/**
 * Class: AddValue
 */

/**
 * Method: new
 */
function AddValue(sensor_id){
	
	if (!sensor_id) throw 'No sensor_id!';
	var data = JSON.parse(localStorage.getItem('data'));
	
	this.sensor = data.hash.sensors[sensor_id];
	this.value_types = this.prepare_value_types(data);
	this.value_types_hash = this.value_types.reduce(function(h,el){h[el.id]=el;return h},{});
	
	this.init({  title:this.sensor.name });
	
}

AddValue.prototype = new Page();

/**
 * Method: my_name
 */
AddValue.prototype.my_name = function(){
	return 'AddValue';
}

AddValue.prototype.before_open=function(){
	var t=this;
	
	lnrr.sensor = this.sensor;
	lnrr.value_types = this.value_types;
	lnrr.last_date = window.localStorage.getItem('last_date');
	
}

/**
 * Method: save_value
 */
AddValue.prototype.save_value=function(value,onsuccess){
	var values = JSON.parse(window.localStorage.getItem('values') || '0') || { sensors:{}};
	
	console.log(value);
	
	if (!values.sensors[this.sensor.id]) values.sensors[this.sensor.id] = {};
	if (!values.sensors[this.sensor.id][value.date_use]) values.sensors[this.sensor.id][value.date_use] = {};
	
	values.sensors[this.sensor.id][value.date_use][value.type] = {
		value: 	value.value,
		text: 	'<i>'+this.value_types_hash[value.type].name + ' (' + value.date_use + ')</i> = ' + value.value +'</br>'
	}
	
	console.log(values);
	
	window.localStorage.setItem('values',JSON.stringify(values));
	this.log('Данные сохранены на устройстве');
	
	if (onsuccess) setTimeout(function(){ onsuccess(); },this.timers.aftersubmit)
	
}

/**
 * Method: submit_next
 */
AddValue.prototype.submit_next=function(tag){
	var t = this;
	var sensor_id = this.sensor.id;
	
	var data = JSON.parse(localStorage.getItem('data'));
	var sensors = data.hash.facilities[this.sensor.facility_id].sensors||[];
	
	for (var i= 0;i<sensors.length;i++) {
		if (sensors[i].id==sensor_id && sensors[i+1]) {
			sensor_id = sensors[i+1].id;
			break;
		}
	}
		
	var func = function(){
		pager.add_object(new AddValue(sensor_id));
	};
	
	this.submit(tag,func);
}

/**
 * Method: submit_continue
 */
AddValue.prototype.submit_continue=function(tag){
	var t = this;
	var func = function(){ t.log(''); };
	this.submit(tag,func);
}

/**
 * Method: submit
 */
AddValue.prototype.submit=function(tag,onsuccess){
	
	if (!onsuccess) onsuccess = function(){ pager.back(); }
	
	var obj=LNMForms.get_object(tag);
	if (!obj) return;
	obj.value = parseFloat(obj.value);
		
	if (!obj.date_use) return this.error('Не указана дата');
	if (!obj.type) return this.error('Не указан тип значения');
	if (!obj.value && obj.value!=0) return this.error('Не указано значение');
	
	obj.sensor_id = this.sensor.id;
	
	window.localStorage.setItem('last_date',obj.date_use);
	
	this.save_value(obj,onsuccess);
}


/**
 * Method: prepare_value_types
 */
AddValue.prototype.prepare_value_types=function(data)
{
	var types = [];
	
	var config = data.hash.AllowedModelType[this.sensor.allowed_model_type_id];
	
	if (config.has_braid) this.sensor.braids.forEach(function(el){
		types.push({
			id:'braid_'+el.id,
			name:'Температура на глубине ' + el.deep + 'м, °C',
		});
	});
	
	var value_types = data.hash.value_types_by_models[this.sensor.allowed_model_type_id] || [];
	console.log(value_types,data.hash.value_types_by_models);
	
	console.log(value_types,this.sensor.allowed_model_type_id);
	
	if (config.has_own_values) value_types.forEach(function(el){
		types.push({
			id:'own_'+el.id,
			name:el.name,
		});
	});
	
	return types;
}
