/**
 * Class: Map
 */

/**
 * Method: new
 */
function Map(facility_id){
	
	var data = JSON.parse(localStorage.getItem('data'));
	
	if (!facility_id) throw 'No facility ID!';
	this.facility = data.hash.facilities[facility_id];
	
	if (!this.facility.image_url) throw 'No facility IMAGE!';
	
	var img = new Image();
	img.onload = function(){
		
	}
	img.src = lnrr.server+facility.image_url;
	console.log(lnrr.server+this.facility.image_url);
	
	var get_pos = function(arr,el,is_facility){
		arr.push({
			id:							el.id,
			top:						el.location_x,
			left:						el.location_y,
			allowed_model_type_code:	el.allowed_model_type_code,
			state_code:					el.state_code,
			type: 						is_facility ? 'facility' : 'sensor'
		});
		return arr;
	}
	
	var get_pos_f = function(arr,el){ return get_pos(arr,el,1); }
	
	this.items = this.facility
		.sensors
		.reduce(get_pos,[]);
		
	this.items = this.facility
		.facilities
		.reduce(get_pos_f,this.items);
	
	this.init({ title: 'Просмотр карты' });
}

Map.prototype = new Page();

/**
 * Method: my_name
 */
Map.prototype.my_name = function(){
	return 'Map';
}

/**
 * Method: before_open
 */
Map.prototype.before_open = function(){
	lnrr.facility = this.facility;
	lnrr.items = this.items;
}



/**
 * Method: after_page_added
 */
Map.prototype.after_page_added = function(){
	this.html.addClass('wide');
}
