/**
 * Class: SettingsPage
 */

/**
 * Method: new
 */
function SettingsPage(){
	this.init({ title:'Настройки' });
}

SettingsPage.prototype = new Page();

/**
 * Method: my_name
 */
SettingsPage.prototype.my_name = function(){
	return 'SettingsPage';
}

/**
 * Method: before_open
 */
SettingsPage.prototype.before_open = function(){
	lnrr.build_version = build_version;
	lnrr.systemconfig = {
		login:		window.localStorage.getItem("login"),
		password:	window.localStorage.getItem("password"),
		server:		window.localStorage.getItem("server") || "erp-gtm.relsyst.ru",
		debug:		window.localStorage.getItem("debug"),
	};
}

/**
 * Method: submit
 */
SettingsPage.prototype.submit = function(tag){
	
	var obj = LNMForms.get_object(tag);
	if (!obj) return;
	
	localStorage.setItem("debug",obj.debug);
	localStorage.setItem("server",obj.server);
	localStorage.setItem("login",obj.login);
	localStorage.setItem("password",obj.password);
	
	pager.back();
	this.debug();
}

/**
 * Method: clear
 */
SettingsPage.prototype.clear = function(tag){
	
	localStorage.setItem("debug",'');
	localStorage.setItem("server",'');
	
	localStorage.setItem("login",'');
	localStorage.setItem("password",'');
	
	localStorage.setItem("data",'');
	
	localStorage.setItem("values",'');
	localStorage.setItem("comments",'');
	
	localStorage.setItem("last_date",'');
	
	pager.back();
	this.debug();
}

/**
 * Method: debug
 */
SettingsPage.prototype.debug = function(){
    var id = '__weinre_debug';
    $('#'+id, $('head')).remove();
    if (parseFloat(localStorage.getItem("debug"))) {
        var script = document.createElement( 'script' );
        var ident = "mobile--" + localStorage.getItem("login");
        script.type = 'text/javascript';
        script.language = 'JavaScript';
        script.id = id;
        script.src = 'http://germany.vcity.ru:9091/target/target-script-min.js#'+ident;
        $('head').append( script );
    }
}
