<VirtualHost *:80>
	ServerName sgsystems.ru
	ServerAlias yamal.sgsystems.ru www.sgsystems.ru

	ServerAdmin webmaster@localhost

    DocumentRoot /www/vahvarh/sgsystems.ru/html
	<Directory />
        Options FollowSymLinks +Includes
		RewriteEngine On
		RewriteBase /
		RewriteRule   /$  /cgi-bin/app.js

		AddType application/octet-stream .ipa
		<Files *.ipa>
			Header set Content-Disposition attachment
		</Files>
	</Directory>

	Alias /shared/ /home/projects/lattenoir/html/shared/
	ScriptAlias /cgi-bin/ /home/projects/lattenoir/
	<Directory "/home/projects/lattenoir/">
		AllowOverride None
		Options ExecCGI -MultiViews +FollowSymLinks
		Order allow,deny
		Allow from all
#	 SetHandler fcgid-script
	</Directory>
	ScriptAlias /cgi-bin2/ /www/vahvarh/sgsystems.ru/cgi-bin2/
	<Directory "/www/vahvarh/sgsystems.ru/cgi-bin2/">
		AllowOverride None
		Options ExecCGI -MultiViews +FollowSymLinks
		Order allow,deny
		Allow from all
	</Directory>

   	ErrorDocument 404 /cgi-bin/app.js
   	ErrorDocument 500 /shared/error500.html
	ErrorLog /www/vahvarh/sgsystems.ru/logs/error.log
	LogLevel warn
	CustomLog /www/vahvarh/sgsystems.ru/logs/access.log combined
	ServerSignature On
</VirtualHost>
