package CSV;

use strict;

sub genline {
	my ($self,$line)=@_;
	my $r="";
	foreach (@$line) {
		$r.=$self->{separator} if $r ne "";
		$r.="\"";
		$_=~s/\"/\\"/g;
		$r.=$_;
		$r.="\"";
	}
	return $r;
}

sub new {
	my ($class)=@_;
	my $self={};
	$self->{lines}=[];
	$self->{cached}="";
	$self->{separator}=",";
	bless ($self,$class);
	return $self;
}

sub parse_line {
	my ($self,$line)=@_;
	my @line;
	my ($tmp,$term);
	chomp $line;
	$line=~s/\r//g;
	$line=~s/=([0-9a-z][0-9a-z])/chr(hex($1))/egi if $self->{convert_eq};
	if ($line=~/=$/) {
		$self->{cached}.=substr($line,0,length($line)-1);
		return;
	} else {
		$line=$self->{cached}.$line;
		$self->{cached}="";
	}
	
	$line=$self->{converter}->convert($line) if $self->{converter};
#	$line.=";";
	@line=();
	my $sep=$self->{separator};
	while ($line ne "") {
		if ($line=~s/^\"//) {
			$tmp="";
			$line=~s/^(.*?)\"//;
			$tmp.=$1;
			while ($line=~s/^\"//) {
				$tmp.="\"";
				$line=~s/^(.*?)\"//;
				$tmp.=$1;
			}
			push(@line,$tmp);
			$line=~s/^$sep//;
		} else {
			$line=~s/^([^$sep]*)//;
			push(@line,$1);
			$line=~s/^$sep//;
		}
	}
	push (@{$self->{lines}},[@line]);
}

sub remove_empty_lines {
	my ($self)=@_;
	my $i=@{$self->{lines}}-1;
	my $flag=1;
	while ($i>=0 && $flag==1) {
		foreach (@{$self->{lines}->[$i]}) {
			$flag=0 unless $_=~/^\s*$/;
		}
		if ($flag) {
			$#{$self->{lines}}=$i-1;
			$i--;
		}
	}
}

sub remove_spaces {
	my ($self)=@_;
	my $line;
	foreach my $line (@{$self->{lines}}) {
		foreach (@$line) {
			s/^\s+//;
			s/\s+$//;
		}
	}
}

sub debug {
	my ($self)=@_;
	foreach (@{$self->{lines}}) {
		warn genline($self,$_)."\n";
	}
};

sub make_html {
	my ($self)=@_;
	my $r="";
	my $count=0;
	my ($line,$i);
	foreach $line (@{$self->{lines}}) {
		for ($i=0;$i!=@$line;$i++) {
			$count=$i+1 if (!($line->[$i]=~/^\s*$/) && $i>=$count);
		}
	}
	$r.="<HTML><BODY>\n";
	$r.="<TABLE border=\"1\">\n";
	foreach $line (@{$self->{lines}}) {
		$r.="<TR>\n";
		for ($i=0;$i!=$count;$i++) {
			$_=$line->[$i];
			$_="" unless defined $_;
			s/\&/&amp;/g;
			s/\</&lt;/g;
			s/\>/&gt;/g;
			$r.="	<TD>$_</TD>\n";
		}
		$r.="</TR>\n";
	}
	$r.="</TABLE>\n";
	$r.="</BODY></HTML>\n";
}

1;

