package MyConfig;

use strict;
use Data::Dumper;
use utf8;
use Encode;
use DirHandle;

###############################################################################
sub new {
	my ($class)=@_;
	my $self={_dirs=>[]};
	bless($self,$class);
#	$self->{_dirs}=[];
#	$self->load_dirs("/");
#	$self->{_dirs}=[reverse @{$self->{_dirs}}];
#	die Dumper $self->load("editor/users");
	return $self;
}

###############################################################################
#sub load_dirs {
#	my ($self,$dir)=@_;
#	my $dh=new DirHandle("config_std$dir");
#	while($_=$dh->read()) {
#		next if /^\./;
#		next unless -d "config_std$dir$_";
#		my $v=$dir.$_;
#		$v=~s/^\///;
#		$v=~s/\//_/g;
#		push(@{$self->{_dirs}},$v."_");
#		$self->load_dirs($dir.$_."/");
#	}
#}

###############################################################################
sub load {
	my ($self,$name)=@_;
	my $filename=$name;
	$name=~s/\//./g;
	return $self->{$filename} if $self->{$filename};
#	foreach (@{$self->{_dirs}}) {
#		if (substr($filename,0,1+length($_)) eq $_."_") {
#			$filename=$_."/".substr($filename,1+length($_));
#		}
#	}
	unless(open IN,"config/".$filename.".cfg") {
		unless(open IN,"config_std2/".$filename.".cfg") {
			unless(open IN,"config_std/".$filename.".cfg") {
				die "No file config(?:|_std|_std2)/$filename.cfg found\n";
			}
		}
	}
	my $line;
	while(defined($line=<IN>)) {
		Encode::_utf8_on($line);
		chomp $line;
		next if $line=~/^\s*$/;
		next if $line=~/^\s*#/;
		if ($line=~/^([\w\.]+)\+\+\s*$/) {
			my $k="$filename.".$1;
			my $s=$self;
			my ($k0,$k1);
			while (length($k)) {
				$k=~s/^([\/\w]+)\.?//;
				$k0=$k1;$k1=$1;
				next unless defined $k0;
				if ($k0 eq "_") {
					$s->[$k0]=($k1=~/^(\d+|_)$/?[]:{}) unless $s->[$k0];
					$s=$s->[@$s-1];
				} elsif ($k0=~/^\d+$/) {
					$s->[$k0]=($k1=~/^(\d+|_)$/?[]:{}) unless $s->[$k0];
					$s=$s->[$k0];
				} else {
					$s->{$k0}=($k1=~/^(\d+|_)$/?[]:{}) unless $s->{$k0};
					$s=$s->{$k0};
				}
			}
			if ($k1 eq "_") {
				$s=$s->[@$s-1];
			} elsif ($k1=~/^\d+$/) {
				$s=$s->[$k1];
			} else {
				$s=$s->{$k1};
			}
			my $i=@$s;

			if (ref $s->[$i-1] eq "ARRAY") {
				push(@$s,[]);
			} else {
				push(@$s,{});
			}
			next;
		}
		next unless $line=~/^([\w\.]+)\s*=\s*(.*)/;
		my ($k,$v)=($filename.".".$1,$2);
		my $s=$self;
		my ($k0,$k1);
		while (length($k)) {
			die "Could not parse \$k='$k' \$k0=$k0, \$k1=$k1\n" unless $k=~s/^([\w\/]+)\.?//;
			$k0=$k1;$k1=$1;
			next unless defined $k0;
			if ($k0 eq "_") {
				my $cnt=@$s;
				$s->[$cnt?$cnt-1:0]=($k1=~/^(\d+|_)$/?[]:{}) unless $s->[$cnt?$cnt-1:0];
				$s=$s->[$cnt?$cnt-1:0];
			} elsif ($k0=~/^\d+$/) {
				$s->[$k0]=($k1=~/^(\d+|_)$/?[]:{}) unless $s->[$k0];
				$s=$s->[$k0];
			} else {
				$s->{$k0}=($k1=~/^(\d+|_)$/?[]:{}) unless $s->{$k0};
				$s=$s->{$k0};
			}
		}
		if ($k1 eq "_") {
			$s->[@$s-1]=$v;
		} elsif ($k1=~/^\d+$/) {
			$s->[$k1]=$v;
		} else {
			$s->{$k1}=$v;
		}
	}
	close IN;
	return $self->{$filename};
}

###############################################################################
sub save {
	my ($self,$filename,$config)=@_;
	my $out;
	open $out,">$filename" or die;
	$self->save_recursive("",$config,$out);
	close $out;
}

###############################################################################
sub save_recursive {
	my ($self,$prefix,$config,$out)=@_;
	if (ref $config eq "ARRAY") {
		my $i=0;
		my $prefix1=$prefix;
		$prefix1=~s/\.$//;
		foreach my $a (@$config) {
			print $out "\n$prefix1++\n" if $i;
			if (ref $a) {
				$self->save_recursive($prefix."_.",$a,$out);
			} else {
				my $r=$prefix."_=$a\n";
				Encode::_utf8_off($r);
				print $out $r;
			}
			$i++;
		}
	} elsif (ref $config eq "HASH") {
		foreach my $k (sort keys %$config) {
			my $v=$config->{$k};
			if (ref $v) {
				$self->save_recursive($prefix."$k.",$v,$out);
			} else {
				my $r=$prefix."$k=$v\n";
				Encode::_utf8_off($r);
				print $out $r;
			}
		}
	} else {
		die;
	}
}

###############################################################################

1;
