package PgWrapperCounter;

use strict;
use utf8;
use Encode;
use PgWrapper;
use Time::HiRes qw (tv_interval gettimeofday);

################################################################################################################
sub new {
	my ($class,$login,$password,$db,$driver)=@_;
	my $self={
		sql=>new PgWrapper($login,$password,$db,$driver),
		counters=>{}
	};
	bless ($self,$class);
	$self->{sql}->{prefix}="sql/";
	return $self;
}

################################################################################################################
sub save_log {
	my ($self)=@_;
	open OUT,">>.logs/sql-".$self->{fetcher_id}.".log";
	foreach my $k (sort { $self->{counters}->{$a} <=> $self->{counters}->{$b} } keys %{$self->{counters}}) {
		print OUT "$k - ".$self->{counters}->{$k}."\n";
	}
	print OUT "\n";
	close OUT;
}

################################################################################################################
sub log {
	my ($self,$name)=@_;
	if ($self->{counters}->{$name}) {
		$self->{counters}->{$name}++;
	} else {
		$self->{counters}->{$name}=1;
	}
}

################################################################################################################
sub DESTROY {my $self=shift @_;$self->{sql}=undef; }
sub commit 									{my $self=shift @_;$self->save_log();$self->{sql}->commit(@_); }
sub set_paths 								{my $self=shift @_;$self->{sql}->set_paths(@_); }
sub last_insert_id							{my $self=shift @_;$self->{sql}->last_insert_id(@_); }
sub read_file								{my $self=shift @_;$self->{sql}->read_file(@_); }
sub rebuild									{my $self=shift @_;$self->{sql}->rebuild(@_); }
sub rebuild_hash							{my $self=shift @_;$self->{sql}->rebuild_hash(@_); }
sub fetch									{my $self=shift @_;$self->{sql}->fetch(@_); }
sub bind									{my $self=shift @_;$self->{sql}->bind(@_); }
sub bind_error								{my $self=shift @_;$self->{sql}->bind_error(@_); }
sub execute									{my $self=shift @_;$self->log(@_);$self->{sql}->execute(@_); }
sub execute_and_fetch						{my $self=shift @_;$self->log(@_);$self->{sql}->execute_and_fetch(@_); }
sub execute_and_fetch_one					{my $self=shift @_;$self->log(@_);$self->{sql}->execute_and_fetch_one(@_); }
sub execute_and_fetch_h						{my $self=shift @_;$self->log(@_);$self->{sql}->execute_and_fetch_h(@_); }
sub execute_and_fetch_h_real				{my $self=shift @_;$self->log(@_);$self->{sql}->execute_and_fetch_h_real(@_); }
sub execute_and_fetch_rev_h					{my $self=shift @_;$self->log(@_);$self->{sql}->execute_and_fetch_rev_h(@_); }
sub execute_bind							{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind(@_); }
sub execute_bind_and_fetch					{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch(@_); }
sub execute_bind_and_fetch_one				{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch_one(@_); }
sub execute_bind_and_fetch_single			{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch_single(@_); }
sub execute_bind_and_fetch_h				{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch_h(@_); }
sub execute_bind_and_fetch_tree				{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch_tree(@_); }
sub execute_bind_and_fetch_single_recurse	{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_and_fetch_single_recurse(@_); }
sub execute_bind_single 					{my $self=shift @_;$self->log(@_);$self->{sql}->execute_bind_single(@_); }

################################################################################################################

1;

