#!/usr/bin/perl
BEGIN {
	$ENV{NLS_LANG}="AMERICAN_AMERICA.UTF8";
	$ENV{NLS_DATE_FORMAT}="YYYY/MM/DD hh24:mi:ss";
}

use strict;
use DBI;
use Encode;

my $FKs;

sub Oracle_tables {
	my ($dbh,$login)=@_;
	my @arr;
	my $sth=$dbh->prepare("SELECT table_name FROM sys.all_tables WHERE owner=?") or die "Can not prepare!";
	my $h;
	$sth->execute(uc $login) or die "Can not execute!";
	push(@arr,$_->[0]) while ($_=$sth->fetchrow_arrayref());
	$sth=$dbh->prepare("
select
	c1.table_name,
	c2.table_name as r_table_name
from
	sys.all_constraints c1,
	sys.all_constraints c2
where
	c1.owner=? and
	c2.owner=? and
	c1.r_constraint_name=c2.constraint_name
	");
	$sth->execute(uc $login,uc $login) or die "Can not execute (2)!";
	while ($_=$sth->fetchrow_hashref()) {
		$FKs->{$_->{TABLE_NAME}}->{$_->{R_TABLE_NAME}}=1;
	}
	return @arr;
}
sub Oracle_sequences {
	my ($dbh,$login,$table,$maxid)=@_;
	my $sname=$table;
	my $r;
	$sname=~s/^T/S/;
	my $sth=$dbh->prepare("
SELECT
	SEQUENCE_NAME,LAST_NUMBER
FROM
	sys.all_sequences
where
	sequence_owner=? and
	sequence_name=?
");
	my $h;
	$sth->execute(uc $login,uc $sname);
	if ($h=$sth->fetchrow_hashref()) {
		$r="";
		$r.="#>DROP SEQUENCE $sname\n";
		my $n=$h->{LAST_NUMBER}+1;
		if (defined $maxid && $maxid>=$n) {
			$n=$maxid+1;
		}
		$r.="#>CREATE SEQUENCE $sname START WITH $n\n";
	}
	return $r;
}

sub pg_tables {
	my ($dbh)=@_;
	my $sth=$dbh->prepare();
}

sub mysql_tables {
	my ($dbh)=@_;
	my $sth=$dbh->prepare("show tables;");
	$sth->execute();
	my @arr;
	while ($_=$sth->fetchrow_arrayref()) {
		push(@arr,$_->[0]);
	}
	$FKs={};
	return @arr;
}

sub mysql_sequences {
	return "";
}

sub pg_sequences {
	return "";
}

sub has_no_fk {
	my ($table,$tables)=@_;
	my $flag=1;
	foreach (@$tables) {
		next if $table eq $_;
		$flag=0 if $FKs->{$table}->{$_};
	}
	return $flag;
}

sub ensort {
	my @src=@_;
	my @r;
	my $i;
	while (@src) {
		$i=0;
		while ($i<@src) {
			if (has_no_fk($src[$i],\@src)) {
#				warn ">> ".$src[$i]."\n";
				push(@r,$src[$i]);
				splice(@src,$i,1);
			} else {
				$i++;
			}
		}
#		warn "Tables left: ".join(",",@src)."\n";
	}
	return @r;
}

{
	if ($#ARGV!=2 && $#ARGV!=3) {
		die "Usage:\n$0 Driver login/password\@database filename.csv [tablelist.file]\n";
	}
	my ($driver,$conn,$file,$tablelist)=@ARGV;
	my ($login,$password,$db);
	($login,$password,$db)=($conn=~/^(.+?)\/(.+?)\@(.+)$/) or die "Can not parse conn string ($conn)\n";
	my $dbh;
	warn "Connection to $db\n";
	if ($driver ne "Pg") {
		$dbh=DBI->connect("dbi:$driver:$db",$login,$password,{RaiseError=>1,AutoCommit=>0});
	} else {
		$dbh=DBI->connect("dbi:Pg:dbname=$db;host=127.0.0.1",$login,$password, {AutoCommit => 0});
	}
	$dbh->{LongTruncOk}=1;
	$dbh->{LongReadLen}=262144;
	my @tables;
	my $h_tables={
		Oracle=>\&Oracle_tables,
		mysql=>\&mysql_tables,
		Pg=>\&pg_tables
	};
	my $h_sequences={
		Oracle=>\&Oracle_sequences,
		mysql=>\&mysql_sequences,
		Pg=>\&pg_sequences
	};
	warn "Loading table list\n";
	@tables=$h_tables->{$driver}->($dbh,$login);
	if ($tablelist) {
		my $minus=0;
		$minus=1 if $tablelist=~s/^[-!]//;
		warn "Using only specificed tables\n" unless $minus;
		warn "Using all but specificed tables\n" if $minus;
		my %used;
		open IN,$tablelist;
		while (<IN>) {
			chomp;
			s/\s+//g;
			$used{lc $_}=1 if $_ ne "";
		}
		close IN;
		my @tmp=@tables;
		@tables=();
		foreach (@tmp) {
			if ($minus) {
				push(@tables,$_) unless $used{lc $_};
			} else {
				push(@tables,$_) if $used{lc $_};
			}
		}
	}
	warn "This tables will be exported ".join(",",@tables)."\n";
	@tables=ensort(@tables);
	warn "Creating csv file\n";
	open OUT,">".$file;
	print OUT "#Dropping any data\n";
	foreach (reverse @tables) {
		print OUT "#>DELETE FROM $_\n";
	}
	print OUT "\n";
	print OUT "#Starting to fill in\n";
	my $sth;
	my $i;
	my $h;
	my $f;
	my $newfile=$file;
	$newfile=~s/^(.+)\.csv/$1\/0000.csv_part/;
	mkdir ($1,0755) unless -d $1;
	my @names;
	my $skipper="^[^\'\"";
	foreach (0..31) {
		$skipper.=sprintf("\\x%02x",$_);
	}
	$skipper.="]*\$";
#	die "$skipper\n";
	foreach (@tables) {
		warn "Table $_\n";
		$sth=$dbh->prepare("SELECT * FROM $_");
		$sth->{LongTruncOk}=1;
		$sth->{LongReadLen}=65535;
		$sth->execute();
		@names=@{$sth->{NAME}};
		$f=0;
		my ($idptr,$maxid);
		for (my $j=0;$j!=@names;$j++) {$idptr=$j if $names[$j] eq "ID";}
		while ($h=$sth->fetchrow_arrayref()) {
			print OUT "\n#!INSERT INTO $_ (".join(",",@names).") values (?".(",?"x((@names) -1)).")\n" if $f==0;
			if (defined $idptr) {
				if (!defined $maxid || $maxid<$h->[$idptr]) {
					$maxid=$h->[$idptr];
				}
			}
			$i=0;
			foreach (@$h) {
				Encode::_utf8_off($_);
				if ($i) {
					print OUT ",";
				}
				if ($_=~/$skipper/) {
					if ($_=~/^\w+$/) {
						print OUT "$_";
					} else {
						print OUT "'$_'";
					}
				} else {
					print OUT "\@$newfile";
					open OUT2,">".$newfile;
					print OUT2 $_;
					close OUT2;
					$newfile=~/^(.+\/)(\d+)(\.csv_part)$/;
					$newfile=$1.sprintf("%04d",$2+1).$3;
				}
				$i++;
			}
			print OUT "\n";
			$f++;
		}
		print OUT $h_sequences->{$driver}->($dbh,$login,$_,$maxid);
	}
	close OUT;
	$dbh->disconnect();
}
