#!/usr/bin/perl -w

BEGIN {
	push(@INC,"/home/modules/");
};

use strict;
use utf8;
use Encode;
use IO::Socket::INET;
use IO::Socket::UNIX;
use IO::Select;
use PgWrapper;
use Time::HiRes qw(gettimeofday tv_interval);

my $server;
my $select;
my $clients={};
my $sql;

binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

$SIG{INT}=\&my_die;
$SIG{__DIE__}=\&my_die;
$SIG{__WARN__}=\&my_warn;

################################################################################################################
sub my_warn {
	my @date=localtime();
	$#date=5;
	$date[5]+=1900;
	$date[4]++;
	my $date=sprintf("%04d-%02d-%02d %02d:%02d:%02d",reverse @date);
	my $tmp=$date." - ".$_[0];
	$tmp.="\n" unless $_[0]=~/\n$/;
	print STDERR $tmp;
}

################################################################################################################
sub close_all {
	if ($select) {
		foreach my $h ($select->handles()) {
			$select->remove($h);
		}
		$select=undef;
	}
	foreach my $k (keys %$clients) {
		$clients->{$k}->close();
		delete $clients->{$k};
	}
	if ($server) {
		$server->close();
		$server=undef;
	}
}

################################################################################################################
sub my_die {
	my_warn(@_);
	close_all();
	exit(1);
}

################################################################################################################

{
	die "Usage:\n$0 login password database driver wrapper-host wrapper-port\n$0 login password database driver unix-socket-path" unless @ARGV==6 || @ARGV==5;
	my ($login,$password,$database,$driver,$host,$port)=@ARGV;
	$sql=new PgWrapper($login,$password,$database,$driver);
	$sql->{prefix}="sql/";
	$sql->{dbh}->{AutoCommit}=1;
	if ($port) {
		$server=new IO::Socket::INET(Proto=>"tcp",LocalAddr=>$host,LocalPort=>$port,Listen=>20) or die "Can not create sql proxy server - $!";
	} else {
		unlink($host);
		$server=new IO::Socket::UNIX(Local=>$host,Listen=>20) or die "Can not create sql proxy server - $!";
	}
	$select=new IO::Select();
	$select->add($server);
	while (1) {
		foreach my $sock ($select->can_read()) {
			if ($sock eq $server) {
				$sock=$sock->accept();
				$select->add($sock);
				warn "Client connected\n";
				my $clt=$clients->{$sock}=new PgWrapperProxyS($sock,$sql);
			} else {
				my $tmp;
				$sock->recv($tmp,1500);
				if (length $tmp) {
					$clients->{$sock}->work($tmp);
				} else {
					$select->remove($sock);
					$clients->{$sock}->close();
					delete $clients->{$sock};
				}
			}
		}
	}
}

################################################################################################################
package PgWrapperProxyS;

use strict;
use utf8;
use Encode;
use Storable qw(freeze thaw);
use Data::Dumper;

################################################################################################################
sub new {
	my ($class,$sock,$sql)=@_;
	my $self={
		sock=>$sock,
		sql=>$sql,
		data=>"",
		len=>0,
		skip=>0,
		method=>""
	};
	bless($self,$class);
	return $self;
}

################################################################################################################
sub close {
	my ($self)=@_;
	$self->{sock}->close();
}

################################################################################################################
sub work {
	my ($self,$tmp)=@_;
	$self->{data}.=$tmp;
	while ($self->work_iter()) {}

}

################################################################################################################
sub work_iter {
	my ($self)=@_;
#	my $r="";
#	my $len;
#	my $skip=0;
#	my $method;
	unless ($self->{skip}) {
		if ($self->{data}=~/^(\w+) (\d+) /) {
			$self->{method}=$1;
			$self->{len}=$2;
			$self->{skip}=length($self->{method})+1+length($self->{len})+1;
			return 1;
		}
		return 0;
	}
	return 0 if length($self->{data})<$self->{len}+$self->{skip};
	my $method=$self->{method};
	my $packed=substr($self->{data},$self->{skip},$self->{len});
	my $dl=length($self->{data});
	$self->{data}=substr($self->{data},$self->{skip}+$self->{len},length($self->{data})-$self->{skip}-$self->{len});
#	warn "method $method, skip=".$self->{skip}.", length=".$self->{len}.", old data length=$dl, new data length=".length($self->{data})."\n";
	my $args=thaw($packed);
	warn "method $method\n";
#	warn "method $method - ".Dumper($args)."\n";
	my @ret=$self->{sql}->$method(@$args);
	my $i;
	for ($i=0;$i<@ret;$i++) {
		my $ref=ref $ret[$i];
		next unless $ref;
		next if $ref eq "ARRAY";
		next if $ref eq "HASH";
		$ret[$i]=undef;
	}
#	return @$ret;
	my $pack=freeze(\@ret);
	$self->{sock}->send("OK ".length($pack)." ");
	$self->{sock}->send($pack);
	$self->{skip}=0;
	return 1;
}

################################################################################################################

1;


