var fs=require("fs");

function load_config(rr)
{
	var configname=rr.site.paths.database+"/market_config.js";
	var config;
	if ((new fs.File(configname)).exists()) {
		config=require(configname).config;
	} else {
		config={};
	}
	if (!config.export_config) config.export_config={};
	if (!config.import_config) config.import_config={};
	return config;
}

function save_config(rr,config)
{
	var configname=rr.site.paths.database+"/market_config.js";
	var f=new fs.File(configname);
	var flag;
	var s="exports.config="+JSON.stringify(config);
	if (!f.exists()) {
		flag=true;
	} else {
		f.open("r");
		if (s!=f.read().toString("utf-8")) flag=true;
		f.close();
	}
	if (!flag) return;
	f.open("w");
	f.write(s);
	f.close();
}


exports.add=[
{
	_type:"controller",
	_config_details: {	
	},
	_config: {
		path:"adminpanel/",
		name:"AdminMarket",
		admin:1,
		role_code:"market"
	},
	
	_admin_nav: [
		{section:"modules",name:"Market",mode:"index"}
	],

	/**
	 * Controller: AdminMarket.index
	 *		Generates a simple page to choose what subsection to edit (items or categories or groups or whatever)
	 *
	 * Returns:
	 *		typeof HTML		-  html part
	 */
	index: function(config) {
		var t=this;
		this.market_categories=this.site.models.MarketCategory.ListHier();
		this.market_categories.forEach(function(cat) {
			cat.cnt=t.site.models.MarketItem.Count("count_of_category",{category_id:cat.id});
		});
		this.cart_states=this.site.models.CartState.List();
		this.cart_states.forEach(function(cs) {
			cs.cnt=t.site.models.Cart.Count("count_of_state",{state_id:cs.id});
		});
		return this.Cview();
	},

	/**
	 * Controller: AdminMarket.cart_state_set
	 */
	cart_state_set: function() {
		this.cart=this.site.models.Cart.Get(this.fields.cart_id);
		this.cart.state_id=this.fields.state_id;
		this.cart.SaveAll();
		return JSON.stringify({refresh:1});
	},
	/**
	 * Controller: AdminMarket.resend_email
	 */
	resend_email: function(config) {
		this.cart=this.site.models.Cart.Get(this.fields.cart_id);
		this.cart.user=this.site.models.User.Get(this.cart.user_id);
		this.cart.FetchItemsFull();
		var side = 'manager';
		var params = {};
		if (this.fields.user_id) {
			var user = this.site.models.User.Get(this.fields.user_id);
			var email = user.login;
			if (!email || !email.match(/@/)) email = user.email;
			side = 'user';
			params.to = [email];
		}
		this.F("Functions","send_mail",this.F("Cart","mail_template_code","fast_cart_checkout",side),params,0);	
		return JSON.stringify({error:"Сообщение отправлено"});//this.Cview();
	},

	/**
	 * Controller: AdminMarket.searchitems
	 *		Shows a result of search of market items of inside admin panel.
	 *		Search is done via name, code and fid.
	 *
	 * Returns:
	 *		typeof HTML		-  html part
	 */
	searchitems: function(config) {
		this.market_items=this.site.models.MarketItem.List("list_for_admin_search",this.fields);
		return this.Cview();
	},

	/**
	 * Controller: AdminMarket.fields
	 *		Shows a list of available groups of item parameters and allows editing them.
	 *		Generally, groups are like (for cell phones) 'general', 'physical'
	 *		And parameters are 'general -> phone type', 'general -> has qwerty', 'general -> has camera', 'physical -> width', 'physical -> height', 'physical -> weight'
	 *
	 * Returns:
	 *		typeof HTML		-  html part
	 */
	fields: function(config) {
		var t=this;
		this.market_categories=this.site.models.MarketCategory.ListHier();
		this.market_categories.forEach(function(cat) {
			cat.groups=t.site.models.MarketFieldGroup.List("list_of_category",{category_id:cat.id});
		});
		this.public_groups=t.site.models.MarketFieldGroup.List("list_of_empty_category");
		return this.Cview();
	},

	/**
	 * Controller: AdminMarket.rewrites
	 *		Automatically writes rewrites to Trewrites table.
	 *		Searches for pages with url '/market/' and makes rewrites to it.
	 *		typical are:
	 *			/market/
	 *			/market/category/[category name]/
	 *			/market/manufacturers/
	 *			/market/manufacturer/[manufacturer name]/
	 *			/market/category/[category name]/[item name]/ 
	 *
	 * Returns:
	 *		typeof HTML		-	"everything is OK" text
	 */
	rewrites: function(config) {
		var p=this.site.models.Page.List("get_by_alias",{alias:"/market/"});
		if (p.length==0) throw "No /market/ page!";
		var page_id=p[0].id;
		var rws=[
			{regexp:"^/market/?$"									,fields:""							,page_id:page_id,controller_mode:"root_categories"	,signature:"Market::root_categories"},
			{regexp:"^/market/category/([\\w\\-]+)/?$"				,fields:"category_code"				,page_id:page_id,controller_mode:"category"			,signature:"Market::category"},
			{regexp:"^/market/manufacturers/?$"						,fields:""							,page_id:page_id,controller_mode:"manufacturers"	,signature:"Market::manufacturers"},
			{regexp:"^/market/manufacturer/([\\w\\-]+)/?$"			,fields:"manufacturer_code"			,page_id:page_id,controller_mode:"manufacturer"		,signature:"Market::manufacturer"},
			{regexp:"^/market/category/([\\w\\-]+)/([\\w\\-]+)/?"	,fields:"category_code,item_code"	,page_id:page_id,controller_mode:"item"				,signature:"Market::item"}//,
//			{regexp:"",fields:"",page_id:page_id,controller_mode:"",signature:""}
		];
		this.cnt=this.F("Admin","rewrites_add",rws);
		return this.Cview();
	},

	/**
	 * Controller: AdminMarket.mail_templates
	 *		Automatically writes mail templates
	 *		1. mail sent to user
	 *		2. mail sent to manager
	 *	
	 * Returns:
	 *		typeof HTML		- "everything is OK" text
	 */
	mail_templates: function(config) {
		var mts=[
			{
				signature:"Cart::cart_user_send",
				code:"cart_user_send",
				name:this.F("Views","L","controllers/Cart/mail","An email sent to user",1),
				default_from:"robot@"+this.site.names[0],
				default_to:"",
				"1__subject":this.F("Files","get_src_view_file","controllers/adminpanel/AdminMarket/cart_mail/user_subject"),
				"1__body":this.F("Files","get_src_view_file","controllers/adminpanel/AdminMarket/cart_mail/user_body")
			},
			{
				signature:"Cart::cart_manager_send",
				code:"cart_manager_send",
				name:this.F("Views","L","controllers/Cart/mail","An email sent to manager",1),
				default_from:"robot@"+this.site.names[0],
				default_to:"",
				"1__subject":this.F("Files","get_src_view_file","controllers/adminpanel/AdminMarket/cart_mail/manager_subject"),
				"1__body":this.F("Files","get_src_view_file","controllers/adminpanel/AdminMarket/cart_mail/manager_body")
			}
		];
		this.cnt=this.F("Admin","mail_templates_add",mts);
		return this.Cview();
	},

	/**
	 * Controllers: AdminMarket.fields_recalc
	 *		Special "hack" controller. rebuilds calculated fields cache.
	 *
	 */
	fields_recalc: function(config) {
		var l10ns=[];
		var view_levels=[];
		this.site.models.MarketViewLevel.List().forEach(function(a) {if (a.code=='no') return;view_levels.push(a.id);});
		this.site.models.L10N.List().forEach(function(a) {l10ns.push(a.id);});
		var arr=this.site.sql.execute_and_fetch_single("select id from Tmarket_items");
		this.count=arr.length;
		for (var i=0;i<arr.length;i++) {
			if (this.fields.id && this.fields.id!=arr[i].id) continue;
			var item=this.site.models.MarketItem.Get(arr[i].id);
			item.CalcAllFields(view_levels,l10ns);
			if (this.fields.id) return this.Cview();
		}
		return this.Cview();
	},

	field_enums: function() {
		var t=this;
		this.groups=t.site.models.MarketFieldGroup.List();
		this.groups.forEach(function(grp) {
			grp.fields=t.site.models.MarketField.List("list_of_group",{group_id:grp.id}).filter(function(f) { return (f.datatype_code=="enum")?1:0; });
		});
		return this.Cview();
	},

	field_enums_table: function() {
		var t=this;
		this.field=this.site.models.MarketField.Get(this.fields.field_id);
		this.values=this.site.models.MarketFieldEnum.List("list_of_field",{field_id:this.field.id});
		return this.Cview();
	},

	field_enums_table_save: function() {
		var values=[];
		var field=this.site.models.MarketField.Get(this.fields.field_id);
		var grp=this.site.models.MarketFieldGroup.Get(field.group_id);
		var colname=(grp.category_id?"fldcat":"fldany")+field.cid;
		for (var k in this.fields) {
			var arr=k.match(/^val_(\d+)$/);
			if (!arr) continue;
			var h={id:arr[1],value:this.fields[k].trim()};
			if (h.value=="") {
				this.site.sql.execute_single("update Tmarket_item_fields_i set "+colname+"=:newid where "+colname+"=:oldid",{newid:null,oldid:h.id});
				this.site.sql.execute("market_field_enums/delete",{id:h.id});
			} else {
				values.push(h);
				this.site.sql.execute("market_field_enums/set_value",{value:h.value+"-tmpvalue-"+h.id,id:h.id});
			}
		}
		var used={};
		for (var i=0;i<values.length;i++) {
			var h=values[i];
			if (used[h.value.toLowerCase()]) {
				this.site.sql.execute_single("update Tmarket_item_fields_i set "+colname+"=:newid where "+colname+"=:oldid",{newid:used[h.value.toLowerCase()],oldid:h.id});
				this.site.sql.execute("market_field_enums/delete",{id:h.id});
			} else {
				this.site.sql.execute("market_field_enums/set_value",{value:h.value,id:h.id});
				used[h.value.toLowerCase()]=h.id;
			}
		}
		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: AdminMarket.import1
	 */
	import1: function(config) {
		impexp1(this,"import");
		return this.Cview();
	},

	/**
	 * Controller: AdminMarket.export1
	 */
	export1: function(config) {
		impexp1(this,"export");
		return this.Cview();
	},

	/**
	 * controller: adminmarket.import2
	 */
	import2: function(config) {
		var t=this;
		var config=load_config(this);
		config.import_config={};
		for (var k in this.fields) {
			var a=k.match(/item_(.*)/);
			if (a) config.import_config[a[1]]=this.fields[k];
		}
		save_config(this,config);

		this.spreadsheet=this.site.models.Spreadsheet.Get(this.fields.spreadsheet_id);
		this.worksheets=this.site.models.Worksheet.List("list_of_spreadsheet",{spreadsheet_id:this.spreadsheet.id});

		var table=this.F("Spreadsheets","get_table",this.worksheets[this.fields.worksheet_no||0].id);

		var cnt_l10n=this.site.models.L10N.Count();
		var cnt_not_l10n=this.site.models.MarketItem._config.field_names.length;
		var fns=this.site.models.MarketItem._config.field_names.concat(this.site.models.MarketItem._config.field_names_l10n);
		var fds=this.site.models.MarketItem._config.field_datatypes.concat(this.site.models.MarketItem._config.field_datatypes_l10n);
		var rules=[];
		var l10ns=[];
		var x,y;
		this.site.models.L10N.List().forEach(function(a) { l10ns.push(a.id); });

		var maxcategories=1;
		var all_categories={};
		var catpaths={};
		function market_categories_hier(parent_id,array)
		{
			t.site.models.MarketCategory.List("list_level",{parent_id:parent_id}).forEach(function(cat) {
				all_categories[cat.id]=cat;
				cat.level=array.length+1;
				if (cat.level>maxcategories) maxcategories=cat.level;
				cat.levels=array.concat([cat.name]);
				catpaths[cat.levels.join("-||-")]=cat.id;
				market_categories_hier(cat.id,cat.levels);
//				throw {cat:cat,levels:cat.levels};
			});
		}
		market_categories_hier(null,[]);

		/**
		 * Prepare input
		 */
		for (var i=0;i<fns.length;i++) {
			var fn=fns[i];
			var fd=fds[i];

			var is_l10n=i>=cnt_not_l10n;
			switch (fd) {
				case "":
				case "file":
				case "file_folder":
					continue;
			}
			if (fn.match(/^calc/)) continue;
			switch (fn) {
				case "ordering":
				case "date_cr":
				case "date_mo":
				case "user_cr_id":
					break;
				case "category_id":
					switch (config.import_config[fn]) {
						case "none":
							continue;
						case "tree":
							rules.push({type:"category_id",value:config.import_config[fn],rows:maxcategories});
							x+=maxcategories;
							break;
						case "fid":
							rules.push({type:"category_id",value:config.import_config[fn]});
							x++;
							break;
					}
					break;
				case "manufacturer_id":
					if (config.import_config[fn]=="none") continue;
					rules.push({type:"manufacturer_id",value:config.import_config[fn]});
					x++;
					break;
				default:
					if (config.import_config[fn]=="0") continue;
					if (is_l10n) {
						if (config.import_config[fn]=="2") {
							for (var j=0;j<l10ns.length;j++) {
								rules.push({type:"value_l10n",value:fn,l10n_id:l10ns[j]});
								x++;
							}
						} else {
							rules.push({type:"value_l10n",value:fn,l10n_id:this.site.default_l10n_id});
							x++;
						}
					} else {
						rules.push({type:"value",value:fn});
						x++;
					}
					break;
			}
		}
	


		function parse_fid(model,y,x,fallback)
		{
			if (table[y][x]=="") return fallback;
			var a=t.site.models[model].List("get_by_fid",{fid:table[y][x]});
			if (a.length==0) throw new Error("TODO");
			if (a.length>1) throw new Error("Should not happen");
			return a[0].id;
		}
	
		function parse_name(model,y,x,fallback)
		{
			if (table[y][x]=="") return fallback;
			var a=t.site.models[model].List("get_by_name",{name:table[y][x]});
			if (a.length==0) throw new Error("TODO at x="+x+", y="+y+" (value='"+table[y][x]+"')");
			if (a.length>1) throw new Error("Should not happen");
			return a[0].id;
		}

		function parse_category_tree(y,x,size,fallback)
		{
			var flag=false;
			var arr=[];
			var min=-1;
			for (var i=0;i<size;i++) if (table[y][x+i]!="") {arr[i]=table[y][x+i];flag=true;if (min==-1) min=i;}
			if (!flag) return fallback;
			if (ccategory) for (var i=0;i<ccategory.levels.length;i++) if (!arr[i] && i<min) arr[i]=ccategory.levels[i];
			var path=arr.join("-||-");
			if (catpaths[path]) {
				ccategory=all_categories[catpaths[path]];
				return ccategory.id;
			}
			var paths="";
			for (var k in catpaths) paths+=k+"\n";
			throw new Error("TODO - (x="+x+", y="+y+") category path not found "+path+"\n\nsearched in category paths:\n"+paths);
		}

		y=2; // TODO

		/**
		 * Import
		 */
		var notnulls={in_stock:1,is_new:0,is_recomended:0,is_featured:0};
		var category_id;
		var manufacturer_id;
		var ccategory;

		if (config.import_config.category_id=="none") category_id=this.site.models.MarketCategory.List()[0].id;
		if (config.import_config.manufacturer_id=="none") manufacturer_id=this.site.models.MarketManufacturer.List()[0].id;
		while (y<table.length) {
			var flag=false;
			for (var i=0;i<table[y].length;i++) if (table[y][i]!=="") flag=true;
			if (!flag) {y++;continue;}
			var iteminfo={l10ns:{},enabled:1,category_id:category_id,manufacturer_id:manufacturer_id};
			var x=0;
			
			for (var j=0;j<rules.length;j++) {
				var rule=rules[j];
				switch (rule.type) {
					case "category_id":
						switch (rule.value) {
							case "fid":
								iteminfo.category_id=category_id=parse_fid("MarketCategory",y,x,category_id);
								break;
							case "tree":
								iteminfo.category_id=category_id=parse_category_tree(y,x,rule.rows,category_id);
								break;
						}
						break;
					case "manufacturer_id":
						switch (rule.value) {
							case "fid":
								iteminfo.manufacturer_id=manufacturer_id=parse_fid("MarketManufacturer",y,x,manufacturer_id);
								break;
							case "names":
								iteminfo.manufacturer_id=manufacturer_id=parse_name("MarketManufacturer",y,x,manufacturer_id);
								break;
						}
						break;
					case "value":
						iteminfo[rule.value]=table[y][x];
						break;
					case "value_l10n":
						if (!iteminfo.l10ns[rule.l10n_id]) iteminfo.l10ns[rule.l10n_id]={};
						iteminfo.l10ns[rule.l10n_id][rule.value]=table[y][x];
						break;
					default:
						throw new Error("Unknown rule type="+rule.type);
				}
				x+=rule.rows||1;
			}
			var item;
			iteminfo.name=iteminfo.l10ns[this.site.default_l10n_id].name;
			if (iteminfo.code) {
				//throw "TEMP";
				item=t.site.models.MarketItem.Get("get_by_code",{code:iteminfo.code});
				if (item) {
					if (item.manufacturer_id!=iteminfo.manufacturer_id) throw "import2() - getting by item.code, manufacturers differ, item.code='"+iteminfo.code+"'!";
					if (item.category_id!=iteminfo.category_id) throw "import2() - getting by item.code, categories differ, was="+item.category_id+", new="+iteminfo.category_id+", item.code='"+iteminfo.code+"'!";
				}				
			} else if (iteminfo.name) {
				item=t.site.models.MarketItem.Get("get_by_name_and_category_and_manufacturer",{manufacturer_id:iteminfo.manufacturer_id,category_id:iteminfo.category_id,name:iteminfo.name});
			} else {
				throw "Line y="+y+", no iteminfo.name!";
			}
			if (item) {
//				throw {item:item,iteminfo:iteminfo,search:{manufacturer_id:iteminfo.manufacturer_id,category_id:iteminfo.category_id,name:iteminfo.name}};
				item.FetchLocales();
				item.Apply(iteminfo);
				item.SaveAll();
			} else {
				for (var k in notnulls) if (!(k in iteminfo)) iteminfo[k]=notnulls[k];
				item=t.site.models.MarketItem.Create();
				item.FetchLocales();
				item.Apply(iteminfo);
				item.SaveAll();
			}
			y++;
		}
		
		return JSON.stringify({redirect:{url:"/admin-AdminMarket-imported/"}});
	},

	/**
	 * controller: adminmarket.export2
	 */
	export2: function(config) {
		var config=load_config(this);
		config.export_config={};
		for (var k in this.fields) {
			var a=k.match(/item_(.*)/);
			if (a) config.export_config[a[1]]=this.fields[k];
		}
		save_config(this,config);
		return JSON.stringify({redirect:{url:"/admin-AdminMarket-export3/"}});
	},

	/**
	 * Controller: AdminMarket.export3
	 */
	export3: function(config) {
		var t=this;
		var config=load_config(this);
		var ss=this.site.models.Spreadsheet.Create({generator:"AdminMarket-export",name:"Market price list export"});
		var ws=ss.AddWorksheet();

		var all_manufacturers={};
		var all_categories={};

		var maxcategories=1;
		function market_categories_hier(parent_id,array)
		{
			t.site.models.MarketCategory.List("list_level",{parent_id:parent_id}).forEach(function(cat) {
				all_categories[cat.id]=cat;
				cat.level=array.length+1;
				if (cat.level>maxcategories) maxcategories=cat.level;
				cat.levels=array.concat([cat.name]);
				market_categories_hier(cat.id,cat.levels);
//				throw {cat:cat,levels:cat.levels};
			});
		}
		market_categories_hier(null,[]);

		this.maxcategories=maxcategories;
		this.site.models.MarketManufacturer.List().forEach(function(m) {
			all_manufacturers[m.id]=m;
		});

		var items=this.site.sql.execute_and_fetch_single("select id from Tmarket_items order by category_id,manufacturer_id");
		var x=0;
		var y=0;
	
		var rules=[];
		var cnt_l10n=this.site.models.L10N.Count();
		var cnt_not_l10n=this.site.models.MarketItem._config.field_names.length;
		var fns=this.site.models.MarketItem._config.field_names.concat(this.site.models.MarketItem._config.field_names_l10n);
		var fds=this.site.models.MarketItem._config.field_datatypes.concat(this.site.models.MarketItem._config.field_datatypes_l10n);

		var cell_pusher=this.F("Spreadsheets","get_cell_pusher",ws);
		var l10ns=[];
		this.site.models.L10N.List().forEach(function(a) { l10ns.push(a.id); });


		/**
		 * Prepare output
		 */
		for (var i=0;i<fns.length;i++) {
			var fn=fns[i];
			var fd=fds[i];
			var is_l10n=i>=cnt_not_l10n;
			switch (fd) {
				case "":
				case "file":
				case "file_folder":
					continue;
			}
			if (fn.match(/^calc/)) continue;
			switch (fn) {
				case "ordering":
				case "date_cr":
				case "date_mo":
				case "user_cr_id":
					break;
				case "category_id":
					switch (config.export_config[fn]) {
						case "none":
							continue;
						case "tree":
							for (var jj=0;jj<maxcategories;jj++) {
								rules.push({type:"category_id",value:config.export_config[fn],level:jj});
								cell_pusher(x,y,fn+"-level"+jj);
								cell_pusher(x,y+1,"[descr]");
								x++;
							}
							break;
						case "fid":
							rules.push({type:"category_id",value:config.export_config[fn]});
							cell_pusher(x,y,fn+"-"+config.export_config[fn]);
							cell_pusher(x,y+1,"[descr]");
							x++;
							break;
					}
					break;
				case "manufacturer_id":
					if (config.export_config[fn]=="none") continue;
					rules.push({type:"manufacturer_id",value:config.export_config[fn]});
					cell_pusher(x,y,fn+"-"+config.export_config[fn]);
					cell_pusher(x,y+1,"[descr]");
					x++;
					break;
				default:
					if (config.export_config[fn]=="0") continue;
					if (is_l10n) {
						if (config.export_config[fn]=="2") {
							for (var j=0;j<l10ns.length;j++) {
								rules.push({type:"value_l10n",value:fn,l10n_id:l10ns[j]});
								cell_pusher(x,y,fn+"-l10n"+l10ns[j]);
								cell_pusher(x,y+1,"[descr]");
								x++;
							}
						} else {
							rules.push({type:"value_l10n",value:fn,l10n_id:this.site.default_l10n_id});
							cell_pusher(x,y,fn+"-l10n"+this.site.default_l10n_id);
							cell_pusher(x,y+1,"[descr]");
							x++;
						}
					} else {
						rules.push({type:"value",value:fn});
						cell_pusher(x,y,fn);
						cell_pusher(x,y+1,"[descr]");
						x++;
					}
					break;
			}
		}	
		y+=2;
		
		/**
		 * Output from database
		 */
		var prev_category_id=0;
		var prev_manufacturer_id=0;

		for (var i=0,s=items.length;i<s;i++) {
			var item=this.site.models.MarketItem.Get(items[i].id);
			item.FetchLocales();
			for (var j=0;j<rules.length;j++) {
				switch (rules[j].type) {
					case "category_id":
						if (prev_category_id==item.category_id) break;
//						throw {value:all_categories[item.category_id].levels[rules[j].level],levels:all_categories[item.category_id].levels};
						if (rules[j].value=="fid") {
							cell_pusher(j,y,all_categories[item.category_id].fid);
						} else {
							if (!all_categories[item.category_id]) throw "No category found in all_categories for "+item.category_id;
							cell_pusher(j,y,all_categories[item.category_id].levels[rules[j].level]);
						}
						break;
					case "manufacturer_id":
						if (prev_manufacturer_id==item.manufacturer_id) break;
						if (rules[j].value=="fid") {
							cell_pusher(j,y,all_manufacturers[item.manufacturer_id].fid);
						} else {
							cell_pusher(j,y,item.manufacturer_name);
						}
						break;
					case "value":
						cell_pusher(j,y,item[rules[j].value]);
						break;
					case "value_l10n":
						cell_pusher(j,y,item.l10ns[rules[j].l10n_id][rules[j].value]);
						break;
				}
			}
			prev_category_id=item.category_id;
			prev_manufacturer_id=item.manufacturer_id;
			y++;
		}
		this.ss=ss;
		this.ws=ws;
		return this.Cview();
	}

},{
	_type:"functions",
	_section:"Admin",
	/**
	 * Function: Admin.market_item_helper
	 */
	market_item_helper: function(mode,item) {	
		var t=this;
		switch (mode) {
			case "edit":
				var cid=this.fields.category_id;
				if (item.category_id) cid=item.category_id;
				this.fieldsinfo=this.F("Admin","market_item_fields",cid,item.id);
				this.categories_hash={};
				item.FetchAllFields();
				this.mif_values=item.fields;
				this.site.models.MarketCategory.List().forEach(function(c){ t.categories_hash[c.id]=c; });
				return this.View("controllers/adminpanel/AutoAdminMarketItem/edit_helper");
				break;
			case "save":
				if (this.fields.mif) {
					item.FetchAllFields();
					item.fields=JSON.parse(this.fields.mif);
					item.SaveAllFields();
				}
				break;
			default:
				throw new Error("market_item_helper - unknown mode="+mode);
		}

	},
	/**
	 * Function: Admin.market_item_fields
	 */
	market_item_fields: function(category_id,item_id) {
		var t=this;
		var h={field_groups:{}};
		var has_field_groups=false;
		h.categories=this.site.models.MarketCategory.List();
		h.datatypes=this.site.models.MarketFieldDatatype.List();
		h.search_levels=this.site.models.MarketSearchLevel.List();
		h.view_levels=this.site.models.MarketViewLevel.List();
		function cathelper(cat) {
			var grp=h.field_groups[cat.id]=t.site.models.MarketFieldGroup.List((cat.id=="")?"list_of_empty_category":"list_of_category",{category_id:cat.id});
			grp.forEach(function(g) {
				has_field_groups=true;
				g.FetchLocales();
				g.children=t.site.models.MarketField.List("list_of_group",{group_id:g.id});
				g.children.forEach(function(f) {
					f.FetchLocales();
				});
			});
		}
		cathelper({id:""});
		h.categories.forEach(cathelper);
		if (!has_field_groups) return undefined;
		return h;
	}
}];


function impexp1(t,side)
{
	var config=load_config(t);
	config=config[side+"_config"];
	var maxcategories=1;
	t.market_categories=t.site.models.MarketCategory.ListHier();
	t.market_categories.forEach(function(cat) { if (cat.level>maxcategories) maxcategories=cat.level;});
	t.maxcategories=maxcategories;

	t.inputs=[
		{"type":"accordion","name":"blocks",mode:"blocks","label":"",pages:[
				{id:"main-block",name:"Main information"},
				{id:"global-fields-block",name:"Global fields"},
				{id:"category-fields-block",name:"Category fields"}
			]
		}
	];
	if (side=="import") {
		t.inputs[0].pages.unshift({id:"file-block",name:"File"});
		var sss=[];
		t.site.models.Spreadsheet.List().forEach(function(ss) {sss.push({id:ss.id,name:ss.name});});
		t.inputs.push({type:"select",name:"spreadsheet_id",label:"XLS File",xpath:".file-block",values:sss});
		t.inputs.push({type:"textedit",name:"worksheet_no",label:"Worksheet number",xpath:".file-block",value:"0"});
		t.inputs.push({type:"select",name:"new_category",label:"For new categories",xpath:".file-block",values:[{id:"0",name:"Stop"},{id:"1",name:"Create"}],value:config.new_category,width:500});
		t.inputs.push({type:"select",name:"new_manufacturer",label:"For new manufacturers",xpath:".file-block",values:[{id:"0",name:"Stop"},{id:"1",name:"Create"}],value:config.new_manufacturer,width:500});
	}
	var cnt_l10n=t.site.models.L10N.Count();
	var cnt_not_l10n=t.site.models.MarketItem._config.field_names.length;
	var fns=t.site.models.MarketItem._config.field_names.concat(t.site.models.MarketItem._config.field_names_l10n);
	var fds=t.site.models.MarketItem._config.field_datatypes.concat(t.site.models.MarketItem._config.field_datatypes_l10n);
	for (var i=0;i<fns.length;i++) {
		var fn=fns[i];
		var fd=fds[i];
		var is_l10n=i>=cnt_not_l10n;
		switch (fd) {
			case "":
			case "file":
			case "file_folder":
				continue;
		}
		if (fn.match(/^calc/)) continue;
		switch (fn) {
			case "ordering":
			case "date_cr":
			case "date_mo":
			case "user_cr_id":
				break;
			case "category_id":
				t.inputs.push({type:"select",name:"item_"+fn,label:"Item field '"+fn+"'",width:500,value:config[fn]||"tree",values:[{id:"tree",name:"Categories tree, first "+maxcategories+" columns (default language)"},{id:"fid",name:"External IDS only, one column"},{id:"none",name:"No categories"}],xpath:".main-block"});
				break;
			case "manufacturer_id":
				t.inputs.push({type:"select",name:"item_"+fn,label:"Item field '"+fn+"'",width:500,value:config[fn]||"names",values:[{id:"names",name:"Names (default language)"},{id:"fid",name:"External IDS only"},{id:"none",name:"No manufacturers"}],xpath:".main-block"});
				break;
			default:
				if (is_l10n) {
					t.inputs.push({type:"select",name:"item_"+fn,label:"Locale item fields '"+fn+"'",value:config[fn]||"0",values:[{id:"0",name:"None"},{id:"1",name:"Default language only"},{id:"2",name:"All languages ("+cnt_l10n+" columns)"}],width:500,xpath:".main-block"});
				} else {
					t.inputs.push({type:"checkbox2",name:"item_"+fn,label:"Item field '"+fn+"'",value:config[fn]||0,xpath:".main-block"});
				}
				break;
		}
	}
}
