var fs=require("fs");

function gettext(rr,value,file_var)
{
	if (!value) return undefined;
	if (typeof value === "string") {
		return value;
	}
	return value[rr.site.language] || value.en || value.ru;
}


exports.add=[
{
	_type:"controller",
	_config_details: {	
	},
	
	_config: {
		path:"adminpanel/",
		name:"AdminStart",
		admin:1,
		role_code:"admin_start",

        admin_start_widgets:[{mode:"wizard",name:"Initial site configurator",body:"Lets you reconfigure site, based on site template and some information",image:"/shared/adminpanel/images/adminstart/wizard.png"}]
	},
	
	/**
	 * Controller: AdminStart.index 
	 *
	 * Returns:
	 *		typeof HTML
	 */
	index: function(config) {
		this.admin_start_fullscreen="";
		this.admin_start_blocks=[];
		var arr=this.site.models.AdminStartWidget.List();
		for (var i=0;i<arr.length;i++) {
			this.admin_start_block=arr[i];
			var html=this.C(arr[i].controller_name,arr[i].controller_mode);
			if (arr[i].fullscreen) {
				this.admin_start_fullscreen+=html;
			} else {
				var big=0;
				html=html.replace(/^BIG\n/,function() {big=1;return "";});
				this.admin_start_blocks.push({big:big,html:html,id:arr[i].id});
			}
		}
		return this.Cview();
	},

	/**
	 * Controller: AdminStart.remove
	 *
	 * Returns:
	 *		typeof HTML
	 */
	remove: function() {
		var item=this.site.models.AdminStartWidget.Get(this.fields.id);
		item.Delete();
//		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: AdminStart.coolbg
	 *
	 * Returns:
	 *		typeof HTML
	 */
	coolbg: function() {
		return this.Cview();
	},

	/**
	 * Controller: AdminStart.wizard
	 *
	 * Returns:
	 *		typeof HTML
	 */
	wizard: function() {
		this.F("AdminSiteSettings","gen_inputs",{mode:"short"});
		return "BIG\n"+this.Cview();
	},

	/**
	 * Controller: AdminStart.wizard_save
	 *
	 * Returns:
	 *		typeof HTML
	 */
	wizard_save: function() {
		this.F("AdminSiteSettings","save",{
			mode:"short",
			rebuild_site: this.fields.rebuild?1:0
		});
		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: AdminStart.nextsteps
	 *
	 * Returns:
	 *		typeof HTML
	 */
	nextsteps: function() {
		return this.Cview();
	},

	/**
	 * Controller: AdminStart.store_cart_stats
	 *
	 * Returns:
	 *		typeof HTML
	 */
	store_cart_stats: function() {
		return this.Cview();
	},

	/**
	 * Controller: AdminStart.add
	 *
	 * Returns:
	 *		typeof HTML
	 */
	add: function() {
		this.widgets=[];
		var arr=this.site.models.AdminStartWidget.List();
		var used={};
		for (var i=0;i<arr.length;i++) {
			used[arr[i].controller_name+"."+arr[i].controller_mode]=1;
		}
//		throw used;
		for (var k in this.site.controllers) {
			var _config=this.site.controllers[k]._config;
			var fullname="controllers/"+_config.path+_config.name;
			var arr=_config.admin_start_widgets;
			if (!arr) continue;
			for (var i=0;i<arr.length;i++) {
				var fullfuncname=_config.name+"."+arr[i].mode;
//				throw fullfuncname;
				this.widgets.push({
					name:this.F("Views","L",fullname,arr[i].name,2),
					body:this.F("Views","L",fullname,arr[i].body,2),
					controller_name:_config.name,
					controller_mode:arr[i].mode,
					image:arr[i].image,
					fullscreen:arr[i].fullscreen?1:0,
					in_use:(used[fullfuncname])?1:0
				});
			}
		}
		this.widgets.sort(function(a,b) { return a.name<b.name; });
		return this.Cview();
	},

	/**
	 * Controller: AdminStart.add2
	 *
	 * Returns:
	 *		typeof HTML
	 */
	add2: function() {
		var item=this.site.models.AdminStartWidget.Create();
		item.controller_name=this.fields.controller_name;
		item.controller_mode=this.fields.controller_mode;
		item.fullscreen=this.fields.fullscreen;
		item.SaveAll();
		return JSON.stringify({});
	}
},{
	_type:"functions",
	_section:"AdminSiteSettings",

	/**
	 * Function: AdminSiteSettings.gen_inputs
	 * Parameters:
	 *		options.mode typeof String		- "short", "all"
	 */
	gen_inputs: function(options) {
		if (!options) options={};
		this.inputs=[];
		var f=new fs.File(this.site.paths.database+"site_template.json");
		
		if (f.exists()) {
			f.open("r");
			var data=JSON.parse(f.read().toString("utf-8"));
			f.close();
			for (var i=0;i<data.questions.length;i++) {
				var q=data.questions[i];
				if (options.mode=="short" && q.level!="short") continue;
				var values=undefined;
				if (q.values && q.values.constructor===Array) values=q.values;
				this.inputs.push({
					type		:q.type,
					name		:q.name,
					label		:gettext(this,q.label),
					legend		:gettext(this,q.legend),
					not_null	:0,
					width		:options.width||250,
					value		:this.site.vars[q.name] || q["default"],
					values		:values
				});
			}
		}
		this.user.full_name="";
		var a=["last_name","first_name","second_name"];
		for (var i=0;i<a.length;i++) {
			if (!this.user[a[i]]) continue;
			if (this.user.full_name) this.user.full_name+=" ";
			this.user.full_name+=this.user[a[i]];
		}
	},

	/**
	 * Function: AdminSiteSettings.save
	 * Parameters:
	 *		options.mode typeof String				- TODO
	 *		options.rebuild_site typeof Boolean		- 
	 */
	save: function(options) {
		if (!options) options={};
		for (var k in this.fields) {
			var a1=k.match(/^(\w+)__(.+)$/);
			if (!a1) continue;
			switch (a1[1]) {
				case "var":
					this.site.vars[k]=this.fields[k];
				case "user":
					if (a1[2]=="full_name") {
						var a2=this.fields[k].split(/\s+/);
						this.user.last_name=a2[0];
						this.user.first_name=a2[1];
						this.user.second_name=a2.splice(2).join(" ");
					} else {
						this.user[a1[2]]=this.fields[k];
					}
				break;
			}
		}
		this.user.SaveAll();
		this.F("Files","save_site_vars");
		if (this.site.vars.site_design_code && options.rebuild_site) {
			this.fields.site_design_code=this.site.vars.site_design_code;
			this.no_system_log = 1;
			this.F("SitingSlave","init");
		}
	}

},{
	_type:"controller",
	_config_details: {	
	},
	_config: {
		path:"adminpanel/",
		name:"AdminSiteSettings",
		admin:1,
		role_code:"settings"
	},
	
	_admin_nav: [
		{section:"settings",name:"Site settings",mode:"index"}
	],

	/**
	 * Controller: AdminSiteSettings.index 
	 *
	 * Returns:
	 *		typeof HTML
	 */
	index: function(config) {
		return this.Cview();
	},

		/**
	 * Controller: AdminSiteSettings.robots_edit
	 *
	 * Returns:
	 *		typeof HTML
	 */
	robots_edit: function(config) {
		var f=new fs.File(this.site.paths.html+"robots.txt");
		if (f.exists()) {
			f.open("r");
			this.robots_txt=f.read().toString("utf-8");
			f.close();
		}
		return this.Cview();
	},

	/**
	 * Controller: AdminSiteSettings.robots_save
	 *
	 * Returns:
	 *		typeof JSON
	 */
	robots_save: function() {
		var f=new fs.File(this.site.paths.html+"robots.txt");
		f.open("w");
		f.write(this.fields.robots_txt);
		f.close();
		return JSON.stringify({redirect:{url:this.action}});
	},

	/**
	 * Controller: AdminSiteSettings.vars_edit 
	 *
	 * Returns:
	 *		typeof HTML
	 */
	vars_edit: function(config) {
		this.F("AdminSiteSettings","gen_inputs",{mode:"all",width:600});
		return this.Cview();
	},

	/**
	 * Controller: AdminSiteSettings.vars_save
	 *
	 * Returns:
	 *		typeof JSON
	 */
	vars_save: function() {
		this.F("AdminSiteSettings","save",{
			mode:"all",
			rebuild_site:1
		});
		return JSON.stringify({redirect:{url:this.action}});
	},

	/**
	 * Controller: AdminSiteSettings.sitemap_save
	 *
	 * Returns:
	 *		typeof HTML
	 */
	sitemap_save: function() {
		this.logs=this.F("SitemapGenerator","run");
		return this.Cview();
	},

}];


