exports.add=[{
	_type:"controller",
	_config_details: {
		
	},
	_config: {
		name: "Articles",
		category_code:"",
		category_groupcode:"",
		list_limit: 20,
		list_pagenumber: 0,
		list_filter_date: "visible",
		short_limit: 5,
		categories_list_limit:0,
		meta_replace: 0,
		big_preview: "5",
		featured: undefined,
		thumb_preview:"2",
		url: "/news/",
		guestbook: {
			premoderated: 0,
			users_can_post: 0,
			mail_code: ""
		}
	},

	/**
	 * Controller: Articles.index
	 *
	 * Parameters:
	 *		config typeof Object
	 *		config.list_pagenumber typeof Integer
	 *		config.list_limit typeof Integer
	 *		config.category_code typeof String
	 *		config.featured typeof Boolean
	 *		config.list_skip typeof Integer
	 *		config.list_filter_date typeof String			- one of "all", "visible", "hidden"
	 * Returns:
	 *		HTML
	 */
	index: function(config) {
		this.configArticles=config;
		var offset=(this.fields.page||config.list_pagenumber||0)*config.list_limit;
		if (config.list_skip) offset+=config.list_skip;
		this.article_category=this.site.models.ArticleCategory.List("get_by_code",{code:config.category_code})[0];

		if (!this.article_category) throw new Error("No article category "+config.category_code+"'");
		var name="list_of_category_enabled_";
		if (config.featured) name+="featured_";
		if (config.list_filter_date=="visible") name+="visible_";
		if (config.list_filter_date=="hidden") name+="hidden_";
		if (config.list_filter_date=="past") name+="past_";
		if (config.list_filter_date=="future") name+="future_";
		if (config.list_filter_date=="future_n_featured") name+="future_n_featured_";
		
		name+="limited";
		
		//if (config.list_filter_date!="all") {
		//	if (config.list_filter_date=="visible") name+="visible_"; else name+="hidden_";
		//}
		//if (config.featured) name+="featured_";
		//if (config.list_filter_date!="all") {
		//	if (config.list_filter_date=="visible") name+="visible_"; else name+="hidden_";
		//}
		//throw name;
		
		this.articles=this.site.models.Article.List(name,{category_id:this.article_category.id,limit:config.list_limit,offset:offset});
		var html = this.Cview();
		return this.fields._ajaj_html ? JSON.stringify({ html:html }) : html;
	},

	all: function(config) {
		this.configArticles=config;
		var offset=(this.fields.page||config.list_pagenumber)*config.list_limit;
		if (config.category_groupcode) {
			this.articles=this.site.models.Article.List("list_of_groupcode_enabled_"+(config.featured?"featured_":"")+"limited",{limit:config.list_limit,offset:offset,category_groupcode:config.category_groupcode});
		} else {
			this.articles=this.site.models.Article.List("list_enabled_"+(config.featured?"featured_":"")+"limited",{limit:config.list_limit,offset:offset});
		}
		return this.Cview();
	},

	/**
	 * Controller: Articles.categories
	 *
	 * Returns:
	 *		HTML
	 */
	categories: function(config) {
		var t=this;
		this.configArticles=config;
		if (config.category_groupcode) {
			this.article_categories=this.site.models.ArticleCategory.List("list_of_groupcode",{groupcode:config.category_groupcode});
		} else {
			this.article_categories=this.site.models.ArticleCategory.List();
		}
		this.article_categories.forEach(function(cat) {
			if (config.categories_list_limit) cat.articles=t.site.models.Article.List("list_of_category_enabled_limited",{category_id:cat.id,limit:config.categories_list_limit,offset:0}); else cat.articles=[];
		});
		return this.Cview();
	},

	/**
	 * Controller: Articles.short
	 *
	 * Returns:
	 *		HTML
	 */
	"short": function(config) {
		this.configArticles=config;
		this.article_category=this.site.models.ArticleCategory.List("get_by_code",{code:config.category_code})[0];
		if (!this.article_category) throw new Error("No article category "+config.category_code+"'");
		this.articles=this.site.models.Article.List("list_of_category_enabled_limited",{category_id:this.article_category.id,limit:config.short_limit,offset:0});
		return this.Cview();
	},

	/**
	 * Controller: Articles.view
	 *
	 * Returns:
	 *		HTML
	 */
	view: function(config) {
		this.configArticles=config;
		if (!this.fields.article_calc_code) {
			this.jsng_response.status_code="404";
			return "GET/POST field article_calc_code is mandatory!";
		}
		var a=this.article=this.site.models.Article.List("get_by_calc_code",{calc_code:this.fields.article_calc_code})[0];
		if (!this.article) {
			this.jsng_response.status_code="404";
			return "No article found, code="+this.fields.article_calc_code;
		}
		this.article.FetchFileFolderFiles();
		this.article_category=this.site.models.ArticleCategory.Get(this.article.category_id);
		if (a.title) {
			if (a.title) this.pageinfo.title=(config.meta_replace)?a.title:a.title+" - "+this.pageinfo.title;
		} else {
			if (a.name) this.pageinfo.title=(config.meta_replace)?a.name:a.name+" - "+this.pageinfo.title;
		}
		if (a.meta_abstract) this.pageinfo.meta_abstract=(config.meta_replace)?a.meta_abstract:a.meta_abstract+" - "+this.pageinfo.meta_abstract;
		if (a.meta_description) this.pageinfo.meta_description=(config.meta_replace)?a.meta_description:a.meta_description+" - "+this.pageinfo.meta_description;
		if (a.folder_id) {
			a.FetchFileFolderFiles();
			a.folder.forEach(function(i) {
				var arr=i.url.match(/^(.*)\.(\w+)$/);
				i.big_url=arr[1]+"-preview"+config.big_preview+"."+arr[2];
				i.thumb_url=arr[1]+"-preview"+config.thumb_preview+"."+arr[2];
			});
		}
		var html=this.Cview();
		if (config.has_guestbook) {
			var gb=this.site.models.Guestbook.Get("get_by_code",{code:"article-"+a.id});
			if (!gb) {
				gb=this.site.models.Guestbook.Create();
				gb.code="article-"+a.id;
				gb.name="Article ID"+a.id;
				gb.premoderated=config.guestbook.premoderated;
				gb.users_can_post=config.guestbook.users_can_post;
				gb.mail_code=config.guestbook.mail_code;
				gb.SaveAll();
			}
			var h={guestbook_code:gb.code};
			for (var k in config.guestbook) h[k]=config.guestbook[k];
			html+=this.C("Guestbook","index",h);
			//throw config;
		}
		return html;
	},

	/**
	 *
	 */
	nav_path_helper: function(config) {
		if (!this.article) return;
		var np=config.nav_path;
		if (np.length) np[np.length-1].clickable=1;
		np.push({url:this.action_src,name:this.article.name,clickable:false});
		//np.push({url:this.alias+this.article.calc_code+"/",name:this.article.name,clickable:false});
	},
	
	siblings: function(){
		if (!this.article) throw 'no article';
		var t = this;
		this.siblings = this.site.models.Article.List('list_of_category',{ category_id:this.article.category_id }).filter(function(el){ return el.id!=t.article.id });
		return this.Cview();
	},
	
	admin_galleries_list: function(config){		
		
		if (!config.fid_id) throw 'No category id!';
		
		var list = this.site.models.Article.List('list_of_category_enabled_limited',{category_id:config.fid_id}).filter(function(el){
			return el.folder_id;
		})
		
		return list;
	}
	
}];

