/*
ROBOKASSA:
	RESULT URL: /cart/robokassa_auth/
	SUCCESS URL: /cart/payment_ret_page/
	FAIL URL: /cart/payment_fail_page/

*/

var default_check_update={
	first_name:{min:1,max:128},
	last_name:{min:1,max:128},
	phone:{min:1,max:128},
	address_city:{min:1,max:128},
	address_street:{min:1,max:128},
	address_comments:{min:0,max:1000}
};

var default_check_fast_checkout={
		email:{type:"email",min:1,max:128},
		first_name:{min:1,max:128},
		last_name:{min:1,max:128},
		phone:{min:1,max:128},
		address_city:{min:1,max:128},
		address_street:{min:1,max:128},
		address_comments:{min:0,max:1000}
};

var default_check_register={
		login:{type:"email_exists",min:1,max:128},
		password1:{type:"password1",min:1,max:128},
		password2:{type:"password2",min:1,max:128},
		first_name:{min:1,max:128},
		last_name:{min:1,max:128},
		phone:{min:1,max:128},
		address_city:{min:1,max:128},
		address_street:{min:1,max:128},
		address_comments:{min:0,max:1000}
};

function mk_tocheck(prefix,conf,obj)
{
	var c=conf[prefix];
	if (!c) return obj;
	var r={};
	for (var k in obj) r[k]=obj[k];
	for (var k in c) r[k]=c[k];
	return r;
}

exports.add=[{
	_type:"controller",
	_config_details: {
	},
	_config: {
		name: "Cart",
		market_action: "/market/",
		action: "/cart/",
		preview: "2C"
	},
	/**
	 * Controller: Cart.snippet
	 *
	 */

	snippet: function(config) {
		this.configCart=config;
		this.cart=this.F("Cart","get_user_fill");
		this.cart.FetchItemsFull(); //GD
		return this.Cview();
	},

	/**
	 * Controller: Cart.index
	 *
	 */
	index: function(config) {
		this.configCart=config;
		this.cart=this.F("Cart","get_user_fill");
		
		//throw this.cart;
		
		this.cart.FetchItemsFull();
		this.payment_methods=this.site.models.CartPaymentMethod.List("list_enabled");
		return this.Cview();
	},

	/**
	 *
	 */
	auth_robokassa: function(config) {
		this.fields.ajaj=1;
		this.configCart=config;
		var mrh_pass2 = config.robokassa_password2||"password_2";

		if (!this.fields.OutSum.match(/^\d+|\d+\.\d+/)) return "OutSum is not a number!";
		if (!this.fields.InvId.match(/^\d+/)) return "InvId is not an integer!";

		var src_crc=this.fields.SignatureValue.toUpperCase();

		var sub=this.fields.OutSum+":"+this.fields.InvId+":"+mrh_pass2;
		var check_crc=require("hash").md5(sub).toUpperCase();
		if (src_crc!=check_crc) return "CRC mismatch";

		this.cart=this.site.models.Cart.Get(this.fields.InvId);
		if (!this.cart) return "Cart does not exist!";
		this.cart.FetchItemsFull();
		var state=this.site.models.CartState.Get(this.cart.state_id);
		if (state.code!="fill") return "Cart is not in fill-state!";
		
		this.cart.real_payed+=this.fields.OutSum*1;
		if (this.cart.real_payed>=this.cart.calc_amount) {
			this.cart.state_id=this.site.models.CartState.List("get_by_code",{code:"sent"})[0].id;
		}
		this.cart.SaveAll();
		return "OK"+this.cart.id;
	},
	
	/**
	 *
	 */
	gen_page_robokassa: function(config) {
		this.configCart=config;
		this.cart_readonly=1;
		this.cart=this.F("Cart","get_user_fill");
		this.cart.FetchItemsFull();

/*
# your registration data
my $mrh_login = "test";      ### your login here
my $mrh_pass1 = "securepass1";   ### merchant pass1 here


# order properties
my $inv_id    = 5;        ### shop's invoice number 
                          ### (unique for shop's lifetime)
my $inv_desc  = "desc";   ### invoice desc
my $out_summ  = "5.12";   ### invoice summ

# build CRC value
my $crc  =
    md5_hex("$mrh_login:$out_summ:$inv_id:$mrh_pass1");

# build URL
my $url = "https://auth.robokassa.ru/Merchant/Index.aspx?MrchLogin=$mrh_login&".
    "OutSum=$out_summ&InvId=$inv_id&Desc=$inv_desc&SignatureValue=$crc";

# print URL if you need
print "Content-type: text/html\n\n";
print "<a href='/ru/$url'>Payment link</a>";
*/
		var mrh_login = config.robokassa_login||"demo";
		var mrh_pass1 = config.robokassa_password1||"password_1";
		var inv_id = this.cart.id;
		var inv_desc = "Оплата заказа N"+this.cart.id+" в магазине "+this.site.name;
		var out_summ = this.cart.calc_summ;
		var shp_item = "1";
		var culture = "ru";
		var encoding = "utf-8";

		var sub=mrh_login+":"+out_summ+":"+inv_id+":"+mrh_pass1;//+":shpItem="+shp_item;
		var crc = require("hash").md5(sub);

		// HTML-страница с кассой
		// ROBOKASSA HTML-page
		//print "Content-type: text/html\n\n";
		//print "<html><script language=JavaScript ".
		//      "src='https://auth.robokassa.ru/Merchant/PaymentForm/FormMS.js?".
		//      "MerchantLogin=$mrh_login&OutSum=$out_summ&InvoiceID=$inv_id".
		//      "&Description=$inv_desc&SignatureValue=$crc&shpItem=$shp_item".
		//      "&Culture=$culture&Encoding=$encoding'></script></html>";
		// https://auth.robokassa.ru/Merchant/Index.aspx?MrchLogin=$mrh_login&OutSum=$out_summ&InvId=$inv_id&Desc=$inv_desc&SignatureValue=$crc

//		this.cart_pay_button="<script language=JavaScript src='https://auth.robokassa.ru/Merchant/PaymentForm/FormMS.js?MrchLogin="+mrh_login+"&OutSum="+out_summ+"&InvID="+inv_id+"&Desc="+inv_desc+"&SignatureValue="+crc+"&Culture="+culture+"&Encoding="+encoding+"'></script>";
		//this.cart_pay_button="<script language=JavaScript src='https://auth.robokassa.ru/Merchant/PaymentForm/FormMS.js?MerchantLogin="+mrh_login+"&OutSum="+out_summ+"&InvoiceID="+inv_id+"&Description="+inv_desc+"&SignatureValue="+crc+"&Culture="+culture+"&Encoding="+encoding+"'></script>";
		this.cart_pay_link="http://"+(config.robokassa_test?"test":"auth")+".robokassa.ru/Index.aspx?MrchLogin="+mrh_login+"&OutSum="+out_summ+"&InvID="+inv_id+"&Desc="+inv_desc+"&SignatureValue="+crc+"&Culture="+culture+"&Encoding="+encoding;
		return this.Cview();
	},

	/**
	 * Controller: Cart.payment_fail_page
	 */
	payment_fail_page:function(config) {
		this.configCart=config;
		this.cart_readonly=1;
		this.cart=this.F("Cart","get_user_fill");
		this.cart.FetchItemsFull();
		return this.Cview();
	},

	/**
	 * Controller: Cart.payment_ret_page
	 */
	payment_ret_page: function(config) {
		this.fields.cart_id=this.fields.InvId;
		return this.C("Cart","checkout_done",config);
	},
		
	/**
	 * Controller: Cart.auth
	 *
	 */
	auth: function(config) {
		if (!this.uid) {
			var errors={};
			if (!this.fields.login) errors.login=this.F("Views","L","controllers/Cart","Empty email",1); else errors.password=this.F("Views","L","controllers/Cart","Incorrect password or email",1);
			return JSON.stringify({call:"CartFuncs.login_error",errors:errors});
		}
		this.cart=this.F("Cart","auth");
		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: Cart.profile_upd
	 */
	profile_upd: function(config) {
		this.configCart=config;
		var errors=this.F("UserAuth","register_check",mk_tocheck("check_update",config,default_check_update));

		if (errors) return JSON.stringify({call:"CartFuncs.profile_upd_error",errors:errors,to_check:mk_tocheck("check_update",config,default_check_update),config:config});

		var u=this.site.models.User.Get(this.uid);
		this.F("Cart","profile_user_update_fields",u);
		u.SaveAll();
		
		var cart=this.cart=this.F("Cart","get_user_fill");
		this.cart.FetchItemsFull();
		
		ret=this.cart.BeforeCheckoutCustom();
		if (ret) return JSON.stringify(ret);

		this.F("Cart","profile_cart_update_fields",cart);
		cart.SaveAll();
		return JSON.stringify({refresh:1});

	},

	/**
	 * Controller: Cart.register
	 *
	 */
	register: function(config) {
		this.configCart=config;
		var errors=this.F("UserAuth","register_check",mk_tocheck("check_register",config,default_check_register));
		
		//throw errors;

		if (errors) return JSON.stringify({call:"CartFuncs.register_error",errors:errors});

		
		var u2 = this.site.models.User.Get('get_of_login',{login:this.fields.login});
		if(u2) return JSON.stringify({call:"CartFuncs.register_error",errors:{login:'already exist'}});
		
		var u=this.site.models.User.Create();
		this.F("Cart","profile_user_update_fields",u);
		u.SaveAll();
		u.StartSession();

		var cart=this.cart=this.F("Cart","auth");
		for (var k in this.fields) {
			if (k.match(/^(address.*|required_change)$/)) cart[k]=this.fields[k];
		}
		cart.address_phone=this.fields.phone;
		cart.SaveAll();
		this.user=u;
		this.uid=u.id;
		this.F("Cart","after_register");
		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: Cart.fast_checkout
	 *
	 */
	fast_checkout: function(config) {
		this.configCart=config;
		//TODO
		var errors=this.F("UserAuth","register_check",mk_tocheck("check_fast_checkout",config,default_check_fast_checkout));
		
		//throw errors;

		if (errors) return JSON.stringify({call:"CartFuncs.fast_checkout_error",errors:errors});
		var date = new Date;
		var u=this.site.models.User.Create();
		this.F("Cart","profile_user_update_fields",u);
		u.login='temp' + date.getTime();
		u.email=this.fields.email;
		u.password='tmppasswd';//this.fields.password1;
		u.SaveAll();
		u.StartSession();

		var cart=this.cart=this.F("Cart","auth");
		this.F("Cart","profile_cart_update_fields",cart);
//		for (var k in this.fields) {
//			if (k.match(/^(address.*|required_change)$/)) cart[k]=this.fields[k];
//		}
//		cart.address_phone=this.fields.phone;
		cart.SaveAll();
		
		//this.configCart=config;
		//var ret=this.C("Cart","profile_upd",config);
		//if (ret.match(/error/)) return ret;
		//if (!this.cart.payment_method_id) return JSON.stringify({call:"CartFuncs.profile_upd_error",errors:{payment_method:this.F("Views","L","controllers/Cart","Please choose a payment method",1)}});
		this.cart.FetchItemsFull();
		
		this.cart.user=this.site.models.User.Get(this.cart.user_id);

		// Только в случае оплаты на руки курьеру
		
		this.hide_login=1;
		this.show_email=1;

		// Отсылка email пользователю
		this.F("Functions","send_mail",this.F("Cart","mail_template_code","fast_cart_checkout","user"),{to:u.email},0);
		// Отсылка email сотруднику
		this.F("Functions","send_mail",this.F("Cart","mail_template_code","fast_cart_checkout","manager"),{},0);
		
		//if (this.cart.items.length==0) return JSON.stringify({call:"CartFuncs.profile_upd_error",errors:{payment_method:this.F("Views","L","controllers/Cart","Cart is empty. Possibly you already submitted it in another browser window. Please <a href=''>refresh</a> this window to check.",1)}});


		//var pm=this.site.models.CartPaymentMethod.Get(this.cart.payment_method_id);
		//if (pm.prepay) {
		//	this.cart.SaveAll();
		//	return JSON.stringify({redirect:{url:this.action+"?mode=gen_page_"+pm.func}});
		//}
		//ret=this.cart.BeforeCheckoutCustom();
		//if (ret) return JSON.stringify(ret);

		this.cart.state_id=this.site.models.CartState.List("get_by_code",{code:"sent"})[0].id;
		this.cart.SaveAll();
	
		u.StopSession();	
		
		//throw {user:u,cart:this.cart,cart_user:this.cart.user,items:this.cart.items};
		//this.cart.AfterCheckoutCustom();
		return JSON.stringify({redirect:{url:this.action+"?mode=fast_checkout_done&cart_id="+this.cart.id}});
		
		//return JSON.stringify({refresh:1});
	},
	
	/**
	 * Controller: Cart.checkout
	 *
	 */
	checkout: function(config) {
		
		this.configCart=config;
		var ret=this.C("Cart","profile_upd",config);
		if (ret.match(/error/)) return ret;
		if (!this.cart.payment_method_id) return JSON.stringify({call:"CartFuncs.profile_upd_error",errors:{payment_method:this.F("Views","L","controllers/Cart","Please choose a payment method",1)}});
		this.cart.FetchItemsFull();
		this.cart.user=this.site.models.User.Get(this.cart.user_id);

		// Только в случае оплаты на руки курьеру
		
		// Отсылка email пользователю
		this.F("Functions","send_mail",this.F("Cart","mail_template_code","cart_checkout","user"),{to:this.cart.user.login},0);
		// Отсылка email сотруднику
		this.F("Functions","send_mail",this.F("Cart","mail_template_code","cart_checkout","manager"),{},0);
		
		if (this.cart.items.length==0) return JSON.stringify({call:"CartFuncs.profile_upd_error",errors:{payment_method:this.F("Views","L","controllers/Cart","Cart is empty. Possibly you already submitted it in another browser window. Please <a href=''>refresh</a> this window to check.",1)}});


		var pm=this.site.models.CartPaymentMethod.Get(this.cart.payment_method_id);
		if (pm.prepay) {
			this.cart.SaveAll();
			return JSON.stringify({redirect:{url:this.action+"?mode=gen_page_"+pm.func}});
		}
		ret=this.cart.BeforeCheckoutCustom();
		if (ret) return JSON.stringify(ret);

		this.cart.state_id=this.site.models.CartState.List("get_by_code",{code:"sent"})[0].id;
		this.cart.SaveAll();
		this.cart.AfterCheckoutCustom();
		return JSON.stringify({redirect:{url:this.action+"?mode=checkout_done&cart_id="+this.cart.id}});
	},

	/**
	 * Controller: Cart.checkout_done
	 *
	 */
	checkout_done: function(config) {
		this.configCart=config;
		this.cart_readonly=1;
		var cart=this.cart=this.site.models.Cart.Get(this.fields.cart_id);
		if (cart.user_id!=this.uid) return "Access denied";
		cart.FetchItemsFull();
		return this.Cview();
	},
	
	fast_checkout_done: function(config) {
		this.configCart=config;
		this.cart_readonly=1;
		var cart=this.cart=this.site.models.Cart.Get(this.fields.cart_id);
		//if (cart.user_id!=this.uid) return "Access denied";
		cart.FetchItemsFull();
		return this.Cview();
	},
	
	
	carts_old: function(config) {
		this.carts_old=this.site.models.Cart.List("list_by_user_and_state",{user_id:this.uid, state_id: config.type_id || 2 });
		return this.Cview();
	},
	
	
	cart_old: function(config) {
		this.cart=this.site.models.Cart.Get(this.fields.cart_id);
		if (this.cart.user_id!=this.uid) {
			throw "Hacks are not allowed";
		}
		this.cart.FetchItemsFull();
		return this.Cview();
	}
}];
