exports.add=[{
	_type:"controller",
	_config_details: {
		
	},
	_config: {
		name: "Gallery",
		thumb_preview: "2",
		big_preview: "5",
		max_levels: 1,
		folder_list_level_name: "list_level",
		folder_preview_name: "get_random_image",
		folder_id: undefined
	},
	/**
	 * Controller: Gallery.folders_tree
	 *
	 * Returns:
	 *		HTML
	 */
	folders_tree: function(config) {
		var t=this;
		this.configGallery=config;
		this.gallery_folder=this.site.models.FileFolder.Get(config.folder_id);
		function iter(parent_id,level,maxl)
		{
			t.site.models.FileFolder.List(config.folder_list_level_name,{parent_id:parent_id}).forEach(function(f) {
				var img=t.site.models.File.List(config.folder_preview_name,{file_folder_id:f.id})[0];
				if (img) f.preview_image_url=img.url;
				f.level=level;
				t.gallery_folders_tree.push(f);
				if (maxl>0) iter(f.id,level+1,maxl-1);
			});
		}
		this.gallery_folders_tree=[];
		iter(this.gallery_folder.id,1,config.max_levels);
		return this.Cview();
	},

	/**
	 * Controller: Gallery.folder_images
	 *
	 * Returns:
	 *		HTML
	 */
	folder_images: function(config) {
		//throw config;
		this.configGallery=config;
		this.gallery_folder=this.site.models.FileFolder.Get(config.folder_id);
		this.gallery_files=this.site.models.File.List("list_of_file_folder",{file_folder_id:config.folder_id});
		this.gallery_files.forEach(function(f) {
			var arr=f.url.match(/^(.+)(\.\w+)$/);
			f.thumb_url=(config.thumb_preview)?(arr[1]+"-preview"+config.thumb_preview+arr[2]):f.url;
			f.big_url=(config.big_preview)?(arr[1]+"-preview"+config.big_preview+arr[2]):f.url;
		});
		this.gallery_first_file=this.gallery_files[0];
		return this.Cview();
	}
}];

