function nav_name(config)
{
	return config.force_all?"list_nav_level_all":"list_nav_level";
}

exports.add=[{
	_type:"controller",
	_config_details: {
		
	},
	_config: {
		name: "NavFull",
		index_view:"index-cl1",
		index_views:["index-cl1","index-clany","sitemap"],
		parent_id:null,
		force_all:false,// Force all pages, not only "show in navigation"
		show_logo_before:0,
		show_logo_after:0,
		helpers:[],
		children_levels:1,
		max_levels:100
	},
	/**
	 * Controller: NavFull.index
	 *		Renders full navigation
	 *
	 * Parameters:
	 *		config
	 *		config.parent_id typeof Integer or String	- "root_id" means this.calc_pages.root_id
	 *
	 *
	 * Returns:
	 *		HTML
	 */
	index: function(config) {
		var t=this;
		this.F("Nav","calc");
		this.configNavFull=config;

		function iter(parent_id,ml,cl)
		{
			if (ml==0) return [];
			var r;
			if (cl) {
				r=t.site.models.Page.List(nav_name(config),{parent_id:parent_id,user_id:t.uid});
			} else {
				r=t.site.models.Page.ListHier(nav_name(config),{parent_id:parent_id,user_id:t.uid});
			}
			r.forEach(function(p) {
				if (t.calc_pages.active[p.id]) p.active=1;
				if (p.alias==t.action) p.fully_active=1;
				if (p.alias=="/index/") p.alias="/";
				if (cl>0 && ml>0) {
					var a=iter(p.id,ml-1,cl-1);
					if (a.length) p.children=a;
				}
			});
			return r;
		}
		var pid=config.parent_id;
		if (pid=="root_id") pid=this.calc_pages.root_id;
		this.nav_full=iter(pid,config.max_levels,config.children_levels);
		config.helpers.forEach(function(a) {
			var arr=a.match(/^(\w+)\.(\w+)$/);
			var err=t.C(arr[1],arr[2]);
			if (err) throw err;
		});
		return this.Cview();
	}
}];

