var PAGE_ITEMS=["title","meta_description","meta_keywords"];

exports.add=[{
	_type:"functions",
	_section:"Seomp",

	/**
	 * Function: Seomp.generate_sqls
	 *
	 * Parameters:
	 *		config.seomp_code
	 *		config.pre_placeholder
	 */
	generate_sqls: function(config) {
		this.seomp=this.site.models.Seomp.Get("get_by_code",{code:config.seomp_code});
		if (config.pre_placeholder) {
			if (!this.fields.groupname) return this.C("Seomp","pre",config);
			this.gph=this.site.models.SeompPlaceholder.Get("get_by_seomp_and_code",{seomp_id:this.seomp.id,code:config.pre_placeholder});
		}
		var phs=this.seomp_placeholders=this.site.models.SeompPlaceholder.List("list_of_seomp",{seomp_id:this.seomp.id});
		var columns=[];
		var from=[];
		var where=[];
		var order_by=[];
		var counters=[];
		for (var i=0;i<phs.length;i++) {
			var ph=phs[i];
			ph.re=new RegExp("\\["+ph.code+"\\]");
			columns.push("	sphv"+ph.id+".id as sphv_id"+ph.id);
			columns.push("	sphv"+ph.id+".name as sphv_name"+ph.id);
			from.push("	Tseomp_placeholder_values sphv"+ph.id);
			where.push(" sphv"+ph.id+".placeholder_id="+ph.id);
			if (this.gph && this.gph.id==ph.id) where.push(" sphv"+ph.id+".groupname=:groupname");
			order_by.push("sphv"+ph.id+".name");
			counters.push("	(select count(*) from Tseomp_placeholder_values sphv"+ph.id+" where sphv"+ph.id+".placeholder_id="+ph.id+((this.gph && this.gph.id==ph.id)?" and sphv"+ph.id+".groupname=:groupname":"")+")");
		}
		var sqlq_list="select\n"+columns.join(",\n")+"\nfrom\n"+from.join(",\n")+"\nwhere\n"+where.join(" and\n")+"\norder by "+order_by.join(",")+"\nlimit :limit offset :offset";
		var sqlq_cnt="select\n"+counters.join("*\n")+" as cnt\n";
		return {list:sqlq_list,cnt:sqlq_cnt};
	},

	/**
	 * Function: Seomp.fetch_pages
	 */
	fetch_pages: function(config) {
		var PAGESIZE=config.pagesize||50;
		var sqlq=this.F("Seomp","generate_sqls",config);
		var phs=this.seomp_placeholders;
		this.items=this.site.sql.execute_and_fetch_single(sqlq.list,{limit:PAGESIZE,offset:(this.fields.page||0)*PAGESIZE,groupname:this.fields.groupname});
		var cnt=this.site.sql.execute_and_fetch_one_single(sqlq.cnt,{groupname:this.fields.groupname}).cnt;
		this.pages=config.no_pages?"":this.C("Helper","paginator",{active:this.fields.page||0,pages:Math.ceil(cnt/PAGESIZE),title:"Pages:"});
//		return this.body=this.Dumper({sqlq_cnt:sqlq_cnt,cnt:cnt,pages:Math.ceil(cnt/PAGESIZE),PAGESIZE:PAGESIZE});

		var page_url_suffix=this.seomp.page_url_suffix;
		if (page_url_suffix && !page_url_suffix.match(/\/$/)) page_url_suffix+="/";
		for (var i=0;i<this.items.length;i++) {
			var item=this.items[i];
			var name=this.seomp.name_template;
			var ids=[];
			item.alias=page_url_suffix||"";
			for (var j=0;j<phs.length;j++) {
				var ph=phs[j];
				ids.push(item["sphv_id"+ph.id]);
				name=name.replace(ph.re,item["sphv_name"+ph.id]);
				if (page_url_suffix) {
					item.alias=item.alias.replace(ph.re,this.F("Languages","to_code",item["sphv_name"+ph.id]));
				} else {
					item.alias+=this.F("Languages","to_code",item["sphv_name"+ph.id])+"/";
				}
			}
			item.ids=ids.join(",");
			item.name=name;
		}
	},
	
},{
	_type:"functions",
	_section:"SitemapGenerator",

	_controller_Seomp: function(builder,config,page) {
		var logs=[];
		config.pagesize=50000;
		config.no_pages=1;
		builder.add_url(page.alias);
		if (config.pre_placeholder) {
			var c=this.C("Seomp","pre",config,1);
			c.replace(/href="(.+?)"/g,function(p,p1) { builder.add_url(p1); });
			system.gc();
			var groups=this.groups;
			for (var i=0;i<groups.length;i++) {
				this.fields.groupname=groups[i].groupname;
				var c=this.C("Seomp","index",config,1);
				if (config.put_body_to) c=this[config.put_body_to];
				c.replace(/<div class="Paginator">(.*?<div.*?<\/div>)*<\/div>/i,"").replace(/href="(.+?)"/g,function(p,p1) { builder.add_url(p1); });
			}
			system.gc();
		} else {
			var c=this.C("Seomp","index",config,1);
			c.replace(/href="(.+?)"/g,function(p,p1) { builder.add_url(p1); });
		}
		return logs;
	},

},{
	_type:"controller",
	_config: {
		name:"Seomp",
	},


	/**
	 * Controller: Seomp.pre
	 *		Lists groupnames
	 */
	pre: function(config) {
		this.seomp=this.site.models.Seomp.Get("get_by_code",{code:config.seomp_code});
		this.ph=this.site.models.SeompPlaceholder.Get("get_by_seomp_and_code",{seomp_id:this.seomp.id,code:config.pre_placeholder});
		this.groups=this.site.sql.execute_and_fetch("seomp_placeholder_values/list_groupnames",{placeholder_id:this.ph.id});
		var r=this.Cview();
		if (config.put_body_to) this[config.put_body_to]=r;
		return r;
	},

	/**
	 * Controller: Seomp.index
	 *		Lists variants, possibly filtered by some groupname
	 */
	index: function(config) {
		if (config.pre_placeholder) {
			if (!this.fields.groupname) return this.C("Seomp","pre",config);
		}
		this.F("Seomp","fetch_pages",config);
		var r=this.Cview();
		if (config.put_body_to) {
			this[config.put_body_to]=r;
			return "";
		}
		return r;
	},

	/**
	 * Controller: Seomp.view
	 *		Shows final page
	 */
	view: function(config) {
		var t=this;
		this.seomp=this.site.models.Seomp.Get("get_by_code",{code:config.seomp_code});

		for (var j=0;j<PAGE_ITEMS.length;j++) if (this.seomp["page_"+PAGE_ITEMS[j]] || !this.pageinfo[PAGE_ITEMS[j]]) this.pageinfo[PAGE_ITEMS[j]]=this.seomp["page_"+PAGE_ITEMS[j]]||"";
		if (this.seomp.page_meta_description) this.pageinfo.title=this.seomp.page_title;
		if (this.seomp.page_meta_keywords) this.pageinfo.title=this.seomp.page_title;

		var ids=this.fields.ids.split(/,/);
		var phs=this.seomp_placeholders=this.site.models.SeompPlaceholder.List("list_of_seomp",{seomp_id:this.seomp.id});
		var blocks=this.seomp_blocks=this.site.models.SeompBlock.List("list_of_seomp",{seomp_id:this.seomp.id});
		var phs_by_code={};
		for (var i=0;i<phs.length;i++) {
			var ph=phs[i];
			var phv=this.site.models.SeompPlaceholderValue.Get(ids[i]);
			ph.value=phv.name;
			ph.image1_url=phv.image1_url;
			ph.image2_url=phv.image2_url;
			ph.image3_url=phv.image3_url;
			ph.re=new RegExp("\\[("+ph.code+")\\]","g");
			if (ph.image_tpl1) ph.re_image1=new RegExp("\\[("+ph.code+")\.image1\\]","g");
			phs_by_code[ph.code]=ph;
			
			for (var j=0;j<PAGE_ITEMS.length;j++) this.pageinfo[PAGE_ITEMS[j]]=this.pageinfo[PAGE_ITEMS[j]].replace(ph.re,ph.value);
		}
		for (var i=0;i<blocks.length;i++) {
			var body=blocks[i].body_src;
			for (var j=0;j<phs.length;j++) {
				var ph=phs[j];
				body=body.replace(ph.re,function(p,p1) { return ph.value; });
				if (ph.re_image1) body=body.replace(ph.re_image1,function(p,p1) { return ph.image1_url; });
			}
			this[blocks[i].place_code]=body;
		}
		return "";
	}
}];
