var fs=require("fs");

/**
 * Class: SitemapBuilder
 *
 *		Typical use:
 *		var builder=new SitemapBuilder(this);
 *		builder.add_file("sitemap_parts/static1.xml"); // some static pre-defined files
 *		builder.add_file("sitemap_parts/static2.xml"); // some static pre-defined files
 *		builder.add_section("sitemap_parts/countrues");
 *		builder.add_url("/countries/US/");
 *		builder.add_url("/countries/UK/");
 *		...
 *		builder.add_section("sitemap_parts/cities");
 *		builder.add_url("/countries/US/New-York/");
 *		...
 *		builder.build_index();
 *
 * Method: new
 */
function SitemapBuilder(rr,sitename)
{
	this.rr=rr;
	this.files=[];
	this.sitename=sitename;
}

/**
 * Method: add_file
 */
SitemapBuilder.prototype.add_file=function(name)
{
	this.files.push(name);
}

/**
 * Method: add_section
 */
SitemapBuilder.prototype.add_section=function(name)
{
	this.end_section();
	this.section=name;
	this.section_n=1;
	this.urls=[];
}

/**
 * Method: add_url
 */
SitemapBuilder.prototype.add_url=function(name)
{
	if (name=="/index/") {
		name="/";
	} else {
		name=name.replace(/^\/index\/\?/,"/?");
	}
	name=name.replace(/ /g,"%20");
	if (!this.section) throw new Error("No section");
	this.urls.push(name);
	if (this.urls.length>=40000) this.commit_section();
}

/**
 * Method: commit_section
 */
SitemapBuilder.prototype.commit_section=function()
{
	if (!this.section) throw new Error("No section");
	var data="";
	data+='<?xml version="1.0" encoding="UTF-8"?>\n';
	data+='<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">\n';
	for (var i=0;i<this.urls.length;i++) {
		data+='<url><loc>http://'+this.sitename+this.urls[i]+'</loc></url>\n';
	}
	data+='</urlset>\n';
	this.urls=[];
	this.save(this.section+"-"+this.section_n+".xml",data);
	this.section_n++;
}

/**
 * Method: end_section
 */
SitemapBuilder.prototype.end_section=function()
{
	if (this.section) this.commit_section();
	this.section=undefined;
}

/**
 * Method: save
 */
SitemapBuilder.prototype.save=function(name,data)
{
	this.files.push(name);
	name=this.rr.site.paths.html+name;
	this.rr.F("Files","mkdir_rec",name,1);
	var f=new fs.File(name);
	try {
		f.open("w");
		f.write(data);
		f.close();
	} catch(e) {
		throw "Cannot save to file "+name+" - "+e;
	}
}

/**
 * Method: build_index
 */
SitemapBuilder.prototype.build_index=function()
{
	this.end_section();
	var sitemap_index="";
	sitemap_index+='<?xml version="1.0" encoding="UTF-8"?>\n';
	sitemap_index+='<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">\n';

	for (var i=0;i<this.files.length;i++) {
		sitemap_index+='<sitemap><loc>http://'+this.sitename+'/'+this.files[i]+'</loc></sitemap>\n';
	}
	sitemap_index+='</sitemapindex>\n';
	this.save("sitemap.xml",sitemap_index);
	return "OK: Made an index of "+(this.files.length-1)+" urlset files";
}

function logs_adder(logs,data)
{
	if (!data) return logs;
	if (data.constructor===Array) logs=logs.concat(data); else logs.push(data);
	return logs;
}

exports.add=[{
	_type:"functions",
	_section:"SitemapGenerator",

	
	run: function() {
		var action_copy=this.action;
		var fields_copy=this.fields;
		var builder=new SitemapBuilder(this,this.site.vars.var__hostname||this.site.names[0]);
//		builder.add_file("sitemap_parts/static1.xml"); // some static pre-defined files
//		builder.add_file("sitemap_parts/static2.xml"); // some static pre-defined files
		var logs=[];
		for (var k in this.site.functions.SitemapGenerator) {
			if (k[0]=="_") continue;
			if (k=="run") continue;
			logs.push("<b>calling generator SitemapGenerator."+k+"()</b>");
			logs=logs_adder(logs,this.F("SitemapGenerator",k,builder));
		}
		logs.push(builder.build_index());
		this.action=action_copy;
		this.fields=fields_copy;
		return logs;
	},

	pages: function(builder) {
		var logs=[];
		builder.add_section("sitemap_parts/pages");
		var arr=this.site.models.Page.List();
		for (var i=0;i<arr.length;i++) {
			this.fields={};
			var page=arr[i];
			if (page.role_id) continue;
			if (page.hide_anon) continue;
			if (page.prerun) {
				var prerun=page.prerun.replace(/\..+$/,"");
				var prerun_param=page.prerun_param;
				if (prerun_param) eval("prerun_param="+prerun_param);
				if (this.site.functions.SitemapGenerator["_controller_"+prerun]) {
					this.action=page.alias;
					logs.push("<b>calling generator SitemapGenerator._controller_"+prerun+"()</b>");
					logs_adder(logs,this.F("SitemapGenerator","_controller_"+prerun,builder,prerun_param||{},page));
				}
				continue;
			}
			builder.add_url(page.alias);
		}
		return logs;
	},

}];
