var MK_PASSWORD={
	pre:["alga","trim","aqua","anna","band","berg","bike","boat","brim","boys","girl","bump","cain","ding","dish","disk","emit","emmy","face","fact","fist","five","fork","fuse","fuss","game","gaze","star","wink","earn","rest","type","uniq","isle","only","post","soda","demo","hole","joke","king","love","zorg","vest","null","more"],
	easy:"1234567890",
	strong:"1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM"
};

exports.add=[{
    _type:"functions",
    _section:"UserAuth",

	/**
	 * Function: UserAuth.phone_format
	 *		Attributes: TODO
	 *		Converts phone to some standart form
	 *		TODO - need to make it country-dependent
	 */
	phone_format: function(v) {
		if (v===null || v===undefined || v==="") return null;
		v=v.replace(/[^\d\+]+/g,"");
		if (v.match(/^\+(\d{11,})$/)) {
			return v;
		} else if (v.match(/^8\d{10,}$/)) {
			return v.replace(/^8/,"+7");
		} else if (v.match(/^7\d{10,}$/)) {
			return v.replace(/^7/,"+7");
		} else if (v.match(/^00\d{9,}$/)) {
			return v.replace(/^00/,"+");
		}
		return "error";
	},

	/**
	 * Function: UserAuth.check_field
	 */
	check_field: function(errors,key,min,max,regexp) {
		if (!(key in this.fields)) {
			errors[key]=this.F("Views","L","UserAuth/"+key,"missing",3) || this.F("Views","L","UserAuth","missing");
			return;
		}

		if (key.match(/date/)) {
			var arr=this.fields[key].match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
			if (arr) this.fields[key]=arr[3]+"."+arr[2]+"."+arr[1];
		}
		if (key=="email" && !regexp) regexp=/^[\w\-\.\_]+@([\w\-]+\.)+\w+$/;

		if (min && this.fields[key].length<min) {
			errors[key]=this.F("Views","L","UserAuth/"+key,"short",3) || this.F("Views","L","UserAuth","short");
		} else if (max && this.fields[key].length>max) {
			errors[key]=this.F("Views","L","UserAuth/"+key,"long",3) || this.F("Views","L","UserAuth","long");
		} else if (regexp && !this.fields[key].match(regexp)) {
			errors[key]=this.F("Views","L","UserAuth/"+key,"symbols",3) || this.F("Views","L","UserAuth","symbols");
		}
	},

	/**
	 * Function: UserAuth.register_check
	 */
	register_check: function(to_check) {
		return this.F("UserAuth","any_check",to_check,this.fields);
	},

	join_checks: function(prefix,conf,obj) {
		var c=conf[prefix];
		if (!c) return obj;
		var r={};
		for (var k in obj) r[k]=obj[k];
		for (var k in c) r[k]=c[k];
		return r;
	},

	any_check: function(to_check,fields) {
		var errors={};
		for (var k in to_check) {
			if (!to_check[k]) continue;
			
			if (to_check[k].min && (!fields[k] || fields[k].length<to_check[k].min)) {
				errors[k]=this.F("Views","L","controllers/Cart","Too short",1);
			}
			if (to_check[k].max && fields[k] && fields[k].length>to_check[k].max) {
				errors[k]=this.F("Views","L","controllers/Cart","Too long",1);
			}
			if (!errors[k] && to_check[k].regexp && !fields[k].match(to_check[k].regexp)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
			switch (to_check[k].type) {
				case "phone":
					if (!errors[k] && !fields[k].match(/^[0-9\-\+\(\)\/ \#]+$/)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
					break;
				case "email_exists":
					var u=this.site.models.User.List("get_of_login",{login:fields[k]});
					if (u.length) errors.login=this.F("Views","L","controllers/Cart","Email already exists",1);
				case "email":
					if (!errors[k] && !fields[k].match(/^\w.*@([\w\-]+\.)+\w+$/)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
					break;
				case "password1":
					if (!errors[k] && !fields[k].match(/^[\w!@,.\/;':\"\[\]\{\}\#]+$/)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
					break;
				case "password2":
					if (!errors[k] && fields.password1!=fields[k]) errors[k]=this.F("Views","L","controllers/Cart","Passwords differ",1);
					break;
				case "none":
					break;
				default:
					if ((k in fields) && !errors[k] && !fields[k].match(/^[a-zA-Z0-9а-яА-Я\/\,\;\(\)#\!\+@\.\-_ ]*$/)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
					break;
//				default:
//					if (!fields[k].match(/^[a-zA-Z0-9а-яА-Я\.\-_ ]+$/)) errors[k]=this.F("Views","L","controllers/Cart","Incorrect characters",1);
			}
		}
		var flag=0;

		for (var k in errors) flag=1;
		if (flag) return errors;
		return undefined;
	},

	mk_password: function(length,strong) {
		var ret="";
		if (!strong) ret+=MK_PASSWORD.pre[Math.floor(Math.random()*MK_PASSWORD.pre.length)];
		if (!length) length=6;
		var str=MK_PASSWORD[strong?"strong":"easy"];
		var len=str.length;
		for (var i=0;i<length;i++) {
			var a=Math.floor(Math.random()*len);
			ret+=str.substr(a,1);
		}
		return ret;
	},


}];

