var BASESID="0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
exports.add=[{
	 _type:"model_methods",
	_config: {name:"Cart"},

	/**
	 * Class: models.Cart
	 */

	/**
	 * Method: Cart.InitForUser
	 *
	 * Parameters:
	 *		user_id typeof Number
	 */
	InitForUser: function(user_id) {
		this.user_id=user_id;
		this._InitAny();
		this.CopyFieldsFromPrevious();
	},

	/**
	 * Method: Cart.InitForAnonymous
	 *
	 * Parameters:
	 *		
	 * Returns:
	 *		sid typeof String		- Session identifier, used by cookie
	 */
	InitForAnonymous: function() {
		var sid="";
		for (var i=0;i<48;i++) sid+=BASESID.substr(Math.round(Math.random()*(BASESID.length-1)),1);
		this.sid=sid;
		this._InitAny();

		var rr=this.GetRR();
		var exp=new Date(new Date().getTime() + 30*24*60*60*1000);
		rr.res.cookie("marketsid",sid,exp,'/',rr.site.cookie_domain);
		return sid;
	},
	
	/**
	 * Method: Cart._InitAny
	 *		Initializes leftovers. Should not be called directly.
	 */
	_InitAny: function() {
		var rr=this.GetRR();
		this.calc_summ=0;
		this.calc_items=0;
		this.calc_amount=0;
		this.real_payed=0;
		this.state_id=rr.site.models.CartState.List("get_by_code",{code:"fill"})[0].id;
		this.payment_method_id=null;
	},

	/**
	 * Method: Cart.AfterFetchCustom
	 */
	AfterFetchCustom: function() {
	},

	/**
	 * Method: Cart.FetchItems
	 *
	 * Parameters:
	 *
	 */
	FetchItems: function() {
		if (this.items)	return;
		var rr=this.GetRR();
		if (this.id) this.items=rr.site.models.CartItem.List("list_of_cart",{cart_id:this.id}); else this.items=[];
//		for (var i=0;i<this.items.length;i++) this.items[i].summ=this.items[i].price*this.items[i].amount;
		this._to_delete=[];
		this._to_save=[];
//		throw this.items;
	},

	/**
	 * Method: Cart.FetchItemsFull
	 *
	 * Parameters:
	 *
	 */
	FetchItemsFull: function() {
		var rr=this.GetRR();
		this.FetchItems();
		for (var i=0;i<this.items.length;i++) {
			this.FillUpItem(rr,this.items[i]);
		}
	},

	FillUpItem: function(rr,m) {
		if (!rr) rr=this.GetRR();
		if (m.market_item_id) {
			m.market_item=rr.site.models.MarketItem.Get(m.market_item_id);
			m.market_item_name=m.market_item.name;
			m.market_item_code=m.market_item.code;
		} else {
			// TODO
		}
	},

	/**
	 * Method: Cart.Authorize
	 *
	 * Parameters:
	 *		user_id typeof Integer		- User id
	 */
	Authorize: function(user_id) {
		if (this.user_id) throw new Error("Cart already authorized!");
		if (!user_id) throw new Error("Empty user_id parameter");
		this.user_id=user_id;
		this.sid=null;
		this.CopyFieldsFromPrevious();
		this.RecalcDiscounts();
	},

	/**
	 * Method: CopyFieldsFromPrevious
	 */
	CopyFieldsFromPrevious: function() {
		var t=this;
		var rr=this.GetRR();
		var old;
		old=rr.site.models.Cart.List("get_previous_of_user",{user_id:this.user_id,cart_id:this.id})[0];
		if (!old) return;
		for (var k in old) {
			if (!(k.match(/^address_/))) continue;
			if (!this[k] && old[k]) t[k]=old[k];
		}
	},
	/**
	 * Method: Cart.GetAmountOf
	 *
	 * Parameters:
	 *		options typeof Object
	 *		options.market_item_id typeof Integer	- optional, item id
	 *		options.other_ftype typeof String		- optional, type of external item
	 *		options.other_fid typeof Integer		- optional, id of external item
	 *
	 */
	GetAmountOf: function(options) {
		this.FetchItems();
		if (options.market_item_id) {
			for (var i=0;i<this.items.length;i++) if (this.items[i].market_item_id==options.market_item_id) return this.items[i].amount;
		} else {
			for (var i=0;i<this.items.length;i++) if (this.items[i].other_ftype==options.other_ftype && this.items[i].other_fid==options.other_fid) return this.items[i].amount;
		}
		return 0;
	},

	/**
	 * Method: Cart.Add
	 */
	Add: function(options) {
		this.FetchItems();
		//throw "Now - "+this.GetAmountOf(options);
		options.amount*=1;
		options.amount+=this.GetAmountOf(options);
		this.Set(options);
	},

	/**
	 * Method: Empty
	 */
	Empty: function() {
		this.FetchItems();
		while (this.items.length) {
			this._to_delete.push(this.items.splice(0,1)[0]);
		}
		//if (!no_after_set) this.AfterSetCustom();
		this.AfterSetCustom();
		this.Recalc();
	},
	
	/**
	 *
	 */
	DiscountCalcCustom: function(options) {
		return options;
	},
	

	RecalcDiscounts: function() {
		this.FetchItemsFull();
		for (var i=0;i<this.items.length;i++) {
			var item=this.items[i];
			var ret=this.DiscountCalcCustom(item);
			if (ret.price!=item.price) {
				item.price=ret.price;
				this._to_save.push(item);
			}
		}
		this.Recalc();
	},

	/**
	 * Method: Cart.Set
	 *
	 * Parameters:
	 *		options typeof Object
	 *		options.amount typeof Integer			- Count of items added
	 *		options.price typeof Number				- Price of one item
	 *		options.market_item_id typeof Integer	- optional, item id
	 *		options.other_ftype typeof String		- optional, type of external item
	 *		options.other_fid typeof Integer		- optional, id of external item
	 *
	 */
	Set: function(options,no_after_set) {
		options=this.DiscountCalcCustom(options);
		var rr=this.GetRR();
		this.FetchItemsFull();
		options.amount*=1;
		if (options.amount==0) {
			if (options.market_item_id) {
				for (var i=0;i<this.items.length;i++) if (this.items[i].market_item_id==options.market_item_id) this._to_delete.push(this.items.splice(i,1)[0]);
			} else {
				for (var i=0;i<this.items.length;i++) if (this.items[i].other_ftype==options.other_ftype && this.items[i].other_fid==options.other_fid) this._to_delete.push(this.items.splice(i,1)[0]);
			}
		} else {
			var flag=0;
			if (options.market_item_id) {
				for (var i=0;i<this.items.length;i++) if (this.items[i].market_item_id==options.market_item_id) {flag=1;this.items[i].amount=options.amount;this.items[i].price=options.price;this._to_save.push(this.items[i]);}
			} else {
				for (var i=0;i<this.items.length;i++) if (this.items[i].other_ftype==options.other_ftype && this.items[i].other_fid==options.other_fid) {flag=1;this.items[i].amount=options.amount;this._to_save.push(this.items[i]);}
			}
			if (!flag) {
				var rr=this.GetRR();
				var m=rr.site.models.CartItem.Create();
				for (var k in options) m[k]=options[k];
				m.cart_id=this.id;
				this.FillUpItem(rr,m);
				this.items.push(m);
				this._to_save.push(m);
			}
		}
		if (!no_after_set) this.AfterSetCustom();
		this.Recalc();
	},
	/**
	 *
	 */
	AfterSetCustom: function() {

	},

	/**
	 * Method: Cart.Recalc
	 */
	Recalc: function() {
         var t = this;
		this.FetchItems();
		this.calc_items=this.items.length;
		this.calc_amount=0;
		this.calc_summ=0;
		for (var i=0;i<this.items.length;i++) {
			this.calc_amount+=this.items[i].amount;
			this.calc_summ+=this.items[i].amount*this.items[i].price;
		}
        //GD: make it to gracia
        this.calc_amount=Math.round(t.calc_amount);
		this.AfterRecalcCustom();
	},
	
	/**
	 * Method: Cart.AfterRecalcCustom
	 */
	AfterRecalcCustom: function() {
	},

	/**
	 * Method: Cart.BeforeCheckoutCustom
	 */
	BeforeCheckoutCustom: function() {

	},
	
	/**
	 * Method: Cart.AfterCheckoutCustom
	 */
	AfterCheckoutCustom: function() {

	},

	/**
	 * Method; Cart.BeforeDeleteCustom
	 */
	BeforeDeleteCustom: function() {
		if (!this.id) return;
		var rr=this.GetRR();
		var items=rr.site.models.CartItem.List("list_of_cart",{cart_id:this.id});
		for (var i=0;i<items.length;i++) items[i].Delete();
	},

	/**
	 * Method: Cart.AfterSaveCustom
	 */
	AfterSaveCustom: function() {
		if (!this.items) return;
		for (var i=0;i<this._to_delete.length;i++) this._to_delete[i].Delete();
		for (var i=0;i<this._to_save.length;i++) {
			if (!this._to_save[i].cart_id) this._to_save[i].cart_id=this.id;
			this._to_save[i].SaveAll();
		}
	},

	/**
	 * Method: Cart.GenerateShortJSON
	 */
	GenerateShortJSON: function() {
		return {
			calc_items:calc_items,
			calc_amount:calc_amount,
			calc_summ:calc_summ,
			
		};
	},

	/**
	 * Method: Cart.GenerateFullJSON
	 */
	GenerateFullJSON: function() {
		this.FetchItems();
		return {
			calc_items:this.calc_items,
			calc_amount:this.calc_amount,
			calc_summ:this.calc_summ,
			items: this.items
		};
	}
}];

