var fs=require('fs');

function safe(t) {
	if (t==undefined) return "--undefined--";
	if (t==null) return "--null--";
	return t.replace(/\&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
}

/**
 * Class: LNViews
 */

/*
 * Constructor: LNViews
 */
function LNViews()
{
	this.paths=['views/'];
	this.cachepaths=['views/'];
//	this.jazz=require('jazz');
	this.compile_or_load=require('./Viewcompiler').compile_or_load;
	this.compiled={};
	return this;
}

/**
 * Method: set_paths
 *
 * Parameters:
 *		arr typeof Array - array of template paths
 *		arrc typeof Array - array of cache paths
 */
LNViews.prototype.set_paths=function(arr,arrc) {
	this.paths=arr;
	this.cachepaths=arrc;
}

/**
 * Method: set_globalspace
 */
LNViews.prototype.set_globalspace=function(space)
{
	this.globalspace=space;
}

/**
 * Method: compile_file
 */
LNViews.prototype.compile_file=function(tmplname)
{
	var i=0;
	var tmpl;
	while (i<this.paths.length && !tmpl) {
		var path=this.paths[i]+tmplname+".html";
		if (this.compiled[path]) {
			tmpl=this.compiled[path];
		} else {
			try {
				var f=new fs.File(path);
				f.open('r');
				var contents=f.read();
				f.close();
				var data;
				try {
					data=contents.toString("utf-8");
				} catch (e2) {
					return "<b>Can not load file "+path+" - not utf-8?</b>";
				}
				try {
					this.compiled[path]=tmpl=this.compile_or_load(data,this.cachepaths[i],tmplname,0,f.stat().mtime);
				} catch(e1) {
					return "<pre class='error'>Template: "+tmplname+"\n<h1>Error thrown by compiler: "+e1+"</h1>"+safe(this.globalspace.Dumper(e1))+"</pre><h1>Template:</h1><pre>"+safe(data)+"</pre>";
				}
			} catch (e) {
				i++;
				continue;
			}
		}
	}
//	throw new Error(tmpl);
	return tmpl;
}

/**
 * Method: process
 *
 * Parameters:
 *		tmplname typeof String	- file name
 *		space typeof Object		- optional
 */
LNViews.prototype.process=function(tmplname,space)
{
	var t = this;
	if (!space) space=this.globalspace;
	var tmpl=this.compile_file(tmplname);
	if (!tmpl) return "<b>[No template "+tmplname+"]</b>";
	if (typeof tmpl != "function") return "<b>[Compilation error "+tmplname+"]</b><br/>"+tmpl;
	var ret;
	try {
		ret=tmpl(this.globalspace,space);
	} catch(e2) {
		var arr = e2.toString().match(/Cannot read property '([\w\d]+)' of undefined/);
		var add_info = '';//
		if (arr&&arr[1]) {
			add_info+='\n';
			var arr2 = tmpl.toString().match(new RegExp('(cspace.[\\.\\w\\d\\_]+.'+arr[1]+')','g'));
			if (arr2.length) arr2.forEach(function(el){
				try { eval(el.replace('cspace','t.globalspace')); } catch(e) {
					add_info += 'проверить : ' + el.replace('cspace.','') + '\n';
				}
			});
		}
		return "<pre class='error'>Template: "+tmplname+"\n<h1>Error thrown by exec: "+e2+"</h1>"+safe(this.globalspace.Dumper(e2))+add_info+"</pre>";
	}
	return ret;
}

/**
 * Method: apply
 *
 * Parameters:
 *		tmplname typeof String	- file name
 *		space typeof Object		- optional
 */
LNViews.prototype.apply=function(tmplcode,space)
{
	var ret;
	try {
		var tmpl;
		var path=this.paths[0]+'---'+tmplcode;
		if (this.compiled[path]) {
			tmpl=this.compiled[path];
		} else {
			this.compiled[path]=tmpl=this.compile_or_load(tmplcode);
		}
		ret=tmpl(this.globalspace,space);
	} catch(e) {
		return "<pre class='error'>Template: "+tmplcode+"\nError: "+this.globalspace.Dumper(e)+"</pre>";
	}
	return ret;
}

/**
 * Method: client_side
 *
 * Parameters:
 */
LNViews.prototype.client_side=function(space,folder)
{
	var fh=this.recurse_get_folders("client-side/"+folder);
	var f=new fs.File(space.F("Files","uploads_folder",1)+"views-"+folder.replace(/\//g,"__")+".js");
/*	if (f.exists() && f.stat()[9]>fh.date) {
		f.open("r");
		var ret=f.read().toString("utf-8");
		f.close();
		space.page.responseHeaders["Content-Type"]="text/javascript";
		return ret;
	}*/
	var fh2=this.build_client_side(space,fh);
	
	var ret="";
	ret+="/* folder: "+folder+" */\n";
	ret+="/*\n	Tree:\n	"+fh.folders.join("\n	")+"\n*/\n";

	ret+="/*\n	Errors compiling view templates:\n";
	for (var fname in fh2.errors) {
		ret+="	TEMPLATE "+fname+":\n";
		ret+="		"+(fh2.errors[fname]||"?").toString().replace(/\n/g,"\n\t\t");
	}
	ret+="*/\n";
	ret+="/*\n	Cached view templates list:\n";
	for (var fname in fh2.files) {
		ret+="	"+fname+"\n";
	}
	ret+="*/\n";
	for (var fname in fh2.files) {
		a=fh2.files[fname].replace(/^data=/,"");
		ret+="lnrr.views.templates['"+fname.replace(/client-side\//,"")+"']="+a+";\n";
	}
	try {
		f.open("w");
		f.write(ret);
		f.close();
	} catch (e) {
		throw new Error("Can not save file "+f.toString()+" - "+e);
	}
	return ret;
}
/**
 * Method: build_client_side
 *
 */
LNViews.prototype.build_client_side=function(space,fh)
{
	var t=this;
	var fh2={errors:{},files:{}};
//	return fh2;
	for (var file in fh.files) {
		try {
			fh2.files[file]=t.build_client_side_file(file);
		} catch(e) {
			fh2.errors[file]=e;
		}
	}
	return fh2;
}

/**
 * Method: build_client_side_file
 *
 */
LNViews.prototype.build_client_side_file=function(tmplname)
{
	var i=0;
	var tmpl;
	var f;
	var max_date;
	while (!f) {//i<this.paths.length && !tmpl) {
		var path=this.paths[i]+tmplname+".html";
		f=new fs.File(path);
		if (!f.exists()) {
			i++;
			if (i==this.paths.length) throw "File not found, like "+path;
			f=undefined;
		}
	}
	if (!f) throw new Error("File not found - "+filename);
	f.open('r');
	var contents=f.read();
	f.close();
	var data=contents.toString("utf-8");
	tmpl=this.compile_or_load(data,this.cachepaths[i],tmplname,1,max_date);
	return tmpl;
}

/**
 * Method: recurse_get_folders
 */
LNViews.prototype.recurse_get_folders=function(folder,r)
{
	if (!r) r={date:undefined,folders:[],files:{}};
	var subdirs;
	for (var i=0,s=this.paths.length;i<s;i++) {
		var d=new fs.Directory(this.paths[i]+folder);
		if (!d.exists()) continue;
		var motime=d.stat().mtime;
		if (r.date==undefined || motime>r.date) r.date=motime;
		if (!subdirs) subdirs={};
		var dirs=d.listDirectories();
		for (var dn=0,ds=dirs.length;dn<ds;dn++) {
			var x=dirs[dn];
			if (x[0]==".") continue;
			subdirs[x]=1;
		}
		var files=d.listFiles();
		for (var fin=0,fis=files.length;fin<fis;fin++) {
			var f=files[fin];
			var arr=f.match(/^(.*)\.html$/);
			if (!arr) continue;
			r.files[folder+"/"+arr[1]]=1;
		}
	}
	if (subdirs) {
		r.folders.push(folder);
		for (var k in subdirs) {
			this.recurse_get_folders(folder+"/"+k,r);
		}
	}
	return r;
}

/*****************************************************************************/


/*****************************************************************************/
exports.LNViews=LNViews;


/*****************************************************************************/
