select
	a.attname as name,
	pg_catalog.format_type(a.atttypid, a.atttypmod) as datatype_full,
	pg_catalog.format_type(a.atttypid,null) as datatype,
	(
		select substring(pg_catalog.pg_get_expr(d.adbin, d.adrelid) for 128)
		from pg_catalog.pg_attrdef d
	  	where d.adrelid = a.attrelid and d.adnum = a.attnum and a.atthasdef
	) as default_value,
	case when a.attnotnull='t' then 1 else 0 end as not_null,
	a.attnum
from pg_catalog.pg_attribute a
where
	a.attrelid=:id and
	a.attnum > 0 and
	not a.attisdropped
order by a.attnum

