select
	u.id,
	u.login,
	u.first_name,
	u.second_name,
	u.last_name,
	u.calc_full_name,
	u.enabled,
	u.email,
	u.calc_no_roles,
	u.sex_id,
	to_char(u.date_birth,'DD.MM.YYYY') as date_birth,
	to_char(u.date_last_page,'DD.MM.YYYY HH24:MI') as date_last_page,
	case when u.date_last_page is null or u.date_last_page<now() - interval '5 minutes' then 1 else 0 end as date_last_page_needs_update,
	u.im_icq,
	u.im_jabber,
	u.im_msn,
	u.im_skype,
	u.phone,
	u.avatar_id,
	f.file_folder_id as avatar_file_folder_id,
	f.ext as avatar_ext,
	us.id as user_session_id,
	case when us.date_exp<now() + interval '12 hours' then 1 else 0 end as date_exp_needs_update
from
	Tusers u
	left join Tfiles f on u.avatar_id=f.id,
	Tuser_sessions us
where
	us.sid=:sid and
	u.id=us.user_id
