create table Tdb_version(
	version integer not null
);
insert into Tdb_version (version) values (1);

create table Tuser_agents (
	id					bigserial primary key,
	name				varchar(1000) not null,
	is_robot			integer not null,
	device_type			integer not null
);

create table Tanon_cookies (
	id					bigserial primary key,
	date_cr				timestamp default now() not null,
	user_agent_id		bigint not null,
	ip					inet not null,
	sid					varchar(256) not null unique,
	foreign key			(user_agent_id) references Tuser_agents
);

/**************************************************************
 *	Languages
 *
 */
create table Tl10n (
	id					bigserial primary key,
	code				varchar(16) not null unique,
	name				varchar(160) not null,
	is_default			integer not null
);

/**************************************************************
 *	File types
 */
create table Tmediums (
	id					bigserial primary key,
	code				varchar(16) not null unique,
	ordering			bigserial not null unique,
	name				varchar(128) not null unique
);

/**************************************************************
 *	File types
 */
create table Tfile_types (
	id					bigserial primary key,
	code				varchar(16) not null unique,
	name				varchar(128) not null
);

/**************************************************************
 * File folders
 */
create table Tfile_folders (
	id					bigserial primary key,
	code				varchar(64) unique,
	parent_id			bigint null,
	user_cr_id			bigint not null,
	date_cr				timestamp default now() not null,
	date_mo				timestamp default now() not null,
	ordering			bigserial unique not null,
	foreign key			(parent_id) references Tfile_folders
);
insert into Tfile_folders (code,user_cr_id) values ('avatars',1);
insert into Tfile_folders (code,user_cr_id) values ('galleries',1);
insert into Tfile_folders (code,user_cr_id) values ('news',1);
insert into Tfile_folders (code,user_cr_id) values ('images',1);
insert into Tfile_folders (code,user_cr_id) values ('market_items',1);

create table Tfile_folders_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128) not null,
	foreign key			(fid_id) references Tfile_folders,
	foreign key			(l10n_id) references Tl10n
);
create unique index Ifile_folders_l10n on Tfile_folders_l10n (fid_id,l10n_id);

create or replace function Ffile_path(file_folder_id in bigint) returns varchar as $$
declare
	cid bigint;
	cid2 bigint;
	path varchar;
	tmp varchar;
begin
	path:='';
	cid:=file_folder_id;
	while cid is not null loop
		select parent_id,code into cid2,tmp from Tfile_folders where id=cid;
		if tmp is null then tmp:=cid; end if;
		path:=tmp||'/'||path;
		cid:=cid2;
	end loop;
	return '/'||path;
end;
$$ language plpgsql;
/**************************************************************
 * Files
 */
create table Tfiles (
	id					bigserial primary key,
	type_id				bigint not null,
	file_folder_id		bigint not null,
	user_cr_id			bigint null,
	date_cr				timestamp default now() not null,
	date_mo				timestamp default now() not null,
	orig_filename		varchar(256) not null,
	ext					varchar(16),
	width				integer,
	height				integer,
	filesize			integer,
	seconds				integer,
	ordering			bigserial unique not null,
	foreign key			(type_id) references Tfile_types,
	foreign key			(file_folder_id) references Tfile_folders
);

create table Tfiles_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128) not null,
	foreign key			(fid_id) references Tfiles,
	foreign key			(l10n_id) references Tl10n
);
create unique index Ifiles_l10n on Tfiles_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tsexes (
	id					bigserial primary key,
	code				varchar(16) not null unique
);

create table Tsexes_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128) not null,
	foreign key			(fid_id) references Tsexes,
	foreign key			(l10n_id) references Tl10n
);
create unique index Isexes_l10n on Tsexes_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tusers (
	id					bigserial primary key,
	login				varchar(64) not null unique,
	first_name			varchar(64),
	second_name			varchar(64),
	last_name			varchar(64),
	calc_full_name		varchar(256),
	password			varchar(64),
	enabled				integer not null,
	email				varchar(64),
	calc_no_roles		integer not null,
	sex_id				bigint,
	date_cr				timestamp default now() not null,
	date_birth			date,
	im_icq				varchar(16),
	im_jabber			varchar(48),
	im_msn				varchar(48),
	im_skype			varchar(48),
	im_telegram			varchar(48),
	phone				varchar(48),
	date_last_page		timestamp,
	avatar_id			bigint,
	about				text,
	regsid				varchar(64) unique,
	prefer_l10n_id		bigint,
	foreign key			(sex_id) references Tsexes,
	foreign key			(avatar_id) references Tfiles,
	foreign key			(prefer_l10n_id) references Tl10n
);

insert into Tusers (login,first_name,calc_full_name,password,enabled,calc_no_roles) values ('admin','Administrator','Administrator','#password#',1,0);

alter table Tfiles add foreign key (user_cr_id) references Tusers;
alter table Tfile_folders add foreign key (user_cr_id) references Tusers;

/**************************************************************
 *
 */
create table Troles (
	id					bigserial primary key,
	code				varchar(32) not null unique
);
insert into Troles (code) values ('pages');
insert into Troles (code) values ('articles');
insert into Troles (code) values ('design');
insert into Troles (code) values ('settings');
insert into Troles (code) values ('files');
insert into Troles (code) values ('market');
insert into Troles (code) values ('guestbooks');
insert into Troles (code) values ('users');
insert into Troles (code) values ('admin_start');
insert into Troles (code) values ('seomp');

create table Troles_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128) not null,
	foreign key			(fid_id) references Troles,
	foreign key			(l10n_id) references Tl10n
);
create unique index Iroles_l10n on Troles_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tusers_enrolled (
	id					bigserial primary key,
	user_id				bigint not null,
	role_id				bigint not null,
	foreign key			(user_id) references Tusers,
	foreign key			(role_id) references Troles
);
create unique index Iusers_enrolled on Tusers_enrolled (user_id,role_id);
create index Iusers_enrolled1  on Tusers_enrolled (user_id);

/**************************************************************
 *
 */
create table Tuser_sessions (
	id					bigserial primary key,
	user_id				bigint not null,
	sid					varchar(48) not null unique,
	date_exp			timestamp not null,
	foreign key			(user_id) references Tusers
);
create index Iuser_sessions1 on Tuser_sessions (date_exp);

/**************************************************************
 *
 */
create table Ttemplates (
	id					bigserial primary key,
	code				varchar(128) unique,
	name				varchar(128) not null unique
);

/**************************************************************
 *
 */
create table Ttemplate_place_types (
	id					bigserial primary key,
	code				varchar(16) not null unique,
	name				varchar(128) not null unique
);

/**************************************************************
 *
 */
create table Ttemplate_places (
	id					bigserial primary key,
	template_id			bigint not null,
	place_type_id		bigint not null,
	ordering			bigserial unique not null,
	code				varchar(64) not null,
	name				varchar(64),
	admin_height		integer default 20 not null,
	templatewide		integer default 0 not null,
	preprocess			integer default 0 not null,
	href				varchar(1024),
	foreign key			(template_id) references Ttemplates,
	foreign key			(place_type_id) references Ttemplate_place_types
);
create unique index Itemplate_places on Ttemplate_places (template_id,code);

create table Ttemplate_places_templatewide (
	id					bigserial primary key,
	place_id			bigint not null,
	l10n_id				bigint not null,
	medium_id			bigint not null,
	body				text,
	foreign key			(place_id) references Ttemplate_places,
	foreign key			(l10n_id) references Tl10n,
	foreign key			(medium_id) references Tmediums
);
create unique index Itemplate_places_templatewide on Ttemplate_places_templatewide (place_id,medium_id,l10n_id);

/**************************************************************
 *
 */
create table Tpages (
	id					bigserial primary key,
	parent_id			bigint,
	alias				varchar(128) not null unique,
	template_id			bigint not null,
	prerun				varchar(2048),
	prerun_param		varchar(2048),
	show_in_nav			integer default 1 not null,
	ordering			bigserial not null unique,
	role_id				bigint null,
	hide_anon			integer default 0 not null,
	hide_reg			integer default 0 not null,
	cssclass			varchar(64),
	foreign key			(parent_id) references Tpages,
	foreign key			(template_id) references Ttemplates,
	foreign key			(role_id) references Troles
);
create index Ipages1 on Tpages (parent_id);
create unique index Ipages2 on Tpages (parent_id,ordering);

create table Tpages_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	title				varchar(2048),
	meta_description	varchar(2048),
	meta_keywords		varchar(2048),
	disabled_l10n		integer default 0 not null,
	foreign key			(fid_id) references Tpages,
	foreign key			(l10n_id) references Tl10n
);
create unique index Ipages_l10n on Tpages_l10n (fid_id,l10n_id);
/**************************************************************
 *
 */
create table Tpage_blocks (
	id					bigserial primary key,
	page_id				bigint not null,
	l10n_id				bigint not null,
	place_id			bigint not null,
	medium_id			bigint not null,
	body				text,
	foreign key			(page_id) references Tpages,
	foreign key			(l10n_id) references Tl10n,
	foreign key			(place_id) references Ttemplate_places
);
create unique index Ipage_blocks on Tpage_blocks (page_id,l10n_id,medium_id,place_id);

/**************************************************************
 *
 */
create table Trewrites (
	id					bigserial primary key,
	regexp				varchar(256) not null unique,
	fields				varchar(128),
	page_id				bigint,
	controller_name		varchar(128),
	controller_mode		varchar(128),
	signature			varchar(128),
	foreign key			(page_id) references Tpages
);

/**************************************************************
 *
 */
create table Tmail_templates (
	id					bigserial primary key,
	code				varchar(256) not null unique,
	name				varchar(256),
	default_from		varchar(256),
	default_to			varchar(256),
	signature			varchar(128)
);

create table Tmail_templates_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	subject				varchar(1024),
	body				text,
	foreign key			(fid_id) references Tmail_templates,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imail_templates_l10n on Tmail_templates_l10n (fid_id,l10n_id);
/**************************************************************
 *
 */
create table Tarticle_categories (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	groupcode			varchar(32),
	has_abstract		integer not null,
	has_image1			integer not null,
	has_image2			integer not null,
	has_gallery			integer not null,
	image1_id			bigint,
	image2_id			bigint,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles
);
create index Tarticle_categories_groupcode_key on Tarticle_categories (groupcode);

create table Tarticle_categories_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(64) not null,
	abstract			text,
	body				text,
	foreign key			(fid_id) references Tarticle_categories,
	foreign key			(l10n_id) references Tl10n
);
create unique index Iarticle_categories_l10n on Tarticle_categories_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tarticles (
	id					bigserial primary key,
	date_cr				timestamp default now() not null,
	date_use			date,
	date_show_start		date,
	date_show_end		date,
	category_id			bigint not null,
	calc_code			varchar(256) not null unique,
	image1_id			bigint,
	image2_id			bigint,
	image3_id			bigint,
	folder_id			bigint,
	enabled				integer not null,
	featured			integer default 0 not null,
	user_cr_id			bigint,
	foreign key			(category_id) references Tarticle_categories,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles,
	foreign key			(image3_id) references Tfiles,
	foreign key			(folder_id) references Tfile_folders,
	foreign key			(user_cr_id) references Tusers
);

create table Tarticles_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(4000) not null,
	abstract			text,
	body				text,
	disabled_l10n		integer default 0 not null,
	title				varchar(4000),
	meta_abstract		varchar(4000),
	meta_description	varchar(4000),
	foreign key			(fid_id) references Tarticles,
	foreign key			(l10n_id) references Tl10n
);
create unique index Iarticles_l10n on Tarticles_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tcustom_navs (
	id					bigserial primary key,
	code				varchar(128) not null unique,
	name				varchar(128) not null unique,
	can_href			integer not null,
	can_image			integer not null,
	can_description		integer not null
);

/**************************************************************
 *
 */
create table Tcustom_nav_items (
	id					bigserial primary key,
	nav_id				bigint,
	parent_id			bigint,
	image_id			bigint,
	href				varchar(256),
	page_id				bigint,
	enabled				integer default 1 not null,
	ordering			bigserial not null unique,
	foreign key			(nav_id) references Tcustom_navs,
	foreign key			(image_id) references Tfiles,
	foreign key			(page_id) references Tpages,
	foreign key			(parent_id) references Tcustom_nav_items
);
/*create unique index Icustom_nav_items on Tcustom_nav_items (nav_id,parent_id,name);*/

create table Tcustom_nav_items_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128),
	description			text,
	foreign key			(fid_id) references Tcustom_nav_items,
	foreign key			(l10n_id) references Tl10n
);
create unique index Icustom_nav_items_l10n on Tcustom_nav_items_l10n (fid_id,l10n_id);

/**************************************************************
 *	Content boxes groups
 */
create table Tcontent_boxes_groups (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	name				varchar(256) not null unique
);

/**************************************************************
 *	Content boxes
 */
create table Tcontent_boxes (
	id					bigserial primary key,
	group_id			bigint not null,
	ordering			bigserial not null unique,
	image_id			bigint,
	image2_id			bigint,
	enabled				integer not null,
	foreign key			(group_id) references Tcontent_boxes_groups,
	foreign key			(image_id) references Tfiles,
	foreign key			(image2_id) references Tfiles
);

create table Tcontent_boxes_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	override_image_id	bigint,
	name				varchar(1024),
	name2				varchar(1024),
	name3				varchar(1024),
	url					varchar(1024),
	foreign key			(fid_id) references Tcontent_boxes,
	foreign key			(l10n_id) references Tl10n,
	foreign key			(override_image_id) references Tfiles
);
create unique index Icontent_boxes_l10n on Tcontent_boxes_l10n (fid_id,l10n_id);

/**************************************************************
 *	Guestbooks
 */
create table Tguestbooks (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	name				varchar(256) not null unique,
	premoderated		integer not null,
	users_can_post		integer not null,
	mail_template1_id	bigint,
	mail_template2_id	bigint,
	foreign key			(mail_template1_id) references Tmail_templates,
	foreign key			(mail_template2_id) references Tmail_templates
);

/**************************************************************
 *	Guestbook messages
 */
create table Tguestbook_messages (
	id					bigserial primary key,
	guestbook_id		bigint not null,
	user_q_name			varchar(128) not null,
	user_q_phone		varchar(128),
	user_q_email		varchar(128),
	user_q_avatar_id	bigint,
	user_a_id			bigint,
	question			text,
	answer				text,
	date_question		timestamp default now(),
	date_answer			timestamp,
	moderated			integer not null,
	foreign key			(guestbook_id) references Tguestbooks,
	foreign key			(user_q_avatar_id) references Tfiles,
	foreign key			(user_a_id) references Tusers
);

/**************************************************************
 *	Forms
 */
create table Tforms (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	name				varchar(128) not null,
	fields_not_null		text,
	func_error			varchar(128),
	func_ok				varchar(1024),
	mail_template1_id	bigint,
	mail_template2_id	bigint,
	foreign key			(mail_template1_id) references Tmail_templates,
	foreign key			(mail_template2_id) references Tmail_templates
);



insert into Tusers_enrolled (user_id,role_id) select u.id,r.id from Tusers u,Troles r;


/**************************************************************
 *	spreadsheets
 */
create table Tspreadsheets (
	id					bigserial primary key,
	name				varchar(1000),
	file_id				bigint,
	date_cr				timestamp,
	generator			varchar(64),
	fid					bigint not null
);

create table Tworksheets (
	id					bigserial primary key,
	spreadsheet_id		bigint not null,
	name				varchar(1000),
	ordering			bigserial unique,
	foreign key			(spreadsheet_id) references Tspreadsheets
);

create table Tcells (
	id					bigserial primary key,
	worksheet_id		bigint not null,
	x					integer not null,
	y					integer not null,
	value				text,
	foreign key			(worksheet_id) references Tworksheets
);



create table Tkvcache (
	id bigserial primary key,
	key varchar(4000) not null unique,
	value text
);
create or replace function Pcache_set(Lkey in varchar,Lvalue in text) returns void as $$
declare
    Lid bigint;
begin
    select max(id) into Lid from Tkvcache where key=Lkey;
    if Lid is not null then
        update Tkvcache set value=Lvalue where id=Lid;
    else
        insert into Tkvcache (key,value) values (Lkey,Lvalue);
    end if;
end;
$$ language plpgsql;

create table Tadmin_start_widgets (
	id				bigserial primary key,
	controller_name	varchar(64) not null,
	controller_mode	varchar(64) not null,
	fullscreen		integer default 0 not null,
	ordering		bigserial unique
);
insert into Tadmin_start_widgets (controller_name,controller_mode,fullscreen) values ('AdminStart','coolbg',1);
insert into Tadmin_start_widgets (controller_name,controller_mode,fullscreen) values ('AdminStart','wizard',0);



create table Tsocial_networks (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	name				varchar(128) not null,
	can_post			integer not null,
	can_auth			integer not null,
	can_friends			integer not null
);
insert into Tsocial_networks (code,name,can_post,can_auth,can_friends) values ('fb','facebook'		,1,1,1);
insert into Tsocial_networks (code,name,can_post,can_auth,can_friends) values ('vk','vkontakte'		,1,1,1);
insert into Tsocial_networks (code,name,can_post,can_auth,can_friends) values ('ok','odnoklasniki'	,1,1,1);
insert into Tsocial_networks (code,name,can_post,can_auth,can_friends) values ('gmail','gmail'		,0,0,1);
insert into Tsocial_networks (code,name,can_post,can_auth,can_friends) values ('gplus','gplus'		,0,1,1);

create table Tsocial_network_accounts (
	id					bigserial primary key,
	user_id				bigint not null,
	network_id			bigint not null,
	fid					varchar(256),
	access_token		varchar(512),
	fid2				varchar(128),
	export_token		varchar(1000),
	export_info			text,
	export_expires		timestamp,
	do_publish			bigint not null default 0,
	date_cr				timestamp default now() not null,
	date_mo				timestamp,
	foreign key			(user_id) references Tusers,
	foreign key			(network_id) references Tsocial_networks
);
create unique index Isocial_network_accounts1 on Tsocial_network_accounts (network_id,fid);


create table Tsocial_network_account_friends (
	id					bigserial primary key,
	fid					varchar(256) not null,
	email				varchar(256),
	name				varchar(256),
	date_birth			varchar(256),
	avatar_id			bigint,
	sex_id				bigint,
	account_id			bigint not null,
	foreign key			(account_id) references Tsocial_network_accounts,
	foreign key			(avatar_id) references Tfiles,
	foreign key			(sex_id) references Tsexes
);

create table Tpayment_service_invoices (
	id					bigserial primary key,
	date_cr				timestamp default now(),
	date_pay			timestamp default now(),
	ask_remote_addr		varchar(128) not null,
	ask_user_agent_id	bigint,
	amount				numeric(30,2) not null,
	user_id				bigint null,
	module_name			varchar(128),
	module_fid			bigint,
	module_data			text,
	redirect			varchar(1024),
	payed				integer not null,
	service_name		varchar(128),
	service_data		text,
	pay_remote_addr		varchar(128),
	pay_user_agent_id	bigint,
	pay_data			text,
	foreign key			(user_id) references Tusers,
	foreign key			(ask_user_agent_id) references Tuser_agents,
	foreign key			(pay_user_agent_id) references Tuser_agents
);

create table Tpayment_service_errors (
	id					bigserial primary key,
	psi_id				bigint,
	amount				numeric(30,2),
	error				text,
	pay_remote_addr		varchar(128) not null,
	pay_user_agent_id	bigint,
	pay_data			text,
	foreign key			(pay_user_agent_id) references Tuser_agents
);

create table Tdebug_requests (
    id              bigserial primary key,
    login           character varying(128),
    password        character varying(128),
    url             character varying(128),
    date_cr         timestamp without time zone default now() not null,
    params          text,
    user_id         bigint,
    user_agent_id   bigint,
    error           text,
    version         character varying(32),
    charge          double precision,
    foreign key     (user_id) references Tusers,
    foreign key     (user_agent_id) references Tuser_agents
);

create table Tlogin_attempts (
    id              bigserial primary key,
    login           character varying(256),
    password        character varying(256),
    date_cr         timestamp without time zone default now() not null,
    user_ip         character varying(32),
    user_agent_id   bigint not null,
    url             character varying(1000),
    ok              integer not null,
    foreign key     (user_agent_id) references Tuser_agents
);



create table Tseomps (
	id				bigserial primary key,
	code			varchar(128) not null unique,
	name			varchar(128) not null unique,
	name_template	varchar(128),
	page_id			bigint not null,
	page_title				varchar(2048),
	page_meta_description	varchar(2048),
	page_meta_keywords		varchar(2048),
	page_url_suffix			varchar(2048),
	list_title				varchar(2048),
	list_meta_description	varchar(2048),
	list_meta_keywords		varchar(2048),
	foreign key		(page_id) references Tpages
);

create table Tseomp_blocks (
	id					bigserial primary key,
	seomp_id			bigint not null,
	place_id			bigint not null,
	body_src			text,/* text with [city], [reason] blah blah to be replaced */
	body_parsed			text,/* TODO not used */
	foreign key			(seomp_id) references Tseomps,
	foreign key			(place_id) references Ttemplate_places
);
create unique index Iseomp_blocks on Tseomp_blocks (seomp_id,place_id);

create table Tseomp_placeholders (
	id					bigserial primary key,
	seomp_id			bigint not null,
	code				varchar(128) not null,
	image_tpl1			varchar(128),
	image_tpl2			varchar(128),
	image_tpl3			varchar(128),
	image_minsize1		varchar(128),
	image_minsize2		varchar(128),
	image_minsize3		varchar(128),
	foreign key			(seomp_id) references Tseomps
);
create unique index Iseomp_placeholders on Tseomp_placeholders (seomp_id,code);

create table Tseomp_placeholder_values (
	id					bigserial primary key,
	placeholder_id		bigint not null,
	groupname			varchar(128),
	name				varchar(128) not null,
	image1_id			bigint,
	image2_id			bigint,
	image3_id			bigint,
	foreign key			(placeholder_id) references Tseomp_placeholders,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles,
	foreign key			(image3_id) references Tfiles
);

create table Tvisits (
	id					bigserial primary key,
	user_id				bigint,
	anon_id				bigint,
	date_cr				timestamp default now() not null,
	baseurl				varchar(1000) not null,
	params				varchar(1000),
	user_agent_id		bigint not null,
	ip					inet not null,
	foreign key			(user_id) references Tusers,
	foreign key			(anon_id) references Tanon_cookies,
	foreign key			(user_agent_id) references Tuser_agents
);

