/**************************************************************
 *	Market
 *		Categories
 */
create table Tmarket_categories (
	id					bigserial primary key,
	code				varchar(128) not null unique,
	parent_id			bigint,
	image1_id			bigint,
	image2_id			bigint,
	enabled				integer not null,
	ordering			bigserial unique,
	fid					varchar(32),
	is_featured			integer default 0 not null,
	is_new				integer default 0 not null,
	is_recomended		integer default 0 not null,
	has_abstract		integer default 0 not null,
	has_body2			integer default 0 not null,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles,
	foreign key			(parent_id) references Tmarket_categories
);

create table Tmarket_categories_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	abstract			text,
	body				text,
	body2				text,
	title				varchar(4000),
	meta_abstract		varchar(4000),
	meta_description	varchar(4000),
	foreign key			(fid_id) references Tmarket_categories,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_categories_l10n on Tmarket_categories_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		Manufacturers
 */
create table Tmarket_manufacturers (
	id					bigserial primary key,
	code				varchar(128) not null unique,
	image1_id			bigint,
	image2_id			bigint,
	enabled				integer not null,
	ordering			bigserial unique,
	fid					varchar(32),
	is_featured			integer default 0 not null,
	is_new				integer default 0 not null,
	is_recomended		integer default 0 not null,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles
);

create table Tmarket_manufacturers_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	abstract			text,
	body				text,
	body2				text,
	title				varchar(4000),
	meta_abstract		varchar(4000),
	meta_description	varchar(4000),
	foreign key			(fid_id) references Tmarket_manufacturers,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_manufacturers_l10n on Tmarket_manufacturers_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		Field groups, i.e. (for phones) Main section, Screen section, Multimedia support
 */
create table Tmarket_field_groups (
	id					bigserial primary key,
	ordering			bigserial unique,
	enabled				integer not null,
	category_id			bigint,
	foreign key			(category_id) references Tmarket_categories
);

create table Tmarket_field_groups_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	foreign key			(fid_id) references Tmarket_field_groups,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_field_groups_l10n on Tmarket_field_groups_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		View levels - DICTIONARY
 */
create table Tmarket_view_levels (
	id					bigserial primary key,
	code				varchar(32) not null unique
);
insert into Tmarket_view_levels (code) values ('no');
insert into Tmarket_view_levels (code) values ('list');
insert into Tmarket_view_levels (code) values ('short');
insert into Tmarket_view_levels (code) values ('full');

create table Tmarket_view_levels_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	foreign key			(fid_id) references Tmarket_view_levels,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_view_levels_l10n on Tmarket_view_levels_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		Search levels - DICTIONARY
 */
create table Tmarket_search_levels (
	id					bigserial primary key,
	code				varchar(32) not null unique
);
insert into Tmarket_search_levels (code) values ('no');
insert into Tmarket_search_levels (code) values ('basic');
insert into Tmarket_search_levels (code) values ('short');
insert into Tmarket_search_levels (code) values ('advanced');
insert into Tmarket_search_levels (code) values ('full');

create table Tmarket_search_levels_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	foreign key			(fid_id) references Tmarket_search_levels,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_search_levels_l10n on Tmarket_search_levels_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		Field datatypes
 */
create table Tmarket_field_datatypes (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	view_code			varchar(32),
	name				varchar(128) not null unique,
	prefix				varchar(32),
	crsql				varchar(128),
	has_l10n			integer not null,
	has_enum			integer not null
);

/**************************************************************
 *	Market
 *		Fields, i.e. (for phones) Main section: standarts (gsm), type (smartphone), operating system (IOS)
 */
create table Tmarket_fields (
	id					bigserial primary key,
	group_id			bigint not null,
	datatype_id			bigint not null,
	view_level_id		bigint not null,
	search_level_id		bigint not null,
	enabled				integer not null,
	ordering			bigserial not null unique,
	cid					bigint,
	fid					varchar(128),
	foreign key			(group_id) references Tmarket_field_groups,
	foreign key			(datatype_id) references Tmarket_field_datatypes,
	foreign key			(view_level_id) references Tmarket_view_levels,
	foreign key			(search_level_id) references Tmarket_search_levels
);

create table Tmarket_fields_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	foreign key			(fid_id) references Tmarket_fields,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_fields_l10n on Tmarket_fields_l10n (fid_id,l10n_id);

/**************************************************************
 *	Market
 *		item view levels
 */
create table Tmarket_item_view_levels (
	id					bigserial primary key,
	item_id				bigint not null,
	l10n_id				bigint not null,
	view_level_id		bigint not null,
	body				text,
	foreign key			(item_id) references Tmarket_items,
	foreign key			(l10n_id) references Tl10n,
	foreign key			(view_level_id) references Tmarket_view_levels
);
create unique index Imarket_item_view_levels on Tmarket_item_view_levels (item_id,l10n_id,view_level_id);

/**************************************************************
 *
 */
create table Tmarket_field_enums (
	id					bigserial primary key,
	field_id			bigint not null,
	value				varchar(2000),
	foreign key			(field_id) references Tmarket_fields
);
create unique index Imarket_field_enums on Tmarket_field_enums (field_id,value);

create table Tmarket_field_enumsl (
	id					bigserial primary key,
	field_id			bigint not null,
	l10n_id				bigint not null,
	value				varchar(2000),
	foreign key			(field_id) references Tmarket_fields,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_field_enumsl on Tmarket_field_enumsl (field_id,value);

/**************************************************************
 *
 */
create table Tmarket_item_groups (
	id					bigserial primary key,
	enabled				integer not null,
	ordering			bigserial unique
);

create table Tmarket_item_groups_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(128),
	foreign key			(fid_id) references Tmarket_item_groups,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_item_groups_l10n on Tmarket_item_groups_l10n (fid_id,l10n_id);

/**************************************************************
 *
 */
create table Tmarket_items (
	id					bigserial primary key,
	code				varchar(256) not null unique,
	date_cr				timestamp default now(),
	image1_id			bigint,
	image2_id			bigint,
	group_id			bigint,
	category_id			bigint not null,
	manufacturer_id		bigint not null,
	enabled				integer not null,
	in_stock			integer not null,
	price				numeric(30,2),
	ordering			bigserial unique,
	is_featured			integer default 0 not null,
	is_new				integer default 0 not null,
	is_recomended		integer default 0 not null,
	fid					varchar(32),
	fid2				varchar(32),
	file_folder_id		bigint,
	old_price			numeric(30,2),
	base_price			numeric(30,2),
	discount_value		varchar(32),
	in_stock_count		integer,
	foreign key			(group_id) references Tmarket_item_groups,
	foreign key			(category_id) references Tmarket_categories,
	foreign key			(manufacturer_id) references Tmarket_manufacturers,
	foreign key			(image1_id) references Tfiles,
	foreign key			(image2_id) references Tfiles,
	foreign key			(file_folder_id) references Tfile_folders
);

create table Tmarket_items_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	abstract			text,
	body				text,
	body2				text,
	foreign key			(fid_id) references Tmarket_items,
	foreign key			(l10n_id) references Tl10n
);
create unique index Imarket_items_l10n on Tmarket_items_l10n (fid_id,l10n_id);

/**************************************************************
 * Will dynamically add fields
 */
create table Tmarket_item_fields_i (
	id					bigserial primary key,
	item_id				bigint not null unique,
	foreign key			(item_id) references Tmarket_items
);

/**************************************************************
 * Will dynamically add fields
 */
create table Tmarket_item_fields_il (
	id					bigserial primary key,
	item_id				bigint not null unique,
	fid_id				bigint not null,
	foreign key			(item_id) references Tmarket_items,
	foreign key			(fid_id) references Tmarket_items
);

/**************************************************************
 * Will dynamically add fields
 */
create table Tmarket_item_fields_f (
	id					bigserial primary key,
	item_id				bigint not null unique,
	foreign key			(item_id) references Tmarket_items
);

/**************************************************************
 * Will dynamically add fields
 */
create table Tmarket_item_fields_s (
	id					bigserial primary key,
	item_id				bigint not null unique,
	foreign key			(item_id) references Tmarket_items
);

/**************************************************************
 * Will dynamically add fields
 */
create table Tmarket_item_fields_sl (
	id					bigserial primary key,
	item_id				bigint not null unique,
	fid_id				bigint not null,
	foreign key			(item_id) references Tmarket_items,
	foreign key			(fid_id) references Tmarket_items
);

/**************************************************************
 * 
 */
create table Tmarket_item_fields_enums (
	id					bigserial primary key,
	item_id				bigint not null,
	field_id			bigint not null,
	enum_id				bigint not null,
	foreign key			(item_id) references Tmarket_items,
	foreign key			(field_id) references Tmarket_fields,
	foreign key			(enum_id) references Tmarket_field_enums
);

/**************************************************************
 * 
 */
create table Tmarket_item_fields_enumsl (
	id					bigserial primary key,
	item_id				bigint not null,
	field_id			bigint not null,
	enum_id				bigint not null,
	foreign key			(item_id) references Tmarket_items,
	foreign key			(field_id) references Tmarket_fields,
	foreign key			(enum_id) references Tmarket_field_enumsl
);

/**************************************************************
 *
 */
create table Tcart_states (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	cssclass			varchar(32),
	do_calc_money		integer not null
);

create table Tcart_states_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	body				text,
	foreign key			(fid_id) references Tcart_states,
	foreign key			(l10n_id) references Tl10n
);


create table Tcart_payment_methods (
	id					bigserial primary key,
	code				varchar(32) not null unique,
	func				varchar(64),
	prepay				integer not null,
	enabled				integer not null
);

create table Tcart_payment_methods_l10n (
	id					bigserial primary key,
	fid_id				bigint not null,
	l10n_id				bigint not null,
	name				varchar(256),
	body				text,
	foreign key			(fid_id) references Tcart_payment_methods,
	foreign key			(l10n_id) references Tl10n
);

create table Tcarts (
	id					bigserial primary key,
	user_id				bigint,
	sid					varchar(128) unique,
	state_id			bigint not null,
	date_cr				timestamp default now(),
	date_mo				timestamp default now(),
	date_sent			timestamp,
	date_state_change	timestamp,
	payment_method_id	bigint,
	manager_id			bigint,
	calc_summ			numeric(30,2) default 0 not null,
	calc_items			integer default 0 not null,
	calc_amount			integer default 0 not null,
	address_postalindex	varchar(16),
	address_city		varchar(128),
	address_street		varchar(128),
	address_phone		varchar(64),
	address_comments	varchar(4000),
	address_nearest		varchar(128),
	address_flat		varchar(128),
	address_porch		varchar(128),
	address_floor		varchar(128),
	address_password	varchar(128),
	required_change		varchar(128),
	real_payed			numeric(30,2) default 0 not null,
	foreign key			(user_id)			references Tusers,
	foreign key			(state_id)			references Tcart_states,
	foreign key			(payment_method_id)	references Tcart_payment_methods,
	foreign key			(manager_id)		references Tusers
);

create table Tcart_items (
	id					bigserial primary key,
	cart_id				bigint not null,
	market_item_id		bigint,
	cnt					integer default 1 not null,
	other_ftype			varchar(128),
	other_fid			bigint,
	price				numeric(30,2) not null,
	amount				integer not null,
	foreign key			(cart_id) references Tcarts,
	foreign key			(market_item_id) references Tmarket_items,
	constraint Tcart_items_item_or_fid check (market_item_id is null or (other_ftype is null and other_fid is null))
);
create unique index Icart_items1 on Tcart_items (cart_id,market_item_id);
create unique index Icart_items2 on Tcart_items (cart_id,other_ftype,other_fid);


