(function( $, undefined ) {
$.widget("ui.ajajform_accordion",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_accordion
	 *		Создает Аккордион
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_accordion
	 *		options.cssclass typeof String, default 'afw-accordion'	- CSS класс добавляемый к DIV формы
	 *		options.mode typeof String, default 'accordion'		- режим
	 *		options.pages typeof Array, default []			- разделы
	 */
	options: {
		cssclass: "afw-accordion",
		mode: "accordion",
		pages: []/*,
		htmltemplate_accordion: '<div></div>',
		htmltemplate_accordion_handle: '<h3 class=""><a href=""></a></h3>',
		htmltemplate_accordion_body: '<div></div>',
		htmltemplate_tabs: '<div><ul></ul></div>',
		htmltemplate_tabs_handle: '<li><a href="#tabs-1">Nunc tincidunt</a></li>',
		htmltemplate_tabs_body: '<div id="tabs-1"></div>'*/
	},
	i18n: {
		ru: {next:"Далее",prev:"Назад"},
		en: {next:"Next",prev:"Prev"}
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this;
		this["createLayout_"+this.options.mode]();
		for (var i=0;i<this.options.pages.length;i++) {
			this.renderTab(this.options.pages[i]);
		}
	},

	renderTab: function(page) {
		this["addTabHelper_"+this.options.mode](page);
	},

	createLayout_accordion:function() {
		this.el=$("<div></div>").appendTo(this.element).addClass("accordion-resize");
		this.el.accordion();
	},
	addTabHelper_accordion: function(page) {
		var p1 = this.el;
		var p2 = null;

		if (page.xpath) {
			p1 = page.xpath;
			p2 = this.el;
		}

		if (page.name !== null) {
			var pa1 = p1;
			var pa2 = p2;

			if (page.underline) {
				pa1 = $('<div></div>').addClass('underline-container').appendTo(p1, p2);
				pa2 = null;
			}

			var h3=$('<h3><a></a></h3>').appendTo(pa1, pa2);

			$("a",h3).prop("id","#"+page.id);
			$("a",h3).text(page.name);

			if (page.underline) {
				$("<div></div>").addClass("underline").appendTo(pa1, pa2);
			}
		}
		
		$("<div></div>").appendTo(p1, p2).addClass(page.id);
	},

	createLayout_tabs: function() {
		this.tabswidget=$("<div></div>").appendTo(this.element);
		$("<ul></ul>").appendTo(this.tabswidget);
		this.tabswidget.tabs({});
	},
	addTabHelper_tabs: function(page) {
		if (page.hidden) {
			$("<div id='"+page.id+"' class='"+page.id+"' style='display:none;'></div>").appendTo(this.element);
		} else {
			
			$("<li><a href='#"+page.id+"'>"+page.name+"</a></li>").appendTo($("ul",this.tabswidget));
			$("<div id='"+page.id+"'></div>").appendTo(this.tabswidget);
			this.tabswidget.tabs("refresh");
			if (!this.tabswidget.tabs( "option", "active")) this.tabswidget.tabs( "option", "active", 0 );
			//this.tabswidget.tabs( "add","#"+page.id,page.name);
			$("#"+page.id,this.tabswidget).addClass(page.id);
		}
//		$("ul",this.tabswidget).append("<li><a href='#"+page.id+"'>"+page.name+"</a></li>");
//		this.tabswidget.append("<div id='"+page.id+"' class='"+page.id+"'></div>");
	},

	createLayout_wizard:function() {
		var t=this;
		this.createLayout_blocks();
		var b=$("<div class='wizard-buttons'><input type='button' class='prev' value=''/><input type='button' class='next' value=''/></div>").appendTo(this.blocks);
		$(".next",b).attr("value",this.gettext("next")).button().bind("click",function() {
			t.setCurrentTab(t.currentTab()+1);
		});
		$(".prev",b).attr("value",this.gettext("prev")).button({disabled:true}).bind("click",function() {
			t.setCurrentTab(t.currentTab()-1);
		});
		this.options.currentTab=0;
	},
	addTabHelper_wizard: function(page) {
		var cnt=$(".block",this.blocks).length;
		var block=this.addTabHelper_block_helper(page).appendTo(this.blocks);
		if (cnt==0) block.addClass('blockA');
	},

	createLayout_blocks:function() {
		this.blocks=$("<div class='"+this.options.mode+"'></div>").appendTo(this.element);
	},
	
	addTabHelper_blocks: function(page) {
		this.addTabHelper_block_helper(page).appendTo(this.blocks);
	},

	addTabHelper_block_helper: function(page) {
		var block=$("<div class='block'></div>");
		$("<div class='block-name' data-id='"+page.id+"'>"+page.name+"</div>").appendTo(block);
		$("<div id='"+page.id+"' class='"+page.id+" block-body'></div>").appendTo(block);
		if (page.collapsable) {
			block.addClass("block-collapsable");
			$(".block-name",block).bind("click",function() { block.toggleClass("block-collapsed"); });
		}
		if (page.collapsed) block.addClass("block-collapsed");
		return block;
	},

	delTabHelper_blocks: function(page) {
		$(".block-name[data-id='"+page.id+"']").parent().remove();
	},

	addTab: function(tab) {
		this.options.pages.push(tab);
		this.renderTab(tab);
	},

	deleteTab: function(id) {
		var i=0;
		var leftover;
		while (i<this.options.pages.length) if (this.options.pages[i].id==id) leftover=this.options.pages.splice(i,1); else i++;
		if (leftover) this["delTabHelper_"+this.options.mode](leftover[0]);
	},

	tabs: function() {
		return this.options.pages;
	},

	setCurrentTab: function(i) {
		$(".block",this.element).removeClass('blockA');
		$(".block:eq("+i+")",this.element).addClass('blockA');
		this.options.currentTab=i;
		$(".prev",this.element).button("option","disabled",(i==0)).removeClass("ui-state-hover");
		$(".next",this.element).button("option","disabled",(i==this.options.pages.length-1)).removeClass("ui-state-hover");
	},
	currentTab: function() {
		return this.options.currentTab;
	}
});

})( jQuery );
