ajajform_htmltemplates.date={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_date",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_date
	 *		Создает поля выбора даты
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_date
	 *		options.cssclass typeof String, default 'afw-date' 	- CSS класс добавляемый к DIV формы
	 *		options.width typeof integer, default null		- ширина блока
	 *		options.password typeof String, default 'false' 	- пароль
	 *		options.not_null typeof boolean, default false		- обязателен
	 *		options.htmltemplate  typeof HtmlString			- шаблон
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.label typeof String				- заголовок
	 *		options.readonly typeof boolean, default false		- без отправки
	 *		options.dateFormat typeof String, default "dd.mm.yy"	- формат даты
	 */
	options: {
		// \type cssclass
		cssclass: "afw-date",
		// \type text
		value: "",
		// \type boolean
		password: false,

		not_null: false,
		// \type text
		label: "",
		// \type integer
		width: null,
		// \type html
		htmltemplate: null,// '<div class="af-label"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type function
		validate: null,
		dateFormat: "dd.mm.yy",
		readonly: false
	},
	i18n: {
		en: {
			empty: "Field is empty"
		},
		ru: {
			empty: "Пустое поле"
		}
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this.getHtmlTemplate("htmltemplate");
		this.element.append(t);
		this.refreshLabel();
		this.refreshInput();
		this.refreshReadonly();
	},
	refreshReadonly: function() {
		$("input",this.element).prop('readonly',this.options.readonly);
	},
	refreshInput: function() {
		var t=this;
		var i=$("input",this.element);
		if(this.options.placeholder) i.attr('placeholder',this.options.placeholder);
		i.addClass("ui-corner-all af-edit");
		i.width(this.options.width);
		i.val(this.options.value);
		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (!this.options.readonly && !this.options.disabled) {
			
			var date_params = {
				dateFormat: this.options.dateFormat,
				changeMonth: ("changeMonth" in this.options) ? this.options.changeMonth : true,
				changeYear:  ("changeYear" in this.options) ? this.options.changeYear : true
			}
			
			if(this.options.minDate) date_params.minDate = this.options.minDate;
			if(this.options.maxDate) date_params.maxDate = this.options.maxDate;
			
			i.datepicker(date_params);
		}
		i.bind("blur",this,function(e) {
			$(this).removeClass("ui-state-highlight");
			if (t.options.validate && !t.options.readonly ) {
				e.data.validate();
			}
		});
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var inp=$("input",this.element);
		var r;
		if (vd) r=vd(inp.val());
		if (!r) {
			if (inp.val().length==0 && this.options.not_null) r=this.gettext("empty");
		}
		this.refreshError(r);
		if (!r) return false;
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		return r?true:false;
	},
	postvalue: function(r) {
		r[this.options.name]=$("input",this.element).val();
	}
});

})( jQuery );
