var global_ajajform_file_group_id;
var global_ajajform_file_group_id_dialog;
ajajform_htmltemplates.file_group_id={
		htmltemplate: ''+
				'<div class="af-label"></div>'+
				'<div class="af-edit">'+
					'<div class="af-name"></div>'+
					'<div class="af-change"><input type="button" class="af-change-select" value=""/><input type="button" class="af-change-remove" value=""/></div>'+
					'<div class="af-html"></div>'+
					'<div class="af-error"></div>'+
				'</div>'+
				'<div class="af-upload"></div>'+
				'<div style="clear: both;"></div>'
};

(function( $, undefined ) {
$.widget("ui.ajajform_file_group_id",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_file_group_id
	 *		Создает загрузки группы файлов
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_checkbox2
	 *		options.allowUpload typeof boolean, default false	-
	 *		options.noFolderChange typeof boolean, default false	-
	 *		options.cssclass typeof String, default 'afw-filegroupid' - CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- значение
	 *		options.label typeof String				- заголовок
	 *		options.previewSuffix typeof String, default '-preview1' - превью
	 *		options.width typeof integer, default null		- ширина блока
	 *		options.htmltemplate typeof HtmlString			- шаблон активный
	 *		options.htmltemplate_disableable  typeof HtmlString	- шаблон не активный 
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.change typeof Function, default null		- функция изменения состояния
	 *		options.htmltemplate_dialog typeof HtmlString		- шаблон диалогового окна
	 *		options.readonly typeof boolean, default false		- без отправки
	 *		options.defaultFileGroupId typeof Integer			- file_group_id если не задана
	 */
	options: {
		// \type boolean
		allowUpload: false,
		noFolderChange: false,
		// \type cssclass
		cssclass: "afw-filegroupid",
		// \type object
		// id: integer
		// name: string
		// files: array of object
		//	url string
		//	name varchar
		//	filename varchar
		//	name_or_filename varchar
		value: {},
		// \type text
		label: "",
		// \type string
		previewSuffix: "-preview1",
		// \type integer
		width: null,
		// \type html
		htmltemplate: null,// '<div class="af-label"></div><div class="af-edit"><div class="af-name"></div><div class="af-change"><input type="button" value=""/></div><div class="af-html"></div><div class="af-error"></div></div><div class="af-upload"></div><div style="clear: both;"></div>',
		//htmltemplate_disableable: '<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><span class="af-html"></span><span class="af-change"></span><div class="af-error"></div></div><div class="af-upload"></div><div style="clear: both;"></div>',
		// \type function
		validate: null,
		// \type: function
		change: null,
		htmltemplate_dialog: '<div><iframe src="" width="100%" height="95%" frameborder="0" border="0"></iframe></div>',
		readonly: false
	},
	i18n: {
		en: {
			folder: "Folder",
			change: "Change",
			remove: "Remove"
		},
		ru: {
			folder: "Папка",
			change: "Сменить",
			remove: "Очистить"
		}
	},
	_create: function() {
		this.genericCreate();
		this.i18n_texts();
		this.bindChangeButton();
		this.refreshLabel();
		this.refreshWidth();
		this.refreshValue();
		this.refreshChange();
		//this.refreshDisabled();
		this.refreshNoFolderChange();
		this.refreshAllowUpload();
		this.refreshReadonly();
	},
	i18n_texts: function() {
		$(".af-change input.af-change-select",this.element).prop("value",this.gettext("change"));
		$(".af-change input.af-change-remove",this.element).prop("value",this.gettext("remove"));
	},
	refreshDefaultFileGroupId: function() {
	},
	refreshWidth: function() {
		if (this.options.width) $(".af-edit",this.element).width(this.options.width);
	},
	refreshNoFolderChange: function () {
		if (this.options.noFolderChange) {
			$(".af-change, .af-name",this.element).hide();
		} else {
			$(".af-change, .af-name",this.element).show();
		}
	},
	refreshValue: function() {
		var n=$(".af-name",this.element);
		var h=$(".af-html",this.element);
		var arr;
		if (this.options.value.id) {
			n.text(this.gettext("folder")+" "+this.options.value.name);
			h.empty();
			if (this.options.value.files) {
				for (var i=0,s=this.options.value.files.length;i<s;i++) {
					var file=this.options.value.files[i];
					if ((arr=file.url.match(/^(.*)\.(png|gif|jpe?g)$/i))) {
						var preview=arr[1]+this.options.previewSuffix+"."+arr[2];
						$("<div class='af-file'><a target='_blank' href='"+file.url+"'><img src='"+preview+"' border='0'/></a></div>").appendTo(h);
					} else if ((arr=file.url.match(/^(.*)\.(doc|docx|csv|txt|xls|xlsx|pdf|xml|tiff|bmp)$/i))) {
						var preview="/shared/icons/filebrowser/"+arr[2].toLowerCase()+this.options.previewSuffix+".png";
						$("<div class='af-file'><a target='_blank' href='"+file.url+"'><img src='"+preview+"' border='0'/></a></div>").appendTo(h);
					} else {
						$("<div class='af-file af-file-noimage'><a target='_blank' href='"+file.url+"'>"+(file.name_or_filename||file.ext)+"</a></div>").appendTo(h);
					}
				}
			}
		} else {
			n.html("");
			h.html("");
		}
	},
	refreshReadonly: function() {
		$(".af-change input",this.element).prop("disabled",this.options.readonly);
		this.refreshAllowUpload();
	},
	refreshAllowUpload: function() {
		var i=$(".af-upload",this.element);
		i.empty();
		if (!this.options.allowUpload || this.options.readonly) return;
		function add_input() {
			$('<input type="file" class="fileInput"/>').appendTo(i).bind("change",add_input);
		}
		add_input();
	},
	bindChangeButton: function() {
		var t=this;
		var b=$(".af-change input.af-change-select",this.element);
		b.button().bind("click",function(e) {t.openFileChooseDialog(t);});
		var b=$(".af-change input.af-change-remove",this.element);
		b.button().bind("click",function(e) {t.options.value={};t.refreshValue();});
	},
	openFileChooseDialog: function() {
		var t=this;
		if (this.options.readonly) return;
		var d=global_ajajform_file_group_id_dialog=$(this.options.htmltemplate_dialog).appendTo($("body"));
		$("iframe",d).attr("src","/admin_popup-AdminMediaLibrary/?target=ajajform_filegroup_id&file_folder_id="+(this.options.value.id||this.options.defaultFileGroupId||""));
		global_ajajform_file_group_id=t;
		var wx=Math.floor(win_x()*0.90)-100;
		var wy=Math.floor(win_y()*0.90)-100;
		d.dialog({
			modal: true,
			width: wx<830?830:wx,
			height: wy<550?470:wy,
			close: function() { d.dialog("destroy");d.remove(); }
		});
	},
	refreshChange: function() {
	},
	//refreshDisabled: function() {
	//	$(".af-change input",this.element).prop("disabled",this.options.disabled);
	//	this.genericRefreshDisabled();
	//},
	destroy: function() {
	},
	validate: function() {
		return false;
	},
	postvalue: function(r,r2) {
		r[this.options.name]=this.options.value.id;
		var arr=$(".af-upload input",this.element);
		for (var i=0;i<arr.length;i++) {
			$(arr[i]).prop("name",this.options.name+"-file"+i);
			var v=$(arr[i]).val();
			if (v && v.length) r2[this.options.name+"-file"+i]=v;
		}
	}
});

})( jQuery );

function ajajform_file_group_id_set(v)
{
	global_ajajform_file_group_id._setOption("value",v);
	global_ajajform_file_group_id=undefined;
	global_ajajform_file_group_id_dialog.dialog("close");
}

