ajajform_htmltemplates.fileupload={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input class="fileInput" type="file"/><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_fileupload",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_fileupload
	 *		(TODO)
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_file_id
	 *		options.cssclass typeof String, default 'afw-fileid' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- значение
	 *		options.label typeof String				- заголовок
	 *		options.width typeof integer, default null		- ширина блока
	 *		options.htmltemplate typeof HtmlString			- шаблон активный 
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.change typeof Function, default null		- функция изменения состояния
	 *		options.multiple typeof boolean, default false		-
	 */
	options: {
		// \type cssclass
		cssclass: "afw-fileupload",
		// \type text
		value: "",
		// \type text
		label: "",
		// \type integer
		width: null,
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><input class="fileInput" type="file"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type function
		validate: null,
		// \type function
		change: null,
		multiple: false
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		this.element.append(this.getHtmlTemplate("htmltemplate"));
		this.refreshLabel();
		this.refreshInput();
		this.refreshName();
		this.refreshValue();
		this.refreshChange();
	},
	refreshName: function() {
		var i=$("input",this.element);
		i.prop("name",this.options.name);
	},
	refreshValue: function() {
		var i=$("input",this.element);
		i.val(this.options.value);
	},
	refreshInput: function() {
		var i=$("input",this.element);
		i.addClass("ui-corner-all af-edit");
		i.width(this.options.width);
		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i.bind("blur",this,function(e) {
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
		if (this.options.multiple) i.attr("multiple","multiple");
	},
	refreshChange: function() {
		var i=$("input",this.element);
		if (!this.options.change) {
			if (this.oldBind) {i.unbind("change",this.oldBind);this.oldBind=null;}
			return;
		}
		if (this.oldBind) i.unbind("change",this.oldBind);
		this.oldBind=this.options.change;
		i.bind("change",{tag:i},this.oldBind);
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var inp=$("input",this.element);
		if (!vd) return false;
		var r=vd(inp.val());
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r1,r2) {
		var v=$("input",this.element).val();
		if (v && v.length) r2[this.options.name]=v;
	}
});

})( jQuery );
