ajajform_htmltemplates.subtreeselector={
	htmltemplate: '<div class="af-label"></div><div class="af-edit"><div class="af-tree"></div><div class="af-error"></div></div><div style="clear: both;"></div>',
	checkboxtemplate: '<div class="item"><div class="expander"></div><label><input type="checkbox" class="" name="" value="1"/><span class="name"></span></label><div class="cl"></div></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_subtreeselector",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_subtreeselector
	 *		Создает список чекбоксов 
	 * Properties:
	 *		options typeof Object 								- Настройки ajajform_subtreeselector
	 *		options.cssclass typeof String, default 'afw-subtreeselector' 	- CSS класс добавляемый к DIV формы
	 *		options.available typeof Array, default []			- массив доступных значений
	 *		options.checked typeof Array, default []			- массив выбранных значений
	 *		options.htmltemplate  typeof HtmlString				- шаблон блока с чекбоксами
	 *		options.checkboxtemplate  typeof HtmlString			- шаблон чекбокса
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.label typeof String							- заголовок
	 */
	options: {
		cssclass: "afw-subtreeselector",
		available: [],
		checked: [],
		htmltemplate: null,
		checkboxtemplate: null,
		label: "",
		readonly: false,
		validate: null,
		item_width:undefined
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this.getHtmlTemplate("htmltemplate");
		this.element.append(t);
		this.refreshLabel();
		this.refreshWidth();
		this.refreshAvailable();
		this.refreshItemWidth();
		this.refreshChecked();
		this.refreshReadonly();
	},
	refreshWidth: function() {
		$(".af-edit",this.element).width(this.options.width);
	},

	refreshItemWidth: function() {
		if (this.options.item_width===undefined) {
			$(".af-tree .item",this.element).css("width",undefined);
		} else {
			$(".af-tree .item",this.element).css("width",this.options.item_width);
		}
	},

	refreshReadonly: function() {
		if (this.options.readonly) this.element.addClass("ro");
		else this.element.removeClass("ro");
	},

	refreshAvailable: function() {
		var t=this;
		var cbs=$(".af-tree",this.element).empty();

		this.children_of={};
		for (var i=0;i<this.options.available.length;i++) {
			var av=this.options.available[i];
			this.children_of[av.id]=[];
			if (av.parent_id && this.children_of[av.parent_id]) this.children_of[av.parent_id].push(av);
		}
		for (var i=0;i<this.options.available.length;i++) {
			var av=this.options.available[i];
			var cb=$(this.getHtmlTemplate("checkboxtemplate")).appendTo(cbs);
			$(".name",cb).text(av.name);
			$("input",cb).prop("name",this.options.name+"-"+av.id);
			if (this.options.item_width) cb.css("width",this.options.item_width);
			$(cb).css("padding-left",((av.level-1)*40)+"px");
			$(cb).attr("data-id",av.id);
			$(cb).attr("data-parent-id",av.parent_id);
			if (!this.children_of[av.id].length) $(".expander",cb).addClass("off");
			if (av.level>1) $(cb).addClass("hidden");
		}
		cbs.append('<div style="clear: both;"></div>');
		$(".expander",cbs).bind("click",function() {
			t.expanderClicked(this);
		});
		$("input",cbs).bind("click",function() {
			t.inputClicked(this);
		});
	},

	inputClicked: function(inp) {
		var cbs=$(".af-tree",this.element);
		var id=$(inp).closest(".item").attr("data-id");
		var checked=$(inp).prop("checked");
		var cc=[id];
		while (cc.length) {
			var tmp=[];
			for (var i=0;i<cc.length;i++) {
				var arr=this.children_of[cc[i]];
				for (var j=0;j<arr.length;j++) {
					tmp.push(arr[j].id);
				}
				$(".item[data-parent-id='"+cc[i]+"'] input",cbs).prop("checked",checked);
			}
			cc=tmp;
		}
	},

	expanderClicked: function(div) {
		div=$(div);
		if (div.hasClass("off")) return;
		var cbs=$(".af-tree",this.element);
		div.toggleClass("expanderA");
		var id=div.closest(".item").attr("data-id");
		var sel=$(".item[data-parent-id='"+id+"']",cbs);
		sel[div.hasClass("expanderA")?"removeClass":"addClass"]("hidden");
		console.log("id=",id,"sel=",sel);
	},

	refreshChecked: function() {
		$(".af-tree input",this.element).prop("checked",false);
		for (var i=0;i<this.options.checked.length;i++) {
			var c=this.options.checked[i];
			$(".af-tree input[name='"+this.options.name+"-"+c+"']",this.element).prop("checked",true);
		}
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	destroy: function() {
	},
	validate: function() {
		return false;
	},
	postvalue: function(r) {
		var sel=$(".af-tree .item input:checked",this.element);
		for (var i=0;i<sel.length;i++) {
			var item=sel[i];
			r[item.name]=1;
		}
	}
});

})( jQuery );
