ajajform_htmltemplates.tagsedit={
	htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="text" class="af-edit"/><div class="af-tags"></div><div class="af-error"></div></div><div style="clear: both;"></div><div class="af-legend"></div>',
};

(function( $, undefined ) {
$.widget("ui.ajajform_tagsedit",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_tagsedit
	 *		Создает однострочное поле ввода текста без форматирования 
	 *
	 * Properties:
	 *		options typeof Object 									- Настройки ajajform_tagsedit
	 *		options.cssclass typeof String, default 'afw-tagsedit' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof Array of String					- введенные теги
	 *		options.separator typeof String, default ', '			- разделитель
	 *		options.min_count typeof integer, default 0				- минимум введенных тегов
	 *		options.max_count typeof integer, default 100			- максимум введенных тегов
	 *		options.label typeof String								- заголовок поля
	 *		options.placeholder typeof Function, default null		- placeholder
	 *		options.width typeof integer, default null				- ширина поля в пикселях
	 *		options.readonly typeof boolean, default false			- нельзя менять
	 *		options.tags typeof Array of String						- массив возможных тегов
	 *		options.validate typeof Function, default null			- функция валидации
	 *		options.change typeof Function, default null			- функция при событии change
	 */
	options: {
		cssclass: "afw-tagsedit",
		min_count: 0,
		max_count: 100,
		label: "",
		width: null,
		readonly: false,
		values:[],
		tags:[],
		separator:", ",
		validate: null,
	},
	i18n: {
		en: {
		},
		ru: {
		}
	},
	_create: function() {
		this.genericCreate();
		this.refreshLabel();
		this.refreshLegend();
		this.refreshWidth();
		this.refreshValues();
		this.refreshTags();
		this.refreshReadonly();
	},

	refreshLegend: function() {
		$(".af-legend",this.element).html(this.options.legend);
	},

	refreshValues: function() {
		var i=$("input",this.element);
		i.val(this.options.values.join(this.options.separator));
	},

	refreshWidth: function() {
		var i=$("input",this.element);
		i.width(this.options.width);
	},

	save: function() {
		var selected=$("input",this.element).val().split(new RegExp("\\s*"+this.options.separator.replace(/^\s+/,"").replace(/\s+$/,"")+"\\s*"));
		var i=0;
		var hash={};
		while (i<selected.length) {
			if (selected[i]=="" || hash[selected[i].toLowerCase()]) {
				selected.splice(i,1);
			} else {
				hash[selected[i].toLowerCase()]=1;
				i++;
			}
		}
		this.options.values=selected;
	},

	toggleTag: function(val) {
		this.save();
		var flag=-1;
		for (var i=0;i<this.options.values.length;i++) {
			if (this.options.values[i].toLowerCase()==val.toLowerCase()) flag=i;
		}
		if (flag==-1) {
			this.options.values.push(val);
		} else {
			this.options.values.splice(flag,1);
		}
		this.refreshValues();
	},

	refreshReadonly: function() {
		// TODO
	},

	refreshTags: function() {
		var t=this;
		var div=$(".af-tags",this.element).empty();
		for (var i=0;i<this.options.tags.length;i++) {
			$("<div class='af-tag'></div>").text(this.options.tags[i]).appendTo(div);
		}
		$(".af-tag",div).bind("click",function() {
			t.toggleTag($(this).text());
		});
	},

	destroy: function() {
	},
	validate: function() {
		this.save();
		var r;
		var vd=this.options.validate;
		if (vd) r=vd(val);

		if (this.options.values.length>this.options.max_count) r=this.gettext("too_many");
		if (this.options.values.length<this.options.min_count) r=this.gettext("too_little");
		if (r) $("input",this.element).addClass("ui-state-error"); else $("input",this.element).removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},

	postvalue: function(r) {
		this.save();
		r[this.options.name]=JSON.stringify(this.options.values);
	}
});

})( jQuery );
