ajajform_htmltemplates.textareaedit={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><textarea/><div class="af-error"></div></div><div style="clear: both;"></div>',
		htmltemplate_disableable: '<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><textarea/><div class="af-error"></div></div><div style="clear: both;"></div>'
};

(function( $, undefined ) {
$.widget("ui.ajajform_textareaedit",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_textareaedit
	 *		Создает многострочное поле ввода текста с или без форматирования
	 * Properties:
	 *		options typeof Object 						- Настройки ajajform_textareaedit
	 *		options.cssclass typeof String, default 'afw-textareaedit' 	- CSS класс добавляемый к DIV формы
	 *		options.label typeof String					- заголовок поля
	 *		options.value typeof String					- введенный текст, значение
	 *		options.htmltemplate typeof HtmlString				- шаблон
	 *		options.htmltemplate_disableable  typeof HtmlString		- шаблон шаблон при Disabled
	 *		options.width typeof integer, default 400			- ширина поля в пикселях
	 *		options.height typeof integer, default 200			- высота поля в пикселях
	 *		options.wysiwyg typeof boolean, default false			- с форматированием?
	 *		options.wysiwyg_toolbar typeof  String, default "external"	- тип редактора
	 *		options.disabled typeof boolean, default false			- выключен
	 *		options.disableable typeof  boolean, default false		- выключен (?)
	 *		options.tinymce_settings typeof  Object				- настройки редактора tinymce
	 */
	options: {
		// \type cssclass
		cssclass: "afw-textareaedit",
		// \type text
		label: "",
		// \type text
		value: "",
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><textarea/><div class="af-error"></div></div><div style="clear: both;"></div>',
		//htmltemplate_disableable: null,// '<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><textarea/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type integer
		width: 400,
		// \type integer
		height: 200,
		// \type boolean
		wysiwyg: false,
		wysiwyg_toolbar: "external",
		//disabled: false,
		//disableable: false,
		readonly: false,
		tinymce_settings: {
			selector: "textarea",
			plugins: [
					"advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
					"searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
					"table contextmenu directionality emoticons template textcolor paste textcolor"
			],

			/*toolbar1: "newdocument fullpage | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | styleselect formatselect fontselect fontsizeselect",
			toolbar2: "cut copy paste | searchreplace | bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media code | inserttime preview | forecolor backcolor",
			toolbar3: "table | hr removeformat | subscript superscript | charmap emoticons | print fullscreen | ltr rtl | spellchecker | visualchars visualblocks nonbreaking template pagebreak restoredraft",*/
			toolbar1: "undo redo | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | formatselect fontselect fontsizeselect",
			toolbar2: "cut copy paste | searchreplace | bullist numlist | outdent indent blockquote | link unlink anchor image media code | inserttime preview | forecolor backcolor",
			toolbar3: "table | hr removeformat | subscript superscript | charmap | spellchecker | visualchars visualblocks nonbreaking pagebreak",

			menubar: false,
			toolbar_items_size: 'small',

			/*style_formats: [
				{title: 'Bold text', inline: 'b'},
				{title: 'Red text', inline: 'span', styles: {color: '#ff0000'}},
				{title: 'Red header', block: 'h1', styles: {color: '#ff0000'}},
				{title: 'Example 1', inline: 'span', classes: 'example1'},
				{title: 'Example 2', inline: 'span', classes: 'example2'},
				{title: 'Table styles'},
				{title: 'Table row 1', selector: 'tr', classes: 'tablerow1'}
			],*/

/*			plugins: "advlist autolink lists link image charmap print preview anchor searchreplace visualblocks code fullscreen"+
					" insertdatetime media table contextmenu paste spellchecker textcolor",
			toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | hr textcolor",*/
			content_css : "/site_tinymce.css",
			relative_urls : false,
			convert_urls: false,
			image_advtab: true,
			valid_elements: "*[*]",
			//extended_valid_elements : "div[itemscope|itemtype|itemprop]",
			file_browser_callback : function(field_name, url, type, win) {AdminMediaLibraryFuncs.open_popup({target:"tinymce"},{field_name:field_name,url:url,type:type,win:win}) }
		}

	/*{
				script_url : '/shared/tiny_mce/jquery.tinymce.js',
				content_css : "/site.css",
				relative_urls : false,
				convert_urls: false,
				file_browser_callback : "openFileBrowser",
				language: ajajform_global_options.language,
				plugins : "table,media,searchreplace,contextmenu,paste,noneditable,visualchars,nonbreaking,template",
				body_class: "bodytinymce",
				theme : "modern",
		 		theme_advanced_buttons1 : "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect,forecolor,backcolor",
			 	theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,image,cleanup,code",
			 	theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,advhr",
//			 	theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak",
				theme_advanced_blockformats : "p,div,h1,h2,h3,h4,h5,h6,blockquote,cite,code,samp",
//				theme_advanced_toolbar_location : "top",
				theme_advanced_toolbar_align : "left",
//				theme_advanced_statusbar_location : "bottom",
				theme_advanced_resizing : true,
			}*/
	},
	_create: function() {
		this.genericCreate();
		this.refreshLabel();
		this.refreshTextarea();
		this.refreshValue();
		if (this.options.wysiwyg) {
			var t=this;
			setTimeout(function() { t.refreshWysiwyg();},10);
		}
	///	this.refreshDisabled();
		this.refreshAnychange();
		this.refreshReadonly();
	},
	refreshWysiwyg: function() {
		if (this.options.wysiwyg) {
			if (!this.options.value) {
				this.options.value="<p></p>";
				this.refreshValue();
			}
			if (!this.options.tinymce_settings.theme_advanced_toolbar_location) this.options.tinymce_settings.theme_advanced_toolbar_location=this.options.wysiwyg_toolbar;
			this.options.tinymce_settings.width=this.options.width;
			this.options.tinymce_settings.height=this.options.height;
			$("textarea",this.element).tinymce(this.options.tinymce_settings);
		}
	},
	refreshTextarea: function() {
		var i=$("textarea",this.element);
		i.addClass("ui-corner-all af-edit");
		i.width(this.options.width);
		i.height(this.options.height);
//		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i.bind("blur",this,function(e) {
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
	},
	refreshValue: function() {
		$("textarea",this.element).prop("value",this.options.value);
	},
	refreshReadonly: function() {
		$("textarea",this.element).prop("readonly",this.options.readonly);
	},
	refreshAnychange: function() {
		this.genericRefreshAnychange(
					"textarea",
					function(t) {t.options.value=$("textarea",t.element).val();},
					function(t) {return t.options.value;}
					);
	},
	//refreshDisabled: function() {
	//	$("textarea",this.element).prop("disabled",this.options.disabled);
	//	this.genericRefreshDisabled();
	//},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var inp=$("textarea",this.element);
		if (!vd) return false;
		var r=vd(inp.val());
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r) {
		r[this.options.name]=$("textarea",this.element).val();
	}
});

})( jQuery );
