ajajform_htmltemplates.textedit={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div><div class="af-legend"></div>',
		htmltemplate_disableable: '<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div><div class="af-legend"></div>'
};

(function( $, undefined ) {
$.widget("ui.ajajform_textedit",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_textedit
	 *		Создает однострочное поле ввода текста без форматирования 
	 *
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_textedit
	 *		options.cssclass typeof String, default 'afw-textedit' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- введенный текст, значение
	 *		options.minsize typeof integer, default 0		- минимум введенных симовлов
	 *		options.maxsize typeof integer, default undefined	- максимум введенных симовлов
	 *		options.password typeof boolean, default 'false'	- является ли поле паролем
	 *		options.label typeof String				- заголовок поля
	 *		options.placeholder typeof Function, default null		- placeholder
	 *		options.width typeof integer, default null		- ширина поля в пикселях
	 *		options.readonly typeof boolean, default false		- нельзя менять
	 *		options.htmltemplate typeof HtmlString			- шаблон
	 *		options.htmltemplate_disableable  typeof HtmlString	- шаблон шаблон при Disabled
	 *		options.autocomplete typeof Function, default null	- функция автозаполнения
	 *		options.add_decimals typeof Function, default null	- функция (?)
	 *		options.iscode typeof boolean, default false		- является ли вводимый текст кодом (видимо для автозаполнения ?)
	 *		options.isnumber typeof boolean, default false		- является ли вводимый текст числом
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.change typeof Function, default null		- функция при событии change
	 */
	options: {
		// \type cssclass
		cssclass: "afw-textedit",
		// \type text
		value: "",
		minsize: 0,
		maxsize: undefined,
		// \type boolean
		password: false,
		// \type text
		label: "",
		// \type integer
		width: null,
		readonly: false,
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		//htmltemplate_disableable: null,//'<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type any
		// \skip 1
		autocomplete: null,
		add_decimals:null,
		isnumber: false,
		iscode: false,
		validate: null,
		validate_re: null,
		// \type: function
		change: null,
		anychange:null
	},
	i18n: {
		en: {
			too_long: "Field is too long",
			too_short: "Field is too short",
			not_number: "Not a number",
			not_code: "Only letters, digits, '_' and '-' allowed",
			not_re: "Input is not valid",
		},
		ru: {
			too_long: "Слишком длинное",
			too_short: "Слишком короткое",
			not_number: "Не число",
			not_code: "Разрешены только латинские буквы, цифры, '_' и '-'",
			not_re: "Недопустимые символы",
		}
	},
	_create: function() {
		if (this.options.password) this.genericCreate(function(x) {return x.replace('type="text"','type="password"')}); else this.genericCreate();
		this.refreshLabel();
		this.refreshLegend();
		this.refreshInput();
		this.refreshValue();
		this.refreshAutocomplete();
		this.refreshChange();
		this.refreshAnychange();
	//	this.refreshDisabled();
		this.refreshShow_autocomplete();
		this.refreshReadonly();
		this.refreshMinsize();
	},
	refreshLegend: function() {
		$(".af-legend",this.element).html(this.options.legend);
	},
	refreshPassword: function() {
	},
	refreshMinsize: function() {
		if (this.options.minsize && !this.options.readonly) this.element.addClass("afw-notnull"); else this.element.removeClass("afw-notnull");
	},
	refreshShow_autocomplete: function() {
		var t=this;
		$(".af-label .af-autocomplete",this.element).remove();
		if (!this.options.show_autocomplete) return;
		var ac=$("<div class='af-autocomplete'></div>").appendTo($(".af-label",this.element));
		var s=this.options.autocomplete.source;
		for (var i=0;i<s.length;i++) {
			$("<div class='af-ac-item'></div>").text(s[i]).appendTo(ac).bind("click",{d:s[i]},function(e) {t.option("value",e.data.d);});
		}
	},
	refreshAutocomplete: function() {
		var i=$("input",this.element);
		if (this.options.autocomplete) {
			i.addClass("has-autocomplete");
			i.autocomplete(this.options.autocomplete);
		} else {
			if (i.hasClass("has-autocomplete")) {
				i.autocomplete("destroy");
				i.removeClass("has-autocomplete");
			}
		}
	},
	refreshValue: function() {
		var i=$("input",this.element);
		fmtd=this.options.value;
		if (this.options.add_decimals && fmtd!==null && fmtd!==undefined && fmtd.toString().match(/^\d+$/)) fmtd+=this.options.add_decimals;
		i.val(fmtd);
	},
	refreshInput: function() {
		var i=$("input",this.element);
		i.addClass("ui-corner-all af-edit");
		if(this.options.placeholder)i.attr('placeholder',this.options.placeholder);
		i.width(this.options.width);
		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i.bind("blur",this,function(e) {
                console.log(e);
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
		
		if (this.options.format) {
			var t = this;
			var format_func = function(v){return v;}
			if (this.options.format=='thousands') format_func = function(v){
				var s='';
				v = v.replace(/\s/g,'');
				for (var k = 0;k<v.length;k++) s = v[v.length-k-1]+((k%3==0 && k)?' ':'')+s;
				return s;
			}
			
			i.on("keyup",function(e) {
				clearTimeout(t.formating_interval);
				t.formating_interval = setTimeout(function(){
					i.val(format_func(i.val())); 	
				},200)				
			});
		}
		
	},
	refreshChange: function() {
		var i=$("input",this.element);
		if (!this.options.change) {
			if (this.oldBind) {i.unbind("change",this.oldBind);this.oldBind=null;}
			return;
		}
		if (this.oldBind) i.unbind("change",this.oldBind);
		this.oldBind=this.options.change;
		i.bind("change",{tag:i},this.oldBind);
	},
	refreshAnychange: function() {
		this.genericRefreshAnychange(
					"input",
					function(t) {t.options.value=$("input",t.element).val();},
					function(t) {return t.options.value;}
					);
		
	},
	//refreshDisabled: function() {
	//	$("input",this.element).prop("disabled",this.options.disabled);
	//	this.genericRefreshDisabled();
	//},
	refreshReadonly: function() {
		$("input",this.element).attr("readonly",this.options.readonly);
		if (this.options.readonly) this.element.addClass("ro");
		else this.element.removeClass("ro");
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var inp=$("input",this.element);
		var val=inp.val();
		var r;
		if (vd && vd.constructor===Function) r=vd(val);
		if (!r) {
			if (val.length<this.options.minsize) r=this.gettext("too_short");
			if (this.options.maxsize && val.length>this.options.maxsize) r=this.gettext("too_long");
			if (this.options.isnumber && !(val.match(/^(|\+|\-)(|\d+|\.\d+|\d+\.|\d+\.\d+)$/))) r=this.gettext("not_number");
			if (this.options.iscode && !(val.match(/^[\w\-]*$/))) r=this.gettext("not_code");
			if (this.options.validate_re && !(val.match(new RegExp(this.options.validate_re)))) r=this.gettext("not_re");
		}
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r) {
		var v = $("input",this.element).val();
		if (this.options.format=='thousands' && v) v = v.replace(/\s/g,'');
		r[this.options.name]=v;
	}
});

})( jQuery );
