function LNScroll(options){
    this.init(options); 
}

LNScroll.prototype.init=function(options){    
    var t = this;
	if (!t.options) t.options = options;
    t.target = t.options.target;
    t.x = t.options.x;
    t.y = t.options.y;
    t.ythumb_click = false; //vertical thumb click flag;
    t.xthumb_click = false; //horizontal thumb click flag;
    t.ystart_pos = 0;       //position for vertical thumb
    t.xstart_pos = 0;       //position for horizontal thumb
    t.dynamic = false;
	//t.dragable = true;
    
	var html;
	
	if (t.source) {
		html = t.source;
	} else {
		html = $(t.target[0]).html();
		t.source = html;
	}
    var             structure = "<div class='scroll_content'>"+                                    
                                    html+                                    
                                "</div>";
    if(t.options.y)   structure+= "<div class='ytrack'>"+
                                    "<div class='thumb'></div>"+
                                "</div>"+"<div class='up_but'></div><div class='down_but'></div>";
    if(t.options.x)   structure+= "<div class='xtrack'>"+
                                    "<div class='thumb'></div>"+
                                "</div>"+"<div class='left_but'></div><div class='right_but'></div>";
    $(t.target[0]).html(structure).addClass('LNScroll');    
    
	
	t.render();
	
		
	t.init_actions();
    
    //if resize
    window.onresize = function(){t.render()}
    
    //success
    if(t.options.success){t.options.success();}
}
LNScroll.prototype.init_actions=function(options){
	
	 
	
	var t = this;
	
	if (t.height>t.content_h) return;
	
	$('.up_but',t.target).bind('click',function(){t.move(-t.options.y_step,'y',true);return false;});
    $('.down_but',t.target).bind('click',function(){t.move(t.options.y_step,'y',true);return false;});
    $('.left_but',t.target).bind('click',function(){t.move(-t.options.x_step,'x',true);return false;});
    $('.right_but',t.target).bind('click',function(){t.move(t.options.x_step,'x',true);return false;});
    
    
    $('.ytrack',t.target).mouseup(function(e){        
        if (!t.dynamic) {
            t.y_pos = $('.ytrack',t.target).offset().top*1+$('.ytrack .thumb',t.target).css('top').replace(/px/,'')*1;
            t.move(e.pageY-t.y_pos,'y');
            t.ystart_pos = e.pageY;
        }
       
    });
    $('.xtrack',t.target).mouseup(function(e){
        if (!t.dynamic) {
            t.x_pos = $('.xtrack',t.target).offset().left*1+$('.xtrack .thumb',t.target).css('left').replace(/px/,'')*1;
            t.move(e.pageX-t.x_pos,'x');
            t.xstart_pos = e.pageX;
        }
          
    });
    
    $('.ytrack .thumb',t.target).mousedown(function(e){
        t.ythumb_click = true;		
        t.ystart_pos = e.pageY;
        return false;
    });
    $('.xtrack .thumb',t.target).mousedown(function(e){
        t.xthumb_click = true;		
        t.xstart_pos = e.pageX ;
        return false;
    });
	if (t.options.dragable)
    $(t.target[0]).mousedown(function(e){
        t.sb_click = true;
        t.xstart_pos = e.pageX;
        t.ystart_pos = e.pageY;
        return false;    
    });  
    $('body').mouseup(function(e){
        return t.ythumb_click = t.xthumb_click = t.dynamic = t.sb_click = false;	
    });
    
    t.ratio_x = (t.content_w-t.width)/(t.xtrack_w-t.xthumb_w);
    t.ratio_y = (t.content_h-t.height)/(t.ytrack_h-t.ythumb_h);
    
    $('body').mousemove( function(e){        
        if (t.ythumb_click) {              
            t.move(e.pageY-t.ystart_pos,'y');
            t.ystart_pos = e.pageY;
            t.dynamic = true;
            return false;			
        }
        if (t.xthumb_click) {              
            t.move(e.pageX-t.xstart_pos,'x');
            t.xstart_pos = e.pageX;
            t.dynamic = true;
            return false;
        }
        else if (t.sb_click) {            
            t.move({x:-(e.pageX-t.xstart_pos)/t.ratio_x ,y:-(e.pageY-t.ystart_pos)/t.ratio_y},'xy');
            t.xstart_pos = e.pageX;
            t.ystart_pos = e.pageY;
            t.dynamic = true;
            return false;
        }
    });
    
    //// wheel ////
    if (t.target[0].addEventListener) {            
        if ('onwheel' in document) 
            t.target[0].addEventListener ("wheel",  function(){t.move()}, false);
        else if ('onmousewheel' in document) 
            t.target[0].addEventListener ("mousewheel", function(){t.move()}, false);
        else 
            t.target[0].addEventListener ("MozMousePixelScroll", function(){t.move()}, false);	   
    } else 
        t.target[0].attachEvent ("onmousewheel", function(e){t.move()});
		
		        
    //// drag ////
	console.log(t.options.dragable);
	if (t.options.dragable)
		$('.scroll_content',t.target).bind('touchstart touchmove touchend touchcancel',function(){t.drag(event);});
} 
LNScroll.prototype.render=function(){
   
    var t = this;
    
    t.width = $(t.target[0]).width();
    t.height = $(t.target[0]).height();
	
	console.log(t.height);
    
    t.ythumb_h = $('.ytrack .thumb',t.target).height() || 0;
    t.ytrack_w = $('.ytrack',t.target).width() || 0;
    t.ythumb_w = $('.ytrack .thumb',t.target).width() || 0;    
	t.xtrack_w = t.width-t.ythumb_w || 0;
	
    $('.xtrack',t.target).width(t.xtrack_w);
    
    t.xtrack_h = $('.xtrack',t.target).height() || 0;
    t.xthumb_h = $('.xtrack .thumb',t.target).height() || 0;   
    t.xthumb_w = $('.xtrack .thumb',t.target).width() || 0;
    t.ytrack_h = t.height-t.xthumb_h || 0;
    $('.ytrack',t.target).height(t.ytrack_h)
    
    t.ytrack_h = $('.ytrack',t.target).height() || 0;
    t.xtrack_w = $('.xtrack',t.target).width() || 0;
	
	
	
	t.content_w = $('.scroll_content',t.target).css('width','auto');
	t.content_w = $('.scroll_content',t.target).width();
    t.content_w += (t.options.x)?t.ythumb_w:-t.ythumb_w;
	if (t.options.x)
		$('.scroll_content',t.target).width(t.content_w);
	
	t.content_h = $('.scroll_content',t.target).css('height','auto');
	t.content_h = $('.scroll_content',t.target).height();    
    t.content_h = $('.scroll_content',t.target).height()+t.xthumb_h;
	if (t.options.y)
		$('.scroll_content',t.target).height(t.content_h);
	
	t.ratio_x = (t.content_w-t.width)/(t.xtrack_w-t.xthumb_w);
    t.ratio_y = (t.content_h-t.height)/(t.ytrack_h-t.ythumb_h);
       
    if (t.options.y_step==0) {$('.up_but',t.target).hide(0),$('.down_but',t.target).hide(0)}
    if (t.options.x_step==0) {$('.left_but',t.target).hide(0),$('.right_but',t.target).hide(0)}
	
	if (t.height>t.content_h) 	$('.ytrack',t.target).hide(0);
	else						$('.ytrack',t.target).show(0);
}

LNScroll.prototype.move=function(e,a,animate){
    var t = this;
    if (e == 0) e = 0;
    else e = e || window.event;
    
    var delta_y = e.deltaY || e.detail || e.wheelDeltaY || e.y || e;
    var delta_x = e.deltaX || e.detail || e.wheelDeltaX || e.x || e;
    
    if (e.x==0) delta_x=0;
    if (e.y==0) delta_y=0;
    
    if (e.type=="wheel" && e.wheelDeltaY==0) {delta_y=0;}
    if (e.type=="wheel" && e.wheelDeltaX==0) {delta_x=0;}
        
    if(e && a=='x') delta_y=0;
    else if(e && a=='y') delta_x=0;
    
    if(t.options.x && !t.options.y && e.wheelDeltaY) delta_x =  e.wheelDeltaY ;
    if(t.options.y && !t.options.x && e.wheelDeltax) delta_y =  e.wheelDeltaX ;
    
    t.x_pos = (t.options.x)?$('.xtrack .thumb',t.target).css('left').replace(/px/,'')*1:0;
    t.y_pos = (t.options.y)?$('.ytrack .thumb',t.target).css('top').replace(/px/,'')*1:0;

    t.y_pos += delta_y;
    t.x_pos += delta_x;

    if (t.y_pos<0) t.y_pos=0;
    else if (t.y_pos > t.ytrack_h-t.ythumb_h) t.y_pos=t.ytrack_h-t.ythumb_h;
    
    if (t.x_pos<0) t.x_pos=0;
    else if (t.x_pos >t.xtrack_w-t.xthumb_w) t.x_pos=t.xtrack_w-t.xthumb_w;
	
	if (animate) {
		$('.ytrack .thumb',t.target).stop().animate({top:t.y_pos});
        $('.scroll_content',t.target).stop().animate({top:-t.y_pos*t.ratio_y});
        
        $('.xtrack .thumb',t.target).stop().animate({left:t.x_pos});
        $('.scroll_content',t.target).stop().animate({left:-t.x_pos*t.ratio_x});
	}
    else {
        $('.ytrack .thumb',t.target).css('top',t.y_pos);
        $('.scroll_content',t.target).css('top',-t.y_pos*t.ratio_y);
        
        $('.xtrack .thumb',t.target).css('left',t.x_pos);
        $('.scroll_content',t.target).css('left',-t.x_pos*t.ratio_x);
	}

    if (e.preventDefault) e.preventDefault();//  e.preventDefault();
    
    ///if move
    if(t.options.move)t.options.move();
}

  
LNScroll.prototype.drag=function(event)
{
    var touches = event.changedTouches,
        first = touches[0],
        type = '';
    switch(event.type)
    {
        case 'touchstart':
            type = 'mousedown';
            break;        
        case 'touchmove':
            type = 'mousemove';
            event.preventDefault();
            break;        
        case 'touchend':
            type = 'mouseup';
            break;        
        default:
            return;
    }	 
    var simulatedEvent = document.createEvent('MouseEvent');
    simulatedEvent.initMouseEvent(type, true, true, window, 1, first.screenX, first.screenY, first.clientX, first.clientY, false, false, false, false, 0/*left*/, null);
    first.target.dispatchEvent(simulatedEvent);  
}

