#!/usr/bin/perl -w

BEGIN {
	push(@INC,"/home/modules/");
};

use strict;
use utf8;
use Encode;
use Cwd;
use DBI;
use Data::Dumper;
use Encode;
use PgWrapper;
use LWP::UserAgent;
use JSON qw(to_json from_json);

my $MK_PASSWORD_PRE=["acer", "acid", "addy", "afro", "aged", "ahoy", "airy", "alga", "ally", "alma", "aloe", "alps", "amid","ammo", "anna", "anti", "ants", "aqua", "aunt", "area", "argh", "aris", "army", "arts", "axis", "band", "berg", "bike", "boat", "boys", "brim", "bump", "cain", "demo", "ding", "dish", "disk", "earn", "emit", "emmy", "face", "fact", "fist", "five", "fork", "fuse", "fuss", "game", "gaze", "girl", "hole", "isle", "joke", "king", "love", "more", "null", "only", "post", "rest", "soda", "star", "trim", "type", "uniq", "vest", "wink", "zorg"];
sub make_apache2 {
	my ($v,$data)=@_;
	my $s=$v->{hosts}->[0];
	$data=~s/#servername#/$s/g;
	if (@{$v->{hosts}}>1) {
		my $hosts="ServerAlias";
		for (my $i=1;$i<@{$v->{hosts}};$i++) {
			$hosts.=" ".$v->{hosts}->[$i];
		}
		$data=~s/#ServerAlias#/$hosts/g;
	} else {
		$data=~s/#ServerAlias#//g;
	}
	$data=~s/#name#/$v->{name}/eg;
	$data=~s/#erp_folder#/$v->{erp_folder}/eg;
	return $data;
}

sub make_lattenoir {
	my ($v,$data)=@_;
	my $hosts="";
	for (my $i=0;$i<@{$v->{hosts}};$i++) {
		$hosts.="," if $hosts;
		$hosts.="\"".$v->{hosts}->[$i]."\"";
	}
	$data=~s/#hosts#/$hosts/g;
#	if ($v->{error_notify}) {
#		$data=~s/#error_notify#/'	error_notify: ["'.$v->{error_notify}.'"],'/eg;
#	} else {
#		$data=~s/#error_notify#//g;
#	}
	$data=~s/#(\w+)#/$v->{$1} || ""/eg;
	my $config=from_json($data);
	if ($v->{previews}) {
		foreach my $a (split /\s+/,$v->{previews}) {
			next unless $a;
			next unless $a=~/^(\d+)x(\d+)$/;
			push(@{$config->{previews}},[$1*1,$2*1]);
		}
	}
	if ($v->{lattenoir_config_patch}) {
		my $h=from_json($v->{lattenoir_config_patch});
		recursive_json_patch($config,$h);
	}
	$data=to_json($config,{pretty=>1});
	if ($v->{site_design_id}) {
		$data=~s/"!custom_rewriter!"/function(rr) {\n		if (rr.action.match(\/^\\\/client-side-views\/)) rr.jsng_response.response_headers["Access-Control-Allow-Origin"]='*';\n		rr.ln_response.set_no_cache();\n	}/;
	} else {
		$data=~s/"!custom_rewriter!"/function(rr) {\n		if ((rr.action=="\/index\/" || rr.action=="\/") && rr.server_name.match(\/combine-erp\/)) rr.action="\/erp\/redirect\/";\n		if (rr.action.match(\/^\\\/client-side-views\/)) rr.jsng_response.response_headers["Access-Control-Allow-Origin"]='*';\n		rr.ln_response.set_no_cache();\n	}/;
	}
	return $data;
}

sub recursive_json_patch {
	my ($object,$patch)=@_;
	if (ref $patch eq "HASH") {
		while (my ($k,$v)=each %$patch) {
			if (ref $v eq "HASH") {
				$object->{$k}={} unless $object->{$k};
				recursive_json_patch($object->{$k},$v);
			} elsif (ref $v eq "ARRAY") {
				$object->{$k}=[] unless $object->{$k};
				recursive_json_patch($object->{$k},$v);
			} elsif (ref $v) {
				die "TODO? ref \$v=".ref($v);
			} else {
				$object->{$k}=$v;
			}
		}
	} elsif (ref $patch eq "ARRAY") {	
		for (my $i=0;$i<@$patch;$i++) {
			my $p=$patch->[$i];
			push(@$object,$p);
			if (ref $p eq "HASH") {
				$object->[$i]={} unless $object->[$i];
				recursive_json_patch($object->[$i],$p);
			} elsif (ref $p eq "ARRAY") {
				$object->[$i]=[] unless $object->[$i];
				recursive_json_patch($object->[$i],$p);
			} elsif (ref $p) {
				die "TODO? ref \$p=".ref($p);
			} else {
				$object->[$i]=$p;
			}
		}
	} else {
		die "TODO ref \$patch=".ref($patch);
	}
}


sub load {
	my ($name)=@_;
	my $r;
	open IN,$name or die "Cannot open file $name";
	{local $/;$r=<IN>;}
	close IN;
	Encode::_utf8_on($r);
	return $r;
}

sub save {
	my ($name,$data)=@_;
	open OUT,">$name" or die;
	binmode(OUT, ":utf8");
	my $msg="Внимание! Автоматически созданный файл - оригинал доступен по адресу ".getcwd();
	if ($name=~/\.js$/) {
		print OUT "/*********************************************************************************\n *\n * $msg\n *\n *********************************************************************************/\n";
	} else {
		print OUT "################################################################################\n#\n# $msg\n#\n################################################################################\n";
	}
	print OUT $data;
	close OUT;
}


sub run_lwp {
	my ($site,$url,$post,$no_check)=@_;
	my $ua=new LWP::UserAgent();
	my $login="vahvarh";
	my $password="darknesswithin";
	$post->{"do-login"}=1;
	$post->{"no-session"}=1;
	$post->{login}=$login;
	$post->{password}=$password;
	my $url_show=$url;
	my $i=0;
	while (my ($k,$v)=each %$post) {
		next if $k eq "do-login";
		next if $k eq "no-session";
		next if $k eq "login";
		next if $k eq "password";
		$url_show.=$i?"&":"?";
		$url_show.=$k;
		$url_show.="=";
		$url_show.=$v;
		$i++;
	}
	print "$url_show\n";
	my $response=$ua->post("http://".$site->{name}.".combine-erp.ru".$url,$post);
	unless ($response->is_success) {
		print "ERROR doing $url\n";
		print Dumper($post);
		die $response->status_line;
	}
	my $data=$response->decoded_content;
	if ($no_check) {
#		die $data;
		if ($data=~/error/i) {
			print "ERROR doing $url\n";
			print Dumper($post);
			print "$response->status_line\n";
			print Dumper($data);
			exit(1);
		}
		return;
	}
	unless ($data=~/^\{/) {
		print "ERROR doing $url\n";
		print Dumper($post);
		print "ERROR\n";
		print Dumper($data);
		exit(1);
	}
	my $json=from_json($data);
	if ($json->{error}) {
		print "ERROR doing $url\n";
		print Dumper($post);
		print "ERROR\n";
		print Dumper($json);
		exit(1);
	}
	return $json;
}

sub run_lwps {
	my ($site)=@_;
	my $user_password=$MK_PASSWORD_PRE->[int(rand()*@$MK_PASSWORD_PRE)];
	$user_password.=int(rand()*90000+10000);
	run_lwp($site,"/erp/",{mode=>"enable_do",module_code=>"contacts"},1);
	run_lwp($site,"/erp/",{mode=>"enable_do",module_code=>"tasks"},1);
	run_lwp($site,"/erp/",{mode=>"enable_do",module_code=>"papertemplates"},1);
	run_lwp($site,"/erp/",{mode=>"enable_do",module_code=>"sales"},1);
	run_lwp($site,"/erp/",{mode=>"enable_do",module_code=>"skus"},1);

	#{"id":1,"doctype_id":"1","doctype_name":"Карточка компании","doctype_code":"contact_company","user_cr_id":1,"state_id":1,"archived":0,"draft_of_user_id":1,"calc_status":"","extras":{},"json":{"doctype-1":{},"separator-1":{},"name":{"comments":"","value":"TradingView"},"company_side":{},"address":[{}],"description":{},"separator-2":{},"legal_form":{},"legal_name":{},"legal_taxid":{},"legal_vatid":{},"separator-3":{},"comments-1":{},"tasks-1":{},"separator-4":{},"avatar":{},"phone":[{}],"email":[{}],"website":[{}],"im":[{}],"tags":[{}],"files-1":{}},"users":[],"tasks":[],"files":[],"doctype_fks_json":{},"user_dependent":{"params":{"doc_id":1}}}
	my $company=run_lwp($site,"/api/docs/get/",{doctype_code=>"contact_company",ajaj=>1})->{doc};
	$company->{json}->{name}->{value}=$site->{company};
	run_lwp($site,"/api/docs/save/",{doc=>to_json($company),ajaj=>1});

#{"id":2,"doctype_id":"2","doctype_name":"Карточка сотрудника","doctype_code":"contact_person","user_cr_id":1,"state_id":2,"calc_name":" ","archived":0,"draft_of_user_id":1,"calc_status":"has_login=false\nhas_login=false\n","extras":{},"json":{"doctype-1":{},"separator-1":{},"last_name":{"comments":"","value":"Иванов"},"first_name":{"comments":"","value":"Иван"},"second_name":{},"pronouncation":[{}],"prefix":[{}],"division":{},"address":[{}],"separator-2":{},"comments-1":{},"tasks-1":{},"separator-3":{},"avatar":{},"phone":[{}],"email":[{}],"company":[{"value":"1"}],"position":[{}],"website":[{}],"im":[{}],"date_birth":{},"tags":[{}],"files-1":{},"separator-4":{},"has_login":{"value":1},"login":{"comments":"","value":"admin"},"password":{"comments":"","value":"12345"},"user_id":{}},"users":[],"tasks":[],"files":[],"doctype_fks_json":{},"user_dependent":{"params":{"doc_id":2}}}
	my $person=run_lwp($site,"/api/docs/get/",{doctype_code=>"contact_person",ajaj=>1})->{doc};
	$person->{json}->{company}=[{value=>$company->{id}}];

	my @name=split(/\s+/,$site->{username});
	$person->{json}->{last_name}->{value}=$name[0]||"";
	$person->{json}->{first_name}->{value}=$name[1]||"";
	$person->{json}->{second_name}->{value}=$name[2]||"";
	$person->{json}->{user_credentials}={
			has_login=>1,
			login=>"admin",
			password=>$user_password
	};
	$person->{json}->{email}=[{value=>$site->{email}}];
	run_lwp($site,"/api/docs/save/",{doc=>to_json($person),ajaj=>1});
}

{
	my $ua = new LWP::UserAgent();
	my $sql = new PgWrapper("sgsystems_ru","tmppasswd","sgsystems_ru","Pg");
	my @sites = $sql->execute_bind_and_fetch_single("select es.* from tgtm_sites es",{});
#			{folder=>"vahvarh",hosts=>["demo.combine-erp.ru"],"log_sql_queries"=>"log_sql_queries: 'true',\n",client=>"demo"},
	my $id=1;
	foreach my $v (@sites) {
		print "Site ".$v->{name}."\n";
		$v->{hosts} = [$v->{name}.".sgsystems_ru.ru"];
#gd		push(@{$v->{hosts}},split(/\s+/,$v->{aliases})) if $v->{aliases};
		my $used_hosts = {};
		my $possible_redirects = {};
		foreach my $h (@{$v->{hosts}}) {
			$used_hosts->{$h}=1;
			if ($h=~/^www\.(.+)/) {
				$possible_redirects->{$1}=$h;
			} else {
				$possible_redirects->{"www.".$h}=$h;
			}
		}
		$v->{redirect_hosts}=[];
		while (my ($src,$dst)=each %$possible_redirects) {
			next if $used_hosts->{$src};
			push(@{$v->{redirect_hosts}},{src=>$src,dst=>$dst});
		}
#		$v->{log_sql_queries}="log_sql_queries: 'true',\n";
#		die Dumper({redirect=>$v->{redirect_hosts},possible=>$possible_redirects,used=>$used_hosts}) if $v->{name} eq "kollection";
		# TODO создать редиректы
		# TODO создать ssl
		save("/etc/apache2/sites-sgsystems/sgsystems-".$v->{name},make_apache2($v,load("updater_apache2.xml")));
		save("/home/projects/lattenoir/config/sites-enabled/sgsystems-".$v->{name}.".js","exports.site=".make_lattenoir($v,load("updater_lattenoir.js")));
		$id++;
	}
	foreach my $v (@sites) {
		next if -d "SITES/".$v->{name};
		# 4. Создать папку для сайта
		system("cp","-r","SITES/TEMPLATE","SITES/".$v->{name});
	}
	my $cnt_new=0;
	foreach my $v (@sites) {
#		run_lwps($v) if $v->{id}==8;
		next if $v->{initialized};
		print "Initializing site ".$v->{name}."\n";
		my $db="sgsystems_".$v->{db};
		unless (-d "/www/combine-erp/stable-nosvn/html/f-".$v->{name}) {
			# 1. Создать базу
			system("ssh","vahvarh\@easymerch.vcity.ru","./combine-make-new.pl",$v->{db});
			# 2. Заполнить базу
			print "press enter\n";
			<>;
			system("psql","-h","easymerch.vcity.ru","-U",$db,$db,"-f","/home/projects/lattenoir/database/core.sql");
			print "press enter\n";
			<>;
			system("psql","-h","easymerch.vcity.ru","-U",$db,$db,"-f","/home/projects/lattenoir/database/core_insert_ru.sql");
			print "press enter\n";
			<>;
			system("psql","-h","easymerch.vcity.ru","-U",$db,$db,"-f","/home/projects/lattenoir/database/ldm_insert.sql");
			print "press enter\n";
			<>;
			system("psql","-h","easymerch.vcity.ru","-U",$db,$db,"-f","/www/combine-erp/vahvarh/database/database.sql");
			print "press enter\n";
			<>;
			# 3. Создать папку для файлов
			mkdir("/www/combine-erp/stable-nosvn/html/f-".$v->{name});
			# 4. Создать папку для сайта
			# 5. Создать симлинк
			symlink("/www/combine-erp/stable-nosvn/html/f-".$v->{name},"/www/combine-erp/SITES/".$v->{name}."/html/f-".$v->{name});
			# 6. Перезагрузить апач
			system("sudo","/etc/init.d/apache2","reload");
			sleep 5;
		}
		# 7. Создать юзера
		run_lwps($v);
		# initalized=1
		if ($v->{site_design_code}) {
			system("/www/combine-erp/DESIGNS/init.sh",$v->{name},$v->{site_design_code});
		}
		$sql->execute_bind_single("update Terp_sites set initialized=1 where id=:id",{id=>$v->{id}});
		$sql->commit();
		$cnt_new++;
	}
	system("sudo","/etc/init.d/apache2","reload");
}

