#!/usr/bin/perl -w
use strict;
use Encode;
use DirHandle;

{
	my $patch;
	{local $/;$patch=<>;}
	Encode::_utf8_on($patch);
	print "Patching all databases\n";
	my $already={};
	foreach my $dir (
		'/home/projects/lattenoir/config/sites-enabled/',
		'/home/projects/lattenoir/config/sites-sgsystems/') {
		my $dh=new DirHandle($dir);
		my $file;
		while (defined ($file=$dh->read())) {
			next unless $file=~/\.js$/;
			my $r;
			open IN,$dir.$file;
			{local $/;$r=<IN>;}
			close IN;
			die "Cannot parse file '$file'" unless $r=~/"?login"?\s*:\s*"(\w+)"/;
			my $login=$1;
			die "Cannot parse file '$file'" unless $r=~/"?password"?\s*:\s*"(\w+)"/;
			my $password=$1;
			die "Cannot parse file '$file'" unless $r=~/"?database"?\s*:\s*"(\w+)"/;
			my $database=$1;
			$r=~/"?host"?\s*:\s*"([\w\.]+)"/;
			my $host=$1 || "127.0.0.1";
			next if $already->{$database};
			next unless $login=~/^sgsystems_/;
			$already->{$database}=1;
			print "$login/$password\@$database\n";
			open OUT,"|psql -U $login -h $host $database";
			print OUT $patch;
			close OUT;
		}
	}

}

