var http = require('http');
var fs = require('fs');
var proc = new require('process');
var base64 = new require('base64');

var Api = {
	BucketUrl:		'https://developer.api.autodesk.com/oss/v2/buckets',
	TokenUrl:		'https://developer.api.autodesk.com/authentication/v1/authenticate',
	ConsumerKey:	'BqJLKSk1Tb6oamiChauRtCFOjWe9tV65',
	ConsumerSecret:	'0iOmP5oedQ64ks4G',
	AppName: 		'erpGTM',
	Description:	'ИАС Геолого-технического мониторинга Комплексная система для ручного и автоматизированного контроля, сбора, хранения, а также анализа и учета показателей датчиков разных типов на местности в рамках ГТМ',
	CallBackURL:	'http://erp-gtm.relsyst.ru/api/autodesk/',
	WebsiteURL:		'http://erp-gtm.relsyst.ru'
}

var Bucket = {
	key: 'gderpgtm',
};


function error(string, params){
	return JSON.stringify({error:string,info:params||{}});
}

function log(data,name){
	var file_path = '/www/vahvarh/erp-gtm.relsyst.ru/html/'+(name?name:'log')+'.txt';
	var log_file = new fs.File(file_path);
		log_file.open("a");
		log_file.write(new Date());
		log_file.write('\n'+data+'\n');
		log_file.close();
}

exports.add=[{
	_type:"controller",
	_config:{
		name:"ApiAutodesk",
	},
	
	get_access_token: function(){		
		var pr = new proc.Process();
		var command = 'curl --data "client_id='+Api.ConsumerKey+'&client_secret='+Api.ConsumerSecret+'&grant_type=client_credentials" "'+Api.TokenUrl+'" -H "Content-Type: application/x-www-form-urlencoded" -k';
		var r = pr.exec(command);
		var data = JSON.parse(r);
		return data.access_token;	
	},
	
	create_bucket: function(){		
		var token = this.C('ApiAutodesk','get_access_token');		
		var pr = new proc.Process();
		var command = 'curl -k --header "Content-Type: application/json" --header "Authorization: Bearer '+token+'" --data "{\\"bucketKey\\":\\"'+Bucket.key+'\\",\\"policyKey\\":\\"persistent\\"}" "https://developer.api.autodesk.com/oss/v2/buckets"';
		var r = pr.exec(command);
		return r;
	},
	
	get_bucket: function(){		
		var token = this.C('ApiAutodesk','get_access_token');		
		var pr = new proc.Process();
		var command = 'curl -k -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/oss/v2/buckets/mybucket/details';
		var r = pr.exec(command);		
		return r;				
	},
	
	get_extensions_list: function(){		
		var token = this.C('ApiAutodesk','get_access_token');		
		var pr = new proc.Process();
		var command = 'curl  -k --header "Authorization: Bearer '+token+'" https://developer.api.autodesk.com/viewingservice/v1/supported';
		var r = pr.exec(command);
		return r;	
	},
		
	upload_file: function(plan){
				
		var token = this.C('ApiAutodesk','get_access_token');
		
		var log_name = 'logs/'+plan.orig_filename;
		
		var file_name = plan.orig_filename+'.'+plan.ext; //'test_to_uplaod.dxf';
		var file_path = '/www/vahvarh/erp-gtm.relsyst.ru/html'+plan.url; // /html/files/'+file_name;
		var file = new fs.File(file_path);
		
		var content_length = file.stat().size;
		var pr = new proc.Process();
		var command = 	'curl '+
						'--header "Authorization: Bearer '+token+'" '+
						'--header "Content-Length: '+content_length+'" '+
						'-H "Content-Type:application/octet-stream" --header "Expect:" '+
						'--upload-file "'+file_path+'" '+
						'-X PUT https://developer.api.autodesk.com/oss/v2/buckets/'+Bucket.key+'/objects/' + encodeURIComponent(file_name) + ' -k';
						
		log(command,log_name);
		log(encodeURIComponent(file_name),log_name);
		var r = pr.exec(command);
		log(r,log_name);
		
		return r;
	},
	
	
	register_file: function(config){
		
		config = config || {};

		var urn_base64 = base64.encode(config.urn).toString('UTF-8');
		
		var token = this.C('ApiAutodesk','get_access_token');
		var pr = new proc.Process();
		var command = 	'curl -k -H "Content-Type: application/json" -H "Authorization:Bearer '+token+'" -i -d "{\\"urn\\":\\"'+urn_base64+'\\"}" https://developer.api.autodesk.com/viewingservice/v1/register';
		
		log(command);
		
		var r = pr.exec(command);
		
		log(r);
		
		return r;
	},
	
	
	check_register: function(config){
		
		config = config || {};
		var urn_base64 = base64.encode(config.urn).toString('UTF-8');
		
		var token = this.C('ApiAutodesk','get_access_token');
		
		var pr = new proc.Process();
		var command = 	'curl -k -i -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/viewingservice/v1/'+urn_base64+'/status';
		
		log(command);
		
		var r = pr.exec(command);
		
		log(r);
		
		return r;
		
	},	
	
	get_thumbnail: function(config){
				
		//var file = {
		//	"bucketKey" : "gderpgtm",
		//	"objectId" : "urn:adsk.objects:os.object:gderpgtm/test_to_uplaod.dxf",
		//	"objectKey" : "test_to_uplaod.dxf",
		//	"sha1" : "c5a22380311827e3c024f65c084c1c522fcb3a94",
		//	"size" : 84365174,
		//	"contentType" : "application/octet-stream",
		//	"location" : "https://developer.api.autodesk.com/oss/v2/buckets/gderpgtm/objects/test_to_uplaod.dxf"
		//};
		//
		//var urn_base64 = base64.encode(file.objectId).toString('UTF-8');
		
		
		
		
		config = config || {};
			
		//config.urn = "urn:adsk.viewing:fs.file:dXJuOmFkc2sub2JqZWN0czpvcy5vYmplY3Q6Z2RlcnBndG0vJUQwJUJGJUQxJTgwJUQwJUI4JUQwJUJCJUQwJUJFJUQwJUI2JUQwJUI1JUQwJUJEJUQwJUI4JUQwJUI1JTIwJUQwJUIwXyVEMCVCQiVEMCVCOCVEMSU4MSVEMSU4MiUyMDFfZHdnLmR3Zw==/output/a1de18ef-75ee-1f0c-34c3-ce40df35e920_f2d/primaryGraphics.f2d"
		
		var urn_base64 = base64.encode(config.urn).toString('UTF-8');
		
		//urn_base64 = 'dXJuOmFkc2sub2JqZWN0czpvcy5vYmplY3Q6Z2RlcnBndG0vJUQwJUJGJUQxJTgwJUQwJUI4JUQwJUJCJUQwJUJFJUQwJUI2JUQwJUI1JUQwJUJEJUQwJUI4JUQwJUI1JTIwJUQwJUIwXyVEMCVCQiVEMCVCOCVEMSU4MSVEMSU4MiUyMDFfZHdnLmR3Zw';
		
		var thumb_path = '/www/vahvarh/erp-gtm.relsyst.ru/html/files/test_thumb.png';
		
		var token = this.C('ApiAutodesk','get_access_token');
		var guid = config.guid ? ('?guid='+config.guid) : '';
		
		var pr = new proc.Process();
		var command = 	'curl -k -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/viewingservice/v1/thumbnails/'+urn_base64+guid+' > '+thumb_path;
		
		log(command);
		
		var r = pr.exec(command);
		
		log(r);
		
		return thumb_path;
		
	},
	
	
	
	get_data: function(config){
		
		//var file = {
		//	"bucketKey" : "gderpgtm",
		//	"objectId" : "urn:adsk.objects:os.object:gderpgtm/test_to_uplaod.dxf",
		//	"objectKey" : "test_to_uplaod.dxf",
		//	"sha1" : "c5a22380311827e3c024f65c084c1c522fcb3a94",
		//	"size" : 84365174,
		//	"contentType" : "application/octet-stream",
		//	"location" : "https://developer.api.autodesk.com/oss/v2/buckets/gderpgtm/objects/test_to_uplaod.dxf"
		//};
		////urn:adsk.viewing:fs.file:dXJuOmFkc2sub2JqZWN0czpvcy5vYmplY3Q6Z2RlcnBndG0vdGVzdF9kd2dfMi5kd2c=/output/designDescription.json
		//var urn_base64 = base64.encode(file.objectId).toString('UTF-8');
		
		//	throw urn_base64;
	
		config = config || {};
		var urn_base64 = base64.encode(config.urn).toString('UTF-8');
		
		var token = this.C('ApiAutodesk','get_access_token');
		
		var pr = new proc.Process();
		var command = 	'curl -k -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/viewingservice/v1/'+urn_base64;
		
		log(command);
		
		var r = pr.exec(command);
		
		var data = JSON.parse(r);
		
		this.children = data.children;
		
		return this.View('controllers/ApiAutodesk/data');
		
	},
	
	get_item: function(config){
		
		//
		//var urn = 'urn:adsk.viewing:fs.file:dXJuOmFkc2sub2JqZWN0czpvcy5vYmplY3Q6Z2RlcnBndG0vdGVzdF9kd2dfMi5kd2c=/output/ece478e0-865f-468d-e4f0-99e17bed7dbc_f2d/thumbnail_200.png';
		//
		//var urn_decoded = encodeURIComponent(urn);
		
		config = config || {};
		var urn_base64 = base64.encode(config.urn).toString('UTF-8');
		
		var token = this.C('ApiAutodesk','get_access_token');
		
		var pr = new proc.Process();
		//var command = 	'curl -k -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/viewingservice/v1/items/'+urn_decoded;
		
		var thumb_path = '/www/vahvarh/erp-gtm.relsyst.ru/html/files/test_thumb.png';
		var command = 	'curl -k -H "Authorization: Bearer '+token+'" -X GET https://developer.api.autodesk.com/viewingservice/v1/items/'+urn_decoded+' > '+thumb_path;
		
		
		log(command);
		
		var r = pr.exec(command);
		log(r);
		
		return r;
		
	}
	
}];
