// GLOBAL
var Cache = {
	get:function(rr,model,id){
		if (!Cache[model]) Cache[model] = {};
		if (!Cache[model][id]) Cache[model][id] = rr.M[model].Get(id);
		return Cache[model][id];
	},
	set:function(rr,model,id){
		if (!Cache[model]) Cache[model] = {};
		Cache[model][id] = rr.M[model].Get(id);
	}
}

// MODULES
var fs = require("fs");
var base64 = new require('base64');
var proc = new require('process');

// RESPONSE helpers
var to_json = function(data){ return JSON.stringify(data); }
var error = function(text){ return to_json({error:text}); }

// DATE helpers
function pad(n){return n<10?'0'+n:n;}
function date_to_xlsx(date) { return date.match(/^(\d+)-(\d+)-(\d+)$/).reverse().slice(0,3).map(function(el){return parseInt(el); }).join('.'); }
function ExcelDateToJSDate(serial) {
   var utc_days  = Math.floor(serial - 25569);
   var utc_value = utc_days * 86400;                                        
   var date_info = new Date(utc_value * 1000);
   var fractional_day = serial - Math.floor(serial) + 0.0000001;
   var total_seconds = Math.floor(86400 * fractional_day);
   var seconds = total_seconds % 60;
   total_seconds -= seconds;
   var hours = Math.floor(total_seconds / (60 * 60));
   var minutes = Math.floor(total_seconds / 60) % 60;
   return [ pad(date_info.getDate()), pad(date_info.getMonth()+1), date_info.getFullYear() ].reverse().join('-');
}
function date_to_bd_from_xlsx(date){
	var arr = date.match(/^(\d+)\.(\d+)\.(\d+)$/);
	if (arr && arr.length) return arr.reverse().slice(0,3).map(pad).join('-');
//	var date = new Date((parseInt(date)-1)*24*60*60*1000);
//	date.setFullYear(date.getFullYear()-70);
//	return date.getFullYear()+'-'+pad(date.getMonth()+1)+'-'+pad(date.getDate());
	return ExcelDateToJSDate(date);
}

exports.add=[{
	_type:	"controller",
	_config:{ name:"GTM" },
	
	init:function(){		
		var t = this;		
		var data = this.C('GTM',this.fields.section);
		return to_json(data);				
	},
	
	plans:function(){
		
		var plan = this.M['Plan'].Get(this.fields.plan_id);
		if (plan) plan.Check();
		
		return {
			plan: plan,
			plans: this.M['Plan'].List('list_exists'),
			dictionaries: {
				PlanFormat: this.M['PlanFormat'].List()
			}
		}		
	},
	
	delete_plan: function(){
		
		var facilities = this.M['Facility'].List('list_by_plan_exists',{ plan_id:this.fields.plan_id });
		if (facilities.length) return error('Невозможно удалить чертеж, так как он уже используется!');
		
		var plan = this.M['Plan'].Get(this.fields.plan_id);
			plan.deleted = 1;
			plan.SaveAll();
			
		return JSON.stringify({ok:1});		
	},
	
	create_plan: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var plan = this.M['Plan'].Create(this.fields.plan_id);
		
			plan.name = this.fields.name;
			plan.format_id = this.fields.format_id;
		
		if (!plan.name)		return error('Не указано наименование');
		if (!plan.format_id)	return error('Не указан формат');
		
		// PDF
		plan.pdf_id = this.F('Files','user_upload_file',{
			ff_id:14,
			inputname: 'pdf_plan'
		});
		
		if (!plan.pdf_id) return error('Не загружен PDF');
		
		// calc PDF
		var path = '/www/vahvarh/erp-gtm.relsyst.ru';
		
		var merge_script_path  = path +'/scripts/pdf/merge.sh';		
		var merge_pdf = function(pdf1,pdf2,result) {
			var pdf1_path = pdf1;
			var pdf2_path = pdf2;
			var result_path = result;
			var command = merge_script_path +' '+ pdf1_path +' '+pdf2_path +' '+result_path;
			var pr = new proc.Process();
			pr.system(command);
			return command;
		}
		
		var pdf_url = this.M['File'].Get(plan.pdf_id).url;
		var format_url = this.M['PlanFormat'].Get(plan.format_id).pdf_url;
		
		
		var result_path = path + '/html/plans/results/tmp2.pdf';
		
		merge_pdf(
			path + '/html' + pdf_url,
			path + '/html' + format_url,
			
			result_path
		);
		
		plan.calc_pdf_id = this.F('Files','user_upload_file',{
			ff_id:14,
			existingfile: result_path
		});
		
		if (!plan.calc_pdf_id) return error('Не удалось сгенерировать pdf');
		
		// JPG
		var path = '/www/vahvarh/erp-gtm.relsyst.ru/';
		var script_path = path + 'scripts/pdf/pdf_to_jpg.sh';
		
		var img_path = path + 'html/tmp_img.jpg';
//		var pdf_path = path + 'html' + pdf_url;
		var pdf_path = path + 'html' + this.M['File'].Get(plan.calc_pdf_id).url;
		
		var command = script_path + ' ' + pdf_path + ' ' + img_path;
			
		var pr = new proc.Process();
			pr.system(command);
			
		plan.jpg_id = this.F('Files','user_upload_file',{
			ff_id:14,
			existingfile: img_path
		});
		
		//if (!plan.jpg_id)	return error('Не удалось создать JPG изображение');
		
		// DWG
		plan.dwg_id = this.F('Files','user_upload_file',{
			ff_id:14,
			inputname: 'dwg_plan'
		});
		
		//if (!plan.dwg_id)		return error('Не загружен DWG');
		
		plan.SaveAll();
		
		return to_json({id:plan.id});
	},
	
	users:function(){
		
		var user = this.M['User'].Get(this.fields.user_id) || {};
		var roled = this.M['UserEnrolled'].List('list_of_user',{user_id:user.id}).reduce(function(h,el){ h[el.role_id] = el; return h; },{});
		
		return {
			user: user,
			roles: this.M['Role'].List().filter(function(el){ return el.code.match(/gtm_\w+/); }).map(function(el){
				el.enabled = roled[el.id];
				return {
					name:el.name,
					enabled:el.enabled ? 1 : 0,
					id:el.id
				};
			}),
//			dictionaries: {
//				roles: this.M['Role'].List().filter(function(el){ return el.code.match(/gtm_\w+/); })
//			},
			users: this.M['User'].List().filter(function(el){ return el.id>13; }),
		}		
	},
	
	edit_user: function(){
		
		if (!this.roles || !this.roles['gtm_settings']) throw 'Нет прав';
		
		if (!this.fields.name) return error('Не указано имя');
		if (!this.fields.login) return error('Не указан login');
		if (!this.fields.password) return error('Не указан пароль');
		
		var user = this.M['User'].Get(this.fields.user_id) || this.M['User'].Create();
		if (!user.id && this.M['User'].Get('get_of_login',{login:this.fields.login.toLowerCase()})) return error('Пользователь уже существует');
		
		user.first_name = this.fields.name;
		user.login = this.fields.login.toLowerCase();
		user.password = this.fields.password;
		user.enabled = 1;
		user.calc_no_roles = 0;
		user.SaveAll();
		
		var roles = this.M['UserEnrolled'].List('list_of_user',{user_id:user.id}).reduce(function(h,el){ h[el.role_id] = el; return h;},{});
		
		for (k in this.fields) if (k.match(/^role_(\d+)/)) {
			var id = k.match(/^role_(\d+)/)[1];
			if (roles[id]) delete roles[id];
			else {
				var role = this.M['UserEnrolled'].Create();
				role.user_id = user.id;
				role.role_id = id;
				role.SaveAll();
			}
		}
		for (k in roles) roles[k].Delete();
		
		user.calc_no_roles = 0;
		user.SaveAll();
			
		return to_json({id:user.id});
		
	},
	
	delete_user: function(){},
	
	
	analytics:function(){

		var tree = this.F('GTM','get_tree');
		return 	{			
			dictionaries: {
				SensorModel: this.M['SensorModel'].List(),
				SensorModelType: this.M['SensorModelType'].List(),
				AllowedModelType: this.M['AllowedModelType'].List(),
				AllowedValueType: this.M['AllowedValueType'].List(),
				SensorState: this.M['SensorState'].List(),
			},
			tree: tree,
			facilities: tree,
		}	
	},
	
		
	get_full_stat: function(){
		
		if (!this.roles || !this.roles['gtm_analytics']) throw 'Нет прав';
		
		var t = this;
		
		var facilities = this.fields.facilities.split(',');
		var models = this.fields.models.split(',');
		var states = this.fields.states.split(',');
		
		var stats = {};
		var date = this.fields.date_to;
		
		stats[date] = {};
		
		facilities.forEach(function(facility_id){
			if (!facility_id) return;
			t.fields.facility_id = facility_id;
			var stat = t.F('GTM','get_stat',undefined,1);
			stats[date][facility_id] = JSON.parse(stat.data);
		});
		
		return to_json(stats);
	},
	
	dashboard:function(){
		return {
			tree: this.F('GTM','get_tree'),
			dictionaries: {
				Plan: this.M['Plan'].List(),
				PlanFormat: this.M['PlanFormat'].List(),
				SensorModel: this.M['SensorModel'].List(),
				SensorModelType: this.M['SensorModelType'].List(),
				AllowedModelType: this.M['AllowedModelType'].List(),
				AllowedValueType: this.M['AllowedValueType'].List(),
				SensorState: this.M['SensorState'].List(),
				MeasurementMode: this.M['MeasurementMode'].List(),
				BasePaddingPrinciple: this.M['BasePaddingPrinciple'].List(),
				NormativeType: this.M['NormativeType'].List(),
				FacilityType: this.M['FacilityType'].List(),
				FacilityState: this.M['FacilityState'].List(),
				Sizes: [
					{id:'0.25',	name:'x0.25'},
					{id:'0.5',	name:'x0.5'},
					{id:'0.75',	name:'x0.75'},
					{id:'1',	name:'x1'},
					{id:'1.25',	name:'x1.25'},
					{id:'1.5',	name:'x1.5'},
					{id:'1.75',	name:'x1.5'},
					{id:'2',	name:'x2'},
				],
			}
		};
		
	},
	
	get_facility: function(){
		
		var t = this;
		
		var facility = this.M['Facility'].Get(this.fields.facility_id);
		var parent = this.M['Facility'].Get(facility.parent_id);
		
		var arr = [facility];
		if (parent) arr.push(parent);
		
		arr.forEach(function(el){
			el.facilities = t.M['Facility'].List('list_level',{parent_id:el.id}).filter(function(el){ return !el.deleted; });
			el.sensors = t.M['Sensor'].List('list_of_facility',{facility_id:el.id}).filter(function(el){ return !el.deleted; });
			el.groups = t.M['FacilityGroup'].List('list_of_facility',{facility_id:el.id});
			el.sensors_groups = t.M['SensorGroup'].List('list_of_facility',{facility_id:el.id});
			el.explication = t.M['Explication'].Get('get_by_facility',{ facility_id:el.id }) || {};
		});
		
		return to_json({
			tree: this.F('GTM','get_tree'),
			facilities:arr
		});
	},
	
	delete_facility: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var facility = this.M['Facility'].Get(this.fields.id);
			facility.deleted = 1;
			facility.SaveAll();
		return to_json({
			tree:this.F('GTM','get_tree')	
		});
	},
	
	get_history: function(){
		return to_json({ history:this.M['EditHistory'].List('list_by_facility',{ facility_id:this.fields.facility_id })});
	},
	
	save_normatives: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var reg = /^type_(\d+)$/;
		var params;
		var arr;
		for (k in this.fields) if (arr=k.match(reg)) {
			params = { type_id:arr[1], value:this.fields[k], facility_id:this.fields.facility_id };
			this.M['Normative'].GetOrCreate('get_by_facility_n_type',params).SaveAll();
		}		
		return this.C('GTM','get_facility');	
	},
	
	save_stamp: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var facility = this.M['Facility'].Get(this.fields.facility_id);
			facility.stamp_data = this.fields.data;
			facility.SaveAll();
		return this.C('GTM','get_facility');	
	},
	
	save_new_facility: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		var facility = 	this.M['Facility'].Create();
		
		['name','plan_id','parent_id'].forEach(function(k){
			facility[k] = t.fields[k];
		});
		
		if (!facility.name) return error('Не указано имя');
		if (!facility.plan_id) return error('Не указан чертеж');
		
		facility.location_x = 50;
		facility.location_y = 50;
		
		
		facility.table_x = 250;
		facility.table_y = 50;
		
		facility.convention_x = 250;
		facility.convention_y = 150;
		
		facility.element_size = 1.00;
		
		facility.show_explication = 1;
		facility.show_convention = 1;
		
		facility.history_type = 'new';
		
		facility.SaveAll();
		
		var r = {
			tree:this.F('GTM','get_tree'),
		};
		
		if (facility.parent_id) {
			this.fields.facility_id = facility.parent_id;
			return this.C('GTM','get_facility');	
		} else{
			return to_json(r);	
		}
		
	},
	
	save_coords: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		
		var type = this.fields.type;
		var model_name = this.fields.model_name;
		var model = this.M[model_name].Get(this.fields.model_id);
		
		if (type=='explication') ['table_x','table_y'].forEach(function(k){ model[k] = parseInt(t.fields[k]) || 0; });
		if (type=='convention') ['convention_x','convention_y'].forEach(function(k){ model[k] = parseInt(t.fields[k]) || 0; });
		if (type=='element') ['location_x','location_y'].forEach(function(k){ model[k] = parseInt(t.fields[k]) || 0; });
		
		model.SaveAll();
		
		return this.C('GTM','get_facility');
	},
	
	save_clip: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var model_name = this.fields.model_name;
		var model = this.M[model_name].Get(this.fields.id);
		
		model.clipmap = this.fields.clipmap;
		model.SaveAll();
		
		return this.C('GTM','get_facility');
	},
	
	save_facility: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;		
		
		if (!this.fields.facility_id) throw 'no facility id!';
		
		var facility = this.M['Facility'].Get(this.fields.facility_id);
		
		[
		 'name',
		 'base_principle_id',
		 'type',
		 'state_id',
		 'base_type',
		 'base_construction',
//		 'clipmap',
		 'dumping_depth',
		 'protection',
		 'allowed_deformation',
		 'allowed_temperature',
		 'responsibility_level',
		 'negative_process',
		 'show_explication',
		 'show_convention',
		 'frozen_depth'
		 ].forEach(function(k){ facility[k] = t.fields[k]; });
		
		[
		 'load_capacity',
		 'element_size',
		 'table_size',
		 'foundation_depth'
		 ].forEach(function(k){ facility[k] = parseFloat(t.fields[k]) || 0; });
		
		if (!facility.name) return error('Не указано имя');
		if (!facility.plan_id) return error('Не указан чертеж');
		
		facility.history_type = 'edit';
		
		facility.SaveAll();
		
		return this.C('GTM','get_facility');
		
	},
	
	save_sensor:function(){	// используется для создания, сохранения, а так же для изменения положения элемента
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		var sensor;
		if (this.fields.id) {
			sensor = this.M['Sensor'].Get(this.fields.id);
			sensor.history_type='edit';
			
		} else {
			sensor = this.M['Sensor'].Create();
			sensor.history_type='new';
			sensor.facility_id = this.fields.facility_id;
		}
		
		if (!sensor.facility_id) return error('Не указан объект');
		
		[
		 'name',
		 'state_id',
		 'reference_date',
		 'image_id',
		 'measurement_period',
		 'measurement_mode_id',
		 'is_retranslator',
		 ].forEach(function(k){ sensor[k] = t.fields[k]; });
		
		if (!sensor.id) ['allowed_model_type_id'].forEach(function(k){ sensor[k] = t.fields[k]; });
		
		if (!sensor.id) [
		 'deep',
		 'deep_step'].forEach(function(k){ sensor[k] = parseFloat(t.fields[k]) || 0; });
		
		['angle'].forEach(function(k){ sensor[k] = parseFloat(t.fields[k]) || 0; });
		
		[
		 'location_x',
		 'location_y'].forEach(function(k){ sensor[k] = parseInt(t.fields[k]) || 50; });
		
		if (!sensor.name) return error('Не указано наименование');
		if (!sensor.allowed_model_type_id) return error('Не указана конструкция');
		if (!sensor.state_id) return error('Не указано состояние');
		
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
				
		if (amt.has_braid && !sensor.deep)  return error('Не указана глубина'); 
		if (amt.has_braid && !sensor.deep_step) return error('Не указан шаг глубины');
				
		sensor.SaveAll();
		
		this.F('GTM','save_braid',sensor);
		
		this.fields.facility_id = sensor.facility_id;		
		return this.C('GTM','get_facility');
	},
	
	delete_sensor: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var sensor = this.M['Sensor'].Get(this.fields.id);
			sensor.deleted = 1;
			sensor.history_type='delete';
			sensor.SaveAll();
			
		this.fields.facility_id = sensor.facility_id;		
		return this.C('GTM','get_facility');
	},
	
	get_braid: function(){
		var braids = this.M['Braid'].List('list_by_sensor',{ sensor_id:this.fields.sensor_id });
		return JSON.stringify({ braids:braids });
	},
	
	save_enable_braid: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		var braids = JSON.parse(this.fields.braids);
		for (k in braids) {
			var braid = t.M['Braid'].Get(k);
			braid.enabled = braids[k];
			braid.SaveAll();
		}
		return JSON.stringify({ok:1});
	},
	
	save_group:function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		var group;
		
		if (this.fields.id) {
			group = this.M['FacilityGroup'].Get(this.fields.id);
			group.history_type = 'edit';
		} else {
			group = this.M['FacilityGroup'].Create();
			group.facility_id = this.fields.facility_id;
			group.history_type = 'new';
		}
		
		if (!group.facility_id) return error('Не указан объект');
		
		['name'].forEach(function(k){ group[k]=t.fields[k]; });
				
		if (!group.name) return error('Не указано наименование'); 
				
		group.SaveAll();
		
		this.fields.facility_id = group.facility_id;
		return this.C('GTM','get_facility');
	},
	
	save_sensor_group:function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		var reg = /^(\d+)$/;
		var sensor = this.M['Sensor'].Get(this.fields.sensor_id);
		
		var sensor_groups = this.M['SensorGroup'].List('list_of_sensor',{ sensor_id:sensor.id }).reduce(function(h,el){ h[el.group_id]=el; return h; },{});
		for (k in this.fields) if (parseInt(this.fields[k]) && k.match(reg)) {
			var group_id = k.match(reg)[1];
			if (sensor_groups[group_id]) {
				delete sensor_groups[group_id];
				continue;
			}
			this.M['SensorGroup'].GetOrCreate('get_by_group_n_sensor',{ sensor_id:sensor.id, group_id:group_id }).SaveAll();
		}
		
		for (k in sensor_groups) sensor_groups[k].Delete();
		
		this.fields.facility_id = sensor.facility_id;
		return this.C('GTM','get_facility');
	},
	
	get_facility_comments: function(config){
		
		var t = this;
		
		config = config || {};
		
		var params = { facility_id:config.facility_id || this.fields.facility_id };
		var comments = this.M['FacilityComment'].List('list_of_facility',params);
		var photos = this.site.sql.execute_and_fetch('images/list_of_facility',params);
		
		var images = {};
		photos.forEach(function(el){
			if (!images[el.comment_id]) images[el.comment_id] = [];
			images[el.comment_id].push( t.M['File'].Get(el.image_id) );
		});
		
		var r = { comments:comments, images:images, type:'facility', id:this.fields.facility_id };
		
		return config.facility_id ? r : to_json(r);
	},
	
	get_sensor_comments: function(config){
		
		var t = this;
		
		config = config || {};
		
		var params = { sensor_id:config.sensor_id || this.fields.sensor_id };
		var comments = this.M['SensorComment'].List('list_of_sensor',params);
		var photos = this.site.sql.execute_and_fetch('images/list_of_sensor',params);
		
		var images = {};
		photos.forEach(function(el){
			if (!images[el.comment_id]) images[el.comment_id] = [];
			images[el.comment_id].push(t.M['File'].Get(el.image_id));
		});
		
		var r = { comments:comments, images:images, type:'sensor', id:this.fields.sensor_id };
		
		return config.sensor_id ? r : to_json(r);
	},
	
	save_facility_comment: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		
		if (this.fields.id) this.fields.facility_id = this.fields.id;
		
		var images_ids = this.F('GTM','upload_images');
		
		var comment = 	this.M['FacilityComment'].Get(this.fields.comment_id) ||
						this.M['FacilityComment'].Create();
						
		if (!comment.id) {
			comment.user_cr_id = this.uid;
			comment.facility_id = this.fields.facility_id;
		}
						
		comment.body = this.fields.body;
		comment.images_json = this.fields.images_json || {};
		
		comment.SaveAll();
		
		if (!this.fields.comment_id) {
			var text = 'Добавлен комментарий к объекту';
			this.F('GTM', 'save_history', comment, 'FacilityComment', this.fields.facility_id, text );
		}
		
		if (this._get_comment) return comment;
						
		var images = {};
		this.M['FacilityCommentImage'].List('list_of_comment',{ comment_id:comment.id }).forEach(function(el){ images[el.id]=1; });
		
		images_ids.forEach(function(id){
			if (!id) return;
			if (images[id]) delete images[id];
			else {
				var img = t.M['FacilityCommentImage'].Create();
				img.comment_id = comment.id
				img.image_id = id;
				img.SaveAll();
			}
		});
		
		for (k in images) images[k].Delete();
		
		return this.C('GTM','get_facility_comments');
	},
	
	save_sensor_comment: function(){
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		
		if (this.fields.id) this.fields.sensor_id = this.fields.id;
		
		var images_ids = this.F('GTM','upload_images');
		
		var comment = 	this.M['SensorComment'].Get(this.fields.comment_id) ||
						this.M['SensorComment'].Create();
						
		if (!comment.id) {
			comment.user_cr_id = this.uid;
			comment.sensor_id = this.fields.sensor_id;
		}
						
		comment.body = this.fields.body;
		comment.images_json = this.fields.images_json || {};
		
		comment.SaveAll();
		
		if (!this.fields.comment_id) {
			var sensor = this.M['Sensor'].Get(this.fields.sensor_id);
			var text = 'Добавлен комментарий для элемента ' + sensor.name;
			this.F('GTM', 'save_history', comment, 'FacilityComment', sensor.facility_id, text );
		}
		
		if (this._get_comment) return comment;
						
		var images = {};
		this.M['SensorCommentImage'].List('list_of_comment',{ comment_id:comment.id }).forEach(function(el){ images[el.id] = 1; });
		
		images_ids.forEach(function(id){
			if (!id) return;
			if (images[id]) delete images[id];
			else {
				var img = t.M['SensorCommentImage'].Create();
				img.comment_id = comment.id
				img.image_id = id;
				img.SaveAll();
			}
		});
		
		for (k in images) images[k].Delete();		
		
		return this.C('GTM','get_sensor_comments');
	},
	
	all_values: function(){
		
		// получаем значения по всем элементам заданного объекта
		// делаем все через режим 'get_values' предназначенный для формирования значений для одного элемента (не факт правда, что он будет использоваться гдето еще)
		// для этого кешируем элементы чтобы по несколько раз не тянуть их
		
		var t = this;
		this.all = 1;
		var values = [];
		this.M['Sensor'].List('list_of_facility',{ facility_id:this.fields.facility_id }).filter(function(el){ return !el.deleted; }).forEach(function(el){
			Cache.set(t,'Sensor',el.id);
			t.fields.id = el.id;
			var data = t.C('GTM','get_values');
			for (k in data) values.push(data[k]);
		});
	
		return t.xml ? values : to_json(values);
	},
	
	get_values: function(){
		
		var t = this;
		
		// контроллер может вызываться не напрямую - поэтому требуется кеш
		var sensor = Cache.get(this,'Sensor',this.fields.id);
		var amt = Cache.get(this,'AllowedModelType',sensor.allowed_model_type_id);
		var avts = this.M['AllowedValueType'].List('list_by_allowed_model',{ allowed_model_type_id:amt.id }); // todo - Cache
		
		// тут тонкий момент - один элемент может иметь только свои значения
		// либо элемент может иметь только косу значений
		// а еще элемент может иметь косу значений и свои значения вместе
		
		// функа формирования таблицы на клиенте выводит либо свои значения либо косы
		
		// выходные данные
		var r = {};
		var own_data   = { dates:[], values:[], sensor_id:sensor.id, params_length:avts.length, type:'own'	 };
		var braid_data = { dates:[], values:[], sensor_id:sensor.id, params_length:avts.length, type:'braid' };
		
		// параметры запроса значений
		var params = {
			sensor_id:	sensor.id,
			days: 		this.fields.days,	// 5
			date_to: 	this.fields.date_to // '2015-10-05'
		};
		
		if (amt.has_own_values) { // для формирования строк собственных значений элемента
		
			// получаем выборку вида [{date:'20.08.2019',avt_id:1,value:1}, ... , {...}]
			// выборка устроена так что в ней обязательно будут все даты за выбранный интервал
			var arr = this.site.sql.execute_and_fetch('values/list_by_sensor',params);
			
			// получаем хеш для доступа к значениям по пути allowed_value_type -> date -> value
			var avt_hash = {};
			avts.forEach(function(el){
				avt_hash[el.id] = {};	
			});
			
			var dates_hash={};
			arr.forEach(function(el){
				if (!el.date) return;
				
				dates_hash[el.date] = 1;
				
				if (!el.allowed_value_type_id) return;
				try {
					
				
				if (el.allowed_value_type_id) avt_hash[el.allowed_value_type_id][el.date] = el.value;
				} catch(e){
					
					throw sensor.id;
				}
			});
			
			
			// собираем массив всех дат для удобства чтобы не собирать его на клиенте а также на какие-то даты может не быть значений
			var dates = [];
			for (k in dates_hash) dates.push(k);
			
			/* и перебираем все в массив значений вида, где на дату приходит несколько занчений в зависимости от avts.length
			 * [
				1,2,		// date_1
				null,5,		// date_2
				null,null,	// date_3
				...
				4,null		// date_n
			]*/
						
			var values = [];
			dates.forEach(function(d){
				avts.forEach(function(at){
					values.push(avt_hash[at.id][d]);
				});
			});
			
			//  тем самым получили готовую строку для таблицы вида
			//	|-----------------------------------|
			//	|	date_1	|	date_2	|	date_3	|
			//	|-----------------------------------|
			//	| p_1 | p_2 | p_1 | p_2 | p_1 | p_2 |
			//	|-----------------------------------|
			//  |	v |  v  |  v  |  v  |  v  |  v  |
			//	|-----------------------------------|
			
			own_data.dates = dates;
			own_data.values = values;
			own_data.avts = avts.map(function(el){return el.id;});
			own_data.params_length = avts.length;
			
			r.own_data = own_data;
		}
		
		if (amt.has_braid) {
			
			// собираем хеш косы по глубине
			var deep_hash = {};
			var deeps = this.M['Braid'].List('list_by_sensor_enabled',{ sensor_id:sensor.id }).map(function(el){
				deep_hash[el.deep] = {};
				return el.deep;
			});
			
			// собираем хеш значений по датам и по глубино_датам
			// то есть доступ к значению по пути deep -> date -> value
			// опятьже выборка значений дает нам все даты на интервале даже при оствуствии на них значений
			var dates_hash = {};
			this.site.sql.execute_and_fetch('values/list_by_sensor_braid',params).forEach(function(el){
				dates_hash[el.date] = 1;
				if (el.deep!=undefined) deep_hash[el.deep][el.date] = el.value;	
			});
			
			// собираем массив всех дат для удобства чтобы не собирать его на клиенте а также на какие-то даты может не быть значений
			var dates = [];
			for (k in dates_hash) dates.push(k);
			
			/* собираем массив вида
			 *[
				['v_on_date_1','v_on_date_2',...,'v_on_date_n'],	// deep_1
				[null,'v_on_date_2',...,'v_on_date_n'],				// deep_1
				...
				['v_on_date_1',...,null] 							// deep_n
			]
			*/
			var values = [];
			deeps.forEach(function(dp){
				var item = [dp];
				dates.forEach(function(d,i){
					item.push(deep_hash[dp][d]);
				});
				values.push(item);
			});
			
			// то есть получаем массив строк для таблицы вида
			//	|---|-----------------------------------|
			//	|   |	date_1	|	date_2	|	date_3	|
			//	|---|-----------------------------------|
			//  | 1 |     v     |     v     |     v     |
			//  | 2 |     v     |     v     |     v     |
			//  | 3 |     v     |     v     |     v     |
			//  |---|-----------------------------------|
			
			braid_data.dates = dates;
			braid_data.values = values;
			braid_data.avts = avts.map(function(el){return el.id;});
			braid_data.params_length = 1;
			r.braid_data = braid_data;
		}
			
		return t.result_to_string ? JSON.stringify(r) : r;
	},
	
	save_values: function(){
		var t = this;
		var data = JSON.parse(this.fields.data);
		data.forEach(function(el){ t.F('GTM','save_value',el); });
		return to_json({ok:1});
	},
	
	pdfs: function(){
		
		var t = this;
		
		var data = this.C('GTM','get_facility');
		var facility = JSON.parse(data).facilities[0];
		
		var path = '/www/vahvarh/erp-gtm.relsyst.ru';
		
		// 1) gen pdf from svg
		this._server = 1;
		this.size = 1;
		
		this.sensor_size = facility.element_size || 1;
		this.row_size = 0.65;
		
		this.width = this.fields.width;
		this.height = this.fields.height;
		
		var sensors = facility.sensors.map(function(el){ el.type='sensor'; return el; });
		var facilities = facility.facilities.map(function(el){ el.type='facility'; return el; });
		
		var colors = {
			dismantle:'#A9AAAF',
			unavailable:'#009B9E',
			unequip:'#352469',
			unmount:'#F1EA50',
			work:'#008E3E',
			damaged:'#F12D25',
		};
		
		this.table = {
			on:	facility.show_explication && 1,
			y: 	facility.table_y || 10,
			x:	facility.table_x || 10,
			row_height: '30',
			txt_height: '20',
			col1_width: '50',
			txt1_x: '5',
			txt2_x: '55',
			col2_width: '200',
		};
		
		var format = this.M['PlanFormat'].Get(facility.plan.format_id);
		var explication_data = JSON.parse(format.explication_data);

		var amt_hash = this.M['AllowedModelType'].List().reduce(function(h,el){h[el.id]=el;return h;},{});
		var filters = JSON.parse(this.fields.filters||'0') || null;
		var check = function(item,f){
			if (!item.type) item.type='sensor';
			if (item.type=='sensor') {
				var model_id = amt_hash[item.allowed_model_type_id].sensor_model_id;
				if (f.ret && !item.is_retranslator) return false;
				if (f.states && !f.states[item.state_id]) return false;
				if (f.models && !f.models[model_id]) return false;
				if (f.sensors && !f.sensors[item.id]) return false;
				if (f.groups && !f.groups[item.id]) return false;
			}
			if (item.type=='facility') {
				return false;
				if (f.facilities && !f.facilities[item.id]) return false;
			}
			return true;
		};
		
		var conventions = {};
			
		this.items = sensors.concat(facilities).filter(function(el){
			if(!filters) return true;
			return check(el,filters);
		}).map(function(el,i){
			el.x = el.location_x*t.size - (t.sensor_size/2) * 50;
			el.y = el.location_y*t.size - (t.sensor_size/2) * 50;
			el.a = el.angle || 0;
			el.stroke_css = 'stroke:' + colors[el.state_code] + ';';
			el.fill_css = 'fill:' + colors[el.state_code] + ';';
			if (el.type=='facility') {
				el.stroke_css = 'stroke:#00a1fb;';
				el.fill_css = 'fill:#00a1fb;';	
			}
			if (el.type=='sensor') {
				el.table_y = t.table.row_height*i;
			}
						
			var code = el.allowed_model_type_code ? (el.allowed_model_type_code + '_' + el.state_code) : 'f';
			var v;
			if (el.allowed_model_type_id) {
				var m = amt_hash[el.allowed_model_type_id];
				v = m.sensor_model_name+' '+m.sensor_model_type_name+', '+el.state_name;
			} else v =  'Объект';
			conventions[code] = v;
			
			return el;
		});
		
		this.conventions = [];
		
		for (k in conventions) {
			var arr = k.match(/(\w+)_(\w+)/);
			var code = state = '';
			if (arr && arr.length) { code = arr[1]; state = arr[2]; }
			else code = 'f';
			this.conventions.push({ code:code, state:state, name:conventions[k], fill_css: 'fill:' + colors[state] + ';', stroke_css : 'stroke:' + colors[state] + ';' })
		}
				
		this.conventions.x = facility.convention_x;
		this.conventions.y = facility.convention_y;
		
		if (!facility.show_convention) delete this.conventions;
		
		var svg = this.View('client-side/website/GTM/dashboard/svg');
		
		var tmp_svg_path = path + '/html/tmp.svg';
		var svg_pdf_path = path + '/html/tmp.pdf';
		
		var f = new fs.File(tmp_svg_path);
			f.open("w");
			f.write(svg);
			f.close();
				
		var svg_to_pdf_command =
			path + '/scripts/pdf/svg_to_pdf.sh ' +
			svg_pdf_path + ' ' +
			tmp_svg_path;
			
		var pr = new proc.Process();
		pr.system(svg_to_pdf_command);
				
		// 2) merge
		
		var merge_script_path  = path +'/scripts/pdf/merge.sh';		
		var merge_pdf = function(pdf1,pdf2,result) {
			
			var pdf1_path = pdf1;
			var pdf2_path = pdf2;
			var result_path = result;
			
			var command = merge_script_path +' '+ pdf1_path +' '+pdf2_path +' '+result_path;
			
			var pr = new proc.Process();
			pr.system(command);
			
			return command;
		}
		
		// 2.1) merge plan+svg
		var tmp_pdf_path = path + '/html/tmp2.pdf';
		
		merge_pdf(
			path + '/html' + facility.plan.pdf_url,
			svg_pdf_path,
			tmp_pdf_path
		);
		
		// 2.2) merge format+(plan,svg)
		
		var result_url = '/' + (this.site.paths.uploads_subfolder||'') + 'plans/results/'+facility.id+'.pdf';
		var result_path = path + '/html'+ result_url;
		
		
		
		merge_pdf(
			tmp_pdf_path,
			path + '/html' + format.pdf_url,
			result_path
		);
		
//		throw result_path;
		
		//3) gen pdf table from html
		
//		var m = 6.736;
		var pdf_stamp_path = path + '/html/pdfs/stamp'+facility.id+'.pdf';
		var pdf_stamp_url = 'http://erp-gtm.relsyst.ru/pdfs/stamp'+facility.id+'.pdf';
		var html_stamp_url = 'http://' + this.site.names[0] + '/stamp_gen/' + facility.id + '/'+Math.round(this.width-1)+'/'+Math.round(this.height-1)+'/';		
		var command  = path + "/scripts/pdf/html_to_pdf.sh " + format.width + ' ' + format.height + ' ' + html_stamp_url + ' ' + pdf_stamp_path;
		
//		throw html_stamp_url;
		
		system.env.DISPLAY = ":13398";
		var pr = new proc.Process();
		pr.system(command);
				
///		var result_url = '/plans/results/'+facility.id+'.pdf';
//		var result_path = path + '/html'+result_url;

//		throw result_path;
		
		merge_pdf(
			pdf_stamp_path,
			result_path,
			result_path
		);
		
		return to_json(result_url);
	},
	
	stamp_gen: function(){
		
		this.fields.ajaj = 1;
		
		var facility = this.M['Facility'].Get(this.fields.facility_id);
		var plan = this.M['Plan'].Get(facility.plan_id);
			
		var format = this.M['PlanFormat'].Get(plan.format_id);
		var explication_data = JSON.parse(format.explication_data);
		
		var sd = 2.54;
		
		this.width = this.fields.width * sd;
		this.height = this.fields.height * sd;
		
		this.expl = {
			size:		0.65 * sd,
			x:			(explication_data.x+1) * sd,
			y:			(explication_data.y) * sd,
			rows:		(JSON.parse(facility.stamp_data||'0')) || (function(){
							var rows = [];
							for (var y=0;y<11;y++) {
								rows[y] = [];
								for (var x=0;x<8;x++) {
									rows[y][x] = undefined;
								}	
							}
							return rows;
						})()
		};
				
		return this.View('/client-side/website/GTM/dashboard/stamp');
	},
	
	export_values:function(){
		
		var t = this;
		
		this.fields.ajaj = 1;
		
		var sensor = Cache.get(this,'Sensor',this.fields.id);
		var values = this.C('GTM','get_values');
		
		if (values.braid_data) {
			
			var data = values.braid_data;
			var braid_table = [[sensor.name],['Дата']];
			
			// добавляем заголовки с глубинами
			data.values.forEach(function(col,i){braid_table[1].push('Глубина '+col[0]+'(м)')});
			
			// разворачиваем таблицу
			data.dates.forEach(function(date,i){
				var row = braid_table[i+2] = [date_to_xlsx(date)];
				data.values.forEach(function(col,j){
					var v = parseFloat(col[i+1]);
					if (v!=0 && !v) v = '-';
					braid_table[i+2][j+1] = v;
				});
			});
		}
		
		if (values.own_data) {
			
			var data = values.own_data;
			var own_table = [[sensor.name],['Дата']];
			
			// определяем кол-во параметров
			var MP = data.avts.length;
			
			// добавляем заголовки с параметрами
			data.avts.forEach(function(id,i){
				own_table[1].push(Cache.get(t,'AllowedValueType',id).name);
			});
		
			// разворачиваем таблицу
			data.dates.forEach(function(date,i){
				own_table[i+2] = [date_to_xlsx(date)];
				data.avts.forEach(function(id,j){
					var v = parseFloat(data.values[i*MP+j]);
					if (v!=0 && !v) v = '-';
					own_table[i+2][j+1] = v;
				});
			});
		}
		
		var result_table;
		
		if (braid_table && own_table) {
			
			result_table = [[sensor.name], ['Дата'] ];
			
			// заполняем шапку
			own_table[1].forEach(function(param,i){if(!i) return; result_table[1].push(param); });
			braid_table[1].forEach(function(deep,i){if(!i) return; result_table[1].push(deep); });
			
			// заполняем параметры
			own_table.forEach(function(row,i){
				if(i<2) return;
				result_table[i] = [];
				row.forEach(function(el){result_table[i].push(el); });
			});
			
			// заполянем косу
			braid_table.forEach(function(row,i){
				if(i<2) return;
				row.forEach(function(el,j){ if(!j) return; result_table[i].push(el); });
			});
		}
		else if (braid_table) result_table = braid_table
		else if (own_table) result_table = own_table;
		
		var data = this.F("Admin","json_table_to_xlsx",result_table);
		
		var date = new Date();
		date = date.getDate()+'-'+(date.getMonth()+1)+'-'+date.getFullYear();
		
		var name = sensor.name + '('+sensor.id+')';
		var date = new Date();
			date = date.getFullYear() + '.' + pad(date.getMonth()+1) +'.'+ pad(date.getDate());
		
		this.jsng_response.response_headers["Content-type"]="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
		this.jsng_response.response_headers["Content-disposition"]='attachment; filename="sg_'+sensor.allowed_model_type_name +'_'+sensor.name + '_' + date + '.xlsx"';
		
		return data;		
	},
	
	import_values:function(){
		
		var t = this;
		
		var sensor = this.M['Sensor'].Get(this.fields.sensor_id);
		if (!sensor) throw 'No sensor';
		
		var data=this.req.files["file"].data;
		try {
			var table=this.F("Admin","xlsx_to_json_table",data);
		} catch(e) {
			throw "не удается импортировать таблицу, проверьте расширение (должно быть xlsx)";
		}
				
		var sensor_name = table[0][0];
		if (sensor_name!=sensor.name) throw 'Имя элемента не совпадает выбран элемент "' + sensor.name + '", в таблице "' + sensor_name + '"';
		
		var amt  = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		var avts = this.M['AllowedValueType'].List('list_by_allowed_model',{ allowed_model_type_id:amt.id });
		
		var upd_values = [];
		
		var dates_by_row = {};
		table.forEach(function(el,i){
			if(i<2) return;
			dates_by_row[i] = date_to_bd_from_xlsx(el[0]);
		});
		
		var value_number = table[1].length-1;
		
		var avt_by_col = {};
		if (amt.has_own_values) {
			avts.forEach(function(avt,i){
				if (table[1][i+1]!=avt.name) throw 'Allowed value names mismatch: ' + table[1][i+1] +'!='+avt.name;
				avt_by_col[i+1] = avt.id;
			});
		}
		
//		throw value_number;
		
		var braid_by_col = {};
		if (amt.has_braid) {
			
			if (!amt.has_own_values) avts = [];
			
			var deep_by_col = {};
			table[1].forEach(function(deep,i){ if(i<avts.length+1) return; deep_by_col[i] = parseFloat(deep.match(/(\d+\.?\d*)/)[1]); });		
			for (k in deep_by_col) braid_by_col[k] = t.M['Braid'].Get('get_by_deep_n_sensor',{ sensor_id:sensor.id, deep:deep_by_col[k] }).id;
		}
		
		table.forEach(function(row,y){
			if(y<2) return;
			var date = dates_by_row[y];
			
			for (var x = 1;x<value_number+1;x++) {
				var v = row[x];
				var val = parseFloat(v);
				if (val!=0 && !val) val = undefined;
				var params = {
					date_use:				date,
					sensor_id: 				sensor.id,
					allowed_value_type_id:  avt_by_col[x],
					braid_id: 				braid_by_col[x],
					value: 					val
				}
				
				var value = t.F('GTM','save_value',params);
				upd_values.push(value);
			}
			
		});
		
		return JSON.stringify({ string:'Импортировано: '+upd_values.length + ' значений' });
		
	},
	
	reference: function(){
		var ref = this.M['Reference'].Get(this.fields.reference_id);
		if (ref) ref.items = this.M['Reference'].List('list_level',{ parent_id:ref.id });
		return {
			references:this.M['Reference'].ListHier('list_level',{ parent_id:0 }),
			reference:ref,
		};
	}
	
	
},{
	
	_type:"functions",
	_section:"GTM",
	
	get_tree: function(){
		return this.M['Facility'].ListHier('list_level_existed',{ parent_id:0 }).map(function(el){ return {
			id:el.id,
			level:el.level,
			name:el.name,
			sensors: [],
			facilities: [],
			groups: [],
			sensors_groups: []
		}});
	},
	
	save_value: function(data){
		
		if (!this.roles || !this.roles['gtm_input']) throw 'Нет прав';
		
		if (!data.sensor_id || !data.date_use) throw 'not enough data!';
		if (!data.braid_id && !data.allowed_value_type_id) throw 'no braid or avt!';
		if (data.braid_id && data.allowed_value_type_id) throw 'braid an avt!';
				
		var save_params = {};
		for (k in data) save_params[k] = data[k];
		save_params.value = parseFloat(save_params.value);
		if (save_params.value!=0 && !save_params.value) save_params.value = null;
		
		save_params.date_use = save_params.date_use.match(/(\d+)-(\d+)-(\d+)/).reverse().slice(0,3).join('-');
		
		var sensor = this.M['Sensor'].Get(data.sensor_id);
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		
		var value;
					
		if (amt.has_braid && data.braid_id) {
			
			value = this.M['SensorValue'].Get('get_by_braid_n_date', data) ||
					this.M['SensorValue'].Create();
					
			for (k in save_params) value[k] = save_params[k];
			
			value.SaveAll();
		}
		
		if (amt.has_own_values && data.allowed_value_type_id) {
			if(!this.site.sql.execute_and_fetch_one_single(
				'select id from tallowed_value_types where allowed_model_type_id = :allowed_model_type_id and id = :allowed_value_type_id',
				{
					allowed_model_type_id: amt.id,
					allowed_value_type_id: data.allowed_value_type_id
				}
			)) throw 'Value type not ALLOWED! - ' + this.Dumper(data);
			
			value = this.M['SensorValue'].Get('get_by_sensor_n_date_n_avt_only', data) ||
					this.M['SensorValue'].Create();
					
			for (k in save_params) value[k] = save_params[k];
			
			value.SaveAll();
		}
		
		return value;
	},
	
	
	save_braid: function (sensor) {
		
		if (!this.roles || !this.roles['gtm_edit']) throw 'Нет прав';
		
		var t = this;
		if (!sensor || !t.fields.deep || !t.fields.deep_step) return;
		
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		if (!amt.has_braid) return;
		
		var braids = {};
		t.M['Braid'].List('list_by_sensor',{sensor_id:sensor.id}).forEach(function(el){
			braids[el.deep.toFixed(1)] = el;
		});
		
		var new_braids = {};
		var deep = parseFloat(t.fields.deep);
		var deep_step = parseFloat(t.fields.deep_step);
		
		// чтобы включало конечную границу
		if (!braids[deep.toFixed(1)]) new_braids[deep.toFixed(1)]=1;
		
		for (var i = 0;i<=deep;i+=deep_step) {
			var d = i.toFixed(1);
			if (braids[d]) delete braids[d];
			else new_braids[d] = 1;
		}
				
		for (k in braids) braids[k].Delete();
		
		for (k in new_braids) {
			var braid = t.site.models.Braid.Create();
			braid.sensor_id = sensor.id;
			braid.deep = k;
			braid.enabled = 1;
			braid.SaveAll();
		}
	},
	
	
	get_stat: function(){
		
		if (!this.fields.facility_id || !this.fields.date_to) return error('No data!');
		
		var today = new Date();//
		today = today.getFullYear() + '-' + pad(today.getMonth() + 1) + '-' + pad(today.getDate());
		
		var date = this.fields.date_to;
		var stat = this.M['FacilityStat'].Get('get_by_facility_n_date',{ facility_id:this.fields.facility_id, date:date });
		
//		if (stat && today!=date) return JSON.stringify(stat);
		if (stat && today!=date) return stat;
		
		if (!stat) stat = this.M['FacilityStat'].Create();
		
		var date_bd = date.match(/(\d+)-(\d+)-(\d+)/).reverse().slice(0,3).join('-');
		
		stat.facility_id = this.fields.facility_id;
		stat.date = date_bd;
		stat.data = to_json(this.F('GTM','gen_stat_data',this.fields.facility_id,date));
		stat.SaveAll();
		
		return stat;
	},
	
	gen_stat_data: function(facility_id, date){
		
		var stat = this.site.sql.execute_and_fetch('facilities/stat',{ facility_id:facility_id, inputdate:date });
		var states = this.M['SensorState'].List();
		
		var allowed_model_types = this.M['AllowedModelType'].List().reduce(function(h,el){
			h[el.id] = {
				id:				el.id,
				states: 		states.reduce(function(hh,el2){ hh[el2.id] = 0; return hh; },{}),
				count:			0,
				retranslators:	0
			};
			return h;
		}, {  });
		
		stat.forEach(function(el){
			if (!el.data) return;
			var sensor = JSON.parse(el.data);
			var amt = allowed_model_types[sensor.allowed_model_type_id];
			try {
				amt.states[sensor.state_id]++;	
			} catch(e) {
				throw sensor;
			}
			
			amt.count++;
			if (sensor.is_retranslator) amt.retranslators++;
		});
		
		var data = {
			facility_id:	facility_id,
			date:			date,
			allowed_model_types: allowed_model_types
		};
		
		return data;
	},
	
	save_history: function(model, model_name, facility_id, text ){
		
		var t = this;
		
		var history = this.M['EditHistory'].Create();
		
		history.model_name	= model_name;
		history.model_id	= model.id;
		
		history.facility_id	= facility_id;
		history.text		= text;
		history.user_id		= this.uid;
		
		history.data		= JSON.stringify(model);
		
		history.SaveAll();
		
	},
	
	upload_images: function(){
		
		var t = this;
		
		var arr = [];
		
		if (this.fields.name=='images' && this.req.files['images'] && !this.req.files['images'].length) arr.push(t.F('Files','user_upload_file',{
			ff_id:		6,
			inputname: 	'images'
		}));
			
		if (this.fields.name=='images' && this.req.files['images'] && this.req.files['images'].length) this.req.files['images'].forEach(function(el,i){
			arr.push(t.F('Files','user_upload_file',{
				ff_id:		6,
				file_index:	i,
				inputname: 	'images'
			}));
		});
		
		arr = arr.filter(function(el){ return el; });
		
		return arr;
	}
	
}];