var fs=require("fs");
var proc = new require('process');
var base64 = new require('base64');

//http://pdfmake.org/index.html#/features

var Cache = {
	get:function(rr,model,id){
		if (!Cache[model]) Cache[model] = {};
		if (!Cache[model][id]) Cache[model][id] = rr.M[model].Get(id);
		return Cache[model][id];
	},
	set:function(rr,model,id){
		if (!Cache[model]) Cache[model] = {};
		Cache[model][id] = rr.M[model].Get(id);
	}
}

function error(data,call){
	var text = '';
	for (k in data) text += data[k] + '</br>';
	return JSON.stringify({error:text,data:data,call:call});
}

function pad(n){return n<10?'0'+n:n;}

function date_to_xlsx(date) { return date.match(/^(\d+)-(\d+)-(\d+)$/).reverse().slice(0,3).map(function(el){return parseInt(el); }).join('.'); }

function date_to_bd_from_xlsx(date){
	var arr = date.match(/^(\d+)\.(\d+)\.(\d+)$/);
	if (arr && arr.length) return arr.reverse().slice(0,3).map(pad).join('-');
	var date = new Date((parseInt(date)-1)*24*60*60*1000);
	date.setFullYear(date.getFullYear()-70);
	return date.getFullYear()+'-'+pad(date.getMonth()+1)+'-'+pad(date.getDate());
}

function filelog(s){
	var log_file = new fs.File("/www/vahvarh/erp-gtm.relsyst.ru/html/logs/log.txt");
		log_file.open("a");
		log_file.write(new Date());
		log_file.write(s);
		log_file.close();
}

exports.add=[{
	_type:"controller",
	_config:{
		name:"Dashboard",
	},
	
	index: function(){
		
		var t = this;
//		if (this.uid!=3) throw 'something bad happens...';

		// собираем данные для выгрузки на клиент
		this.F("Dashboard","fill_dictionaries",[
			"SensorModel",
			"SensorModelType",
			"AllowedModelType",
			"AllowedValueType",
			"SensorState",
			"MeasurementMode",
			"BasePaddingPrinciple",
			"NormativeType",
			"FacilityType",
			"FacilityState",
		]);
		
		//var f = new fs.File('/www/vahvarh/erp-gtm.relsyst.ru/html/f/6/298-state5.png');
		//f.remove();
		
//		this.img = this.M['File'].Get(298);
//		this.state = {"size":410,"x":-274,"y":-263,"W":301,"H":600};
//		this.img.state = JSON.stringify(this.state);
	 
		// отображаем стартовую страницу выбора объекта если объект не указан
		if (!this.fields.facility_id) {
			this.facilities=this.M['Facility'].List("list_level",{});
			return this.View('controllers/Dashboard/start');
		}
				
		// - объект(ы)
		this.facility = this.M['Facility'].Get(this.fields.facility_id);
		this.facilities = this.M['Facility'].List('list_level',{parent_id:this.facility.id});
		
		// - датчики
		this.sensors = this.M['Sensor'].List('list_of_facility',{facility_id:this.facility.id});
		
		// - группы и привязки датчиков к группам
		this.groups = this.M['FacilityGroup'].List('list_of_facility',{facility_id:this.facility.id});
		this.sensor_groups = this.M['SensorGroup'].List('list_of_facility',{facility_id:this.facility.id});
		
		// составляем путь от корня до объекта
		this.path = (function fill_path (el,arr){
			if (!el) return arr;
			arr.unshift(el);
			return fill_path(t.M['Facility'].Get(el.parent_id),arr)
		})(this.facility,[]);
		
		if (this.fields.pdf) return this.View('controllers/Dashboard/pdf');
		
		return this.Cview();
	},
	
	save_facility:function(){ // используется для создания, сохранения, а так же для изменения положения объекта (justcoords)
		
		var t = this;
		var facility;
		
		if (this.fields.id) {
			facility = this.M['Facility'].Get(this.fields.id);
		} else {
			facility = this.M['Facility'].Create();
			facility.parent_id = this.fields.parent_id;
		}
		
		['location_x',
		 'location_y'].forEach(function(k){facility[k]=t.fields[k]});
		
		if (!this.fields.justcoords)[
		 'name',
		 'width',
		 'height',
		 'base_principle_id',
		 'type_id',
		 'state_id',
		 'base_type',
		 'base_construction',
		 'clipmap',
		 'load_capacity',
		 'foundation_depth',
		 'frozen_depth',
		 'dumping_depth',
//		 'image_id',
		 'dwg_id',
		 'protection'].forEach(function(k){ facility[k]=t.fields[k]; });
		
		var errors = {};
		if (this.fields.justcoords){
			if (!facility.id) errors['id'] = 'Объект не создан';
			if (!facility.location_x||facility.location_x<0) errors['location_x'] = 'Не допустимое значение координаты X';
			if (!facility.location_y||facility.location_y<0) errors['location_y'] = 'Не допустимое значение координаты Y';
		} else {
//			if (!facility.image_id) errors['image_id'] 	= 'Изображение не загружено';
			if (!facility.name) errors['name'] 			= 'Не указано наименование';
//			if (!parseInt(facility.width)) errors['width'] 			= 'Не указана ширина';
//			if (!parseInt(facility.height)) errors['height'] 			= 'Не указана высота';
		}
		
		for (k in errors) return error(errors,'refresh_facility,init_pic');
		
		facility.no_history = 1;
		facility.SaveAll();
		
		// сохраняю периодичность замеров
		if (!this.fields.justcoords) for (k in this.fields) if (k && k.match(/period_\d+/)) {
			var sensor_model_id = k.match(/period_(\d+)/)[1];
			var params = {
				sensor_model_id:	sensor_model_id,
				facility_id:		facility.id
			}
			var period = t.M['MeasurementPeriod'].Get('get_by_model_n_facility',params) ||
						 t.M['MeasurementPeriod'].Create();
			for (p in params) period[p]=params[p];
			period.value = t.fields[k];
			period.SaveAll();
		}
		
		facility.no_history = 0;
		facility.CalcPeriods();
		facility.SaveAll();
		
		return JSON.stringify({ facility:t.M['Facility'].Get(facility.id) });
	},
	
	
	delete_facility: function(){
		var facility = this.M['Facility'].Get(this.fields.id);
			facility.deleted = 1;
			facility.SaveAll();
		return JSON.stringify({ facility:facility });
	},
	
	save_sensor:function(){	// используется для создания, сохранения, а так же для изменения положения датчика
		
		var t = this;
		var sensor;
		if (this.fields.id) {
			sensor = this.M['Sensor'].Get(this.fields.id);
		} else {
			sensor = this.M['Sensor'].Create();
			sensor.facility_id = this.fields.facility_id;
		}
		
		['location_x',
		 'location_y'].forEach(function(k){sensor[k]=t.fields[k]});
		
		if (!this.fields.justcoords)[
		 'name',
		 'state_id',
		 'deep',
		 'deep_step',
		 'reference_date',
		 'image_id',
		 'measurement_period',
		 'measurement_mode_id',
		 'allowed_model_type_id',
		 'is_retranslator',
		 ].forEach(function(k){ sensor[k]=t.fields[k]; });
		
		var errors = {};
		if (this.fields.justcoords){
			if (!sensor.id) errors['id'] = 'Датчик не создан';
			if (!sensor.location_x||sensor.location_x<0) errors['location_x'] = 'Не допустимое значение координаты X';
			if (!sensor.location_y||sensor.location_y<0) errors['location_y'] = 'Не допустимое значение координаты Y';
		} else {
			if (!sensor.name) errors['name'] = 'Не указано наименование';
			if (!sensor.allowed_model_type_id) errors['allowed_model_type_id'] = 'Не указан тип';
			if (!sensor.allowed_model_type_id) errors['state_id'] = 'Не указано состояние';
		}
		
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		if (!amt) for (k in errors) return error(errors);
				
		if (amt.has_braid && !parseFloat(sensor.deep)) errors['deep'] = 'Не указана глубина';
		if (amt.has_braid && !parseFloat(sensor.deep_step)) errors['deep_step'] = 'Не указан шаг глубины';
		
		for (k in errors) return error(errors);
		
		sensor.SaveAll();
		
		if (!this.fields.justcoords) this.F('Dashboard','save_braid',sensor);
		
		return JSON.stringify({ sensor:t.M['Sensor'].Get(sensor.id) });
	},
	
	switch_angle:function(){ // поворот датчика
		
		var t = this;
		var sensor = this.M['Sensor'].Get(this.fields.id);
		if (!sensor) return JSON.stringify({});
		
		var step = 45;
		if (!sensor.angle) sensor.angle = 0;
		
		sensor.angle += step*(this.fields.v);
		
		if (sensor.angle<0) sensor.angle=360-step;
		if (sensor.angle>360) sensor.angle=step;
		
		sensor.SaveAll();
		
		return JSON.stringify({ sensor:sensor });
	},
	
	get_braid: function(){
		var braids = this.M['Braid'].List('list_by_sensor',{ sensor_id:this.fields.sensor_id });
		return JSON.stringify({ braids:braids });
	},
	
	save_enable_braid: function(){
		var t = this;
		var braids = JSON.parse(this.fields.braids);
		for (k in braids) {
			var braid = t.M['Braid'].Get(k);
			braid.enabled = braids[k];
			braid.SaveAll();
		}
		return JSON.stringify({ok:1});
	},
	
	delete_sensor: function(){
		var sensor = this.M['Sensor'].Get(this.fields.id);
			sensor.deleted = 1;
			sensor.SaveAll();
		return JSON.stringify({sensor:sensor});
	},
	
	save_group:function(){
		
		var t = this;
		var group;
		
		if (this.fields.id) {
			group = this.M['FacilityGroup'].Get(this.fields.id);
		} else {
			group = this.M['FacilityGroup'].Create();
			group.facility_id = this.fields.facility_id;
		}
		
		['name'].forEach(function(k){ group[k]=t.fields[k]; });
		
		var errors = {};
		if (!group.name) errors['name'] = 'Не указано наименование';
		for (k in errors) return error(errors);
		
		group.SaveAll();
		return JSON.stringify({ group:group });
	},
	
	save_sensor_group:function(){
		
		var t = this;
		var reg = /^group_(\d+)$/;
		var sensor_id = this.fields.sensor_id;
		
		var sensor_groups = this.M['SensorGroup'].List('list_of_sensor',{ sensor_id:sensor_id }).reduce(function(h,el){ h[el.group_id]=el; return h; },{});
		for (k in this.fields) if (parseInt(this.fields[k]) && k.match(reg)) {
			var group_id = k.match(reg)[1];
			if (sensor_groups[group_id]) {
				delete sensor_groups[group_id];
				continue;
			}
			this.M['SensorGroup'].GetOrCreate('get_by_group_n_sensor',{ sensor_id:sensor_id, group_id:group_id }).SaveAll();
		}
		
		for (k in sensor_groups) sensor_groups[k].Delete();
		
		return JSON.stringify({ sensor_groups:this.M['SensorGroup'].List('list_of_sensor',{ sensor_id:sensor_id }), sensor_id:sensor_id });
	},
		
	get_facility_comments: function(config){
		
		var t = this;
		
		config = config || {};
		
		var params = { facility_id:config.facility_id || this.fields.facility_id };
		var comments = this.M['FacilityComment'].List('list_of_facility',params);
		var photos = this.site.sql.execute_and_fetch('images/list_of_facility',params);
		
		var images = {};
		photos.forEach(function(el){
			if (!images[el.comment_id]) images[el.comment_id] = [];
			images[el.comment_id].push( t.M['File'].Get(el.image_id) );
		});
		
		return JSON.stringify({ comments:comments, images:images, type:'facility', id:this.fields.facility_id });
	},
	
	get_sensor_comments: function(config){
		
		var t = this;
		
		config = config || {};
		
		var params = { sensor_id:config.sensor_id || this.fields.sensor_id };
		var comments = this.M['SensorComment'].List('list_of_sensor',params);
		var photos = this.site.sql.execute_and_fetch('images/list_of_sensor',params);
		
		var images = {};
		photos.forEach(function(el){
			if (!images[el.comment_id]) images[el.comment_id] = [];
			images[el.comment_id].push(t.M['File'].Get(el.image_id));
		});
		
		return JSON.stringify({ comments:comments, images:images, type:'sensor', id:this.fields.sensor_id });
	},
	
	save_facility_comment: function(){
		
		var t = this;
		
		var comment = 	this.M['FacilityComment'].Get(this.fields.comment_id) ||
						this.M['FacilityComment'].Create();
						
		if (!comment.id) {
			comment.user_cr_id = this.uid;
			comment.facility_id = this.fields.facility_id;
		}
						
		comment.body = this.fields.body;
		comment.images_json = this.fields.images_json || {};
		
		comment.SaveAll();
		
		if (this._get_comment) return comment;
						
		var images = {};
		this.M['FacilityCommentImage'].List('list_of_comment',{ comment_id:comment.id }).forEach(function(el){ images[el.id]=1; });
		
		if (this.fields.image_ids) this.fields.image_ids.split(',').forEach(function(id){
			if (!id) return;
			if (images[id]) delete images[id];
			else {
				var img = t.M['FacilityCommentImage'].Create();
				img.comment_id = comment.id
				img.image_id = id;
				img.SaveAll();
			}
		});
		
		for (k in images) images[k].Delete();
		
		return this.C('Dashboard','get_facility_comments');
	},
	
	save_sensor_comment: function(){
		
		var t = this;
		
		var comment = 	this.M['SensorComment'].Get(this.fields.comment_id) ||
						this.M['SensorComment'].Create();
						
		if (!comment.id) {
			comment.user_cr_id = this.uid;
			comment.sensor_id = this.fields.sensor_id;
		}
						
		comment.body = this.fields.body;
		comment.images_json = this.fields.images_json || {};
		
		comment.SaveAll();
		
		if (this._get_comment) return comment;
						
		var images = {};
		this.M['SensorCommentImage'].List('list_of_comment',{ comment_id:comment.id }).forEach(function(el){ images[el.id]=1; });
		
		if (this.fields.image_ids) this.fields.image_ids.split(',').forEach(function(id){
			if (!id) return;
			if (images[id]) delete images[id];
			else {
				var img = t.M['SensorCommentImage'].Create();
				img.comment_id = comment.id
				img.image_id = id;
				img.SaveAll();
			}
		});
		
		for (k in images) images[k].Delete();
		
		return this.C('Dashboard','get_sensor_comments');
	},

	all_values: function(){
		
		// получаем значения по всем датчикам заданного объекта
		// делаем все через режим 'get_values' предназначенный для формирования значений для одного датчика (не факт правда, что он будет использоваться гдето еще)
		// для этого кешируем датчики чтобы по несколько раз не тянуть их
		
		var t = this;
		this.all = 1;
		var values = [];
		this.M['Sensor'].List('list_of_facility',{ facility_id:this.fields.facility_id }).forEach(function(el){
			Cache.set(t,'Sensor',el.id);
			t.fields.id = el.id;
			var data = t.C('Dashboard','get_values');
			for (k in data) values.push(data[k]);
		});
	
		return t.xml ? values : JSON.stringify(values);
	},
	
	get_values: function(){
		
		var t = this;
		
		// контроллер может вызываться не напрямую - поэтому требуется кеш
		var sensor = Cache.get(this,'Sensor',this.fields.id);
		var amt = Cache.get(this,'AllowedModelType',sensor.allowed_model_type_id);
		var avts = this.M['AllowedValueType'].List('list_by_allowed_model',{ allowed_model_type_id:amt.id }); // todo - Cache
		
		// тут тонкий момент - один датчик может иметь только свои значения
		// либо датчик может иметь только косу значений
		// а еще датчик может иметь косу значений и свои значения вместе
		
		// функа формирования таблицы на клиенте выводит либо свои значения либо косы
		
		// выходные данные
		var r = {};
		var own_data   = { dates:[], values:[], sensor_id:sensor.id, params_length:avts.length, type:'own'	 };
		var braid_data = { dates:[], values:[], sensor_id:sensor.id, params_length:avts.length, type:'braid' };
		
		// параметры запроса значений
		var params = {
			sensor_id:	sensor.id,
			days: 		this.fields.days,	// 5
			date_to: 	this.fields.date_to // '2015-10-05'
		};
		
		if (amt.has_own_values) { // для формирования строк собственных значений датчика
		
			// получаем выборку вида [{date:'20.08.2019',avt_id:1,value:1}, ... , {...}]
			// выборка устроена так что в ней обязательно будут все даты за выбранный интервал
			var arr = this.site.sql.execute_and_fetch('values/list_by_sensor',params);
			
			// получаем хеш для доступа к значениям по пути allowed_value_type -> date -> value
			var avt_hash = {};
			avts.forEach(function(el){
				avt_hash[el.id] = {};	
			});
			
			var dates_hash={};
			arr.forEach(function(el){
				if (!el.date) return;
				
				dates_hash[el.date] = 1;
				
				if (!el.allowed_value_type_id) return;
				try {
					
				
				if (el.allowed_value_type_id) avt_hash[el.allowed_value_type_id][el.date] = el.value;
				} catch(e){
					
					throw sensor.id;
				}
			});
			
			
			// собираем массив всех дат для удобства чтобы не собирать его на клиенте а также на какие-то даты может не быть значений
			var dates = [];
			for (k in dates_hash) dates.push(k);
			
			/* и перебираем все в массив значений вида, где на дату приходит несколько занчений в зависимости от avts.length
			 * [
				1,2,		// date_1
				null,5,		// date_2
				null,null,	// date_3
				...
				4,null		// date_n
			]*/
						
			var values = [];
			dates.forEach(function(d){
				avts.forEach(function(at){
					values.push(avt_hash[at.id][d]);
				});
			});
			
			//  тем самым получили готовую строку для таблицы вида
			//	|-----------------------------------|
			//	|	date_1	|	date_2	|	date_3	|
			//	|-----------------------------------|
			//	| p_1 | p_2 | p_1 | p_2 | p_1 | p_2 |
			//	|-----------------------------------|
			//  |	v |  v  |  v  |  v  |  v  |  v  |
			//	|-----------------------------------|
			
			own_data.dates = dates;
			own_data.values = values;
			own_data.avts = avts.map(function(el){return el.id;});
			own_data.params_length = avts.length;
			
			r.own_data = own_data;
		}
		
		if (amt.has_braid) {
			
			// собираем хеш косы по глубине
			var deep_hash = {};
			var deeps = this.M['Braid'].List('list_by_sensor_enabled',{ sensor_id:sensor.id }).map(function(el){
				deep_hash[el.deep] = {};
				return el.deep;
			});
			
			// собираем хеш значений по датам и по глубино_датам
			// то есть доступ к значению по пути deep -> date -> value
			// опятьже выборка значений дает нам все даты на интервале даже при оствуствии на них значений
			var dates_hash = {};
			this.site.sql.execute_and_fetch('values/list_by_sensor_braid',params).forEach(function(el){
				dates_hash[el.date] = 1;
				if (el.deep!=undefined) deep_hash[el.deep][el.date] = el.value;	
			});
			
			// собираем массив всех дат для удобства чтобы не собирать его на клиенте а также на какие-то даты может не быть значений
			var dates = [];
			for (k in dates_hash) dates.push(k);
			
			/* собираем массив вида
			 *[
				['v_on_date_1','v_on_date_2',...,'v_on_date_n'],	// deep_1
				[null,'v_on_date_2',...,'v_on_date_n'],				// deep_1
				...
				['v_on_date_1',...,null] 							// deep_n
			]
			*/
			var values = [];
			deeps.forEach(function(dp){
				var item = [dp];
				dates.forEach(function(d,i){
					item.push(deep_hash[dp][d]);
				});
				values.push(item);
			});
			
			// то есть получаем массив строк для таблицы вида
			//	|---|-----------------------------------|
			//	|   |	date_1	|	date_2	|	date_3	|
			//	|---|-----------------------------------|
			//  | 1 |     v     |     v     |     v     |
			//  | 2 |     v     |     v     |     v     |
			//  | 3 |     v     |     v     |     v     |
			//  |---|-----------------------------------|
			
			braid_data.dates = dates;
			braid_data.values = values;
			braid_data.avts = avts.map(function(el){return el.id;});
			braid_data.params_length = 1;
			r.braid_data = braid_data;
		}
			
		return t.result_to_string ? JSON.stringify(r) : r;
	},
	
	save_values: function(){
		var t = this;
		var data = JSON.parse(this.fields.data);
		data.forEach(function(el){ t.F('Dashboard','save_value',el); });
		return JSON.stringify({ok:1});
	},
	
	export_values:function(){
		
		var t = this;
		
		this.fields.ajaj = 1;
		
		var sensor = Cache.get(this,'Sensor',this.fields.id);
		var values = this.C('Dashboard','get_values');
		
		if (values.braid_data) {
			
			var data = values.braid_data;
			var braid_table = [[sensor.name],['Дата']];
			
			// добавляем заголовки с глубинами
			data.values.forEach(function(col,i){braid_table[1].push('Глубина '+col[0]+'(м)')});
			
			// разворачиваем таблицу
			data.dates.forEach(function(date,i){
				var row = braid_table[i+2] = [date_to_xlsx(date)];
				data.values.forEach(function(col,j){
					braid_table[i+2][j+1] = col[i+1] || '-';
				});
			});
		}
		
		if (values.own_data) {
			
			var data = values.own_data;
			var own_table = [[sensor.name],['Дата']];
			
			// определяем кол-во параметров
			var MP = data.avts.length;
			
			// добавляем заголовки с параметрами
			data.avts.forEach(function(id,i){
				own_table[1].push(Cache.get(t,'AllowedValueType',id).name);
			});
		
			// разворачиваем таблицу
			data.dates.forEach(function(date,i){
				own_table[i+2] = [date_to_xlsx(date)];
				data.avts.forEach(function(id,j){
					own_table[i+2][j+1] = data.values[i*MP+j] || '-';
				});
			});
		}
		
		var result_table;
		
		if (braid_table && own_table) {
			
			result_table = [[sensor.name], ['Дата'] ];
			
			// заполняем шапку
			own_table[1].forEach(function(param,i){if(!i) return; result_table[1].push(param); });
			braid_table[1].forEach(function(deep,i){if(!i) return; result_table[1].push(deep); });
			
			// заполняем параметры
			own_table.forEach(function(row,i){
				if(i<2) return;
				result_table[i] = [];
				row.forEach(function(el){result_table[i].push(el); });
			});
			
			// заполянем косу
			braid_table.forEach(function(row,i){
				if(i<2) return;
				row.forEach(function(el,j){ if(!j) return; result_table[i].push(el); });
			});
		}
		else if (braid_table) result_table = braid_table
		else if (own_table) result_table = own_table;
		
		
		var data=this.F("Admin","json_table_to_xlsx",result_table);
		
		var date = new Date();
		date = date.getDate()+'-'+(date.getMonth()+1)+'-'+date.getFullYear();
		
		this.jsng_response.response_headers["Content-type"]="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
		this.jsng_response.response_headers["Content-disposition"]='attachment; filename="sensor_'+sensor.id+'.xlsx"';
		
		return data;
		
	},
	
	
	import_values:function(){
		
		var t = this;
		
		var sensor = this.M['Sensor'].Get(this.fields.sensor_id);
		if (!sensor) throw 'No sensor';
		
		var data=this.req.files["file"].data;
		var table=this.F("Admin","xlsx_to_json_table",data);
		if (!table) throw "Could not parse xlsx";
		
		var sensor_name = table[0][0];
		if (sensor_name!=sensor.name) throw 'Sensor mismatch';
		
		var amt  = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		var avts = this.M['AllowedValueType'].List('list_by_allowed_model', { allowed_model_type_id:amt.id });
		
		var new_values = [];
		var upd_values = [];
		
		var dates_by_row = {};
		table.forEach(function(el,i){
			if(i<2) return;
			dates_by_row[i] = date_to_bd_from_xlsx(el[0]);
		});
		
		var avt_by_col = {};
		if (amt.has_own_values) {
			avts.forEach(function(avt,i){
				if (table[1][i+1]!=avt.name) throw 'Allowed value names mismatch: ' + table[1][i+1] +'!='+avt.name;
				avt_by_col[i+1] = avt.id;
			});
		}
		
		var braid_by_col = {};
		if (amt.has_braid) {
			
			if (!amt.has_own_values) avts.length = [];
			
			var deep_by_col = {};
			table[1].forEach(function(deep,i){ if(i<avts.length+1) return; deep_by_col[i] = parseFloat(deep.match(/(\d+\.?\d*)/)[1]); });		
			for (k in deep_by_col) braid_by_col[k] = t.M['Braid'].Get('get_by_deep_n_sensor',{ sensor_id:sensor.id, deep:deep_by_col[k] }).id;
		}
		
		table.forEach(function(row,y){
			if(y<2) return;
			var date = dates_by_row[y];
			
			table[y].forEach(function(v,x){
				
				if (!x) return;
				
				var params = {
					date_use:	date,
					sensor_id: 	sensor.id,
					allowed_value_type_id: avt_by_col[x],
					braid_id: 	braid_by_col[x],
					value: 		parseFloat(v) || undefined
				}
				
				var value = t.F('Dashboard','save_value',params);
				
				if (!value._is_new) upd_values.push(value);
				else new_values.push(value);
				
				value.SaveAll();
				
			});
		});
		
		return JSON.stringify({ string:'Обновлено: '+upd_values.length + '<br> Добавлено: ' + new_values.length });
		
	},
	
	save_normative: function(){
		
		var list = 'get_by_facility_n_type_n_model';
		
		if (this.fields.value == '') return error({value:'Значение неуказано'});
		
		var params = {
			facility_id: 		this.fields.facility_id,
			type_id: 			this.fields.type_id,
			sensor_model_id:	this.fields.sensor_model_id,
			value: 				this.fields.value
		};
		
		var normative = this.M["Normative"].GetOrCreate(list,params).SaveAll();
		
		if (!this.many) return JSON.stringify({ facility:this.M['Facility'].Get(params.facility_id) });
	},
	
	save_normatives: function(){
		var reg = /^type_(\d+)$/;
		var params;
		var arr;
		for (k in this.fields) if (arr=k.match(reg)) {
			params = { type_id:arr[1], value:this.fields[k], facility_id:this.fields.facility_id };
			this.M['Normative'].GetOrCreate('get_by_facility_n_type',params).SaveAll();
		}		
		return JSON.stringify({ facility:this.M['Facility'].Get(this.fields.facility_id) });
	
	},

	get_history: function(){
		return JSON.stringify({ history:this.M['EditHistory'].List('list_by_facility',{ facility_id:this.fields.facility_id }) });
	},
	
	
	get_stats: function(){
		
		var t = this;
		
		var facilities = this.fields.facilities.split(',');
		var models = this.fields.models.split(',');
		var states = this.fields.states.split(',');
		
		var stats = {};
		var date = this.fields.date_to;
		
		stats[date] = {};
		
		facilities.forEach(function(facility_id){
			t.fields.facility_id = facility_id;
			var stat = JSON.parse(t.C('Dashboard','get_stat'));
			stats[date][facility_id] = JSON.parse(stat.data);
		});
		
		return JSON.stringify(stats);
		
	},
	
	get_stat: function(){
		
		if (!this.fields.facility_id || !this.fields.date_to) throw 'No data!';
		
		var today = new Date();//
		today = today.getFullYear() + '-' + pad(today.getMonth() + 1) + '-' + pad(today.getDate());
		
		var date = this.fields.date_to;
		var stat = this.M['FacilityStat'].Get('get_by_facility_n_date',{ facility_id:this.fields.facility_id, date:date });
		
		if (stat && today!=date) return JSON.stringify(stat);
		
		if (!stat) stat = this.M['FacilityStat'].Create();
		
		var date_bd = date.match(/(\d+)-(\d+)-(\d+)/).reverse().slice(0,3).join('-');
		
		stat.facility_id = this.fields.facility_id;
		stat.date = date_bd;
		stat.data = JSON.stringify(this.F('Dashboard','gen_stat_data',this.fields.facility_id,date));
		stat.SaveAll();
		
		return JSON.stringify(stat);
	},
	
	
	
},
{
	_type:"functions",
	_section:"Dashboard",
	
	fill_dictionaries: function(arr){
		var t = this;
		this.dictionaries = this.dictionaries || {};
		arr.forEach(function(k){ if (!t.dictionaries[k]) t.dictionaries[k] = t.M[k].List(); });
	},
			
	get_models_hash: function(arr){
		var t = this;
		this.dictionaries = this.dictionaries || {};
		this.models_hash  = this.model_hash   || {};
		arr.forEach(function(k){
			if(!t.dictionaries[k]) t.F('Dashboard','fill_dictionaries',[k]);
			t.models_hash[k] = t.dictionaries[k].reduce(function(hash,el){ hash[el.id]=el; return hash; }, {});
		});
	},
	
	save_history: function( model, model_name, facility_id ){
		
		var t = this;
		
		var history = this.M['EditHistory'].Create();
		var translate = {
			'Sensor'		: 'Датчик ' + model.name,
			'Facility'		: 'Объект ' + model.name,
			'SensorValue'	: 'Значение датчика на ' + model.date_use
		};
		
		history.model_id = model.id;
		history.model_name = model_name;
		history.facility_id = facility_id;
		history.user_id = this.uid;
		
		history.text = translate[model_name] + (model.was_id ? ' отредактирован' : ' создан');
		
		var updated_params = [];
		var old_data = model.old_data ? JSON.parse(model.old_data) : {};
		
		var keys = [];

		if (model_name == 'Sensor' || model_name == 'Facility') {
			
			keys.push({ key:'location_x',	name:'X-координата' });			
			keys.push({ key:'location_y',	name:'Y-координата' });
			keys.push({ key:'name',			name:'Наименование' });
			keys.push({ key:'deleted',		name:'Удален' });
			keys.push({ key:'image_id',		name:'Чертеж' });			
		}
		
		if (model_name == 'Facility') {
			
			this.F('Dashboard','get_models_hash',['FacilityState','FacilityType','BasePaddingPrinciple']);
			
			keys.push({ key:'state_id',				name:'Состояние ',									value_hash:'FacilityState' });
			keys.push({ key:'type_id',				name:'Тип объекта ',								value_hash:'FacilityType' });
			keys.push({ key:'base_principle_id',	name:'Принцип использования грунтов основания',		value_hash:'BasePaddingPrinciple' });
			
			keys.push({ key:'height',				name:'Высота' });
			keys.push({ key:'width',				name:'Ширина' });
			
			keys.push({ key:'base_construction',	name:'Конструкция фундамента' });
			keys.push({ key:'base_type',			name:'Тип фундамента' });			
			keys.push({ key:'load_capacity',		name:'Несущая способность' });
			keys.push({ key:'protection',			name:'Инженерная защита' });
			
			this.F('Dashboard','fill_dictionaries',['SensorModel']);
			this.dictionaries.SensorModel.forEach(function(el){
				keys.push({ key:'period_'+el.id, name:'Период замера для модели ' + el.name });		
			});
		}
		
		if (model_name == 'Sensor') {
			
			this.F('Dashboard','get_models_hash',['AllowedModelType','SensorState','MeasurementMode']);
			
			keys.push({ key:'angle',				name:'Угол' });
			keys.push({ key:'is_retranslator',		name:'Ретранслятор' });			
			keys.push({ key:'state_id',				name:'Состояние ',			value_hash:'SensorState' });
			keys.push({ key:'measurement_mode_id',	name:'Режим замера ',		value_hash:'MeasurementMode' });
			keys.push({ key:'allowed_model_type_id',name:'Тип модели ',			value_hash:'AllowedModelType' });
		}
		
		if (model_name == 'SensorValue') {
			this.F('Dashboard','get_models_hash',[]);
			keys.push({ key:'value', name:'Значение' });
		}
		
		keys.forEach(function(el){
			if (old_data[el.key]!=model[el.key]) {
				var text = el.name + ': '+(old_data[el.key]||'...')+' -> ';
				var value = model[el.key];
				var hash = t.models_hash[el.value_hash] && t.models_hash[el.value_hash][value];
				var value_name = (hash && hash.name) || value;
				updated_params.push(text + value_name);
			}
		});
		
		if (updated_params.length) {
			history.data = JSON.stringify(model);
			history.text += ':<br> '+updated_params.join(', ');
			history.SaveAll();	
		}
		
	},
	
	save_value: function(data){
		
		if (!data.sensor_id || !data.date_use || data.value==undefined) throw 'not enough data!';
		if (!data.braid_id && !data.allowed_value_type_id) throw 'no braid or avt!';
		if (data.braid_id && data.allowed_value_type_id) throw 'braid an avt!';
		
		var save_params = {};
		for (k in data) save_params[k] = data[k];
		
		save_params.date_use = save_params.date_use.match(/(\d+)-(\d+)-(\d+)/).reverse().slice(0,3).join('-');
		
		var sensor = this.M['Sensor'].Get(data.sensor_id);
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		
		var value;
					
		if (amt.has_braid && data.braid_id) value = this.M['SensorValue'].GetOrCreate('get_by_braid_n_date', data, save_params).SaveAll();
		
		if (amt.has_own_values && data.allowed_value_type_id) {
			if(!this.site.sql.execute_and_fetch_one_single(
				'select id from tallowed_value_types where allowed_model_type_id = :allowed_model_type_id and id = :allowed_value_type_id',
				{
					allowed_model_type_id: amt.id,
					allowed_value_type_id: data.allowed_value_type_id
				}
			)) throw 'Value type not ALLOWED! - ' + this.Dumper(data);	
			value = this.M['SensorValue'].GetOrCreate('get_by_sensor_n_date_n_avt_only',data,save_params).SaveAll();
		}
		
		return value;
	},
	
		
	save_braid: function (sensor) {
		
		var t = this;
		if (!sensor || !t.fields.deep || !t.fields.deep_step) return;
		
		var amt = this.M['AllowedModelType'].Get(sensor.allowed_model_type_id);
		if (!amt.has_braid) return;
		
		var braids = {};
		t.M['Braid'].List('list_by_sensor',{sensor_id:sensor.id}).forEach(function(el){
			braids[el.deep.toFixed(1)] = el;
		});
		
		var new_braids = {};
		var deep = parseFloat(t.fields.deep);
		var deep_step = parseFloat(t.fields.deep_step);
		
		// чтобы включало конечную границу
		if (!braids[deep.toFixed(1)]) new_braids[deep.toFixed(1)]=1;
		else delete braids[deep.toFixed(1)];
		
		for (var i = 0;i<=deep;i+=deep_step) {
			var d = i.toFixed(1);
			if (braids[d]) delete braids[d];
			else new_braids[d] = 1;
		}
				
		for (k in braids) braids[k].Delete();
		
		for (k in new_braids) {
			var braid = t.site.models.Braid.Create();
			braid.sensor_id = sensor.id;
			braid.deep = k;
			braid.enabled = 1;
			braid.SaveAll();
		}
	},
	
	check_plan: function(facility){
	
		// -> statuses
		//
		// errored
		// created
		// loaded
		// registered
		// checked
		
		var save_errored = function(plan,text){
			plan.status_code = 'errored';
			plan.error = text;
			plan.SaveAll();
		}
		
		if (!facility.dwg_id) return;
		
		var plan = this.M['FacilityPlan'].Get('get_by_facility',{ facility_id:facility.id });
		
		if (plan && plan.status_code=='checked' && plan.dwg_id==facility.dwg_id) {
			facility.urn = plan.urn;
			return;
		}
		
		if (plan && plan.dwg_id!=facility.dwg_id) {
			plan.Delete();
			plan = undefined;
		}
		
		if (plan && plan.status_code=='errored') {
			facility.urn = plan.error;
			return;
		}
		
		if (!plan) {
			plan = this.M['FacilityPlan'].Create();
			plan.facility_id = facility.id;
			plan.dwg_id = facility.dwg_id
			plan.status_code = 'created';
			plan.SaveAll();
		}
		
		if (plan.status_code == 'created') {
			
			var file = this.M['File'].Get(plan.dwg_id);	
			var upload_data = this.C('ApiAutodesk','upload_file',file,1);
			
			if (!upload_data) {
				save_errored(plan,'Bad upload request');
				return;
			}
			
			try {
				upload_data = JSON.parse(upload_data);				
			} catch(e) {
				save_errored(plan,'Bad upload request parse');
				return;
			}
			
			plan.objectid = upload_data.objectId;
			plan.urn = 'urn:' + base64.encode(plan.objectid).toString('UTF-8');
			plan.status_code = 'loaded';
			plan.SaveAll();
		}
		
		if (plan.status_code == 'loaded') {
			
			var reg = this.C('ApiAutodesk','register_file',{ urn:plan.objectid },1);
			
			if (!reg) {
				save_errored(plan,'Bad register request');
				return;
			}
			
			var result = reg.split('\n');
			result = result[result.length-1];
			
			try {
				result = JSON.parse(result);
			} catch(e) {
				save_errored(plan,'Bad register request parse');
				return;
			}
			
			if (result.Result != 'Created') {
				save_errored(plan,'Bad register - ' + result.diagnostic);
				return
			}
				
			plan.status_code = 'registered';
			plan.SaveAll();
		}
		
		if (plan.status_code == 'registered') {
			var reg = this.C('ApiAutodesk','check_register',{ urn:plan.objectid },1);
			
			if (!reg) {
				save_errored(plan,'Bad check register request');
				return ;
			}
				
			var result = reg.split('\n');
			result = result[result.length-1];
			
			try {
				result = JSON.parse(result);
			} catch(e) {
				save_errored(plan,'Bad check register request parse');
				return 
			}
			
			if (result.progress != 'complete') {
				plan.error = 'not complete yet';
				plan.SaveAll();
				return;
			}
			
			plan.status_code = 'checked';
			plan.SaveAll();
			
			facility.urn = plan.urn;
		}
		return;
	},
	
	gen_stat_data: function(facility_id, date){
		
		var stat = this.site.sql.execute_and_fetch('facilities/stat',{ facility_id:facility_id, date:date });
		var states = this.M['SensorState'].List();
		var allowed_model_types = this.M['AllowedModelType'].List().reduce(function(h,el){
			h[el.id] = {
				id:				el.id,
				states: 		states.reduce(function(hh,el2){ hh[el2.id] = 0; return hh; },{}),
				count:			0,
				retranslators:	0
			};
			return h;
		}, {  });
		
		stat.forEach(function(el){
			if (!el.data) return;
			var data = JSON.parse(el.data);
			var amt = allowed_model_types[data.allowed_model_type_id];
			amt.states[data.state_id]++;
			amt.count++;
			if (data.is_retranslator) amt.retranslators++;
		});
		
		var data = {
			facility_id:	facility_id,
			date:			date,
			allowed_model_types: allowed_model_types
		};
		
		return data;
	}
	
}];






