function viewer_init(rr)
{
	rr.root_facility=rr.site.models.Facility.Get(rr.fields.root_id);
	rr.facilities=rr.site.models.Facility.ListHier("list_level",{parent_id:rr.fields.root_id});
	var f_hash=rr.F("Alg","array_to_hash",rr.facilities);
	rr.path=[];
	if (rr.fields.facility_id) {
		var tmp_id=rr.fields.facility_id;
		rr.facility=f_hash[tmp_id];
		while (tmp_id) {
			var f=f_hash[tmp_id];
			if (!f) {tmp_id=undefined;continue;}
			rr.path.unshift(f);
			tmp_id=f.parent_id;
		}
	}
	rr.path.unshift(rr.root_facility);
}

function date_to_bd(date){
	var arr = date.match(/(\d+)\.(\d+)\.(\d+)/);
	return arr[1]+'-'+arr[2]+'-'+arr[3];
}

function date_to_js(date){
	var arr = date.match(/(\d+)\-(\d+)\-(\d+)/);
	return arr[3]+'.'+arr[2]+'.'+arr[1];
}

exports.add=[{
	_type:"controller",
	_config:{
		name:"FacilitiesPage",
	},

	index: function() {
		this.facilities=this.site.models.Facility.List("list_level",{});
		return this.Cview();
	},

	/**
	 * Controller: FacilitiesPage.viewer
	 */
	viewer: function() {
		viewer_init(this);
		return this.Cview();
	},

	/**
	 * Controller: FacilitiesPage.viewer_info
	 */
	viewer_info: function() {
		viewer_init(this);
		
		var query = 'select count(*) from tsensors where facility_id=:id';
		var params = {id:this.facility.id};
		this.facility.sensors_count = this.site.sql.execute_and_fetch_one_single(query,params).count;
		
		var query = 'select count(*) from tsensor_values as v, tsensors as s where s.facility_id=:id and v.sensor_id=s.id';
		var params = {id:this.facility.id};
		this.facility.values_count = this.site.sql.execute_and_fetch_one_single(query,params).count;
		
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},

	/**
	 * Controller: FacilitiesPage.viewer_sensors
	 */
	viewer_sensors: function() {
		viewer_init(this);
		this.sensors=this.site.models.Sensor.List("list_of_facility",{facility_id:this.fields.facility_id});
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},

	/**
	 * Controller: FacilitiesPage.viewer_sensors_edit
	 */
	viewer_sensors_edit: function() {
		viewer_init(this);
		this.dictionaries={
			sensor_models:this.site.models.SensorModel.List()
		};
		if (this.fields.id) {
			this.sensor=this.site.models.Sensor.Get(this.fields.id);
			if (this.sensor.facility_id!=this.fields.facility_id) throw "HACKER";
		} else {
			this.sensor=this.site.models.Sensor.Create();
		}
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},

	/**
	 * Controller: FacilitiesPage.viewer_sensors_save
	 */
	viewer_sensors_save: function() {
		if (this.fields.id) {
			this.sensor=this.site.models.Sensor.Get(this.fields.id);
			if (this.sensor.facility_id!=this.fields.facility_id) throw "HACKER";
		} else {
			this.sensor=this.site.models.Sensor.Create();
		}
		this.sensor.name=this.fields.name;
		this.sensor.sensor_model_id=this.fields.sensor_model_id;
		this.sensor.SaveAll();
		return JSON.stringify({redirect:{url:this.action+"?mode=viewer_sensors&root_id="+this.fields.root_id+"&facility_id="+this.fields.facility_id}});
	},

	/**
	 * Controller: FacilitiesPage.viewer_comment
	 */
	viewer_comments: function() {
		viewer_init(this);
		this.comments=this.site.models.FacilityComment.List("list_of_facility",{facility_id:this.fields.facility_id});
		this.comment = this.site.models.FacilityComment.Create();
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},
	
	
	/**
	 * Controller: FacilitiesPage.viewer_comment_save
	 */
	viewer_comments_save: function() {
		
		var comment = this.site.models.FacilityComment.Create();
			comment.facility_id = this.fields.facility_id;
			comment.body = this.fields.body;
			comment.user_cr_id = this.uid;
			comment.SaveAll();
			
		return JSON.stringify({refresh:1});
	},
	
	/**
	 * Controller: FacilitiesPage.viewer_photos
	 */
	viewer_photos: function() {
		viewer_init(this);
		this.photos=this.site.models.FacilityPhoto.List("list_of_facility",{facility_id:this.fields.facility_id});
		this.photo = this.site.models.FacilityPhoto.Create();
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},
	
	
	/**
	 * Controller: FacilitiesPage.viewer_photos_save
	 */
	viewer_photos_save: function() {
		
		var inputname = 'image_id-file';
		if (this.req.files[inputname]) this.fields.image_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		var photo = this.site.models.FacilityPhoto.Create();
			photo.facility_id = this.fields.facility_id;
			photo.body = this.fields.body;
			photo.image_id = this.fields.image_id;
			photo.user_cr_id = this.uid;
			photo.SaveAll();
			
		return JSON.stringify({refresh:1});
	},
	
	/**
	 * Controller: FacilitiesPage.viewer_sensors_data
	 */
	viewer_sensors_data: function(config) {
		config = config || {};
		viewer_init(this);
		var t = this;		
		this.dictionaries = {
			sensor_models:this.site.models.SensorModel.List()
		};
		this.values = [];
		this.site.models.Sensor.List("list_of_facility",{facility_id:this.fields.facility_id}).forEach(function(el){
			t.values = t.values.concat(t.site.models.SensorValue.List("list_of_sensor",{sensor_id:el.id}));
		});
		this.values = this.F('Functions','filter',this.values,{ sensor_id:1, sensor_model_measurer_id:1, date_use:1 });
		this.viewer=this.Cview();
		if (config.only) return this.viewer;
		return this.View("controllers/FacilitiesPage/viewer");
	},
	
	get_values: function(){
		var filter = JSON.parse(this.fields.filter);
		var models = {};
		if (filter.models.length) filter.models.forEach(function(el){models[el]=1});
		var model_ids = filter.models.join(',');
		var emptyness = filter.emptyness;
		
		var params = {
			models:			'{'+model_ids+'}',
			date: 			this.fields.date,
			interval:		filter.col_number || 4,
			facility_id: 	this.fields.facility_id
		}
		
		//throw this.site.sql.execute_and_fetch('values/list_by_models_n_facility_dated',params);
		var dates = {};
		var sensors= {};
		this.site.sql.execute_and_fetch('values/list_by_models_n_facility_dated',params).forEach(function(el){
			dates[el.d] = 1;
			if (!el.sensor_id) return;
			if(!sensors[el.sensor_id]) sensors[el.sensor_id] = [];
			sensors[el.sensor_id].push(el);
		});
		if (emptyness) {
			this.site.models.Sensor.List("list_of_facility",params)
				.filter(function(el){  if (!model_ids) return true; return models[el.sensor_model_id]; })
				.forEach(function(el){ if (!sensors[el.id])	sensors[el.id] = []; });
		}
		var items = [];
		for (k in sensors) {
			var sensor = this.site.models.Sensor.Get('get_full',{id:k});
			var item = {
				id: sensor.id,
				name: sensor.name,
				name_short: sensor.sensor_model_name_short,
				model_name: sensor.sensor_model_name,
				dates:[]
			}
			var exist_dates = {};
			sensors[k].forEach(function(el){
				exist_dates[el.d] = el;	
			});
			for (d in dates) item.dates.push(exist_dates[d]||{d:d})
			item.dates = item.dates.sort(function(a,b){return a.d>b.d})
			items.push(item);
		}
		
		var arrdates = [];
		for (d in dates) arrdates.push(date_to_js(d));
		
		return JSON.stringify({items:items,dates:arrdates});
	},

	/**
	 * Controller: FacilitiesPage.viewer_map
	 */
	viewer_map: function() {
		viewer_init(this);
		this.viewer=this.Cview();
		return this.View("controllers/FacilitiesPage/viewer");
	},

	/**
	 * Controller: FacilitiesPage.viewer_sub_facility_edit
	 */
	viewer_sub_facility_edit: function() {
		viewer_init(this);
		this.fields.id=this.fields.facility_id;
		this.viewer=this.C("FacilitiesPage","sub_facility_edit");
		return this.View("controllers/FacilitiesPage/viewer");
	},

	base_facility_edit: function() {
		if (!this.roles.gtm_facilities) throw "Нет доступа";
		if (this.fields.id) {
			this.facility=this.site.models.Facility.Get(this.fields.id);
		} else {
			this.facility={};
		}
		return this.Cview();
	},

	base_facility_save: function() {
		if (!this.roles.gtm_facilities) throw "Нет доступа";
		if (this.fields.id) {
			this.facility=this.site.models.Facility.Get(this.fields.id);
		} else {
			this.facility=this.site.models.Facility.Create();
		}
		
		var inputname = 'image_id-file';
		if (this.req.files[inputname]) this.fields.image_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		this.facility.image_id=this.fields.image_id;
		this.facility.name=this.fields.name;
		this.facility.code=this.fields.code;
		this.facility.address=this.fields.address;
		this.facility.SaveAll();
		
		return JSON.stringify({redirect:{url:this.action}});
	},

	sub_facility_edit: function() {
		if (!this.roles.gtm_facilities) throw "Нет доступа";
		this.root_facility=this.site.models.Facility.Get(this.fields.root_id);
		this.dictionaries={
			facilities: this.site.models.Facility.ListHier("list_level",{parent_id:this.fields.root_id})
		};
		this.dictionaries.facilities.unshift(this.root_facility);
		if (this.fields.id) {
			this.facility=this.site.models.Facility.Get(this.fields.id);
		} else {
			this.facility={parent_id:this.fields.root_id};
		}
		return this.Cview();
	},

	sub_facility_save: function() {
		if (!this.roles.gtm_facilities) throw "Нет доступа";
		if (this.fields.id) {
			this.facility=this.site.models.Facility.Get(this.fields.id);
		} else {
			this.facility=this.site.models.Facility.Create();
		}
		var inputname = 'image_id-file';
		if (this.req.files[inputname]) this.fields.image_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		this.facility.image_id=this.fields.image_id;
		this.facility.name=this.fields.name;
		this.facility.parent_id=this.fields.parent_id;
		this.facility.code=this.fields.code;
		this.facility.address=this.fields.address;
		this.facility.SaveAll();
		return JSON.stringify({redirect:{url:this.action+"?mode=viewer&root_id="+this.fields.root_id}});
	},


}];

