exports.add=[{
	 _type:"model_methods",
	_config: {name:"Facility"},	

	AfterSaveCustom: function(){
		
		var text = '';
		var t = this;
		
		if (!this.history_type) return;
		
		if (this.history_type == 'new' ) {
			text = 'Создан новый объект "' + this.name + '"';
			this.GetRR().F('GTM', 'save_history', this, 'Facility', this.id, text );
		}
		
		if (this.history_type == 'edit' ) {
			
			var old_data = JSON.parse(this._old);
			
			if (old_data.name!=this.name) text += 'Объект переименован на "'+this.name+'"\n';
			
			[
				{ k:'base_principle_id',	name:'Принцип грунтов основания' },
				{ k:'foundation_depth',		name:'Глубина фундамента' },
				{ k:'frozen_depth',			name:'СТС/СМС' },
				{ k:'dumping_depth',		name:'Уровень естественной поверхности' },
				{ k:'allowed_deformation',	name:'Допустимая величина деформации' },
				{ k:'allowed_temperature',	name:'Максимальная допустимая температура' }
			].forEach(function(el){
				if (old_data[el.k]!=t[el.k]) text += 'Параметр объекта "'+el.name+'" изменен на "'+t[el.k]+'"\n';	
			});
			
			if (text) this.GetRR().F('GTM', 'save_history', this, 'Facility', this.id, text );
		}
	},	

	AfterFetchCustom:function(){
		
		var rr = this.GetRR();
		
		this.comments_length = rr.site.sql.execute_and_fetch_one('facilities/comments_count',{facility_id:this.id}).count || 0;
		this.photos_length = rr.site.sql.execute_and_fetch_one('facilities/photos_count',{facility_id:this.id}).count || 0;
		
		this._old = JSON.stringify(this);
	},
	
	toJSONCustom: function(h){
		
		var t = this;
		
		var rr = this.GetRR();
				
		h.comments_length = this.comments_length;
		h.photos_length = this.photos_length;
	
		h.facilities = this.facilities;
		h.sensors = this.sensors;
		h.groups = this.groups;
		h.explication = this.explication;
		h.sensors_groups = this.sensors_groups;
		h.parent = this.parent;
		
		var plan = rr.M['Plan'].Get(this.plan_id);
		
		h.jpg_url = plan.jpg_url;
		h.jpg_id = plan.jpg_id;
		
		h.pdf_url = plan.pdf_url;
		h.calc_pdf_url = plan.calc_pdf_url;
		h.pdf_id = plan.pdf_id;
			
		h.plan = plan;
		
		h.urn_encoded = plan.urn_encoded;
		
		// prepare to mobile
		
		if (this._mobile) {
			h.comments = rr.C('GTM','get_facility_comments',{ facility_id:this.id });
			var json = {};
			[
				'id',
				'name',
				'parent_id',
				'jpg_url',
				'jpg_id',
				'location_x',
				'location_y',
				'sensors',
				'facilities',
				'comments',
				'comments_length',
				'photos_length',			
				'element_size'
			].forEach(function(k){ json[k] = t[k]; });
			h = json;
		}

	}
	
}];

