exports.add=[{
	_type:"model_methods",
	_config: {name:"Sensor"},
	
	AfterSaveCustom: function(){

		
		if (!this.history_type) return;
		
		var text = '';
		var t = this;
		var rr = this.GetRR();
				
		if (this.history_type == 'new') {
			var type_name = rr.M['AllowedModelType'].Get(this.allowed_model_type_id).name;
			text = 'Создан новый элемент '+type_name+' "' + this.name + '"';
			rr.F('GTM', 'save_history', this, 'Sensor', this.facility_id, text );
		}

		if (this.history_type == 'delete') {
			text = 'Удален элемент "' + this.name + '"';
			rr.F('GTM', 'save_history', this, 'Sensor', this.facility_id, text );
		}
		
		if (this.history_type == 'edit') {
			
			var old_data = JSON.parse(this._old);
			
			if (old_data.name!=this.name) text += 'Элемент {'+old_data.name+'} переименован на "'+this.name+'"\n';
			
			[
				{ k:'state_id',		name:'Состояние', dict:'SensorState' },
				{ k:'allowed_model_type_id',	name:' Конструкция', dict:'AllowedModelType' },
				{ k:'is_translator',			name:'Ретранслятор' },			
				{ k:'angle',	name:'Угол' },
				{ k:'reference_date',	name:'Дата реперного замера' },
			].forEach(function(el){
				if ((old_data[el.k]||t[el.k]) && old_data[el.k]!=t[el.k]) {
					var param = !el.dict ? t[el.k] : rr.M[el.dict].Get(t[el.k]).name;
					text += 'Параметр элемента {'+ t.name +'} "'+el.name+'" изменен на "' + param + '"\n';
				}
			});
			
			if (text) this.GetRR().F('GTM', 'save_history', this, 'Sensor', this.facility_id, text );
		}
	},	
	
	AfterFetchCustom:function(){
		var rr = this.GetRR();
		this.comments_length = rr.site.sql.execute_and_fetch_one('sensors/comments_count',{sensor_id:this.id}).count;
		this.photos_length = rr.site.sql.execute_and_fetch_one('sensors/photos_count',{sensor_id:this.id}).count;
		this._old = JSON.stringify(this);
	},
	
	toJSONCustom: function(h){
		
		var t = this;
		var rr = this.GetRR();
		
		h.comments_length = this.comments_length;
		h.photos_length = this.photos_length;
		
		if (this.reference_date) {		
			var query = "select value from tsensor_values where sensor_id=:id and date_use=to_date(:reference_date,'DD.MM.YYYY')";
			h.reference_value = rr.site.sql.execute_and_fetch_single(query,this).map(function(el){ return el.value; })[0]; // костыль
			h.reference_date_rev = this.reference_date.match(/^(\d+)\.(\d+)\.(\d+)$/).reverse().slice(0,3).join('-');
		}
		
		var ld = rr.site.sql.execute_and_fetch_one_single("select date_use from tsensor_values where sensor_id=:id order by date_use desc limit 1",{ id:this.id });
		h.last_value_date = (ld && ld.date_use) || '-';
		
		h.braids = rr.M['Braid'].List('list_of_sensor',{sensor_id:this.id});
		h.deeps = h.braids.reduce(function(h,el){h[el.deep]=el.id;return h;},{});
		
		if (this._mobile) {
			h.comments = rr.C('GTM','get_sensor_comments',{ sensor_id:this.id });
			var json = {};
			[
				'id',
				'name',
				'type_name',
				'facility_id',
				'allowed_model_type_id',
				'location_x',
				'location_y',
				'state_id',
				'state_code',
				'allowed_model_type_code',
				'is_retranslator',			
				'angle',
				'deleted',
				'braids',
				'comments',
				'comments_length',
				'photos_length',
			].forEach(function(k){ json[k] = h[k]; });
			h = json;
		}
		
	}
}];

