///PLANS PAGE

GTM.init_plans = function(){
	
	this.render('left',this.data,'plans/list');
	this.render('right',this.data,'plans/plan');
	
	this.init_actions();
//	this.init_dwg();
	this.init_plan();
	
}

GTM.init_actions = function(){
	var t = this;
	this.block('formats').on('change',function(){
		var id = $(this).val();
		t.render('template',{ format:t.get('PlanFormat',id) }, 'plans/template');
	}).change();
}

GTM.init_plan = function(){
	
	var t = this;
	if (!this.data.plan) return;
	this.init_pdf();
	this.render_pdf();
}

GTM.render_pdf = function(){
	
	var t = this;
	var doc = PDFJS.getDocument(this.data.plan.calc_pdf_url);
	
	doc.promise.then(function(pdf){
		pdf.getPage(1).then(function(page){
			var s = 1;
			var viewport = page.getViewport(s);
						
			t.pdf.canvas.height = viewport.height;
			t.pdf.canvas.width = viewport.width;
			
			var renderContext = {
				canvasContext:	t.pdf.context,
				viewport:		viewport
			};
			
			page.render(renderContext);
		});				
	});
}

GTM.submit = function(){
	
	var t = this;
	
	var form = new FormData(document.getElementById('planform'));
	console.log('Form',form);
	
	$.ajax({
		url: "/GTM/create_plan/",
		type: "POST",
		data: form,
		dataType: 'json',
		enctype: 'multipart/form-data',
		processData: false,
		contentType: false,
		success: function (data) {
			if (data.error) t.error(data.error);
			if (data.id) window.location = '/plans/?plan_id=' + data.id;
		},
		error:function(err){
			if (err && err.responseText) t.error(err.responseText);
		}
	});
}



GTM.delete_plan = function(id){
	
	var t = this;
	
	$.ajax({
		url: "/GTM/delete_plan/",
		type: "POST",
		data: {ajaj:1,plan_id:id},
		dataType: 'json',
		success: function (data) {
			if (data.error) t.error(data.error);
			else window.location = '/plans/';
		},
		error:function(err){
			if (err && err.responseText) t.error(err.responseText);
		}
	});
}

			