function pad(n){return n<10?'0'+n:n;}
function date_to_bd(date){ return date.getFullYear()+'-'+pad(date.getMonth()+1)+'-'+pad(date.getDate()); }
function date_to_js(date){ var arr = date.match(/(\d+).(\d+).(\d+)/);return new Date(arr[3],arr[2]-1,arr[1]); }

var Element = function(type,id){
	this.item = Dashboard.hash[type][id];
	this.type = type;
	this.init(type);
}

Element.prototype.init = function(type){
	
	if (type=='sensors' && this.item.allowed_model_type_code.match(/dm/)) this.item.has_angle = 1;
	
	lnrr.item = this.item;
	lnrr.type = type;
	
	this.target = $(lnrr.View('website/dashboard/element'));
	$('.right > .map').append(this.target);
	if (this.item.clipmap) {
		this.clip = $(lnrr.View('website/dashboard/clip'));
		$('.right > .map .layers').append(this.clip);
		Dashboard.init_hover();
	}	
	
	this.init_actions();
};

Element.prototype.round = function(v){
	Dashboard.request('switch_angle',{v:v,id:this.target.attr('data-id')});
}

Element.prototype.render_viewer = function(){
	var el = this.target.css({'z-index':9});
	var type = el.attr('data-type');
	var id = el.attr('data-id');
	var item = Dashboard.hash[type][id];
	var pos = Viewer.calc_pos({
		x:item.location_x,
		y:item.location_y
	},1);
	el.css({
		height:6*pos.size,
		width:6*pos.size,
		left:pos.x,
		top:pos.y
	});
	//this.render_clip();
}

Element.prototype.render = function(){
	var el = this.target.css({'z-index':'initial'});
	var type = el.attr('data-type');
	var id = el.attr('data-id');
	var item = Dashboard.hash[type][id];
	var pos = Pic.calc_pos({
		x:item.location_x*Dashboard.pic_ratio_x,
		y:item.location_y*Dashboard.pic_ratio_y
	});
	el.css({
		height:Pic.size*50,
		width:Pic.size*50,
		left:pos.x,
		top:pos.y
	});
	this.render_clip();
};

Element.prototype.render_clip = function(){
	if (!this.clip)	return;
	this.clip.css(Pic.cssstyles);
	Pic.render_clipmap(this.item.clipmap,this.clip);
};

Element.prototype.init_actions = function(){
	var t = this;
	this.target.on('click',function(e){
		e.preventDefault();
		e.stopPropagation();
		delete t.click;
		if (t.draged) {
			t.save();
			delete t.draged;
			return;
		}
		if (t.type=='facilities') window.location = '/dashboard/'+t.item.id;
		else Dashboard.edit_sensor(t.item.id);
	});
	this.target.find('.context').on('mousedown touchstart click',function(e){ e.stopPropagation(); });
	this.target.on('mousedown touchstart',function(e){
		if (Dashboard.blocked) return;
		t.click = 1;
		t.l = parseInt(t.target.css('left'));
		t.t = parseInt(t.target.css('top'));
		t.x = (e.clientX||event.touches[0].pageX);
		t.y = (e.clientY||event.touches[0].pageY);
	});
	this.target.find('.direction').on('click',function(){t.round($(this).hasClass('r')?1:-1)});
	this.target.find('.comments').on('click',function(){Dashboard.edit_comments('sensor',t.item.id)});
	
//	if (this.clip) this.clip.on('click',function(){ window.location = '/dashboard/'+t.item.id+'/'; });
	
};

Element.prototype.drag = function(x,y){
	this.draged = 1;
	this.target.css({
		left:	this.l+x,
		top:	this.t+y
	});
}

Element.prototype.save = function(is_viewer){
	
	
	var pos = Pic.calc_coords({
		x:parseInt(this.target.offset().left) + this.target.height()/2,
		y:parseInt(this.target.offset().top) + this.target.width()/2
	});
	
	if(Dashboard.view_mode!='viewer') {
		
		if (pos.x>0&&pos.x<Dashboard.pic.img.width && pos.y>0&&pos.y<Dashboard.pic.img.height) {
			var mode = 'save_'+(this.type=='facilities'?'facility':'sensor');
			Dashboard.request(mode,{
				justcoords:	1,
				id:				this.item.id,
				location_x:	pos.rel_x,
				location_y:	pos.rel_y
			});
		} else Pic.render_elements();
		
	} else {
		var facility = Dashboard.get_facility();
		var coords = Viewer.calc_coords(pos);
		if (coords.x<facility.width && coords.y<facility.height) {
			var mode = 'save_'+(this.type=='facilities'?'facility':'sensor');
			var data = {
				justcoords:	1,
				id:			this.item.id,
				location_x:	parseInt(coords.x),
				location_y: parseInt(facility.height-coords.y)
			};
			Dashboard.request(mode,data);
		} else Pic.render_elements();
	}
}

var Context = {
	cssclass:'Context',
	init:function(){
		$('.'+this.cssclass).remove();
		this.target = $(lnrr.View('website/widgets/Context'));
		$('body').append(this.target.addClass(this.cssclass));
		this.hide();
		this.init_action();
	},
	init_action:function(){
		$('.item:not(.section)',this.target).on('click',function(e){
			e.stopPropagation();
		});	
	},
	hide:function(){
		if (this.target) this.target.hide();
	},
	show:function(e){
		Pic.calc_context_pos(e);
		Viewer.calc_context_pos(e);
		this.target.show().css({
			'top':e.clientY+'px',
			'left':e.clientX+'px'
		});
	}
};

var Popup = {
	targetclass : 'Popup',
	init:function (data) {
		data = data||{};
		lnrr.popup=data;
		this.open();
	},
	open:function(){
		var t = this;
		if (lnrr.popup.type=='error' && $('.'+t.targetclass).length) {
			$('.'+t.targetclass).find('.error_log').show().html(lnrr.popup.text);
			this.render();
			return;
		}
		this.close();
		Context.hide();
		var html = $(lnrr.View('website/widgets/Popup'));
		html.addClass(this.targetclass);
		$('body').append(html);
		this.target = html;
		this.render();
		$('input,textarea',html).eq(0).focus();
		$('.to_focus').show().focus().hide();
	},
	render: function(){
		if (!Popup.target) return;
		var w = Popup.target.find('.window');
		if (lnrr.popup.type=='comments' ||
			lnrr.popup.type=='history') w.css('width','inherit');
		w.css({
			'margin-left':	-w.width()/2,
			'margin-top':	-w.height()/2,
		});
	},
	close:function(){
		var t = this;
		$('.'+t.targetclass).remove();
		
	}
}

var Pic = {
	
	pos:{},
	elements:[],
	context_pos:{},
	target:'',
	
	render_clipmap: function(clipmap,tag){
		var s = [];
		if (!clipmap) { tag.removeClass('A'); return; }
		var arr = clipmap.split(';');
		if (!arr || arr.length<3) {tag.removeClass('A');return;}
		arr.forEach(function(coords){
			if (!coords) return;
			var pos = coords.split(',').reduce(function(h,el,i){
				h[!i?'x':'y'] = el;
				return h;
			},{});
			var xr = pos.x*Pic.size+Pic.pos.x;
			var yr = pos.y*Pic.size+Pic.pos.y;
			var H = $('.map > .pic').height();
			var W = $('.map > .pic').width();			
			var xproc = (100*(xr/W)).toFixed(2);
			var yproc = (100*(yr/H)).toFixed(2);
			s.push( [xproc,yproc].map(function(el){return el+'%';}).join(' ') );
		});
		var polygon = s.join(',');
		tag.css({
			'-webkit-clip-path': 'polygon('+polygon+')'
		}).addClass('A');	
	},
	
	inc_size: function(i){	
		if (!this.target) return;
		var data_height = Dashboard.dragarea.target.parent().height();
		this.target.height($('.main > .right').height() - data_height);
		var size = this.size;
		this.size += i;
		if (this.size>1) this.size = 1;
		this.calc();
		if (!this.stoph||!this.stopw) this.size=size;	
		this.set_pos(this.pos.x,this.pos.y);
		this.refresh_styles();
		this.render();
		this.calc_stops();
		if (this.stoph<0||this.stopw<0) {
			var size1 = this.target.height()/this.img.height;
			var size2 = this.target.width()/this.img.width;
			this.size = size1>size2 ? size1 : size2;
		}
		this.refresh_styles();
		this.render();
	},
	
	calc_stops: function(){
		this.stoph = this.img.height*this.size - this.target.height();
		this.stopw = this.img.width*this.size -  this.target.width();
	},
	
	correct_stops: function(){
		if (this.stoph<=0) this.stoph=0;
		if (this.stopw<=0) this.stopw=0;
	},
	
	calc:function(){
		this.calc_stops();
		this.correct_stops();
	},
	
	set_pos: function(pos_x,pos_y){
		if (pos_y>=0) pos_y = 0;
		if (pos_x>=0) pos_x = 0;
		if (pos_x<=-this.stopw) pos_x = -this.stopw;
		if (pos_y<=-this.stoph) pos_y = -this.stoph;
		this.pos = {x:pos_x,y:pos_y};
	},
	
	get_back_pos: function(){
		this.bx = parseInt(this.target.css('background-position-x'));
		this.by = parseInt(this.target.css('background-position-y'));
	},
	
	center:function(x,y){
		var ww = this.target.width();
		var wh = this.target.height();		
		var px = -(x*this.size-ww/2)
		var py = -(y*this.size-wh/2);
		this.set_pos(px,py);
		this.render();
	},
	
	move: function(xv,yv){
		this.get_back_pos();
		this.drag(xv,yv);
	},
	
	drag: function(xv,yv){
		this.set_pos(this.bx + xv,this.by + yv);
		this.render();
		this.render_elements();
	},
	
	refresh_styles: function(s){
		lnrr.size = s || this.size;
		//lnrr.pos = this.pos;
		//lnrr.img = this.img;
		//lnrr.w = this.img.width * this.size;
		//lnrr.h = this.img.height * this.size;
		var styles = $(lnrr.View('website/dashboard/_styles')).html();
		$('#_styles').html(styles);
	},
	
	render: function(){
		var t = this;
		this.cssstyles = {
			'background-position-y': this.pos.y,
			'background-position-x': this.pos.x,
			'background-size': this.size*this.img.width + 'px ' + this.size*this.img.height + 'px'
		};		
		this.target.css(this.cssstyles);
		this.render_clipmapeditor(this.cssstyles);
		this.render_elements();
	},
	
	render_clipmapeditor: function(cssstyles){
		if (cssstyles) Dashboard.clipmap_editor.css(cssstyles);
		var v = Dashboard.clipmap_input.val();
		Pic.render_clipmap(v,Dashboard.clipmap_editor);
	},
	
	gen_filters: function(){
		var filters = {};
		['.actions .filter[data-name=sensor_models]',
		 '.actions .filter[data-name=sensor_states]',
		 '.list[data-name=sensors]',
		 '.list[data-name=groups]',
		 '.list[data-name=facilities]',
		 ].forEach(function(el){
			var block = $(el);
			var k = block.attr('data-name');
			var list = $('.cb.A',block);
			filters[k] = {};
			if (!list.length) filters['all_'+k]=1;
			else if(k!='groups') list.each(function(){filters[k][$(this).attr('data-id')]=1;})
			else list.each(function(){
				var gid = parseInt($(this).attr('data-id'));
				for (j in Dashboard.hash.sensor_groups[gid]) filters[k][Dashboard.hash.sensor_groups[gid][j].sensor_id]=1;		  
			});	
		});
		filters.retranslator = $('.actions .filter[data-name=retranslator] .cb').hasClass('A');
		return filters;
	},
	
	check:function(item,type,filters){
		console.log(arguments);
		var id = item.id;
		if (type == 'sensors') {
			var model_id = Dashboard.hash.amt[item.allowed_model_type_id].sensor_model_id;
			if (!filters.all_sensors && !filters.sensors[id]) return false;
			if (!filters.all_sensor_states && !filters.sensor_states[item.state_id]) return false;
			if (!filters.all_sensor_models && !filters.sensor_models[model_id]) return false;
			if (!filters.all_groups && !filters.groups[id]) return false;
			if (filters.retranslator && !item.is_retranslator) return false;
			if (item.deleted) return false;
			return true;
		}
		if (type == 'facilities') {
			if (!filters.all_facilities && !filters.facilities[id]) return false;
			return true;
		}
		return true;
	},
	
	init_elements:function(){
		var t = this;
		var filters = this.gen_filters();
		var filter = function(k,id){
			var item = Dashboard.hash[k][id];
			return Dashboard.pdf? 1 : t.check(item,k,filters);
		};
		var t = this;		
		var class_hash = {};
		$('.right > .map .element,.clipmap:not(.editor)').each(function(){
			var id = $(this).attr('data-id');
			var type = $(this).attr('data-type');
			if (!type) return;
			if (!class_hash[type]) class_hash[type]={};
			class_hash[type][id] = $(this).attr('class');
		}).remove();		
		this.elements = [];
		['sensors','facilities'].forEach(function(k){			
			for (id in Dashboard.hash[k]) {
				if (k=='facilities'&&id==Dashboard.main_id || !filter(k,id)) continue;
				var element = new Element(k,id);
				t.elements.push(element);
				if (class_hash[k]&&class_hash[k][id]) element.target.addClass(class_hash[k][id])
			}
		});
	},
	
	select_sensor: function(id){
		$('.element').removeClass('A');
		$('.element[data-type=sensors][data-id='+id+']').addClass('A');
		var item = Dashboard.hash.sensors[id];
		Pic.center( item.location_x*Dashboard.pic_ratio_x, item.location_y*Dashboard.pic_ratio_y );
	},
	
	render_elements: function(){
		var t = this;
		var a = Dashboard.view_mode=='map' ? 'render' : 'render_viewer';
		this.elements.forEach(function(el){ el[a](); });
	},
	
	refresh_elements: function(){
		this.init_elements();
		this.render_elements();
		Dashboard.render_data();
	},
	
	calc_pos: function(e){
		return pos = {
			x:parseInt(this.size*e.x+this.pos.x),
			y:parseInt(this.size*e.y+this.pos.y)
		};
	},
	
	calc_coords: function(e){
		var left = $('.main > .left').width();
		var top = $('.hat').height();
		var x = parseInt((e.x-left-this.pos.x)/this.size);
		var y = parseInt((e.y-top-this.pos.y)/this.size);
		return pos = {
			x:x,
			y:y,
			rel_x:parseInt(x/Dashboard.pic_ratio_x),
			rel_y:parseInt(y/Dashboard.pic_ratio_y)
		};
	},
	
	show_coords: function(e){
		var pos = this.calc_coords(e);
		$('#relx').html(pos.rel_x);
		$('#rely').html(pos.rel_y);
		$('#mapx').html(pos.x);
		$('#mapy').html(pos.y);
	},
	
	calc_context_pos: function(e){ this.context_pos = this.calc_coords({ x:e.clientX, y:e.clientY });  },
	
	uninit: function(){
		if (!this.target) return;
		this.target.hide();
		this.target.off('mousemove mousewheel contextmenu mousedown touchstart click');
		delete this.click;
		delete this.x;
		delete this.y;
	}
};

var Dashboard = {};
Dashboard.init = function(){
	var t = this;
	this.values_to_save = [];
	this.values = [];
	this.states = {};
	this.hash = {};
	['sensor_groups','group_sensors','facilities','sensors','groups','amt','avt','normatives'].forEach(function(k){t.hash[k]={};});
	if(this.data.facility) this.init_facility(this.data.facility,'true');
	if(this.data.facilities) this.data.facilities.forEach(function(el){t.init_facility(el);});
	if(this.data.groups) this.data.groups.forEach(function(el){t.init_group(el);});
	if(this.data.sensors) this.data.sensors.forEach(function(el){t.init_sensor(el);});
	if(this.data.sensor_groups) this.data.sensor_groups.forEach(function(el){t.init_sensor_group(el);});
	lnrr.dictionaries['AllowedModelType'].forEach(function(el){ t.hash.amt[el.id] = el; });
	lnrr.dictionaries['AllowedValueType'].forEach(function(el){ t.hash.avt[el.id] = el; });
	
};

Dashboard.V = function(template){return lnrr.View('website/dashboard/'+template)};

Dashboard.get_facility = function(id){
	if (!id) id = this.main_id;
	return this.hash.facilities[id];
}

Dashboard.init_facility = function(facility,is_main){
	var f = facility;	
	if (is_main) this.main_id = f.id;
	if (this.main_id == f.id) this.hash['normatives']=f.normatives.reduce(function(h,el){h[el.id]=el.value;return h;},{});
	f.periods = [];
	lnrr.dictionaries['SensorModel'].forEach(function(el){
		var item = {model:el,value:f['period_'+el.id]}
		f.periods.push(item);
	});
	this.hash['facilities'][f.id]=f;
	lnrr.facility = f;
}

Dashboard.init_sensor = function(sensor){
	var s = sensor;
	if (s.allowed_model_type_code.match(/dm/)) s.has_angle = 1;
	this.hash['sensors'][s.id]=s;
}

Dashboard.init_group = function(group){
	var g = group;
	this.hash['groups'][g.id]=g;
}
Dashboard.clear_sensor_group = function(sensor_id){
	var k =  'sensor_groups';
	var ak = 'group_sensors';
	if(!this.hash[ak]) this.hash[ak]={};
	this.hash[ak][sensor_id] = 0;
	
	if(!this.hash[k]) this.hash[k]={};
	for (group_id in this.hash[k]) delete this.hash[k][group_id][sensor_id];
}
Dashboard.init_sensor_group = function(sensor_group){
	var k =  'sensor_groups';
	var ak = 'group_sensors';
	if(!this.hash[k][sensor_group.group_id]) this.hash[k][sensor_group.group_id]={};
	if(!this.hash[ak][sensor_group.sensor_id]) this.hash[ak][sensor_group.sensor_id]={};
	this.hash[k][sensor_group.group_id][sensor_group.sensor_id] = sensor_group;
	this.hash[ak][sensor_group.sensor_id][sensor_group.group_id] = sensor_group;
}

Dashboard.request=function(mode,data,add_callback){
	var t = this;
	if (t.pending) return;
	Dashboard.log('Выполняется запрос ['+mode+']');
	t.pending=1;
	data = data||{};
	data.ajaj = 1;
	data.mode = mode;
	var callback = {
		'save_facility':function(data){
			var f = data.facility;
			t.init_facility(f);
			if(f.id==t.main_id) {
				t.refresh_facility();
				t.init_pic();
			} else {
				t.refresh_facilities();
				t.pic.init_elements();
				t.pic.render_elements();
			}
			Popup.close();
		},
		'save_sensor':function(data){
			t.init_sensor(data.sensor);
			t.refresh_sensors();
			t.refresh_sensor();
			t.pic.init_elements();
			t.pic.render_elements();
			Popup.close();
		},
		'delete_sensor':function(data){
			t.init_sensor(data.sensor);
			t.refresh_sensors();
			t.pic.init_elements();
			t.pic.render_elements();
			t.switch_element_wrapper(0);
		},
		'switch_angle':function(data){
			if (!data.sensor) return;
			t.init_sensor(data.sensor);
			t.refresh_sensors();
			t.refresh_sensor();
			t.pic.init_elements();
			t.pic.render_elements();
		},
		'save_group':function(data){
			t.init_group(data.group);
			t.refresh_groups();
			t.refresh_sensors();
			Popup.close();
		},
		'save_sensor_group':function(data){
			t.clear_sensor_group(data.sensor_id);
			data.sensor_groups.forEach(function(el){t.init_sensor_group(el);});
			t.refresh_sensors();
			t.refresh_sensor();
			t.pic.init_elements();
			t.pic.render_elements();
			Popup.close();
		},
		'all_values':function(data){
			Dashboard.values = data;
		},
		'get_braid':function(data){
			t.add_braid(data);
		},
		'get_facility_comments':function(data){
			t.add_comments(data);
		},
		'get_sensor_comments':function(data){
			t.add_comments(data);
		},
		'save_sensor_comment':function(data){
			t.add_comments(data);
		},
		'save_facility_comment':function(data){
			t.add_comments(data);
		},
		'save_normative':function(data){
			t.init_facility(data.facility);
			t.edit_normatives();
		},
		'get_history':function(data){
			t.show_history(data);
		},
		'save_normatives':function(data){
			t.init_facility(data.facility);
			Popup.close();
		},
	}[mode] || function(rr){ console.log('No handler to '+mode,rr); };
	
	if (lnrr.start) callback = function(){ window.location.reload(); }
	
	$.ajax({
		url:'/dashboard/',
		method:'POST',
		data:data,
		dataType:'json',
		success:function(r){
			t.pending = 0;
			Dashboard.log('Запрос успешно завершен',1);
			if( r&&r.error ) {
				if (r.call) r.call.split(',').forEach(function(c){ Dashboard[c](); });
				Popup.init({ type:'error', title:'Ошибка', text:r.error });
				return;
			}
			callback(r);
			if(add_callback) add_callback(r);
		},
		error:function(e){
			t.pending=0;
			Dashboard.log('Запрос выполнен некорректно');
			console.log(e);
			if (!e) return;
			if (typeof e == 'string') Popup.init({ type:'error', title:'Ошибка запроса', text:e });
			else {
				var text = e.responseText;
				text = text ? text.replace(/\\n/g,'<br/>').replace(/\\t/g,'&#9;') : 'неизвестная ошибка';
				Popup.init({ type:'error', title:'Ошибка запроса', text:text });
			}
		}
	});
}

Dashboard.switch_element_wrapper = function(show){
	var a = show ? 'show':'hide';
	$('.element_wrapper')[a]();
	var mh = $('body > .main').height();
	var eh = show ? ($('.element_wrapper').height()+8) : 0;
	$('.main > .left .scroller').height(mh-eh);
}

Dashboard.prepare = function(type,add_id){
	var t = this;
	var arr = [];
	for(k in this.hash[type]){
		if (type=='facilities' && this.hash[type][k].id==this.main_id) continue;
		var item = this.hash[type][k];
		if (item.deleted) continue;
		arr.push(item);
	}
	if (type=='sensors') arr.forEach(function(el){
		el.groups = '';
		var groups = [];
		for(k in t.hash.group_sensors[el.id]) groups.push(t.hash.groups[k].name);
		if(groups.length) el.groups = '['+groups.join(', ')+']';
	});
	if (type=='groups' && add_id) arr.forEach(function(el){
		el.enabled = 0;
		var h = t.hash.group_sensors[add_id];
		if (!h) return;
		if (h[el.id]) el.enabled = 1;
	});
	return arr;
}

Dashboard.get_data = function(tag,data){
	data = data||{};
	tag.find('.inp input,.inp select,textarea').each(function(){ data[$(this).attr('name')] = $(this).val(); });
	tag.find('.cb').each(function(){ data[$(this).attr('data-name')] = $(this).hasClass('A')?1:0; });
	var loader = tag.find('.loader');
	if (loader.length) loader.each(function(){
		data[$(this).attr('data-name')] = $(this).attr('data-id');	
	});
	return data;
}

Dashboard.refresh_block = function(block,view_code){
	if (block.attr('view')) view_code = block.attr('view');
	return block.replaceWith(this.V(view_code));
}

Dashboard.refresh_facility = function(){
	if (!this.main_id) return;
	lnrr.facility = this.hash.facilities[this.main_id];
	this.refresh_block($('.left .params[data-name=facility]'));
}

Dashboard.refresh_facilities = function(){
	lnrr.facilities = this.prepare('facilities');
	this.refresh_block($('.list[data-name=facilities]'),'facilities_list');
	this.init_hover();
}

Dashboard.refresh_sensor = function(){
	this.prepare('sensors');
	var params = $('.main .params[data-name=sensor]');
	var id = params.attr('data-id');
	if (!id) return;
	lnrr.sensor = this.hash.sensors[id];
	
	var amt = Dashboard.hash.amt[lnrr.sensor.allowed_model_type_id];
	['has_braid','can_be_retranslator'].forEach(function(k){lnrr.sensor[k]=amt[k]});
	this.prepare_allowed(amt.sensor_model_id);
	params.replaceWith($(lnrr.View('website/dashboard/sensor_params')).attr('data-id',id));
}

Dashboard.refresh_sensors = function(){
	lnrr.sensors = this.prepare('sensors');
	$('.list[data-name=sensors]').replaceWith(lnrr.View('website/dashboard/sensors_list'));
	this.init_hover();
}

Dashboard.refresh_groups = function(){
	lnrr.groups = this.prepare('groups');
	$('.list[data-name=groups]').replaceWith(lnrr.View('website/dashboard/groups_list'));
	this.init_hover();
}

Dashboard.add_facility = function(data){
	data=data||{};
	if (this.main_id) data.parent_id = this.main_id;
	lnrr.facility = {};
	for (k in data) lnrr.facility[k] = data[k];
	if (data.context) {
		lnrr.facility.location_x = this.pic.context_pos.rel_x;
		lnrr.facility.location_y = this.pic.context_pos.rel_y;
	}
	Popup.init({type:'facility',title:'Добавление '+(lnrr.start?'площадки':'подобъекта'),form:lnrr.View('website/dashboard/facility_params')});
}

Dashboard.prepare_allowed = function(sensor_model_id){
	lnrr.allowed_model_types = [];
	for (k in this.hash.amt)
		if (this.hash.amt[k].sensor_model_id==sensor_model_id)
			lnrr.allowed_model_types.push(this.hash.amt[k]);
}

Dashboard.add_sensor = function(data){
	data=data||{};
	lnrr.sensor = {};
	for (k in data) lnrr.sensor[k] = data[k];
	if (data.context && Dashboard.view_mode=='map') {
		lnrr.sensor.location_x = this.pic.context_pos.rel_x;
		lnrr.sensor.location_y = this.pic.context_pos.rel_y;
	}
	if (data.context && Dashboard.view_mode=='viewer') {
		lnrr.sensor.location_x = parseInt(Viewer.context_coords.x) || 0;
		lnrr.sensor.location_y = parseInt(this.get_facility().height-Viewer.context_coords.y) || 0;
	}
	if (!data.sensor_model_id) {
		Popup.init({type:'models',title:'Выбор модели',form:lnrr.View('website/dashboard/models')});
	} else {
		this.prepare_allowed(data.sensor_model_id);
		if (data.sensor_model_id==10 ||
			data.sensor_model_id==14) lnrr.sensor.has_braid = 1;
		lnrr.sensor.can_be_retranslator = 1;
		Popup.init({type:'sensor',title:'Добавление элемента',form:lnrr.View('website/dashboard/sensor_params')});
	}
}

Dashboard.add_to_group = function(tag){
	var id = tag.closest('.content').find('.params').attr('data-id');
	lnrr.sensor = this.hash.sensors[id];
	lnrr.groups = this.prepare('groups',id);
	Popup.init({type:'add_to_group',title:'Добавление элемента в группу',form:lnrr.View('website/dashboard/add_to_group')});
}

Dashboard.import_xlsx = function(tag){
	var id = tag.closest('.content').find('.params').attr('data-id');
	lnrr.sensor = this.hash.sensors[id];
	Popup.init({type:'import_xlsx',title:'Импорт данных для '+lnrr.sensor.name,form:lnrr.View('website/dashboard/import_xlsx')});
}

Dashboard.edit_sensor = function(id){	
	var params = $('.main .left .params[data-name=sensor]');
	params.attr('data-id',id);	
	this.refresh_sensor();
	Pic.select_sensor(id);
	this.switch_element_wrapper(1);
}

Dashboard.add_group = function(data){
	lnrr.group = {};
	if (data) for (k in data) lnrr.group[k] = data[k];
	Popup.init({type:'group',title:'Добавление группы',form:lnrr.View('website/dashboard/group_params')});
}

Dashboard.edit_group = function(id){
	lnrr.group = this.hash.groups[id];
	Popup.init({type:'group',title:'Редактирование группы',form:lnrr.View('website/dashboard/group_params')});
}

Dashboard.save_facility = function(tag,id){
	var params = tag.closest('.content').find('.params[data-name=facility]');
	var data = this.get_data(params,data);
	if (id) data.id = id;
	else data.parent_id = this.main_id;
	this.request('save_facility',data);
}

Dashboard.save_sensor = function(tag,id){
	var params = tag.closest('.content').find('.params[data-name=sensor]');
	if (params.attr('data-id')) id = parseInt(params.attr('data-id'));
	var data = this.get_data(params,{ id:id, facility_id:this.main_id });
	this.request('save_sensor',data);
}

Dashboard.delete_sensor = function(tag,id){
	var params = tag.closest('.content').find('.params[data-name=sensor]');
	if (params.attr('data-id')) id = parseInt(params.attr('data-id'));
	var data = { id:id };
	this.request('delete_sensor',data);
}

Dashboard.save_group = function(tag,id){
	var params = tag.closest('.content').find('.params[data-name=group]');
	var data = this.get_data(params,{ id:id, facility_id:this.main_id });
	this.request('save_group',data);
}

Dashboard.save_sensor_group = function(sensor_id,tag){
	var params = tag.closest('.content').find('.params[data-name=groups]');
	data = this.get_data(params,{ sensor_id:sensor_id });
	this.request('save_sensor_group',data);
}

Dashboard.edit_braid = function(id){
	this.request('get_braid',{sensor_id:id});
}

Dashboard.add_braid = function(data){
	lnrr.braid = {};
	if (data) for (k in data) lnrr.braid[k] = data[k];
	Popup.init({ type:'braid', title:'Редактирование косы', form:lnrr.View('website/dashboard/braid') });
}

Dashboard.save_enable_braid = function(tag){
	var params = tag.closest('.content').find('.params[data-name=braid]');
	var data = this.get_data(params);
	this.request('save_enable_braid',{braids:JSON.stringify(data)});
}

Dashboard.save_xlsx_data = function(tag){
	var params = tag.closest('.content').find('.params[data-name=xlsx]');
	var data = this.get_data(params);
	this.request('save_xlsx_data',data);
}

Dashboard.edit_comments = function(type,id){
	var params = {type:type};
	if (type=='facility') params.facility_id = this.main_id;
	if (type=='sensor') params.sensor_id = id;
	this.request('get_'+type+'_comments',params);
}

Dashboard.get_history = function(){
	this.request('get_history',{ facility_id:this.main_id });
}

Dashboard.show_history = function(data){
	lnrr.history = data.history;
	Popup.init({type:'history',title:'История изменений',form:lnrr.View('website/dashboard/history')});
}

Dashboard.add_comments = function(data){
	lnrr.comments = [];
	lnrr.type = data.type;
	lnrr.id = data.id;
	data.comments.forEach(function(el){
		el.images = data.images[el.id]||[];
		lnrr.comments.push(el);
	});
	Popup.init({type:'comments',title:'Комментарии',form:lnrr.View('website/dashboard/comments')});
}

Dashboard.save_comment = function(tag,type,id){
	var params = tag.closest('.content').find('.params[data-name=comment]');
	data = this.get_data(params,{type:type});
	if (data.type=='sensor') data.sensor_id = id;
	if (data.type=='facility') data.facility_id = this.main_id;
	this.request('save_'+data.type+'_comment',data);
}

Dashboard.edit_normatives = function(){
	lnrr.facility = Dashboard.get_facility();
	Popup.init({ type:'normatives', title:'Критериальные параметры', form:lnrr.View('website/dashboard/normatives')});
}

Dashboard.save_normatives = function(tag){
	var params = tag.closest('.content').find('.params[data-name=normatives]');
	var data = this.get_data(params, { facility_id:this.main_id });
	this.request('save_normatives',data);
}

Dashboard.init_drag = function(){
	var dragarea = { target:$('.data .before') }
	dragarea.target.on('mousedown touchstart',function(e){
		dragarea.click = 1;
		dragarea.y = (e.clientY||event.touches[0].pageY);
		dragarea.h = dragarea.target.parent().height();
		dragarea.target.addClass('grab');
		e.stopPropagation();
		return false;
	});
	Dashboard.dragarea = dragarea;
	Dashboard.refresh_data();
};

Dashboard.log = function(string,clear){
	console.log('log',arguments);
	$('.left > .log').show().html(string);
	if (clear) {
		clearTimeout(this.log_tid);
		this.log_tid = setTimeout(function(){
			$('.left > .log').html('').hide();		
		},3000);
	}
}

Dashboard.toggle_panel = function(tag){
	$('.main').toggleClass('hidepanel');
	$(tag).find('span').html($('.main').hasClass('hidepanel')?'Отобразить':'Скрыть');
	Dashboard.refresh_data();
	Pic.inc_size(0);
}

Dashboard.switch_edit_mode = function(){
	Dashboard.clipmap_input.toggleClass('A');
	Dashboard.clip_edit = Dashboard.clipmap_input.hasClass('A');
}

Dashboard.block_moves = function(tag){
	Dashboard.blocked = tag.toggleClass('A').hasClass('A');
	tag.html(Dashboard.blocked ?'Разблокировать':'Заблокировать');
}

Dashboard.clear_element = function(event){
	if (event) event.stopPropagation();
	$('.element').removeClass('A');
	this.switch_element_wrapper(0);
}

Dashboard.switch_views = function(mode){
	this.view_mode = mode ? mode : (this.view_mode=='map' ? 'viewer' : 'map');
	
	try {
		this.uninit_viewer();
	} catch(e) {
		console.log('...wtf');
	}
	
	Pic.uninit();
	
	if (this.view_mode=='viewer') this.init_viewer();
	else this.init_pic();
}

Dashboard.init_pic = function(){
	if (!this.main_id) return;
	Pic.uninit();
	var t = this;
	var img = new Image();
	var url = this.hash.facilities[this.main_id].image_url;
	Dashboard.clipmap_input = $('input[name=clipmapeditor]');
	Dashboard.clipmap_editor = $('.clipmap.editor');
	Dashboard.log('Инициализируем карту...');
	img.onload = function(){
		
		Pic.target = $('.main .pic').css({
			'background-image':'url('+url+')'
		}).on('mousemove',function(e){
			Pic.show_coords({x:e.clientX,y:e.clientY});
		}).on('mousewheel',function(e){
			e.preventDefault();
			Pic.show_coords({x:e.clientX,y:e.clientY});
			Pic.inc_size(-0.001*e.originalEvent.deltaY);
		}).on('contextmenu',function(e){
			Context.show(e);
			e.stopPropagation();
			return false;
		}).on('mousedown touchstart',function(e){
			if (e.button==2) return;
			Pic.click = 1;
			Pic.x = (e.clientX||event.touches[0].pageX);
			Pic.y = (e.clientY||event.touches[0].pageY);
			Pic.get_back_pos();
		}).on('click',function(){
			Dashboard.clear_element();			
		}).show();
		
		Pic.img = img;
		
		Dashboard.pic_ratio_x = Pic.img.width/Dashboard.hash.facilities[Dashboard.main_id].width;
		Dashboard.pic_ratio_y = Pic.img.height/Dashboard.hash.facilities[Dashboard.main_id].height;
		
		Pic.size = 1;
		Pic.set_pos(0,0);
		Pic.init_elements();
		Pic.inc_size(0);
		
		Dashboard.log('Инициализация карты завершена',1);
	}
	img.src = url;
	this.pic = Pic;
};

Dashboard.init_global_actions=function(){
	var t = this;
	$('body').on('keyup',function(e){
		if(e.keyCode==27) { Popup.close(); Context.hide(); }
		if(e.shiftKey && e.keyCode==221) {
			var p = $('.cathead');
			p.show().animate({'margin-top':'0rem'},function(){setTimeout(function(){p.animate({'margin-top':'2.5rem'},function(){p.hide()});},2000);});
		}
	});
	var add_coord = function(p){
		var inp = Dashboard.clipmap_input;
		var coords = { x:p.x, y:p.y };
		var pos = Pic.calc_coords(coords);
		var v = inp.val() || '';
		v+=pos.x+','+pos.y+';';
		inp.val(v);
		Pic.render_clipmapeditor();
	}
	$(document).on('keydown',function(e){
		var v = e.shiftKey?250:50;
		var s = e.shiftKey?0.3:0.1;
		if(e.keyCode==66) Dashboard.block_moves($('.blocker')); // up
		if(e.keyCode==77) Dashboard.switch_edit_mode(); // up
		if(e.keyCode==69) {
			Dashboard.clipmap_input.val('');
			Pic.render_clipmapeditor();
		}
		if(e.keyCode==81) {
			if (!Dashboard.clip_edit) return;
			add_coord(t.lastcoords);
		}
		if(e.keyCode==82) {
			if (!Dashboard.clip_edit) return;
			var v = Dashboard.clipmap_input.val();
			if (!v) return;
			var arr = v.split(';');
			if (!arr||!arr.length) return;
			arr.pop();
			Dashboard.clipmap_input.val(arr.join(';'));
			Pic.render_clipmapeditor();
		}
		if(e.keyCode==38 ||
		   e.keyCode==87) Dashboard.pic.move(0,v); //up
		if(e.keyCode==40 ||
		   e.keyCode==83) Dashboard.pic.move(0,-v); //down
		if(e.keyCode==37 ||
		   e.keyCode==65) Dashboard.pic.move(v,0); //up
		if(e.keyCode==39 ||
		   e.keyCode==68) Dashboard.pic.move(-v,0); //down
		if(e.keyCode==187 ||
		   e.keyCode==107) Dashboard.pic.inc_size(-s);
		if(e.keyCode==189 ||
		   e.keyCode==109) Dashboard.pic.inc_size(s);
		if(e.keyCode>=48 && e.keyCode<=57 && false) {
			Dashboard.geometry_index = e.keyCode - 48;
			Dashboard.switch_views('viewer')
		}
	//	if(e.keyCode==86) Dashboard.switch_views();
	});
	$('.tabs .item').on('click',function(){
		$('.content[data-tab='+$(this).toggleClass('A').attr('data-tab')+']').toggleClass('A');
	});
	$('body').on('click',function(event){
		Context.hide();
		if (!Dashboard.clip_edit) return;
//		add_coord(t.lastcoords);
	})
	$('body').on('mouseup touchend',function(e){
		if (t.dragarea.click) Pic.inc_size(0);
		t.dragarea.click = 0;
		t.dragarea.target.removeClass('grab');
		if (t.pic) t.pic.click = 0;
	});
	$('body').on('mousemove touchmove',function(e){
		
		t.lastcoords = {x:e.clientX,y:e.clientY};
		
		if(t.dragarea.click) {
			var height = t.dragarea.h - (e.clientY||event.touches[0].pageY) + t.dragarea.y;
			t.dragarea.target.parent().height(height);
			e.preventDefault();
			return false;
		}
		
		if(t.pic && t.pic.click) {
			t.pic.drag(
				((e.clientX||event.touches[0].pageX) - t.pic.x),	 
				((e.clientY||event.touches[0].pageY) - t.pic.y)	 
			);
			e.preventDefault();
			return false;
		}
		
		if(t.pic) t.pic.elements.forEach(function(el){
			if(!el.click) return;
			e.preventDefault();
			Pic.show_coords({x:e.clientX,y:e.clientY});
			el.drag(
				((e.clientX||event.touches[0].pageX) - el.x),	 
				((e.clientY||event.touches[0].pageY) - el.y)	 
			);
		});
		
		if (Dashboard.clip_edit) {
			return;
			var pos = Pic.calc_coords(t.lastcoords);
			var v = Dashboard.clipmap_input.val()||'';
			var arr = v.split(';');
			if (!arr) return;
			console.log(arr, arr.filter(function(el){return el;}));
			arr = arr.filter(function(el){return el;});
			arr.push(pos.x+','+pos.y+';');
			v = arr.join(';');
			console.log(v);
			Pic.render_clipmap(v,Dashboard.clipmap_editor);
		}
	});
}
Dashboard.init_hover=function(){
	
	$('.list[data-name=sensors] .item').on('mouseover mouseout',function(event){
		var id = $(this).attr('data-id');
		var method = event.type=='mouseover'?'addClass':'removeClass';
		$('.element[data-type=sensors][data-id='+id+']')[method]('hover');
		$('.clipmap[data-type=sensors][data-id='+id+']')[method]('hover');
	});
	
	$('.list[data-name=facilities] .item').on('mouseover mouseout',function(event){
		var id = $(this).attr('data-id');
		var method = event.type=='mouseover'?'addClass':'removeClass';
		$('.element[data-type=facilities][data-id='+id+']')[method]('hover');
		$('.clipmap[data-type=facilities][data-id='+id+']')[method]('hover');
	});
	
	$('.list[data-name=groups] .item').on('mouseover mouseout',function(event){
		var id = $(this).attr('data-id');
		var method = event.type=='mouseover'?'addClass':'removeClass';
		for(k in Dashboard.hash.sensor_groups[id]) {
			$('.element[data-type=sensors][data-id='+k+']')[method]('hover');
			$('.clipmap[data-type=sensors][data-id='+k+']')[method]('hover');
		}
	});
	
	$('.clipmap[data-type=sensors]').on('mouseover mouseout',function(event){
		var id = $(this).attr('data-id');
		var method = event.type=='mouseover'?'addClass':'removeClass';
		$('.element[data-type=sensors][data-id='+id+']')[method]('hover');
		$('.list[data-name=sensors] .item[data-id='+id+']')[method]('hover');
	});
	
	$('.clipmap[data-type=facilities]').on('mouseover mouseout',function(event){
		var id = $(this).attr('data-id');
		var method = event.type=='mouseover'?'addClass':'removeClass';
		$('.list[data-name=facilities] .item[data-id='+id+']')[method]('hover');
		$('.element[data-type=facilities][data-id='+id+']')[method]('hover');
	});
	
};
Dashboard.switch_cb=function(cb,type){
	cb.toggleClass('A');	
	if (type=='filter') Pic.refresh_elements();
};
Dashboard.switch_title=function(title,callback){
	title.parent().toggleClass('A').next().toggle();
	if (callback) callback();
};

Dashboard.init_loader=function(){
	
	$('.loader:not(.ready)').addClass('ready').each(function(){
		
		var target = $(this);
		var loader = {
			wait: 		3000,
			tag : 		target,
			name: 		target.attr('data-name'),
			multi: 		lnrr.multi = target.attr('data-multi'),
			images: 	[],
			sensor_id:	target.attr('data-sid'),
			id: 		target.attr('data-id'),
			url: 		target.attr('data-url')
		}
		
		loader.tag.html($(lnrr.View('website/widgets/Im')));
		
		if (loader.id && (loader.name=='image_id' || loader.name=='dwg_id')) $('.loader_wrap .name',loader.tag).html('<a href="'+loader.url+'" target="_blank">текущий</a>');
		
		var upload_data = {
			url:			'/ajaj/upload/',
			ajaj: 1
		}
		
		$('.loader_wrap .status',loader.tag).html('');
	
		var inp = $('.loader_wrap input[name=file]',loader.tag);	
		inp.fileupload({
			url: '/ajaj/upload/',
			formData: { ajaj:1, name:loader.name, sensor_id:loader.sensor_id },
			dataType: 'json',
			add:function(e,data){
				var file = data.files[0];
				if (!file) 									{Popup.init({type:'error',title:'Ошибка загрузки',text:'Нет файла'});return;}			
				if (!file.name)								{Popup.init({type:'error',title:'Ошибка загрузки',text:'Безымянный файл'});return;}
				if (name=='image_id' &&
					!file.type.match(/jpg|jpeg|gif|png/)) 	{Popup.init({type:'error',title:'Ошибка загрузки',text:'Не допустимое расширение файла'});return;}
				data.submit();
			},
			done: function (e, data) {
				
				$('.status',loader.tag).html('Завершено');
				setTimeout(function(){ $('.status',loader.tag).html('load'); },loader.wait);
				
				if (loader.name=='xlsx') {
					$('.Popup .import_result').html(data.result.string);
					return;
				}
				
				if (loader.name=='image_id' || loader.name=='image_ids' || loader.name=='dwg_id') {
					var image = data.result.image;				
					if (!image.id) { $('.status',loader.tag).html('Ошибка'); return; }
					if (loader.multi) {
						loader.images.push(image.id);
						loader.tag.attr('data-id',loader.images.join(','));	
					} else {
						loader.tag.attr('data-id',image.id);
						loader.tag.attr('data-url',image.url);
					}
				}
			},
			error: function (e, data) {
				$('.status',loader.tag).html('error');
				setTimeout(function(){$('.status',loader.tag).html('load');},2500);
			},
			progressall: function (e, data) {
				var status = parseInt(data.loaded / data.total * 100, 10);//1..100%
				if (status>95) status = 95;
				$('.status',loader.tag).html(status+"%");
			},
		}).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
	});
}

Dashboard.switch_data = function(event){
	event.stopPropagation();
	var data = $('.right .data');
	var h = data.height();
	var mh = $('.right > .map').height();
	data.height(mh>h*2?mh/2:0);
}

Dashboard.gen_params_for_data = function(){
	var params = {facility_id:this.main_id};
	var date = $('.settings input.date').val();
	if (!date) date = date_to_bd(new Date());
	else date = date_to_bd(date_to_js(date));
	params.days = $('.settings input.days').val()||7;
	params.date_to = date;
	return params;
}

Dashboard.refresh_data = function(){
	var t = this;
	var params = t.gen_params_for_data();
	this.request('all_values',params,function(){t.render_data();});	
}

Dashboard.render_data = function(){
	
	if (!Dashboard.values.length) return;
	var table_data = Dashboard.prepare_data_for_table(true);
	
	lnrr.title = 'Показания по всем данным';
	
	var html = $(lnrr.View('website/dashboard/values'));
	var target = html.find('.table_place')[0];

	Dashboard.all_table = Dashboard.gen_table(target,table_data);
	$('.main .right .data .content .tabledata').html(html);
	
	Dashboard.all_table.render();
}

Dashboard.check_value = function(cell_data, value, tag){
	if (!Dashboard.all_table) return;
	var sensor = this.hash.sensors[cell_data.sensor_id];
	if (cell_data.date_use == sensor.reference_date_rev) {
		tag.addClass('ref');
		return;
	}
	if (value==undefined) return;
	var facility = this.hash.facilities[this.main_id];
	
	// done
	if (cell_data.allowed_value_type_id == 1) {
		var prev_value = parseFloat(Dashboard.all_table.getDataAtCell(cell_data.y,cell_data.x-1));
		if (!prev_value) tag.addClass('undef');
		else if (prev_value!=value) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.allowed_value_type_id == 2) {  //for PS
		var norma = this.hash.normatives[13];
		if (!norma) return;
		if (value>norma) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.allowed_value_type_id == 5 ||
		cell_data.allowed_value_type_id == 6 ||
		cell_data.allowed_value_type_id == 12) {
		var norma = this.hash.normatives[11];
		if (!norma) return;
		var ref_value = sensor.reference_value;
		if (!ref_value) tag.addClass('undef');
		if (value-ref_value>norma) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.braid_id) {
		var braids = Dashboard.braid_values[sensor.id];
		if (facility.base_principle_id==2){
			for (deep in braids) if (Dashboard.all_table.getDataAtCell(braids[deep],cell_data.x)<0){
				tag.addClass('warning');
				return;	
			}
		}
		var norma = this.hash.normatives[12];
		if (!norma) return;
		var Ts = 0;
		var counter = 0;
		var coords;
		
		var flag = 0;
		var foundation_depth = facility.foundation_depth || sensor.deep;
		var frozen_depth = facility.frozen_depth || 0;
		for (deep in braids) {
			if (deep<frozen_depth || deep>foundation_depth) continue;
			y = braids[deep];
			var temp = Dashboard.all_table.getDataAtCell(y,cell_data.x);
			Ts+=temp;
			counter++;
		}
		Ts/=counter;
		if(Ts>norma) tag.addClass('warning');
		return;	
	}
}
Dashboard.prepare_data_for_table = function(filter){
	
	var filters = Pic.gen_filters();
	var pairs = {};
	
	console.log(Dashboard.values);
	
	var values = Dashboard.values.map(function(el){
		el.sensor = Dashboard.hash.sensors[el.sensor_id];
		console.log(el);
		return el;
	}).filter(function(el){
		if (!filter) return true;
		console.log(el);
		return Pic.check(el.sensor,'sensors',filters);
	});
	
	if (!values.length) return null;
	
	// хеш шапок по моделям - чтобы перед каждой моделью вывелась шапочка с названием значений ^__^ (кроме ГДМ - она бяка >p)
	var hats = {};
	
	function repeat(n,func) { for (var l=0;l<n;l++) func(); } // повторяет функу н раз
	
	function add_item(v,el,j,y,item,arr) { 	// полученная искусственным путем функа добавляющая ячейку со все подноготной
		var n = MP/el.params_length;   //колво объединений
		var x = (has_braid?2:1)+n*j;   //x координата в таблице
		repeat(n,function(){ item.push(v); });
		merges.push({row: y, col: x, rowspan:1, colspan:n });
		Dashboard.table_values[y+'_'+x] = {
			y:						y,
			x:						x,
			sensor_id:				el.sensor.id,
			date_use:				arr[0][x],
			allowed_value_type_id:	el.type=='braid'?undefined:el.avts[j%el.params_length],
			braid_id:				el.type=='braid'?el.sensor.deeps[item[1]]:undefined,
			deep:					item[1]
		}
		if (el.type=='braid') {
			if (!Dashboard.braid_values[el.sensor.id]) Dashboard.braid_values[el.sensor.id] = {};
			Dashboard.braid_values[el.sensor.id][item[1]] = y;
		}
	}
	
	function add_head(type,arr,avts,amt_id) { 								// добавляет ряд с заголовками
		// TODO - уменьшить кол-во аргументов
		if (hats[amt_id] && amt_id!=4 && amt_id!=12) return;
		hats[amt_id] = 1;
		
		if (type=='inc') {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(Dashboard.hash.amt[amt_id].name) }); //первые два/одно пустое значение
			merges.push({row: arr.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			values[0].dates.forEach(function(){
				item.push(Dashboard.hash.avt[avts[0]].name);
				item.push(Dashboard.hash.avt[avts[1]].name);
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		} else {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(Dashboard.hash.amt[amt_id].name) });
			merges.push({row:arr.length,col:0,rowspan:1,colspan:has_braid?2:1});
			values[0].dates.forEach(function(el,l){
				var measurer = type=='braid'? 'Температура °C' :  Dashboard.hash.avt[avts[0]].name;
				repeat(MP,function(){ item.push(measurer); });
				merges.push({row: arr.length, col: (has_braid?2:1)+MP*l, rowspan:1, colspan:MP });
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		}
		arr.push(item);
	}
	
	var render_funcs = { '0':function(ins,td){$(td).addClass('th');} } //хеш функций кастомного рендинга по рядам
	
	Dashboard.table_values = {}; // хеш параметров ячейки по коориданатам - для дальнейшего быстрого обращения и сохранения ячеек
	Dashboard.braid_values = {}; // хеш координаты y ячеек кос для определения средних температур, braid_values -> sensor_id -> deep = y
	
	var has_braid;				 // есть ли в таблице косы				
	var MP = 1;					 // максимальное число параметров для одного датчика на одну дату
	var inc_flag = 0;			 // флаг того что шапка для инкринометричских датчиков уже есть
	var temp_flag = 0;			 // флаг того что шапка для НЕинкринометричских датчиков уже есть
	var braid_flag = 0;			 // флаг того что шапка для кос уже есть
	
	//определям has_braid
	values = values.map(function(el){
		if (el.params_length>MP) MP=el.params_length;
		if (el.type=='braid') has_braid = 1;
		return el;
	}) // сортируем по моделям
	.sort(function(a,b){
		var a_order = Dashboard.hash.amt[a.sensor.allowed_model_type_id].ordering;
		var b_order = Dashboard.hash.amt[b.sensor.allowed_model_type_id].ordering;
		if (a.sensor.id==b.sensor.id) {
			if (a.type>b.type) return -1;
			if (a.type<b.type) return 1;
		}
		return  a_order - b_order;
	});
		
	var merges = []; 		// масив объединений
	var rows = [[]];		// масив рядов с готовым пустым массивом дат/шапки
	
	repeat(has_braid?2:1,function(){ rows[0].push('ДАТЧИК') }); //первые два/одно пустое значение
	merges.push({row: 0, col: 0, rowspan:1, colspan:has_braid?2:1 });
	
	//берем даты из данных первогог датчика (там всегда есть массив дат и он одинаков для всех - да, говнокод)
	values[0].dates.forEach(function(el,i){
		repeat(MP,function(){ rows[0].push(el); });
		merges.push({row: 0, col: (has_braid?2:1)+MP*i, rowspan:1, colspan:MP });
	});
		
	// раскидываем значения по рядам
	// значения отсортированы по инклинометрическим и косам - поэтому шляпы добавляем только один раз
	for (var i=0;i<values.length;i++) {
		var el = values[i];
		
		if (el.type=='own') {
		
			if (el.params_length==1) add_head('temp',rows,el.avts,el.sensor.allowed_model_type_id); 
			if (el.params_length!=1) add_head('inc',rows,el.avts,el.sensor.allowed_model_type_id); 
			
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(el.sensor.name) }); //первые два/одно пустое значение
			merges.push({row: rows.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			
			var y = rows.length;//y координата в таблице
			
			el.values.forEach(function(v,j){ add_item(v,el,j,y,item,rows); });
			rows.push(item);
		}
		if (el.type=='braid') {
			
			add_head('braid',rows,el.avts,el.sensor.allowed_model_type_id);
			
			merges.push({row: rows.length, col: 0, rowspan:el.values.length, colspan:1 });
			el.values.forEach(function(arr,j){
				var item = [];
				item.push(el.sensor.name);
				item.push(arr[0]);
				var y = rows.length;
				arr.forEach(function(v,k){ if(k) add_item(v,el,k-1,y,item,rows); });			
				rows.push(item);
			});
		}
	}
	
	return {rows:rows,merges:merges,render_funcs:render_funcs};
}

Dashboard.gen_table = function(target,data){
	function repeat(n,func) { for (var l=0;l<n;l++) func(); }
	var cellProperties,cell_params;
	var table = new Handsontable(target, {
		data: data.rows,
		height:'auto',
		colHeaders: false,
		rowHeaders: false,
		stretchH: 'all',
		mergeCells:data.merges,
		className: "htRight",
		cells: function (row, col, prop) {
			cellProperties = {};
			if(data.render_funcs[row]) cellProperties.renderer = function(instance, td){
			    Handsontable.renderers.TextRenderer.apply(this, arguments);
				data.render_funcs[row](instance, td);
			};
			cell_params = Dashboard.table_values[row+'_'+col];
			if(cell_params) {				
				cellProperties.type = 'numeric';
				cellProperties.format = '0.0000'; // todo by accuracy
				
				var avt_id = cell_params.allowed_value_type_id;
				if (avt_id) {
					cellProperties.format = '0.'
					repeat(Dashboard.hash.avt[avt_id].accuracy,function(){ cellProperties.format+='0'; });
				}
				
				cellProperties.editor = 'text';
				cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties) {
					Handsontable.renderers.NumericRenderer.apply(this, arguments);
					Dashboard.check_value(cell_params,value,$(td));
				};
			} else cellProperties.editor = false;
			
			return cellProperties;
		},
		afterChange:Dashboard.save_data
	});
	return table;
}

Dashboard.save_data = function(cells){
	if (!cells||!cells.length) return;
	var arr = [];
	cells.forEach(function(c){
		var v = Dashboard.table_values[c[0]+'_'+c[1]];
		if (!v) return;
		var params = {
			sensor_id: 	v.sensor_id,
			braid_id:	v.braid_id,
			date_use:	v.date_use,
			value: c[3],
			allowed_value_type_id: v.allowed_value_type_id
		};
		console.log(params);
		arr.push(params);
	});
	Dashboard.values_to_save.push(JSON.stringify(arr));
	Dashboard.save_values();
}

Dashboard.save_values = function(){
	if (Dashboard.values_pending) return;
	Dashboard.values_pending = 1;
	var data = Dashboard.values_to_save.shift();
	Dashboard.log('Идет сохранение значений...');
	if (data) $.ajax({
		url:'/dashboard/',
		method:'POST',
		data:{data:data,mode:'save_values',ajaj:1},
		error:function(){			
			Dashboard.last_error = arguments[0];			
			Dashboard.values_pending=0;
			Dashboard.render_data();
			Popup.init({type:'error',title:'Ошибка сохранения',text:'Не удалось сохранить значение' + data});
			console.log('save_value detail-error:',$(JSON.parse(arguments[0].responseText).error.error)[0]);
		},
		success:function(){
			Dashboard.values_pending=0;
			Dashboard.save_values();
		}
	}); else {
		Dashboard.values_pending = 0;
		Dashboard.request('all_values',Dashboard.gen_params_for_data());
		Dashboard.log('Значения сохранены');
	}
}

Dashboard.export_sensor_values = function(id){
	var params = this.gen_params_for_data();
	var s = '/dashboard/?mode=export_values&id='+id;
	for (k in params) s+='&'+k+'='+params[k];
	window.location = s;
}

Dashboard.render_viewer_elements = function(){
	Pic.elements.forEach(function(el){ el.render_viewer(); });
}
Dashboard.uninit_viewer = function(){
	if (!Viewer.tag || !Viewer.target || !Viewer.target.uninitialize) return;
	Viewer.tag.hide();
	Viewer.target.uninitialize();
	delete Viewer.Z;
}



var	getToken = function() {
	var theUrl = "/api/autodesk/get_access_token/";
	var xmlHttp = null;
	xmlHttp = new XMLHttpRequest();
	xmlHttp.open("GET", theUrl, false);
	xmlHttp.send(null);
	return xmlHttp.responseText;
};
	

var Viewer = {

	loadDocument: function() {
		var select = $('select[name=viewlayers]');
		select.off('change').html('').val('');
		var t = this;
		//t.options.document = Dashboard.get_facility().urn;
		 t.options.document = 'urn:dXJuOmFkc2sub2JqZWN0czpvcy5vYmplY3Q6Z2RlcnBndG0vdGVzdF90b191cGxhb2QuZHhm'; // to test
		try {
			Autodesk.Viewing.Document.load(
				t.options.document,
				function(doc) {// onLoadCallback
					
					var geometryItems = [];
					geometryItems = Autodesk.Viewing.Document.getSubItemsWithProperties(doc.getRootItem(), {
						'type':'geometry',
						'role':'2d'
					}, true);				
										
					geometryItems.forEach(function(el,i){
						$('<option></option>').attr('value',i).html(el.name).appendTo(select);
					});
					
					select.on('change',function(){
						Dashboard.geometry_index = $(this).val();
						Dashboard.switch_views('viewer');
					});
					
					if (geometryItems.length > 0) {
						t.target.load(doc.getViewablePath(geometryItems[Dashboard.geometry_index||0]));
					}
					
					t.target.addEventListener(
						Autodesk.Viewing.CAMERA_CHANGE_EVENT,
						function(event) {
							if (!Viewer.Z) Viewer.set_Z();
							var pos = Pic.calc_coords({x:event.clientX,y:event.clientY});
							var coords = Viewer.calc_coords(pos);
							Pic.refresh_styles(coords.size*6/50);
							Dashboard.render_viewer_elements();
						}
					);				
				},
				function(errorCode,errorMsg) {// onErrorCallback
					Popup.init({ type:'error', title:'Ошибка', text:errorMsg+'<br>'+t.options.document });
					Dashboard.switch_views('map');
				}
			);
		} catch(e) {
			Popup.init({ type:'error', title:'Ошибка', text:'Не удается запустить просмотрщик <br>'+t.options.document });
			Dashboard.switch_views('map');
		}
	},
	
	set_Z: function(){
		this.Z = this.get_viewer_coords().z
		return;
	},
		
	get_viewer_coords: function(){
		if (!this.target || !this.target.getState) return;
		var arr = this.target.getState().viewport.eye;
		return {x:arr[0],y:arr[1],z:arr[2]};
	},
		
	calc_context_pos: function(e){
		var left = $('.main > .left').width();
		var top = $('.hat').height();
		this.context_coords = this.calc_coords({ x:e.clientX-left, y:e.clientY-top });
	},
	
	calc_coords: function(pos){
		
		if (!this.target || !this.target.getState) return;
				
		var facility = Dashboard.get_facility();
		var vcoords = this.get_viewer_coords();
					
		var vH = this.tag.height();
		var vW = this.tag.width();
		
		var rH = facility.height;
		var rW = facility.width;
		
		var ratio = vW/rW;
		var z = this.Z; // normal
		var size = z/vcoords.z;
		
		var ret = {
			x:   (pos.x - vW/2)/(ratio*size) + vcoords.x,
			y:  -(pos.y - vH/2)/(ratio*size) + vcoords.y,
			size: (ratio*size)
		}
		
		return ret;
	},
		
	calc_pos: function(coords,reverse){
		
		var facility = Dashboard.get_facility();
		var vcoords = this.get_viewer_coords();
		
		var vH = this.tag.height();
		var vW = this.tag.width();
		
		var rH = facility.height;
		var rW = facility.width;
		
		if (reverse) coords.y = rH - coords.y;
		
		var ratio = vW/rW;
		var z = this.Z; //normal
		var size = z/vcoords.z;
		
		var ret = {
			x:   (ratio*size)*(coords.x - vcoords.x) + vW/2,
			y:  -(ratio*size)*(coords.y - vcoords.y) + vH/2,
			size: (ratio*size)
		};
		
		return ret;
		
	},
	
	options: {
	   'env':'AutodeskProduction',
	   'getAccessToken': getToken,
	   'refreshToken': getToken,
	   'api_test_link': 'https://developer.autodesk.com/api/view-and-data-api/interactive/',
	   'bucket_name': 'gderpgtm'
	},
	
	
	show_coords: function(e){
		//var coords = this.calc_coords(e);
		//var pos = this.calc_pos(coords);
		//
		//$('#relx').html(coords.x.toFixed(2));
		//$('#rely').html(coords.y.toFixed(2));
		//$('#mapx').html(pos.x.toFixed(2));
		//$('#mapy').html(pos.y.toFixed(2));
	},
	
	
	
	
}

Dashboard.init_viewer = function(){
	
	var t = this;
	
	Viewer.tag = $(document.getElementById('viewer'));
	Viewer.tag.show();
	var facility = this.get_facility();
	var rF = facility.width/facility.height;
	var rV = Viewer.tag.width()/Viewer.tag.height();
	console.log('rF',rF,'rV',rV);
	if (rV>rF)  Viewer.tag.width(Viewer.tag.height()*rF)
	
	Viewer.target = new Autodesk.Viewing.Private.GuiViewer3D(Viewer.tag[0], {
		extensions: ['BasicExtension']
	});
	
	Autodesk.Viewing.Initializer(
		Viewer.options,
		function() {
			Viewer.target.initialize();
			Viewer.loadDocument();
		}
	);

	Viewer.tag.on('contextmenu',function(e){
		Context.show(e);
		e.stopPropagation();
		return false;
	});
	

}


/*
Dashboard = {

	//изначально вгруженная информация
	data: {
		facility:{},
		facilities:[],
		sensors:[],
		groups:[]
	};
	
	// информация
	main_id: {{facility.id}}, // id текущего объекта (нету - значит в корне)
	hash:{
		facilities:{}, //хеш всех подобъектов и объекта основного
		sensors: {}, //хеш всех элементов объекта
		groups:{} //хеш всех групп на объекте
	},
	
	// методы редактирования
	add_facility: function(){ // открывает попап с добавлением подобъектов
		//ничего не возвращает
	},
	save_facility: function(tag,id){ // сохраняет подобъект из настроек в блоке определнным из tag, если нету id - добавляет подобъект как дочерний текущему
		//ничего не возвращает
		//после refresh_facilities или refresh_facility если id==main_id
	}
	add_sensor: function(){ // открывает поап с добавлением сенсора
		//ничего не возвращает
	},
	save_sensor: function(id){ // сохраняет/добавляет сенсор
		//ничего не возвращает
		//после refresh_sensors
		//после show_sensor(id)
	}
	add_group: function(){ // открывает попап с добавлением группы
		//ничего не возвращает
	},
	save_group: function(id){ // сохраняет/добавляет группу
		//ничего не возвращает
		//после refresh_groups
	}
	
	// состояния отображения
	states: {
		facilities: { "10":{visible:1} ... },
		sensors: {"10":{visible:1} ... }
		groups: {"10":{visible:1} ... }
	},
	
	// методы влияющие на отображение
	switch_visible: function(type,id){ // меняет состояние отображения на карте
		// ничего не возвращает
	},
	
	filter: function(type,arr){ // фильтрует массив по типу выборки
		// возвращает массив
	},
	
	// методы панели управления
	init_pic: function(){ // инициализирует манипуляции с картинкой
		//ничего не возвращает
	},
	init_drag: function(){ // инициализирует манипуляции с тянущимися окнами
		//ничего не возвращает
	},
	init_checkboxes: function(tag){ // инициализирует нажатия на чекбоксы внутри tag
		//ничего не возвращает
	},
	init_loader: function(tag){ // инициализирует загруpчик картинок
		//ничего не возвращает
	}
	
	// методы отображения
	refresh_facilities: function(){ // обвноляет блок со списоком подобъектов
		//ничего не возвращает
	},
	refresh_facility: function(){ // обновляет блок с инфой о текущем подобъекте 
		//ничего не возвращает
	},
	refresh_sensors: function(){ // обвноляет блок со списоком сенсоров
		//ничего не возвращает
	},
	show_sensor: function(id){ // // выводит блок с сенсором
		//ничего не возвращает
	},
	refresh_groups: function(){ // обвноляет блок со списоком групп
		//ничего не возвращает
	},
	show_group: function(id){ // выводит блок с группой
		//ничего не возвращает
	},	
	refresh_map:function(){ //  перерисовывает все элементы на карте
		// ничего не возврщает
	}
		
	// дополнительные методы
	request: function(mode,data){ // делает ajaj запрос на сервер
		// по типу ответа понимает что надо сохранить и перерисовать 
		//ничего не возврщает
	},
	
	// дополнительные методы
	prepare: function(type){ // возвращает массив сущности type профильтрованную и отсортированную
		// по типу ответа понимает что надо сохранить и перерисовать 
		// возвращает arr
	}
	
	get_data: function(tag,data){ // дополняет data(или создает и наполняет) данными из интерфейса из tag
		// по типу ответа понимает что надо сохранить и перерисовать 
		// возвращает data
	}
};
*/






