var Funcs = {};

Funcs.check_sensor = function(sensor,filter){
	if (!filter.all_sensors && !filter.sensors[sensor.id]) return false;
	if (!filter.all_state_id && !filter.state_id[sensor.state_id]) return false;
	if (!filter.all_allowed_model_type_id && !filter.allowed_model_type_id[sensor.allowed_model_type_id]) return false;
	if (filter.is_retranslator && !sensor.is_retranslator) return false;
	return true;	
}

Funcs.prepare_data_for_table = function(data,hash,filters){
		
	var values = data;
	if (filters) values = values.filter(function(el){ return Funcs.check_sensor(el.sensor,filters); });	// фильтруем сенсоры
	if (!values.length) return null;
	
	console.log(values);
	
	var has_braid;				 // есть ли в таблице косы				
	var MP=1;					 // максимальное число параметров для одного датчика на одну дату
	var inc_flag;			 	// флаг того что шапка для инкринометричских датчиков уже есть
	var temp_flag;			 	// флаг того что шапка для НЕинкринометричских датчиков уже есть
	var braid_flag;			 	// флаг того что шапка для кос уже есть
	
	var table_values = {}; // хеш параметров ячейки по коориданатам - для дальнейшего быстрого обращения и сохранения ячеек
	var braid_values = {}; // хеш координаты y ячеек кос для определения средних температур, braid_values -> sensor_id -> deep = y
	
	var merges = []; 		// масив объединений
	var rows = [[]];		// масив рядов с готовым пустым массивом дат/шапки
	
	var render_funcs = { '0':function(ins,td){$(td).addClass('th');} } //хеш функций кастомного рендинга по рядам
	
	// хеш шапок по моделям - чтобы перед каждой моделью вывелась шапочка с названием значений ^__^ (кроме ГДМ - она бяка >p)
	var hats = {};
	
	function repeat(n,func) { for (var l=0;l<n;l++) func(); } // повторяет функу н раз
	
	function add_item(v,el,j,y,item,arr) { 	// полученная искусственным путем функа добавляющая ячейку со все подноготной
		var n = MP/el.params_length;   //колво объединений
		var x = (has_braid?2:1)+n*j;   //x координата в таблице
		repeat(n,function(){ item.push(v); });
		merges.push({row: y, col: x, rowspan:1, colspan:n });
		table_values[y+'_'+x] = {
			y:						y,
			x:						x,
			sensor_id:				el.sensor.id,
			date_use:				arr[0][x],
			allowed_value_type_id:	el.type=='braid'?undefined:el.avts[j%el.params_length],
			braid_id:				el.type=='braid'?el.sensor.deeps[item[1]]:undefined,
			deep:					item[1]
		}
		if (el.type=='braid') {
			if (!braid_values[el.sensor.id]) braid_values[el.sensor.id] = {};
			braid_values[el.sensor.id][item[1]] = y;
		}
	}
	
	function add_head(type,arr,avts,amt_id) { 								// добавляет ряд с заголовками
		// TODO - уменьшить кол-во аргументов
		if (hats[amt_id] && amt_id!=4 && amt_id!=12) return;
		hats[amt_id] = 1;
		
		if (type=='inc') {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(hash.amt[amt_id].name) }); //первые два/одно пустое значение
			merges.push({row: arr.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			values[0].dates.forEach(function(){
				item.push(hash.avt[avts[0]].name);
				item.push(hash.avt[avts[1]].name);
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		} else {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(hash.amt[amt_id].name) });
			merges.push({row:arr.length,col:0,rowspan:1,colspan:has_braid?2:1});
			values[0].dates.forEach(function(el,l){
				var measurer = type=='braid'? 'Температура °C' :  hash.avt[avts[0]].name;
				repeat(MP,function(){ item.push(measurer); });
				merges.push({row: arr.length, col: (has_braid?2:1)+MP*l, rowspan:1, colspan:MP });
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		}
		arr.push(item);
	}
	
	//определям has_braid
	values = values.map(function(el){
		if (el.params_length>MP) MP=el.params_length;
		if (el.type=='braid') has_braid = 1;
		return el;
	}) // сортируем по моделям
	.sort(function(a,b){
		var a_order = hash.amt[a.sensor.allowed_model_type_id].ordering;
		var b_order = hash.amt[b.sensor.allowed_model_type_id].ordering;
		if (a.sensor.id==b.sensor.id) {
			if (a.type>b.type) return -1;
			if (a.type<b.type) return 1;
		}
		return  a_order - b_order;
	});
	
	repeat(has_braid?2:1,function(){ rows[0].push('ДАТЧИК') }); //первые два/одно пустое значение
	merges.push({ row:0, col:0, rowspan:1, colspan:(has_braid?2:1) });
	
	//берем даты из данных первогог датчика (там всегда есть массив дат и он одинаков для всех - да, говнокод)
	values[0].dates.forEach(function(el,i){
		repeat(MP,function(){ rows[0].push(el); });
		merges.push({row: 0, col: (has_braid?2:1)+MP*i, rowspan:1, colspan:MP });
	});
		
	// раскидываем значения по рядам
	// значения отсортированы по инклинометрическим и косам - поэтому шляпы добавляем только один раз
	for (var i=0;i<values.length;i++) {
		var el = values[i];
		
		if (el.type=='own') {
		
			if (el.params_length==1) add_head('temp',rows,el.avts,el.sensor.allowed_model_type_id); 
			if (el.params_length!=1) add_head('inc',rows,el.avts,el.sensor.allowed_model_type_id); 
			
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(el.sensor.name) }); //первые два/одно пустое значение
			merges.push({row: rows.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			
			var y = rows.length;//y координата в таблице
			
			el.values.forEach(function(v,j){ add_item(v,el,j,y,item,rows); });
			rows.push(item);
		}
		if (el.type=='braid') {
			
			add_head('braid',rows,el.avts,el.sensor.allowed_model_type_id);
			
			merges.push({row: rows.length, col: 0, rowspan:el.values.length, colspan:1 });
			el.values.forEach(function(arr,j){
				var item = [];
				item.push(el.sensor.name);
				item.push(arr[0]);
				var y = rows.length;
				arr.forEach(function(v,k){ if(k) add_item(v,el,k-1,y,item,rows); });			
				rows.push(item);
			});
		}
	}
	
	return { rows:rows, merges:merges, render_funcs:render_funcs, table_values:table_values, braid_values:braid_values };
}

Funcs.create_table = function(target,data,afterChange){
	var cellProperties, cell_params;
	var table = new Handsontable(target, {
		data: 		data.rows,
		height:		'auto',
		colHeaders: false,
		rowHeaders: false,
		stretchH: 	'all',
		mergeCells:	data.merges,
		className: "htRight",
		readOnly: true,
		cells: function (row, col, prop) {
			cellProperties = {};
			if(data.render_funcs && data.render_funcs[row]) cellProperties.renderer = function(instance, td){
			    Handsontable.renderers.TextRenderer.apply(this, arguments);
				data.render_funcs[row](instance, td);
			};
			cell_params = data.table_values && data.table_values[row+'_'+col];
			if(cell_params) {				
				cellProperties.type = 'numeric';
				cellProperties.format = '0.0000'; // todo by accuracy
				cellProperties.editor = 'text';
				cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties) {
					Handsontable.renderers.NumericRenderer.apply(this, arguments);
//					Funcs.check_value(cell_params,value,$(td));
				};
			} else cellProperties.editor = false;
			
			return cellProperties;
		},
		afterChange: afterChange
	});
	return table;
}



