function pad(n){return n<10?'0'+n:n;}
function date_to_bd(date){ return date.getFullYear()+'-'+pad(date.getMonth()+1)+'-'+pad(date.getDate()); }
function date_to_js(date){ var arr = date.match(/(\d+).(\d+).(\d+)/);return new Date(arr[3],arr[2]-1,arr[1]); }

Array.prototype.some_eq = function(v){ return this.some(function(el){ return el==v; }) }
Array.prototype.reduce_by = function(k,v){ return this.reduce(function(h,el){ h[el[k]]= v ? {} : el; return h; },{}); }

var Popup = function(type,data){
	Popup.close();
	
	lnrr.popup = data || {};
	lnrr.popup.type = type;
	lnrr.popup.content = GTM.view(type);
	
	Popup.html = $(GTM.view('popup'));
	Popup.open();
	Popup.render();
}

Popup.open = function(){
	$('body').append(Popup.html);
	$('input,textarea',Popup.html).eq(0).focus();
	$('.to_focus').show().focus().hide();
}

Popup.render = function(){
	var w = Popup.html.find('#window');
	w.css({
		'margin-left':	-w.width()/2,
		'margin-top':	-w.height()/2,
	});
}

Popup.close = function(){
	if (Popup.html) Popup.html.remove();
}

var Context = {
	id:'context',
	init:function(){
		$('#'+this.cssclass).remove();
		this.target = $(lnrr.View('website/widgets/context'));
		$('body').append(this.target.attr('id',this.id));
		this.hide();
		this.init_action();
		return this;
	},
	init_action:function(){
		$('.item:not(.section)',this.target).on('click',function(e){
			e.stopPropagation();
		});	
	},
	hide:function(){
		if (this.target) this.target.hide();
	},
	show:function(e){
		this.target.show().css({
			'top':e.clientY+'px',
			'left':e.clientX+'px'
		});
	}
};

var Element = function(item,type){
	this.item = item;
	this.html = $(GTM.view('element',null,{ item:item, type:type })).hide();
	if (this.item.clipmap) {
		this.layout = $(GTM.view('layout',null,{ item:item, type:type }));
	}
	GTM.block('elements').append(this.html);
	GTM.block('layouts').append(this.layout);
}

Element.prototype.init_actions = function(){
	var t = this;
	this.html.on('click',function(){
		if(t.type=='facility') GTM.choose_facility(t.item.id);
		if(t.type=='sensors') GTM.show_senosr(t.item.id);
	});
}

Element.prototype.render = function(type,pos){
	this['render_'+type](pos);
}

Element.prototype.render_map = function(pos){
	this.render_layout(pos);
	this.html.css({
		top:  (this.item.location_y + pos.y)*pos.size/1000 + 'px',
		left: (this.item.location_x + pos.x)*pos.size/1000 + 'px',
	});
}


Element.prototype.render_layout = function(pos){
	if (!this.item.clipmap) return;
	
	var clipmap = this.item.clipmap;
	var arr = clipmap.split(';');
	
	if (!arr || arr.length<3) return;
	
	var H = GTM.block('map').height();
	var W = GTM.block('map').width();
	
	var s = [];

	arr.forEach(function(coords){
		if (!coords) return;
		coords = coords.split(',').reduce(function(h,el,i){
			h[!i?'x':'y'] = parseFloat(el);
			return h;
		},{});
		
		var y = (coords.y + pos.y)*pos.size/1000;
		var x = (coords.x + pos.x)*pos.size/1000;
		
		var yproc = (100*(y/H)).toFixed(2);
		var xproc = (100*(x/W)).toFixed(2);
		
		s.push([xproc,yproc].map(function(el){return el+'%';}).join(' ') );
	});
	
	var polygon = s.join(',');
	
	this.layout.css({
		'-webkit-clip-path': 'polygon('+polygon+')'
	});
	
}

// STRUCTURE

var GTM = {
	
	tree:[],
	
	hash:{ facilities:{}, sensors:{}, groups:{}, sensor_groups:{} },
	
	tabs:[],
	blocks:{},
	states:{},
	
	click:{},
	
	values_to_save:[],
	
	popup: Popup
}

// MAIN
//data
GTM.get = function(code,id){
	if (!this.hash[code]) this.hash[code] = {};//
	return id ? this.hash[code][id] : this.hash[code];
}
GTM.LS = {
	get:function(item_name){
		if (!localStorage) return undefined;
		try {
			return JSON.parse(localStorage.getItem(item_name));
		} catch(e) {
			return localStorage.getItem(item_name);
		}
	},
	set:function(item_name,data){
		if (!localStorage) return;
		localStorage.setItem(item_name,JSON.stringify(data));
	},
}
GTM.fill_hash = function(code,data){
	var h = this.get(code);
	for (k in data) h[k] = data[k];
}
//view
GTM.view = function(code,folder,data){
	if (data) for (k in data) lnrr[k] = data[k];
	return lnrr.View('website/' + (folder || 'gtm') + '/'+ code);
}
GTM.block = function(name){
	if (!this.blocks[name]) this.blocks[name] = $('#'+name);
	return this.blocks[name];
}
GTM.refresh_block = function(block){
	this.block(block).html(this.view(block));
	this.refresh_block_state(block,this.main_id);
}
GTM.save_state = function(f_id){
	if (!f_id) return;
	var t = this;
	if(!this.states[f_id]) this.states[f_id] = {};
	
	['left'].forEach(function(block){
		var still = [];
		t.block(block).find('[still]').each(function(){
			still.push({
				hide: $(this).css('display') == 'none',
				css: this.className
			});
		});	
		t.states[f_id][block] = still;	
	});
	
	this.states[f_id]['map'] = this.resizator('get_state');
	this.states.tabs = this.tabs;
	this.states.main_id = this.main_id;
	
	this.LS.set('states',this.states);
}
GTM.load_state = function(){
	var t = this;
	var states = this.LS.get('states') || {};
	this.states = states;
	(states.tabs || []).forEach(function(id){ t.add_tab(id); });
	this.choose_facility(this.states.main_id);
}
GTM.refresh_block_state = function(block,f_id){
	var still = f_id && this.states[f_id] && this.states[f_id][block];
	if (!still || !still.length) return;
	this.block(block).find('[still]').each(function(i){
		var tag = $(this);
		var s = still[i];
		tag[s.hide?'hide':'show']();
		tag.addClass(s.css);
	});
}
GTM.get_params = function(tag){	
	var params = {};
	tag
	.closest('.params')
	.find('input,select')
	.each(function(){
		var block = $(this);
		params[block.attr('name')] = block.val();
	});
	return params;
}
GTM.refresh_styles = function(size){
	lnrr.size = size;
	this.refresh_block('styles');
}
GTM.gen_filters = function(){
	var t = this;
	var filters = {};
	$('[data-f]').each(function(){
		var name = $(this).attr('data-f');
		filters[name] = { all:true };
		$(this).find('[type=checkbox][name=filters]').each(function(){
			var id = $(this).attr('data-id');
			filters[name][id] = $(this).prop("checked");
			if (filters[name][id]) filters[name].all = false;
		});
	});
	var groups = {};
	if(!filters.groups.all) {
		for (gid in filters.groups) {
			if (!filters.groups[gid]) continue;
			var sensors = this.get('group_sensors',gid);
			for (sid in sensors) { groups[sid] = 1; }
		}
		filters.groups = groups;
	}
	return filters;
}
GTM.refresh_filters = function(){
	this.refresh_elements();
	
}

/// START

GTM.init = function(data){
	this.init_data(data);
	this.init_dicts();
	this.init_map();
	this.init_viewer();
	this.init_panel_actions();
	this.context = Context.init();
	this.load_state();
}

GTM.init_dicts = function(data){
	var t = this;
	for (d in lnrr.dictionaries) {
		t.fill_hash(d,lnrr.dictionaries[d].reduce_by('id'));
	}
}

GTM.init_data = function(data){
	var t = this;
	console.log(data);
	if (data.facility) {
		
		if (!this.states[data.facility.id]) this.states[data.facility.id] = {};
		
		this.hash.facilities[data.facility.id] = data.facility;
		
		this.fill_hash('sensors',data.facility.sensors.reduce_by('id'));
		this.fill_hash('groups',data.facility.groups.reduce_by('id'));
		this.fill_hash('normatives',data.facility.normatives.reduce_by('id'));
		
		this.fill_hash('sensor_groups',data.facility.sensors_groups.reduce_by('sensor_id',1));
		this.fill_hash('group_sensors',data.facility.sensors_groups.reduce_by('group_id',1));
		
		data.facility.sensors_groups.forEach(function(el){
			t.get('sensor_groups',el.sensor_id)[el.group_id] = 1;
			t.get('group_sensors',el.group_id)[el.sensor_id] = 1;	
		});
		
	}
	if (data.tree){
		this.tree = data.tree;
		this.hash.tree = data.tree.reduce_by('id');
	}
}

GTM.gen_params_for_data = function(){
	var params = {facility_id:this.main_id};
	var date = this.block('date_to').val();
	if (!date) date = date_to_bd(new Date());
	else date = date_to_bd(date_to_js(date));
	params.days = this.block('days').val()||7;
	params.date_to = date;
	return params;
}

GTM.refresh_values = function(){
	if (!this.main_id) return;
	var t = this;
	var data = this.gen_params_for_data();
	this.request('all_values',data,function(data){ t.render_values(data); });	
}

GTM.render_values = function(data){
	var table_data = this.prepare_values(data);
	if (!table_data) {
		this.block('table').html('');
		this.table = undefined;
		return;
	}
	this.table =  this.render_table(table_data);
	this.table.render();
}

GTM.init_map = function(data){
	var t = this;
	this.block('pic').resizator({
		after_init:		null,
		after_render:	function(pos){ t.map_move(pos); },
		cover:			1,
	});
	this.resizator = this.block('pic').resizator;
}

GTM.init_viewer = function(plan,index,cb,need_screenshot){
	
	var t = this;
	var tag = this.block('viewer');	
	
	var	getToken = function() {
		var xmlHttp = new XMLHttpRequest();
		xmlHttp.open("GET", "/api/autodesk/get_access_token/",false);
		xmlHttp.send(null);
		return xmlHttp.responseText;
	};
	
	this.viewer = {
		
		options: {
			'env':'AutodeskProduction',
			'getAccessToken': getToken,
			'refreshToken': getToken,
		},
		
		tag: tag,
		
		refresh: function(plan,index,callback) {
			
			var t = this;
			
			this.set_plan(plan,index);
			
			this.target = new Autodesk.Viewing.Private.GuiViewer3D(this.tag[0], {
				extensions: ['BasicExtension']
			});
			
			if (need_screenshot) this.target.loadExtension('Autodesk.ADN.Viewing.Extension.ScreenShotManager',{ createControls:true });
			
			this.target.initialize();
			
			if (!this.plan) return;
			
			this.load(callback);
		},
		
		set_plan: function(plan,index){
			this.plan = plan;
			this.index = index || 0;
		},
		
		load: function(callback,error){
			
			var t = this;
			
			Autodesk.Viewing.Document.load(
				t.plan,
				function(doc) {
					
					if (!t.geometryItems) t.geometryItems = Autodesk.Viewing.Document.getSubItemsWithProperties(doc.getRootItem(), {
						'type':'geometry',
						'role':'2d'
					}, true);
					
					t.target.load(doc.getViewablePath(t.geometryItems[t.index || 0]));
					
					t.target.addEventListener(
						Autodesk.Viewing.CAMERA_CHANGE_EVENT,
						function(event) {
							GTM.last_camera = {
								H:	event.camera.clientHeight,
								W:	event.camera.clientWidth,
								x:	event.camera.position.x,
								y:	event.camera.position.y,
								z:	event.camera.position.z
							}
						}
					);
					
					if (callback) callback(t);
				},
				function(errorCode,errorMsg) {
					GTM.log(errorMsg);
					if (error) error(errorCode,errorMsg);
				}
			);
		},
		
		get_image: function(w,h,callback){
			this.target.getScreenShot(w, h, function(blobUrl) {
				if (callback) callback(blobUrl);
			});
		}
	}
	
	Autodesk.Viewing.Initializer(
		this.viewer.options,
		function() { t.viewer.refresh(plan,index,cb); }
	);

	this.viewer.tag.on('contextmenu',function(e){
		Context.show(e);
		e.stopPropagation();
		return false;
	});
}

GTM.select_facility = function(){
	this.switch_panel(1);
	this.main_id = undefined;
	lnrr.facilities = this.tree;
	this.refresh_facility();
}

GTM.add_tab = function(facility_id){	
	if(!this.tabs.some_eq(facility_id)) this.tabs.push(facility_id);
	this.refresh_tabs();
}

GTM.switch_tab = function(facility_id){	
	this.block('tabs').find('.tab').removeClass('A');
	this.block('tabs').find('.tab[data-id='+facility_id+']').addClass('A');
}

GTM.choose_facility = function(facility_id){
	if (!facility_id) {
		this.save_state(this.main_id);
		this.select_facility();
		this.switch_tab();
		return;
	}
	var facility = this.get('facilities',facility_id);
	if (facility) {		
		this.add_tab(facility.id);
		this.switch_tab(facility.id);
		
		this.save_state(this.main_id);		
		this.main_id = facility.id;		
		this.refresh_facility();
		
		this.refresh_screen();
		this.refresh_values();
	} else {
		this.request('init_facility',{ id:facility_id });
	}
}

GTM.refresh_facility = function(){
	var facility = this.get('facilities',this.main_id);
	lnrr.facility = facility;
	this.refresh_block('left');
}

GTM.refresh_screen = function(){
	this.refresh_map();
	this.refresh_viewer();
}

GTM.refresh_map = function(){
	var facility = this.get('facilities',this.main_id);
	
	this.block('elements').html('');
	this.block('layouts').html('');
	
	facility.facilities.forEach(function(el){
		el.element = new Element(el,'facility');
	});
	
	facility.sensors.forEach(function(el){
		el.element = new Element(el,'sensor');
	});
	
	var state = this.states[this.main_id]['map'];
	this.resizator('init_new',this.get('facilities',this.main_id).image_url,0,state);
	this.refresh_elements();
}


GTM.check = function(type,filters,el){
	if (!filters[type].all && !filters[type][el.id]) return false;
	if (type=='sensors') {
		var model_id = GTM.get('AllowedModelType',el.allowed_model_type_id).sensor_model_id;
		if (filters.ret.ret && !el.is_retranslator) return false;
		if (!filters.states.all && !filters.states[el.state_id]) return false;
		if (!filters.models.all && !filters.states[model_id]) return false;
		if (!filters.groups.all && !filters.groups[el.id]) return false;
	}
	return true;
}

GTM.refresh_elements = function(){
	var t = this;
	var facility = this.get('facilities',this.main_id);
	var filters = this.gen_filters();
	['sensors','facilities'].forEach(function(k){
		facility[k].forEach(function(el){
			el.element.html[t.check(k,filters,el) ? 'show' : 'hide']();
		});
	});
}

GTM.map_move = function(pos){
	var t = this;
	if (!this.main_id) return;
	var facility = this.get('facilities',this.main_id);
	['sensors','facilities'].forEach(function(k){
		facility[k].forEach(function(el){
			el.element.render('map',pos);
		});
	});
	this.refresh_styles(pos.size/1000);
}

GTM.refresh_viewer = function(){
	
}

// SAVES
GTM.save_facility = function(tag){
	var params = this.get_params(tag);
	params.id = this.main_id;
	this.request('save_facility',params);
}



// new Facility

GTM.new_facility = function(step,data){
	this.popup('facility_s'+step, data);
}


GTM.new_facility_next = function(tag,step){
	var data = this.get_params(tag);
	if (step==1 && !data.name) {
		return;
	}
	this.new_facility(step+1,data);
}

/// DASHBOARD

GTM.init_panel_actions = function(){
	
	var t = this;
	
	this.block('values_hat').on('mousedown touchstart',function(e){
		var h = t.get_mouse_pos(e);
			h.h = t.block('values').height();
		t.click['values_hat'] = h;
	});
	
	this.block('view_arrow').on('mousedown touchstart',function(e){
		var h = t.get_mouse_pos(e);
			h.mw = t.block('map').width();
			h.W = t.block('screen').width();
			console.log(h);
		t.click['view_arrow'] = h;
	});
	
	$('body').on('mouseup touchend',function(e){
		for(k in t.click) delete t.click[k];
		t.resizator('refresh');
	});
	
	$('body').on('click',function(e){
		t.context.hide();
	});
		
	$('body').on('mousemove touchmove',function(e){
		t.lastcoords = t.get_mouse_pos(e);
		t.resize_values_hat();
		t.resize_screen();
	});
	
	this.block('screen').on('contextmenu',function(e){
		Context.show(e);
		e.stopPropagation();
		return false;
	});
	
	this.block('values_hat').on('contextmenu',function(e){ e.stopPropagation(); });
	this.block('values').on('contextmenu',function(e){ e.stopPropagation(); });
}

GTM.resize_values_hat = function(e){
	var vh_click = this.click['values_hat'];
	if (!vh_click) return;
	var new_h = vh_click.h - this.get_pos_odds(vh_click).y;
	this.block('values').height(new_h);
}

GTM.resize_screen = function(e){
	var va_click = this.click['view_arrow'];
	if (!va_click) return;
	var new_w = va_click.mw + this.get_pos_odds(va_click).x;
	this.block('map').width(new_w);
	this.block('viewer').width(va_click.W - new_w - 1);
}


GTM.refresh_tabs = function(){
	var t = this;;
	lnrr.tabs = this.tabs.map(function(el){ return t.get('tree',el); });
	lnrr.main_id = this.main_id;
	this.refresh_block('tabs');
}

GTM.get_mouse_pos = function(e){
	e = e || event;
	var touch = (e && e.touches && e.touches[0]) || {};
	return {
		x: e.clientX || touch.pageX || 0,
		y: e.clientY || touch.pageY || 0
	};
}

GTM.get_pos_odds = function(old_pos){
	var new_pos = this.lastcoords;
	var pos = {};
	for(k in new_pos) pos[k] = new_pos[k] - old_pos[k];
	return pos;
}

GTM.toggle_panel = function(){
	this.block('main').toggleClass('hidepanel');
}

GTM.switch_panel = function(v){
	this.block('main')[!v?'addClass':'removeClass']('hidepanel');
}

GTM.switch_acc = function(tag){	
	tag.toggleClass('A');
	var v = tag.hasClass('A');
	tag.next()[!v?'hide':'show']();
}


// EVENTS 
GTM.log = function(text,clear_time){
	console.log('LOG - > ',text);
	clearTimeout(this.log_tid);
	this.block('log').html(text);
	if (clear_time) this.log_tid = seTimeout(function(){
		t.block('log').html(text);	
	},clear_time);
}

GTM.set_loader = function(v){
	this.block('log')[v?'addClass':'removeClass']('A');
}


// REQUEST

GTM.request = function(mode,data,success){
	
	var t = this;
	
	data = data || {};
	data.ajaj = 1;
	data.mode = mode;
	
	var callback = {
		'init_facility': function(data){
			t.init_data(data);
			t.choose_facility(data.facility.id);
		},
		'save_facility': function(data){
			t.init_data(data);
			t.choose_facility(data.facility.id);
		},
	}[mode] || function(){ console.log('no handler for mode ',mode); }
	
	t.set_pending(1);
	
	$.ajax({
		url:'/GTM/',
		method:'POST',
		data: data,
		dataType:'json',
		success:function(r){
			console.log('REQUEST -> ',r,mode,data);
			t.set_pending(0);
			
			if (r && r.error ) {
			//	Popup.init({ type:'error', title:'Ошибка', text:r.error });
				t.choose_facility(t.main_id);
				return;
			}
			
			callback(r);
			if (success) success(r);
		},
		error:function(r){
			console.log('ERROR -> ',r,mode,data);
			t.set_pending(0);
			t.log('Запрос прошел неудачно');
		},
	});
}

GTM.set_pending = function(v){
	this.log(v?'Загрузка началась':'Загрузка завершена');
	this.set_loader(v);
}


//VALUES
GTM.prepare_values = function(data){
	var t = this;
	var values = data;
	var filters  = this.gen_filters();
	values = values.filter(function(el){
		el.sensor = t.get('sensors',el.sensor_id);
		return t.check('sensors',filters,el.sensor);
	});	// фильтруем сенсоры
	
	if (!values.length) return null;
	
	var has_braid;				 // есть ли в таблице косы				
	var MP=1;					 // максимальное число параметров для одного датчика на одну дату
	var inc_flag;			 	// флаг того что шапка для инкринометричских датчиков уже есть
	var temp_flag;			 	// флаг того что шапка для НЕинкринометричских датчиков уже есть
	var braid_flag;			 	// флаг того что шапка для кос уже есть
	
	var table_values = {}; // хеш параметров ячейки по коориданатам - для дальнейшего быстрого обращения и сохранения ячеек
	var braid_values = {}; // хеш координаты y ячеек кос для определения средних температур, braid_values -> sensor_id -> deep = y
	
	var merges = []; 		// масив объединений
	var rows = [[]];		// масив рядов с готовым пустым массивом дат/шапки
	
	var render_funcs = { '0':function(ins,td){$(td).addClass('th');} } //хеш функций кастомного рендинга по рядам
	
	// хеш шапок по моделям - чтобы перед каждой моделью вывелась шапочка с названием значений ^__^ (кроме ГДМ - она бяка >p)
	var hats = {};
	
	function repeat(n,func) { for (var l=0;l<n;l++) func(); } // повторяет функу н раз
	
	function add_item(v,el,j,y,item,arr) { 	// полученная искусственным путем функа добавляющая ячейку со все подноготной
		var n = MP/el.params_length;   //колво объединений
		var x = (has_braid?2:1)+n*j;   //x координата в таблице
		repeat(n,function(){ item.push(v); });
		merges.push({row: y, col: x, rowspan:1, colspan:n });
		table_values[y+'_'+x] = {
			y:						y,
			x:						x,
			sensor_id:				el.sensor.id,
			date_use:				arr[0][x],
			allowed_value_type_id:	el.type=='braid'?undefined:el.avts[j%el.params_length],
			braid_id:				el.type=='braid'?el.sensor.deeps[item[1]]:undefined,
			deep:					item[1]
		}
		if (el.type=='braid') {
			if (!braid_values[el.sensor.id]) braid_values[el.sensor.id] = {};
			braid_values[el.sensor.id][item[1]] = y;
		}
	}
	
	function add_head(type,arr,avts,amt_id) { 								// добавляет ряд с заголовками
		// TODO - уменьшить кол-во аргументов
		if (hats[amt_id] && amt_id!=4 && amt_id!=12) return;
		hats[amt_id] = 1;
		
		if (type=='inc') {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(t.get('AllowedModelType',amt_id).name) }); //первые два/одно пустое значение
			merges.push({row: arr.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			values[0].dates.forEach(function(){
				item.push(t.get('AllowedValueType',avts[0]).name);
				item.push(t.get('AllowedValueType',avts[1]).name);
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		} else {
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(t.get('AllowedModelType',amt_id).name) });
			merges.push({row:arr.length,col:0,rowspan:1,colspan:has_braid?2:1});
			values[0].dates.forEach(function(el,l){
				var measurer = type=='braid'? 'Температура °C' :  t.get('AllowedValueType',avts[0]).name;
				repeat(MP,function(){ item.push(measurer); });
				merges.push({row: arr.length, col: (has_braid?2:1)+MP*l, rowspan:1, colspan:MP });
			});
			render_funcs[arr.length] = function(ins,td){$(td).addClass('custheader');}
		}
		arr.push(item);
	}
	
	//определям has_braid
	values = values.map(function(el){
		if (el.params_length>MP) MP=el.params_length;
		if (el.type=='braid') has_braid = 1;
		return el;
	}) // сортируем по моделям
	.sort(function(a,b){
		var a_order = t.get('AllowedModelType',a.sensor.allowed_model_type_id).ordering;
		var b_order = t.get('AllowedModelType',b.sensor.allowed_model_type_id).ordering;
		if (a.sensor.id==b.sensor.id) {
			if (a.type>b.type) return -1;
			if (a.type<b.type) return 1;
		}
		return  a_order - b_order;
	});
	
	repeat(has_braid?2:1,function(){ rows[0].push('ДАТЧИК') }); //первые два/одно пустое значение
	merges.push({ row:0, col:0, rowspan:1, colspan:(has_braid?2:1) });
	
	//берем даты из данных первогог датчика (там всегда есть массив дат и он одинаков для всех - да, говнокод)
	values[0].dates.forEach(function(el,i){
		repeat(MP,function(){ rows[0].push(el); });
		merges.push({row: 0, col: (has_braid?2:1)+MP*i, rowspan:1, colspan:MP });
	});
		
	// раскидываем значения по рядам
	// значения отсортированы по инклинометрическим и косам - поэтому шляпы добавляем только один раз
	for (var i=0;i<values.length;i++) {
		var el = values[i];
		
		if (el.type=='own') {
		
			if (el.params_length==1) add_head('temp',rows,el.avts,el.sensor.allowed_model_type_id); 
			if (el.params_length!=1) add_head('inc',rows,el.avts,el.sensor.allowed_model_type_id); 
			
			var item = [];
			repeat(has_braid?2:1,function(){ item.push(el.sensor.name) }); //первые два/одно пустое значение
			merges.push({row: rows.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
			
			var y = rows.length;//y координата в таблице
			
			el.values.forEach(function(v,j){ add_item(v,el,j,y,item,rows); });
			rows.push(item);
		}
		if (el.type=='braid') {
			
			add_head('braid',rows,el.avts,el.sensor.allowed_model_type_id);
			
			merges.push({row: rows.length, col: 0, rowspan:el.values.length, colspan:1 });
			el.values.forEach(function(arr,j){
				var item = [];
				item.push(el.sensor.name);
				item.push(arr[0]);
				var y = rows.length;
				arr.forEach(function(v,k){ if(k) add_item(v,el,k-1,y,item,rows); });			
				rows.push(item);
			});
		}
	}
	
	return { rows:rows, merges:merges, render_funcs:render_funcs, table_values:table_values, braid_values:braid_values };
}

GTM.render_table = function(table_data){	
	var cellProperties, cell_params;
	var table = new Handsontable(this.block('table')[0], {
		data: 		table_data.rows,
		height:		'auto',
		colHeaders: false,
		rowHeaders: false,
		stretchH: 	'all',
		mergeCells:	table_data.merges,
		className: "htRight",
//		readOnly: true,
		cells: function (row, col, prop) {
			cellProperties = {};
			if(table_data.render_funcs && table_data.render_funcs[row]) cellProperties.renderer = function(instance, td){
			    Handsontable.renderers.TextRenderer.apply(this, arguments);
				table_data.render_funcs[row](instance, td);
			};
			cell_params = table_data.table_values && table_data.table_values[row+'_'+col];
			if(cell_params) {				
				cellProperties.type = 'numeric';
				cellProperties.format = '0.0000'; // todo by accuracy
				cellProperties.editor = 'text';
				cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties) {
					Handsontable.renderers.NumericRenderer.apply(this, arguments);
					GTM.check_value(cell_params,value,$(td),table_data.braid_values);
				};
			} else cellProperties.editor = false;
			
			return cellProperties;
		},
		afterChange: function(cells){ GTM.save_data(cells,table_data.table_values); }
	});
	return table;
}

GTM.check_value = function(cell_data,value,tag,braid_values){
	
	
	if (!this.table) return;
	var sensor = this.get('sensors',cell_data.sensor_id);
	
	if (cell_data.date_use == sensor.reference_date_rev) {
		tag.addClass('ref');
		return;
	}
	
	if (value==undefined) return;
	var facility = this.get('facilities',this.main_id);
	
	// done
	if (cell_data.allowed_value_type_id == 1) {
		var prev_value = parseFloat(this.table.getDataAtCell(cell_data.y,cell_data.x-1));
		if (!prev_value) tag.addClass('undef');
		else if (prev_value!=value) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.allowed_value_type_id == 2) {  //for PS
		var norma = this.get('normatives',13);
		if (!norma) return;
		if (value>norma) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.allowed_value_type_id == 5 ||
		cell_data.allowed_value_type_id == 6 ||
		cell_data.allowed_value_type_id == 12) {
		var norma = this.get('normatives',11);
		if (!norma) return;
		var ref_value = sensor.reference_value;
		if (!ref_value) tag.addClass('undef');
		if (value-ref_value>norma) tag.addClass('warning');
		return;	
	}
	
	// done
	if (cell_data.braid_id) {
		var braids = braid_values[sensor.id]; 
		if (facility.base_principle_id==2){
			for (deep in braids) if (this.table.getDataAtCell(braids[deep],cell_data.x)<0){
				tag.addClass('warning');
				return;	
			}
		}
		var norma = this.get('normatives',12);
		if (!norma) return;
		var Ts = 0;
		var counter = 0;
		var coords;
		
		var flag = 0;
		var foundation_depth = facility.foundation_depth || sensor.deep;
		var frozen_depth = facility.frozen_depth || 0;
		for (deep in braids) {
			if (deep<frozen_depth || deep>foundation_depth) continue;
			y = braids[deep];
			var temp = this.table.getDataAtCell(y,cell_data.x);
			Ts+=temp;
			counter++;
		}
		Ts/=counter;
		if(Ts>norma) tag.addClass('warning');
		return;	
	}
		
}

GTM.save_data = function(cells,table_values){
	if (!cells||!cells.length) return;
	var arr = [];
	cells.forEach(function(c){
		var v = table_values[c[0]+'_'+c[1]];
		if (!v) return;
		var params = {
			sensor_id: 	v.sensor_id,
			braid_id:	v.braid_id,
			date_use:	v.date_use,
			value: c[3],
			allowed_value_type_id: v.allowed_value_type_id
		};
		arr.push(params);
	});
	GTM.values_to_save.push(JSON.stringify(arr));
	GTM.save_values();
}


GTM.save_values = function(){
	
	var t = this;
	
	if (this.values_pending) return;
	this.values_pending = 1;
	
	var data = this.values_to_save.shift();
	this.log('Идет сохранение значений...');
	
	if (data) $.ajax({
		url:'/GTM/',
		method:'POST',
		data:{ data:data, mode:'save_values', ajaj:1 },
		error:function(){			
			t.values_pending=0;
			t.refresh_values();
			console.log('save_value detail-error:',$(JSON.parse(arguments[0].responseText).error.error)[0]);
		},
		success:function(){
			t.values_pending=0;
			t.save_values();
		}
	}); else {
		t.values_pending = 0;
		t.request('all_values',t.gen_params_for_data());
		t.log('Значения сохранены');
	}
}


// LOADER


GTM.init_loader=function(){
	
	$('.loader:not(.ready)').addClass('ready').each(function(){
		
		var target = $(this);
		var loader = {
			wait: 		3000,
			tag : 		target,
			name: 		target.attr('data-name'),
			multi: 		lnrr.multi = target.attr('data-multi'),
			images: 	[],
			sensor_id:	target.attr('data-sid'),
			id: 		target.attr('data-id'),
			url: 		target.attr('data-url')
		}
		
		loader.tag.html($(lnrr.View('website/widgets/Im')));
		
		if (loader.id && (loader.name=='image_id' || loader.name=='dwg_id')) $('.loader_wrap .name',loader.tag).html('<a href="'+loader.url+'" target="_blank">текущий</a>');
		
		var upload_data = {
			url:			'/ajaj/upload/',
			ajaj: 1
		}
		
		$('.loader_wrap .status',loader.tag).html('');
	
		var inp = $('.loader_wrap input[name=file]',loader.tag);	
		inp.fileupload({
			url: '/ajaj/upload/',
			formData: { ajaj:1, name:loader.name, sensor_id:loader.sensor_id },
			dataType: 'json',
			add:function(e,data){
				var file = data.files[0];
//				if (!file) 									{Popup.init({type:'error',title:'Ошибка загрузки',text:'Нет файла'});return;}			
//				if (!file.name)								{Popup.init({type:'error',title:'Ошибка загрузки',text:'Безымянный файл'});return;}
//				if (name=='image_id' &&
//					!file.type.match(/jpg|jpeg|gif|png/)) 	{Popup.init({type:'error',title:'Ошибка загрузки',text:'Не допустимое расширение файла'});return;}
				data.submit();
			},
			done: function (e, data) {
				
				$('.status',loader.tag).html('Завершено');
				setTimeout(function(){ $('.status',loader.tag).html('load'); },loader.wait);
				
				if (loader.name=='xlsx') {
					$('.Popup .import_result').html(data.result.string);
					return;
				}
				
				if (loader.name=='image_id' || loader.name=='image_ids' || loader.name=='dwg_id') {
					var image = data.result.image;				
					if (!image.id) { $('.status',loader.tag).html('Ошибка'); return; }
					if (loader.multi) {
						loader.images.push(image.id);
						loader.tag.attr('data-id',loader.images.join(','));	
					} else {
						loader.tag.attr('data-id',image.id);
						loader.tag.attr('data-url',image.url);
					}
				}
			},
			error: function (e, data) {
				$('.status',loader.tag).html('error');
				setTimeout(function(){$('.status',loader.tag).html('load');},2500);
			},
			progressall: function (e, data) {
				var status = parseInt(data.loaded / data.total * 100, 10);//1..100%
				if (status>95) status = 95;
				$('.status',loader.tag).html(status+"%");
			},
		}).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
	});
}





