/**
 * Class: AddComments
 */

/**
 * Method: new
 */
function AddComments(type,item_id) {
	
	var data = JSON.parse(localStorage.getItem('data'));
	this.item = data.hash[type][item_id];
	this.type = type;
	this.images = {};
	this.images_index = 1;
	
	this.init({ title: this.item.name });
}

AddComments.prototype = new Page();


/**
 * Method: back_confirm
 */
AddComments.prototype.back_confirm = function(){
	var flag = true;
	
	if ($('.images .item',this.html).length) flag = false;
	if ($('textarea',this.html).val()) flag = false;
	
	return flag;
}

/**
 * Method: my_name
 */
AddComments.prototype.my_name = function(){
	return 'AddComments';
}

/**
 * Method: before_open
 */
AddComments.prototype.before_open = function(){
	var t = this;
	lnrr.item = this.item;
	lnrr.comments = this.item.comments.comments.map(function(el){
		el.images = t.item.comments.images[el.id]||[];
		return el;
	});
}

/**
 * Method: after_page_added
 */
AddComments.prototype.after_page_added = function(){
	this.blocks.images = $('._page_images',this.html);
	
}

/**
 * Method: get_photo
 */
AddComments.prototype.get_photo = function(lib){
	if (!navigator.camera || !navigator.camera.getPicture) {
		this.error(lib ? 'Проводник не найден!' : 'Камера не найдена!');
        return;
    }
	this.capture(lib ? 'PHOTOLIBRARY' : 'CAMERA' );
}

/**
 * Method: capture
 */
AddComments.prototype.capture=function(source){
	var t=this;
	var sourceType = Camera.PictureSourceType[source];
	try {
		var options =  {
			destinationType     : navigator.camera.DestinationType.FILE_URI,
			sourceType          : sourceType,
			correctOrientation  : true,
			saveToPhotoAlbum    : true,
			mediaType           : Camera.MediaType.PICTURE
		};
		navigator.camera.getPicture( function (imageURI) {
			t.capture_success(imageURI);
		}, function(message) {
			t.error(message,1);
		}, options);
	} catch(e) {
		console.log(e);
		t.error(e,1);
	}
}

/**
 * Method: capture_success
 */
AddComments.prototype.capture_success = function(imageURI){
	
	var t = this;
	
	if (!imageURI) {
		this.error('No image',1);
		return;
	}
	
	window.resolveLocalFileSystemURI(imageURI, function(entry){
		
		t.log('Фотография добавлена',1);
		t.images[imageURI] = t.images_index++;
		
		var img = new Image();
		
		img.onload = function(){
			console.log('Image has load');
			t.refresh_images();	
		};
		
		img.src = imageURI;
	
	}, function(e){ t.error('No image!',1); });
}

/**
 * Method: refresh_images
 */
AddComments.prototype.refresh_images = function(){
	
	console.log('refresh_images');
	console.log(this.blocks);
	
	var images = [];
	for (k in this.images) images.push({ url:k, ordering:this.images[k] });
	images = images.sort(function(a,b){ return b.ordering - a.ordering; }).map(function(el){ return el.url; });
	lnrr.images = images;
	
	this.blocks.images.html(this.get_view('images'));
	this.to_center();
}

/**
 * Method: delete_image
 */
AddComments.prototype.delete_image = function(key){
	this.log('Фотография удалена',1);
	delete this.images[key];
	this.refresh_images();
}

/**
 * Method: submit
 */
AddComments.prototype.submit = function(tag,onsuccess){
		
	if (!onsuccess) onsuccess = function(){ pager.back(); }
	
	if(this.back_confirm()) {
		this.error('Нет данных для сохранения');
		return;
	}
	
	var obj=LNMForms.get_object(tag);
	
	obj.images = this.images;
	obj.type = this.type;
	obj.fid = this.item.id;
	
	var comments = JSON.parse(window.localStorage.getItem('comments') || '0') || [];
	comments.push(obj);
	
	window.localStorage.setItem('comments',JSON.stringify(comments));
	
	onsuccess();
}
