/**
 * Class: ViewComments
 */

/**
 * Method: new
 */
function ViewComments(type,item_id){
	
	var t = this;
	
	var data = JSON.parse(localStorage.getItem('data'));
	this.item = data.hash[type][item_id];	
	
	this.more_length = 5;
	this.start = 0;
	
	var images = this.LS.get('images') || {};
	
	this.items = this.item.comments.comments.map(function(el){
		el.images = t.item.comments.images[el.id]||[];
		el.images.forEach(function(img){
			img.url = images[img.id] || (lnrr.server + img.url);
		});
		return el;
	}).reverse();
	
	this.init({ title:this.item.name });
}

ViewComments.prototype = new Page();

/**
 * Method: my_name
 */
ViewComments.prototype.my_name = function(){
	return 'ViewComments';
}


/**
 * Method: prepare_items
 */
ViewComments.prototype.prepare_items = function(){
	
	lnrr.item = this.item;
	lnrr.comments = this.items.splice(0,this.more_length);
	lnrr.left_items = this.items.length;
	
}

/**
 * Method: open
 */
ViewComments.prototype.before_open = function(){
	this.prepare_items();
}

/**
 * Method: more
 */
ViewComments.prototype.more = function(tag){
	this.prepare_items();
	tag.replaceWith(this.get_view('items'));
}