--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.6
-- Dumped by pg_dump version 9.5.6

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: pgcrypto; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pgcrypto WITH SCHEMA public;


--
-- Name: EXTENSION pgcrypto; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pgcrypto IS 'cryptographic functions';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';


SET search_path = public, pg_catalog;

--
-- Name: ffile_path(bigint); Type: FUNCTION; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE FUNCTION ffile_path(file_folder_id bigint) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare
    cid bigint;
    cid2 bigint;
    path varchar;
    tmp varchar;
begin
    path:='';
    cid:=file_folder_id;
    while cid is not null loop
        select parent_id,code into cid2,tmp from Tfile_folders where id=cid;
        if tmp is null then tmp:=cid; end if;
        path:=tmp||'/'||path;
        cid:=cid2;
    end loop;
    return '/'||path;
end;
$$;


ALTER FUNCTION public.ffile_path(file_folder_id bigint) OWNER TO sgsystems_erp_gtm;

--
-- Name: pcache_set(character varying, text); Type: FUNCTION; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE FUNCTION pcache_set(lkey character varying, lvalue text) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare
    Lid bigint;
begin
    select max(id) into Lid from Tkvcache where key=Lkey;
    if Lid is not null then
        update Tkvcache set value=Lvalue where id=Lid;
    else
        insert into Tkvcache (key,value) values (Lkey,Lvalue);
    end if;
end;
$$;


ALTER FUNCTION public.pcache_set(lkey character varying, lvalue text) OWNER TO sgsystems_erp_gtm;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: tadmin_start_widgets; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tadmin_start_widgets (
    id bigint NOT NULL,
    controller_name character varying(64) NOT NULL,
    controller_mode character varying(64) NOT NULL,
    fullscreen integer DEFAULT 0 NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tadmin_start_widgets OWNER TO sgsystems_erp_gtm;

--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tadmin_start_widgets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tadmin_start_widgets_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tadmin_start_widgets_id_seq OWNED BY tadmin_start_widgets.id;


--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tadmin_start_widgets_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tadmin_start_widgets_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tadmin_start_widgets_ordering_seq OWNED BY tadmin_start_widgets.ordering;


--
-- Name: tallowed_model_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tallowed_model_types (
    id bigint NOT NULL,
    sensor_model_id integer,
    sensor_model_type_id integer,
    code character varying(1024),
    has_braid integer,
    has_own_values integer,
    ordering integer,
    can_be_retranslator integer,
    name character varying(1024),
    braid_measurer_id integer
);


ALTER TABLE tallowed_model_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tallowed_model_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tallowed_model_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tallowed_model_types_id_seq OWNED BY tallowed_model_types.id;


--
-- Name: tallowed_value_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tallowed_value_types (
    id bigint NOT NULL,
    measure_id integer,
    allowed_model_type_id integer,
    code character varying(64),
    accuracy integer,
    name character varying(1024)
);


ALTER TABLE tallowed_value_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tallowed_value_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tallowed_value_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tallowed_value_types_id_seq OWNED BY tallowed_value_types.id;


--
-- Name: tanon_cookies; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tanon_cookies (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_agent_id bigint NOT NULL,
    sid character varying(256) NOT NULL,
    ip inet NOT NULL
);


ALTER TABLE tanon_cookies OWNER TO sgsystems_erp_gtm;

--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tanon_cookies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tanon_cookies_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tanon_cookies_id_seq OWNED BY tanon_cookies.id;


--
-- Name: tarticle_categories; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tarticle_categories (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    groupcode character varying(32),
    has_abstract integer NOT NULL,
    has_image1 integer NOT NULL,
    has_image2 integer NOT NULL,
    has_gallery integer NOT NULL,
    image1_id bigint,
    image2_id bigint
);


ALTER TABLE tarticle_categories OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tarticle_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticle_categories_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tarticle_categories_id_seq OWNED BY tarticle_categories.id;


--
-- Name: tarticle_categories_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tarticle_categories_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(64) NOT NULL,
    abstract text,
    body text
);


ALTER TABLE tarticle_categories_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tarticle_categories_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticle_categories_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tarticle_categories_l10n_id_seq OWNED BY tarticle_categories_l10n.id;


--
-- Name: tarticles; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tarticles (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_use date,
    date_show_start date,
    date_show_end date,
    category_id bigint NOT NULL,
    calc_code character varying(256) NOT NULL,
    image1_id bigint,
    image2_id bigint,
    image3_id bigint,
    folder_id bigint,
    enabled integer NOT NULL,
    featured integer DEFAULT 0 NOT NULL,
    user_cr_id bigint
);


ALTER TABLE tarticles OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticles_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tarticles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticles_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tarticles_id_seq OWNED BY tarticles.id;


--
-- Name: tarticles_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tarticles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(4000) NOT NULL,
    abstract text,
    body text,
    disabled_l10n integer DEFAULT 0 NOT NULL,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tarticles_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tarticles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticles_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tarticles_l10n_id_seq OWNED BY tarticles_l10n.id;


--
-- Name: tbase_padding_principles; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tbase_padding_principles (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tbase_padding_principles OWNER TO sgsystems_erp_gtm;

--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tbase_padding_principles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tbase_padding_principles_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tbase_padding_principles_id_seq OWNED BY tbase_padding_principles.id;


--
-- Name: tbraids; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tbraids (
    id bigint NOT NULL,
    sensor_id integer,
    deep numeric(10,1),
    enabled integer
);


ALTER TABLE tbraids OWNER TO sgsystems_erp_gtm;

--
-- Name: tbraids_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tbraids_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tbraids_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tbraids_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tbraids_id_seq OWNED BY tbraids.id;


--
-- Name: tcart_items; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcart_items (
    id bigint NOT NULL,
    cart_id bigint NOT NULL,
    market_item_id bigint,
    cnt integer DEFAULT 1 NOT NULL,
    other_ftype character varying(128),
    other_fid bigint,
    price numeric(30,2) NOT NULL,
    amount integer NOT NULL,
    CONSTRAINT tcart_items_item_or_fid CHECK (((market_item_id IS NULL) OR ((other_ftype IS NULL) AND (other_fid IS NULL))))
);


ALTER TABLE tcart_items OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_items_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcart_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_items_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcart_items_id_seq OWNED BY tcart_items.id;


--
-- Name: tcart_payment_methods; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcart_payment_methods (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    func character varying(64),
    prepay integer NOT NULL,
    enabled integer NOT NULL
);


ALTER TABLE tcart_payment_methods OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcart_payment_methods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_payment_methods_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcart_payment_methods_id_seq OWNED BY tcart_payment_methods.id;


--
-- Name: tcart_payment_methods_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcart_payment_methods_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    body text
);


ALTER TABLE tcart_payment_methods_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcart_payment_methods_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_payment_methods_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcart_payment_methods_l10n_id_seq OWNED BY tcart_payment_methods_l10n.id;


--
-- Name: tcart_states; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcart_states (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    cssclass character varying(32),
    do_calc_money integer NOT NULL
);


ALTER TABLE tcart_states OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_states_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcart_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_states_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcart_states_id_seq OWNED BY tcart_states.id;


--
-- Name: tcart_states_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcart_states_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    body text
);


ALTER TABLE tcart_states_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcart_states_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_states_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcart_states_l10n_id_seq OWNED BY tcart_states_l10n.id;


--
-- Name: tcarts; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcarts (
    id bigint NOT NULL,
    user_id bigint,
    sid character varying(128),
    state_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    date_mo timestamp without time zone DEFAULT now(),
    date_sent timestamp without time zone,
    date_state_change timestamp without time zone,
    payment_method_id bigint,
    manager_id bigint,
    calc_summ numeric(30,2) DEFAULT 0 NOT NULL,
    calc_items integer DEFAULT 0 NOT NULL,
    calc_amount integer DEFAULT 0 NOT NULL,
    address_postalindex character varying(16),
    address_city character varying(128),
    address_street character varying(128),
    address_phone character varying(64),
    address_comments character varying(4000),
    address_nearest character varying(128),
    address_flat character varying(128),
    address_porch character varying(128),
    address_floor character varying(128),
    address_password character varying(128),
    required_change character varying(128),
    real_payed numeric(30,2) DEFAULT 0 NOT NULL
);


ALTER TABLE tcarts OWNER TO sgsystems_erp_gtm;

--
-- Name: tcarts_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcarts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcarts_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcarts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcarts_id_seq OWNED BY tcarts.id;


--
-- Name: tcells; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcells (
    id bigint NOT NULL,
    worksheet_id bigint NOT NULL,
    x integer NOT NULL,
    y integer NOT NULL,
    value text
);


ALTER TABLE tcells OWNER TO sgsystems_erp_gtm;

--
-- Name: tcells_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcells_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcells_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcells_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcells_id_seq OWNED BY tcells.id;


--
-- Name: tcontent_boxes; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcontent_boxes (
    id bigint NOT NULL,
    group_id bigint NOT NULL,
    ordering bigint NOT NULL,
    image_id bigint,
    image2_id bigint,
    enabled integer NOT NULL
);


ALTER TABLE tcontent_boxes OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_groups; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcontent_boxes_groups (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(256) NOT NULL
);


ALTER TABLE tcontent_boxes_groups OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcontent_boxes_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_groups_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcontent_boxes_groups_id_seq OWNED BY tcontent_boxes_groups.id;


--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcontent_boxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcontent_boxes_id_seq OWNED BY tcontent_boxes.id;


--
-- Name: tcontent_boxes_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcontent_boxes_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    override_image_id bigint,
    name character varying(1024),
    name2 character varying(1024),
    name3 character varying(1024),
    url character varying(1024)
);


ALTER TABLE tcontent_boxes_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcontent_boxes_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcontent_boxes_l10n_id_seq OWNED BY tcontent_boxes_l10n.id;


--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcontent_boxes_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcontent_boxes_ordering_seq OWNED BY tcontent_boxes.ordering;


--
-- Name: tcustom_nav_items; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcustom_nav_items (
    id bigint NOT NULL,
    nav_id bigint,
    parent_id bigint,
    image_id bigint,
    href character varying(256),
    page_id bigint,
    enabled integer DEFAULT 1 NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tcustom_nav_items OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_id_seq OWNED BY tcustom_nav_items.id;


--
-- Name: tcustom_nav_items_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcustom_nav_items_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128),
    description text
);


ALTER TABLE tcustom_nav_items_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_l10n_id_seq OWNED BY tcustom_nav_items_l10n.id;


--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_ordering_seq OWNED BY tcustom_nav_items.ordering;


--
-- Name: tcustom_navs; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tcustom_navs (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(128) NOT NULL,
    can_href integer NOT NULL,
    can_image integer NOT NULL,
    can_description integer NOT NULL
);


ALTER TABLE tcustom_navs OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tcustom_navs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_navs_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tcustom_navs_id_seq OWNED BY tcustom_navs.id;


--
-- Name: tdb_version; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tdb_version (
    version integer NOT NULL
);


ALTER TABLE tdb_version OWNER TO sgsystems_erp_gtm;

--
-- Name: tdebug_requests; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tdebug_requests (
    id bigint NOT NULL,
    login character varying(128),
    password character varying(128),
    url character varying(128),
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    params text,
    user_id bigint,
    user_agent_id bigint,
    error text,
    version character varying(32),
    charge double precision
);


ALTER TABLE tdebug_requests OWNER TO sgsystems_erp_gtm;

--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tdebug_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tdebug_requests_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tdebug_requests_id_seq OWNED BY tdebug_requests.id;


--
-- Name: tedit_histories; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tedit_histories (
    id integer NOT NULL,
    model_name name,
    text text,
    data text,
    facility_id integer,
    date_cr timestamp without time zone DEFAULT now(),
    user_id integer,
    model_id integer
);


ALTER TABLE tedit_histories OWNER TO sgsystems_erp_gtm;

--
-- Name: tedit_histories_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tedit_histories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tedit_histories_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tedit_histories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tedit_histories_id_seq OWNED BY tedit_histories.id;


--
-- Name: texplications; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE texplications (
    id bigint NOT NULL,
    facility_id integer,
    field01 character varying(1024),
    field02 character varying(1024),
    field03 character varying(1024),
    field04 character varying(1024),
    field05 character varying(1024),
    field06 character varying(1024),
    field07 character varying(1024),
    field08 character varying(1024),
    field09 character varying(1024),
    field10 character varying(1024),
    field11 character varying(1024),
    field12 character varying(1024)
);


ALTER TABLE texplications OWNER TO sgsystems_erp_gtm;

--
-- Name: texplications_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE texplications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE texplications_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: texplications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE texplications_id_seq OWNED BY texplications.id;


--
-- Name: tfacilities; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacilities (
    id bigint NOT NULL,
    parent_id bigint,
    name character varying(256) NOT NULL,
    ordering bigint NOT NULL,
    image_id bigint,
    code character varying(128),
    address character varying(1280),
    load_capacity numeric(30,4),
    protection text,
    base_type character varying(128),
    base_construction character varying(128),
    base_principle_id integer,
    location_x numeric(30,4),
    location_y numeric(30,4),
    state_id integer,
    width integer,
    height integer,
    foundation_depth numeric(20,1),
    frozen_depth character varying(2048),
    clipmap character varying(2048),
    dumping_depth numeric(20,2),
    plan_id integer,
    view_data text,
    table_x numeric(10,2) DEFAULT 1,
    table_y numeric(10,2),
    element_size numeric(10,2) DEFAULT 1.00,
    table_size numeric(10,2),
    deleted integer,
    date_cr date DEFAULT now(),
    allowed_temperature numeric(30,2),
    allowed_deformation numeric(30,2),
    show_explication integer DEFAULT 0,
    show_convention integer DEFAULT 0,
    convention_x integer DEFAULT 0,
    convention_y integer DEFAULT 0,
    type character varying(1024),
    stamp_data text,
    responsibility_level character varying(2048),
    negative_process text
);


ALTER TABLE tfacilities OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacilities_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacilities_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacilities_id_seq OWNED BY tfacilities.id;


--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacilities_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacilities_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacilities_ordering_seq OWNED BY tfacilities.ordering;


--
-- Name: tfacility_comment_images; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_comment_images (
    id bigint NOT NULL,
    comment_id integer,
    image_id integer
);


ALTER TABLE tfacility_comment_images OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_comment_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_comment_images_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_comment_images_id_seq OWNED BY tfacility_comment_images.id;


--
-- Name: tfacility_comments; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_comments (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    body text,
    images_json text
);


ALTER TABLE tfacility_comments OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_comments_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_comments_id_seq OWNED BY tfacility_comments.id;


--
-- Name: tfacility_groups; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_groups (
    id bigint NOT NULL,
    facility_id integer,
    name character varying(1024)
);


ALTER TABLE tfacility_groups OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_photos; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_photos (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    image_id bigint NOT NULL,
    body text
);


ALTER TABLE tfacility_photos OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_photos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_photos_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_photos_id_seq OWNED BY tfacility_photos.id;


--
-- Name: tfacility_states; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_states (
    id bigint NOT NULL,
    name character varying(1024),
    ordering bigint NOT NULL
);


ALTER TABLE tfacility_states OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_states_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_states_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_states_id_seq OWNED BY tfacility_states.id;


--
-- Name: tfacility_states_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_states_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_states_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_states_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_states_ordering_seq OWNED BY tfacility_states.ordering;


--
-- Name: tfacility_stats; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_stats (
    id bigint NOT NULL,
    facility_id integer,
    date date,
    data text
);


ALTER TABLE tfacility_stats OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_stats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_stats_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_stats_id_seq OWNED BY tfacility_stats.id;


--
-- Name: tfacility_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfacility_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tfacility_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfacility_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfacility_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfacility_types_id_seq OWNED BY tfacility_types.id;


--
-- Name: tfile_folders; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfile_folders (
    id bigint NOT NULL,
    code character varying(64),
    parent_id bigint,
    user_cr_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_mo timestamp without time zone DEFAULT now() NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tfile_folders OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_folders_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfile_folders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_folders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfile_folders_id_seq OWNED BY tfile_folders.id;


--
-- Name: tfile_folders_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfile_folders_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfile_folders_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfile_folders_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfile_folders_l10n_id_seq OWNED BY tfile_folders_l10n.id;


--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfile_folders_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfile_folders_ordering_seq OWNED BY tfile_folders.ordering;


--
-- Name: tfile_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfile_types (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfile_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfile_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfile_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfile_types_id_seq OWNED BY tfile_types.id;


--
-- Name: tfiles; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfiles (
    id bigint NOT NULL,
    type_id bigint NOT NULL,
    file_folder_id bigint NOT NULL,
    user_cr_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_mo timestamp without time zone DEFAULT now() NOT NULL,
    orig_filename character varying(256) NOT NULL,
    ext character varying(16),
    width integer,
    height integer,
    filesize integer,
    seconds integer,
    ordering bigint NOT NULL
);


ALTER TABLE tfiles OWNER TO sgsystems_erp_gtm;

--
-- Name: tfiles_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfiles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfiles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfiles_id_seq OWNED BY tfiles.id;


--
-- Name: tfiles_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tfiles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfiles_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfiles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfiles_l10n_id_seq OWNED BY tfiles_l10n.id;


--
-- Name: tfiles_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfiles_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfiles_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfiles_ordering_seq OWNED BY tfiles.ordering;


--
-- Name: tmeasurement_periods; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmeasurement_periods (
    id bigint NOT NULL,
    facility_id integer,
    sensor_model_id integer,
    value integer
);


ALTER TABLE tmeasurement_periods OWNER TO sgsystems_erp_gtm;

--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tfmeasurement_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfmeasurement_periods_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tfmeasurement_periods_id_seq OWNED BY tmeasurement_periods.id;


--
-- Name: tforms; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tforms (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(128) NOT NULL,
    fields_not_null text,
    func_error character varying(128),
    func_ok character varying(1024),
    mail_template1_id bigint,
    mail_template2_id bigint
);


ALTER TABLE tforms OWNER TO sgsystems_erp_gtm;

--
-- Name: tforms_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tforms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tforms_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tforms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tforms_id_seq OWNED BY tforms.id;


--
-- Name: tguestbook_messages; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tguestbook_messages (
    id bigint NOT NULL,
    guestbook_id bigint NOT NULL,
    user_q_name character varying(128) NOT NULL,
    user_q_phone character varying(128),
    user_q_email character varying(128),
    user_q_avatar_id bigint,
    user_a_id bigint,
    question text,
    answer text,
    date_question timestamp without time zone DEFAULT now(),
    date_answer timestamp without time zone,
    moderated integer NOT NULL
);


ALTER TABLE tguestbook_messages OWNER TO sgsystems_erp_gtm;

--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tguestbook_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tguestbook_messages_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tguestbook_messages_id_seq OWNED BY tguestbook_messages.id;


--
-- Name: tguestbooks; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tguestbooks (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(256) NOT NULL,
    premoderated integer NOT NULL,
    users_can_post integer NOT NULL,
    mail_template1_id bigint,
    mail_template2_id bigint
);


ALTER TABLE tguestbooks OWNER TO sgsystems_erp_gtm;

--
-- Name: tguestbooks_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tguestbooks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tguestbooks_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tguestbooks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tguestbooks_id_seq OWNED BY tguestbooks.id;


--
-- Name: tkvcache; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tkvcache (
    id bigint NOT NULL,
    key character varying(4000) NOT NULL,
    value text
);


ALTER TABLE tkvcache OWNER TO sgsystems_erp_gtm;

--
-- Name: tkvcache_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tkvcache_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tkvcache_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tkvcache_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tkvcache_id_seq OWNED BY tkvcache.id;


--
-- Name: tl10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tl10n (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(160) NOT NULL,
    is_default integer NOT NULL
);


ALTER TABLE tl10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tl10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tl10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tl10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tl10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tl10n_id_seq OWNED BY tl10n.id;


--
-- Name: tlogin_attempts; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tlogin_attempts (
    id bigint NOT NULL,
    login character varying(256),
    password character varying(256),
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_ip character varying(32),
    user_agent_id bigint NOT NULL,
    url character varying(1000),
    ok integer NOT NULL
);


ALTER TABLE tlogin_attempts OWNER TO sgsystems_erp_gtm;

--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tlogin_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tlogin_attempts_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tlogin_attempts_id_seq OWNED BY tlogin_attempts.id;


--
-- Name: tmail_templates; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmail_templates (
    id bigint NOT NULL,
    code character varying(256) NOT NULL,
    name character varying(256),
    default_from character varying(256),
    default_to character varying(256),
    signature character varying(128)
);


ALTER TABLE tmail_templates OWNER TO sgsystems_erp_gtm;

--
-- Name: tmail_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmail_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmail_templates_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmail_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmail_templates_id_seq OWNED BY tmail_templates.id;


--
-- Name: tmail_templates_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmail_templates_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    subject character varying(1024),
    body text
);


ALTER TABLE tmail_templates_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmail_templates_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmail_templates_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmail_templates_l10n_id_seq OWNED BY tmail_templates_l10n.id;


--
-- Name: tmarket_categories; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_categories (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    parent_id bigint,
    image1_id bigint,
    image2_id bigint,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    fid character varying(32),
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL,
    has_abstract integer DEFAULT 0 NOT NULL,
    has_body2 integer DEFAULT 0 NOT NULL
);


ALTER TABLE tmarket_categories OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_categories_id_seq OWNED BY tmarket_categories.id;


--
-- Name: tmarket_categories_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_categories_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tmarket_categories_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_categories_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_categories_l10n_id_seq OWNED BY tmarket_categories_l10n.id;


--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_categories_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_categories_ordering_seq OWNED BY tmarket_categories.ordering;


--
-- Name: tmarket_field_datatypes; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_field_datatypes (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    view_code character varying(32),
    name character varying(128) NOT NULL,
    prefix character varying(32),
    crsql character varying(128),
    has_l10n integer NOT NULL,
    has_enum integer NOT NULL
);


ALTER TABLE tmarket_field_datatypes OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_datatypes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_datatypes_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_datatypes_id_seq OWNED BY tmarket_field_datatypes.id;


--
-- Name: tmarket_field_enums; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_field_enums (
    id bigint NOT NULL,
    field_id bigint NOT NULL,
    value character varying(2000)
);


ALTER TABLE tmarket_field_enums OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_enums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_enums_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_enums_id_seq OWNED BY tmarket_field_enums.id;


--
-- Name: tmarket_field_enumsl; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_field_enumsl (
    id bigint NOT NULL,
    field_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    value character varying(2000)
);


ALTER TABLE tmarket_field_enumsl OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_enumsl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_enumsl_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_enumsl_id_seq OWNED BY tmarket_field_enumsl.id;


--
-- Name: tmarket_field_groups; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_field_groups (
    id bigint NOT NULL,
    ordering bigint NOT NULL,
    enabled integer NOT NULL,
    category_id bigint
);


ALTER TABLE tmarket_field_groups OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_id_seq OWNED BY tmarket_field_groups.id;


--
-- Name: tmarket_field_groups_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_field_groups_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_field_groups_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_l10n_id_seq OWNED BY tmarket_field_groups_l10n.id;


--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_ordering_seq OWNED BY tmarket_field_groups.ordering;


--
-- Name: tmarket_fields; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_fields (
    id bigint NOT NULL,
    group_id bigint NOT NULL,
    datatype_id bigint NOT NULL,
    view_level_id bigint NOT NULL,
    search_level_id bigint NOT NULL,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    cid bigint,
    fid character varying(128)
);


ALTER TABLE tmarket_fields OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_fields_id_seq OWNED BY tmarket_fields.id;


--
-- Name: tmarket_fields_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_fields_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_fields_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_fields_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_fields_l10n_id_seq OWNED BY tmarket_fields_l10n.id;


--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_fields_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_fields_ordering_seq OWNED BY tmarket_fields.ordering;


--
-- Name: tmarket_item_fields_enums; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_enums (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    field_id bigint NOT NULL,
    enum_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_enums OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_enums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_enums_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_enums_id_seq OWNED BY tmarket_item_fields_enums.id;


--
-- Name: tmarket_item_fields_enumsl; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_enumsl (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    field_id bigint NOT NULL,
    enum_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_enumsl OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_enumsl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_enumsl_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_enumsl_id_seq OWNED BY tmarket_item_fields_enumsl.id;


--
-- Name: tmarket_item_fields_f; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_f (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_f OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_f_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_f_id_seq OWNED BY tmarket_item_fields_f.id;


--
-- Name: tmarket_item_fields_i; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_i (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_i OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_i_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_i_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_i_id_seq OWNED BY tmarket_item_fields_i.id;


--
-- Name: tmarket_item_fields_il; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_il (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    fid_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_il OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_il_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_il_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_il_id_seq OWNED BY tmarket_item_fields_il.id;


--
-- Name: tmarket_item_fields_s; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_s (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_s OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_s_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_s_id_seq OWNED BY tmarket_item_fields_s.id;


--
-- Name: tmarket_item_fields_sl; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_fields_sl (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    fid_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_sl OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_sl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_sl_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_sl_id_seq OWNED BY tmarket_item_fields_sl.id;


--
-- Name: tmarket_item_groups; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_groups (
    id bigint NOT NULL,
    enabled integer NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tmarket_item_groups OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_id_seq OWNED BY tmarket_item_groups.id;


--
-- Name: tmarket_item_groups_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_item_groups_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128)
);


ALTER TABLE tmarket_item_groups_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_l10n_id_seq OWNED BY tmarket_item_groups_l10n.id;


--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_ordering_seq OWNED BY tmarket_item_groups.ordering;


--
-- Name: tmarket_items; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_items (
    id bigint NOT NULL,
    code character varying(256) NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    image1_id bigint,
    image2_id bigint,
    group_id bigint,
    category_id bigint NOT NULL,
    manufacturer_id bigint NOT NULL,
    enabled integer NOT NULL,
    in_stock integer NOT NULL,
    price numeric(30,2),
    ordering bigint NOT NULL,
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL,
    fid character varying(32),
    fid2 character varying(32),
    file_folder_id bigint,
    old_price numeric(30,2),
    base_price numeric(30,2),
    discount_value character varying(32),
    in_stock_count integer
);


ALTER TABLE tmarket_items OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_items_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_items_id_seq OWNED BY tmarket_items.id;


--
-- Name: tmarket_items_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_items_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text
);


ALTER TABLE tmarket_items_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_items_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_items_l10n_id_seq OWNED BY tmarket_items_l10n.id;


--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_items_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_items_ordering_seq OWNED BY tmarket_items.ordering;


--
-- Name: tmarket_manufacturers; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_manufacturers (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    image1_id bigint,
    image2_id bigint,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    fid character varying(32),
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL
);


ALTER TABLE tmarket_manufacturers OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_id_seq OWNED BY tmarket_manufacturers.id;


--
-- Name: tmarket_manufacturers_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_manufacturers_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tmarket_manufacturers_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_l10n_id_seq OWNED BY tmarket_manufacturers_l10n.id;


--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_ordering_seq OWNED BY tmarket_manufacturers.ordering;


--
-- Name: tmarket_search_levels; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_search_levels (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE tmarket_search_levels OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_search_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_search_levels_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_search_levels_id_seq OWNED BY tmarket_search_levels.id;


--
-- Name: tmarket_search_levels_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_search_levels_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_search_levels_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_search_levels_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_search_levels_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_search_levels_l10n_id_seq OWNED BY tmarket_search_levels_l10n.id;


--
-- Name: tmarket_view_levels; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_view_levels (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE tmarket_view_levels OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_view_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_view_levels_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_view_levels_id_seq OWNED BY tmarket_view_levels.id;


--
-- Name: tmarket_view_levels_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmarket_view_levels_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_view_levels_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmarket_view_levels_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_view_levels_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmarket_view_levels_l10n_id_seq OWNED BY tmarket_view_levels_l10n.id;


--
-- Name: tmeasurement_modes; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmeasurement_modes (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tmeasurement_modes OWNER TO sgsystems_erp_gtm;

--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmeasurement_modes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmeasurement_modes_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmeasurement_modes_id_seq OWNED BY tmeasurement_modes.id;


--
-- Name: tmeasurer_value_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmeasurer_value_types (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(256) NOT NULL
);


ALTER TABLE tmeasurer_value_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmeasurer_value_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmeasurer_value_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmeasurer_value_types_id_seq OWNED BY tmeasurer_value_types.id;


--
-- Name: tmediums; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tmediums (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    ordering bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tmediums OWNER TO sgsystems_erp_gtm;

--
-- Name: tmediums_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmediums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmediums_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmediums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmediums_id_seq OWNED BY tmediums.id;


--
-- Name: tmediums_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tmediums_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmediums_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tmediums_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tmediums_ordering_seq OWNED BY tmediums.ordering;


--
-- Name: tnormative_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tnormative_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tnormative_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tnormatives; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tnormatives (
    id bigint NOT NULL,
    facility_id integer,
    type_id integer,
    value numeric
);


ALTER TABLE tnormatives OWNER TO sgsystems_erp_gtm;

--
-- Name: tnormatives_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tnormatives_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tnormatives_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tnormatives_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tnormatives_id_seq OWNED BY tnormative_types.id;


--
-- Name: tnormatives_id_seq1; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tnormatives_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tnormatives_id_seq1 OWNER TO sgsystems_erp_gtm;

--
-- Name: tnormatives_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tnormatives_id_seq1 OWNED BY tnormatives.id;


--
-- Name: tpage_blocks; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tpage_blocks (
    id bigint NOT NULL,
    page_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    place_id bigint NOT NULL,
    medium_id bigint NOT NULL,
    body text
);


ALTER TABLE tpage_blocks OWNER TO sgsystems_erp_gtm;

--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpage_blocks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpage_blocks_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpage_blocks_id_seq OWNED BY tpage_blocks.id;


--
-- Name: tpages; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tpages (
    id bigint NOT NULL,
    parent_id bigint,
    alias character varying(128) NOT NULL,
    template_id bigint NOT NULL,
    prerun character varying(2048),
    prerun_param character varying(2048),
    show_in_nav integer DEFAULT 1 NOT NULL,
    ordering bigint NOT NULL,
    role_id bigint,
    hide_anon integer DEFAULT 0 NOT NULL,
    hide_reg integer DEFAULT 0 NOT NULL,
    cssclass character varying(64)
);


ALTER TABLE tpages OWNER TO sgsystems_erp_gtm;

--
-- Name: tpages_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpages_id_seq OWNED BY tpages.id;


--
-- Name: tpages_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tpages_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    title character varying(2048),
    meta_description character varying(2048),
    meta_keywords character varying(2048),
    disabled_l10n integer DEFAULT 0 NOT NULL
);


ALTER TABLE tpages_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpages_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpages_l10n_id_seq OWNED BY tpages_l10n.id;


--
-- Name: tpages_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpages_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpages_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpages_ordering_seq OWNED BY tpages.ordering;


--
-- Name: tpayment_service_errors; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tpayment_service_errors (
    id bigint NOT NULL,
    psi_id bigint,
    amount numeric(30,2),
    error text,
    pay_remote_addr character varying(128) NOT NULL,
    pay_user_agent_id bigint,
    pay_data text
);


ALTER TABLE tpayment_service_errors OWNER TO sgsystems_erp_gtm;

--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpayment_service_errors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpayment_service_errors_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpayment_service_errors_id_seq OWNED BY tpayment_service_errors.id;


--
-- Name: tpayment_service_invoices; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tpayment_service_invoices (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    date_pay timestamp without time zone DEFAULT now(),
    ask_remote_addr character varying(128) NOT NULL,
    ask_user_agent_id bigint,
    amount numeric(30,2) NOT NULL,
    user_id bigint,
    module_name character varying(128),
    module_fid bigint,
    module_data text,
    redirect character varying(1024),
    payed integer NOT NULL,
    service_name character varying(128),
    service_data text,
    pay_remote_addr character varying(128),
    pay_user_agent_id bigint,
    pay_data text
);


ALTER TABLE tpayment_service_invoices OWNER TO sgsystems_erp_gtm;

--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tpayment_service_invoices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpayment_service_invoices_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tpayment_service_invoices_id_seq OWNED BY tpayment_service_invoices.id;


--
-- Name: tplan_formats; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tplan_formats (
    id bigint NOT NULL,
    name character varying(1024),
    width integer,
    height integer,
    dwg_id integer,
    pdf_id integer,
    explication_data text
);


ALTER TABLE tplan_formats OWNER TO sgsystems_erp_gtm;

--
-- Name: tplan_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tplan_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tplan_formats_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tplan_formats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tplan_formats_id_seq OWNED BY tplan_formats.id;


--
-- Name: tplans; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tplans (
    id bigint NOT NULL,
    name character varying(1204),
    dwg_id integer,
    pdf_id integer,
    jpg_id integer,
    format_id integer,
    view_data text,
    width integer,
    height integer,
    status character varying(64),
    urn text,
    urn_encoded text,
    log text,
    calc_pdf_id integer,
    deleted integer
);


ALTER TABLE tplans OWNER TO sgsystems_erp_gtm;

--
-- Name: tplans_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tplans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tplans_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tplans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tplans_id_seq OWNED BY tplans.id;


--
-- Name: treferences; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE treferences (
    id bigint NOT NULL,
    parent_id integer,
    name character varying(1024),
    body text,
    ordering bigint NOT NULL,
    enabled integer
);


ALTER TABLE treferences OWNER TO sgsystems_erp_gtm;

--
-- Name: treferences_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE treferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE treferences_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: treferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE treferences_id_seq OWNED BY treferences.id;


--
-- Name: treferences_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE treferences_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE treferences_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: treferences_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE treferences_ordering_seq OWNED BY treferences.ordering;


--
-- Name: trewrites; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE trewrites (
    id bigint NOT NULL,
    regexp character varying(256) NOT NULL,
    fields character varying(128),
    page_id bigint,
    controller_name character varying(128),
    controller_mode character varying(128),
    signature character varying(128)
);


ALTER TABLE trewrites OWNER TO sgsystems_erp_gtm;

--
-- Name: trewrites_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE trewrites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE trewrites_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: trewrites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE trewrites_id_seq OWNED BY trewrites.id;


--
-- Name: troles; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE troles (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE troles OWNER TO sgsystems_erp_gtm;

--
-- Name: troles_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE troles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE troles_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: troles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE troles_id_seq OWNED BY troles.id;


--
-- Name: troles_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE troles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE troles_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: troles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE troles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE troles_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: troles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE troles_l10n_id_seq OWNED BY troles_l10n.id;


--
-- Name: tsensor_comment_images; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_comment_images (
    id bigint NOT NULL,
    image_id integer,
    comment_id integer
);


ALTER TABLE tsensor_comment_images OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_comment_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_comment_images_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_comment_images_id_seq OWNED BY tsensor_comment_images.id;


--
-- Name: tsensor_comments; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_comments (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    body text,
    images_json text
);


ALTER TABLE tsensor_comments OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_comments_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_comments_id_seq OWNED BY tsensor_comments.id;


--
-- Name: tsensor_groups; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_groups (
    id bigint NOT NULL,
    sensor_id integer,
    group_id integer
);


ALTER TABLE tsensor_groups OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_groups_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_groups_id_seq OWNED BY tfacility_groups.id;


--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_groups_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_groups_id_seq1 OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_groups_id_seq1 OWNED BY tsensor_groups.id;


--
-- Name: tsensor_model_measurers; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_model_measurers (
    id bigint NOT NULL,
    sensor_model_id bigint NOT NULL,
    value_type_id bigint NOT NULL,
    name character varying(128),
    ordering bigint NOT NULL,
    accuracy character varying(24)
);


ALTER TABLE tsensor_model_measurers OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_model_measurers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_measurers_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_model_measurers_id_seq OWNED BY tsensor_model_measurers.id;


--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_model_measurers_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_measurers_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_model_measurers_ordering_seq OWNED BY tsensor_model_measurers.ordering;


--
-- Name: tsensor_model_normatives; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_model_normatives (
    id bigint NOT NULL,
    sensor_model_id integer,
    normative_id integer,
    value numeric(30,4),
    for_group integer
);


ALTER TABLE tsensor_model_normatives OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_model_normatives_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_normatives_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_model_normatives_id_seq OWNED BY tsensor_model_normatives.id;


--
-- Name: tsensor_model_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_model_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tsensor_model_types OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_model_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_model_types_id_seq OWNED BY tsensor_model_types.id;


--
-- Name: tsensor_models; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_models (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(256) NOT NULL,
    name_short character varying(24),
    has_braid integer,
    has_own_values integer,
    has_angle integer
);


ALTER TABLE tsensor_models OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_models_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_models_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_models_id_seq OWNED BY tsensor_models.id;


--
-- Name: tsensor_photos; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_photos (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    image_id bigint NOT NULL,
    body text
);


ALTER TABLE tsensor_photos OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_photos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_photos_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_photos_id_seq OWNED BY tsensor_photos.id;


--
-- Name: tsensor_states; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_states (
    id bigint NOT NULL,
    name character varying(64),
    code character varying(32)
);


ALTER TABLE tsensor_states OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_states_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_states_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_states_id_seq OWNED BY tsensor_states.id;


--
-- Name: tsensor_values; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensor_values (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    value numeric(30,4),
    date_use date,
    braid_id integer,
    allowed_value_type_id integer,
    CONSTRAINT braid_or_allowed_value_type CHECK ((((allowed_value_type_id IS NULL) AND (braid_id IS NOT NULL)) OR ((allowed_value_type_id IS NOT NULL) AND (braid_id IS NULL))))
);


ALTER TABLE tsensor_values OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_values_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensor_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_values_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensor_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensor_values_id_seq OWNED BY tsensor_values.id;


--
-- Name: tsensors; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsensors (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    name character varying(256) NOT NULL,
    location_x numeric(30,2),
    location_y numeric(30,2),
    location_comments text,
    measurement_mode_id integer,
    allowed_model_type_id integer NOT NULL,
    state_id integer NOT NULL,
    is_retranslator integer,
    deep numeric(20,1),
    deep_step numeric(20,1),
    image_id integer,
    angle integer,
    deleted integer,
    pr_sensor_id integer,
    measurement_period character varying(1024),
    reference_date date,
    clipmap character varying(2048)
);


ALTER TABLE tsensors OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensors_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsensors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensors_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsensors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsensors_id_seq OWNED BY tsensors.id;


--
-- Name: tsexes; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsexes (
    id bigint NOT NULL,
    code character varying(16) NOT NULL
);


ALTER TABLE tsexes OWNER TO sgsystems_erp_gtm;

--
-- Name: tsexes_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsexes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsexes_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsexes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsexes_id_seq OWNED BY tsexes.id;


--
-- Name: tsexes_l10n; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsexes_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tsexes_l10n OWNER TO sgsystems_erp_gtm;

--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsexes_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsexes_l10n_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsexes_l10n_id_seq OWNED BY tsexes_l10n.id;


--
-- Name: tsocial_network_account_friends; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsocial_network_account_friends (
    id bigint NOT NULL,
    fid character varying(256) NOT NULL,
    email character varying(256),
    name character varying(256),
    date_birth character varying(256),
    avatar_id bigint,
    sex_id bigint,
    account_id bigint NOT NULL
);


ALTER TABLE tsocial_network_account_friends OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsocial_network_account_friends_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_network_account_friends_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsocial_network_account_friends_id_seq OWNED BY tsocial_network_account_friends.id;


--
-- Name: tsocial_network_accounts; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsocial_network_accounts (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    network_id bigint NOT NULL,
    fid character varying(256),
    access_token character varying(512),
    fid2 character varying(128),
    export_token character varying(1000),
    export_info text,
    export_expires timestamp without time zone,
    do_publish bigint DEFAULT 0 NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_mo timestamp without time zone
);


ALTER TABLE tsocial_network_accounts OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsocial_network_accounts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_network_accounts_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsocial_network_accounts_id_seq OWNED BY tsocial_network_accounts.id;


--
-- Name: tsocial_networks; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tsocial_networks (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(128) NOT NULL,
    can_post integer NOT NULL,
    can_auth integer NOT NULL,
    can_friends integer NOT NULL
);


ALTER TABLE tsocial_networks OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tsocial_networks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_networks_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tsocial_networks_id_seq OWNED BY tsocial_networks.id;


--
-- Name: tspreadsheets; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tspreadsheets (
    id bigint NOT NULL,
    name character varying(1000),
    file_id bigint,
    date_cr timestamp without time zone,
    generator character varying(64),
    fid bigint NOT NULL
);


ALTER TABLE tspreadsheets OWNER TO sgsystems_erp_gtm;

--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tspreadsheets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tspreadsheets_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tspreadsheets_id_seq OWNED BY tspreadsheets.id;


--
-- Name: ttemplate_place_types; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE ttemplate_place_types (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE ttemplate_place_types OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE ttemplate_place_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_place_types_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE ttemplate_place_types_id_seq OWNED BY ttemplate_place_types.id;


--
-- Name: ttemplate_places; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE ttemplate_places (
    id bigint NOT NULL,
    template_id bigint NOT NULL,
    place_type_id bigint NOT NULL,
    ordering bigint NOT NULL,
    code character varying(64) NOT NULL,
    name character varying(64),
    admin_height integer DEFAULT 20 NOT NULL,
    templatewide integer DEFAULT 0 NOT NULL,
    preprocess integer DEFAULT 0 NOT NULL,
    href character varying(1024)
);


ALTER TABLE ttemplate_places OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE ttemplate_places_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE ttemplate_places_id_seq OWNED BY ttemplate_places.id;


--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE ttemplate_places_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE ttemplate_places_ordering_seq OWNED BY ttemplate_places.ordering;


--
-- Name: ttemplate_places_templatewide; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE ttemplate_places_templatewide (
    id bigint NOT NULL,
    place_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    medium_id bigint NOT NULL,
    body text
);


ALTER TABLE ttemplate_places_templatewide OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE ttemplate_places_templatewide_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_templatewide_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE ttemplate_places_templatewide_id_seq OWNED BY ttemplate_places_templatewide.id;


--
-- Name: ttemplates; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE ttemplates (
    id bigint NOT NULL,
    code character varying(128),
    name character varying(128) NOT NULL
);


ALTER TABLE ttemplates OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplates_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE ttemplates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplates_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: ttemplates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE ttemplates_id_seq OWNED BY ttemplates.id;


--
-- Name: tuser_agents; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tuser_agents (
    id bigint NOT NULL,
    name character varying(1000) NOT NULL,
    is_robot integer NOT NULL,
    device_type integer NOT NULL
);


ALTER TABLE tuser_agents OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_agents_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tuser_agents_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_agents_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_agents_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tuser_agents_id_seq OWNED BY tuser_agents.id;


--
-- Name: tuser_sessions; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tuser_sessions (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    sid character varying(48) NOT NULL,
    date_exp timestamp without time zone NOT NULL
);


ALTER TABLE tuser_sessions OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tuser_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_sessions_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tuser_sessions_id_seq OWNED BY tuser_sessions.id;


--
-- Name: tvisits; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tvisits (
    id bigint NOT NULL,
    user_id bigint,
    anon_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    baseurl character varying(1000) NOT NULL,
    params character varying(1000),
    user_agent_id bigint NOT NULL,
    ip inet NOT NULL
);


ALTER TABLE tvisits OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_urls_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tuser_urls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_urls_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tuser_urls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tuser_urls_id_seq OWNED BY tvisits.id;


--
-- Name: tusers; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tusers (
    id bigint NOT NULL,
    login character varying(64) NOT NULL,
    first_name character varying(64),
    second_name character varying(64),
    last_name character varying(64),
    calc_full_name character varying(256),
    password character varying(64),
    enabled integer NOT NULL,
    email character varying(64),
    calc_no_roles integer NOT NULL,
    sex_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_birth date,
    im_icq character varying(16),
    im_jabber character varying(48),
    im_msn character varying(48),
    im_skype character varying(48),
    phone character varying(48),
    date_last_page timestamp without time zone,
    avatar_id bigint,
    about text,
    regsid character varying(64),
    prefer_l10n_id bigint,
    im_telegram character varying(32)
);


ALTER TABLE tusers OWNER TO sgsystems_erp_gtm;

--
-- Name: tusers_enrolled; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tusers_enrolled (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE tusers_enrolled OWNER TO sgsystems_erp_gtm;

--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tusers_enrolled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tusers_enrolled_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tusers_enrolled_id_seq OWNED BY tusers_enrolled.id;


--
-- Name: tusers_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tusers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tusers_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tusers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tusers_id_seq OWNED BY tusers.id;


--
-- Name: tworksheets; Type: TABLE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE TABLE tworksheets (
    id bigint NOT NULL,
    spreadsheet_id bigint NOT NULL,
    name character varying(1000),
    ordering bigint NOT NULL
);


ALTER TABLE tworksheets OWNER TO sgsystems_erp_gtm;

--
-- Name: tworksheets_id_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tworksheets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tworksheets_id_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tworksheets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tworksheets_id_seq OWNED BY tworksheets.id;


--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE SEQUENCE tworksheets_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tworksheets_ordering_seq OWNER TO sgsystems_erp_gtm;

--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER SEQUENCE tworksheets_ordering_seq OWNED BY tworksheets.ordering;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets ALTER COLUMN id SET DEFAULT nextval('tadmin_start_widgets_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets ALTER COLUMN ordering SET DEFAULT nextval('tadmin_start_widgets_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_model_types ALTER COLUMN id SET DEFAULT nextval('tallowed_model_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_value_types ALTER COLUMN id SET DEFAULT nextval('tallowed_value_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tanon_cookies ALTER COLUMN id SET DEFAULT nextval('tanon_cookies_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories ALTER COLUMN id SET DEFAULT nextval('tarticle_categories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n ALTER COLUMN id SET DEFAULT nextval('tarticle_categories_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles ALTER COLUMN id SET DEFAULT nextval('tarticles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles_l10n ALTER COLUMN id SET DEFAULT nextval('tarticles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tbase_padding_principles ALTER COLUMN id SET DEFAULT nextval('tbase_padding_principles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tbraids ALTER COLUMN id SET DEFAULT nextval('tbraids_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_items ALTER COLUMN id SET DEFAULT nextval('tcart_items_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods ALTER COLUMN id SET DEFAULT nextval('tcart_payment_methods_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n ALTER COLUMN id SET DEFAULT nextval('tcart_payment_methods_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states ALTER COLUMN id SET DEFAULT nextval('tcart_states_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n ALTER COLUMN id SET DEFAULT nextval('tcart_states_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts ALTER COLUMN id SET DEFAULT nextval('tcarts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcells ALTER COLUMN id SET DEFAULT nextval('tcells_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes ALTER COLUMN ordering SET DEFAULT nextval('tcontent_boxes_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items ALTER COLUMN id SET DEFAULT nextval('tcustom_nav_items_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items ALTER COLUMN ordering SET DEFAULT nextval('tcustom_nav_items_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n ALTER COLUMN id SET DEFAULT nextval('tcustom_nav_items_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_navs ALTER COLUMN id SET DEFAULT nextval('tcustom_navs_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tdebug_requests ALTER COLUMN id SET DEFAULT nextval('tdebug_requests_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tedit_histories ALTER COLUMN id SET DEFAULT nextval('tedit_histories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY texplications ALTER COLUMN id SET DEFAULT nextval('texplications_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities ALTER COLUMN id SET DEFAULT nextval('tfacilities_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities ALTER COLUMN ordering SET DEFAULT nextval('tfacilities_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images ALTER COLUMN id SET DEFAULT nextval('tfacility_comment_images_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comments ALTER COLUMN id SET DEFAULT nextval('tfacility_comments_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_groups ALTER COLUMN id SET DEFAULT nextval('tsensor_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_photos ALTER COLUMN id SET DEFAULT nextval('tfacility_photos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_states ALTER COLUMN id SET DEFAULT nextval('tfacility_states_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_states ALTER COLUMN ordering SET DEFAULT nextval('tfacility_states_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_stats ALTER COLUMN id SET DEFAULT nextval('tfacility_stats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_types ALTER COLUMN id SET DEFAULT nextval('tfacility_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders ALTER COLUMN id SET DEFAULT nextval('tfile_folders_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders ALTER COLUMN ordering SET DEFAULT nextval('tfile_folders_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n ALTER COLUMN id SET DEFAULT nextval('tfile_folders_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_types ALTER COLUMN id SET DEFAULT nextval('tfile_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles ALTER COLUMN id SET DEFAULT nextval('tfiles_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles ALTER COLUMN ordering SET DEFAULT nextval('tfiles_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles_l10n ALTER COLUMN id SET DEFAULT nextval('tfiles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tforms ALTER COLUMN id SET DEFAULT nextval('tforms_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbook_messages ALTER COLUMN id SET DEFAULT nextval('tguestbook_messages_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks ALTER COLUMN id SET DEFAULT nextval('tguestbooks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tkvcache ALTER COLUMN id SET DEFAULT nextval('tkvcache_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tl10n ALTER COLUMN id SET DEFAULT nextval('tl10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tlogin_attempts ALTER COLUMN id SET DEFAULT nextval('tlogin_attempts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates ALTER COLUMN id SET DEFAULT nextval('tmail_templates_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n ALTER COLUMN id SET DEFAULT nextval('tmail_templates_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories ALTER COLUMN id SET DEFAULT nextval('tmarket_categories_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories ALTER COLUMN ordering SET DEFAULT nextval('tmarket_categories_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_categories_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes ALTER COLUMN id SET DEFAULT nextval('tmarket_field_datatypes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums ALTER COLUMN id SET DEFAULT nextval('tmarket_field_enums_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl ALTER COLUMN id SET DEFAULT nextval('tmarket_field_enumsl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups ALTER COLUMN id SET DEFAULT nextval('tmarket_field_groups_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups ALTER COLUMN ordering SET DEFAULT nextval('tmarket_field_groups_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_field_groups_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields ALTER COLUMN id SET DEFAULT nextval('tmarket_fields_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields ALTER COLUMN ordering SET DEFAULT nextval('tmarket_fields_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_fields_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_enums_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_enumsl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_f_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_i_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_il_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_s_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_sl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups ALTER COLUMN id SET DEFAULT nextval('tmarket_item_groups_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups ALTER COLUMN ordering SET DEFAULT nextval('tmarket_item_groups_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_item_groups_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items ALTER COLUMN id SET DEFAULT nextval('tmarket_items_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items ALTER COLUMN ordering SET DEFAULT nextval('tmarket_items_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_items_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers ALTER COLUMN id SET DEFAULT nextval('tmarket_manufacturers_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers ALTER COLUMN ordering SET DEFAULT nextval('tmarket_manufacturers_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_manufacturers_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels ALTER COLUMN id SET DEFAULT nextval('tmarket_search_levels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_search_levels_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels ALTER COLUMN id SET DEFAULT nextval('tmarket_view_levels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_view_levels_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_modes ALTER COLUMN id SET DEFAULT nextval('tmeasurement_modes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods ALTER COLUMN id SET DEFAULT nextval('tfmeasurement_periods_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types ALTER COLUMN id SET DEFAULT nextval('tmeasurer_value_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums ALTER COLUMN id SET DEFAULT nextval('tmediums_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums ALTER COLUMN ordering SET DEFAULT nextval('tmediums_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormative_types ALTER COLUMN id SET DEFAULT nextval('tnormatives_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormatives ALTER COLUMN id SET DEFAULT nextval('tnormatives_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpage_blocks ALTER COLUMN id SET DEFAULT nextval('tpage_blocks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages ALTER COLUMN id SET DEFAULT nextval('tpages_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages ALTER COLUMN ordering SET DEFAULT nextval('tpages_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages_l10n ALTER COLUMN id SET DEFAULT nextval('tpages_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors ALTER COLUMN id SET DEFAULT nextval('tpayment_service_errors_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices ALTER COLUMN id SET DEFAULT nextval('tpayment_service_invoices_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplan_formats ALTER COLUMN id SET DEFAULT nextval('tplan_formats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans ALTER COLUMN id SET DEFAULT nextval('tplans_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY treferences ALTER COLUMN id SET DEFAULT nextval('treferences_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY treferences ALTER COLUMN ordering SET DEFAULT nextval('treferences_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY trewrites ALTER COLUMN id SET DEFAULT nextval('trewrites_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles ALTER COLUMN id SET DEFAULT nextval('troles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles_l10n ALTER COLUMN id SET DEFAULT nextval('troles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images ALTER COLUMN id SET DEFAULT nextval('tsensor_comment_images_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comments ALTER COLUMN id SET DEFAULT nextval('tsensor_comments_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_groups ALTER COLUMN id SET DEFAULT nextval('tsensor_groups_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers ALTER COLUMN id SET DEFAULT nextval('tsensor_model_measurers_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers ALTER COLUMN ordering SET DEFAULT nextval('tsensor_model_measurers_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives ALTER COLUMN id SET DEFAULT nextval('tsensor_model_normatives_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_types ALTER COLUMN id SET DEFAULT nextval('tsensor_model_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_models ALTER COLUMN id SET DEFAULT nextval('tsensor_models_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_photos ALTER COLUMN id SET DEFAULT nextval('tsensor_photos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_states ALTER COLUMN id SET DEFAULT nextval('tsensor_states_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_values ALTER COLUMN id SET DEFAULT nextval('tsensor_values_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors ALTER COLUMN id SET DEFAULT nextval('tsensors_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes ALTER COLUMN id SET DEFAULT nextval('tsexes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes_l10n ALTER COLUMN id SET DEFAULT nextval('tsexes_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends ALTER COLUMN id SET DEFAULT nextval('tsocial_network_account_friends_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts ALTER COLUMN id SET DEFAULT nextval('tsocial_network_accounts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_networks ALTER COLUMN id SET DEFAULT nextval('tsocial_networks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tspreadsheets ALTER COLUMN id SET DEFAULT nextval('tspreadsheets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types ALTER COLUMN id SET DEFAULT nextval('ttemplate_place_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places ALTER COLUMN id SET DEFAULT nextval('ttemplate_places_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places ALTER COLUMN ordering SET DEFAULT nextval('ttemplate_places_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide ALTER COLUMN id SET DEFAULT nextval('ttemplate_places_templatewide_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplates ALTER COLUMN id SET DEFAULT nextval('ttemplates_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_agents ALTER COLUMN id SET DEFAULT nextval('tuser_agents_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_sessions ALTER COLUMN id SET DEFAULT nextval('tuser_sessions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers ALTER COLUMN id SET DEFAULT nextval('tusers_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers_enrolled ALTER COLUMN id SET DEFAULT nextval('tusers_enrolled_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tvisits ALTER COLUMN id SET DEFAULT nextval('tuser_urls_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tworksheets ALTER COLUMN id SET DEFAULT nextval('tworksheets_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tworksheets ALTER COLUMN ordering SET DEFAULT nextval('tworksheets_ordering_seq'::regclass);


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY spatial_ref_sys  FROM stdin;
\.


--
-- Data for Name: tadmin_start_widgets; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tadmin_start_widgets (id, controller_name, controller_mode, fullscreen, ordering) FROM stdin;
1	AdminStart	coolbg	1	1
\.


--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tadmin_start_widgets_id_seq', 2, true);


--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tadmin_start_widgets_ordering_seq', 2, true);


--
-- Data for Name: tallowed_model_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tallowed_model_types (id, sensor_model_id, sensor_model_type_id, code, has_braid, has_own_values, ordering, can_be_retranslator, name, braid_measurer_id) FROM stdin;
8	14	5	ts_vert	1	0	14	1	ТС (вертикальная)	2
11	14	7	ts_slop	1	0	12	1	ТС (наклонная)	2
12	10	1	gdm	0	1	3	0	ГДМ	5
4	10	2	gdm_inc	0	1	4	0	ГДМ (инкл)	5
6	13	4	dm_fatty	0	1	5	0	ДМ (наварная)	\N
13	13	8	dm_concrete	0	1	11	0	ДМ (в бетоне)	\N
1	8	1	rp	\N	1	1	1	Репер	\N
2	9	1	ps	\N	1	2	\N	ПС	\N
7	13	2	dm_inc	\N	1	7	1	ДМ (инкл)	\N
5	13	3	dm_paint	\N	1	6	\N	ДМ (краской)	\N
9	14	6	ts_hor	1	0	13	1	ТС (горизонтальная)	2
\.


--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tallowed_model_types_id_seq', 13, true);


--
-- Data for Name: tallowed_value_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tallowed_value_types (id, measure_id, allowed_model_type_id, code, accuracy, name) FROM stdin;
4	6	4	s	4	Угол 2
5	5	5	h	4	Высота
8	6	7	s	4	Угол 2
7	6	7	h	4	Угол 1
3	6	4	h	4	Угол 1
2	7	2	h	2	УГВ
1	5	1	h	4	Высота
6	5	6	h	0	Высота
13	5	12	h	2	Высота 2
12	5	12	h	4	Высота 1
\.


--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tallowed_value_types_id_seq', 13, true);


--
-- Data for Name: tanon_cookies; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tanon_cookies (id, date_cr, user_agent_id, sid, ip) FROM stdin;
\.


--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tanon_cookies_id_seq', 1, false);


--
-- Data for Name: tarticle_categories; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tarticle_categories (id, code, groupcode, has_abstract, has_image1, has_image2, has_gallery, image1_id, image2_id) FROM stdin;
\.


--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tarticle_categories_id_seq', 1, false);


--
-- Data for Name: tarticle_categories_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tarticle_categories_l10n (id, fid_id, l10n_id, name, abstract, body) FROM stdin;
\.


--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tarticle_categories_l10n_id_seq', 1, false);


--
-- Data for Name: tarticles; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tarticles (id, date_cr, date_use, date_show_start, date_show_end, category_id, calc_code, image1_id, image2_id, image3_id, folder_id, enabled, featured, user_cr_id) FROM stdin;
\.


--
-- Name: tarticles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tarticles_id_seq', 1, false);


--
-- Data for Name: tarticles_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tarticles_l10n (id, fid_id, l10n_id, name, abstract, body, disabled_l10n, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tarticles_l10n_id_seq', 1, false);


--
-- Data for Name: tbase_padding_principles; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tbase_padding_principles (id, name) FROM stdin;
1	&#8544;
2	&#8545;
\.


--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tbase_padding_principles_id_seq', 1, true);


--
-- Data for Name: tbraids; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tbraids (id, sensor_id, deep, enabled) FROM stdin;
494	381	11.0	1
495	381	0.0	1
496	381	1.0	1
497	381	2.0	1
498	381	3.0	1
499	381	4.0	1
500	381	5.0	1
501	381	6.0	1
502	381	7.0	1
503	381	8.0	1
504	381	9.0	1
505	381	10.0	1
506	382	5.0	1
507	382	0.0	1
508	382	1.0	1
509	382	2.0	1
510	382	3.0	1
511	382	4.0	1
512	383	10.0	1
513	383	0.0	1
514	383	1.0	1
515	383	2.0	1
516	383	3.0	1
517	383	4.0	1
518	383	5.0	1
519	383	6.0	1
520	383	7.0	1
521	383	8.0	1
522	383	9.0	1
523	384	10.0	1
524	384	0.0	1
525	384	1.0	1
526	384	2.0	1
527	384	3.0	1
528	384	4.0	1
529	384	5.0	1
530	384	6.0	1
531	384	7.0	1
532	384	8.0	1
533	384	9.0	1
534	385	10.0	1
535	385	0.0	1
536	385	1.0	1
537	385	2.0	1
538	385	3.0	1
539	385	4.0	1
540	385	5.0	1
541	385	6.0	1
542	385	7.0	1
543	385	8.0	1
544	385	9.0	1
545	386	5.0	1
546	386	0.0	1
547	386	1.0	1
548	386	2.0	1
549	386	3.0	1
550	386	4.0	1
551	387	10.0	1
552	387	0.0	1
553	387	1.0	1
554	387	2.0	1
555	387	3.0	1
556	387	4.0	1
557	387	5.0	1
558	387	6.0	1
559	387	7.0	1
560	387	8.0	1
561	387	9.0	1
562	393	10.0	1
563	393	0.0	1
564	393	1.0	1
565	393	2.0	1
566	393	3.0	1
567	393	4.0	1
568	393	5.0	1
569	393	6.0	1
570	393	7.0	1
571	393	8.0	1
572	393	9.0	1
573	402	10.0	1
574	402	0.0	1
575	402	1.0	1
576	402	2.0	1
577	402	3.0	1
578	402	4.0	1
579	402	5.0	1
580	402	6.0	1
581	402	7.0	1
582	402	8.0	1
583	402	9.0	1
584	403	10.0	1
585	403	0.0	1
586	403	1.0	1
587	403	2.0	1
588	403	3.0	1
589	403	4.0	1
590	403	5.0	1
591	403	6.0	1
592	403	7.0	1
593	403	8.0	1
594	403	9.0	1
595	404	10.0	1
596	404	0.0	1
597	404	0.5	1
598	404	1.0	1
599	404	1.5	1
600	404	2.0	1
601	404	2.5	1
602	404	3.0	1
603	404	3.5	1
604	404	4.0	1
605	404	4.5	1
606	404	5.0	1
607	404	5.5	1
608	404	6.0	1
609	404	6.5	1
610	404	7.0	1
611	404	7.5	1
612	404	8.0	1
613	404	8.5	1
614	404	9.0	1
615	404	9.5	1
616	405	15.0	1
617	405	0.0	1
618	405	0.5	1
619	405	1.0	1
620	405	1.5	1
621	405	2.0	1
622	405	2.5	1
623	405	3.0	1
624	405	3.5	1
625	405	4.0	1
626	405	4.5	1
627	405	5.0	1
628	405	5.5	1
629	405	6.0	1
630	405	6.5	1
631	405	7.0	1
632	405	7.5	1
633	405	8.0	1
634	405	8.5	1
635	405	9.0	1
636	405	9.5	1
637	405	10.0	1
638	405	10.5	1
639	405	11.0	1
640	405	11.5	1
641	405	12.0	1
642	405	12.5	1
643	405	13.0	1
644	405	13.5	1
645	405	14.0	1
646	405	14.5	1
647	406	15.0	1
648	406	0.0	1
649	406	0.5	1
650	406	1.0	1
651	406	1.5	1
652	406	2.0	1
653	406	2.5	1
654	406	3.0	1
655	406	3.5	1
656	406	4.0	1
657	406	4.5	1
658	406	5.0	1
659	406	5.5	1
660	406	6.0	1
661	406	6.5	1
662	406	7.0	1
663	406	7.5	1
664	406	8.0	1
665	406	8.5	1
666	406	9.0	1
667	406	9.5	1
668	406	10.0	1
669	406	10.5	1
670	406	11.0	1
671	406	11.5	1
672	406	12.0	1
673	406	12.5	1
674	406	13.0	1
675	406	13.5	1
676	406	14.0	1
677	406	14.5	1
678	407	10.0	1
679	407	0.0	1
680	407	0.5	1
681	407	1.0	1
682	407	1.5	1
683	407	2.0	1
684	407	2.5	1
685	407	3.0	1
686	407	3.5	1
687	407	4.0	1
688	407	4.5	1
689	407	5.0	1
690	407	5.5	1
691	407	6.0	1
692	407	6.5	1
693	407	7.0	1
694	407	7.5	1
695	407	8.0	1
696	407	8.5	1
697	407	9.0	1
698	407	9.5	1
699	408	5.0	1
700	408	0.0	1
701	408	1.0	1
702	408	2.0	1
703	408	3.0	1
704	408	4.0	1
705	409	3.0	1
706	409	0.0	1
707	409	1.0	1
708	409	2.0	1
709	414	2.0	1
710	414	0.0	1
711	414	1.0	1
712	415	2.0	1
713	415	0.0	1
714	415	1.0	1
715	421	5.0	1
716	421	0.0	1
717	423	11.0	1
718	423	0.0	1
719	423	0.5	1
720	423	1.0	1
721	423	1.5	1
722	423	2.0	1
723	423	2.5	1
724	423	3.0	1
725	423	3.5	1
726	423	4.0	1
727	423	4.5	1
728	423	5.0	1
729	423	5.5	1
730	423	6.0	1
731	423	6.5	1
732	423	7.0	1
733	423	7.5	1
734	423	8.0	1
735	423	8.5	1
736	423	9.0	1
737	423	9.5	1
738	423	10.0	1
739	423	10.5	1
740	425	3.0	1
741	425	0.0	1
742	426	3.0	1
743	426	0.0	1
744	427	3.0	1
745	427	0.0	1
746	428	3.0	1
747	428	0.0	1
\.


--
-- Name: tbraids_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tbraids_id_seq', 747, true);


--
-- Data for Name: tcart_items; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcart_items (id, cart_id, market_item_id, cnt, other_ftype, other_fid, price, amount) FROM stdin;
\.


--
-- Name: tcart_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcart_items_id_seq', 1, false);


--
-- Data for Name: tcart_payment_methods; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcart_payment_methods (id, code, func, prepay, enabled) FROM stdin;
1	courier	\N	0	1
2	robokassa	robokassa	1	1
\.


--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcart_payment_methods_id_seq', 2, true);


--
-- Data for Name: tcart_payment_methods_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcart_payment_methods_l10n (id, fid_id, l10n_id, name, body) FROM stdin;
\.


--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcart_payment_methods_l10n_id_seq', 1, false);


--
-- Data for Name: tcart_states; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcart_states (id, code, cssclass, do_calc_money) FROM stdin;
1	fill	cart-fill	0
2	sent	cart-sent	1
3	checked	cart-checked	1
4	assemble	cart-assemble	1
5	transfer	cart-transfer	1
6	done	cart-done	1
7	canceled	cart-canceled	0
\.


--
-- Name: tcart_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcart_states_id_seq', 7, true);


--
-- Data for Name: tcart_states_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcart_states_l10n (id, fid_id, l10n_id, name, body) FROM stdin;
1	1	1	Наполняется	\N
2	2	1	Отправлена менеджеру	\N
3	3	1	Проверена менеджером	\N
4	4	1	Собирается на складе	\N
5	5	1	Доставляется	\N
6	6	1	Доставлена	\N
7	7	1	Отменена	\N
\.


--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcart_states_l10n_id_seq', 7, true);


--
-- Data for Name: tcarts; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcarts (id, user_id, sid, state_id, date_cr, date_mo, date_sent, date_state_change, payment_method_id, manager_id, calc_summ, calc_items, calc_amount, address_postalindex, address_city, address_street, address_phone, address_comments, address_nearest, address_flat, address_porch, address_floor, address_password, required_change, real_payed) FROM stdin;
\.


--
-- Name: tcarts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcarts_id_seq', 1, false);


--
-- Data for Name: tcells; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcells (id, worksheet_id, x, y, value) FROM stdin;
\.


--
-- Name: tcells_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcells_id_seq', 1, false);


--
-- Data for Name: tcontent_boxes; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcontent_boxes (id, group_id, ordering, image_id, image2_id, enabled) FROM stdin;
\.


--
-- Data for Name: tcontent_boxes_groups; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcontent_boxes_groups (id, code, name) FROM stdin;
\.


--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_groups_id_seq', 1, false);


--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_id_seq', 1, false);


--
-- Data for Name: tcontent_boxes_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcontent_boxes_l10n (id, fid_id, l10n_id, override_image_id, name, name2, name3, url) FROM stdin;
\.


--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_l10n_id_seq', 1, false);


--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_ordering_seq', 1, false);


--
-- Data for Name: tcustom_nav_items; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcustom_nav_items (id, nav_id, parent_id, image_id, href, page_id, enabled, ordering) FROM stdin;
\.


--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_id_seq', 1, false);


--
-- Data for Name: tcustom_nav_items_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcustom_nav_items_l10n (id, fid_id, l10n_id, name, description) FROM stdin;
\.


--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_l10n_id_seq', 1, false);


--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_ordering_seq', 1, false);


--
-- Data for Name: tcustom_navs; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tcustom_navs (id, code, name, can_href, can_image, can_description) FROM stdin;
\.


--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tcustom_navs_id_seq', 1, false);


--
-- Data for Name: tdb_version; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tdb_version (version) FROM stdin;
1
\.


--
-- Data for Name: tdebug_requests; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tdebug_requests (id, login, password, url, date_cr, params, user_id, user_agent_id, error, version, charge) FROM stdin;
\.


--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tdebug_requests_id_seq', 1, false);


--
-- Data for Name: tedit_histories; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tedit_histories (id, model_name, text, data, facility_id, date_cr, user_id, model_id) FROM stdin;
6274	Facility	Создан новый объект "ЦПС_ОГТМ"	{"id":116,"parent_id":"","name":"ЦПС_ОГТМ","location_x":50,"location_y":50,"plan_id":"65","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	116	2017-01-17 10:13:22.447193	13	116
6275	Facility	Создан новый объект "Поз.9.1 Совмещенная факельная установка h=50м"	{"id":117,"parent_id":"116","name":"Поз.9.1 Совмещенная факельная установка h=50м","location_x":50,"location_y":50,"plan_id":"66","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	117	2017-01-17 10:13:58.855853	13	117
6276	Facility	Создан новый объект "ЦПС_ОГТМ"	{"id":118,"parent_id":"","name":"ЦПС_ОГТМ","location_x":50,"location_y":50,"plan_id":"65","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	118	2017-01-17 13:53:40.41976	13	118
6277	Facility	Создан новый объект "ЦПС_ОГТМ"	{"id":119,"parent_id":"","name":"ЦПС_ОГТМ","location_x":50,"location_y":50,"plan_id":"71","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	119	2017-01-17 13:56:14.916281	13	119
6278	Facility	Создан новый объект "поз 9.1_Совмещенная факельная установка h=50м"	{"id":120,"parent_id":"119","name":"поз 9.1_Совмещенная факельная установка h=50м","location_x":50,"location_y":50,"plan_id":"65","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	120	2017-01-17 13:57:13.99698	13	120
6279	Facility	Создан новый объект "поз. 9.1_Совмещенная факельная установка"	{"id":121,"parent_id":"119","name":"поз. 9.1_Совмещенная факельная установка","location_x":50,"location_y":50,"plan_id":"66","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	121	2017-01-17 13:58:39.533368	13	121
6280	Facility	Создан новый объект "Площадка ЦПС"	{"id":122,"parent_id":"","name":"Площадка ЦПС","location_x":50,"location_y":50,"plan_id":"71","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-01-18 07:53:17.902263	13	122
6358	SensorValue	Высота, мм элемента {Дм3} на 25-01-2017 = 355.564	{"id":4106,"sensor_id":"392","value":355.564,"date_use":"25-01-2017","allowed_value_type_id":"5"}	127	2017-01-25 13:55:00.287648	13	4106
6281	Facility	Создан новый объект "поз. 9.1 Факельная установка h=50м"	{"id":123,"parent_id":"122","name":"поз. 9.1 Факельная установка h=50м","location_x":50,"location_y":50,"plan_id":"66","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-01-18 07:54:55.942856	13	123
6282	Sensor	Создан новый элемент Репер "тест"	{"id":380,"facility_id":"123","name":"тест","location_x":666,"location_y":351,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-19 19:53:28.412838	3	380
6283	Facility	Создан новый объект "Подобъект"	{"id":124,"parent_id":"122","name":"Подобъект","location_x":50,"location_y":50,"plan_id":"65","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	124	2017-01-19 19:54:05.927268	3	124
6284	Facility	Создан новый объект "Участок перехода через р. Большая Хета"	{"id":125,"parent_id":"","name":"Участок перехода через р. Большая Хета","location_x":50,"location_y":50,"plan_id":"73","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/812.jpg","jpg_id":812,"pdf_url":"/f/14/810.pdf","calc_pdf_url":"/f/14/811.pdf","pdf_id":810,"plan":{"id":73,"name":"Переход Б Хета_Схема (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":810,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/810.pdf","jpg_id":812,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/812.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":811,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/811.pdf"},"urn_encoded":null}	125	2017-01-24 15:07:11.431617	13	125
6285	Facility	Создан новый объект "ПК143+25.68-ПК146+25.68"	{"id":126,"parent_id":"125","name":"ПК143+25.68-ПК146+25.68","location_x":50,"location_y":50,"plan_id":"74","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf"},"urn_encoded":null}	126	2017-01-24 15:08:55.664939	13	126
6286	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":125,"parent_id":null,"name":"Участок перехода через р. Большая Хета","ordering":125,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":50,"location_y":50,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":73,"plan_name":"Переход Б Хета_Схема","view_data":null,"table_x":250,"table_y":50,"element_size":0.75,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/812.jpg","jpg_id":812,"pdf_url":"/f/14/810.pdf","calc_pdf_url":"/f/14/811.pdf","pdf_id":810,"plan":{"id":73,"name":"Переход Б Хета_Схема (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":810,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/810.pdf","jpg_id":812,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/812.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":811,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/811.pdf"},"urn_encoded":null}	125	2017-01-24 15:09:30.677307	13	125
6294	Sensor	Создан новый элемент ТС (вертикальная) "ТС№7"	{"id":384,"facility_id":"126","name":"ТС№7","location_x":1182,"location_y":210,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:57:32.86455	13	384
6295	Sensor	Создан новый элемент ТС (вертикальная) "ТС№6"	{"id":385,"facility_id":"126","name":"ТС№6","location_x":1223,"location_y":145,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:58:29.109016	13	385
6296	Sensor	Создан новый элемент ГДМ (инкл) "ГДМ№2"	{"id":386,"facility_id":"126","name":"ГДМ№2","location_x":1187,"location_y":172,"allowed_model_type_id":"4","state_id":"1","is_retranslator":"0","deep":5,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:58:59.448312	13	386
6359	SensorValue	Температура элемента {ТС№12} на глубине 0(м), на 25-01-2017 = -1	{"id":4107,"sensor_id":"393","value":-1,"date_use":"25-01-2017","braid_id":"563"}	127	2017-01-25 13:55:00.287648	13	4107
6287	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":125,"parent_id":null,"name":"Участок перехода через р. Большая Хета","ordering":125,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":73,"plan_name":"Переход Б Хета_Схема","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/812.jpg","jpg_id":812,"pdf_url":"/f/14/810.pdf","calc_pdf_url":"/f/14/811.pdf","pdf_id":810,"plan":{"id":73,"name":"Переход Б Хета_Схема (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":810,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/810.pdf","jpg_id":812,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/812.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":811,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/811.pdf"},"urn_encoded":null}	125	2017-01-24 15:09:36.543996	13	125
6288	Facility	Создан новый объект "ПК146+25.68-ПК149+25.68"	{"id":127,"parent_id":"125","name":"ПК146+25.68-ПК149+25.68","location_x":50,"location_y":50,"plan_id":"75","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf"},"urn_encoded":null}	127	2017-01-24 15:12:08.385869	13	127
6289	Sensor	Создан новый элемент ТС (вертикальная) "ТС№9"	{"id":381,"facility_id":"126","name":"ТС№9","location_x":1033,"location_y":214,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":11,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:54:05.945714	13	381
6290	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":776,"location_y":846,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":74,"plan_name":"Б_Хета_лист 3","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf"},"urn_encoded":null}	126	2017-01-24 15:54:19.788642	13	126
6291	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":776,"location_y":846,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":74,"plan_name":"Б_Хета_лист 3","view_data":null,"table_x":250,"table_y":50,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":132,"convention_y":142,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf"},"urn_encoded":null}	126	2017-01-24 15:54:52.297572	13	126
6292	Sensor	Создан новый элемент ГДМ (инкл) "ГДМ№1"	{"id":382,"facility_id":"126","name":"ГДМ№1","location_x":976,"location_y":225,"allowed_model_type_id":"4","state_id":"1","is_retranslator":"0","deep":5,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:55:22.851557	13	382
6293	Sensor	Создан новый элемент ТС (вертикальная) "ТС№8"	{"id":383,"facility_id":"126","name":"ТС№8","location_x":1131,"location_y":137,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:57:04.289384	13	383
6331	SensorValue	Температура элемента {ТС№6} на глубине 10(м), на 16-01-2017 = 4	{"id":4087,"sensor_id":385,"value":4,"date_use":"16-01-2017","braid_id":534}	126	2017-01-25 10:32:41.690791	13	4087
6297	Sensor	Создан новый элемент ТС (вертикальная) "ТС№5"	{"id":387,"facility_id":"126","name":"ТС№5","location_x":1513,"location_y":173,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 15:59:56.200009	13	387
6298	Sensor	Создан новый элемент ДМ (наварной) "ДМ(N°3а-3)"	{"id":388,"facility_id":"126","name":"ДМ(N°3а-3)","location_x":1539,"location_y":153,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	126	2017-01-24 16:00:28.888049	13	388
6299	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":504,"location_y":803,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":250,"table_y":50,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf"},"urn_encoded":null}	127	2017-01-24 16:03:14.979857	13	127
6300	Sensor	Создан новый элемент Репер "РП№4"	{"id":389,"facility_id":"127","name":"РП№4","location_x":1345,"location_y":242,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:04:32.035869	13	389
6301	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":504,"location_y":803,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf"},"urn_encoded":null}	127	2017-01-24 16:04:49.323957	13	127
6302	Sensor	Создан новый элемент ДМ (наварной) "Дм"	{"id":390,"facility_id":"127","name":"Дм","location_x":1237,"location_y":322,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:05:42.244325	13	390
6303	Sensor	Создан новый элемент ДМ (краской) "Дм2"	{"id":391,"facility_id":"127","name":"Дм2","location_x":1193,"location_y":337,"allowed_model_type_id":"5","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:07:24.924066	13	391
6304	Sensor	Создан новый элемент ДМ (краской) "Дм3"	{"id":392,"facility_id":"127","name":"Дм3","location_x":1222,"location_y":233,"allowed_model_type_id":"5","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:07:42.214667	13	392
6305	Sensor	Создан новый элемент ТС (вертикальная) "ТС№12"	{"id":393,"facility_id":"127","name":"ТС№12","location_x":944,"location_y":207,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:08:12.095134	13	393
6306	Sensor	Создан новый элемент ДМ (наварной) "Дм4"	{"id":394,"facility_id":"127","name":"Дм4","location_x":1351,"location_y":147,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":180,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:08:49.476828	13	394
6307	Sensor	Создан новый элемент ДМ (наварной) "Дм5"	{"id":395,"facility_id":"127","name":"Дм5","location_x":1196,"location_y":135,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:10:03.407052	13	395
6332	SensorValue	Температура элемента {ТС№6} на глубине 10(м), на 16-01-2017 = 4	{"id":4087,"sensor_id":385,"sensor_name":"ТС№6","date_cr":"25.01.2017 10:32:41","value":4,"date_use":"16-01-2017","braid_id":534,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	126	2017-01-25 10:32:42.502603	13	4087
6360	SensorValue	Температура элемента {ТС№12} на глубине 2(м), на 25-01-2017 = -2	{"id":4108,"sensor_id":"393","value":-2,"date_use":"25-01-2017","braid_id":"565"}	127	2017-01-25 13:55:00.287648	13	4108
6308	Sensor	Параметр элемента {Дм5} "Угол" изменен на "180"\n	{"id":395,"facility_id":127,"facility_name":"ПК146+25.68-ПК149+25.68","facility_code":null,"name":"Дм5","location_x":1196,"location_y":135,"location_comments":null,"measurement_mode_name":null,"allowed_model_type_id":6,"allowed_model_type_name":"ДМ (наварной)","allowed_model_type_code":"dm_fatty","state_id":"1","state_name":"Рабочее","state_code":"work","deep":0,"deep_step":0,"image_ext":null,"image_file_folder_id":null,"angle":180,"deleted":null,"pr_sensor_id":null,"pr_sensor_name":null,"reference_date":"","clipmap":null,"comments_length":0,"photos_length":0,"last_value_date":"-","braids":[],"deeps":{}}	127	2017-01-24 16:10:09.809306	13	395
6309	Facility	Создан новый объект "Каталог координат_л.3"	{"id":128,"parent_id":"125","name":"Каталог координат_л.3","location_x":50,"location_y":50,"plan_id":"76","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/821.jpg","jpg_id":821,"pdf_url":"/f/14/819.pdf","calc_pdf_url":"/f/14/820.pdf","pdf_id":819,"plan":{"id":76,"name":"Б Хета_каталог координат (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":819,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/819.pdf","jpg_id":821,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/821.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":820,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/820.pdf"},"urn_encoded":null}	128	2017-01-24 16:13:57.304923	13	128
6310	SensorValue	Температура элемента {ТС№5} на глубине 0(м), на 16-01-2017 = 1	{"id":4066,"sensor_id":387,"value":1,"date_use":"16-01-2017","braid_id":552}	126	2017-01-25 10:32:24.324617	13	4066
6311	SensorValue	Температура элемента {ТС№5} на глубине 1(м), на 16-01-2017 = 2	{"id":4067,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":553}	126	2017-01-25 10:32:25.740789	13	4067
6312	SensorValue	Температура элемента {ТС№5} на глубине 2(м), на 16-01-2017 = 2	{"id":4068,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":554}	126	2017-01-25 10:32:26.7423	13	4068
6313	SensorValue	Температура элемента {ТС№5} на глубине 3(м), на 16-01-2017 = 2	{"id":4069,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":555}	126	2017-01-25 10:32:27.330226	13	4069
6314	SensorValue	Температура элемента {ТС№5} на глубине 4(м), на 16-01-2017 = 2	{"id":4070,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":556}	126	2017-01-25 10:32:27.792668	13	4070
6315	SensorValue	Температура элемента {ТС№5} на глубине 5(м), на 16-01-2017 = 2	{"id":4071,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":557}	126	2017-01-25 10:32:28.21823	13	4071
6316	SensorValue	Температура элемента {ТС№5} на глубине 6(м), на 16-01-2017 = 2	{"id":4072,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":558}	126	2017-01-25 10:32:28.450376	13	4072
6317	SensorValue	Температура элемента {ТС№5} на глубине 7(м), на 16-01-2017 = 2	{"id":4073,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":559}	126	2017-01-25 10:32:28.658327	13	4073
6318	SensorValue	Температура элемента {ТС№5} на глубине 8(м), на 16-01-2017 = 2	{"id":4074,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":560}	126	2017-01-25 10:32:28.853317	13	4074
6319	SensorValue	Температура элемента {ТС№5} на глубине 9(м), на 16-01-2017 = 2	{"id":4075,"sensor_id":387,"value":2,"date_use":"16-01-2017","braid_id":561}	126	2017-01-25 10:32:29.049842	13	4075
6320	SensorValue	Температура элемента {ТС№5} на глубине 10(м), на 16-01-2017 = 22	{"id":4076,"sensor_id":387,"value":22,"date_use":"16-01-2017","braid_id":551}	126	2017-01-25 10:32:30.61265	13	4076
6321	SensorValue	Температура элемента {ТС№6} на глубине 0(м), на 16-01-2017 = 7	{"id":4077,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":535}	126	2017-01-25 10:32:39.606053	13	4077
6322	SensorValue	Температура элемента {ТС№6} на глубине 1(м), на 16-01-2017 = 7	{"id":4078,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":536}	126	2017-01-25 10:32:39.842661	13	4078
6323	SensorValue	Температура элемента {ТС№6} на глубине 2(м), на 16-01-2017 = 7	{"id":4079,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":537}	126	2017-01-25 10:32:40.055329	13	4079
6324	SensorValue	Температура элемента {ТС№6} на глубине 3(м), на 16-01-2017 = 7	{"id":4080,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":538}	126	2017-01-25 10:32:40.264225	13	4080
6325	SensorValue	Температура элемента {ТС№6} на глубине 4(м), на 16-01-2017 = 7	{"id":4081,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":539}	126	2017-01-25 10:32:40.457687	13	4081
6326	SensorValue	Температура элемента {ТС№6} на глубине 5(м), на 16-01-2017 = 7	{"id":4082,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":540}	126	2017-01-25 10:32:40.687762	13	4082
6327	SensorValue	Температура элемента {ТС№6} на глубине 6(м), на 16-01-2017 = 7	{"id":4083,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":541}	126	2017-01-25 10:32:40.878725	13	4083
6328	SensorValue	Температура элемента {ТС№6} на глубине 7(м), на 16-01-2017 = 7	{"id":4084,"sensor_id":385,"value":7,"date_use":"16-01-2017","braid_id":542}	126	2017-01-25 10:32:41.08495	13	4084
6329	SensorValue	Температура элемента {ТС№6} на глубине 8(м), на 16-01-2017 = 65	{"id":4085,"sensor_id":385,"value":65,"date_use":"16-01-2017","braid_id":543}	126	2017-01-25 10:32:41.288677	13	4085
6330	SensorValue	Температура элемента {ТС№6} на глубине 9(м), на 16-01-2017 = 5	{"id":4086,"sensor_id":385,"value":5,"date_use":"16-01-2017","braid_id":544}	126	2017-01-25 10:32:41.495537	13	4086
6333	FacilityComment	Добавлен комментарий к объекту	{"id":102,"facility_id":122,"user_cr_id":13,"body":"Вид с вертолета. Цеха. Позиции 45.3...7","images_json":"{\\"file:///storage/emulated/0/Pictures/IMG_20170125_112006.jpg\\":3}"}	122	2017-01-25 11:37:21.135744	13	102
6334	FacilityComment	Добавлен комментарий к объекту	{"id":103,"facility_id":122,"user_cr_id":13,"body":"Площадка ЦПС. Вид с вертолета. Цеха, поз. 45.3...7","images_json":"{\\"file:///storage/emulated/0/Pictures/IMG_20170125_112649.jpg\\":1}"}	122	2017-01-25 11:37:21.135744	13	103
6335	FacilityComment	Добавлен комментарий к объекту	{"id":104,"facility_id":122,"user_cr_id":13,"body":"Площадка ЦПС. Вид с вертолета, цеха, поз. 45.3...7","images_json":"{\\"file:///storage/emulated/0/Pictures/IMG_20170125_112953.jpg\\":1}"}	122	2017-01-25 11:37:21.135744	13	104
6336	FacilityComment	Добавлен комментарий к объекту	{"id":105,"facility_id":123,"user_cr_id":13,"body":"Факел. Поз. 9.1","images_json":"{\\"file:///storage/emulated/0/Pictures/IMG_20170125_113352.jpg\\":2}"}	123	2017-01-25 11:37:21.135744	13	105
6337	SensorValue	Высота, мм элемента {тест} на 25-01-2017 = 365.407	{"id":4088,"sensor_id":"380","value":365.407,"date_use":"25-01-2017","allowed_value_type_id":"1"}	123	2017-01-25 11:44:25.077037	13	4088
6338	SensorValue	Температура элемента {ТС№5} на глубине 10(м), на 25-01-2017 = -8	{"id":4089,"sensor_id":"387","value":-8,"date_use":"25-01-2017","braid_id":"551"}	126	2017-01-25 11:44:25.077037	13	4089
6339	SensorValue	Высота, мм элемента {ДМ(N°3а-3)} на 25-01-2017 = 365.58	{"id":4090,"sensor_id":"388","value":365.58,"date_use":"25-01-2017","allowed_value_type_id":"6"}	126	2017-01-25 11:44:25.077037	13	4090
6340	FacilityComment	Добавлен комментарий к объекту	{"id":106,"facility_id":127,"user_cr_id":13,"body":"Репер рабочий","images_json":"{}"}	127	2017-01-25 13:54:33.622038	13	106
6341	FacilityComment	Добавлен комментарий к объекту	{"id":107,"facility_id":127,"user_cr_id":13,"body":"Всплытие на участке ПК147...ПК148","images_json":"{\\"file:///storage/emulated/0/Pictures/IMG_20170125_134810.jpg\\":1}"}	127	2017-01-25 13:54:33.622038	13	107
6342	SensorValue	Угол 1, ° элемента {ГДМ№1} на 25-01-2017 = 3	{"id":4091,"sensor_id":"382","value":3,"date_use":"25-01-2017","allowed_value_type_id":"3"}	126	2017-01-25 13:55:00.287648	13	4091
6343	SensorValue	Угол 2, ° элемента {ГДМ№1} на 25-01-2017 = 3	{"id":4092,"sensor_id":"382","value":3,"date_use":"25-01-2017","allowed_value_type_id":"4"}	126	2017-01-25 13:55:00.287648	13	4092
6344	SensorValue	Температура элемента {ТС№7} на глубине 0(м), на 25-01-2017 = -1	{"id":4093,"sensor_id":"384","value":-1,"date_use":"25-01-2017","braid_id":"524"}	126	2017-01-25 13:55:00.287648	13	4093
6345	SensorValue	Температура элемента {ТС№7} на глубине 1(м), на 25-01-2017 = -1	{"id":4094,"sensor_id":"384","value":-1,"date_use":"25-01-2017","braid_id":"525"}	126	2017-01-25 13:55:00.287648	13	4094
6346	SensorValue	Температура элемента {ТС№7} на глубине 2(м), на 25-01-2017 = -2	{"id":4095,"sensor_id":"384","value":-2,"date_use":"25-01-2017","braid_id":"526"}	126	2017-01-25 13:55:00.287648	13	4095
6347	SensorValue	Температура элемента {ТС№7} на глубине 3(м), на 25-01-2017 = -3	{"id":4096,"sensor_id":"384","value":-3,"date_use":"25-01-2017","braid_id":"527"}	126	2017-01-25 13:55:00.287648	13	4096
6348	SensorValue	Температура элемента {ТС№7} на глубине 4(м), на 25-01-2017 = -3	{"id":4097,"sensor_id":"384","value":-3,"date_use":"25-01-2017","braid_id":"528"}	126	2017-01-25 13:55:00.287648	13	4097
6349	SensorValue	Температура элемента {ТС№7} на глубине 5(м), на 25-01-2017 = -5	{"id":4098,"sensor_id":"384","value":-5,"date_use":"25-01-2017","braid_id":"529"}	126	2017-01-25 13:55:00.287648	13	4098
6350	SensorValue	Температура элемента {ТС№7} на глубине 6(м), на 25-01-2017 = -5	{"id":4099,"sensor_id":"384","value":-5,"date_use":"25-01-2017","braid_id":"530"}	126	2017-01-25 13:55:00.287648	13	4099
6351	SensorValue	Температура элемента {ТС№6} на глубине 10(м), на 25-01-2017 = -9	{"id":4100,"sensor_id":"385","value":-9,"date_use":"25-01-2017","braid_id":"534"}	126	2017-01-25 13:55:00.287648	13	4100
6352	SensorValue	Угол 1, ° элемента {ГДМ№2} на 25-01-2017 = 5	{"id":4101,"sensor_id":"386","value":5,"date_use":"25-01-2017","allowed_value_type_id":"3"}	126	2017-01-25 13:55:00.287648	13	4101
6353	SensorValue	Угол 2, ° элемента {ГДМ№2} на 25-01-2017 = 5	{"id":4102,"sensor_id":"386","value":5,"date_use":"25-01-2017","allowed_value_type_id":"4"}	126	2017-01-25 13:55:00.287648	13	4102
6354	SensorValue	Температура элемента {ТС№5} на глубине 10(м), на 25-01-2017 = -8	{"id":4089,"sensor_id":"387","sensor_name":"ТС№5","date_cr":"25.01.2017 11:44:25","value":-8,"date_use":"25-01-2017","braid_id":"551","allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	126	2017-01-25 13:55:00.287648	13	4089
6355	SensorValue	Высота, мм элемента {РП№4} на 25-01-2017 = 354.055	{"id":4103,"sensor_id":"389","value":354.055,"date_use":"25-01-2017","allowed_value_type_id":"1"}	127	2017-01-25 13:55:00.287648	13	4103
6356	SensorValue	Высота, мм элемента {Дм} на 25-01-2017 = 368.471	{"id":4104,"sensor_id":"390","value":368.471,"date_use":"25-01-2017","allowed_value_type_id":"6"}	127	2017-01-25 13:55:00.287648	13	4104
6357	SensorValue	Высота, мм элемента {Дм2} на 25-01-2017 = 367.458	{"id":4105,"sensor_id":"391","value":367.458,"date_use":"25-01-2017","allowed_value_type_id":"5"}	127	2017-01-25 13:55:00.287648	13	4105
6361	SensorValue	Температура элемента {ТС№12} на глубине 3(м), на 25-01-2017 = -3	{"id":4109,"sensor_id":"393","value":-3,"date_use":"25-01-2017","braid_id":"566"}	127	2017-01-25 13:55:00.287648	13	4109
6362	SensorValue	Температура элемента {ТС№12} на глубине 4(м), на 25-01-2017 = -5	{"id":4110,"sensor_id":"393","value":-5,"date_use":"25-01-2017","braid_id":"567"}	127	2017-01-25 13:55:00.287648	13	4110
6363	SensorValue	Температура элемента {ТС№12} на глубине 5(м), на 25-01-2017 = -6	{"id":4111,"sensor_id":"393","value":-6,"date_use":"25-01-2017","braid_id":"568"}	127	2017-01-25 13:55:00.287648	13	4111
6364	SensorValue	Температура элемента {ТС№12} на глубине 6(м), на 25-01-2017 = -7	{"id":4112,"sensor_id":"393","value":-7,"date_use":"25-01-2017","braid_id":"569"}	127	2017-01-25 13:55:00.287648	13	4112
6365	SensorValue	Температура элемента {ТС№12} на глубине 7(м), на 25-01-2017 = -8	{"id":4113,"sensor_id":"393","value":-8,"date_use":"25-01-2017","braid_id":"570"}	127	2017-01-25 13:55:00.287648	13	4113
6366	SensorValue	Температура элемента {ТС№12} на глубине 8(м), на 25-01-2017 = -9	{"id":4114,"sensor_id":"393","value":-9,"date_use":"25-01-2017","braid_id":"571"}	127	2017-01-25 13:55:00.287648	13	4114
6367	SensorValue	Температура элемента {ТС№12} на глубине 9(м), на 25-01-2017 = -10	{"id":4115,"sensor_id":"393","value":-10,"date_use":"25-01-2017","braid_id":"572"}	127	2017-01-25 13:55:00.287648	13	4115
6368	SensorValue	Температура элемента {ТС№12} на глубине 10(м), на 25-01-2017 = -10	{"id":4116,"sensor_id":"393","value":-10,"date_use":"25-01-2017","braid_id":"562"}	127	2017-01-25 13:55:00.287648	13	4116
6369	SensorValue	Высота, мм элемента {Дм4} на 25-01-2017 = 367.528	{"id":4117,"sensor_id":"394","value":367.528,"date_use":"25-01-2017","allowed_value_type_id":"6"}	127	2017-01-25 13:55:00.287648	13	4117
6370	SensorValue	Высота, мм элемента {Дм5} на 25-01-2017 = 357.032	{"id":4118,"sensor_id":"395","value":357.032,"date_use":"25-01-2017","allowed_value_type_id":"6"}	127	2017-01-25 13:55:00.287648	13	4118
6371	Sensor	Удален элемент "тест"	{"id":380,"facility_id":123,"facility_name":"поз. 9.1 Факельная установка h=50м","facility_code":null,"name":"тест","location_x":357,"location_y":761,"location_comments":null,"measurement_mode_id":null,"measurement_mode_name":null,"allowed_model_type_id":1,"allowed_model_type_name":"Репер","allowed_model_type_code":"rp","state_id":1,"state_name":"Рабочее","state_code":"work","is_retranslator":0,"deep":0,"deep_step":0,"image_id":null,"image_ext":null,"image_file_folder_id":null,"angle":0,"deleted":1,"pr_sensor_id":null,"pr_sensor_name":null,"measurement_period":null,"reference_date":null,"clipmap":null,"comments_length":0,"photos_length":0,"last_value_date":"2017-01-25","braids":[],"deeps":{}}	123	2017-01-25 15:42:11.024779	13	380
6372	Sensor	Создан новый элемент ДМ (наварной) "ДМ1"	{"id":396,"facility_id":"123","name":"ДМ1","location_x":338,"location_y":539,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:43:24.746296	13	396
6373	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"поз. 9.1 Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":1453,"location_y":567,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-01-25 15:43:31.870525	13	123
6374	Sensor	Создан новый элемент ДМ (наварной) "ДМ2"	{"id":397,"facility_id":"123","name":"ДМ2","location_x":333,"location_y":534,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:43:48.583684	13	397
6375	Sensor	Создан новый элемент ДМ (наварной) "ДМ3"	{"id":398,"facility_id":"123","name":"ДМ3","location_x":444,"location_y":590,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:44:12.196157	13	398
6376	Sensor	Создан новый элемент ДМ (наварной) "ДМ4"	{"id":399,"facility_id":"123","name":"ДМ4","location_x":356,"location_y":851,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:44:36.14759	13	399
6377	Sensor	Создан новый элемент ДМ (наварной) "ДМ5"	{"id":400,"facility_id":"123","name":"ДМ5","location_x":532,"location_y":641,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:44:52.614339	13	400
6378	Sensor	Создан новый элемент ДМ (наварной) "ДМ6"	{"id":401,"facility_id":"123","name":"ДМ6","location_x":552,"location_y":633,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:45:08.862774	13	401
6379	Sensor	Создан новый элемент ТС (вертикальная) "ТС1"	{"id":402,"facility_id":"123","name":"ТС1","location_x":685,"location_y":635,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:45:28.830031	13	402
6380	Sensor	Создан новый элемент ТС (вертикальная) "ТС2"	{"id":403,"facility_id":"123","name":"ТС2","location_x":552,"location_y":602,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":10,"deep_step":1,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	123	2017-01-25 15:45:45.295299	13	403
6381	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"поз. 9.1 Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1453,"location_y":567,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-01-25 15:46:04.542557	13	123
6382	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на "20"\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"поз. 9.1 Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1453,"location_y":567,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-01-26 16:24:57.384602	3	123
6383	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 0	{"id":4119,"sensor_id":396,"value":0,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:02.991392	3	4119
6384	SensorValue	Высота, мм элемента {ДМ2} на 18-01-2017 = 5	{"id":4120,"sensor_id":397,"value":5,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:04.273403	3	4120
6385	SensorValue	Высота, мм элемента {ДМ3} на 18-01-2017 = 10	{"id":4121,"sensor_id":398,"value":10,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:06.46353	3	4121
6386	SensorValue	Высота, мм элемента {ДМ4} на 18-01-2017 = 20	{"id":4122,"sensor_id":399,"value":20,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:08.003676	3	4122
6387	SensorValue	Высота, мм элемента {ДМ5} на 18-01-2017 = 30	{"id":4123,"sensor_id":400,"value":30,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:10.148595	3	4123
6388	SensorValue	Высота, мм элемента {ДМ6} на 18-01-2017 = 40	{"id":4124,"sensor_id":401,"value":40,"date_use":"18-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:11.344815	3	4124
6389	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"value":0,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4125
6390	SensorValue	Высота, мм элемента {ДМ2} на 19-01-2017 = 5	{"id":4126,"sensor_id":397,"value":5,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4126
6391	SensorValue	Высота, мм элемента {ДМ3} на 19-01-2017 = 10	{"id":4127,"sensor_id":398,"value":10,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4127
6392	SensorValue	Высота, мм элемента {ДМ4} на 19-01-2017 = 20	{"id":4128,"sensor_id":399,"value":20,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4128
6393	SensorValue	Высота, мм элемента {ДМ5} на 19-01-2017 = 30	{"id":4129,"sensor_id":400,"value":30,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4129
6394	SensorValue	Высота, мм элемента {ДМ6} на 19-01-2017 = 40	{"id":4130,"sensor_id":401,"value":40,"date_use":"19-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:25:25.139929	3	4130
6395	SensorValue	Температура элемента {ТС1} на глубине 2(м), на 18-01-2017 = 2017	{"id":4131,"sensor_id":402,"value":2017,"date_use":"18-01-2017","braid_id":576}	123	2017-01-26 16:28:03.040164	3	4131
6396	SensorValue	Температура элемента {ТС1} на глубине 2(м), на 18-01-2017 = null	{"id":4131,"sensor_id":402,"sensor_name":"ТС1","date_cr":"26.01.2017 16:28:03","value":null,"date_use":"18-01-2017","braid_id":576,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	123	2017-01-26 16:28:03.666747	3	4131
6418	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:39","value":5,"date_use":"20-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4132
6397	Sensor	Параметр элемента {ДМ1} "Дата реперного замера" изменен на "18.01.2017"\n	{"id":396,"facility_id":123,"facility_name":"поз. 9.1 Факельная установка h=50м","facility_code":null,"name":"ДМ1","location_x":271,"location_y":514,"location_comments":null,"measurement_mode_name":null,"allowed_model_type_id":6,"allowed_model_type_name":"ДМ (наварной)","allowed_model_type_code":"dm_fatty","state_id":"1","state_name":"Рабочее","state_code":"work","deep":0,"deep_step":0,"image_ext":null,"image_file_folder_id":null,"angle":0,"deleted":null,"pr_sensor_id":null,"pr_sensor_name":null,"reference_date":"18.01.2017","clipmap":null,"comments_length":0,"photos_length":0,"reference_value":0,"reference_date_rev":"2017-01-18","last_value_date":"2017-01-19","braids":[],"deeps":{}}	123	2017-01-26 16:28:26.628987	3	396
6398	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"value":5,"date_use":"20-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:28:39.452876	3	4132
6399	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"value":10,"date_use":"21-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:28:41.789032	3	4133
6400	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"value":20,"date_use":"22-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:28:43.724673	3	4134
6401	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:28:50.507282	3	4119
6402	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 30	{"id":4135,"sensor_id":396,"value":30,"date_use":"23-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:29:14.579203	3	4135
6403	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"value":40,"date_use":"24-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:29:17.065415	3	4136
6404	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 5	{"id":4137,"sensor_id":396,"value":5,"date_use":"25-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:31:22.903493	3	4137
6405	SensorValue	Высота, мм элемента {ДМ1} на 17-01-2017 = null	{"id":4138,"sensor_id":396,"value":null,"date_use":"17-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:33:55.417108	3	4138
6406	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4119
6407	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:25","value":0,"date_use":"19-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4125
6408	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:39","value":5,"date_use":"20-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4132
6409	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:41","value":10,"date_use":"21-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4133
6410	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:43","value":20,"date_use":"22-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4134
6411	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 35	{"id":4135,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:14","value":35,"date_use":"23-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4135
6412	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:17","value":40,"date_use":"24-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4136
6413	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 55	{"id":4137,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:31:22","value":55,"date_use":"25-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:33:55.417108	3	4137
6414	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = null	{"id":4139,"sensor_id":396,"value":null,"date_use":"26-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:33:55.417108	3	4139
6415	SensorValue	Высота, мм элемента {ДМ1} на 17-01-2017 = null	{"id":4138,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"17-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4138
6416	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4119
6417	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:25","value":0,"date_use":"19-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4125
6419	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:41","value":10,"date_use":"21-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4133
6420	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:43","value":20,"date_use":"22-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4134
6421	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 35	{"id":4135,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:14","value":35,"date_use":"23-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4135
6422	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:17","value":40,"date_use":"24-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4136
6423	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 55	{"id":4137,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:31:22","value":55,"date_use":"25-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4137
6424	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = null	{"id":4139,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"26-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:35:07.916974	3	4139
6425	SensorValue	Высота, мм элемента {ДМ1} на 29-01-2017 = 66	{"id":4140,"sensor_id":396,"value":66,"date_use":"29-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:35:07.916974	3	4140
6426	SensorValue	Высота, мм элемента {ДМ1} на 17-01-2017 = null	{"id":4138,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"17-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4138
6427	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4119
6428	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:25","value":0,"date_use":"19-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4125
6429	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:39","value":5,"date_use":"20-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4132
6430	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:41","value":10,"date_use":"21-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4133
6431	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:43","value":20,"date_use":"22-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4134
6432	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 35	{"id":4135,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:14","value":35,"date_use":"23-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4135
6433	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:17","value":40,"date_use":"24-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4136
6434	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 55	{"id":4137,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:31:22","value":55,"date_use":"25-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4137
6435	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = null	{"id":4139,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"26-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4139
6436	SensorValue	Высота, мм элемента {ДМ1} на 29-01-2017 = 66	{"id":4140,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:35:07","value":66,"date_use":"29-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:37:38.69848	3	4140
6437	SensorValue	Высота, мм элемента {ДМ1} на 30-01-2017 = 71	{"id":4141,"sensor_id":396,"value":71,"date_use":"30-01-2017","allowed_value_type_id":6}	123	2017-01-26 16:37:38.69848	3	4141
6438	SensorValue	Высота, мм элемента {ДМ1} на 17-01-2017 = null	{"id":4138,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"17-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4138
6563	SensorValue	Высота, мм элемента {ДМ} на 15-03-2017 = 1	{"id":4157,"sensor_id":422,"value":1,"date_use":"15-03-2017","allowed_value_type_id":6}	131	2017-03-23 13:57:47.630631	13	4157
6439	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4119
6440	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:25","value":0,"date_use":"19-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4125
6441	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:39","value":5,"date_use":"20-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4132
6442	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:41","value":10,"date_use":"21-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4133
6443	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:43","value":20,"date_use":"22-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4134
6444	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 35	{"id":4135,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:14","value":35,"date_use":"23-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4135
6445	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:17","value":40,"date_use":"24-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4136
6446	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 55	{"id":4137,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:31:22","value":55,"date_use":"25-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4137
6447	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = null	{"id":4139,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"26-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4139
6448	SensorValue	Высота, мм элемента {ДМ1} на 29-01-2017 = 66	{"id":4140,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:35:07","value":66,"date_use":"29-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4140
6449	SensorValue	Высота, мм элемента {ДМ1} на 30-01-2017 = 71	{"id":4141,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:37:38","value":71,"date_use":"30-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:40:41.198052	3	4141
6450	SensorValue	Высота, мм элемента {ДМ1} на 17-01-2017 = null	{"id":4138,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"17-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4138
6451	SensorValue	Высота, мм элемента {ДМ1} на 18-01-2017 = 1	{"id":4119,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:02","value":1,"date_use":"18-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4119
6452	SensorValue	Высота, мм элемента {ДМ1} на 19-01-2017 = 0	{"id":4125,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:25:25","value":0,"date_use":"19-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4125
6453	SensorValue	Высота, мм элемента {ДМ1} на 20-01-2017 = 5	{"id":4132,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:39","value":5,"date_use":"20-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4132
6454	SensorValue	Высота, мм элемента {ДМ1} на 21-01-2017 = 10	{"id":4133,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:41","value":10,"date_use":"21-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4133
6455	SensorValue	Высота, мм элемента {ДМ1} на 22-01-2017 = 20	{"id":4134,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:28:43","value":20,"date_use":"22-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4134
6456	SensorValue	Высота, мм элемента {ДМ1} на 23-01-2017 = 35	{"id":4135,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:14","value":35,"date_use":"23-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4135
6457	SensorValue	Высота, мм элемента {ДМ1} на 24-01-2017 = 40	{"id":4136,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:29:17","value":40,"date_use":"24-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4136
6458	SensorValue	Высота, мм элемента {ДМ1} на 25-01-2017 = 55	{"id":4137,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:31:22","value":55,"date_use":"25-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4137
6459	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = null	{"id":4139,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":null,"date_use":"26-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4139
6460	SensorValue	Высота, мм элемента {ДМ1} на 29-01-2017 = 66	{"id":4140,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:35:07","value":66,"date_use":"29-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4140
6461	SensorValue	Высота, мм элемента {ДМ1} на 30-01-2017 = 71	{"id":4141,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:37:38","value":71,"date_use":"30-01-2017","allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-01-26 16:42:17.495788	3	4141
6462	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":504,"location_y":803,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"0","show_convention":"0","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":2,"photos_length":1,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf"},"urn_encoded":null}	127	2017-01-26 18:22:09.518827	3	127
6463	Facility	Параметр объекта "Мощность отсыпки" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":776,"location_y":846,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":74,"plan_name":"Б_Хета_лист 3","view_data":null,"table_x":203,"table_y":982,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":421,"convention_y":1045,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf"},"urn_encoded":null}	126	2017-01-31 16:19:10.636533	3	126
6464	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":50,"location_y":50,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:32:47.015979	13	122
6486	Sensor	Создан новый элемент ТС "ТС_тест1"	{"id":404,"facility_id":"122","name":"ТС_тест1","location_x":1208,"location_y":613,"allowed_model_type_id":"11","state_id":"1","is_retranslator":"0","deep":10,"deep_step":0.5,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 12:58:31.612981	13	404
6496	Sensor	Создан новый элемент ГДМ "ГДМ_тест1"	{"id":408,"facility_id":"122","name":"ГДМ_тест1","location_x":1292,"location_y":504,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":5,"deep_step":1,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:10:44.775279	13	408
6498	Sensor	Создан новый элемент Репер "РП_тест1"	{"id":410,"facility_id":"122","name":"РП_тест1","location_x":1246,"location_y":336,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:11:56.403564	13	410
6465	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:35:55.220176	13	122
6466	Facility	Создан новый объект "Поз.8.1_Система измер-я кол-ва нефти"	{"id":129,"parent_id":"122","name":"Поз.8.1_Система измер-я кол-ва нефти","location_x":50,"location_y":50,"plan_id":"77","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/829.jpg","jpg_id":829,"pdf_url":"/f/14/827.pdf","calc_pdf_url":"/f/14/828.pdf","pdf_id":827,"plan":{"id":77,"name":"Поз.8.1 Система измер-я кол-ва нефти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":827,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/827.pdf","jpg_id":829,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/829.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":828,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/828.pdf"},"urn_encoded":null}	129	2017-02-01 10:37:14.876986	13	129
6467	Facility	Объект переименован на "Поз. 9.1 Факельная установка h=50м"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"Поз. 9.1 Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1453,"location_y":567,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-02-01 10:37:30.431219	13	123
6468	Facility	Объект переименован на "Поз. 8.1_Система измер-я кол-ва нефти"\nПараметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":129,"parent_id":122,"name":"Поз. 8.1_Система измер-я кол-ва нефти","ordering":129,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":50,"location_y":50,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":77,"plan_name":"Поз.8.1 Система измер-я кол-ва нефти","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"01.02.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/829.jpg","jpg_id":829,"pdf_url":"/f/14/827.pdf","calc_pdf_url":"/f/14/828.pdf","pdf_id":827,"plan":{"id":77,"name":"Поз.8.1 Система измер-я кол-ва нефти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":827,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/827.pdf","jpg_id":829,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/829.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":828,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/828.pdf"},"urn_encoded":null}	129	2017-02-01 10:37:52.530742	13	129
6469	Facility	Объект переименован на "Поз. 9.1_Факельная установка h=50м"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"Поз. 9.1_Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1453,"location_y":567,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf"},"urn_encoded":null}	123	2017-02-01 10:38:07.467809	13	123
6487	Sensor	Создан новый элемент ТС (вертикальная) "ТС_тест 2"	{"id":405,"facility_id":"122","name":"ТС_тест 2","location_x":1368,"location_y":411,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"1","deep":15,"deep_step":0.5,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 12:59:27.320815	13	405
6470	Facility	Объект переименован на "Подобъект к удалению"\nПараметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":124,"parent_id":122,"name":"Подобъект к удалению","ordering":124,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":50,"location_y":50,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":65,"plan_name":"ЦПС_ОГТМ","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":1,"date_cr":"19.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	124	2017-02-01 10:38:48.911686	13	124
6471	Facility	Объект переименован на "Подобъект к удалению!!!"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":124,"parent_id":122,"name":"Подобъект к удалению!!!","ordering":124,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":65,"plan_name":"ЦПС_ОГТМ","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":1,"date_cr":"19.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/788.jpg","jpg_id":788,"pdf_url":"/f/14/786.pdf","calc_pdf_url":"/f/14/787.pdf","pdf_id":786,"plan":{"id":65,"name":"ЦПС_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":786,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/786.pdf","jpg_id":788,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/788.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":787,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/787.pdf"},"urn_encoded":null}	124	2017-02-01 10:40:26.483743	13	124
6472	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:43:41.803673	13	122
6473	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.75,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:45:58.563923	13	122
6497	Sensor	Создан новый элемент ГДМ "ГДМ_тест2"	{"id":409,"facility_id":"122","name":"ГДМ_тест2","location_x":1460,"location_y":820,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"1","deep":3,"deep_step":1,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:11:26.343678	13	409
6474	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:46:07.402757	13	122
6475	Facility	Создан новый объект "Поз. 52.2_Площадка дренажной емкости"	{"id":130,"parent_id":"122","name":"Поз. 52.2_Площадка дренажной емкости","location_x":50,"location_y":50,"plan_id":"78","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/832.jpg","jpg_id":832,"pdf_url":"/f/14/830.pdf","calc_pdf_url":"/f/14/831.pdf","pdf_id":830,"plan":{"id":78,"name":"Поз. 52.2 Пл-ка дрен емк-ти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":830,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/830.pdf","jpg_id":832,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/832.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":831,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/831.pdf"},"urn_encoded":null}	130	2017-02-01 10:49:14.834104	13	130
6476	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf"},"urn_encoded":null}	122	2017-02-01 10:53:49.904825	13	122
6477	SensorValue	Высота, мм элемента {ДМ1} на 26-01-2017 = 20	{"id":4139,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"26.01.2017 16:33:55","value":20,"date_use":"26-01-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-02-01 11:26:31.41895	13	4139
6478	SensorValue	Высота, мм элемента {ДМ1} на 27-01-2017 = 10	{"id":4142,"sensor_id":396,"value":10,"date_use":"27-01-2017","allowed_value_type_id":6}	123	2017-02-01 11:26:34.047353	13	4142
6479	SensorValue	Высота, мм элемента {ДМ1} на 28-01-2017 = 509	{"id":4143,"sensor_id":396,"value":509,"date_use":"28-01-2017","allowed_value_type_id":6}	123	2017-02-01 11:26:37.887098	13	4143
6480	SensorValue	Высота, мм элемента {ДМ1} на 28-01-2017 = 50	{"id":4143,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"01.02.2017 11:26:37","value":50,"date_use":"28-01-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-02-01 11:26:41.14891	13	4143
6488	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":130,"parent_id":122,"name":"Поз. 52.2_Площадка дренажной емкости","ordering":130,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1226,"location_y":1943,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"1190.000,1814.000;1017.000,1878.000;1136.000,2072.000;1345.000,2041.000;1337.000,1886.000;1288.000,1812.000;","dumping_depth":"","plan_id":78,"plan_name":"Поз. 52.2 Пл-ка дрен емк-ти","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"01.02.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/832.jpg","jpg_id":832,"pdf_url":"/f/14/830.pdf","calc_pdf_url":"/f/14/831.pdf","pdf_id":830,"plan":{"id":78,"name":"Поз. 52.2 Пл-ка дрен емк-ти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":830,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/830.pdf","jpg_id":832,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/832.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":831,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/831.pdf","deleted":null,"used":{"id":130,"parent_id":122,"name":"Поз. 52.2_Площадка дренажной емкости","ordering":130,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":1226,"location_y":1943,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"1190.000,1814.000;1017.000,1878.000;1136.000,2072.000;1345.000,2041.000;1337.000,1886.000;1288.000,1812.000;","dumping_depth":null,"plan_id":78,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-02-01","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	130	2017-02-01 13:00:07.092047	3	130
6481	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":125,"parent_id":null,"name":"Участок перехода через р. Большая Хета","ordering":125,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":73,"plan_name":"Переход Б Хета_Схема","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/812.jpg","jpg_id":812,"pdf_url":"/f/14/810.pdf","calc_pdf_url":"/f/14/811.pdf","pdf_id":810,"plan":{"id":73,"name":"Переход Б Хета_Схема (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":810,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/810.pdf","jpg_id":812,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/812.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":811,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/811.pdf"},"urn_encoded":null}	125	2017-02-01 11:29:27.71338	13	125
6482	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	122	2017-02-01 12:51:15.979987	13	122
6483	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"Поз. 9.1_Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1557,"location_y":643,"state_id":"2","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf","deleted":null,"used":{"id":117,"parent_id":116,"name":"Поз.9.1 Совмещенная факельная установка h=50м","ordering":117,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":66,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-01-17","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	123	2017-02-01 12:51:26.901921	13	123
6484	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":129,"parent_id":122,"name":"Поз. 8.1_Система измер-я кол-ва нефти","ordering":129,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1258,"location_y":2904,"state_id":"2","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":77,"plan_name":"Поз.8.1 Система измер-я кол-ва нефти","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"01.02.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/829.jpg","jpg_id":829,"pdf_url":"/f/14/827.pdf","calc_pdf_url":"/f/14/828.pdf","pdf_id":827,"plan":{"id":77,"name":"Поз.8.1 Система измер-я кол-ва нефти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":827,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/827.pdf","jpg_id":829,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/829.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":828,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/828.pdf","deleted":null,"used":{"id":129,"parent_id":122,"name":"Поз. 8.1_Система измер-я кол-ва нефти","ordering":129,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":1258,"location_y":2904,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":77,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-02-01","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	129	2017-02-01 12:51:40.73507	13	129
6485	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":130,"parent_id":122,"name":"Поз. 52.2_Площадка дренажной емкости","ordering":130,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":1226,"location_y":1943,"state_id":"2","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"dumping_depth":"","plan_id":78,"plan_name":"Поз. 52.2 Пл-ка дрен емк-ти","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"01.02.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/832.jpg","jpg_id":832,"pdf_url":"/f/14/830.pdf","calc_pdf_url":"/f/14/831.pdf","pdf_id":830,"plan":{"id":78,"name":"Поз. 52.2 Пл-ка дрен емк-ти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":830,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/830.pdf","jpg_id":832,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/832.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":831,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/831.pdf","deleted":null,"used":{"id":130,"parent_id":122,"name":"Поз. 52.2_Площадка дренажной емкости","ordering":130,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":1226,"location_y":1943,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":78,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-02-01","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	130	2017-02-01 12:51:55.103412	13	130
6564	SensorValue	Высота, мм элемента {ДМ} на 16-03-2017 = 1.2	{"id":4158,"sensor_id":422,"value":1.2,"date_use":"16-03-2017","allowed_value_type_id":6}	131	2017-03-23 13:57:51.101484	13	4158
6489	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":129,"parent_id":122,"name":"Поз. 8.1_Система измер-я кол-ва нефти","ordering":129,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1258,"location_y":2904,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"1088.000,2830.000;1051.000,2964.000;1237.000,3071.000;1394.000,3067.000;1481.000,2904.000;1383.000,2776.000;1169.000,2713.000;","dumping_depth":"","plan_id":77,"plan_name":"Поз.8.1 Система измер-я кол-ва нефти","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"01.02.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/829.jpg","jpg_id":829,"pdf_url":"/f/14/827.pdf","calc_pdf_url":"/f/14/828.pdf","pdf_id":827,"plan":{"id":77,"name":"Поз.8.1 Система измер-я кол-ва нефти (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":827,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/827.pdf","jpg_id":829,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/829.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":828,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/828.pdf","deleted":null,"used":{"id":129,"parent_id":122,"name":"Поз. 8.1_Система измер-я кол-ва нефти","ordering":129,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":1258,"location_y":2904,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"1088.000,2830.000;1051.000,2964.000;1237.000,3071.000;1394.000,3067.000;1481.000,2904.000;1383.000,2776.000;1169.000,2713.000;","dumping_depth":null,"plan_id":77,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-02-01","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	129	2017-02-01 13:00:10.020516	3	129
6490	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":123,"parent_id":122,"name":"Поз. 9.1_Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1557,"location_y":643,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"1310.000,542.000;1172.000,731.000;1323.000,938.000;1566.000,933.000;1723.000,865.000;1789.000,633.000;1467.000,477.000;","dumping_depth":"","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf","deleted":null,"used":{"id":117,"parent_id":116,"name":"Поз.9.1 Совмещенная факельная установка h=50м","ordering":117,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":66,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-01-17","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	123	2017-02-01 13:00:12.763893	3	123
6491	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":632,"table_y":72,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":632,"table_y":72,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	122	2017-02-01 13:00:16.394812	3	122
6492	Sensor	Создан новый элемент ТС (вертикальная) "ТС_тест3"	{"id":406,"facility_id":"122","name":"ТС_тест3","location_x":1613,"location_y":505,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"1","deep":15,"deep_step":0.5,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:00:31.575789	13	406
6493	Sensor	Элемент {ТС_тест1} переименован на "ТСфоновая_тест1"\n	{"id":404,"facility_id":122,"facility_name":"Площадка ЦПС","facility_code":null,"name":"ТСфоновая_тест1","location_x":1208,"location_y":613,"location_comments":null,"measurement_mode_name":null,"allowed_model_type_id":11,"allowed_model_type_name":"ТС","allowed_model_type_code":"ts_slop","state_id":"1","state_name":"Рабочее","state_code":"work","is_retranslator":"0","deep":10,"deep_step":0.5,"image_ext":null,"image_file_folder_id":null,"angle":0,"deleted":null,"pr_sensor_id":null,"pr_sensor_name":null,"reference_date":"01.02.2017","clipmap":null,"comments_length":0,"photos_length":0,"reference_date_rev":"2017-02-01","last_value_date":"-","braids":[{"id":595,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":10,"enabled":1},{"id":596,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":0,"enabled":1},{"id":597,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":0.5,"enabled":1},{"id":598,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":1,"enabled":1},{"id":599,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":1.5,"enabled":1},{"id":600,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":2,"enabled":1},{"id":601,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":2.5,"enabled":1},{"id":602,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":3,"enabled":1},{"id":603,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":3.5,"enabled":1},{"id":604,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":4,"enabled":1},{"id":605,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":4.5,"enabled":1},{"id":606,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":5,"enabled":1},{"id":607,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":5.5,"enabled":1},{"id":608,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":6,"enabled":1},{"id":609,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":6.5,"enabled":1},{"id":610,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":7,"enabled":1},{"id":611,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":7.5,"enabled":1},{"id":612,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":8,"enabled":1},{"id":613,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":8.5,"enabled":1},{"id":614,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":9,"enabled":1},{"id":615,"sensor_id":404,"sensor_name":"ТСфоновая_тест1","deep":9.5,"enabled":1}],"deeps":{"0":596,"1":598,"2":600,"3":602,"4":604,"5":606,"6":608,"7":610,"8":612,"9":614,"10":595,"0.5":597,"1.5":599,"2.5":601,"3.5":603,"4.5":605,"5.5":607,"6.5":609,"7.5":611,"8.5":613,"9.5":615}}	122	2017-02-01 13:00:45.833579	13	404
6494	Sensor	Создан новый элемент ТС (горизонтальная) "ТС_фоновая_тест4"	{"id":407,"facility_id":"122","name":"ТС_фоновая_тест4","location_x":1125,"location_y":921,"allowed_model_type_id":"9","state_id":"1","is_retranslator":"1","deep":10,"deep_step":0.5,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:06:47.114608	13	407
6495	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2090,"convention_y":254,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2090,"convention_y":254,"type":null,"stamp_data":null}},"urn_encoded":null}	122	2017-02-01 13:09:21.871402	13	122
6499	Sensor	Создан новый элемент Репер "РП_тест2"	{"id":411,"facility_id":"122","name":"РП_тест2","location_x":811,"location_y":1678,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:12:22.698066	13	411
6500	Sensor	Параметр элемента {РП_тест2} "Дата реперного замера" изменен на "01.02.2017"\n	{"id":411,"facility_id":122,"facility_name":"Площадка ЦПС","facility_code":null,"name":"РП_тест2","location_x":811,"location_y":1678,"location_comments":null,"measurement_mode_name":null,"allowed_model_type_id":1,"allowed_model_type_name":"Репер","allowed_model_type_code":"rp","state_id":"1","state_name":"Рабочее","state_code":"work","is_retranslator":"0","deep":0,"deep_step":0,"image_ext":null,"image_file_folder_id":null,"angle":0,"deleted":null,"pr_sensor_id":null,"pr_sensor_name":null,"reference_date":"01.02.2017","clipmap":null,"comments_length":0,"photos_length":0,"reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:12:30.437859	13	411
6501	Sensor	Создан новый элемент Репер "РП_тест3"	{"id":412,"facility_id":"122","name":"РП_тест3","location_x":1249,"location_y":2304,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"1","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:12:52.391162	13	412
6502	Sensor	Создан новый элемент Репер "РП_тест4"	{"id":413,"facility_id":"122","name":"РП_тест4","location_x":929,"location_y":2780,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"1","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:13:14.823024	13	413
6503	Sensor	Создан новый элемент ГДМ "ГДМ_тест3"	{"id":414,"facility_id":"122","name":"ГДМ_тест3","location_x":888,"location_y":1680,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"1","deep":2,"deep_step":1,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:13:58.09448	13	414
6504	Sensor	Создан новый элемент ГДМ "ГДМ_тест5"	{"id":415,"facility_id":"122","name":"ГДМ_тест5","location_x":1249,"location_y":2230,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"1","deep":2,"deep_step":1,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:14:54.831458	13	415
6505	Sensor	Создан новый элемент ПС "ПС_тест3"	{"id":416,"facility_id":"122","name":"ПС_тест3","location_x":1187,"location_y":2868,"allowed_model_type_id":"2","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:15:40.626758	13	416
6506	Sensor	Создан новый элемент ПС "ПС_тест2"	{"id":417,"facility_id":"122","name":"ПС_тест2","location_x":1247,"location_y":1750,"allowed_model_type_id":"2","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:16:02.902668	13	417
6507	Sensor	Создан новый элемент ПС "ПС_тест1"	{"id":418,"facility_id":"122","name":"ПС_тест1","location_x":1606,"location_y":571,"allowed_model_type_id":"2","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.02.2017","reference_date_rev":"2017-02-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-02-01 13:16:46.191932	13	418
6508	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Проектируется","base_type":"Свайн, плитн, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2080,"convention_y":662,"type":"Площадка","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Проектируется","base_type":"Свайн, плитн, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2080,"convention_y":662,"type":"Площадка","stamp_data":null}},"urn_encoded":null}	122	2017-02-01 13:17:39.340286	13	122
6509	Facility	Параметр объекта "СТС/СМС" изменен на "3.5"\nПараметр объекта "Уровень естественной поверхности" изменен на "386"\nПараметр объекта "Допустимая величина деформации" изменен на "20"\nПараметр объекта "Максимальная допустимая температура" изменен на "-1"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Проектируется","base_type":"Свайн, плитн, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":3.5,"clipmap":null,"dumping_depth":"386","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":2080,"convention_y":662,"type":"Площадка","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Проектируется","base_type":"Свайн, плитн, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":3.5,"clipmap":null,"dumping_depth":386,"plan_id":71,"view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":20,"show_explication":1,"show_convention":1,"convention_x":2080,"convention_y":662,"type":"Площадка","stamp_data":null}},"urn_encoded":null}	122	2017-02-01 13:20:25.404587	13	122
6537	Sensor	Создан новый элемент Репер "11111111111"	{"id":424,"facility_id":"122","name":"11111111111","location_x":184,"location_y":112,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-23 08:18:40.062626	13	424
6560	SensorValue	Высота, мм элемента {Рп} на 17-03-2017 = 2	{"id":4155,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 13:56:53","value":2,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 13:57:11.458084	13	4155
6510	Facility	Параметр объекта "Глубина фундамента" изменен на "10"\nПараметр объекта "СТС/СМС" изменен на "3.5"\nПараметр объекта "Уровень естественной поверхности" изменен на "386.5"\nПараметр объекта "Максимальная допустимая температура" изменен на "-1"\n	{"id":123,"parent_id":122,"name":"Поз. 9.1_Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":17,"protection":"Проектируется","base_type":"Свайный","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1557,"location_y":643,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":10,"frozen_depth":3.5,"clipmap":"1441.000,517.000;1421.000,621.000;1521.000,587.000;","dumping_depth":"386.5","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"20","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"Факельная установка","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf","deleted":null,"used":{"id":117,"parent_id":116,"name":"Поз.9.1 Совмещенная факельная установка h=50м","ordering":117,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":66,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-01-17","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	123	2017-02-01 13:26:19.59261	13	123
6511	Facility	Параметр объекта "Глубина фундамента" изменен на "10"\nПараметр объекта "СТС/СМС" изменен на "5"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":125,"parent_id":null,"name":"Участок перехода через р. Большая Хета","ordering":125,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Есть","base_type":"Свайный, траншея","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":10,"frozen_depth":5,"clipmap":null,"dumping_depth":"","plan_id":73,"plan_name":"Переход Б Хета_Схема","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Трубопровод","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/812.jpg","jpg_id":812,"pdf_url":"/f/14/810.pdf","calc_pdf_url":"/f/14/811.pdf","pdf_id":810,"plan":{"id":73,"name":"Переход Б Хета_Схема (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":810,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/810.pdf","jpg_id":812,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/812.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":811,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/811.pdf","deleted":null,"used":{"id":125,"parent_id":null,"name":"Участок перехода через р. Большая Хета","ordering":125,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"Есть","base_type":"Свайный, траншея","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":10,"frozen_depth":5,"clipmap":null,"dumping_depth":null,"plan_id":73,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Трубопровод","stamp_data":null}},"urn_encoded":null}	125	2017-02-01 13:33:25.901024	13	125
6512	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":504,"location_y":803,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":2,"photos_length":1,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf","deleted":null,"used":{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":504,"location_y":803,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":null,"plan_id":75,"view_data":null,"table_x":250,"table_y":50,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	127	2017-02-01 13:35:08.928109	13	127
6513	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":504,"location_y":803,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":372,"table_y":940,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":582,"convention_y":964,"type":"","stamp_data":null,"comments_length":2,"photos_length":1,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf","deleted":null,"used":{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":504,"location_y":803,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":null,"plan_id":75,"view_data":null,"table_x":372,"table_y":940,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":582,"convention_y":964,"type":null,"stamp_data":null}},"urn_encoded":null}	127	2017-02-01 13:35:39.757405	13	127
6514	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Подземная прокладка","base_principle_id":"1","base_principle_name":"&#8544;","location_x":776,"location_y":846,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"787.000,915.000;763.000,977.000;619.000,925.000;641.000,861.000;","dumping_depth":"","plan_id":74,"plan_name":"Б_Хета_лист 3","view_data":null,"table_x":203,"table_y":982,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":421,"convention_y":1045,"type":"Трубопровод","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf","deleted":null,"used":{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Подземная прокладка","base_construction":null,"base_principle_id":1,"location_x":776,"location_y":846,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"787.000,915.000;763.000,977.000;619.000,925.000;641.000,861.000;","dumping_depth":null,"plan_id":74,"view_data":null,"table_x":203,"table_y":982,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":421,"convention_y":1045,"type":"Трубопровод","stamp_data":null}},"urn_encoded":null}	126	2017-02-01 13:37:14.602278	13	126
6557	SensorValue	Высота, мм элемента {Рп} на 16-03-2017 = 1.2	{"id":4154,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 13:56:49","value":1.2,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 13:56:59.522439	13	4154
6515	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Подземная прокладка","base_principle_id":"1","base_principle_name":"&#8544;","location_x":776,"location_y":846,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"787.000,915.000;763.000,977.000;619.000,925.000;641.000,861.000;","dumping_depth":"","plan_id":74,"plan_name":"Б_Хета_лист 3","view_data":null,"table_x":203,"table_y":982,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":421,"convention_y":1045,"type":"Трубопровод","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/815.jpg","jpg_id":815,"pdf_url":"/f/14/813.pdf","calc_pdf_url":"/f/14/814.pdf","pdf_id":813,"plan":{"id":74,"name":"Б_Хета_лист 3 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":813,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/813.pdf","jpg_id":815,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/815.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":814,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/814.pdf","deleted":null,"used":{"id":126,"parent_id":125,"name":"ПК143+25.68-ПК146+25.68","ordering":126,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Подземная прокладка","base_construction":null,"base_principle_id":1,"location_x":776,"location_y":846,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"787.000,915.000;763.000,977.000;619.000,925.000;641.000,861.000;","dumping_depth":null,"plan_id":74,"view_data":null,"table_x":203,"table_y":982,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":421,"convention_y":1045,"type":"Трубопровод","stamp_data":null}},"urn_encoded":null}	126	2017-02-01 13:37:25.950908	13	126
6516	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Надземная прокладка","base_principle_id":"1","base_principle_name":"&#8544;","location_x":504,"location_y":803,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":"","plan_id":75,"plan_name":"Б Хета_лист 4","view_data":null,"table_x":372,"table_y":940,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"24.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":582,"convention_y":964,"type":"Трубопровод","stamp_data":null,"comments_length":2,"photos_length":1,"jpg_url":"/f/14/818.jpg","jpg_id":818,"pdf_url":"/f/14/816.pdf","calc_pdf_url":"/f/14/817.pdf","pdf_id":816,"plan":{"id":75,"name":"Б Хета_лист 4 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":816,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/816.pdf","jpg_id":818,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/818.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":817,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/817.pdf","deleted":null,"used":{"id":127,"parent_id":125,"name":"ПК146+25.68-ПК149+25.68","ordering":127,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"Надземная прокладка","base_construction":null,"base_principle_id":1,"location_x":504,"location_y":803,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;","dumping_depth":null,"plan_id":75,"view_data":null,"table_x":372,"table_y":940,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-24","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":582,"convention_y":964,"type":"Трубопровод","stamp_data":null}},"urn_encoded":null}	127	2017-02-01 13:37:42.319407	13	127
6517	Facility	Параметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"0","show_convention":"0","convention_x":2080,"convention_y":662,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":0,"show_convention":0,"convention_x":2080,"convention_y":662,"type":null,"stamp_data":null}},"urn_encoded":null}	122	2017-02-01 15:39:38.093637	3	122
6518	SensorValue	УГВ, м элемента {ПС_тест2} на 30-01-2017 = null	{"id":4144,"sensor_id":417,"value":null,"date_use":"30-01-2017","allowed_value_type_id":2}	122	2017-02-03 19:19:36.037929	3	4144
6519	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2045,"convention_y":663,"type":"","stamp_data":null,"comments_length":3,"photos_length":3,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2152,"table_y":122,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2045,"convention_y":663,"type":null,"stamp_data":null}},"urn_encoded":null}	122	2017-02-08 17:29:53.797638	3	122
6520	SensorValue	Высота, мм элемента {РП_тест3} на 15-02-2017 = 2	{"id":4145,"sensor_id":"412","value":2,"date_use":"15-02-2017","allowed_value_type_id":"1"}	122	2017-02-15 18:27:28.65687	3	4145
6521	FacilityComment	Добавлен комментарий к объекту	{"id":108,"facility_id":125,"user_cr_id":3,"body":"Тест\\n","images_json":"{\\"file:///storage/sdcard0/Android/data/ru.pronetcom.ias_yamal/cache/1487172486771.jpg\\":1}"}	125	2017-02-15 18:28:13.194078	3	108
6522	FacilityComment	Добавлен комментарий к объекту	{"id":109,"facility_id":122,"user_cr_id":3,"body":"Тест\\n","images_json":"{\\"file:///storage/sdcard0/Android/data/ru.pronetcom.ias_yamal/cache/1487172594912.jpg\\":2}"}	122	2017-02-15 18:30:00.524834	3	109
6558	SensorValue	Высота, мм элемента {Рп} на 15-03-2017 = 1	{"id":4153,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 13:56:41","value":1,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 13:57:02.527485	13	4153
6561	SensorValue	Высота, мм элемента {Рп} на 17-03-2017 = 1.1	{"id":4155,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 13:56:53","value":1.1,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 13:57:19.97333	13	4155
6565	SensorValue	Высота, мм элемента {ДМ} на 17-03-2017 = 1.5	{"id":4159,"sensor_id":422,"value":1.5,"date_use":"17-03-2017","allowed_value_type_id":6}	131	2017-03-23 13:57:54.32833	13	4159
6523	Facility	Создан новый объект "Куст скважин №31"	{"id":131,"parent_id":"","name":"Куст скважин №31","location_x":50,"location_y":50,"plan_id":"79","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":79,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	131	2017-03-21 14:24:07.189286	13	131
6524	Facility	Создан новый объект "Поз. 8"	{"id":132,"parent_id":"131","name":"Поз. 8","location_x":50,"location_y":50,"plan_id":"80","table_x":250,"table_y":50,"element_size":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"jpg_url":"/f/14/839.jpg","jpg_id":839,"pdf_url":"/f/14/837.pdf","calc_pdf_url":"/f/14/838.pdf","pdf_id":837,"plan":{"id":80,"name":"Куст 31_Поз. 8 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":837,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/837.pdf","jpg_id":839,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/839.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":838,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/838.pdf","deleted":null,"used":{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":80,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	132	2017-03-21 14:37:04.548826	13	132
6525	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":50,"location_y":50,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-22 09:53:36.414292	13	131
6526	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-22 09:54:10.462687	13	131
6527	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-22 09:54:15.42455	13	131
6528	Facility	Параметр объекта "Принцип грунтов основания" изменен на "1"\nПараметр объекта "Глубина фундамента" изменен на "0"\nПараметр объекта "СТС/СМС" изменен на "0"\nПараметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":null,"location_x":628,"location_y":496,"state_id":"1","state_name":null,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":"","plan_id":80,"plan_name":"Куст 31_Поз. 8","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/839.jpg","jpg_id":839,"pdf_url":"/f/14/837.pdf","calc_pdf_url":"/f/14/838.pdf","pdf_id":837,"plan":{"id":80,"name":"Куст 31_Поз. 8 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":837,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/837.pdf","jpg_id":839,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/839.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":838,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/838.pdf","deleted":null,"used":{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":628,"location_y":496,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":null,"plan_id":80,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	132	2017-03-22 13:12:30.544839	13	132
6529	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":628,"location_y":496,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":"","plan_id":80,"plan_name":"Куст 31_Поз. 8","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/839.jpg","jpg_id":839,"pdf_url":"/f/14/837.pdf","calc_pdf_url":"/f/14/838.pdf","pdf_id":837,"plan":{"id":80,"name":"Куст 31_Поз. 8 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":837,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/837.pdf","jpg_id":839,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/839.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":838,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/838.pdf","deleted":null,"used":{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":628,"location_y":496,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":null,"plan_id":80,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null}},"urn_encoded":null}	132	2017-03-22 13:13:24.850171	13	132
6530	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"свайный","base_principle_id":"1","base_principle_name":"&#8544;","location_x":628,"location_y":496,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":"","plan_id":80,"plan_name":"Куст 31_Поз. 8","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/839.jpg","jpg_id":839,"pdf_url":"/f/14/837.pdf","calc_pdf_url":"/f/14/838.pdf","pdf_id":837,"plan":{"id":80,"name":"Куст 31_Поз. 8 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":837,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/837.pdf","jpg_id":839,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/839.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":838,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/838.pdf","deleted":null,"used":{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":"свайный","base_construction":null,"base_principle_id":1,"location_x":628,"location_y":496,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":null,"plan_id":80,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null}},"urn_encoded":null}	132	2017-03-22 13:13:31.020632	13	132
6531	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"нет","base_type":"свайный","base_principle_id":"1","base_principle_name":"&#8544;","location_x":628,"location_y":496,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":"","plan_id":80,"plan_name":"Куст 31_Поз. 8","view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/839.jpg","jpg_id":839,"pdf_url":"/f/14/837.pdf","calc_pdf_url":"/f/14/838.pdf","pdf_id":837,"plan":{"id":80,"name":"Куст 31_Поз. 8 (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":837,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/837.pdf","jpg_id":839,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/839.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":838,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/838.pdf","deleted":null,"used":{"id":132,"parent_id":131,"name":"Поз. 8","ordering":132,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"нет","base_type":"свайный","base_construction":null,"base_principle_id":1,"location_x":628,"location_y":496,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":"598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;","dumping_depth":null,"plan_id":80,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"сооружение","stamp_data":null}},"urn_encoded":null}	132	2017-03-22 13:13:37.445538	13	132
6532	Sensor	Создан новый элемент Репер "Рп"	{"id":419,"facility_id":"131","name":"Рп","location_x":186,"location_y":136,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	131	2017-03-22 16:07:55.535859	13	419
6533	Sensor	Создан новый элемент ПС "ПС"	{"id":420,"facility_id":"131","name":"ПС","location_x":190,"location_y":254,"allowed_model_type_id":"2","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	131	2017-03-22 16:08:06.595431	13	420
6534	Sensor	Создан новый элемент ГДМ "ГДМ"	{"id":421,"facility_id":"131","name":"ГДМ","location_x":187,"location_y":397,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":5,"deep_step":5,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	131	2017-03-22 16:08:45.337718	13	421
6535	Sensor	Создан новый элемент ДМ (наварной) "ДМ"	{"id":422,"facility_id":"131","name":"ДМ","location_x":196,"location_y":489,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	131	2017-03-22 16:09:25.926711	13	422
6536	Sensor	Создан новый элемент ТС (вертикальная) "ТС"	{"id":423,"facility_id":"131","name":"ТС","location_x":192,"location_y":653,"allowed_model_type_id":"8","state_id":"1","is_retranslator":"0","deep":11,"deep_step":0.5,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	131	2017-03-22 16:09:57.589875	13	423
6538	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-23 11:18:41.926702	13	122
6539	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":2,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":2,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-23 11:18:50.822464	13	122
6540	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-23 11:18:58.836543	13	122
6541	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.25,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-23 11:19:09.451556	13	122
6542	Facility	Параметр объекта "Уровень естественной поверхности" изменен на ""\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":null,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-23 11:19:20.552574	13	122
6559	SensorValue	Высота, мм элемента {Рп} на 16-03-2017 = 1	{"id":4154,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 13:56:49","value":1,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 13:57:04.010953	13	4154
6562	SensorValue	Высота, мм элемента {ДМ} на 14-03-2017 = 1	{"id":4156,"sensor_id":422,"value":1,"date_use":"14-03-2017","allowed_value_type_id":6}	131	2017-03-23 13:57:46.715972	13	4156
6582	SensorValue	Температура элемента {ТС} на глубине 2(м), на 14-03-2017 = -2	{"id":4167,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":722}	131	2017-03-23 14:01:52.153214	13	4167
6543	Facility	Параметр объекта "Уровень естественной поверхности" изменен на "1"\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"1","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":1,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 13:55:39.348338	13	131
6544	Facility	Параметр объекта "Уровень естественной поверхности" изменен на "5"\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"5","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":5,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 13:55:47.449762	13	131
6545	SensorValue	УГВ, м элемента {ПС} на 14-03-2017 = 1	{"id":4146,"sensor_id":420,"value":1,"date_use":"14-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:50.715255	13	4146
6546	SensorValue	УГВ, м элемента {ПС} на 15-03-2017 = 2	{"id":4147,"sensor_id":420,"value":2,"date_use":"15-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:51.435228	13	4147
6547	SensorValue	УГВ, м элемента {ПС} на 16-03-2017 = 3	{"id":4148,"sensor_id":420,"value":3,"date_use":"16-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:52.18132	13	4148
6548	SensorValue	УГВ, м элемента {ПС} на 17-03-2017 = 4	{"id":4149,"sensor_id":420,"value":4,"date_use":"17-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:52.969767	13	4149
6549	SensorValue	УГВ, м элемента {ПС} на 18-03-2017 = 5	{"id":4150,"sensor_id":420,"value":5,"date_use":"18-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:53.959104	13	4150
6550	SensorValue	УГВ, м элемента {ПС} на 19-03-2017 = 6	{"id":4151,"sensor_id":420,"value":6,"date_use":"19-03-2017","allowed_value_type_id":2}	131	2017-03-23 13:55:54.963759	13	4151
6551	Facility	Параметр объекта "Допустимая величина деформации" изменен на "0.4"\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"5","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"","allowed_deformation":"0.4","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":5,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":null,"allowed_deformation":0.4,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 13:56:10.035304	13	131
6552	Facility	Параметр объекта "Максимальная допустимая температура" изменен на "-1"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"5","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"0.4","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":5,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":0.4,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 13:56:15.013288	13	131
6553	SensorValue	Высота, мм элемента {Рп} на 14-03-2017 = 1	{"id":4152,"sensor_id":419,"value":1,"date_use":"14-03-2017","allowed_value_type_id":1}	131	2017-03-23 13:56:39.804927	13	4152
6554	SensorValue	Высота, мм элемента {Рп} на 15-03-2017 = 1	{"id":4153,"sensor_id":419,"value":1,"date_use":"15-03-2017","allowed_value_type_id":1}	131	2017-03-23 13:56:41.293001	13	4153
6555	SensorValue	Высота, мм элемента {Рп} на 16-03-2017 = 1.5	{"id":4154,"sensor_id":419,"value":1.5,"date_use":"16-03-2017","allowed_value_type_id":1}	131	2017-03-23 13:56:49.528239	13	4154
6556	SensorValue	Высота, мм элемента {Рп} на 17-03-2017 = 1.2	{"id":4155,"sensor_id":419,"value":1.2,"date_use":"17-03-2017","allowed_value_type_id":1}	131	2017-03-23 13:56:53.98421	13	4155
6566	Facility	Параметр объекта "Допустимая величина деформации" изменен на "1"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"5","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"1","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":5,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:00:49.589491	13	131
6567	SensorValue	Высота, мм элемента {ДМ} на 17-03-2017 = null	{"id":4159,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:54","value":null,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:00:55.949823	13	4159
6568	SensorValue	Высота, мм элемента {ДМ} на 16-03-2017 = null	{"id":4158,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:51","value":null,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:00:56.67816	13	4158
6569	SensorValue	Высота, мм элемента {ДМ} на 15-03-2017 = null	{"id":4157,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:47","value":null,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:00:57.564851	13	4157
6570	SensorValue	Высота, мм элемента {ДМ} на 15-03-2017 = 1	{"id":4157,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:47","value":1,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:01:00.985475	13	4157
6571	SensorValue	Высота, мм элемента {ДМ} на 16-03-2017 = 2	{"id":4158,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:51","value":2,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:01:02.517322	13	4158
6572	SensorValue	Высота, мм элемента {ДМ} на 17-03-2017 = 3	{"id":4159,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:54","value":3,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:01:03.648975	13	4159
6573	SensorValue	Высота, мм элемента {ДМ} на 18-03-2017 = 10	{"id":4160,"sensor_id":422,"value":10,"date_use":"18-03-2017","allowed_value_type_id":6}	131	2017-03-23 14:01:06.24015	13	4160
6574	SensorValue	Высота, мм элемента {ДМ} на 19-03-2017 = 50	{"id":4161,"sensor_id":422,"value":50,"date_use":"19-03-2017","allowed_value_type_id":6}	131	2017-03-23 14:01:08.354959	13	4161
6575	SensorValue	Высота, мм элемента {ДМ} на 20-03-2017 = 100	{"id":4162,"sensor_id":422,"value":100,"date_use":"20-03-2017","allowed_value_type_id":6}	131	2017-03-23 14:01:10.458853	13	4162
6576	Facility	Параметр объекта "Допустимая величина деформации" изменен на "-1"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"5","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"-1","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":5,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":-1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:01:16.628554	13	131
6577	Facility	Параметр объекта "Уровень естественной поверхности" изменен на "4"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"-1","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":-1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:01:28.633365	13	131
6578	SensorValue	Температура элемента {ТС} на глубине 0(м), на 14-03-2017 = -2	{"id":4163,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":718}	131	2017-03-23 14:01:47.916066	13	4163
6579	SensorValue	Температура элемента {ТС} на глубине 0.5(м), на 14-03-2017 = -2	{"id":4164,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":719}	131	2017-03-23 14:01:48.385875	13	4164
6580	SensorValue	Температура элемента {ТС} на глубине 1(м), на 14-03-2017 = -2	{"id":4165,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":720}	131	2017-03-23 14:01:49.349765	13	4165
6581	SensorValue	Температура элемента {ТС} на глубине 1.5(м), на 14-03-2017 = -2	{"id":4166,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":721}	131	2017-03-23 14:01:50.358775	13	4166
6583	SensorValue	Температура элемента {ТС} на глубине 2.5(м), на 14-03-2017 = -2	{"id":4168,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":723}	131	2017-03-23 14:01:52.153214	13	4168
6584	SensorValue	Температура элемента {ТС} на глубине 3(м), на 14-03-2017 = -2	{"id":4169,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":724}	131	2017-03-23 14:01:52.153214	13	4169
6585	SensorValue	Температура элемента {ТС} на глубине 3.5(м), на 14-03-2017 = -2	{"id":4170,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":725}	131	2017-03-23 14:01:52.153214	13	4170
6586	SensorValue	Температура элемента {ТС} на глубине 4(м), на 14-03-2017 = -2	{"id":4171,"sensor_id":423,"value":-2,"date_use":"14-03-2017","braid_id":726}	131	2017-03-23 14:01:52.153214	13	4171
6587	SensorValue	Температура элемента {ТС} на глубине 0(м), на 15-03-2017 = -1	{"id":4172,"sensor_id":423,"value":-1,"date_use":"15-03-2017","braid_id":718}	131	2017-03-23 14:01:57.3287	13	4172
6588	SensorValue	Температура элемента {ТС} на глубине 0(м), на 16-03-2017 = -0.9	{"id":4173,"sensor_id":423,"value":-0.9,"date_use":"16-03-2017","braid_id":718}	131	2017-03-23 14:02:05.070089	13	4173
6589	SensorValue	Температура элемента {ТС} на глубине 0.5(м), на 15-03-2017 = -0.9	{"id":4174,"sensor_id":423,"value":-0.9,"date_use":"15-03-2017","braid_id":719}	131	2017-03-23 14:02:13.901612	13	4174
6590	SensorValue	Температура элемента {ТС} на глубине 1(м), на 15-03-2017 = -2	{"id":4175,"sensor_id":423,"value":-2,"date_use":"15-03-2017","braid_id":720}	131	2017-03-23 14:02:17.445484	13	4175
6591	Facility	Параметр объекта "Допустимая величина деформации" изменен на "1"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"1","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":1,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:02:36.437255	13	131
6592	SensorValue	Высота, мм элемента {Рп} на 18-03-2017 = 1	{"id":4176,"sensor_id":419,"value":1,"date_use":"18-03-2017","allowed_value_type_id":1}	131	2017-03-23 14:02:57.445399	13	4176
6593	SensorValue	Высота, мм элемента {Рп} на 20-03-2017 = 2	{"id":4177,"sensor_id":419,"value":2,"date_use":"20-03-2017","allowed_value_type_id":1}	131	2017-03-23 14:02:59.122947	13	4177
6594	SensorValue	Высота, мм элемента {Рп} на 19-03-2017 = 2	{"id":4178,"sensor_id":419,"value":2,"date_use":"19-03-2017","allowed_value_type_id":1}	131	2017-03-23 14:03:01.252261	13	4178
6595	SensorValue	Высота, мм элемента {Рп} на 20-03-2017 = 1	{"id":4177,"sensor_id":419,"sensor_name":"Рп","date_cr":"23.03.2017 14:02:59","value":1,"date_use":"20-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:03:03.372639	13	4177
6596	SensorValue	Высота, мм элемента {ГДМ} на 14-03-2017 = 1	{"id":4179,"sensor_id":421,"value":1,"date_use":"14-03-2017","allowed_value_type_id":12}	131	2017-03-23 14:03:38.520428	13	4179
6597	SensorValue	Высота, мм элемента {ГДМ} на 15-03-2017 = 1	{"id":4180,"sensor_id":421,"value":1,"date_use":"15-03-2017","allowed_value_type_id":12}	131	2017-03-23 14:03:39.86615	13	4180
6598	SensorValue	Высота, мм элемента {ГДМ} на 16-03-2017 = 2	{"id":4181,"sensor_id":421,"value":2,"date_use":"16-03-2017","allowed_value_type_id":12}	131	2017-03-23 14:03:40.740234	13	4181
6599	SensorValue	Высота, мм элемента {ГДМ} на 17-03-2017 = 3	{"id":4182,"sensor_id":421,"value":3,"date_use":"17-03-2017","allowed_value_type_id":12}	131	2017-03-23 14:03:42.062652	13	4182
6600	SensorValue	Высота, мм элемента {ГДМ} на 18-03-2017 = 4	{"id":4183,"sensor_id":421,"value":4,"date_use":"18-03-2017","allowed_value_type_id":12}	131	2017-03-23 14:03:44.716843	13	4183
6601	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 1	{"id":4184,"sensor_id":421,"value":1,"date_use":"14-03-2017","braid_id":716}	131	2017-03-23 14:03:51.839879	13	4184
6602	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 0.9	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":0.9,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:04:08.479248	13	4184
6603	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 1	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":1,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:04:14.007363	13	4184
6622	SensorValue	Высота, мм элемента {ГДМ} на 17-03-2017 = 1	{"id":4182,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:42","value":1,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:33:49.728207	13	4182
6623	SensorValue	Высота, мм элемента {ГДМ} на 18-03-2017 = 1	{"id":4183,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:44","value":1,"date_use":"18-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:33:50.490864	13	4183
6604	Facility	Параметр объекта "Допустимая величина деформации" изменен на "0.4"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"0.4","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":0.4,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:10:39.406451	13	131
6605	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 1	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":1,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:10:43.578892	13	4184
6606	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 0	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":0,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:10:46.075941	13	4184
6607	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 0.4	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":0.4,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:10:53.836174	13	4184
6608	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 14-03-2017 = 0.4	{"id":4185,"sensor_id":421,"value":0.4,"date_use":"14-03-2017","braid_id":715}	131	2017-03-23 14:11:03.092319	13	4185
6609	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 14-03-2017 = 1	{"id":4185,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:03","value":1,"date_use":"14-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:11:05.437337	13	4185
6610	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 1	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":1,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:11:07.289233	13	4184
6611	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 15-03-2017 = 1	{"id":4186,"sensor_id":421,"value":1,"date_use":"15-03-2017","braid_id":716}	131	2017-03-23 14:11:09.07081	13	4186
6612	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 15-03-2017 = 1	{"id":4187,"sensor_id":421,"value":1,"date_use":"15-03-2017","braid_id":715}	131	2017-03-23 14:11:10.532207	13	4187
6613	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 16-03-2017 = 1.5	{"id":4188,"sensor_id":421,"value":1.5,"date_use":"16-03-2017","braid_id":716}	131	2017-03-23 14:11:14.902612	13	4188
6614	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 16-03-2017 = 2	{"id":4189,"sensor_id":421,"value":2,"date_use":"16-03-2017","braid_id":715}	131	2017-03-23 14:11:17.157275	13	4189
6615	SensorValue	Высота, мм элемента {ГДМ} на 14-03-2017 = 0.4	{"id":4179,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:38","value":0.4,"date_use":"14-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:18:02.514369	13	4179
6616	SensorValue	Высота, мм элемента {ГДМ} на 15-03-2017 = 0.4	{"id":4180,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:39","value":0.4,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:18:07.153106	13	4180
6617	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 50	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":50,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:18:13.340537	13	4184
6618	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 14-03-2017 = 45	{"id":4185,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:03","value":45,"date_use":"14-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:18:15.760775	13	4185
6619	SensorValue	Высота, мм элемента {ГДМ} на 14-03-2017 = 1	{"id":4179,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:38","value":1,"date_use":"14-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:33:44.430939	13	4179
6620	SensorValue	Высота, мм элемента {ГДМ} на 15-03-2017 = 1	{"id":4180,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:39","value":1,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:33:47.12175	13	4180
6621	SensorValue	Высота, мм элемента {ГДМ} на 16-03-2017 = 1	{"id":4181,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:40","value":1,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:33:48.834612	13	4181
6658	SensorValue	УГВ, м элемента {ПС_тест1} на 20-03-2017 = 13	{"id":4198,"sensor_id":418,"value":13,"date_use":"20-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:01.127751	13	4198
6624	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 1	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":1,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:52.715436	13	4184
6625	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 14-03-2017 = 1	{"id":4185,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:03","value":1,"date_use":"14-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:53.648843	13	4185
6626	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 15-03-2017 = 1	{"id":4187,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:10","value":1,"date_use":"15-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:54.300534	13	4187
6627	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 15-03-2017 = 11	{"id":4186,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:09","value":11,"date_use":"15-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:55.922983	13	4186
6628	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 15-03-2017 = 1	{"id":4186,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:09","value":1,"date_use":"15-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:57.592748	13	4186
6629	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 16-03-2017 = 1	{"id":4189,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:17","value":1,"date_use":"16-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:58.70133	13	4189
6630	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 16-03-2017 = 1	{"id":4188,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:14","value":1,"date_use":"16-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:33:59.692772	13	4188
6631	SensorValue	Высота, мм элемента {ГДМ} на 14-03-2017 = 0	{"id":4179,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:38","value":0,"date_use":"14-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:34:07.465044	13	4179
6632	SensorValue	Высота, мм элемента {ГДМ} на 15-03-2017 = 0	{"id":4180,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:39","value":0,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:34:09.446295	13	4180
6633	Facility	Параметр объекта "Допустимая величина деформации" изменен на "10"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"10","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":10,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:39:11.404513	13	131
6634	Facility	Параметр объекта "Допустимая величина деформации" изменен на "100"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","allowed_deformation":"100","show_explication":"1","show_convention":"1","convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":252,"table_y":58,"element_size":1,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":100,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-03-23 14:39:38.065884	13	131
6635	SensorValue	Высота, мм элемента {ДМ} на 14-03-2017 = 1000	{"id":4156,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:46","value":1000,"date_use":"14-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:04.429858	13	4156
6636	SensorValue	Высота, мм элемента {ДМ} на 15-03-2017 = 1100	{"id":4157,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:47","value":1100,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:16.608633	13	4157
6637	SensorValue	Высота, мм элемента {ДМ} на 16-03-2017 = 2000	{"id":4158,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:51","value":2000,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:25.401489	13	4158
6638	SensorValue	Высота, мм элемента {ДМ} на 17-03-2017 = 100000	{"id":4159,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 13:57:54","value":100000,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:29.857784	13	4159
6639	SensorValue	Высота, мм элемента {ДМ} на 18-03-2017 = 0	{"id":4160,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 14:01:06","value":0,"date_use":"18-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:33.436218	13	4160
6640	SensorValue	Высота, мм элемента {ДМ} на 19-03-2017 = 1	{"id":4161,"sensor_id":422,"sensor_name":"ДМ","date_cr":"23.03.2017 14:01:08","value":1,"date_use":"19-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:35.900457	13	4161
6641	SensorValue	Высота, мм элемента {ГДМ} на 14-03-2017 = 35000	{"id":4179,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:38","value":35000,"date_use":"14-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:47.91264	13	4179
6642	SensorValue	Высота, мм элемента {ГДМ} на 15-03-2017 = 35200	{"id":4180,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:39","value":35200,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	131	2017-03-23 14:41:56.555307	13	4180
6643	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 14-03-2017 = 35000	{"id":4184,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:03:51","value":35000,"date_use":"14-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:42:01.873457	13	4184
6644	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 14-03-2017 = 30000	{"id":4185,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:03","value":30000,"date_use":"14-03-2017","braid_id":715,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:42:08.956834	13	4185
6645	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 15-03-2017 = 35100	{"id":4186,"sensor_id":421,"sensor_name":"ГДМ","date_cr":"23.03.2017 14:11:09","value":35100,"date_use":"15-03-2017","braid_id":716,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	131	2017-03-23 14:42:18.337154	13	4186
6646	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 17-03-2017 = 5	{"id":4190,"sensor_id":421,"value":5,"date_use":"17-03-2017","braid_id":716}	131	2017-03-24 13:24:02.953542	13	4190
6647	SensorValue	Температура элемента {ГДМ} на глубине 5(м), на 17-03-2017 = 7	{"id":4191,"sensor_id":421,"value":7,"date_use":"17-03-2017","braid_id":715}	131	2017-03-24 13:24:04.976473	13	4191
6648	SensorValue	Температура элемента {ГДМ} на глубине 0(м), на 18-03-2017 = 16	{"id":4192,"sensor_id":421,"value":16,"date_use":"18-03-2017","braid_id":716}	131	2017-03-24 13:24:07.351919	13	4192
6649	SensorValue	УГВ, м элемента {ПС_тест1} на 15-03-2017 = null	{"id":4193,"sensor_id":418,"value":null,"date_use":"15-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:36:28.883002	13	4193
6650	Facility	Параметр объекта "Уровень естественной поверхности" изменен на "10"\nПараметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:36:41.996975	13	122
6651	SensorValue	УГВ, м элемента {ПС_тест1} на 15-03-2017 = 8	{"id":4193,"sensor_id":418,"sensor_name":"ПС_тест1","date_cr":"24.03.2017 13:36:28","value":8,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":2,"allowed_value_type_name":"УГВ","allowed_value_type_code":"h"}	122	2017-03-24 13:36:48.833381	13	4193
6652	SensorValue	УГВ, м элемента {ПС_тест1} на 16-03-2017 = 9	{"id":4194,"sensor_id":418,"value":9,"date_use":"16-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:36:49.858845	13	4194
6653	SensorValue	УГВ, м элемента {ПС_тест1} на 18-03-2017 = 0	{"id":4195,"sensor_id":418,"value":0,"date_use":"18-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:36:51.699725	13	4195
6654	SensorValue	УГВ, м элемента {ПС_тест1} на 17-03-2017 = 1	{"id":4196,"sensor_id":418,"value":1,"date_use":"17-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:36:53.51207	13	4196
6655	SensorValue	УГВ, м элемента {ПС_тест1} на 17-03-2017 = 10	{"id":4196,"sensor_id":418,"sensor_name":"ПС_тест1","date_cr":"24.03.2017 13:36:53","value":10,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":2,"allowed_value_type_name":"УГВ","allowed_value_type_code":"h"}	122	2017-03-24 13:36:55.453525	13	4196
6656	SensorValue	УГВ, м элемента {ПС_тест1} на 18-03-2017 = 11	{"id":4195,"sensor_id":418,"sensor_name":"ПС_тест1","date_cr":"24.03.2017 13:36:51","value":11,"date_use":"18-03-2017","braid_id":null,"allowed_value_type_id":2,"allowed_value_type_name":"УГВ","allowed_value_type_code":"h"}	122	2017-03-24 13:36:56.955615	13	4195
6657	SensorValue	УГВ, м элемента {ПС_тест1} на 19-03-2017 = 12	{"id":4197,"sensor_id":418,"value":12,"date_use":"19-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:36:59.090541	13	4197
6659	SensorValue	УГВ, м элемента {ПС_тест3} на 15-03-2017 = 7	{"id":4199,"sensor_id":416,"value":7,"date_use":"15-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:08.703995	13	4199
6660	SensorValue	УГВ, м элемента {ПС_тест3} на 16-03-2017 = 8	{"id":4200,"sensor_id":416,"value":8,"date_use":"16-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:09.32744	13	4200
6661	SensorValue	УГВ, м элемента {ПС_тест3} на 17-03-2017 = 9	{"id":4201,"sensor_id":416,"value":9,"date_use":"17-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:10.271476	13	4201
6662	SensorValue	УГВ, м элемента {ПС_тест3} на 18-03-2017 = 10	{"id":4202,"sensor_id":416,"value":10,"date_use":"18-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:12.017664	13	4202
6663	SensorValue	УГВ, м элемента {ПС_тест3} на 19-03-2017 = 11	{"id":4203,"sensor_id":416,"value":11,"date_use":"19-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:13.326111	13	4203
6664	SensorValue	УГВ, м элемента {ПС_тест3} на 20-03-2017 = 12	{"id":4204,"sensor_id":416,"value":12,"date_use":"20-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:14.860307	13	4204
6665	SensorValue	УГВ, м элемента {ПС_тест2} на 15-03-2017 = 9	{"id":4205,"sensor_id":417,"value":9,"date_use":"15-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:20.498754	13	4205
6666	SensorValue	УГВ, м элемента {ПС_тест2} на 16-03-2017 = 10	{"id":4206,"sensor_id":417,"value":10,"date_use":"16-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:22.048221	13	4206
6667	SensorValue	УГВ, м элемента {ПС_тест2} на 17-03-2017 = 11	{"id":4207,"sensor_id":417,"value":11,"date_use":"17-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:23.533827	13	4207
6668	SensorValue	УГВ, м элемента {ПС_тест2} на 18-03-2017 = 12	{"id":4208,"sensor_id":417,"value":12,"date_use":"18-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:25.084945	13	4208
6669	SensorValue	УГВ, м элемента {ПС_тест2} на 19-03-2017 = 13	{"id":4209,"sensor_id":417,"value":13,"date_use":"19-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:25.755984	13	4209
6670	SensorValue	УГВ, м элемента {ПС_тест2} на 20-03-2017 = 14	{"id":4210,"sensor_id":417,"value":14,"date_use":"20-03-2017","allowed_value_type_id":2}	122	2017-03-24 13:37:26.8009	13	4210
6671	Facility	Параметр объекта "Допустимая величина деформации" изменен на ""\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:40:44.161705	13	122
6672	Facility	Параметр объекта "Допустимая величина деформации" изменен на "100"\nПараметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"100","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":100,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:44:12.704107	13	122
6673	SensorValue	Высота, мм элемента {РП_тест1} на 15-03-2017 = 3000	{"id":4211,"sensor_id":410,"value":3000,"date_use":"15-03-2017","allowed_value_type_id":1}	122	2017-03-24 13:44:32.567472	13	4211
6674	SensorValue	Высота, мм элемента {РП_тест1} на 16-03-2017 = 3019	{"id":4212,"sensor_id":410,"value":3019,"date_use":"16-03-2017","allowed_value_type_id":1}	122	2017-03-24 13:44:42.311427	13	4212
6675	SensorValue	Высота, мм элемента {РП_тест1} на 16-03-2017 = 3000	{"id":4212,"sensor_id":410,"sensor_name":"РП_тест1","date_cr":"24.03.2017 13:44:42","value":3000,"date_use":"16-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-24 13:44:49.358563	13	4212
6676	SensorValue	Высота, мм элемента {РП_тест1} на 17-03-2017 = 300	{"id":4213,"sensor_id":410,"value":300,"date_use":"17-03-2017","allowed_value_type_id":1}	122	2017-03-24 13:45:00.397131	13	4213
6692	SensorValue	Температура элемента {ТС_тест 2} на глубине 7.5(м), на 15-03-2017 = -7.5	{"id":4221,"sensor_id":405,"value":-7.5,"date_use":"15-03-2017","braid_id":632}	122	2017-03-24 13:53:23.57297	13	4221
6693	SensorValue	Температура элемента {ТС_тест 2} на глубине 7(м), на 15-03-2017 = -7	{"id":4222,"sensor_id":405,"value":-7,"date_use":"15-03-2017","braid_id":631}	122	2017-03-24 13:53:25.636594	13	4222
6694	SensorValue	Температура элемента {ТС_тест 2} на глубине 6.5(м), на 15-03-2017 = -6.5	{"id":4223,"sensor_id":405,"value":-6.5,"date_use":"15-03-2017","braid_id":630}	122	2017-03-24 13:53:29.080316	13	4223
6677	Facility	Параметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"100","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":100,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:45:00.530216	13	122
6678	SensorValue	Высота, мм элемента {РП_тест1} на 17-03-2017 = 3010	{"id":4213,"sensor_id":410,"sensor_name":"РП_тест1","date_cr":"24.03.2017 13:45:00","value":3010,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-24 13:45:06.004403	13	4213
6679	Facility	Параметр объекта "Максимальная допустимая температура" изменен на ""\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"","allowed_deformation":"100","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":100,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:48:33.715967	13	122
6680	Facility	Параметр объекта "Максимальная допустимая температура" изменен на "-1"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"100","show_explication":"1","show_convention":"1","convention_x":2187,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":100,"show_explication":1,"show_convention":1,"convention_x":2187,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-24 13:52:07.234242	13	122
6681	SensorValue	Температура элемента {ТС_тест 2} на глубине 10(м), на 15-03-2017 = -10	{"id":4214,"sensor_id":405,"value":-10,"date_use":"15-03-2017","braid_id":637}	122	2017-03-24 13:52:27.613529	13	4214
6682	SensorValue	Температура элемента {ТС_тест 2} на глубине 9.5(м), на 15-03-2017 = -95	{"id":4215,"sensor_id":405,"value":-95,"date_use":"15-03-2017","braid_id":636}	122	2017-03-24 13:52:32.903701	13	4215
6683	SensorValue	Температура элемента {ТС_тест 2} на глубине 9.5(м), на 15-03-2017 = -95.5	{"id":4215,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:52:32","value":-95.5,"date_use":"15-03-2017","braid_id":636,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:52:38.176186	13	4215
6684	SensorValue	Температура элемента {ТС_тест 2} на глубине 9.5(м), на 15-03-2017 = -9.5	{"id":4215,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:52:32","value":-9.5,"date_use":"15-03-2017","braid_id":636,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:52:42.951239	13	4215
6685	SensorValue	Температура элемента {ТС_тест 2} на глубине 10.5(м), на 15-03-2017 = -9.5	{"id":4216,"sensor_id":405,"value":-9.5,"date_use":"15-03-2017","braid_id":638}	122	2017-03-24 13:53:02.280446	13	4216
6686	SensorValue	Температура элемента {ТС_тест 2} на глубине 11(м), на 15-03-2017 = -10	{"id":4217,"sensor_id":405,"value":-10,"date_use":"15-03-2017","braid_id":639}	122	2017-03-24 13:53:02.280446	13	4217
6687	SensorValue	Температура элемента {ТС_тест 2} на глубине 10.5(м), на 15-03-2017 = null	{"id":4216,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:53:02","value":null,"date_use":"15-03-2017","braid_id":638,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:53:04.022485	13	4216
6688	SensorValue	Температура элемента {ТС_тест 2} на глубине 11(м), на 15-03-2017 = null	{"id":4217,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:53:02","value":null,"date_use":"15-03-2017","braid_id":639,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:53:04.022485	13	4217
6689	SensorValue	Температура элемента {ТС_тест 2} на глубине 9(м), на 15-03-2017 = -9	{"id":4218,"sensor_id":405,"value":-9,"date_use":"15-03-2017","braid_id":635}	122	2017-03-24 13:53:13.41806	13	4218
6690	SensorValue	Температура элемента {ТС_тест 2} на глубине 8.5(м), на 15-03-2017 = -8.5	{"id":4219,"sensor_id":405,"value":-8.5,"date_use":"15-03-2017","braid_id":634}	122	2017-03-24 13:53:17.638509	13	4219
6691	SensorValue	Температура элемента {ТС_тест 2} на глубине 8(м), на 15-03-2017 = -8	{"id":4220,"sensor_id":405,"value":-8,"date_use":"15-03-2017","braid_id":633}	122	2017-03-24 13:53:20.463675	13	4220
6695	SensorValue	Температура элемента {ТС_тест 2} на глубине 6(м), на 15-03-2017 = -6	{"id":4224,"sensor_id":405,"value":-6,"date_use":"15-03-2017","braid_id":629}	122	2017-03-24 13:53:31.7484	13	4224
6696	SensorValue	Температура элемента {ТС_тест 2} на глубине 5.5(м), на 15-03-2017 = -5.5	{"id":4225,"sensor_id":405,"value":-5.5,"date_use":"15-03-2017","braid_id":628}	122	2017-03-24 13:53:36.703552	13	4225
6697	SensorValue	Температура элемента {ТС_тест 2} на глубине 5(м), на 15-03-2017 = -5	{"id":4226,"sensor_id":405,"value":-5,"date_use":"15-03-2017","braid_id":627}	122	2017-03-24 13:53:38.766808	13	4226
6698	SensorValue	Температура элемента {ТС_тест 2} на глубине 4.5(м), на 15-03-2017 = -4.5	{"id":4227,"sensor_id":405,"value":-4.5,"date_use":"15-03-2017","braid_id":626}	122	2017-03-24 13:53:41.346425	13	4227
6699	SensorValue	Температура элемента {ТС_тест 2} на глубине 4(м), на 15-03-2017 = -4	{"id":4228,"sensor_id":405,"value":-4,"date_use":"15-03-2017","braid_id":625}	122	2017-03-24 13:53:45.998023	13	4228
6700	SensorValue	Температура элемента {ТС_тест 2} на глубине 3.5(м), на 15-03-2017 = -3.5	{"id":4229,"sensor_id":405,"value":-3.5,"date_use":"15-03-2017","braid_id":624}	122	2017-03-24 13:53:48.904949	13	4229
6701	SensorValue	Температура элемента {ТС_тест 2} на глубине 3(м), на 15-03-2017 = -3	{"id":4230,"sensor_id":405,"value":-3,"date_use":"15-03-2017","braid_id":623}	122	2017-03-24 13:53:51.039268	13	4230
6702	SensorValue	Температура элемента {ТС_тест 2} на глубине 2.5(м), на 15-03-2017 = -2.5	{"id":4231,"sensor_id":405,"value":-2.5,"date_use":"15-03-2017","braid_id":622}	122	2017-03-24 13:53:53.904039	13	4231
6703	SensorValue	Температура элемента {ТС_тест 2} на глубине 2(м), на 15-03-2017 = -2	{"id":4232,"sensor_id":405,"value":-2,"date_use":"15-03-2017","braid_id":621}	122	2017-03-24 13:54:17.993955	13	4232
6704	SensorValue	Температура элемента {ТС_тест 2} на глубине 1.5(м), на 15-03-2017 = -1.5	{"id":4233,"sensor_id":405,"value":-1.5,"date_use":"15-03-2017","braid_id":620}	122	2017-03-24 13:54:21.580626	13	4233
6705	SensorValue	Температура элемента {ТС_тест 2} на глубине 1(м), на 15-03-2017 = -1	{"id":4234,"sensor_id":405,"value":-1,"date_use":"15-03-2017","braid_id":619}	122	2017-03-24 13:54:24.124441	13	4234
6706	SensorValue	Температура элемента {ТС_тест 2} на глубине 1(м), на 16-03-2017 = -1	{"id":4235,"sensor_id":405,"value":-1,"date_use":"16-03-2017","braid_id":619}	122	2017-03-24 13:55:53.865795	13	4235
6707	SensorValue	Температура элемента {ТС_тест 2} на глубине 1.5(м), на 16-03-2017 = -1.5	{"id":4236,"sensor_id":405,"value":-1.5,"date_use":"16-03-2017","braid_id":620}	122	2017-03-24 13:55:53.865795	13	4236
6708	SensorValue	Температура элемента {ТС_тест 2} на глубине 2(м), на 16-03-2017 = -2	{"id":4237,"sensor_id":405,"value":-2,"date_use":"16-03-2017","braid_id":621}	122	2017-03-24 13:55:53.865795	13	4237
6709	SensorValue	Температура элемента {ТС_тест 2} на глубине 2.5(м), на 16-03-2017 = -2.5	{"id":4238,"sensor_id":405,"value":-2.5,"date_use":"16-03-2017","braid_id":622}	122	2017-03-24 13:55:53.865795	13	4238
6710	SensorValue	Температура элемента {ТС_тест 2} на глубине 3(м), на 16-03-2017 = -3	{"id":4239,"sensor_id":405,"value":-3,"date_use":"16-03-2017","braid_id":623}	122	2017-03-24 13:55:53.865795	13	4239
6711	SensorValue	Температура элемента {ТС_тест 2} на глубине 3.5(м), на 16-03-2017 = -3.5	{"id":4240,"sensor_id":405,"value":-3.5,"date_use":"16-03-2017","braid_id":624}	122	2017-03-24 13:55:53.865795	13	4240
6712	SensorValue	Температура элемента {ТС_тест 2} на глубине 4(м), на 16-03-2017 = -4	{"id":4241,"sensor_id":405,"value":-4,"date_use":"16-03-2017","braid_id":625}	122	2017-03-24 13:55:53.865795	13	4241
6713	SensorValue	Температура элемента {ТС_тест 2} на глубине 4.5(м), на 16-03-2017 = -4.5	{"id":4242,"sensor_id":405,"value":-4.5,"date_use":"16-03-2017","braid_id":626}	122	2017-03-24 13:55:53.865795	13	4242
6714	SensorValue	Температура элемента {ТС_тест 2} на глубине 5(м), на 16-03-2017 = -5	{"id":4243,"sensor_id":405,"value":-5,"date_use":"16-03-2017","braid_id":627}	122	2017-03-24 13:55:53.865795	13	4243
6715	SensorValue	Температура элемента {ТС_тест 2} на глубине 5.5(м), на 16-03-2017 = -5.5	{"id":4244,"sensor_id":405,"value":-5.5,"date_use":"16-03-2017","braid_id":628}	122	2017-03-24 13:55:53.865795	13	4244
6716	SensorValue	Температура элемента {ТС_тест 2} на глубине 6(м), на 16-03-2017 = -6	{"id":4245,"sensor_id":405,"value":-6,"date_use":"16-03-2017","braid_id":629}	122	2017-03-24 13:55:53.865795	13	4245
6717	SensorValue	Температура элемента {ТС_тест 2} на глубине 6.5(м), на 16-03-2017 = -6.5	{"id":4246,"sensor_id":405,"value":-6.5,"date_use":"16-03-2017","braid_id":630}	122	2017-03-24 13:55:53.865795	13	4246
6718	SensorValue	Температура элемента {ТС_тест 2} на глубине 7(м), на 16-03-2017 = -7	{"id":4247,"sensor_id":405,"value":-7,"date_use":"16-03-2017","braid_id":631}	122	2017-03-24 13:55:53.865795	13	4247
6719	SensorValue	Температура элемента {ТС_тест 2} на глубине 7.5(м), на 16-03-2017 = -7.5	{"id":4248,"sensor_id":405,"value":-7.5,"date_use":"16-03-2017","braid_id":632}	122	2017-03-24 13:55:53.865795	13	4248
6720	SensorValue	Температура элемента {ТС_тест 2} на глубине 8(м), на 16-03-2017 = -8	{"id":4249,"sensor_id":405,"value":-8,"date_use":"16-03-2017","braid_id":633}	122	2017-03-24 13:55:53.865795	13	4249
6721	SensorValue	Температура элемента {ТС_тест 2} на глубине 8.5(м), на 16-03-2017 = -8.5	{"id":4250,"sensor_id":405,"value":-8.5,"date_use":"16-03-2017","braid_id":634}	122	2017-03-24 13:55:53.865795	13	4250
6722	SensorValue	Температура элемента {ТС_тест 2} на глубине 9(м), на 16-03-2017 = -9	{"id":4251,"sensor_id":405,"value":-9,"date_use":"16-03-2017","braid_id":635}	122	2017-03-24 13:55:53.865795	13	4251
6723	SensorValue	Температура элемента {ТС_тест 2} на глубине 9.5(м), на 16-03-2017 = -9.5	{"id":4252,"sensor_id":405,"value":-9.5,"date_use":"16-03-2017","braid_id":636}	122	2017-03-24 13:55:53.865795	13	4252
6724	SensorValue	Температура элемента {ТС_тест 2} на глубине 10(м), на 16-03-2017 = -10	{"id":4253,"sensor_id":405,"value":-10,"date_use":"16-03-2017","braid_id":637}	122	2017-03-24 13:55:53.865795	13	4253
6725	SensorValue	Температура элемента {ТС_тест 2} на глубине 1(м), на 17-03-2017 = -1	{"id":4254,"sensor_id":405,"value":-1,"date_use":"17-03-2017","braid_id":619}	122	2017-03-24 13:55:58.273621	13	4254
6726	SensorValue	Температура элемента {ТС_тест 2} на глубине 1.5(м), на 17-03-2017 = -1.5	{"id":4255,"sensor_id":405,"value":-1.5,"date_use":"17-03-2017","braid_id":620}	122	2017-03-24 13:55:58.273621	13	4255
6727	SensorValue	Температура элемента {ТС_тест 2} на глубине 2(м), на 17-03-2017 = -2	{"id":4256,"sensor_id":405,"value":-2,"date_use":"17-03-2017","braid_id":621}	122	2017-03-24 13:55:58.273621	13	4256
6728	SensorValue	Температура элемента {ТС_тест 2} на глубине 2.5(м), на 17-03-2017 = -2.5	{"id":4257,"sensor_id":405,"value":-2.5,"date_use":"17-03-2017","braid_id":622}	122	2017-03-24 13:55:58.273621	13	4257
6729	SensorValue	Температура элемента {ТС_тест 2} на глубине 3(м), на 17-03-2017 = -3	{"id":4258,"sensor_id":405,"value":-3,"date_use":"17-03-2017","braid_id":623}	122	2017-03-24 13:55:58.273621	13	4258
6730	SensorValue	Температура элемента {ТС_тест 2} на глубине 3.5(м), на 17-03-2017 = -3.5	{"id":4259,"sensor_id":405,"value":-3.5,"date_use":"17-03-2017","braid_id":624}	122	2017-03-24 13:55:58.273621	13	4259
6731	SensorValue	Температура элемента {ТС_тест 2} на глубине 4(м), на 17-03-2017 = -4	{"id":4260,"sensor_id":405,"value":-4,"date_use":"17-03-2017","braid_id":625}	122	2017-03-24 13:55:58.273621	13	4260
6732	SensorValue	Температура элемента {ТС_тест 2} на глубине 4.5(м), на 17-03-2017 = -4.5	{"id":4261,"sensor_id":405,"value":-4.5,"date_use":"17-03-2017","braid_id":626}	122	2017-03-24 13:55:58.273621	13	4261
6733	SensorValue	Температура элемента {ТС_тест 2} на глубине 5(м), на 17-03-2017 = -5	{"id":4262,"sensor_id":405,"value":-5,"date_use":"17-03-2017","braid_id":627}	122	2017-03-24 13:55:58.273621	13	4262
6734	SensorValue	Температура элемента {ТС_тест 2} на глубине 5.5(м), на 17-03-2017 = -5.5	{"id":4263,"sensor_id":405,"value":-5.5,"date_use":"17-03-2017","braid_id":628}	122	2017-03-24 13:55:58.273621	13	4263
6735	SensorValue	Температура элемента {ТС_тест 2} на глубине 6(м), на 17-03-2017 = -6	{"id":4264,"sensor_id":405,"value":-6,"date_use":"17-03-2017","braid_id":629}	122	2017-03-24 13:55:58.273621	13	4264
6736	SensorValue	Температура элемента {ТС_тест 2} на глубине 6.5(м), на 17-03-2017 = -6.5	{"id":4265,"sensor_id":405,"value":-6.5,"date_use":"17-03-2017","braid_id":630}	122	2017-03-24 13:55:58.273621	13	4265
6737	SensorValue	Температура элемента {ТС_тест 2} на глубине 7(м), на 17-03-2017 = -7	{"id":4266,"sensor_id":405,"value":-7,"date_use":"17-03-2017","braid_id":631}	122	2017-03-24 13:55:58.273621	13	4266
6738	SensorValue	Температура элемента {ТС_тест 2} на глубине 7.5(м), на 17-03-2017 = -7.5	{"id":4267,"sensor_id":405,"value":-7.5,"date_use":"17-03-2017","braid_id":632}	122	2017-03-24 13:55:58.273621	13	4267
6739	SensorValue	Температура элемента {ТС_тест 2} на глубине 8(м), на 17-03-2017 = -8	{"id":4268,"sensor_id":405,"value":-8,"date_use":"17-03-2017","braid_id":633}	122	2017-03-24 13:55:58.273621	13	4268
6740	SensorValue	Температура элемента {ТС_тест 2} на глубине 8.5(м), на 17-03-2017 = -8.5	{"id":4269,"sensor_id":405,"value":-8.5,"date_use":"17-03-2017","braid_id":634}	122	2017-03-24 13:55:58.273621	13	4269
6741	SensorValue	Температура элемента {ТС_тест 2} на глубине 9(м), на 17-03-2017 = -9	{"id":4270,"sensor_id":405,"value":-9,"date_use":"17-03-2017","braid_id":635}	122	2017-03-24 13:55:58.273621	13	4270
6742	SensorValue	Температура элемента {ТС_тест 2} на глубине 9.5(м), на 17-03-2017 = -9.5	{"id":4271,"sensor_id":405,"value":-9.5,"date_use":"17-03-2017","braid_id":636}	122	2017-03-24 13:55:58.273621	13	4271
6743	SensorValue	Температура элемента {ТС_тест 2} на глубине 10(м), на 17-03-2017 = -10	{"id":4272,"sensor_id":405,"value":-10,"date_use":"17-03-2017","braid_id":637}	122	2017-03-24 13:55:58.273621	13	4272
6744	SensorValue	Температура элемента {ТС_тест 2} на глубине 1.5(м), на 17-03-2017 = -1	{"id":4255,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:55:58","value":-1,"date_use":"17-03-2017","braid_id":620,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:56:07.983075	13	4255
6745	SensorValue	Температура элемента {ТС_тест 2} на глубине 1(м), на 17-03-2017 = -0.9	{"id":4254,"sensor_id":405,"sensor_name":"ТС_тест 2","date_cr":"24.03.2017 13:55:58","value":-0.9,"date_use":"17-03-2017","braid_id":619,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-24 13:56:13.602619	13	4254
6746	Facility	Параметр объекта "Допустимая величина деформации" изменен на "200"\n	{"id":123,"parent_id":122,"name":"Поз. 9.1_Факельная установка h=50м","ordering":123,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":17,"protection":"Проектируется","base_type":"Свайный","base_principle_id":"1","base_principle_name":"&#8544;","location_x":1557,"location_y":643,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":10,"frozen_depth":3.5,"clipmap":"1442.000,520.000;1422.000,620.000;1524.000,588.000;","dumping_depth":"386.5","plan_id":66,"plan_name":"Поз.9.1_Совмещенная факельная установка h=50м","view_data":null,"table_x":401,"table_y":160,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"200","show_explication":"1","show_convention":"1","convention_x":614,"convention_y":269,"type":"Факельная установка","stamp_data":null,"comments_length":1,"photos_length":1,"jpg_url":"/f/14/791.jpg","jpg_id":791,"pdf_url":"/f/14/789.pdf","calc_pdf_url":"/f/14/790.pdf","pdf_id":789,"plan":{"id":66,"name":"Поз.9.1_Совмещенная факельная установка h=50м (A2_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":789,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/789.pdf","jpg_id":791,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/791.jpg","format_id":14,"format_name":"A2_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":790,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/790.pdf","deleted":null,"used":{"id":117,"parent_id":116,"name":"Поз.9.1 Совмещенная факельная установка h=50м","ordering":117,"image_id":null,"code":null,"address":null,"load_capacity":null,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":null,"location_x":50,"location_y":50,"state_id":null,"width":null,"height":null,"foundation_depth":null,"frozen_depth":null,"clipmap":null,"dumping_depth":null,"plan_id":66,"view_data":null,"table_x":250,"table_y":50,"element_size":1,"table_size":null,"deleted":null,"date_cr":"2017-01-17","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":250,"convention_y":150,"type":null,"stamp_data":null}},"urn_encoded":null}	123	2017-03-24 13:58:25.686557	13	123
6747	SensorValue	Высота, мм элемента {ДМ1} на 15-03-2017 = 1400	{"id":4273,"sensor_id":396,"value":1400,"date_use":"15-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:58:36.876181	13	4273
6748	SensorValue	Высота, мм элемента {ДМ1} на 15-03-2017 = 200	{"id":4273,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"24.03.2017 13:58:36","value":200,"date_use":"15-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-03-24 13:58:53.929878	13	4273
6749	SensorValue	Высота, мм элемента {ДМ1} на 16-03-2017 = 201	{"id":4274,"sensor_id":396,"value":201,"date_use":"16-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:02.60816	13	4274
6750	SensorValue	Высота, мм элемента {ДМ1} на 17-03-2017 = 220	{"id":4275,"sensor_id":396,"value":220,"date_use":"17-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:06.721146	13	4275
6751	SensorValue	Высота, мм элемента {ДМ1} на 17-03-2017 = 202	{"id":4275,"sensor_id":396,"sensor_name":"ДМ1","date_cr":"24.03.2017 13:59:06","value":202,"date_use":"17-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	123	2017-03-24 13:59:11.911199	13	4275
6752	SensorValue	Высота, мм элемента {ДМ3} на 15-03-2017 = 100	{"id":4276,"sensor_id":398,"value":100,"date_use":"15-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:24.572791	13	4276
6753	SensorValue	Высота, мм элемента {ДМ3} на 16-03-2017 = 150	{"id":4277,"sensor_id":398,"value":150,"date_use":"16-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:28.334996	13	4277
6754	SensorValue	Высота, мм элемента {ДМ3} на 17-03-2017 = 200	{"id":4278,"sensor_id":398,"value":200,"date_use":"17-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:31.364849	13	4278
6755	SensorValue	Высота, мм элемента {ДМ3} на 18-03-2017 = 250	{"id":4279,"sensor_id":398,"value":250,"date_use":"18-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:37.849191	13	4279
6756	SensorValue	Высота, мм элемента {ДМ3} на 19-03-2017 = 300	{"id":4280,"sensor_id":398,"value":300,"date_use":"19-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:41.187218	13	4280
6757	SensorValue	Высота, мм элемента {ДМ3} на 20-03-2017 = 400	{"id":4281,"sensor_id":398,"value":400,"date_use":"20-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:46.721273	13	4281
6758	SensorValue	Высота, мм элемента {ДМ3} на 21-03-2017 = 500	{"id":4282,"sensor_id":398,"value":500,"date_use":"21-03-2017","allowed_value_type_id":6}	123	2017-03-24 13:59:50.245279	13	4282
6759	SensorValue	Высота, мм элемента {ДМ3} на 22-03-2017 = 50	{"id":4283,"sensor_id":398,"value":50,"date_use":"22-03-2017","allowed_value_type_id":6}	123	2017-03-24 14:00:04.053637	13	4283
6760	SensorValue	Высота, мм элемента {ДМ3} на 23-03-2017 = 1	{"id":4284,"sensor_id":398,"value":1,"date_use":"23-03-2017","allowed_value_type_id":6}	123	2017-03-24 14:00:06.264232	13	4284
6761	Sensor	Создан новый элемент ГДМ "разр-1"	{"id":425,"facility_id":"122","name":"разр-1","location_x":1311,"location_y":870,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":3,"deep_step":3,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-28 10:53:12.91154	13	425
6762	Sensor	Создан новый элемент ГДМ "разр-2"	{"id":426,"facility_id":"122","name":"разр-2","location_x":1394,"location_y":900,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":3,"deep_step":3,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-28 10:53:28.454404	13	426
6763	Sensor	Создан новый элемент ГДМ "разр3"	{"id":427,"facility_id":"122","name":"разр3","location_x":1469,"location_y":906,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":3,"deep_step":3,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-28 10:53:50.416403	13	427
6764	Sensor	Элемент {разр3} переименован на "разр-3"\n	{"id":427,"facility_id":122,"facility_name":"Площадка ЦПС","facility_code":null,"name":"разр-3","location_x":1469,"location_y":906,"location_comments":null,"measurement_mode_name":null,"allowed_model_type_id":12,"allowed_model_type_name":"ГДМ","allowed_model_type_code":"gdm","state_id":"1","state_name":"Рабочее","state_code":"work","deep":3,"deep_step":3,"image_ext":null,"image_file_folder_id":null,"angle":0,"deleted":null,"pr_sensor_id":null,"pr_sensor_name":null,"reference_date":"","clipmap":null,"comments_length":0,"photos_length":0,"last_value_date":"-","braids":[{"id":744,"sensor_id":427,"sensor_name":"разр-3","deep":3,"enabled":1},{"id":745,"sensor_id":427,"sensor_name":"разр-3","deep":0,"enabled":1}],"deeps":{"0":745,"3":744}}	122	2017-03-28 10:53:56.009317	13	427
6765	SensorValue	Температура элемента {разр-1} на глубине 0(м), на 19-03-2017 = 2000	{"id":4285,"sensor_id":425,"value":2000,"date_use":"19-03-2017","braid_id":741}	122	2017-03-28 10:55:05.120452	13	4285
6766	SensorValue	Высота, мм элемента {разр-1} на 19-03-2017 = 38000	{"id":4286,"sensor_id":425,"value":38000,"date_use":"19-03-2017","allowed_value_type_id":12}	122	2017-03-28 10:57:51.325066	13	4286
6767	SensorValue	Температура элемента {разр-1} на глубине 0(м), на 19-03-2017 = 38000	{"id":4285,"sensor_id":425,"sensor_name":"разр-1","date_cr":"28.03.2017 10:55:05","value":38000,"date_use":"19-03-2017","braid_id":741,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 10:58:07.279944	13	4285
6768	SensorValue	Температура элемента {разр-1} на глубине 3(м), на 19-03-2017 = 35000	{"id":4287,"sensor_id":425,"value":35000,"date_use":"19-03-2017","braid_id":740}	122	2017-03-28 10:58:14.564158	13	4287
6769	SensorValue	Высота, мм элемента {разр-2} на 19-03-2017 = 38000	{"id":4288,"sensor_id":426,"value":38000,"date_use":"19-03-2017","allowed_value_type_id":12}	122	2017-03-28 10:58:23.711581	13	4288
6770	SensorValue	Температура элемента {разр-2} на глубине 0(м), на 19-03-2017 = 38000	{"id":4289,"sensor_id":426,"value":38000,"date_use":"19-03-2017","braid_id":743}	122	2017-03-28 10:58:29.472421	13	4289
6771	SensorValue	Температура элемента {разр-2} на глубине 3(м), на 19-03-2017 = 35000	{"id":4290,"sensor_id":426,"value":35000,"date_use":"19-03-2017","braid_id":742}	122	2017-03-28 10:58:32.228213	13	4290
6772	SensorValue	Высота, мм элемента {разр-3} на 19-03-2017 = 38000	{"id":4291,"sensor_id":427,"value":38000,"date_use":"19-03-2017","allowed_value_type_id":12}	122	2017-03-28 10:58:39.639602	13	4291
6773	SensorValue	Температура элемента {разр-3} на глубине 0(м), на 19-03-2017 = 38000	{"id":4292,"sensor_id":427,"value":38000,"date_use":"19-03-2017","braid_id":745}	122	2017-03-28 10:58:42.460318	13	4292
6774	SensorValue	Температура элемента {разр-3} на глубине 3(м), на 19-03-2017 = 35000	{"id":4293,"sensor_id":427,"value":35000,"date_use":"19-03-2017","braid_id":744}	122	2017-03-28 10:58:49.482674	13	4293
6775	SensorValue	Высота, мм элемента {разр-1} на 20-03-2017 = 38200	{"id":4294,"sensor_id":425,"value":38200,"date_use":"20-03-2017","allowed_value_type_id":12}	122	2017-03-28 10:58:55.936842	13	4294
6776	SensorValue	Высота, мм элемента {разр-1} на 21-03-2017 = 38300	{"id":4295,"sensor_id":425,"value":38300,"date_use":"21-03-2017","allowed_value_type_id":12}	122	2017-03-28 10:59:00.537156	13	4295
6777	SensorValue	Температура элемента {разр-1} на глубине 0(м), на 20-03-2017 = 38200	{"id":4296,"sensor_id":425,"value":38200,"date_use":"20-03-2017","braid_id":741}	122	2017-03-28 10:59:05.979891	13	4296
6778	SensorValue	Температура элемента {разр-1} на глубине 0(м), на 21-03-2017 = 38300	{"id":4297,"sensor_id":425,"value":38300,"date_use":"21-03-2017","braid_id":741}	122	2017-03-28 10:59:05.979891	13	4297
6779	SensorValue	Температура элемента {разр-2} на глубине 0(м), на 20-03-2017 = 38200	{"id":4298,"sensor_id":426,"value":38200,"date_use":"20-03-2017","braid_id":743}	122	2017-03-28 10:59:08.508797	13	4298
6780	SensorValue	Температура элемента {разр-2} на глубине 0(м), на 21-03-2017 = 38300	{"id":4299,"sensor_id":426,"value":38300,"date_use":"21-03-2017","braid_id":743}	122	2017-03-28 10:59:08.508797	13	4299
6781	SensorValue	Температура элемента {разр-3} на глубине 0(м), на 20-03-2017 = 38200	{"id":4300,"sensor_id":427,"value":38200,"date_use":"20-03-2017","braid_id":745}	122	2017-03-28 10:59:09.761014	13	4300
6782	SensorValue	Температура элемента {разр-3} на глубине 0(м), на 21-03-2017 = 38300	{"id":4301,"sensor_id":427,"value":38300,"date_use":"21-03-2017","braid_id":745}	122	2017-03-28 10:59:09.761014	13	4301
6783	SensorValue	Температура элемента {разр-1} на глубине 3(м), на 20-03-2017 = 35000	{"id":4302,"sensor_id":425,"value":35000,"date_use":"20-03-2017","braid_id":740}	122	2017-03-28 10:59:37.17548	13	4302
6784	SensorValue	Температура элемента {разр-1} на глубине 3(м), на 21-03-2017 = 35000	{"id":4303,"sensor_id":425,"value":35000,"date_use":"21-03-2017","braid_id":740}	122	2017-03-28 10:59:37.17548	13	4303
6785	SensorValue	Температура элемента {разр-2} на глубине 3(м), на 20-03-2017 = 35000	{"id":4304,"sensor_id":426,"value":35000,"date_use":"20-03-2017","braid_id":742}	122	2017-03-28 10:59:54.197203	13	4304
6786	SensorValue	Температура элемента {разр-2} на глубине 3(м), на 21-03-2017 = 35000	{"id":4305,"sensor_id":426,"value":35000,"date_use":"21-03-2017","braid_id":742}	122	2017-03-28 10:59:54.197203	13	4305
6787	SensorValue	Температура элемента {разр-3} на глубине 3(м), на 20-03-2017 = 35000	{"id":4306,"sensor_id":427,"value":35000,"date_use":"20-03-2017","braid_id":744}	122	2017-03-28 10:59:57.174098	13	4306
6788	SensorValue	Температура элемента {разр-3} на глубине 3(м), на 21-03-2017 = 35000	{"id":4307,"sensor_id":427,"value":35000,"date_use":"21-03-2017","braid_id":744}	122	2017-03-28 10:59:57.174098	13	4307
6789	SensorValue	Высота, мм элемента {разр-2} на 20-03-2017 = 38000	{"id":4308,"sensor_id":426,"value":38000,"date_use":"20-03-2017","allowed_value_type_id":12}	122	2017-03-28 11:00:06.448077	13	4308
6790	SensorValue	Высота, мм элемента {разр-2} на 21-03-2017 = 38000	{"id":4309,"sensor_id":426,"value":38000,"date_use":"21-03-2017","allowed_value_type_id":12}	122	2017-03-28 11:00:06.448077	13	4309
6791	SensorValue	Высота, мм элемента {разр-3} на 20-03-2017 = 38000	{"id":4310,"sensor_id":427,"value":38000,"date_use":"20-03-2017","allowed_value_type_id":12}	122	2017-03-28 11:00:10.015718	13	4310
6792	SensorValue	Высота, мм элемента {разр-3} на 21-03-2017 = 38000	{"id":4311,"sensor_id":427,"value":38000,"date_use":"21-03-2017","allowed_value_type_id":12}	122	2017-03-28 11:00:10.015718	13	4311
6793	SensorValue	Температура элемента {разр-1} на глубине 3(м), на 20-03-2017 = 35200	{"id":4302,"sensor_id":425,"sensor_name":"разр-1","date_cr":"28.03.2017 10:59:37","value":35200,"date_use":"20-03-2017","braid_id":740,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:00:56.010375	13	4302
6794	SensorValue	Температура элемента {разр-1} на глубине 3(м), на 21-03-2017 = 35300	{"id":4303,"sensor_id":425,"sensor_name":"разр-1","date_cr":"28.03.2017 10:59:37","value":35300,"date_use":"21-03-2017","braid_id":740,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:02.675201	13	4303
6795	SensorValue	Температура элемента {разр-2} на глубине 0(м), на 20-03-2017 = 38300	{"id":4298,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 10:59:08","value":38300,"date_use":"20-03-2017","braid_id":743,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:10.318244	13	4298
6796	SensorValue	Температура элемента {разр-2} на глубине 0(м), на 21-03-2017 = 38400	{"id":4299,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 10:59:08","value":38400,"date_use":"21-03-2017","braid_id":743,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:12.952066	13	4299
6797	SensorValue	Высота, мм элемента {разр-2} на 19-03-2017 = 38000	{"id":4288,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 10:58:23","value":38000,"date_use":"19-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:17.053198	13	4288
6798	SensorValue	Высота, мм элемента {разр-2} на 20-03-2017 = 38300	{"id":4308,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 11:00:06","value":38300,"date_use":"20-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:17.053198	13	4308
6799	SensorValue	Высота, мм элемента {разр-2} на 21-03-2017 = 38400	{"id":4309,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 11:00:06","value":38400,"date_use":"21-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:17.053198	13	4309
6800	SensorValue	Температура элемента {разр-2} на глубине 3(м), на 20-03-2017 = 35300	{"id":4304,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 10:59:54","value":35300,"date_use":"20-03-2017","braid_id":742,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:23.498055	13	4304
6801	SensorValue	Температура элемента {разр-2} на глубине 3(м), на 21-03-2017 = 35400	{"id":4305,"sensor_id":426,"sensor_name":"разр-2","date_cr":"28.03.2017 10:59:54","value":35400,"date_use":"21-03-2017","braid_id":742,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:26.038003	13	4305
6802	SensorValue	Температура элемента {разр-3} на глубине 0(м), на 20-03-2017 = 38350	{"id":4300,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 10:59:09","value":38350,"date_use":"20-03-2017","braid_id":745,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:33.35344	13	4300
6803	SensorValue	Температура элемента {разр-3} на глубине 0(м), на 21-03-2017 = 38450	{"id":4301,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 10:59:09","value":38450,"date_use":"21-03-2017","braid_id":745,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:36.968768	13	4301
6804	SensorValue	Высота, мм элемента {разр-3} на 19-03-2017 = 38000	{"id":4291,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 10:58:39","value":38000,"date_use":"19-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:41.819794	13	4291
6805	SensorValue	Высота, мм элемента {разр-3} на 20-03-2017 = 38350	{"id":4310,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 11:00:10","value":38350,"date_use":"20-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:41.819794	13	4310
6806	SensorValue	Высота, мм элемента {разр-3} на 21-03-2017 = 38450	{"id":4311,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 11:00:10","value":38450,"date_use":"21-03-2017","braid_id":null,"allowed_value_type_id":12,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-28 11:01:41.819794	13	4311
6807	SensorValue	Температура элемента {разр-3} на глубине 3(м), на 20-03-2017 = 35350	{"id":4306,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 10:59:57","value":35350,"date_use":"20-03-2017","braid_id":744,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:01:55.650301	13	4306
6808	SensorValue	Температура элемента {разр-3} на глубине 3(м), на 21-03-2017 = 35400	{"id":4307,"sensor_id":427,"sensor_name":"разр-3","date_cr":"28.03.2017 10:59:57","value":35400,"date_use":"21-03-2017","braid_id":744,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-28 11:02:00.077997	13	4307
6809	Sensor	Создан новый элемент ГДМ "ГДМ_!!!"	{"id":428,"facility_id":"122","name":"ГДМ_!!!","location_x":1269,"location_y":964,"allowed_model_type_id":"12","state_id":"1","is_retranslator":"0","deep":3,"deep_step":3,"angle":0,"reference_date":"","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-30 15:28:32.616318	13	428
6810	Facility	Параметр объекта "Допустимая величина деформации" изменен на "1000"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"1000","show_explication":"1","show_convention":"1","convention_x":2072,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":1000,"show_explication":1,"show_convention":1,"convention_x":2072,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-30 15:29:13.220551	13	122
6811	SensorValue	Температура элемента {разр-1} на глубине 0(м), на 21-03-2017 = 3000	{"id":4297,"sensor_id":425,"sensor_name":"разр-1","date_cr":"28.03.2017 10:59:05","value":3000,"date_use":"21-03-2017","braid_id":741,"allowed_value_type_id":null,"allowed_value_type_name":null,"allowed_value_type_code":null}	122	2017-03-30 15:29:17.715789	13	4297
6812	Sensor	Создан новый элемент ДМ (наварной) "ДМ!!!!!!"	{"id":429,"facility_id":"122","name":"ДМ!!!!!!","location_x":230,"location_y":125,"allowed_model_type_id":"6","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.03.2017","reference_date_rev":"2017-03-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-30 15:37:30.430855	13	429
6813	Facility	Параметр объекта "Допустимая величина деформации" изменен на "200"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"200","show_explication":"1","show_convention":"1","convention_x":2072,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":0,"clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":200,"show_explication":1,"show_convention":1,"convention_x":2072,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-03-30 15:37:53.810747	13	122
6814	SensorValue	Высота, мм элемента {ДМ!!!!!!} на 01-03-2017 = 50	{"id":4312,"sensor_id":429,"value":50,"date_use":"01-03-2017","allowed_value_type_id":6}	122	2017-03-30 15:38:39.59437	13	4312
6815	SensorValue	Высота, мм элемента {ДМ!!!!!!} на 01-03-2017 = 50000	{"id":4312,"sensor_id":429,"sensor_name":"ДМ!!!!!!","date_cr":"30.03.2017 15:38:39","value":50000,"date_use":"01-03-2017","braid_id":null,"allowed_value_type_id":6,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:38:47.937189	13	4312
6816	SensorValue	Высота, мм, мм элемента {ДМ!!!!!!} на 02-03-2017 = 50200	{"id":4313,"sensor_id":429,"value":50200,"date_use":"02-03-2017","allowed_value_type_id":6}	122	2017-03-30 15:39:52.160959	13	4313
6817	SensorValue	Высота, мм, мм элемента {ДМ!!!!!!} на 03-03-2017 = 50300	{"id":4314,"sensor_id":429,"value":50300,"date_use":"03-03-2017","allowed_value_type_id":6}	122	2017-03-30 15:39:56.597269	13	4314
6818	SensorValue	Высота, мм, мм элемента {ДМ!!!!!!} на 04-03-2017 = 49700	{"id":4315,"sensor_id":429,"value":49700,"date_use":"04-03-2017","allowed_value_type_id":6}	122	2017-03-30 15:40:04.231246	13	4315
6819	Sensor	Создан новый элемент Репер "РП!!!!!"	{"id":430,"facility_id":"122","name":"РП!!!!!","location_x":216,"location_y":334,"allowed_model_type_id":"1","state_id":"1","is_retranslator":"0","deep":0,"deep_step":0,"angle":0,"reference_date":"01.03.2017","reference_date_rev":"2017-03-01","last_value_date":"-","braids":[],"deeps":{}}	122	2017-03-30 15:44:42.657261	13	430
6820	SensorValue	Высота, мм элемента {РП!!!!!} на 01-03-2017 = 50	{"id":4316,"sensor_id":430,"value":50,"date_use":"01-03-2017","allowed_value_type_id":1}	122	2017-03-30 15:46:38.501188	13	4316
6821	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = 51	{"id":4317,"sensor_id":430,"value":51,"date_use":"02-03-2017","allowed_value_type_id":1}	122	2017-03-30 15:46:41.650449	13	4317
6822	SensorValue	Высота, мм элемента {РП!!!!!} на 03-03-2017 = 50	{"id":4318,"sensor_id":430,"value":50,"date_use":"03-03-2017","allowed_value_type_id":1}	122	2017-03-30 15:46:45.76366	13	4318
6823	SensorValue	Высота, мм элемента {РП!!!!!} на 03-03-2017 = null	{"id":4318,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:45","value":null,"date_use":"03-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:46:59.165352	13	4318
6824	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = null	{"id":4317,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:41","value":null,"date_use":"02-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:46:59.737028	13	4317
6825	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = null	{"id":4317,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:41","value":null,"date_use":"02-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:00.205433	13	4317
6826	SensorValue	Высота, мм элемента {РП!!!!!} на 01-03-2017 = null	{"id":4316,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:38","value":null,"date_use":"01-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:01.022863	13	4316
6827	SensorValue	Высота, мм элемента {РП!!!!!} на 01-03-2017 = 50000	{"id":4316,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:38","value":50000,"date_use":"01-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:04.702281	13	4316
6828	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = null	{"id":4317,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:41","value":null,"date_use":"02-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:08.232715	13	4317
6829	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = null	{"id":4317,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:41","value":null,"date_use":"02-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:08.431986	13	4317
6830	SensorValue	Высота, мм элемента {РП!!!!!} на 02-03-2017 = 50000	{"id":4317,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:41","value":50000,"date_use":"02-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:15.297813	13	4317
6831	SensorValue	Высота, мм элемента {РП!!!!!} на 03-03-2017 = 50000	{"id":4318,"sensor_id":430,"sensor_name":"РП!!!!!","date_cr":"30.03.2017 15:46:45","value":50000,"date_use":"03-03-2017","braid_id":null,"allowed_value_type_id":1,"allowed_value_type_name":"Высота","allowed_value_type_code":"h"}	122	2017-03-30 15:47:19.039086	13	4318
6832	SensorValue	Высота, мм элемента {РП!!!!!} на 04-03-2017 = 49999	{"id":4319,"sensor_id":430,"value":49999,"date_use":"04-03-2017","allowed_value_type_id":1}	122	2017-03-30 15:47:27.310317	13	4319
6833	Facility	Параметр объекта "СТС/СМС" изменен на "3"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"asdf; asdmf[l kjasdfklj has;dlfkj as;lkdjf ;lkasjd fasdf","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":3,"clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"200","show_explication":"1","show_convention":"1","convention_x":2072,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"asdf; asdmf[l kjasdfklj has;dlfkj as;lkdjf ;lkasjd fasdf","base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":"3","clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":200,"show_explication":1,"show_convention":1,"convention_x":2072,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-04-21 13:43:01.538755	3	122
6834	Facility	Параметр объекта "СТС/СМС" изменен на "3,5...6,5"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":"3,5...6,5","clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","allowed_temperature":"-1","allowed_deformation":"200","show_explication":"1","show_convention":"1","convention_x":2072,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":"3,5...6,5","clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":-1,"allowed_deformation":200,"show_explication":1,"show_convention":1,"convention_x":2072,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]"}},"urn_encoded":null}	122	2017-04-21 13:45:54.32801	3	122
6835	Facility	Параметр объекта "Допустимая величина деформации" изменен на "undefined"\n	{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"1","state_name":"Эксплуатация","width":null,"height":null,"foundation_depth":0,"frozen_depth":"0.0","clipmap":null,"dumping_depth":"4","plan_id":79,"plan_name":"Куст скважин №31_ОГТМ","view_data":null,"table_x":567,"table_y":79,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"21.03.2017","allowed_temperature":"-1","show_explication":"1","show_convention":"1","convention_x":276,"convention_y":73,"type":"Куст скважин","stamp_data":null,"comments_length":0,"photos_length":0,"jpg_url":"/f/14/836.jpg","jpg_id":836,"pdf_url":"/f/14/834.pdf","calc_pdf_url":"/f/14/835.pdf","pdf_id":834,"plan":{"id":79,"name":"Куст скважин №31_ОГТМ (A1_H)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":834,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/834.pdf","jpg_id":836,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/836.jpg","format_id":9,"format_name":"A1_H","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":835,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/835.pdf","deleted":null,"used":{"id":131,"parent_id":null,"name":"Куст скважин №31","ordering":131,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":"да","base_type":"свайный, плитный, по грунту","base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":1,"width":null,"height":null,"foundation_depth":0,"frozen_depth":"0.0","clipmap":null,"dumping_depth":4,"plan_id":79,"view_data":null,"table_x":567,"table_y":79,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-03-21","allowed_temperature":-1,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":276,"convention_y":73,"type":"Куст скважин","stamp_data":null}},"urn_encoded":null}	131	2017-04-21 13:50:33.394155	3	131
6836	Facility	Параметр объекта "Допустимая величина деформации" изменен на "undefined"\nПараметр объекта "Максимальная допустимая температура" изменен на "undefined"\n	{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"image_ext":null,"image_file_folder_id":null,"code":null,"address":null,"load_capacity":0,"protection":"","base_type":"","base_principle_id":"1","base_principle_name":"&#8544;","location_x":50,"location_y":50,"state_id":"2","state_name":"Сроительство","width":null,"height":null,"foundation_depth":0,"frozen_depth":"3,5...6,5","clipmap":null,"dumping_depth":"10","plan_id":71,"plan_name":"ЦПС","view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"18.01.2017","show_explication":"1","show_convention":"1","convention_x":2072,"convention_y":677,"type":"","stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","responsibility_level":"повышенный","comments_length":4,"photos_length":4,"jpg_url":"/f/14/806.jpg","jpg_id":806,"pdf_url":"/f/14/804.pdf","calc_pdf_url":"/f/14/805.pdf","pdf_id":804,"plan":{"id":71,"name":"ЦПС (A0_V)","dwg_id":null,"dwg_ext":null,"dwg_file_folder_id":null,"pdf_id":804,"pdf_ext":"pdf","pdf_file_folder_id":14,"pdf_url":"/f/14/804.pdf","jpg_id":806,"jpg_ext":"jpg","jpg_file_folder_id":14,"jpg_url":"/f/14/806.jpg","format_id":12,"format_name":"A0_V","view_data":null,"width":null,"height":null,"status":"Ошибка загрузки","urn":null,"urn_encoded":null,"log":null,"calc_pdf_id":805,"calc_pdf_ext":"pdf","calc_pdf_file_folder_id":14,"calc_pdf_url":"/f/14/805.pdf","deleted":null,"used":{"id":122,"parent_id":null,"name":"Площадка ЦПС","ordering":122,"image_id":null,"code":null,"address":null,"load_capacity":0,"protection":null,"base_type":null,"base_construction":null,"base_principle_id":1,"location_x":50,"location_y":50,"state_id":2,"width":null,"height":null,"foundation_depth":0,"frozen_depth":"3,5...6,5","clipmap":null,"dumping_depth":10,"plan_id":71,"view_data":null,"table_x":2150,"table_y":92,"element_size":0.5,"table_size":0,"deleted":null,"date_cr":"2017-01-18","allowed_temperature":null,"allowed_deformation":null,"show_explication":1,"show_convention":1,"convention_x":2072,"convention_y":677,"type":null,"stamp_data":"[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,\\"02.02.17\\",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]","responsibility_level":"повышенный"}},"urn_encoded":null}	122	2017-04-21 14:40:06.520274	3	122
\.


--
-- Name: tedit_histories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tedit_histories_id_seq', 6836, true);


--
-- Data for Name: texplications; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY texplications (id, facility_id, field01, field02, field03, field04, field05, field06, field07, field08, field09, field10, field11, field12) FROM stdin;
\.


--
-- Name: texplications_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('texplications_id_seq', 3, true);


--
-- Data for Name: tfacilities; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacilities (id, parent_id, name, ordering, image_id, code, address, load_capacity, protection, base_type, base_construction, base_principle_id, location_x, location_y, state_id, width, height, foundation_depth, frozen_depth, clipmap, dumping_depth, plan_id, view_data, table_x, table_y, element_size, table_size, deleted, date_cr, allowed_temperature, allowed_deformation, show_explication, show_convention, convention_x, convention_y, type, stamp_data, responsibility_level, negative_process) FROM stdin;
128	125	Каталог координат_л.3	128	\N	\N	\N	\N	\N	\N	\N	\N	763.0000	502.0000	\N	\N	\N	\N	\N	\N	\N	76	\N	250.00	50.00	1.00	\N	\N	2017-01-24	\N	\N	1	1	250	150	\N	\N	\N	\N
125	\N	Участок перехода через р. Большая Хета	125	\N	\N	\N	0.0000	Есть	Свайный, траншея	\N	1	50.0000	50.0000	1	\N	\N	10.0	5.0	\N	\N	73	\N	250.00	50.00	0.50	0.00	\N	2017-01-24	\N	\N	1	1	250	150	Трубопровод	\N	\N	\N
124	122	Подобъект к удалению!!!	124	\N	\N	\N	0.0000	\N	\N	\N	1	934.0000	304.0000	1	\N	\N	0.0	0.0	824.000,223.000;822.000,563.000;1112.000,567.000;1096.000,221.000;	\N	65	\N	250.00	50.00	1.00	0.00	1	2017-01-19	\N	\N	1	1	250	150	\N	\N	\N	\N
116	\N	ЦПС_ОГТМ	116	\N	\N	\N	\N	\N	\N	\N	\N	50.0000	50.0000	\N	\N	\N	\N	\N	\N	\N	65	\N	250.00	50.00	1.00	\N	1	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
118	\N	ЦПС_ОГТМ	118	\N	\N	\N	\N	\N	\N	\N	\N	50.0000	50.0000	\N	\N	\N	\N	\N	\N	\N	65	\N	250.00	50.00	1.00	\N	1	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
129	122	Поз. 8.1_Система измер-я кол-ва нефти	129	\N	\N	\N	0.0000	\N	\N	\N	1	1257.0000	2910.0000	2	\N	\N	0.0	0.0	1196.000,2871.000;1236.000,2868.000;1236.000,2908.000;1196.000,2906.000;	\N	77	\N	250.00	50.00	0.50	0.00	\N	2017-02-01	\N	\N	1	1	250	150	\N	\N	\N	\N
130	122	Поз. 52.2_Площадка дренажной емкости	130	\N	\N	\N	0.0000	\N	\N	\N	1	1226.0000	1943.0000	2	\N	\N	0.0	0.0	1186.000,1921.000;1212.000,1919.000;1212.000,1945.000;1188.000,1945.000;	\N	78	\N	250.00	50.00	0.50	0.00	\N	2017-02-01	\N	\N	1	1	250	150	\N	\N	\N	\N
126	125	ПК143+25.68-ПК146+25.68	126	\N	\N	\N	0.0000	да	Подземная прокладка	\N	1	776.0000	846.0000	1	\N	\N	0.0	0.0	787.000,915.000;763.000,977.000;619.000,925.000;641.000,861.000;	\N	74	\N	203.00	982.00	0.25	0.00	\N	2017-01-24	\N	\N	1	1	421	1045	Трубопровод	\N	\N	\N
117	116	Поз.9.1 Совмещенная факельная установка h=50м	117	\N	\N	\N	\N	\N	\N	\N	\N	50.0000	50.0000	\N	\N	\N	\N	\N	\N	\N	66	\N	250.00	50.00	1.00	\N	\N	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
119	\N	ЦПС_ОГТМ	119	\N	\N	\N	\N	\N	\N	\N	\N	50.0000	50.0000	\N	\N	\N	\N	\N	\N	\N	71	\N	250.00	50.00	1.00	\N	1	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
132	131	Поз. 8	132	\N	\N	\N	0.0000	нет	свайный	\N	1	628.0000	496.0000	1	\N	\N	0.0	0.0	598.000,480.000;660.000,479.000;662.000,514.000;599.000,510.000;	\N	80	\N	250.00	50.00	1.00	0.00	\N	2017-03-21	\N	\N	1	1	250	150	сооружение	\N	\N	\N
123	122	Поз. 9.1_Факельная установка h=50м	123	\N	\N	\N	17.0000	Проектируется	Свайный	\N	1	1557.0000	643.0000	2	\N	\N	10.0	3.5	1442.000,520.000;1422.000,620.000;1524.000,588.000;	386.50	66	\N	401.00	160.00	0.50	0.00	\N	2017-01-18	-1.00	200.00	1	1	614	269	Факельная установка	\N	\N	\N
120	119	поз 9.1_Совмещенная факельная установка h=50м	120	\N	\N	\N	\N	\N	\N	\N	\N	821.0000	41.0000	\N	\N	\N	\N	\N	\N	\N	65	\N	250.00	50.00	1.00	\N	1	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
127	125	ПК146+25.68-ПК149+25.68	127	\N	\N	\N	0.0000	да	Надземная прокладка	\N	1	504.0000	803.0000	1	\N	\N	0.0	0.0	655.000,863.000;629.000,929.000;583.000,913.000;551.000,943.000;511.000,899.000;579.000,837.000;	\N	75	\N	372.00	940.00	0.50	0.00	\N	2017-01-24	\N	\N	1	1	582	964	Трубопровод	\N	\N	\N
121	119	поз. 9.1_Совмещенная факельная установка	121	\N	\N	\N	\N	\N	\N	\N	\N	381.0000	281.0000	\N	\N	\N	\N	\N	\N	\N	66	\N	250.00	50.00	1.00	\N	\N	2017-01-17	\N	\N	1	1	250	150	\N	\N	\N	\N
131	\N	Куст скважин №31	131	\N	\N	\N	0.0000	да	свайный, плитный, по грунту	\N	1	50.0000	50.0000	1	\N	\N	0.0	0.0	\N	4.00	79	\N	567.00	79.00	0.50	0.00	\N	2017-03-21	-1.00	\N	1	1	276	73	Куст скважин	\N	\N	\N
122	\N	Площадка ЦПС	122	\N	\N	\N	0.0000	 fdh\\;lgk dsfokgh 	\N	\N	1	50.0000	50.0000	2	\N	\N	0.0	3,5...6,5	\N	10.00	71	\N	2150.00	92.00	0.50	0.00	\N	2017-01-18	\N	\N	1	1	2072	677	\N	[[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,"02.02.17",null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null]]	повышенный	sd'flkj as;dfjklh sadf
\.


--
-- Name: tfacilities_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacilities_id_seq', 132, true);


--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacilities_ordering_seq', 132, true);


--
-- Data for Name: tfacility_comment_images; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_comment_images (id, comment_id, image_id) FROM stdin;
105	102	822
106	103	823
107	104	824
108	105	825
109	107	826
110	109	833
\.


--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_comment_images_id_seq', 110, true);


--
-- Data for Name: tfacility_comments; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_comments (id, facility_id, date_cr, user_cr_id, body, images_json) FROM stdin;
102	122	2017-01-25 11:37:21.135744	13	Вид с вертолета. Цеха. Позиции 45.3...7	{}
103	122	2017-01-25 11:37:21.135744	13	Площадка ЦПС. Вид с вертолета. Цеха, поз. 45.3...7	{}
104	122	2017-01-25 11:37:21.135744	13	Площадка ЦПС. Вид с вертолета, цеха, поз. 45.3...7	{}
105	123	2017-01-25 11:37:21.135744	13	Факел. Поз. 9.1	{}
106	127	2017-01-25 13:54:33.622038	13	Репер рабочий	{}
107	127	2017-01-25 13:54:33.622038	13	Всплытие на участке ПК147...ПК148	{}
108	125	2017-02-15 18:28:13.194078	3	Тест\n	{"file:///storage/sdcard0/Android/data/ru.pronetcom.ias_yamal/cache/1487172486771.jpg":1}
109	122	2017-02-15 18:30:00.524834	3	Тест\n	{}
\.


--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_comments_id_seq', 109, true);


--
-- Data for Name: tfacility_groups; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_groups (id, facility_id, name) FROM stdin;
\.


--
-- Data for Name: tfacility_photos; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_photos (id, facility_id, date_cr, user_cr_id, image_id, body) FROM stdin;
\.


--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_photos_id_seq', 4, true);


--
-- Data for Name: tfacility_states; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_states (id, name, ordering) FROM stdin;
2	Строительство	2
4	Проектирование	1
1	Эксплуатация	3
3	Ликвидация	4
\.


--
-- Name: tfacility_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_states_id_seq', 4, true);


--
-- Name: tfacility_states_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_states_ordering_seq', 4, true);


--
-- Data for Name: tfacility_stats; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_stats (id, facility_id, date, data) FROM stdin;
\.


--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_stats_id_seq', 168, true);


--
-- Data for Name: tfacility_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfacility_types (id, name) FROM stdin;
1	Строение
2	Скважина
\.


--
-- Name: tfacility_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfacility_types_id_seq', 2, true);


--
-- Data for Name: tfile_folders; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfile_folders (id, code, parent_id, user_cr_id, date_cr, date_mo, ordering) FROM stdin;
1	avatars	\N	1	2015-08-20 09:00:43.202674	2015-08-20 09:00:43.202674	1
2	galleries	\N	1	2015-08-20 09:00:43.204839	2015-08-20 09:00:43.204839	2
3	news	\N	1	2015-08-20 09:00:43.205254	2015-08-20 09:00:43.205254	3
4	images	\N	1	2015-08-20 09:00:43.205584	2015-08-20 09:00:43.205584	4
5	market_items	\N	1	2015-08-20 09:00:43.20598	2015-08-20 09:00:43.20598	5
6	\N	\N	3	2015-08-24 15:21:09.666889	2015-08-24 15:21:09.666889	6
7	\N	\N	3	2015-08-26 11:40:22.099897	2015-08-26 11:40:22.099897	7
8	\N	7	3	2015-08-26 11:40:29.645833	2015-08-26 11:40:29.645833	8
9	\N	8	3	2015-08-26 11:40:35.557888	2015-08-26 11:40:35.557888	9
12	\N	11	3	2015-12-30 13:30:09.084951	2015-12-30 13:30:09.084951	12
13	\N	11	3	2015-12-30 13:30:16.574481	2015-12-30 13:30:16.574481	13
11	\N	\N	3	2015-12-30 13:29:51.256183	2015-12-30 14:36:45.646278	11
14	\N	\N	3	2015-12-30 14:36:59.720915	2015-12-30 14:36:59.720915	14
15	\N	11	3	2016-03-10 18:07:20.08403	2016-03-10 18:07:20.08403	15
\.


--
-- Name: tfile_folders_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_id_seq', 15, true);


--
-- Data for Name: tfile_folders_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfile_folders_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Аватары
2	2	1	Галереи сайта
3	3	1	Статьи
4	4	1	Изображения
5	5	1	Позиции каталога
6	6	1	Объекты
7	7	1	Карта
8	8	1	Элементы
9	9	1	Датчики
12	12	1	PDF_formats
13	13	1	DWG_templates
11	11	1	Шаблоны чертежей
14	14	1	Чертежи
15	15	1	CORRECT
\.


--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_l10n_id_seq', 15, true);


--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_ordering_seq', 15, true);


--
-- Data for Name: tfile_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfile_types (id, code, name) FROM stdin;
1	image	Изображение
2	video	Видео
3	sound	Звук
4	other	Файл
\.


--
-- Name: tfile_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfile_types_id_seq', 4, true);


--
-- Data for Name: tfiles; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfiles (id, type_id, file_folder_id, user_cr_id, date_cr, date_mo, orig_filename, ext, width, height, filesize, seconds, ordering) FROM stdin;
1	1	4	3	2015-08-24 14:49:26.643313	2015-08-24 14:49:26.643313	img3	jpg	500	378	33409	\N	1
2	1	6	3	2015-08-24 15:23:05.163139	2015-08-24 15:23:05.163139	img3	jpg	500	378	33409	\N	2
3	1	6	3	2015-08-24 15:25:04.377426	2015-08-24 15:25:04.377426	img3	jpg	500	378	33409	\N	3
33	1	6	3	2015-09-08 15:55:43.485269	2015-09-08 15:55:43.485269	test4	gif	621	348	3185279	\N	33
6	1	6	3	2015-08-24 16:16:46.444128	2015-08-24 16:16:46.444128	img3	jpg	500	378	33409	\N	6
7	1	6	3	2015-08-24 16:17:05.20495	2015-08-24 16:17:05.20495	анжер	jpg	2000	2000	1076007	\N	7
8	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	dm_ico50_50	png	50	50	2445	\N	8
9	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	gdm_ico50_50	png	50	50	2989	\N	9
10	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	gr_ico50_50	png	50	50	3946	\N	10
11	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	ps_ico50_50	png	50	50	4529	\N	11
12	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	tdg_ico50_50	png	50	50	3976	\N	12
13	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	ts_ico50_50	png	50	50	3800	\N	13
14	1	8	3	2015-08-26 11:42:09.753258	2015-08-26 11:42:09.753258	photo_ico50_50	png	50	50	3177	\N	14
15	1	8	3	2015-08-26 11:42:09.753258	2015-08-26 11:42:09.753258	subfac_ico50_50	png	50	50	3761	\N	15
16	1	6	3	2015-08-26 11:55:33.487677	2015-08-26 11:55:33.487677	6	jpg	973	685	331661	\N	16
17	1	6	3	2015-08-26 13:24:59.902091	2015-08-26 13:24:59.902091	6	jpg	973	685	331661	\N	17
18	1	6	3	2015-08-26 13:51:06.444671	2015-08-26 13:51:06.444671	6	jpg	973	685	331661	\N	18
19	1	6	3	2015-08-26 13:51:23.590513	2015-08-26 13:51:23.590513	img3	jpg	500	378	33409	\N	19
20	1	6	3	2015-08-31 20:42:40.425597	2015-08-31 20:42:40.425597	объект_1	jpg	2560	791	365765	\N	20
21	1	6	3	2015-08-31 20:47:36.38649	2015-08-31 20:47:36.38649	объект_1	jpg	6918	2139	2653827	\N	21
22	1	6	3	2015-09-07 18:28:26.470352	2015-09-07 18:28:26.470352	test4	gif	621	348	3185279	\N	22
23	1	6	3	2015-09-07 18:29:43.214367	2015-09-07 18:29:43.214367	test3	gif	621	348	3708740	\N	23
24	1	6	3	2015-09-07 18:30:03.732969	2015-09-07 18:30:03.732969	test3	gif	621	348	3708740	\N	24
25	1	6	3	2015-09-07 18:30:55.648225	2015-09-07 18:30:55.648225	test3	gif	621	348	3708740	\N	25
26	1	6	3	2015-09-07 18:31:28.320028	2015-09-07 18:31:28.320028	test4	gif	621	348	3185279	\N	26
27	1	6	3	2015-09-07 18:32:04.946264	2015-09-07 18:32:04.946264	test3	gif	621	348	3708740	\N	27
28	1	6	3	2015-09-07 18:37:09.731483	2015-09-07 18:37:09.731483	test2	gif	621	348	4630740	\N	28
29	1	6	3	2015-09-07 18:38:30.797686	2015-09-07 18:38:30.797686	test	gif	621	348	224262	\N	29
30	1	6	3	2015-09-08 15:46:12.902901	2015-09-08 15:46:12.902901	test2	gif	621	348	4630740	\N	30
31	1	6	3	2015-09-08 15:49:39.182762	2015-09-08 15:49:39.182762	test2	gif	621	348	4630740	\N	31
32	1	6	3	2015-09-08 15:54:56.964146	2015-09-08 15:54:56.964146	test2	gif	621	348	4630740	\N	32
34	1	6	3	2015-09-08 16:03:01.383919	2015-09-08 16:03:01.383919	test2	gif	621	348	4630740	\N	34
35	1	6	3	2015-09-08 16:03:38.201915	2015-09-08 16:03:38.201915	avatar	jpg	200	216	57465	\N	35
36	1	6	3	2015-09-08 16:04:14.370635	2015-09-08 16:04:14.370635	avatar	jpg	200	216	57465	\N	36
37	1	6	3	2015-09-08 16:09:14.447998	2015-09-08 16:09:14.447998	avatar	jpg	200	216	57465	\N	37
38	1	6	3	2015-09-08 16:12:00.578615	2015-09-08 16:12:00.578615	test2	gif	621	348	4630740	\N	38
39	1	6	3	2015-09-08 18:02:12.298169	2015-09-08 18:02:12.298169	avatar	jpg	200	216	57465	\N	39
40	1	6	3	2015-09-08 18:03:24.105654	2015-09-08 18:03:24.105654	test2	gif	621	348	4630740	\N	40
41	1	6	3	2015-09-08 18:03:41.675144	2015-09-08 18:03:41.675144	avatar	jpg	200	216	57465	\N	41
42	1	6	3	2015-09-08 18:04:09.949336	2015-09-08 18:04:09.949336	объект_1	jpg	6918	2139	2653827	\N	42
43	1	6	3	2015-09-08 18:06:20.961969	2015-09-08 18:06:20.961969	element_sheet	jpg	4396	3038	2099033	\N	43
44	1	6	3	2015-09-09 11:36:26.69785	2015-09-09 11:36:26.69785	объект_1	jpg	6918	2139	2653827	\N	44
45	1	6	3	2015-09-09 11:41:43.210538	2015-09-09 11:41:43.210538	объект_1	jpg	6918	2139	2653827	\N	45
46	1	6	3	2015-09-10 14:30:49.737896	2015-09-10 14:30:49.737896	объект_1	jpg	6918	2139	2653827	\N	46
47	1	6	3	2015-09-14 14:32:02.261057	2015-09-14 14:32:02.261057	объект_1	jpg	6918	2139	2653827	\N	47
48	1	6	3	2015-09-14 14:35:12.935628	2015-09-14 14:35:12.935628	объект_1	jpg	6918	2139	2653827	\N	48
49	1	6	3	2015-09-15 11:56:47.902547	2015-09-15 11:56:47.902547	объект_1	jpg	6918	2139	2653827	\N	49
50	1	6	3	2015-09-16 15:50:12.765439	2015-09-16 15:50:12.765439	avatar	jpg	200	216	57465	\N	50
51	1	6	3	2015-09-16 18:28:17.987815	2015-09-16 18:28:17.987815	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	51
52	1	6	3	2015-09-16 18:28:18.615261	2015-09-16 18:28:18.615261	carottage5	jpg	320	451	77278	\N	52
53	1	6	3	2015-09-16 18:28:18.615264	2015-09-16 18:28:18.615264	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	53
54	1	6	3	2015-09-16 18:28:18.73294	2015-09-16 18:28:18.73294	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	54
55	1	6	3	2015-09-16 18:28:18.944046	2015-09-16 18:28:18.944046	boif-djd2-gh	gif	800	800	105601	\N	55
56	1	6	3	2015-09-16 18:29:11.692028	2015-09-16 18:29:11.692028	boif-djd2-gh	gif	800	800	105601	\N	56
57	1	6	3	2015-09-16 18:29:26.843049	2015-09-16 18:29:26.843049	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	57
58	1	6	3	2015-09-16 18:29:41.205801	2015-09-16 18:29:41.205801	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	58
59	1	6	3	2015-09-16 18:29:41.457271	2015-09-16 18:29:41.457271	carottage5	jpg	320	451	77278	\N	59
60	1	6	3	2015-09-16 18:29:41.526113	2015-09-16 18:29:41.526113	boif-djd2-gh	gif	800	800	105601	\N	60
61	1	6	3	2015-09-16 18:29:41.559923	2015-09-16 18:29:41.559923	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	61
62	1	6	3	2015-09-16 18:29:41.731038	2015-09-16 18:29:41.731038	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	62
63	1	6	3	2015-09-16 18:30:38.459839	2015-09-16 18:30:38.459839	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	63
64	1	6	3	2015-09-16 18:30:38.698332	2015-09-16 18:30:38.698332	boif-djd2-gh	gif	800	800	105601	\N	64
65	1	6	3	2015-09-16 18:30:38.858253	2015-09-16 18:30:38.858253	carottage5	jpg	320	451	77278	\N	65
66	1	6	3	2015-09-16 18:30:38.882293	2015-09-16 18:30:38.882293	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	66
67	1	6	3	2015-09-16 18:30:38.945472	2015-09-16 18:30:38.945472	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	67
68	1	6	3	2015-09-16 18:34:56.399099	2015-09-16 18:34:56.399099	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	68
69	1	6	3	2015-09-16 18:34:56.476456	2015-09-16 18:34:56.476456	carottage5	jpg	320	451	77278	\N	69
70	1	6	3	2015-09-16 18:34:56.51143	2015-09-16 18:34:56.51143	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	70
71	1	6	3	2015-09-16 18:34:56.554638	2015-09-16 18:34:56.554638	boif-djd2-gh	gif	800	800	105601	\N	71
72	1	6	3	2015-09-16 18:34:57.177572	2015-09-16 18:34:57.177572	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	72
73	1	6	3	2015-09-16 18:38:43.691998	2015-09-16 18:38:43.691998	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	73
74	1	6	3	2015-09-16 18:38:43.713857	2015-09-16 18:38:43.713857	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	74
75	1	6	3	2015-09-16 18:38:43.798925	2015-09-16 18:38:43.798925	boif-djd2-gh	gif	800	800	105601	\N	75
76	1	6	3	2015-09-16 18:38:44.098715	2015-09-16 18:38:44.098715	carottage5	jpg	320	451	77278	\N	76
77	1	6	3	2015-09-16 18:38:44.651002	2015-09-16 18:38:44.651002	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	77
78	1	6	3	2015-09-16 18:39:32.915052	2015-09-16 18:39:32.915052	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	78
79	1	6	3	2015-09-16 18:39:33.074676	2015-09-16 18:39:33.074676	carottage5	jpg	320	451	77278	\N	79
80	1	6	3	2015-09-16 18:39:33.109203	2015-09-16 18:39:33.109203	boif-djd2-gh	gif	800	800	105601	\N	80
81	1	6	3	2015-09-16 18:39:33.128269	2015-09-16 18:39:33.128269	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	81
82	1	6	3	2015-09-16 18:39:33.188936	2015-09-16 18:39:33.188936	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	82
83	1	6	3	2015-09-16 18:45:51.457671	2015-09-16 18:45:51.457671	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	83
84	1	6	3	2015-09-16 18:45:51.597894	2015-09-16 18:45:51.597894	carottage5	jpg	320	451	77278	\N	84
85	1	6	3	2015-09-16 18:45:51.679049	2015-09-16 18:45:51.679049	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	85
86	1	6	3	2015-09-16 18:45:51.703988	2015-09-16 18:45:51.703988	boif-djd2-gh	gif	800	800	105601	\N	86
87	1	6	3	2015-09-16 18:45:51.807192	2015-09-16 18:45:51.807192	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	87
88	1	6	3	2015-09-16 18:48:32.087523	2015-09-16 18:48:32.087523	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	88
89	1	6	3	2015-09-16 18:48:32.384578	2015-09-16 18:48:32.384578	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	89
90	1	6	3	2015-09-16 18:48:32.399493	2015-09-16 18:48:32.399493	carottage5	jpg	320	451	77278	\N	90
91	1	6	3	2015-09-16 18:48:32.424412	2015-09-16 18:48:32.424412	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	91
92	1	6	3	2015-09-16 18:48:32.491621	2015-09-16 18:48:32.491621	boif-djd2-gh	gif	800	800	105601	\N	92
93	1	6	3	2015-09-16 18:51:31.885482	2015-09-16 18:51:31.885482	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	93
95	1	6	3	2015-09-16 18:51:32.399869	2015-09-16 18:51:32.399869	carottage5	jpg	320	451	77278	\N	95
94	1	6	3	2015-09-16 18:51:32.399464	2015-09-16 18:51:32.399464	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	94
96	1	6	3	2015-09-16 18:51:32.564829	2015-09-16 18:51:32.564829	boif-djd2-gh	gif	800	800	105601	\N	96
97	1	6	3	2015-09-16 18:51:32.711416	2015-09-16 18:51:32.711416	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	97
98	1	6	3	2015-09-16 19:02:09.389993	2015-09-16 19:02:09.389993	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	98
99	1	6	3	2015-09-16 19:02:09.548159	2015-09-16 19:02:09.548159	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	99
100	1	6	3	2015-09-16 19:02:09.600831	2015-09-16 19:02:09.600831	boif-djd2-gh	gif	800	800	105601	\N	100
101	1	6	3	2015-09-16 19:02:09.681987	2015-09-16 19:02:09.681987	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	101
102	1	6	3	2015-09-16 19:02:09.72506	2015-09-16 19:02:09.72506	carottage5	jpg	320	451	77278	\N	102
103	1	6	3	2015-09-16 19:02:15.638822	2015-09-16 19:02:15.638822	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	103
104	1	6	3	2015-09-16 19:02:15.730486	2015-09-16 19:02:15.730486	carottage5	jpg	320	451	77278	\N	104
105	1	6	3	2015-09-16 19:02:15.733409	2015-09-16 19:02:15.733409	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	105
106	1	6	3	2015-09-16 19:02:15.807035	2015-09-16 19:02:15.807035	boif-djd2-gh	gif	800	800	105601	\N	106
107	1	6	3	2015-09-16 19:02:15.826875	2015-09-16 19:02:15.826875	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	107
108	1	6	3	2015-09-16 19:02:21.947414	2015-09-16 19:02:21.947414	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	108
109	1	6	3	2015-09-16 19:02:22.12404	2015-09-16 19:02:22.12404	carottage5	jpg	320	451	77278	\N	109
110	1	6	3	2015-09-16 19:02:22.128252	2015-09-16 19:02:22.128252	boif-djd2-gh	gif	800	800	105601	\N	110
111	1	6	3	2015-09-16 19:02:22.342338	2015-09-16 19:02:22.342338	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	111
112	1	6	3	2015-09-16 19:02:22.417471	2015-09-16 19:02:22.417471	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	112
113	1	6	3	2015-09-16 19:19:44.707195	2015-09-16 19:19:44.707195	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	113
114	1	6	3	2015-09-21 12:27:16.734223	2015-09-21 12:27:16.734223	carottage5	jpg	320	451	77278	\N	114
115	1	6	3	2015-09-21 12:27:16.768582	2015-09-21 12:27:16.768582	boif-djd2-gh	gif	800	800	105601	\N	115
116	1	6	3	2015-09-21 12:27:16.818422	2015-09-21 12:27:16.818422	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	116
117	1	6	3	2015-09-21 12:27:16.957348	2015-09-21 12:27:16.957348	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	117
118	1	6	3	2015-09-21 14:15:57.652581	2015-09-21 14:15:57.652581	объект_1	jpg	6918	2139	2653827	\N	118
119	1	6	3	2015-10-05 17:58:57.121693	2015-10-05 17:58:57.121693	объект_1	jpg	6918	2139	2653827	\N	119
120	1	6	3	2015-10-07 13:38:24.513835	2015-10-07 13:38:24.513835	trollface	png	469	428	99320	\N	120
121	1	6	3	2015-10-07 13:39:14.095502	2015-10-07 13:39:14.095502	trollface	png	469	428	99320	\N	121
122	1	6	3	2015-10-07 13:40:46.594823	2015-10-07 13:40:46.594823	carottage5	jpg	320	451	77278	\N	122
124	1	6	3	2015-10-07 13:40:46.625088	2015-10-07 13:40:46.625088	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	124
123	1	6	3	2015-10-07 13:40:46.624212	2015-10-07 13:40:46.624212	boif-djd2-gh	gif	800	800	105601	\N	123
125	1	6	3	2015-10-07 13:42:12.983104	2015-10-07 13:42:12.983104	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	125
126	1	6	3	2015-10-07 13:43:24.563816	2015-10-07 13:43:24.563816	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	126
127	1	6	3	2015-10-07 13:43:25.526474	2015-10-07 13:43:25.526474	boif-djd2-gh	gif	800	800	105601	\N	127
128	1	6	3	2015-10-07 13:43:25.948362	2015-10-07 13:43:25.948362	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	128
129	1	6	3	2015-10-07 13:47:51.399788	2015-10-07 13:47:51.399788	объект_1	jpg	6918	2139	2653827	\N	129
151	4	6	3	2015-11-11 17:53:30.612634	2015-11-11 17:53:30.612634	1.общая схема кц	dxf	\N	\N	84365174	\N	151
142	1	6	3	2015-10-27 18:48:52.407586	2015-10-27 18:48:52.407586	blank_1	jpg	850	1203	369940	\N	142
143	1	6	3	2015-10-29 11:57:49.253473	2015-10-29 11:57:49.253473	объект_1	jpg	6918	2139	2653827	\N	143
144	1	6	3	2015-10-29 17:55:05.732488	2015-10-29 17:55:05.732488	объект_1	jpg	6918	2139	2653827	\N	144
145	1	6	3	2015-10-31 10:26:28.134226	2015-10-31 10:26:28.134226	image	jpg	2592	1936	1599324	\N	145
146	4	6	3	2015-11-11 14:22:33.652412	2015-11-11 14:22:33.652412	лист.2-44	dwg	\N	\N	3366285	\N	146
147	4	6	3	2015-11-11 14:24:08.006297	2015-11-11 14:24:08.006297	лист.2-44	dwg	\N	\N	3366285	\N	147
148	4	6	3	2015-11-11 14:25:10.600607	2015-11-11 14:25:10.600607	лист.2-44	dwg	\N	\N	3366285	\N	148
149	4	6	3	2015-11-11 16:03:30.273989	2015-11-11 16:03:30.273989	1.общая схема кц	dwg	\N	\N	12052299	\N	149
150	4	6	3	2015-11-11 17:48:41.519343	2015-11-11 17:48:41.519343	чертеж8	dwg	\N	\N	377633	\N	150
152	4	6	3	2015-11-11 18:00:00.534623	2015-11-11 18:00:00.534623	лист.2-44	dwg	\N	\N	3366285	\N	152
153	4	6	3	2015-11-11 18:30:31.160801	2015-11-11 18:30:31.160801	лист 17 поз.5.4	pdf	\N	\N	81512	\N	153
154	1	6	3	2015-11-12 13:49:58.691604	2015-11-12 13:49:58.691604	orion_hubble_6000	jpg	6000	6000	2697142	\N	154
155	1	6	3	2015-11-13 12:56:11.702693	2015-11-13 12:56:11.702693	orion_hubble_6000	jpg	6000	6000	2697142	\N	155
156	1	6	3	2015-11-13 12:58:07.463617	2015-11-13 12:58:07.463617	chart	jpeg	1200	800	66704	\N	156
157	1	6	3	2015-11-13 14:13:53.620079	2015-11-13 14:13:53.620079	desert	jpg	1024	768	845941	\N	157
170	1	6	3	2015-11-18 20:03:55.752084	2015-11-18 20:03:55.752084	img_20151118_192946	jpg	1440	2560	62089	\N	170
171	1	6	3	2015-11-18 20:03:55.763807	2015-11-18 20:03:55.763807	img_20151118_192813	jpg	1440	2560	72633	\N	171
172	1	6	3	2015-11-18 20:03:55.807547	2015-11-18 20:03:55.807547	img_20151118_192830	jpg	1440	2560	90477	\N	172
173	1	6	3	2015-11-18 20:04:40.07685	2015-11-18 20:04:40.07685	img_20151118_192813	jpg	1440	2560	72633	\N	173
174	1	6	3	2015-11-18 20:04:40.088784	2015-11-18 20:04:40.088784	img_20151118_192946	jpg	1440	2560	62089	\N	174
175	1	6	3	2015-11-18 20:04:40.100167	2015-11-18 20:04:40.100167	img_20151118_192830	jpg	1440	2560	90477	\N	175
187	1	6	3	2015-11-19 13:40:37.956295	2015-11-19 13:40:37.956295	img_20151119_135415	jpg	2560	1440	177646	\N	187
182	1	6	3	2015-11-19 13:19:26.683184	2015-11-19 13:19:26.683184	img_20151119_135415	jpg	2560	1440	177646	\N	182
183	1	6	3	2015-11-19 13:20:50.663698	2015-11-19 13:20:50.663698	img_20151119_135415	jpg	2560	1440	177646	\N	183
184	1	6	3	2015-11-19 13:20:50.748435	2015-11-19 13:20:50.748435	img_20151119_135404	jpg	1440	2560	176829	\N	184
185	1	6	3	2015-11-19 13:37:32.380532	2015-11-19 13:37:32.380532	img_20151119_135415	jpg	2560	1440	177646	\N	185
186	1	6	3	2015-11-19 13:40:37.867832	2015-11-19 13:40:37.867832	img_20151119_135404	jpg	1440	2560	176829	\N	186
188	1	6	3	2015-11-19 13:43:18.436295	2015-11-19 13:43:18.436295	img_20151119_135415	jpg	2560	1440	177646	\N	188
189	1	6	3	2015-11-19 13:51:04.729303	2015-11-19 13:51:04.729303	img_20151119_144826	jpg	1440	2560	155127	\N	189
190	1	6	3	2015-11-19 13:51:04.772263	2015-11-19 13:51:04.772263	img_20151119_144831	jpg	2560	1440	152306	\N	190
191	1	6	3	2015-11-19 13:51:04.822302	2015-11-19 13:51:04.822302	img_20151119_144858	jpg	1440	2560	169356	\N	191
192	1	6	3	2015-11-19 13:51:04.83607	2015-11-19 13:51:04.83607	img_20151119_144906	jpg	1440	2560	158445	\N	192
194	1	6	3	2015-11-19 13:59:52.983582	2015-11-19 13:59:52.983582	img_20151119_145757	jpg	1440	2560	122964	\N	194
193	1	6	3	2015-11-19 13:59:52.983283	2015-11-19 13:59:52.983283	img_20151119_145803	jpg	1440	2560	110234	\N	193
195	1	6	3	2015-11-19 13:59:52.989877	2015-11-19 13:59:52.989877	img_20151119_145740	jpg	1440	2560	119976	\N	195
197	1	6	3	2015-11-19 14:33:39.687804	2015-11-19 14:33:39.687804	img_20151119_152107	jpg	1440	2560	128382	\N	197
198	1	6	3	2015-11-19 14:33:40.319651	2015-11-19 14:33:40.319651	img_20151119_152112	jpg	1440	2560	138530	\N	198
199	1	6	3	2015-11-19 14:33:40.95175	2015-11-19 14:33:40.95175	img_20151119_152133	jpg	1440	2560	147734	\N	199
200	1	6	3	2015-11-19 14:33:41.584221	2015-11-19 14:33:41.584221	img_20151119_152138	jpg	1440	2560	159638	\N	200
201	1	6	3	2015-11-19 14:54:15.634969	2015-11-19 14:54:15.634969	img_20151119_152102	jpg	1440	2560	103101	\N	201
202	1	6	3	2015-11-19 14:57:47.443188	2015-11-19 14:57:47.443188	img_20151119_155517	jpg	1440	2560	153852	\N	202
203	1	6	3	2015-11-19 14:57:47.989414	2015-11-19 14:57:47.989414	img_20151119_155523	jpg	1440	2560	72835	\N	203
204	1	6	3	2015-11-19 14:57:48.604411	2015-11-19 14:57:48.604411	img_20151119_155530	jpg	1440	2560	132085	\N	204
205	1	6	3	2015-11-19 14:57:49.186756	2015-11-19 14:57:49.186756	img_20151119_155555	jpg	1440	2560	112793	\N	205
206	1	6	3	2015-11-19 14:57:49.731732	2015-11-19 14:57:49.731732	img_20151119_155605	jpg	1440	2560	106060	\N	206
207	1	6	3	2015-11-19 15:08:18.072942	2015-11-19 15:08:18.072942	img_20151119_160643	jpg	480	640	16256	\N	207
208	1	6	3	2015-11-19 15:08:18.421504	2015-11-19 15:08:18.421504	img_20151119_160652	jpg	480	640	12102	\N	208
209	1	6	3	2015-11-19 15:16:25.695672	2015-11-19 15:16:25.695672	img_20151119_161406	jpg	1440	2560	162425	\N	209
210	1	6	3	2015-11-19 15:16:26.38922	2015-11-19 15:16:26.38922	img_20151119_161421	jpg	1440	2560	158951	\N	210
211	1	6	3	2015-11-19 15:16:27.066826	2015-11-19 15:16:27.066826	img_20151119_161426	jpg	1440	2560	169615	\N	211
212	1	6	3	2015-11-19 15:16:27.61824	2015-11-19 15:16:27.61824	img_20151119_161431	jpg	1440	2560	113410	\N	212
213	1	6	3	2015-11-19 15:16:28.373225	2015-11-19 15:16:28.373225	img_20151119_161449	jpg	1440	2560	170505	\N	213
214	1	6	3	2015-11-19 18:32:40.188417	2015-11-19 18:32:40.188417	img_20151119_193049	jpg	480	640	16804	\N	214
215	1	6	3	2015-11-19 18:39:51.783123	2015-11-19 18:39:51.783123	img_20151119_193751	jpg	1440	2560	94476	\N	215
216	1	6	3	2015-11-19 18:39:52.513215	2015-11-19 18:39:52.513215	img_20151119_193757	jpg	1440	2560	102561	\N	216
217	1	6	3	2015-11-19 18:43:59.757383	2015-11-19 18:43:59.757383	img_20151119_194218	jpg	1440	2560	186195	\N	217
218	1	6	3	2015-11-19 18:44:00.426861	2015-11-19 18:44:00.426861	img_20151119_194223	jpg	1440	2560	97561	\N	218
219	1	6	3	2015-11-19 18:47:14.067431	2015-11-19 18:47:14.067431	img_20151119_194533	jpg	1440	2560	112149	\N	219
220	1	6	3	2015-11-19 18:47:14.666656	2015-11-19 18:47:14.666656	img_20151119_194538	jpg	1440	2560	111519	\N	220
221	1	6	3	2015-11-19 18:54:47.317804	2015-11-19 18:54:47.317804	img_20151119_195228	jpg	1440	2560	102812	\N	221
222	1	6	3	2015-11-19 18:54:48.003862	2015-11-19 18:54:48.003862	img_20151119_195234	jpg	1440	2560	136880	\N	222
223	1	6	3	2015-11-19 18:54:50.375036	2015-11-19 18:54:50.375036	img_20151119_195223	jpg	1440	2560	90446	\N	223
224	1	6	3	2015-11-19 18:59:38.532161	2015-11-19 18:59:38.532161	img_20151119_195754	jpg	1440	2560	98058	\N	224
225	1	6	3	2015-11-19 18:59:39.723695	2015-11-19 18:59:39.723695	img_20151119_195759	jpg	1440	2560	99399	\N	225
226	1	6	3	2015-11-19 18:59:41.963643	2015-11-19 18:59:41.963643	img_20151119_195749	jpg	1440	2560	97678	\N	226
227	1	6	3	2015-11-19 19:06:08.348886	2015-11-19 19:06:08.348886	img_20151119_200424	jpg	1440	2560	152869	\N	227
228	1	6	3	2015-11-19 19:06:09.014179	2015-11-19 19:06:09.014179	img_20151119_200433	jpg	1440	2560	140833	\N	228
229	1	6	3	2015-11-19 19:06:11.271936	2015-11-19 19:06:11.271936	img_20151119_200418	jpg	1440	2560	150957	\N	229
230	1	6	3	2015-11-19 19:18:12.300029	2015-11-19 19:18:12.300029	img_20151119_201433	jpg	1440	2560	118808	\N	230
231	1	6	3	2015-11-19 19:18:12.937322	2015-11-19 19:18:12.937322	img_20151119_201504	jpg	1440	2560	113423	\N	231
232	1	6	3	2015-11-19 19:18:13.483156	2015-11-19 19:18:13.483156	img_20151119_201620	jpg	1440	2560	81375	\N	232
233	1	6	3	2015-11-19 19:18:15.609009	2015-11-19 19:18:15.609009	img_20151119_201348	jpg	1440	2560	115579	\N	233
234	1	6	3	2015-11-19 19:22:24.710108	2015-11-19 19:22:24.710108	img_20151119_201956	jpg	1440	2560	105548	\N	234
235	1	6	3	2015-11-19 19:22:25.350393	2015-11-19 19:22:25.350393	img_20151119_202002	jpg	1440	2560	143987	\N	235
236	1	6	3	2015-11-19 19:22:26.026287	2015-11-19 19:22:26.026287	img_20151119_202021	jpg	1440	2560	146584	\N	236
237	1	6	3	2015-11-19 19:22:26.646964	2015-11-19 19:22:26.646964	img_20151119_202027	jpg	1440	2560	130645	\N	237
238	1	6	3	2015-11-19 19:22:27.304421	2015-11-19 19:22:27.304421	img_20151119_202034	jpg	1440	2560	121126	\N	238
239	1	6	3	2015-11-19 19:22:29.414186	2015-11-19 19:22:29.414186	img_20151119_201951	jpg	1440	2560	107621	\N	239
240	1	6	3	2015-11-22 19:41:15.789349	2015-11-22 19:41:15.789349	img_20151122_203622	jpg	480	640	14638	\N	240
241	1	6	3	2015-11-22 20:29:42.915979	2015-11-22 20:29:42.915979	img_20151122_212611	jpg	480	640	14959	\N	241
242	1	6	3	2015-11-22 20:29:44.796029	2015-11-22 20:29:44.796029	img_20151122_212606	jpg	480	640	14115	\N	242
243	1	6	3	2015-11-23 12:44:08.205715	2015-11-23 12:44:08.205715	img_20151123_133116	jpg	480	640	14854	\N	243
244	1	6	3	2015-11-23 12:44:08.619209	2015-11-23 12:44:08.619209	img_20151123_133134	jpg	480	640	18444	\N	244
245	1	6	3	2015-11-23 12:44:08.928692	2015-11-23 12:44:08.928692	img_20151123_133214	jpg	480	640	12763	\N	245
246	1	6	3	2015-11-23 12:44:09.495826	2015-11-23 12:44:09.495826	img_20151123_133224	jpg	1440	2560	146255	\N	246
247	1	6	3	2015-11-23 12:44:10.148044	2015-11-23 12:44:10.148044	img_20151123_133230	jpg	1440	2560	178041	\N	247
248	1	6	3	2015-11-23 12:44:10.682614	2015-11-23 12:44:10.682614	img_20151123_133236	jpg	1440	2560	104903	\N	248
249	1	6	3	2015-11-23 12:44:12.537276	2015-11-23 12:44:12.537276	img_20151123_133101	jpg	480	640	12259	\N	249
250	1	6	3	2015-11-23 14:00:36.051713	2015-11-23 14:00:36.051713	img_20151123_145852	jpg	1440	2560	111044	\N	250
251	1	6	3	2015-11-23 14:00:36.697016	2015-11-23 14:00:36.697016	img_20151123_145858	jpg	1440	2560	120563	\N	251
252	1	6	3	2015-11-23 14:00:38.929396	2015-11-23 14:00:38.929396	img_20151123_145847	jpg	1440	2560	151630	\N	252
253	1	6	3	2015-11-23 15:14:31.531554	2015-11-23 15:14:31.531554	img_20151123_161302	jpg	1440	2560	83976	\N	253
254	1	6	3	2015-11-23 17:14:42.16015	2015-11-23 17:14:42.16015	img_20151123_181257	jpg	1440	2560	169334	\N	254
255	1	6	3	2015-11-24 16:08:42.401745	2015-11-24 16:08:42.401745	yamal	png	1358	3991	1043870	\N	255
256	1	6	3	2015-11-24 16:09:20.159336	2015-11-24 16:09:20.159336	yamal	png	1358	3991	1043870	\N	256
257	1	6	3	2015-11-24 16:09:44.438386	2015-11-24 16:09:44.438386	yamal	png	1358	3991	1043870	\N	257
258	1	6	3	2015-11-24 16:15:52.405527	2015-11-24 16:15:52.405527	yamal	png	1358	3991	1043870	\N	258
259	1	6	3	2015-11-24 16:16:55.307755	2015-11-24 16:16:55.307755	yamal	png	1358	3991	1043870	\N	259
260	1	6	3	2015-11-24 16:27:48.483278	2015-11-24 16:27:48.483278	yamal	png	1358	3991	1043870	\N	260
261	1	6	3	2015-11-24 16:59:23.962594	2015-11-24 16:59:23.962594	yamal	png	1358	3991	1043870	\N	261
262	1	6	3	2015-11-24 17:00:36.387744	2015-11-24 17:00:36.387744	yamal	png	1358	3991	1043870	\N	262
263	1	6	3	2015-11-24 17:02:20.276613	2015-11-24 17:02:20.276613	yamal	png	1358	3991	1043870	\N	263
264	1	6	3	2015-11-24 17:19:28.289469	2015-11-24 17:19:28.289469	2015-10-24-428	png	647	1961	586951	\N	264
265	1	6	3	2015-11-24 17:20:31.264319	2015-11-24 17:20:31.264319	yamal	png	1358	3991	1043870	\N	265
266	1	6	3	2015-11-24 17:20:55.673256	2015-11-24 17:20:55.673256	2015-10-24-428	png	647	1961	586951	\N	266
267	1	6	3	2015-11-24 17:21:18.387404	2015-11-24 17:21:18.387404	yamal	png	1358	3991	1043870	\N	267
270	1	6	3	2015-11-24 18:38:19.789468	2015-11-24 18:38:19.789468	yamal	png	1358	3991	1043870	\N	270
271	1	6	3	2015-11-24 18:39:43.613685	2015-11-24 18:39:43.613685	yamal	png	1358	3991	1043870	\N	271
272	1	6	3	2015-11-24 18:40:37.620738	2015-11-24 18:40:37.620738	yamal	png	1358	3991	1043870	\N	272
273	1	6	3	2015-11-24 23:56:58.36765	2015-11-24 23:56:58.36765	снимок экрана 2015-09-10 в 23.02.35	png	1920	906	455503	\N	273
274	1	6	3	2015-11-25 00:00:18.741271	2015-11-25 00:00:18.741271	снимок экрана 2015-09-18 в 2.00.41	png	1920	882	356722	\N	274
275	1	6	3	2015-11-25 00:03:19.10139	2015-11-25 00:03:19.10139	снимок экрана 2015-09-18 в 2.06.49	png	1920	883	357888	\N	275
276	1	6	3	2015-11-25 00:03:55.710862	2015-11-25 00:03:55.710862	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	276
277	1	6	3	2015-11-25 00:06:54.396058	2015-11-25 00:06:54.396058	b-day	jpg	720	480	51195	\N	277
278	1	6	3	2015-11-25 00:07:39.330353	2015-11-25 00:07:39.330353	tlh-1jnorxk	jpg	50	50	1730	\N	278
279	1	6	3	2015-11-25 00:08:28.457426	2015-11-25 00:08:28.457426	k1evq-yyw-w	jpg	403	604	25088	\N	279
280	1	6	3	2015-11-25 00:09:12.666875	2015-11-25 00:09:12.666875	снимок экрана 2015-10-04 в 18.25.14	png	642	321	8876	\N	280
281	1	6	3	2015-11-25 00:09:23.020396	2015-11-25 00:09:23.020396	снимок экрана 2015-09-18 в 2.00.41	png	1920	882	356722	\N	281
282	1	6	3	2015-11-25 00:10:46.811601	2015-11-25 00:10:46.811601	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	282
283	1	6	3	2015-11-25 00:11:56.563091	2015-11-25 00:11:56.563091	tlh-1jnorxk	jpg	50	50	1730	\N	283
284	1	6	3	2015-11-25 00:19:36.39817	2015-11-25 00:19:36.39817	снимок экрана 2015-09-10 в 23.02.35	png	1920	906	455503	\N	284
285	1	6	3	2015-11-25 00:19:51.891756	2015-11-25 00:19:51.891756	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	285
286	1	6	3	2015-11-25 00:22:20.631184	2015-11-25 00:22:20.631184	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	286
287	1	6	3	2015-11-25 00:25:07.12081	2015-11-25 00:25:07.12081	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	287
288	1	6	3	2015-11-25 00:30:45.680103	2015-11-25 00:30:45.680103	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	288
289	1	6	3	2015-11-25 11:37:14.744808	2015-11-25 11:37:14.744808	back	png	90	156	2521	\N	289
290	1	6	3	2015-11-25 11:38:28.588302	2015-11-25 11:38:28.588302	back	png	90	156	2521	\N	290
291	1	6	3	2015-11-25 11:38:54.023655	2015-11-25 11:38:54.023655	back	png	90	156	2521	\N	291
292	1	6	3	2015-11-25 11:41:34.717261	2015-11-25 11:41:34.717261	back	png	90	156	2521	\N	292
293	1	6	3	2015-11-25 11:42:07.718793	2015-11-25 11:42:07.718793	back	png	90	156	2521	\N	293
294	1	6	3	2015-11-25 11:46:48.996542	2015-11-25 11:46:48.996542	back	png	90	156	2521	\N	294
295	1	6	3	2015-11-25 11:47:14.813737	2015-11-25 11:47:14.813737	bg1	png	2560	2245	925553	\N	295
296	1	6	3	2015-11-25 11:50:38.131376	2015-11-25 11:50:38.131376	bg1	png	2560	2245	925553	\N	296
297	1	6	3	2015-11-25 11:52:59.66525	2015-11-25 11:52:59.66525	bg1	png	2560	2245	925553	\N	297
298	1	6	3	2015-11-25 11:54:02.13417	2015-11-25 11:54:02.13417	bg1	png	2560	2245	925553	\N	298
299	1	6	3	2015-11-25 12:35:52.79634	2015-11-25 12:35:52.79634	forward	png	90	156	4578	\N	299
300	1	6	3	2015-11-25 16:05:00.012287	2015-11-25 16:05:00.012287	back	png	90	156	2521	\N	300
301	1	6	3	2015-11-25 16:30:44.088797	2015-11-25 16:30:44.088797	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	301
302	1	6	3	2015-11-25 16:37:48.001876	2015-11-25 16:37:48.001876	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	302
303	1	6	3	2015-11-26 13:33:15.158959	2015-11-26 13:33:15.158959	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	303
304	1	6	3	2015-11-28 16:24:50.734833	2015-11-28 16:24:50.734833	img_20151128_162049	jpg	1536	2048	128367	\N	304
305	1	6	3	2015-12-08 16:06:08.087211	2015-12-08 16:06:08.087211	img_20151208_170422	jpg	1440	2560	128616	\N	305
306	1	6	3	2015-12-08 16:09:42.112078	2015-12-08 16:09:42.112078	img_20151208_170653	jpg	1440	2560	183940	\N	306
307	1	6	3	2015-12-08 16:25:25.996314	2015-12-08 16:25:25.996314	284	jpg	2560	1440	134529	\N	307
308	1	6	3	2015-12-08 17:38:16.885242	2015-12-08 17:38:16.885242	8	jpg	200	216	57465	\N	308
309	1	6	3	2015-12-08 17:39:33.231276	2015-12-08 17:39:33.231276	10	jpg	200	216	57465	\N	309
310	1	6	3	2015-12-08 17:42:37.935235	2015-12-08 17:42:37.935235	8	jpg	2640	3960	4243136	\N	310
311	1	6	3	2015-12-08 19:42:06.559013	2015-12-08 19:42:06.559013	10	jpg	2640	3960	4243136	\N	311
312	1	6	3	2015-12-09 14:20:21.892453	2015-12-09 14:20:21.892453	img_20151209_151755	jpg	1440	2560	154641	\N	312
313	1	6	3	2015-12-09 18:16:30.673369	2015-12-09 18:16:30.673369	img_20151209_191113	jpg	1440	2560	113749	\N	313
314	1	6	3	2015-12-09 18:16:31.35145	2015-12-09 18:16:31.35145	img_20151209_191120	jpg	1440	2560	99941	\N	314
315	1	6	3	2015-12-09 18:16:32.025536	2015-12-09 18:16:32.025536	img_20151209_191125	jpg	1440	2560	115056	\N	315
316	1	6	3	2015-12-09 18:16:32.71331	2015-12-09 18:16:32.71331	img_20151209_191130	jpg	1440	2560	111303	\N	316
317	1	6	3	2015-12-09 18:16:33.394143	2015-12-09 18:16:33.394143	img_20151209_191136	jpg	1440	2560	116419	\N	317
318	1	6	3	2015-12-09 18:16:34.199692	2015-12-09 18:16:34.199692	img_20151209_191141	jpg	1440	2560	112407	\N	318
319	1	6	3	2015-12-09 18:16:34.872667	2015-12-09 18:16:34.872667	img_20151209_191146	jpg	1440	2560	108461	\N	319
320	1	6	3	2015-12-09 18:16:35.677884	2015-12-09 18:16:35.677884	img_20151209_191200	jpg	1440	2560	119204	\N	320
321	1	6	3	2015-12-09 18:16:36.623475	2015-12-09 18:16:36.623475	img_20151209_191205	jpg	1440	2560	119845	\N	321
322	1	6	3	2015-12-09 23:44:08.335646	2015-12-09 23:44:08.335646	8	jpg	2592	1936	1186816	\N	322
323	1	6	3	2015-12-10 14:08:17.0972	2015-12-10 14:08:17.0972	img_20151210_150432	jpg	480	640	9205	\N	323
324	1	6	3	2015-12-10 15:37:16.883355	2015-12-10 15:37:16.883355	8	jpg	1024	768	780831	\N	324
325	1	6	3	2015-12-14 13:21:15.429478	2015-12-14 13:21:15.429478	img_20151214_141923	jpg	1440	2560	119274	\N	325
326	1	6	3	2015-12-14 13:21:16.160667	2015-12-14 13:21:16.160667	img_20151214_141928	jpg	1440	2560	135247	\N	326
327	1	6	3	2015-12-14 13:21:18.555034	2015-12-14 13:21:18.555034	img_20151214_141916	jpg	1440	2560	111274	\N	327
328	1	6	3	2015-12-14 13:25:14.274133	2015-12-14 13:25:14.274133	8	jpg	2560	1600	2399175	\N	328
329	1	6	3	2015-12-14 13:25:16.249343	2015-12-14 13:25:16.249343	10	jpg	4800	3000	1304017	\N	329
330	4	6	3	2015-12-21 19:25:19.47295	2015-12-21 19:25:19.47295	приложение б	dwg	\N	\N	15461059	\N	330
331	4	6	3	2015-12-21 19:26:06.989072	2015-12-21 19:26:06.989072	приложение б	dwg	\N	\N	15461059	\N	331
332	4	6	3	2015-12-22 13:09:09.466709	2015-12-22 13:09:09.466709	приложение б	dwg	\N	\N	15461059	\N	332
333	4	6	3	2015-12-22 13:36:34.740157	2015-12-22 13:36:34.740157	приложение б	dwg	\N	\N	15461059	\N	333
334	4	6	3	2015-12-22 13:37:27.273956	2015-12-22 13:37:27.273956	приложение б	dwg	\N	\N	15461059	\N	334
335	4	6	3	2015-12-22 13:41:15.627411	2015-12-22 13:41:15.627411	приложение б	dwg	\N	\N	15461059	\N	335
337	4	6	3	2015-12-22 13:48:42.187309	2015-12-22 13:48:42.187309	приложение б	dwg	\N	\N	15461059	\N	337
338	4	6	3	2015-12-22 13:59:37.893656	2015-12-22 13:59:37.893656	приложение б	dwg	\N	\N	15461059	\N	338
339	4	6	3	2015-12-22 14:04:19.748399	2015-12-22 14:04:19.748399	1.общая схема кц	dwg	\N	\N	12052299	\N	339
340	4	6	3	2015-12-22 14:10:12.22835	2015-12-22 14:10:12.22835	1.общая схема кц	dxf	\N	\N	84365174	\N	340
341	4	6	3	2015-12-22 14:15:33.242315	2015-12-22 14:15:33.242315	приложение б	dwg	\N	\N	15461059	\N	341
342	4	6	3	2015-12-22 14:17:18.65481	2015-12-22 14:17:18.65481	приложение б	dwg	\N	\N	15461059	\N	342
343	4	6	3	2015-12-22 14:24:02.846038	2015-12-22 14:24:02.846038	test_1	dwg	\N	\N	15461059	\N	343
344	4	6	3	2015-12-22 14:41:57.147326	2015-12-22 14:41:57.147326	test_2	dwg	\N	\N	15507024	\N	344
345	4	6	3	2015-12-22 16:07:14.566556	2015-12-22 16:07:14.566556	test_3	dwg	\N	\N	7754354	\N	345
346	4	6	3	2015-12-22 16:21:22.146797	2015-12-22 16:21:22.146797	test_4	dwg	\N	\N	12052299	\N	346
347	4	6	3	2015-12-22 19:17:04.194015	2015-12-22 19:17:04.194015	test_5	dwg	\N	\N	2696778	\N	347
348	4	6	3	2015-12-23 13:43:22.608365	2015-12-23 13:43:22.608365	test_6pdf	pdf	\N	\N	65549	\N	348
349	4	6	3	2015-12-23 14:15:29.951988	2015-12-23 14:15:29.951988	test_7pdf	pdf	\N	\N	2616300	\N	349
350	4	6	3	2015-12-23 15:11:33.971728	2015-12-23 15:11:33.971728	test_6_1pdf	pdf	\N	\N	64827	\N	350
351	4	6	3	2015-12-23 15:59:37.690069	2015-12-23 15:59:37.690069	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	351
352	4	6	3	2015-12-23 16:01:12.369318	2015-12-23 16:01:12.369318	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	352
353	4	6	3	2015-12-23 17:41:15.742578	2015-12-23 17:41:15.742578	приложение	dwg	\N	\N	193802	\N	353
354	4	6	3	2015-12-23 17:43:05.035249	2015-12-23 17:43:05.035249	приложение	dwg	\N	\N	1813462	\N	354
355	1	6	3	2015-12-23 17:44:13.667549	2015-12-23 17:44:13.667549	поз.18 оси после 17	png	4981	1536	907974	\N	355
356	4	6	3	2015-12-23 17:47:31.243319	2015-12-23 17:47:31.243319	приложение 3 схема расположения сети гтм_2.1	dwg	\N	\N	1164469	\N	356
357	4	6	3	2015-12-23 17:47:44.173952	2015-12-23 17:47:44.173952	приложение 3 схема расположения сети гтм_2.3	dwg	\N	\N	1029504	\N	357
358	4	6	3	2015-12-23 17:47:53.97896	2015-12-23 17:47:53.97896	приложение 3 схема расположения сети гтм_2.5	dwg	\N	\N	1082144	\N	358
359	4	6	3	2015-12-23 17:48:05.292988	2015-12-23 17:48:05.292988	приложение 3 схема расположения сети гтм_общая схема	dwg	\N	\N	1203488	\N	359
360	4	6	3	2015-12-23 17:48:16.97628	2015-12-23 17:48:16.97628	приложение 4  конструкция термометрической скважины тс, l=10м	dwg	\N	\N	448808	\N	360
361	4	6	3	2015-12-23 17:48:26.740848	2015-12-23 17:48:26.740848	приложение 5  конструкция грунтового геодезического репера	dwg	\N	\N	150120	\N	361
362	4	6	3	2015-12-23 17:48:35.130618	2015-12-23 17:48:35.130618	приложение 6  конструкция и спецификация деформационной марки на оголовке сваи (тип б)	dwg	\N	\N	157290	\N	362
363	4	6	3	2015-12-23 17:48:43.279919	2015-12-23 17:48:43.279919	приложение 7   деформационная марка тип г	dwg	\N	\N	132979	\N	363
364	4	6	3	2015-12-23 17:56:29.617019	2015-12-23 17:56:29.617019	приложение б	dwg	\N	\N	15461059	\N	364
365	4	6	3	2015-12-23 18:04:34.219558	2015-12-23 18:04:34.219558	приложение б л.1-5	dwg	\N	\N	15507024	\N	365
366	4	6	3	2015-12-23 18:05:45.89001	2015-12-23 18:05:45.89001	приложение б л.6-53	dwg	\N	\N	1757388	\N	366
367	4	6	3	2015-12-23 18:06:05.906045	2015-12-23 18:06:05.906045	приложение б. л.54-71	dwg	\N	\N	1780785	\N	367
368	4	6	3	2015-12-23 18:08:50.088358	2015-12-23 18:08:50.088358	лист 1	dwg	\N	\N	7750965	\N	368
369	4	6	3	2015-12-23 18:10:36.97084	2015-12-23 18:10:36.97084	лист 2	dwg	\N	\N	7754354	\N	369
370	4	6	3	2015-12-23 18:17:20.986076	2015-12-23 18:17:20.986076	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	370
371	4	6	3	2015-12-23 18:17:36.974038	2015-12-23 18:17:36.974038	кс-4 гтп_ книга 2 приложение а - копия	dwg	\N	\N	2696778	\N	371
372	4	6	3	2015-12-23 18:17:56.380801	2015-12-23 18:17:56.380801	кс-4 гтп книга 2 приложение б	dwg	\N	\N	5981350	\N	372
373	4	6	3	2015-12-23 18:23:57.830608	2015-12-23 18:23:57.830608	приложение	dwg	\N	\N	193802	\N	373
374	4	6	3	2015-12-23 18:25:51.601333	2015-12-23 18:25:51.601333	приложение	dwg	\N	\N	1813462	\N	374
375	4	6	3	2015-12-23 18:26:04.005941	2015-12-23 18:26:04.005941	приложение а_лист 1	dwg	\N	\N	377833	\N	375
376	4	6	3	2015-12-23 18:26:13.065899	2015-12-23 18:26:13.065899	приложение а_лист 2	dwg	\N	\N	342321	\N	376
377	4	6	3	2015-12-23 18:26:21.398948	2015-12-23 18:26:21.398948	приложение а_лист 3	dwg	\N	\N	344780	\N	377
378	4	6	3	2015-12-23 18:26:29.069987	2015-12-23 18:26:29.069987	приложение а_лист 4	dwg	\N	\N	373895	\N	378
379	4	6	3	2015-12-23 18:26:38.49176	2015-12-23 18:26:38.49176	приложение а_лист 5	dwg	\N	\N	395383	\N	379
380	4	6	3	2015-12-23 18:26:46.292266	2015-12-23 18:26:46.292266	приложение а_лист 6	dwg	\N	\N	393127	\N	380
381	4	6	3	2015-12-23 18:26:53.838055	2015-12-23 18:26:53.838055	приложение а_лист 7	dwg	\N	\N	390978	\N	381
382	4	6	3	2015-12-23 18:27:20.755065	2015-12-23 18:27:20.755065	приложение а_лист 9	dwg	\N	\N	381482	\N	382
383	4	6	3	2015-12-23 18:28:07.490087	2015-12-23 18:28:07.490087	приложение а_лист 8	dwg	\N	\N	386040	\N	383
384	4	6	3	2015-12-23 18:53:09.376156	2015-12-23 18:53:09.376156	приложение 3 схема расположения сети гтм_2.1	dwg	\N	\N	1164469	\N	384
385	4	6	3	2015-12-23 19:01:05.478293	2015-12-23 19:01:05.478293	а0_в	dwg	\N	\N	94976	\N	385
386	4	6	3	2015-12-23 19:55:05.629074	2015-12-23 19:55:05.629074	а4_в_t1	dwg	\N	\N	43899	\N	386
387	4	6	3	2015-12-24 13:01:55.520889	2015-12-24 13:01:55.520889	приложение а_лист 1_dwg	dwg	\N	\N	330528	\N	387
388	4	6	3	2015-12-24 13:22:11.662156	2015-12-24 13:22:11.662156	test_format_a4	dwg	\N	\N	29196	\N	388
389	4	6	3	2015-12-24 13:22:59.964269	2015-12-24 13:22:59.964269	test_format_a4	dwg	\N	\N	59617	\N	389
390	4	6	3	2015-12-24 17:40:15.500874	2015-12-24 17:40:15.500874	format_a4	dwg	\N	\N	44890	\N	390
391	4	6	3	2015-12-24 17:42:19.180195	2015-12-24 17:42:19.180195	а4_в_pdf4	dwg	\N	\N	53510	\N	391
392	4	6	3	2015-12-24 17:56:11.374834	2015-12-24 17:56:11.374834	а4_в_dwg5	dwg	\N	\N	55238	\N	392
401	1	6	3	2015-12-25 13:27:55.07479	2015-12-25 13:27:55.07479	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	401
394	1	6	3	2015-12-25 13:06:59.643664	2015-12-25 13:06:59.643664	ff9941ce-c9c4-433a-9f45-c43626f123a1	png	4205	5945	835342	\N	394
395	1	6	3	2015-12-25 13:18:43.813434	2015-12-25 13:18:43.813434	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	395
396	1	6	3	2015-12-25 13:23:42.889653	2015-12-25 13:23:42.889653	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	396
397	1	6	3	2015-12-25 13:24:29.642477	2015-12-25 13:24:29.642477	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	397
398	1	6	3	2015-12-25 13:24:37.307281	2015-12-25 13:24:37.307281	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	398
399	1	6	3	2015-12-25 13:24:50.389813	2015-12-25 13:24:50.389813	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	399
400	1	6	3	2015-12-25 13:25:11.543877	2015-12-25 13:25:11.543877	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	400
402	1	6	3	2015-12-25 13:31:05.052551	2015-12-25 13:31:05.052551	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	402
403	1	6	3	2015-12-25 13:31:11.273263	2015-12-25 13:31:11.273263	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	403
404	1	6	3	2015-12-25 13:31:31.46995	2015-12-25 13:31:31.46995	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	404
405	1	6	3	2015-12-25 14:40:17.016689	2015-12-25 14:40:17.016689	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	405
406	1	6	3	2015-12-25 15:50:23.70017	2015-12-25 15:50:23.70017	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	406
407	1	6	3	2015-12-25 15:50:30.264996	2015-12-25 15:50:30.264996	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	407
408	1	6	3	2015-12-25 15:53:41.058936	2015-12-25 15:53:41.058936	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	408
409	1	6	3	2015-12-25 15:54:07.766862	2015-12-25 15:54:07.766862	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	409
410	1	6	3	2015-12-25 15:56:25.53544	2015-12-25 15:56:25.53544	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	410
411	1	6	3	2015-12-25 15:56:48.116263	2015-12-25 15:56:48.116263	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	411
412	1	6	3	2015-12-25 15:57:20.580476	2015-12-25 15:57:20.580476	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	412
413	1	6	3	2015-12-25 15:58:20.589598	2015-12-25 15:58:20.589598	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	413
414	1	6	3	2015-12-25 15:58:30.540984	2015-12-25 15:58:30.540984	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	414
415	1	6	3	2015-12-25 15:58:48.038595	2015-12-25 15:58:48.038595	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	415
416	1	6	3	2015-12-25 15:59:31.704434	2015-12-25 15:59:31.704434	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	416
417	1	6	3	2015-12-25 15:59:46.908331	2015-12-25 15:59:46.908331	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	417
418	1	6	3	2015-12-25 16:01:12.5738	2015-12-25 16:01:12.5738	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	418
419	1	6	3	2015-12-25 16:02:01.234811	2015-12-25 16:02:01.234811	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	419
420	1	6	3	2015-12-25 16:02:21.64306	2015-12-25 16:02:21.64306	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	420
421	1	6	3	2015-12-25 16:02:44.931294	2015-12-25 16:02:44.931294	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	421
422	4	6	3	2015-12-25 19:48:24.911792	2015-12-25 19:48:24.911792	чертеж8	dwg	\N	\N	377633	\N	422
423	1	6	3	2015-12-25 19:53:41.275725	2015-12-25 19:53:41.275725	1a6c79a3-5876-483c-b1c5-728b51e5305a	png	4205	5945	1247626	\N	423
424	1	6	3	2015-12-25 19:55:28.063781	2015-12-25 19:55:28.063781	1a6c79a3-5876-483c-b1c5-728b51e5305a	png	4205	5945	1247626	\N	424
425	4	6	3	2015-12-25 19:56:00.227458	2015-12-25 19:56:00.227458	приложение а_лист 1_dwg	dwg	\N	\N	330528	\N	425
427	1	6	3	2015-12-25 20:04:15.521031	2015-12-25 20:04:15.521031	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4	png	5046	7134	1382338	\N	427
428	1	6	3	2015-12-25 20:04:53.578717	2015-12-25 20:04:53.578717	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4	png	5046	7134	1382338	\N	428
429	4	6	3	2015-12-28 15:13:45.241743	2015-12-28 15:13:45.241743	а4_в_test1	dwg	\N	\N	63714	\N	429
430	4	6	3	2015-12-28 17:07:02.446435	2015-12-28 17:07:02.446435	а4_в_test1	dwg	\N	\N	121874	\N	430
431	4	6	3	2015-12-28 17:08:16.197913	2015-12-28 17:08:16.197913	а4_в_test1	dwg	\N	\N	121874	\N	431
432	4	6	3	2015-12-28 17:09:02.17262	2015-12-28 17:09:02.17262	а4_в_test1_2	dwg	\N	\N	121874	\N	432
433	4	6	3	2015-12-28 17:14:44.340287	2015-12-28 17:14:44.340287	а4_в_test1_3	dwg	\N	\N	116098	\N	433
440	4	14	3	2016-01-11 12:39:57.923182	2016-01-11 12:39:57.923182	model_1pdf	pdf	\N	\N	10200	\N	440
441	4	14	3	2016-01-11 12:39:57.923182	2016-01-11 12:39:57.923182	model_1dwg	dwg	\N	\N	49433	\N	441
442	4	14	3	2016-01-11 12:46:55.394792	2016-01-11 12:46:55.394792	model_1pdf	pdf	\N	\N	10200	\N	442
443	4	14	3	2016-01-11 12:46:55.394792	2016-01-11 12:46:55.394792	model_1dwg	dwg	\N	\N	49433	\N	443
444	4	14	3	2016-01-11 12:48:14.987702	2016-01-11 12:48:14.987702	model_1pdf	pdf	\N	\N	10200	\N	444
445	4	14	3	2016-01-11 12:48:14.987702	2016-01-11 12:48:14.987702	model_1dwg	dwg	\N	\N	49433	\N	445
446	4	14	3	2016-01-11 12:48:43.834068	2016-01-11 12:48:43.834068	model_1pdf	pdf	\N	\N	10200	\N	446
447	4	14	3	2016-01-11 12:48:43.834068	2016-01-11 12:48:43.834068	model_1dwg	dwg	\N	\N	49433	\N	447
448	4	14	3	2016-01-11 13:50:19.334884	2016-01-11 13:50:19.334884	model_1pdf	pdf	\N	\N	10206	\N	448
449	4	14	3	2016-01-11 13:50:19.334884	2016-01-11 13:50:19.334884	model_1pdf	dwg	\N	\N	57507	\N	449
450	4	14	3	2016-01-11 14:26:05.616687	2016-01-11 14:26:05.616687	model_1pdf	pdf	\N	\N	10206	\N	450
451	4	14	3	2016-01-11 14:26:05.616687	2016-01-11 14:26:05.616687	model_1dwg	dwg	\N	\N	69113	\N	451
487	1	6	3	2016-01-13 17:31:13.339233	2016-01-13 17:31:13.339233	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	487
484	1	6	3	2016-01-13 17:27:56.575795	2016-01-13 17:27:56.575795	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	484
483	1	6	3	2016-01-13 17:27:56.545875	2016-01-13 17:27:56.545875	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	483
485	1	6	3	2016-01-13 17:28:03.421963	2016-01-13 17:28:03.421963	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	485
486	1	6	3	2016-01-13 17:30:34.268925	2016-01-13 17:30:34.268925	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	486
488	1	6	3	2016-01-13 17:34:09.019321	2016-01-13 17:34:09.019321	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	488
489	1	6	3	2016-01-13 17:36:00.399721	2016-01-13 17:36:00.399721	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	489
490	1	6	3	2016-01-13 17:37:51.225682	2016-01-13 17:37:51.225682	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	490
491	1	6	3	2016-01-13 17:38:31.521436	2016-01-13 17:38:31.521436	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	491
492	1	6	3	2016-01-13 17:45:00.171032	2016-01-13 17:45:00.171032	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	492
493	1	6	3	2016-01-13 17:45:01.404507	2016-01-13 17:45:01.404507	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	493
494	1	6	3	2016-01-13 17:45:02.896115	2016-01-13 17:45:02.896115	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	494
536	4	14	3	2016-01-15 19:17:16.43725	2016-01-15 19:17:16.43725	a1_g_test_pdf	pdf	\N	\N	284855	\N	536
537	4	14	3	2016-01-15 19:17:16.43725	2016-01-15 19:17:16.43725	a1_g_test_dwg	dwg	\N	\N	147889	\N	537
538	4	14	3	2016-01-15 19:23:56.051979	2016-01-15 19:23:56.051979	a3x6_test_pdf	pdf	\N	\N	234849	\N	538
539	4	14	3	2016-01-15 19:23:56.051979	2016-01-15 19:23:56.051979	a3x6_test_dwg	dwg	\N	\N	335284	\N	539
540	4	14	3	2016-01-16 18:56:33.40192	2016-01-16 18:56:33.40192	a2x3_v_pdf	pdf	\N	\N	9812	\N	540
541	4	14	3	2016-01-16 18:56:33.40192	2016-01-16 18:56:33.40192	a2x3_v_dwg	dwg	\N	\N	72820	\N	541
542	4	14	3	2016-01-18 16:12:29.335377	2016-01-18 16:12:29.335377	a1x2_g_pdf	pdf	\N	\N	165747	\N	542
543	4	14	3	2016-01-18 16:12:29.335377	2016-01-18 16:12:29.335377	a1x2_g_dwg	dwg	\N	\N	118722	\N	543
544	4	14	3	2016-01-18 17:00:43.145247	2016-01-18 17:00:43.145247	a1x2_g_pdf	pdf	\N	\N	165747	\N	544
545	4	14	3	2016-01-18 17:00:43.145247	2016-01-18 17:00:43.145247	a1x2_g_dwg_2	dwg	\N	\N	136874	\N	545
546	4	14	3	2016-01-18 17:34:20.521152	2016-01-18 17:34:20.521152	a1_g_data_pdf	pdf	\N	\N	1205	\N	546
547	4	14	3	2016-01-18 17:34:20.521152	2016-01-18 17:34:20.521152	a1_g_data_dwg	dwg	\N	\N	41050	\N	547
548	4	14	3	2016-01-18 17:40:04.81076	2016-01-18 17:40:04.81076	a1_g_data_pdf	pdf	\N	\N	1205	\N	548
549	4	14	3	2016-01-18 17:40:04.81076	2016-01-18 17:40:04.81076	a1_g_data_dwg	dwg	\N	\N	41050	\N	549
550	4	14	3	2016-01-18 18:47:04.310489	2016-01-18 18:47:04.310489	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	550
551	4	14	3	2016-01-18 18:47:04.310489	2016-01-18 18:47:04.310489	a3x3_g_test_dwg	dxf	\N	\N	636425	\N	551
552	4	14	3	2016-01-19 12:32:13.090002	2016-01-19 12:32:13.090002	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	552
553	4	14	3	2016-01-19 12:32:13.090002	2016-01-19 12:32:13.090002	тестовый_a3x5_g_dwg	dwg	\N	\N	334523	\N	553
554	4	14	3	2016-01-19 13:48:31.875751	2016-01-19 13:48:31.875751	a2_v_test_pdf	pdf	\N	\N	143587	\N	554
555	4	14	3	2016-01-19 13:48:31.875751	2016-01-19 13:48:31.875751	a2_v_test_dwg	dwg	\N	\N	82606	\N	555
556	4	14	3	2016-01-19 15:15:57.048263	2016-01-19 15:15:57.048263	525	pdf	\N	\N	66212	\N	556
557	4	14	3	2016-01-19 15:15:57.048263	2016-01-19 15:15:57.048263	525	dwg	\N	\N	249722	\N	557
558	4	14	3	2016-01-25 18:13:05.183301	2016-01-25 18:13:05.183301	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	558
559	4	14	3	2016-01-29 16:47:56.577496	2016-01-29 16:47:56.577496	a1_g_test_pdf	pdf	\N	\N	284855	\N	559
560	4	14	3	2016-02-03 16:12:51.465416	2016-02-03 16:12:51.465416	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	560
561	4	14	3	2016-02-03 16:21:49.131192	2016-02-03 16:21:49.131192	a1x2_g_pdf	pdf	\N	\N	165747	\N	561
562	4	14	3	2016-02-03 16:26:30.09111	2016-02-03 16:26:30.09111	a2x3_v_pdf	pdf	\N	\N	9812	\N	562
563	4	14	3	2016-02-05 16:42:36.153821	2016-02-05 16:42:36.153821	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	563
564	1	14	3	2016-02-05 17:57:18.457435	2016-02-05 17:57:18.457435	undefinedtmp_img	jpg	2526	1191	149921	\N	564
130	1	6	3	2015-10-13 15:13:00.083498	2015-10-13 15:13:00.083498	desert	jpg	1024	768	845941	\N	130
131	1	6	3	2015-10-20 09:21:48.227128	2015-10-20 09:21:48.227128	снимок	jpg	867	810	161607	\N	131
132	1	6	3	2015-10-20 09:23:18.679573	2015-10-20 09:23:18.679573	снимок	jpg	867	810	161607	\N	132
594	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	594
133	1	6	3	2015-10-20 09:24:12.809607	2015-10-20 09:24:12.809607	снимок	jpg	867	810	161607	\N	133
595	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	595
570	4	14	3	2016-02-05 18:11:20.154202	2016-02-05 18:11:20.154202	a1_g_test_pdf	pdf	\N	\N	284855	\N	570
571	1	14	3	2016-02-05 18:11:20.154202	2016-02-05 18:11:20.154202	undefinedtmp_img	jpg	2384	1684	90964	\N	571
572	4	14	3	2016-02-05 18:54:09.912462	2016-02-05 18:54:09.912462	a2x3_v_pdf	pdf	\N	\N	9812	\N	572
573	1	14	3	2016-02-05 18:54:09.912462	2016-02-05 18:54:09.912462	undefinedtmp_img	jpg	1684	3572	103391	\N	573
574	4	14	3	2016-02-05 18:54:32.878676	2016-02-05 18:54:32.878676	a2_v_test_pdf	pdf	\N	\N	143587	\N	574
575	1	14	3	2016-02-05 18:54:32.878676	2016-02-05 18:54:32.878676	undefinedtmp_img	jpg	1191	1684	73609	\N	575
576	4	14	3	2016-02-05 18:54:58.93275	2016-02-05 18:54:58.93275	a2x3_v_pdf	pdf	\N	\N	9812	\N	576
577	1	14	3	2016-02-05 18:54:58.93275	2016-02-05 18:54:58.93275	undefinedtmp_img	jpg	1684	3572	103391	\N	577
596	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	596
597	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)	jpg	3005	2005	1680341	\N	597
598	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	598
599	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	599
587	1	6	3	2016-02-08 15:04:41.160261	2016-02-08 15:04:41.160261	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	587
588	1	6	3	2016-02-08 15:05:40.582097	2016-02-08 15:05:40.582097	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	588
589	1	6	3	2016-02-08 15:06:42.644165	2016-02-08 15:06:42.644165	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	589
590	1	6	3	2016-02-08 15:06:42.644165	2016-02-08 15:06:42.644165	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	590
591	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	591
592	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	592
593	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	593
600	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	600
601	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	601
602	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	602
603	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	603
604	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	604
605	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)	jpg	3005	2005	1680341	\N	605
606	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	606
607	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	607
608	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	608
609	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	609
610	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	610
611	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	611
612	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	612
613	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	613
614	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	614
615	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	615
616	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	616
617	4	14	3	2016-02-09 14:31:34.630792	2016-02-09 14:31:34.630792	test_7pdf	pdf	\N	\N	2616300	\N	617
618	4	14	3	2016-02-09 14:32:14.564521	2016-02-09 14:32:14.564521	test_7pdf	pdf	\N	\N	2616300	\N	618
619	4	14	3	2016-02-09 14:34:23.544104	2016-02-09 14:34:23.544104	test_7pdf	pdf	\N	\N	2616300	\N	619
620	4	14	3	2016-02-09 14:36:40.138903	2016-02-09 14:36:40.138903	test_7pdf	pdf	\N	\N	2616300	\N	620
621	4	14	3	2016-02-09 14:37:30.976426	2016-02-09 14:37:30.976426	test_7pdf	pdf	\N	\N	2616300	\N	621
622	4	14	3	2016-02-09 14:38:28.723743	2016-02-09 14:38:28.723743	test_7pdf	pdf	\N	\N	2616300	\N	622
623	4	14	3	2016-02-09 14:38:29.300325	2016-02-09 14:38:29.300325	test_7pdf	pdf	\N	\N	2616300	\N	623
624	4	14	3	2016-02-09 14:39:24.657219	2016-02-09 14:39:24.657219	test_7pdf	pdf	\N	\N	2616300	\N	624
625	4	14	3	2016-02-09 14:40:16.456616	2016-02-09 14:40:16.456616	test_7pdf	pdf	\N	\N	2616300	\N	625
626	4	14	3	2016-02-09 14:41:02.445019	2016-02-09 14:41:02.445019	test_7pdf	pdf	\N	\N	2616300	\N	626
627	4	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	test_7pdf	pdf	\N	\N	2616300	\N	627
628	4	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	undefinedtmp2	pdf	\N	\N	2621140	\N	628
629	1	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	undefinedtmp_img	jpg	2384	1684	601535	\N	629
630	4	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	a1_g_test_pdf	pdf	\N	\N	284855	\N	630
631	4	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	undefinedtmp2	pdf	\N	\N	203268	\N	631
632	1	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	undefinedtmp_img	jpg	2384	1684	90964	\N	632
633	4	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	снимок экрана 2016-02-11 в 17.18.15	pdf	\N	\N	308863	\N	633
634	4	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	undefinedtmp2	pdf	\N	\N	314761	\N	634
635	1	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	undefinedtmp_img	jpg	792	655	77489	\N	635
636	4	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	снимок экрана 2016-02-11 в 17.18.15	pdf	\N	\N	308863	\N	636
637	4	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	undefinedtmp2	pdf	\N	\N	314755	\N	637
638	1	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	undefinedtmp_img	jpg	792	655	77489	\N	638
639	4	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	a3x6_test_pdf	pdf	\N	\N	234849	\N	639
640	4	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	undefinedtmp2	pdf	\N	\N	174075	\N	640
641	1	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	undefinedtmp_img	jpg	4768	1191	217032	\N	641
642	4	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	a3x6_test_pdf	pdf	\N	\N	234849	\N	642
643	4	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	undefinedtmp2	pdf	\N	\N	174104	\N	643
644	1	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	undefinedtmp_img	jpg	4768	1191	217032	\N	644
645	4	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	645
646	4	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	undefinedtmp2	pdf	\N	\N	172492	\N	646
647	1	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	undefinedtmp_img	jpg	4768	1191	217252	\N	647
648	4	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	648
649	4	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	undefinedtmp2	pdf	\N	\N	81980	\N	649
650	1	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	undefinedtmp_img	jpg	2526	1191	149921	\N	650
651	4	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	a2_v_test_pdf	pdf	\N	\N	143587	\N	651
652	4	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	undefinedtmp2	pdf	\N	\N	97429	\N	652
653	1	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	undefinedtmp_img	jpg	1191	1684	73609	\N	653
654	4	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	a2x3_v_pdf	pdf	\N	\N	9812	\N	654
655	4	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	undefinedtmp2	pdf	\N	\N	16343	\N	655
656	1	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	undefinedtmp_img	jpg	1684	3572	103391	\N	656
657	4	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	a1x2_g_pdf	pdf	\N	\N	165747	\N	657
658	4	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	undefinedtmp2	pdf	\N	\N	118353	\N	658
659	1	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	undefinedtmp_img	jpg	2384	3370	206355	\N	659
660	4	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	a1x2_g_pdf	pdf	\N	\N	165747	\N	660
661	4	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	undefinedtmp2	pdf	\N	\N	118358	\N	661
662	1	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	undefinedtmp_img	jpg	2384	3370	206355	\N	662
670	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a0_v	dwg	\N	\N	41498	\N	670
671	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a0_v	pdf	\N	\N	7474	\N	671
672	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_h	dwg	\N	\N	40955	\N	672
673	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_h	pdf	\N	\N	7474	\N	673
674	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_v	dwg	\N	\N	41210	\N	674
675	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_v	pdf	\N	\N	7457	\N	675
676	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1x3_h	dwg	\N	\N	41371	\N	676
677	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1x3_h	pdf	\N	\N	7468	\N	677
678	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_h	dwg	\N	\N	41019	\N	678
679	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_h	pdf	\N	\N	7477	\N	679
680	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_v	dwg	\N	\N	41467	\N	680
681	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_v	pdf	\N	\N	7486	\N	681
682	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2×4_v	dwg	\N	\N	41053	\N	682
683	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2×4_v	pdf	\N	\N	7475	\N	683
684	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_h	dwg	\N	\N	41051	\N	684
685	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_h	pdf	\N	\N	7451	\N	685
686	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_v	dwg	\N	\N	41019	\N	686
134	1	6	3	2015-10-20 09:28:24.107818	2015-10-20 09:28:24.107818	снимок	jpg	867	810	161607	\N	134
135	1	6	3	2015-10-20 10:05:33.157261	2015-10-20 10:05:33.157261	снимок	jpg	867	810	161607	\N	135
136	1	6	3	2015-10-20 11:32:23.970314	2015-10-20 11:32:23.970314	013 приложение д схема расположения элементов сети гтм	jpg	3309	4678	1225525	\N	136
138	1	6	3	2015-10-21 13:39:35.440439	2015-10-21 13:39:35.440439	013 приложение д схема расположения элементов сети гтм	jpg	1900	830	197839	\N	138
139	1	6	3	2015-10-21 13:55:27.400279	2015-10-21 13:55:27.400279	7тест	jpg	13200	10200	3817309	\N	139
140	1	6	3	2015-10-21 13:56:15.911598	2015-10-21 13:56:15.911598	7тест	jpg	13200	10200	3817309	\N	140
141	1	6	3	2015-10-21 13:59:39.97624	2015-10-21 13:59:39.97624	8тест	jpg	6600	5100	1350332	\N	141
530	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x5_g_1486x420	dwg	\N	\N	41660	\N	530
500	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1_g_841x594	pdf	\N	\N	9237	\N	500
501	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1_v_594x841	pdf	\N	\N	9229	\N	501
502	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x2_594x1682_v	pdf	\N	\N	9228	\N	502
503	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x2_g_841x1189	pdf	\N	\N	9244	\N	503
504	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x3_g_1783x841	pdf	\N	\N	9230	\N	504
687	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_v	pdf	\N	\N	7457	\N	687
688	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_h	dwg	\N	\N	41402	\N	688
689	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_h	pdf	\N	\N	7479	\N	689
690	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_v	dwg	\N	\N	41594	\N	690
691	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_v	pdf	\N	\N	7735	\N	691
692	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x3_h	dwg	\N	\N	41626	\N	692
693	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x3_h	pdf	\N	\N	7470	\N	693
694	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x4_h	dwg	\N	\N	41562	\N	694
695	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x4_h	pdf	\N	\N	7482	\N	695
696	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x5_h	dwg	\N	\N	41597	\N	696
697	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x5_h	pdf	\N	\N	7460	\N	697
698	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x6_h	dwg	\N	\N	41563	\N	698
699	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x6_h	pdf	\N	\N	7486	\N	699
700	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4_v	dwg	\N	\N	41688	\N	700
701	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4_v	pdf	\N	\N	7472	\N	701
702	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x3_h	dwg	\N	\N	41724	\N	702
703	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x3_h	pdf	\N	\N	7475	\N	703
704	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x6_h	dwg	\N	\N	41466	\N	704
705	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x6_h	pdf	\N	\N	7724	\N	705
706	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x8_h	dwg	\N	\N	41275	\N	706
707	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x8_h	pdf	\N	\N	7466	\N	707
708	4	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	small_pdf	pdf	\N	\N	4209	\N	708
709	4	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	undefinedtmp2	pdf	\N	\N	10260	\N	709
710	1	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	undefinedtmp_img	jpg	283	283	615	\N	710
711	4	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	small_pdf	pdf	\N	\N	4209	\N	711
712	4	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	undefinedtmp2	pdf	\N	\N	10260	\N	712
713	1	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	undefinedtmp_img	jpg	283	283	615	\N	713
714	4	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	small_pdf	pdf	\N	\N	4209	\N	714
715	4	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	undefinedtmp2	pdf	\N	\N	10274	\N	715
716	1	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	undefinedtmp_img	jpg	283	283	615	\N	716
717	4	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	small_pdf	pdf	\N	\N	4209	\N	717
718	4	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	undefinedtmp2	pdf	\N	\N	10279	\N	718
719	1	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	undefinedtmp_img	jpg	283	283	615	\N	719
720	4	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	small_pdf	pdf	\N	\N	4209	\N	720
721	4	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	undefinedtmp2	pdf	\N	\N	10262	\N	721
722	1	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	undefinedtmp_img	jpg	283	283	615	\N	722
505	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2_g_594x420	pdf	\N	\N	9231	\N	505
506	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2_v_420x594	pdf	\N	\N	9164	\N	506
507	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2x3_1261x594	pdf	\N	\N	9213	\N	507
508	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2x3_v_594x1260	pdf	\N	\N	9218	\N	508
509	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3_v_297x420	pdf	\N	\N	9166	\N	509
510	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x3_g_891x420	pdf	\N	\N	9226	\N	510
511	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x4_g_1189x420	pdf	\N	\N	9234	\N	511
512	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x5_g_1486x420	pdf	\N	\N	9210	\N	512
513	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x6_g_1682x420	pdf	\N	\N	9211	\N	513
514	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4_v_210x297	pdf	\N	\N	9121	\N	514
515	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x3_g_630x297	pdf	\N	\N	9231	\N	515
516	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x6_g_1260x297	pdf	\N	\N	9226	\N	516
517	4	12	3	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x8_g_1680x297	pdf	\N	\N	9220	\N	517
518	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1_g_841x594	dwg	\N	\N	41182	\N	518
519	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1_v_594x841	dwg	\N	\N	41114	\N	519
520	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x2_594x1682_v	dwg	\N	\N	41500	\N	520
521	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x2_g_841x1189	dwg	\N	\N	41213	\N	521
522	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x3_g_1783x841	dwg	\N	\N	41502	\N	522
523	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2_g_594x420	dwg	\N	\N	41146	\N	523
524	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2_v_420x594	dwg	\N	\N	41820	\N	524
525	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2x3_1261x594	dwg	\N	\N	41630	\N	525
526	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2x3_v_594x1260	dwg	\N	\N	41566	\N	526
527	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3_v_297x420	dwg	\N	\N	41560	\N	527
528	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x3_g_891x420	dwg	\N	\N	41564	\N	528
529	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x4_g_1189x420	dwg	\N	\N	41434	\N	529
531	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x6_g_1682x420	dwg	\N	\N	41501	\N	531
532	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4_v_210x297	dwg	\N	\N	41370	\N	532
533	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x3_g_630x297	dwg	\N	\N	41721	\N	533
534	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x6_g_1260x297	dwg	\N	\N	42842	\N	534
535	4	13	3	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x8_g_1680x297	dwg	\N	\N	41534	\N	535
663	4	14	3	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	523_кс-2ярынская	pdf	\N	\N	122645	\N	663
664	4	14	3	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	undefinedtmp2	pdf	\N	\N	129992	\N	664
665	1	14	3	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	undefinedtmp_img	jpg	1684	1191	174326	\N	665
723	4	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	small_pdf	pdf	\N	\N	4209	\N	723
724	4	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	undefinedtmp2	pdf	\N	\N	10260	\N	724
725	1	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	undefinedtmp_img	jpg	283	283	615	\N	725
726	4	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	small_pdf	pdf	\N	\N	4209	\N	726
727	4	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	undefinedtmp2	pdf	\N	\N	10274	\N	727
728	1	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	undefinedtmp_img	jpg	283	283	615	\N	728
729	4	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	small_pdf	pdf	\N	\N	4209	\N	729
730	4	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	undefinedtmp2	pdf	\N	\N	10279	\N	730
731	1	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	undefinedtmp_img	jpg	283	283	615	\N	731
732	4	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	small_pdf	pdf	\N	\N	4209	\N	732
733	4	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	undefinedtmp2	pdf	\N	\N	10262	\N	733
734	1	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	undefinedtmp_img	jpg	283	283	615	\N	734
735	4	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	small_pdf	pdf	\N	\N	4209	\N	735
736	4	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	undefinedtmp2	pdf	\N	\N	10263	\N	736
737	1	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	undefinedtmp_img	jpg	283	283	615	\N	737
738	4	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	small_pdf	pdf	\N	\N	4209	\N	738
739	4	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	undefinedtmp2	pdf	\N	\N	10262	\N	739
740	1	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	undefinedtmp_img	jpg	283	283	615	\N	740
741	4	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	small_pdf	pdf	\N	\N	4209	\N	741
742	4	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	undefinedtmp2	pdf	\N	\N	10271	\N	742
743	1	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	undefinedtmp_img	jpg	283	283	615	\N	743
744	4	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	small_pdf	pdf	\N	\N	4209	\N	744
745	4	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	undefinedtmp2	pdf	\N	\N	10255	\N	745
746	1	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	undefinedtmp_img	jpg	283	283	615	\N	746
747	4	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	small_pdf	pdf	\N	\N	4209	\N	747
748	4	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	undefinedtmp2	pdf	\N	\N	11647	\N	748
749	1	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	undefinedtmp_img	jpg	283	283	615	\N	749
750	4	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	small_pdf	pdf	\N	\N	4209	\N	750
751	4	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	undefinedtmp2	pdf	\N	\N	11647	\N	751
752	1	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	undefinedtmp_img	jpg	283	283	615	\N	752
753	4	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	small_pdf	pdf	\N	\N	4209	\N	753
754	4	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	undefinedtmp2	pdf	\N	\N	10242	\N	754
755	1	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	undefinedtmp_img	jpg	283	283	615	\N	755
756	4	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	small_pdf	pdf	\N	\N	4209	\N	756
757	4	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	undefinedtmp2	pdf	\N	\N	10272	\N	757
666	4	14	3	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	523_кс-2ярынская	dwg	\N	\N	326601	\N	666
667	4	14	3	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	поз. 1.3	pdf	\N	\N	300233	\N	667
668	4	14	3	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	undefinedtmp2	pdf	\N	\N	305466	\N	668
669	1	14	3	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	undefinedtmp_img	jpg	1786	842	157453	\N	669
789	4	14	13	2017-01-17 10:12:38.286407	2017-01-17 10:12:38.286407	14_факел_поз 9.1-model	pdf	\N	\N	45911	\N	789
790	4	14	13	2017-01-17 10:12:38.286407	2017-01-17 10:12:38.286407	undefinedtmp2	pdf	\N	\N	52118	\N	790
791	1	14	13	2017-01-17 10:12:38.286407	2017-01-17 10:12:38.286407	undefinedtmp_img	jpg	1684	1191	70857	\N	791
795	4	14	13	2017-01-17 10:31:49.686911	2017-01-17 10:31:49.686911	огтм_куюмб-е м-е	pdf	\N	\N	1861586	\N	795
796	4	14	13	2017-01-17 10:31:49.686911	2017-01-17 10:31:49.686911	undefinedtmp2	pdf	\N	\N	1850480	\N	796
797	1	14	13	2017-01-17 10:31:49.686911	2017-01-17 10:31:49.686911	undefinedtmp_img	jpg	2384	1684	363487	\N	797
801	4	14	13	2017-01-17 10:34:32.154891	2017-01-17 10:34:32.154891	огтм_	pdf	\N	\N	1859723	\N	801
802	4	14	13	2017-01-17 10:34:32.154891	2017-01-17 10:34:32.154891	undefinedtmp2	pdf	\N	\N	1849032	\N	802
803	1	14	13	2017-01-17 10:34:32.154891	2017-01-17 10:34:32.154891	undefinedtmp_img	jpg	2384	1684	363982	\N	803
810	4	14	13	2017-01-24 15:03:52.862257	2017-01-24 15:03:52.862257	схема2	pdf	\N	\N	91309	\N	810
811	4	14	13	2017-01-24 15:03:52.862257	2017-01-24 15:03:52.862257	undefinedtmp2	pdf	\N	\N	72566	\N	811
812	1	14	13	2017-01-24 15:03:52.862257	2017-01-24 15:03:52.862257	undefinedtmp_img	jpg	2384	1684	172030	\N	812
816	4	14	13	2017-01-24 15:05:33.557905	2017-01-24 15:05:33.557905	2	pdf	\N	\N	142822	\N	816
817	4	14	13	2017-01-24 15:05:33.557905	2017-01-24 15:05:33.557905	undefinedtmp2	pdf	\N	\N	106958	\N	817
818	1	14	13	2017-01-24 15:05:33.557905	2017-01-24 15:05:33.557905	undefinedtmp_img	jpg	1684	1191	208361	\N	818
822	1	6	13	2017-01-25 11:37:21.987579	2017-01-25 11:37:21.987579	img_20170125_112006	jpg	3264	1836	312215	\N	822
824	1	6	13	2017-01-25 11:37:24.774278	2017-01-25 11:37:24.774278	img_20170125_112953	jpg	3264	1836	545902	\N	824
826	1	6	13	2017-01-25 13:54:34.534488	2017-01-25 13:54:34.534488	img_20170125_134810	jpg	3264	1836	301361	\N	826
827	4	14	13	2017-02-01 10:31:56.584994	2017-02-01 10:31:56.584994	13_рез-дм-на-люк_бб_поз 8.1_8.2-model	pdf	\N	\N	52595	\N	827
828	4	14	13	2017-02-01 10:31:56.584994	2017-02-01 10:31:56.584994	undefinedtmp2	pdf	\N	\N	59020	\N	828
829	1	14	13	2017-02-01 10:31:56.584994	2017-02-01 10:31:56.584994	undefinedtmp_img	jpg	1684	1191	54625	\N	829
830	4	14	13	2017-02-01 10:48:10.800953	2017-02-01 10:48:10.800953	45_рез на 2 ростверках_поз 52.2.3-model	pdf	\N	\N	10271	\N	830
831	4	14	13	2017-02-01 10:48:10.800953	2017-02-01 10:48:10.800953	undefinedtmp2	pdf	\N	\N	16427	\N	831
758	1	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	undefinedtmp_img	jpg	283	283	615	\N	758
759	4	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	small_pdf	pdf	\N	\N	4209	\N	759
760	4	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	undefinedtmp2	pdf	\N	\N	10258	\N	760
761	1	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	undefinedtmp_img	jpg	283	283	615	\N	761
762	4	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	small_pdf	pdf	\N	\N	4209	\N	762
763	4	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	undefinedtmp2	pdf	\N	\N	10268	\N	763
764	1	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	undefinedtmp_img	jpg	283	283	615	\N	764
765	4	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	small_pdf	pdf	\N	\N	4209	\N	765
766	4	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	undefinedtmp2	pdf	\N	\N	10269	\N	766
767	1	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	undefinedtmp_img	jpg	283	283	615	\N	767
768	4	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	small_pdf	pdf	\N	\N	4209	\N	768
769	4	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	undefinedtmp2	pdf	\N	\N	10274	\N	769
770	1	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	undefinedtmp_img	jpg	283	283	615	\N	770
771	4	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	small_pdf	pdf	\N	\N	4209	\N	771
772	4	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	undefinedtmp2	pdf	\N	\N	10267	\N	772
773	1	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	undefinedtmp_img	jpg	283	283	615	\N	773
774	4	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	small_pdf	pdf	\N	\N	4209	\N	774
775	4	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	undefinedtmp2	pdf	\N	\N	10266	\N	775
776	1	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	undefinedtmp_img	jpg	283	283	615	\N	776
777	4	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	small_pdf	pdf	\N	\N	4209	\N	777
778	4	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	undefinedtmp2	pdf	\N	\N	10265	\N	778
779	1	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	undefinedtmp_img	jpg	283	283	615	\N	779
780	4	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	small_pdf	pdf	\N	\N	4209	\N	780
781	4	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	undefinedtmp2	pdf	\N	\N	10267	\N	781
782	1	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	undefinedtmp_img	jpg	283	283	615	\N	782
783	4	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	small_pdf	pdf	\N	\N	4209	\N	783
784	4	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	undefinedtmp2	pdf	\N	\N	10242	\N	784
785	1	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	undefinedtmp_img	jpg	283	283	615	\N	785
786	4	14	13	2017-01-17 10:09:33.641136	2017-01-17 10:09:33.641136	огтм_куюмб-е м-е	pdf	\N	\N	1861586	\N	786
787	4	14	13	2017-01-17 10:09:33.641136	2017-01-17 10:09:33.641136	undefinedtmp2	pdf	\N	\N	1850480	\N	787
788	1	14	13	2017-01-17 10:09:33.641136	2017-01-17 10:09:33.641136	undefinedtmp_img	jpg	2384	1684	363487	\N	788
792	4	14	13	2017-01-17 10:30:22.861641	2017-01-17 10:30:22.861641	огтм_куюмб-е м-е	pdf	\N	\N	1861586	\N	792
793	4	14	13	2017-01-17 10:30:22.861641	2017-01-17 10:30:22.861641	undefinedtmp2	pdf	\N	\N	1850480	\N	793
794	1	14	13	2017-01-17 10:30:22.861641	2017-01-17 10:30:22.861641	undefinedtmp_img	jpg	2384	1684	363487	\N	794
798	4	14	13	2017-01-17 10:33:56.027867	2017-01-17 10:33:56.027867	111	pdf	\N	\N	1861586	\N	798
799	4	14	13	2017-01-17 10:33:56.027867	2017-01-17 10:33:56.027867	undefinedtmp2	pdf	\N	\N	1850480	\N	799
800	1	14	13	2017-01-17 10:33:56.027867	2017-01-17 10:33:56.027867	undefinedtmp_img	jpg	2384	1684	363487	\N	800
804	4	14	13	2017-01-17 13:05:51.470859	2017-01-17 13:05:51.470859	куюмб огтм_цпс	pdf	\N	\N	1861586	\N	804
805	4	14	13	2017-01-17 13:05:51.470859	2017-01-17 13:05:51.470859	undefinedtmp2	pdf	\N	\N	1850482	\N	805
806	1	14	13	2017-01-17 13:05:51.470859	2017-01-17 13:05:51.470859	undefinedtmp_img	jpg	2384	3370	611440	\N	806
807	4	14	13	2017-01-24 14:58:29.347357	2017-01-24 14:58:29.347357	схема	pdf	\N	\N	91254	\N	807
808	4	14	13	2017-01-24 14:58:29.347357	2017-01-24 14:58:29.347357	undefinedtmp2	pdf	\N	\N	72493	\N	808
809	1	14	13	2017-01-24 14:58:29.347357	2017-01-24 14:58:29.347357	undefinedtmp_img	jpg	2384	1684	172109	\N	809
813	4	14	13	2017-01-24 15:04:53.270441	2017-01-24 15:04:53.270441	1	pdf	\N	\N	78254	\N	813
814	4	14	13	2017-01-24 15:04:53.270441	2017-01-24 15:04:53.270441	undefinedtmp2	pdf	\N	\N	65524	\N	814
815	1	14	13	2017-01-24 15:04:53.270441	2017-01-24 15:04:53.270441	undefinedtmp_img	jpg	1684	1191	167535	\N	815
819	4	14	13	2017-01-24 15:06:12.736669	2017-01-24 15:06:12.736669	каталог	pdf	\N	\N	141664	\N	819
820	4	14	13	2017-01-24 15:06:12.736669	2017-01-24 15:06:12.736669	undefinedtmp2	pdf	\N	\N	91515	\N	820
821	1	14	13	2017-01-24 15:06:12.736669	2017-01-24 15:06:12.736669	undefinedtmp_img	jpg	1684	1191	241027	\N	821
823	1	6	13	2017-01-25 11:37:23.074202	2017-01-25 11:37:23.074202	img_20170125_112649	jpg	3264	1836	312531	\N	823
825	1	6	13	2017-01-25 11:37:25.897073	2017-01-25 11:37:25.897073	img_20170125_113352	jpg	3264	1836	370350	\N	825
832	1	14	13	2017-02-01 10:48:10.800953	2017-02-01 10:48:10.800953	undefinedtmp_img	jpg	1684	1191	53643	\N	832
833	1	6	3	2017-02-15 18:30:01.140921	2017-02-15 18:30:01.140921	1487172594912	jpg	1440	2560	82351	\N	833
834	4	14	13	2017-03-21 13:57:04.708448	2017-03-21 13:57:04.708448	тестовый генплан 31 куст	pdf	\N	\N	274241	\N	834
835	4	14	13	2017-03-21 13:57:04.708448	2017-03-21 13:57:04.708448	undefinedtmp2	pdf	\N	\N	245665	\N	835
836	1	14	13	2017-03-21 13:57:04.708448	2017-03-21 13:57:04.708448	undefinedtmp_img	jpg	2384	1684	280132	\N	836
837	4	14	13	2017-03-21 14:36:28.460442	2017-03-21 14:36:28.460442	тест_поз.8	pdf	\N	\N	27749	\N	837
838	4	14	13	2017-03-21 14:36:28.460442	2017-03-21 14:36:28.460442	undefinedtmp2	pdf	\N	\N	25006	\N	838
839	1	14	13	2017-03-21 14:36:28.460442	2017-03-21 14:36:28.460442	undefinedtmp_img	jpg	1684	1191	59588	\N	839
\.


--
-- Name: tfiles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfiles_id_seq', 839, true);


--
-- Data for Name: tfiles_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tfiles_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	img3
2	2	1	facility_1440418985165
3	3	1	facility_1440419104378
6	6	1	img3
7	7	1	анжер
8	8	1	dm_ico50_50
9	9	1	gdm_ico50_50
10	10	1	gr_ico50_50
11	11	1	ps_ico50_50
12	12	1	tdg_ico50_50
13	13	1	ts_ico50_50
14	14	1	photo_ico50_50
15	15	1	subfac_ico50_50
16	16	1	6
17	17	1	6
18	18	1	6
19	19	1	img3
20	20	1	объект_1
21	21	1	объект_1
22	22	1	test4
23	23	1	test3
24	24	1	test3
25	25	1	test3
26	26	1	test4
27	27	1	test3
28	28	1	test2
29	29	1	test
30	30	1	test2
31	31	1	test2
32	32	1	test2
33	33	1	test4
34	34	1	test2
35	35	1	avatar
36	36	1	avatar
37	37	1	avatar
38	38	1	test2
39	39	1	avatar
40	40	1	test2
41	41	1	avatar
42	42	1	объект_1
43	43	1	element_sheet
44	44	1	объект_1
45	45	1	объект_1
46	46	1	объект_1
47	47	1	объект_1
48	48	1	объект_1
49	49	1	объект_1
50	50	1	avatar
51	51	1	403ds-multi-purge-manifold-pr-600px
52	53	1	engineering-and-geodetic-surveys
53	52	1	carottage5
54	54	1	51232801ac79590c7f03cba5[1]
55	55	1	boif-djd2-gh
56	56	1	boif-djd2-gh
57	57	1	engineering-and-geodetic-surveys
58	58	1	403ds-multi-purge-manifold-pr-600px
59	59	1	carottage5
60	60	1	boif-djd2-gh
61	61	1	51232801ac79590c7f03cba5[1]
62	62	1	engineering-and-geodetic-surveys
63	63	1	403ds-multi-purge-manifold-pr-600px
64	64	1	boif-djd2-gh
65	65	1	carottage5
66	66	1	engineering-and-geodetic-surveys
67	67	1	51232801ac79590c7f03cba5[1]
68	68	1	403ds-multi-purge-manifold-pr-600px
69	69	1	carottage5
70	70	1	engineering-and-geodetic-surveys
71	71	1	boif-djd2-gh
72	72	1	51232801ac79590c7f03cba5[1]
73	73	1	403ds-multi-purge-manifold-pr-600px
74	74	1	engineering-and-geodetic-surveys
75	75	1	boif-djd2-gh
76	76	1	carottage5
77	77	1	51232801ac79590c7f03cba5[1]
78	78	1	403ds-multi-purge-manifold-pr-600px
79	79	1	carottage5
80	80	1	boif-djd2-gh
81	81	1	engineering-and-geodetic-surveys
82	82	1	51232801ac79590c7f03cba5[1]
83	83	1	403ds-multi-purge-manifold-pr-600px
84	84	1	carottage5
85	85	1	engineering-and-geodetic-surveys
86	86	1	boif-djd2-gh
87	87	1	51232801ac79590c7f03cba5[1]
88	88	1	403ds-multi-purge-manifold-pr-600px
89	89	1	engineering-and-geodetic-surveys
90	90	1	carottage5
91	91	1	51232801ac79590c7f03cba5[1]
92	92	1	boif-djd2-gh
93	93	1	403ds-multi-purge-manifold-pr-600px
94	94	1	engineering-and-geodetic-surveys
95	95	1	carottage5
96	96	1	boif-djd2-gh
97	97	1	51232801ac79590c7f03cba5[1]
98	98	1	403ds-multi-purge-manifold-pr-600px
99	99	1	engineering-and-geodetic-surveys
100	100	1	boif-djd2-gh
101	101	1	51232801ac79590c7f03cba5[1]
102	102	1	carottage5
103	103	1	403ds-multi-purge-manifold-pr-600px
104	104	1	carottage5
105	105	1	engineering-and-geodetic-surveys
106	106	1	boif-djd2-gh
107	107	1	51232801ac79590c7f03cba5[1]
108	108	1	403ds-multi-purge-manifold-pr-600px
109	109	1	carottage5
110	110	1	boif-djd2-gh
111	111	1	51232801ac79590c7f03cba5[1]
432	445	1	model_1dwg
112	112	1	engineering-and-geodetic-surveys
113	113	1	engineering-and-geodetic-surveys
114	114	1	carottage5
115	115	1	boif-djd2-gh
116	116	1	51232801ac79590c7f03cba5[1]
117	117	1	engineering-and-geodetic-surveys
118	118	1	объект_1
119	119	1	объект_1
120	120	1	trollface
121	121	1	trollface
122	122	1	carottage5
123	123	1	boif-djd2-gh
124	124	1	engineering-and-geodetic-surveys
125	125	1	51232801ac79590c7f03cba5[1]
126	126	1	403ds-multi-purge-manifold-pr-600px
127	127	1	boif-djd2-gh
128	128	1	51232801ac79590c7f03cba5[1]
129	129	1	объект_1
130	130	1	desert
131	131	1	снимок
132	132	1	снимок
133	133	1	снимок
134	134	1	снимок
135	135	1	снимок
136	136	1	013 приложение д схема расположения элементов сети гтм
138	138	1	013 приложение д схема расположения элементов сети гтм
139	139	1	7тест
140	140	1	7тест
141	141	1	8тест
142	142	1	blank_1
143	143	1	объект_1
144	144	1	объект_1
145	145	1	image
146	146	1	лист.2-44
147	147	1	лист.2-44
148	148	1	лист.2-44
149	149	1	1.общая схема кц
150	150	1	чертеж8
151	151	1	1.общая схема кц
152	152	1	лист.2-44
153	153	1	лист 17 поз.5.4
154	154	1	orion_hubble_6000
155	155	1	orion_hubble_6000
156	156	1	chart
157	157	1	desert
158	170	1	img_20151118_192946
159	171	1	img_20151118_192813
160	172	1	img_20151118_192830
161	173	1	img_20151118_192813
162	174	1	img_20151118_192946
163	175	1	img_20151118_192830
170	182	1	img_20151119_135415
171	183	1	img_20151119_135415
172	184	1	img_20151119_135404
173	185	1	img_20151119_135415
174	186	1	img_20151119_135404
175	187	1	img_20151119_135415
176	188	1	img_20151119_135415
177	189	1	img_20151119_144826
178	190	1	img_20151119_144831
179	191	1	img_20151119_144858
180	192	1	img_20151119_144906
181	194	1	img_20151119_145757
182	193	1	img_20151119_145803
183	195	1	img_20151119_145740
185	197	1	img_20151119_152107
186	198	1	img_20151119_152112
187	199	1	img_20151119_152133
188	200	1	img_20151119_152138
189	201	1	img_20151119_152102
190	202	1	img_20151119_155517
191	203	1	img_20151119_155523
192	204	1	img_20151119_155530
193	205	1	img_20151119_155555
194	206	1	img_20151119_155605
195	207	1	img_20151119_160643
196	208	1	img_20151119_160652
197	209	1	img_20151119_161406
198	210	1	img_20151119_161421
199	211	1	img_20151119_161426
200	212	1	img_20151119_161431
201	213	1	img_20151119_161449
202	214	1	img_20151119_193049
203	215	1	img_20151119_193751
204	216	1	img_20151119_193757
205	217	1	img_20151119_194218
206	218	1	img_20151119_194223
207	219	1	img_20151119_194533
208	220	1	img_20151119_194538
209	221	1	img_20151119_195228
210	222	1	img_20151119_195234
211	223	1	img_20151119_195223
212	224	1	img_20151119_195754
213	225	1	img_20151119_195759
214	226	1	img_20151119_195749
215	227	1	img_20151119_200424
216	228	1	img_20151119_200433
217	229	1	img_20151119_200418
218	230	1	img_20151119_201433
219	231	1	img_20151119_201504
220	232	1	img_20151119_201620
221	233	1	img_20151119_201348
222	234	1	img_20151119_201956
223	235	1	img_20151119_202002
224	236	1	img_20151119_202021
225	237	1	img_20151119_202027
226	238	1	img_20151119_202034
227	239	1	img_20151119_201951
228	240	1	img_20151122_203622
229	241	1	img_20151122_212611
230	242	1	img_20151122_212606
231	243	1	img_20151123_133116
232	244	1	img_20151123_133134
233	245	1	img_20151123_133214
234	246	1	img_20151123_133224
235	247	1	img_20151123_133230
236	248	1	img_20151123_133236
237	249	1	img_20151123_133101
238	250	1	img_20151123_145852
239	251	1	img_20151123_145858
240	252	1	img_20151123_145847
241	253	1	img_20151123_161302
242	254	1	img_20151123_181257
243	255	1	yamal
244	256	1	yamal
245	257	1	yamal
246	258	1	yamal
247	259	1	yamal
248	260	1	yamal
249	261	1	yamal
250	262	1	yamal
251	263	1	yamal
252	264	1	2015-10-24-428
253	265	1	yamal
254	266	1	2015-10-24-428
255	267	1	yamal
258	270	1	yamal
259	271	1	yamal
260	272	1	yamal
261	273	1	снимок экрана 2015-09-10 в 23.02.35
262	274	1	снимок экрана 2015-09-18 в 2.00.41
263	275	1	снимок экрана 2015-09-18 в 2.06.49
264	276	1	снимок экрана 2015-10-18 в 1.31.45
265	277	1	b-day
266	278	1	tlh-1jnorxk
267	279	1	k1evq-yyw-w
268	280	1	снимок экрана 2015-10-04 в 18.25.14
269	281	1	снимок экрана 2015-09-18 в 2.00.41
270	282	1	снимок экрана 2015-10-18 в 1.31.45
271	283	1	tlh-1jnorxk
272	284	1	снимок экрана 2015-09-10 в 23.02.35
273	285	1	снимок экрана 2015-10-18 в 1.31.45
274	286	1	снимок экрана 2015-10-18 в 1.31.45
275	287	1	снимок экрана 2015-10-18 в 1.31.45
276	288	1	снимок экрана 2015-10-18 в 1.31.45
277	289	1	back
278	290	1	back
279	291	1	back
280	292	1	back
281	293	1	back
282	294	1	back
283	295	1	bg1
284	296	1	bg1
285	297	1	bg1
286	298	1	bg1
287	299	1	forward
288	300	1	back
289	301	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
290	302	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
291	303	1	polar_mesospheric_clouds-other
292	304	1	img_20151128_162049
293	305	1	img_20151208_170422
294	306	1	img_20151208_170653
295	307	1	284
296	308	1	8
297	309	1	10
298	310	1	8
299	311	1	10
300	312	1	img_20151209_151755
301	313	1	img_20151209_191113
302	314	1	img_20151209_191120
303	315	1	img_20151209_191125
304	316	1	img_20151209_191130
305	317	1	img_20151209_191136
306	318	1	img_20151209_191141
307	319	1	img_20151209_191146
308	320	1	img_20151209_191200
309	321	1	img_20151209_191205
310	322	1	8
311	323	1	img_20151210_150432
312	324	1	8
313	325	1	img_20151214_141923
314	326	1	img_20151214_141928
315	327	1	img_20151214_141916
316	328	1	8
317	329	1	10
318	330	1	приложение б
319	331	1	приложение б
320	332	1	приложение б
321	333	1	приложение б
322	334	1	приложение б
323	335	1	приложение б
325	337	1	приложение б
326	338	1	приложение б
327	339	1	1.общая схема кц
328	340	1	1.общая схема кц
329	341	1	приложение б
330	342	1	приложение б
331	343	1	test_1
332	344	1	test_2
333	345	1	test_3
334	346	1	test_4
335	347	1	test_5
336	348	1	test_6pdf
337	349	1	test_7pdf
338	350	1	test_6_1pdf
339	351	1	кс-4 гтп_ книга 2 приложение в тсг
340	352	1	кс-4 гтп_ книга 2 приложение в тсг
341	353	1	приложение
342	354	1	приложение
343	355	1	поз.18 оси после 17
344	356	1	приложение 3 схема расположения сети гтм_2.1
345	357	1	приложение 3 схема расположения сети гтм_2.3
346	358	1	приложение 3 схема расположения сети гтм_2.5
347	359	1	приложение 3 схема расположения сети гтм_общая схема
348	360	1	приложение 4  конструкция термометрической скважины тс, l=10м
349	361	1	приложение 5  конструкция грунтового геодезического репера
350	362	1	приложение 6  конструкция и спецификация деформационной марки на оголовке сваи (тип б)
351	363	1	приложение 7   деформационная марка тип г
352	364	1	приложение б
353	365	1	приложение б л.1-5
354	366	1	приложение б л.6-53
355	367	1	приложение б. л.54-71
356	368	1	лист 1
357	369	1	лист 2
358	370	1	кс-4 гтп_ книга 2 приложение в тсг
359	371	1	кс-4 гтп_ книга 2 приложение а - копия
360	372	1	кс-4 гтп книга 2 приложение б
361	373	1	приложение
362	374	1	приложение
363	375	1	приложение а_лист 1
364	376	1	приложение а_лист 2
365	377	1	приложение а_лист 3
366	378	1	приложение а_лист 4
367	379	1	приложение а_лист 5
368	380	1	приложение а_лист 6
369	381	1	приложение а_лист 7
370	382	1	приложение а_лист 9
371	383	1	приложение а_лист 8
372	384	1	приложение 3 схема расположения сети гтм_2.1
373	385	1	а0_в
374	386	1	а4_в_t1
375	387	1	приложение а_лист 1_dwg
376	388	1	test_format_a4
377	389	1	test_format_a4
378	390	1	format_a4
379	391	1	а4_в_pdf4
380	392	1	а4_в_dwg5
382	394	1	ff9941ce-c9c4-433a-9f45-c43626f123a1
383	395	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
384	396	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
385	397	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
386	398	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
387	399	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
388	400	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
389	401	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
390	402	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
391	403	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
392	404	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
393	405	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
394	406	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
395	407	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
396	408	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
397	409	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
398	410	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
399	411	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
400	412	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
401	413	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
402	414	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
403	415	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
404	416	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
405	417	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
406	418	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
407	419	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
408	420	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
409	421	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
410	422	1	чертеж8
411	423	1	1a6c79a3-5876-483c-b1c5-728b51e5305a
412	424	1	1a6c79a3-5876-483c-b1c5-728b51e5305a
413	425	1	приложение а_лист 1_dwg
414	427	1	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4
415	428	1	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4
416	429	1	а4_в_test1
417	430	1	а4_в_test1
418	431	1	а4_в_test1
419	432	1	а4_в_test1_2
420	433	1	а4_в_test1_3
427	440	1	model_1pdf
428	441	1	model_1dwg
429	442	1	model_1pdf
430	443	1	model_1dwg
431	444	1	model_1pdf
433	446	1	model_1pdf
434	447	1	model_1dwg
435	448	1	model_1pdf
436	449	1	model_1pdf
437	450	1	model_1pdf
438	451	1	model_1dwg
535	548	1	a1_g_data_pdf
536	549	1	a1_g_data_dwg
537	550	1	a3x3_g_test_pdf
470	483	1	polar_mesospheric_clouds-other
471	484	1	nature-snow-trees-winter-2544954-1920x1200
472	485	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
473	486	1	nature-snow-trees-winter-2544954-1920x1200
474	487	1	polar_mesospheric_clouds-other
475	488	1	cb54c619700f4eb583152fb8451
476	489	1	bezyimyannyij-b80uvk
477	490	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
478	491	1	beautiful_stream-widescreen_wallpapers
479	492	1	bezyimyannyij-b80uvk
480	493	1	cb54c619700f4eb583152fb8451
481	494	1	beautiful_stream-widescreen_wallpapers
487	500	1	a1_g_841x594
488	501	1	a1_v_594x841
489	502	1	a1x2_594x1682_v
490	503	1	a1x2_g_841x1189
491	504	1	a1x3_g_1783x841
492	505	1	a2_g_594x420
493	506	1	a2_v_420x594
494	507	1	a2x3_1261x594
495	508	1	a2x3_v_594x1260
496	509	1	a3_v_297x420
497	510	1	a3x3_g_891x420
498	511	1	a3x4_g_1189x420
499	512	1	a3x5_g_1486x420
500	513	1	a3x6_g_1682x420
501	514	1	a4_v_210x297
502	515	1	a4x3_g_630x297
503	516	1	a4x6_g_1260x297
504	517	1	a4x8_g_1680x297
505	518	1	a1_g_841x594
506	519	1	a1_v_594x841
507	520	1	a1x2_594x1682_v
508	521	1	a1x2_g_841x1189
509	522	1	a1x3_g_1783x841
510	523	1	a2_g_594x420
511	524	1	a2_v_420x594
512	525	1	a2x3_1261x594
513	526	1	a2x3_v_594x1260
514	527	1	a3_v_297x420
515	528	1	a3x3_g_891x420
516	529	1	a3x4_g_1189x420
517	530	1	a3x5_g_1486x420
518	531	1	a3x6_g_1682x420
519	532	1	a4_v_210x297
520	533	1	a4x3_g_630x297
521	534	1	a4x6_g_1260x297
522	535	1	a4x8_g_1680x297
523	536	1	a1_g_test_pdf
524	537	1	a1_g_test_dwg
525	538	1	a3x6_test_pdf
526	539	1	a3x6_test_dwg
527	540	1	a2x3_v_pdf
528	541	1	a2x3_v_dwg
529	542	1	a1x2_g_pdf
530	543	1	a1x2_g_dwg
531	544	1	a1x2_g_pdf
532	545	1	a1x2_g_dwg_2
533	546	1	a1_g_data_pdf
534	547	1	a1_g_data_dwg
538	551	1	a3x3_g_test_dwg
539	552	1	тестовый_a3x5_g_pdf
540	553	1	тестовый_a3x5_g_dwg
541	554	1	a2_v_test_pdf
542	555	1	a2_v_test_dwg
543	556	1	525
544	557	1	525
545	558	1	тестовый_a3x5_g_pdf
546	559	1	a1_g_test_pdf
547	560	1	a3x3_g_test_pdf
548	561	1	a1x2_g_pdf
549	562	1	a2x3_v_pdf
550	563	1	тестовый_a3x5_g_pdf
551	564	1	undefinedtmp_img
773	786	1	огтм_куюмб-е м-е
774	787	1	undefinedtmp2
775	788	1	undefinedtmp_img
779	792	1	огтм_куюмб-е м-е
780	793	1	undefinedtmp2
557	570	1	a1_g_test_pdf
558	571	1	undefinedtmp_img
559	572	1	a2x3_v_pdf
560	573	1	undefinedtmp_img
561	574	1	a2_v_test_pdf
562	575	1	undefinedtmp_img
563	576	1	a2x3_v_pdf
564	577	1	undefinedtmp_img
781	794	1	undefinedtmp_img
785	798	1	111
786	799	1	undefinedtmp2
787	800	1	undefinedtmp_img
791	804	1	куюмб огтм_цпс
792	805	1	undefinedtmp2
793	806	1	undefinedtmp_img
794	807	1	схема
795	808	1	undefinedtmp2
574	587	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
575	588	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
576	589	1	735154_utrenniy_tuman_v_lesu
577	590	1	beautiful_stream-widescreen_wallpapers
578	591	1	bezyimyannyij-b80uvk
579	592	1	cb54c619700f4eb583152fb8451
580	593	1	nature-snow-trees-winter-2544954-1920x1200
581	594	1	bezyimyannyij-b80uvk
582	595	1	cb54c619700f4eb583152fb8451
796	809	1	undefinedtmp_img
800	813	1	1
801	814	1	undefinedtmp2
583	596	1	nature-snow-trees-winter-2544954-1920x1200
584	597	1	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)
585	598	1	735154_utrenniy_tuman_v_lesu
586	599	1	beautiful_stream-widescreen_wallpapers
587	600	1	bezyimyannyij-b80uvk
588	601	1	cb54c619700f4eb583152fb8451
589	602	1	nature-snow-trees-winter-2544954-1920x1200
590	603	1	polar_mesospheric_clouds-other
591	604	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
592	605	1	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)
593	606	1	735154_utrenniy_tuman_v_lesu
594	607	1	beautiful_stream-widescreen_wallpapers
595	608	1	bezyimyannyij-b80uvk
596	609	1	cb54c619700f4eb583152fb8451
597	610	1	nature-snow-trees-winter-2544954-1920x1200
598	611	1	polar_mesospheric_clouds-other
599	612	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
600	613	1	cb54c619700f4eb583152fb8451
601	614	1	nature-snow-trees-winter-2544954-1920x1200
602	615	1	polar_mesospheric_clouds-other
603	616	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
604	617	1	test_7pdf
605	618	1	test_7pdf
606	619	1	test_7pdf
607	620	1	test_7pdf
608	621	1	test_7pdf
609	622	1	test_7pdf
610	623	1	test_7pdf
611	624	1	test_7pdf
612	625	1	test_7pdf
613	626	1	test_7pdf
614	627	1	test_7pdf
615	628	1	undefinedtmp2
616	629	1	undefinedtmp_img
617	630	1	a1_g_test_pdf
618	631	1	undefinedtmp2
619	632	1	undefinedtmp_img
620	633	1	снимок экрана 2016-02-11 в 17.18.15
621	634	1	undefinedtmp2
622	635	1	undefinedtmp_img
623	636	1	снимок экрана 2016-02-11 в 17.18.15
624	637	1	undefinedtmp2
625	638	1	undefinedtmp_img
626	639	1	a3x6_test_pdf
627	640	1	undefinedtmp2
628	641	1	undefinedtmp_img
629	642	1	a3x6_test_pdf
630	643	1	undefinedtmp2
631	644	1	undefinedtmp_img
632	645	1	тестовый_a3x5_g_pdf
633	646	1	undefinedtmp2
634	647	1	undefinedtmp_img
635	648	1	a3x3_g_test_pdf
636	649	1	undefinedtmp2
637	650	1	undefinedtmp_img
638	651	1	a2_v_test_pdf
639	652	1	undefinedtmp2
640	653	1	undefinedtmp_img
641	654	1	a2x3_v_pdf
642	655	1	undefinedtmp2
643	656	1	undefinedtmp_img
644	657	1	a1x2_g_pdf
645	658	1	undefinedtmp2
646	659	1	undefinedtmp_img
647	660	1	a1x2_g_pdf
648	661	1	undefinedtmp2
649	662	1	undefinedtmp_img
650	663	1	523_кс-2ярынская
651	664	1	undefinedtmp2
652	665	1	undefinedtmp_img
653	666	1	523_кс-2ярынская
654	667	1	поз. 1.3
655	668	1	undefinedtmp2
656	669	1	undefinedtmp_img
657	670	1	a0_v
658	671	1	a0_v
659	672	1	a1_h
660	673	1	a1_h
661	674	1	a1_v
662	675	1	a1_v
663	676	1	a1x3_h
664	677	1	a1x3_h
665	678	1	a2_h
666	679	1	a2_h
667	680	1	a2_v
668	681	1	a2_v
669	682	1	a2×4_v
670	683	1	a2×4_v
671	684	1	a2x3_h
672	685	1	a2x3_h
673	686	1	a2x3_v
674	687	1	a2x3_v
675	688	1	a3_h
676	689	1	a3_h
677	690	1	a3_v
678	691	1	a3_v
679	692	1	a3x3_h
680	693	1	a3x3_h
681	694	1	a3x4_h
682	695	1	a3x4_h
683	696	1	a3x5_h
684	697	1	a3x5_h
685	698	1	a3x6_h
686	699	1	a3x6_h
687	700	1	a4_v
688	701	1	a4_v
689	702	1	a4x3_h
690	703	1	a4x3_h
691	704	1	a4x6_h
692	705	1	a4x6_h
693	706	1	a4x8_h
694	707	1	a4x8_h
695	708	1	small_pdf
696	709	1	undefinedtmp2
697	710	1	undefinedtmp_img
698	711	1	small_pdf
699	712	1	undefinedtmp2
700	713	1	undefinedtmp_img
701	714	1	small_pdf
702	715	1	undefinedtmp2
703	716	1	undefinedtmp_img
704	717	1	small_pdf
705	718	1	undefinedtmp2
706	719	1	undefinedtmp_img
707	720	1	small_pdf
708	721	1	undefinedtmp2
709	722	1	undefinedtmp_img
710	723	1	small_pdf
711	724	1	undefinedtmp2
712	725	1	undefinedtmp_img
713	726	1	small_pdf
714	727	1	undefinedtmp2
715	728	1	undefinedtmp_img
716	729	1	small_pdf
717	730	1	undefinedtmp2
718	731	1	undefinedtmp_img
719	732	1	small_pdf
720	733	1	undefinedtmp2
721	734	1	undefinedtmp_img
722	735	1	small_pdf
723	736	1	undefinedtmp2
724	737	1	undefinedtmp_img
725	738	1	small_pdf
726	739	1	undefinedtmp2
727	740	1	undefinedtmp_img
728	741	1	small_pdf
729	742	1	undefinedtmp2
730	743	1	undefinedtmp_img
731	744	1	small_pdf
732	745	1	undefinedtmp2
733	746	1	undefinedtmp_img
734	747	1	small_pdf
735	748	1	undefinedtmp2
736	749	1	undefinedtmp_img
737	750	1	small_pdf
738	751	1	undefinedtmp2
739	752	1	undefinedtmp_img
740	753	1	small_pdf
741	754	1	undefinedtmp2
742	755	1	undefinedtmp_img
743	756	1	small_pdf
744	757	1	undefinedtmp2
745	758	1	undefinedtmp_img
746	759	1	small_pdf
747	760	1	undefinedtmp2
748	761	1	undefinedtmp_img
749	762	1	small_pdf
750	763	1	undefinedtmp2
751	764	1	undefinedtmp_img
752	765	1	small_pdf
753	766	1	undefinedtmp2
754	767	1	undefinedtmp_img
755	768	1	small_pdf
756	769	1	undefinedtmp2
757	770	1	undefinedtmp_img
758	771	1	small_pdf
759	772	1	undefinedtmp2
760	773	1	undefinedtmp_img
761	774	1	small_pdf
762	775	1	undefinedtmp2
763	776	1	undefinedtmp_img
764	777	1	small_pdf
765	778	1	undefinedtmp2
766	779	1	undefinedtmp_img
767	780	1	small_pdf
768	781	1	undefinedtmp2
769	782	1	undefinedtmp_img
770	783	1	small_pdf
771	784	1	undefinedtmp2
772	785	1	undefinedtmp_img
776	789	1	14_факел_поз 9.1-model
777	790	1	undefinedtmp2
778	791	1	undefinedtmp_img
782	795	1	огтм_куюмб-е м-е
783	796	1	undefinedtmp2
784	797	1	undefinedtmp_img
788	801	1	огтм_
789	802	1	undefinedtmp2
790	803	1	undefinedtmp_img
797	810	1	схема2
798	811	1	undefinedtmp2
799	812	1	undefinedtmp_img
802	815	1	undefinedtmp_img
803	816	1	2
804	817	1	undefinedtmp2
805	818	1	undefinedtmp_img
806	819	1	каталог
807	820	1	undefinedtmp2
808	821	1	undefinedtmp_img
809	822	1	img_20170125_112006
810	823	1	img_20170125_112649
811	824	1	img_20170125_112953
812	825	1	img_20170125_113352
813	826	1	img_20170125_134810
814	827	1	13_рез-дм-на-люк_бб_поз 8.1_8.2-model
815	828	1	undefinedtmp2
816	829	1	undefinedtmp_img
817	830	1	45_рез на 2 ростверках_поз 52.2.3-model
818	831	1	undefinedtmp2
819	832	1	undefinedtmp_img
820	833	1	1487172594912
821	834	1	тестовый генплан 31 куст
822	835	1	undefinedtmp2
823	836	1	undefinedtmp_img
824	837	1	тест_поз.8
825	838	1	undefinedtmp2
826	839	1	undefinedtmp_img
\.


--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfiles_l10n_id_seq', 826, true);


--
-- Name: tfiles_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfiles_ordering_seq', 839, true);


--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tfmeasurement_periods_id_seq', 110, true);


--
-- Data for Name: tforms; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tforms (id, code, name, fields_not_null, func_error, func_ok, mail_template1_id, mail_template2_id) FROM stdin;
\.


--
-- Name: tforms_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tforms_id_seq', 1, false);


--
-- Data for Name: tguestbook_messages; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tguestbook_messages (id, guestbook_id, user_q_name, user_q_phone, user_q_email, user_q_avatar_id, user_a_id, question, answer, date_question, date_answer, moderated) FROM stdin;
\.


--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tguestbook_messages_id_seq', 1, false);


--
-- Data for Name: tguestbooks; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tguestbooks (id, code, name, premoderated, users_can_post, mail_template1_id, mail_template2_id) FROM stdin;
\.


--
-- Name: tguestbooks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tguestbooks_id_seq', 1, false);


--
-- Data for Name: tkvcache; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tkvcache (id, key, value) FROM stdin;
\.


--
-- Name: tkvcache_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tkvcache_id_seq', 1, false);


--
-- Data for Name: tl10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tl10n (id, code, name, is_default) FROM stdin;
1	ru	Русский	1
\.


--
-- Name: tl10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tl10n_id_seq', 1, true);


--
-- Data for Name: tlogin_attempts; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tlogin_attempts (id, login, password, date_cr, user_ip, user_agent_id, url, ok) FROM stdin;
\.


--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tlogin_attempts_id_seq', 1, false);


--
-- Data for Name: tmail_templates; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmail_templates (id, code, name, default_from, default_to, signature) FROM stdin;
1	test	test	robot@erp-gtm.relsyst.ru	\N	\N
\.


--
-- Name: tmail_templates_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmail_templates_id_seq', 1, true);


--
-- Data for Name: tmail_templates_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmail_templates_l10n (id, fid_id, l10n_id, subject, body) FROM stdin;
1	1	1	Hello world	<p>Ура уии уии ;)</p>\n<p><span>Ура уии уии ;)</span></p>\n<p><span><span>Ура уии уии ;)</span></span></p>\n<p><span><span></span></span></p>
\.


--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmail_templates_l10n_id_seq', 1, true);


--
-- Data for Name: tmarket_categories; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_categories (id, code, parent_id, image1_id, image2_id, enabled, ordering, fid, is_featured, is_new, is_recomended, has_abstract, has_body2) FROM stdin;
\.


--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_id_seq', 1, false);


--
-- Data for Name: tmarket_categories_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_categories_l10n (id, fid_id, l10n_id, name, abstract, body, body2, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_l10n_id_seq', 1, false);


--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_ordering_seq', 1, false);


--
-- Data for Name: tmarket_field_datatypes; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_field_datatypes (id, code, view_code, name, prefix, crsql, has_l10n, has_enum) FROM stdin;
1	integer	range	Целое число	i	integer	0	0
2	float	range	Дробное число	f	float	0	0
3	string	\N	Строка	s	varchar(2000)	0	0
4	lstring	\N	Локализованная строка	sl	varchar(2000)	1	0
5	enum	checkbox	Одно из перечисленных значений	i	integer	0	1
6	lenum	checkbox	Одно из локализованных перечисленных значений	i	integer	1	1
7	enums	checkbox	Несколько из перечисленных значений	\N	\N	0	1
8	lenums	checkbox	Несколько из локализованных перечисленных значений	\N	\N	1	1
\.


--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_datatypes_id_seq', 8, true);


--
-- Data for Name: tmarket_field_enums; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_field_enums (id, field_id, value) FROM stdin;
\.


--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_enums_id_seq', 1, false);


--
-- Data for Name: tmarket_field_enumsl; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_field_enumsl (id, field_id, l10n_id, value) FROM stdin;
\.


--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_enumsl_id_seq', 1, false);


--
-- Data for Name: tmarket_field_groups; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_field_groups (id, ordering, enabled, category_id) FROM stdin;
\.


--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_id_seq', 1, false);


--
-- Data for Name: tmarket_field_groups_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_field_groups_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_l10n_id_seq', 1, false);


--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_ordering_seq', 1, false);


--
-- Data for Name: tmarket_fields; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_fields (id, group_id, datatype_id, view_level_id, search_level_id, enabled, ordering, cid, fid) FROM stdin;
\.


--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_id_seq', 1, false);


--
-- Data for Name: tmarket_fields_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_fields_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_l10n_id_seq', 1, false);


--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_ordering_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_enums; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_enums (id, item_id, field_id, enum_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_enums_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_enumsl; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_enumsl (id, item_id, field_id, enum_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_enumsl_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_f; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_f (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_f_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_i; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_i (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_i_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_il; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_il (id, item_id, fid_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_il_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_s; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_s (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_s_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_sl; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_fields_sl (id, item_id, fid_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_sl_id_seq', 1, false);


--
-- Data for Name: tmarket_item_groups; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_groups (id, enabled, ordering) FROM stdin;
\.


--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_id_seq', 1, false);


--
-- Data for Name: tmarket_item_groups_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_item_groups_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_l10n_id_seq', 1, false);


--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_ordering_seq', 1, false);


--
-- Data for Name: tmarket_items; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_items (id, code, date_cr, image1_id, image2_id, group_id, category_id, manufacturer_id, enabled, in_stock, price, ordering, is_featured, is_new, is_recomended, fid, fid2, file_folder_id, old_price, base_price, discount_value, in_stock_count) FROM stdin;
\.


--
-- Name: tmarket_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_id_seq', 1, false);


--
-- Data for Name: tmarket_items_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_items_l10n (id, fid_id, l10n_id, name, abstract, body, body2) FROM stdin;
\.


--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_l10n_id_seq', 1, false);


--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_ordering_seq', 1, false);


--
-- Data for Name: tmarket_manufacturers; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_manufacturers (id, code, image1_id, image2_id, enabled, ordering, fid, is_featured, is_new, is_recomended) FROM stdin;
\.


--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_id_seq', 1, false);


--
-- Data for Name: tmarket_manufacturers_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_manufacturers_l10n (id, fid_id, l10n_id, name, abstract, body, body2, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_l10n_id_seq', 1, false);


--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_ordering_seq', 1, false);


--
-- Data for Name: tmarket_search_levels; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_search_levels (id, code) FROM stdin;
1	no
2	basic
3	short
4	advanced
5	full
\.


--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_search_levels_id_seq', 5, true);


--
-- Data for Name: tmarket_search_levels_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_search_levels_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Не показывать
2	2	1	Простой режим
3	3	1	Краткий режим
4	4	1	Расширенный режим
5	5	1	Полный режим
\.


--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_search_levels_l10n_id_seq', 5, true);


--
-- Data for Name: tmarket_view_levels; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_view_levels (id, code) FROM stdin;
1	no
2	list
3	short
4	full
\.


--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_view_levels_id_seq', 4, true);


--
-- Data for Name: tmarket_view_levels_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmarket_view_levels_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Не показывать
2	2	1	В списке
3	3	1	Краткий вариант
4	4	1	Полный вариант
\.


--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmarket_view_levels_l10n_id_seq', 4, true);


--
-- Data for Name: tmeasurement_modes; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmeasurement_modes (id, name) FROM stdin;
1	Ручной
2	Автоматический
\.


--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmeasurement_modes_id_seq', 2, true);


--
-- Data for Name: tmeasurement_periods; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmeasurement_periods (id, facility_id, sensor_model_id, value) FROM stdin;
\.


--
-- Data for Name: tmeasurer_value_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmeasurer_value_types (id, code, name) FROM stdin;
5	height	мм
2	temperature	°C
6	grad	°
7	level	м
\.


--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmeasurer_value_types_id_seq', 7, true);


--
-- Data for Name: tmediums; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tmediums (id, code, ordering, name) FROM stdin;
1	desktop	1	Десктоп
2	mobile	2	Мобильный
\.


--
-- Name: tmediums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmediums_id_seq', 2, true);


--
-- Name: tmediums_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tmediums_ordering_seq', 2, true);


--
-- Data for Name: tnormative_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tnormative_types (id, name) FROM stdin;
13	Высота подошвы отсыпки 
12	Максимальная допустимая температура
11	Допустимая величина деформации
\.


--
-- Data for Name: tnormatives; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tnormatives (id, facility_id, type_id, value) FROM stdin;
\.


--
-- Name: tnormatives_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tnormatives_id_seq', 13, true);


--
-- Name: tnormatives_id_seq1; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tnormatives_id_seq1', 24, true);


--
-- Data for Name: tpage_blocks; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tpage_blocks (id, page_id, l10n_id, place_id, medium_id, body) FROM stdin;
4	1	1	1	1	\N
7	12	1	1	1	dashboard
3	17	1	1	1	reference
6	8	1	1	1	analytics
1	15	1	1	1	users
2	16	1	1	1	plans
\.


--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpage_blocks_id_seq', 7, true);


--
-- Data for Name: tpages; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tpages (id, parent_id, alias, template_id, prerun, prerun_param, show_in_nav, ordering, role_id, hide_anon, hide_reg, cssclass) FROM stdin;
1	\N	/index/	4	\N	\N	0	1	\N	1	0	\N
12	\N	/dashboard/	4	\N	\N	1	14	\N	1	0	\N
17	\N	/reference/	4	\N	\N	1	17	\N	0	0	\N
8	\N	/analytics/	4	Analytics	\N	1	15	12	0	0	\N
15	\N	/users/	4	\N	\N	1	16	10	0	0	\N
16	\N	/plans/	4	GTM	\N	1	13	13	0	0	\N
\.


--
-- Name: tpages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpages_id_seq', 17, true);


--
-- Data for Name: tpages_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tpages_l10n (id, fid_id, l10n_id, name, title, meta_description, meta_keywords, disabled_l10n) FROM stdin;
1	1	1	Главная	\N	\N	\N	0
12	12	1	Рабочая панель	\N	\N	\N	0
17	17	1	Справка	\N	\N	\N	0
8	8	1	Аналитика	\N	\N	\N	0
15	15	1	Пользователи	\N	\N	\N	0
16	16	1	Чертежи	\N	\N	\N	0
\.


--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpages_l10n_id_seq', 17, true);


--
-- Name: tpages_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpages_ordering_seq', 17, true);


--
-- Data for Name: tpayment_service_errors; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tpayment_service_errors (id, psi_id, amount, error, pay_remote_addr, pay_user_agent_id, pay_data) FROM stdin;
\.


--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpayment_service_errors_id_seq', 1, false);


--
-- Data for Name: tpayment_service_invoices; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tpayment_service_invoices (id, date_cr, date_pay, ask_remote_addr, ask_user_agent_id, amount, user_id, module_name, module_fid, module_data, redirect, payed, service_name, service_data, pay_remote_addr, pay_user_agent_id, pay_data) FROM stdin;
\.


--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tpayment_service_invoices_id_seq', 1, false);


--
-- Data for Name: tplan_formats; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tplan_formats (id, name, width, height, dwg_id, pdf_id, explication_data) FROM stdin;
13	A1x3_H	1783	841	676	677	{"size":0.7,"x":4517,"y":2216}
14	A2_H	594	420	678	679	{"size":0.7,"x":1145,"y":1021}
16	A2_V	420	594	680	681	{"size":0.7,"x":652,"y":1514}
17	A2x3_H	1261	594	684	685	{"size":0.7,"x":3036,"y":1515}
19	A3_V	297	420	690	691	{"size":0.7,"x":302,"y":1021}
20	A3x3_H	892	420	692	693	{"size":0.65,"x":1986,"y":1021}
21	A3x4_H	1189	420	694	695	{"size":0.7,"x":2832,"y":1021}
22	A3x5_H	1487	420	696	697	{"size":0.7,"x":3673,"y":1021}
23	A3x6_H	1682	420	698	699	{"size":0.7,"x":4228,"y":1021}
24	A4_V	210	297	700	701	{"size":0.7,"x":56,"y":672}
25	A4x3_H	631	297	702	703	{"size":0.7,"x":1246,"y":672}
26	A4x6_H	1261	297	704	705	{"size":0.7,"x":3033,"y":672}
27	A4x8_G	1682	297	706	707	{"size":0.7,"x":4224,"y":672}
28	A2x3_V	594	1261	686	687	{"size":0.7,"x":1145,"y":3406}
9	A1_H	841	594	672	673	{"size":0.7,"x":1845,"y":1514}
12	A0_V	841	1189	670	671	{"size":0.7,"x":1844,"y":3200}
18	A2x3_V	594	1260	686	687	{"size":0.7,"x":1144,"y":3404}
10	A1_V	594	841	674	675	{"size":0.7,"x":1144,"y":2215}
11	A2×4_V	594	1682	682	683	{"size":0.7,"x":1144,"y":4599}
\.


--
-- Name: tplan_formats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tplan_formats_id_seq', 28, true);


--
-- Data for Name: tplans; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tplans (id, name, dwg_id, pdf_id, jpg_id, format_id, view_data, width, height, status, urn, urn_encoded, log, calc_pdf_id, deleted) FROM stdin;
66	Поз.9.1_Совмещенная факельная установка h=50м	\N	789	791	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	790	\N
71	ЦПС	\N	804	806	12	\N	\N	\N	Ошибка загрузки	\N	\N	\N	805	\N
73	Переход Б Хета_Схема	\N	810	812	9	\N	\N	\N	Ошибка загрузки	\N	\N	\N	811	\N
74	Б_Хета_лист 3	\N	813	815	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	814	\N
75	Б Хета_лист 4	\N	816	818	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	817	\N
76	Б Хета_каталог координат	\N	819	821	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	820	\N
77	Поз.8.1 Система измер-я кол-ва нефти	\N	827	829	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	828	\N
78	Поз. 52.2 Пл-ка дрен емк-ти	\N	830	832	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	831	\N
65	ЦПС_ОГТМ	\N	786	788	9	\N	\N	\N	Ошибка загрузки	\N	\N	\N	787	1
79	Куст скважин №31_ОГТМ	\N	834	836	9	\N	\N	\N	Ошибка загрузки	\N	\N	\N	835	\N
80	Куст 31_Поз. 8	\N	837	839	14	\N	\N	\N	Ошибка загрузки	\N	\N	\N	838	\N
\.


--
-- Name: tplans_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tplans_id_seq', 80, true);


--
-- Data for Name: treferences; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY treferences (id, parent_id, name, body, ordering, enabled) FROM stdin;
64	63	Введение и основные термины	<p>ИАС ГТМ &laquo;Ямал&raquo; - программный комплекс, предназначенный для ручного контроля и обработки данных измерений, проведенных с использованием элементов сети геотехнического мониторинга (далее <strong>элементов</strong>) разных типов на местности (в дальнейшем - <strong>объекте</strong>).</p>\n<p><strong>Объект</strong> представлен в виде <strong>чертежа</strong> в формате pdf. На объекте присутствуют сооружения или участки (в дальнейшем - <strong>подобъекты</strong>) с относящимися к ним отдельными pdf-чертежами.</p>\n<p>Элементы имеют координатную привязку на pdf-чертеже к объекту или подобъекту. По каждому из элементов система позволяет вести замеры <strong>значений</strong>.</p>\n<p>В дальнейшем, система позволяет сравнивать произведенные замеры с допустимыми отклонениями &ndash; <strong>нормативами</strong>, указанными отдельно для каждого объекта, и, при необходимости, сигнализировать об их превышении.</p>\n<p>Также система позволяет:</p>\n<p>- генерировать итоговый pdf-чертеж для объекта с нанесенными на него <strong>штампом</strong>, <strong>экспликацией</strong>, <strong>условными обозначениями</strong> и элементами;</p>\n<p>- производить анализ (в дальнейшем &ndash; <strong>аналитика)</strong> полученных при замерах значений - выполнять экспорт графиков и таблиц.</p>\n<p>&nbsp;</p>\n<p>Комплекс предусматривает возможность одновременного использования различными <strong>пользователями</strong> с задаваемыми определенными <strong>правами</strong>.</p>	64	1
65	63	Пользователи	<p>Пользователем является учетная запись, позволяющая работать с системой. Пользователь имеет <strong>имя</strong> для идентификации в системе, а также <strong>login</strong> и <strong>password</strong> для авторизации в системе.</p>\n<p>У каждого пользователя есть права. Изначально система администрируется одним super-пользователем, который не отображен в списке пользователей в соответствующем разделе программы и имеет имя, определенное при оформлении заявки на активацию системы, а также login и password, высылаемые на почту после оформления заявки.</p>\n<p>Super-пользователь имеет все возможные права, такие как:</p>\n<p><em>- Редактирование</em> - редактирование объектов и чертежей, добавление и удаление элементов;</p>\n<p>- <em>Ввод данных </em>- ввод замеров датчиков;</p>\n<p><em>- Аналитика - </em>просмотр аналитических сведений и построение графиков;</p>\n<p><em>- Создание пользователей</em> - администрирование пользователей в системе.</p>	65	1
66	63	Объекты	<p><strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong>Объектами являются территории строительства, площадки, сооружения или их части в рамках проектирования и эксплуатации сетей геотехнического мониторинга. Объекты представлены, в первую очередь, в виде загружаемых чертежей.</p>\n<p>Объект может содержать дочерний объект, именуемый подобъектом. Данная иерархия имеет следующее графическое представление в системе: каждый подобъект имеет родителя и отображен на нем в виде определенной позиции на чертеже (или в виде полигональной области). Корневые объекты без родителя могут называться <strong>площадками</strong>.</p>\n<p>Помимо подобъектов на объекте могут находиться элементы сети ГТМ. Для компоновки массивов элементов предусмотрены группы, упрощающие фильтрацию элементов при отображении на чертеже и при выводе табличных значений. Всякий объект обладает свойствами, которые условно можно разделить на 4 секции:</p>\n<p>1) <em>Основные параметры</em> - наименование объекта, чертежи родительский объект, если таковой существует.</p>\n<p>2) <em>Параметры отображения карты</em> - показывать/не показывать экспликацию и условные обозначения при просмотре и при генерации конечного чертежа, масштаб отображения элементов.</p>\n<p>3) <em>Косвенные параметры</em> - статичные данные, не влияющие на функционал системы, такие как &laquo;состояние объекта&raquo;, &laquo;тип объекта&raquo;, &laquo;тип фундамента&raquo;, &laquo;инженерная защита&raquo; и &laquo;несущая способность&raquo;. Данные параметры не проходят валидацию.</p>\n<p>4) <em>Нормативные параметры</em> - параметры объекта влияющие на сигнализацию значений для элементов сети.</p>\n<p>Также, к каждому объекту относятся данные, выводимые в штампе конечного pdf-чертежа, комментарии и фотографии.</p>	66	1
68	63	Элементы	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Под &laquo;<strong>элементами&raquo;</strong> подразумеваются элементы сети геотехнического мониторинга, расположенные на объектах. Элементы строго привязаны по координатам, и, в отличие от подобъектов, не могут иметь областей. Элементы могут быть разных видов (скважины, марки, датчики), а также разных конструкций для каждого вида (например, может быть несколько конструкций деформационной марки).</p>\n<p>Для каждого вида элемента и конструкции есть своя область значений и принцип сигнализации (на основе отклонений от нормативного параметра - предельно допустимых значений) в таблице данных, указанной для объекта, к которому принадлежит элемент.</p>\n<p>Некоторые элементы могут являться ретрансляторами.</p>\n<p>Помимо значений, назначаемых для элементов, некоторые элементы могут иметь целые ряды значений, если речь идет об элементах, использующих косы (например, термометрические скважины). Значениями кос всегда являются замеры температур (&deg;C) по глубине, с точностью до 4 знаков после запятой. То есть, в табличном отображении, одна коса представляет собой несколько пар значений глубина-температура. Для одного элемента на одну дату возможно указание только одной косы. Значения кос сигнализируются в случае, если:</p>\n<p>1) У объекта указан I принцип использования грунтов и среднее значение температуры от глубины фундамента до глубины косы превышает максимально допустимые показатели.</p>\n<p>2) У объекта указан II принцип использования грунтов и одно из значений температур, лежащих на глубине ниже сезонно-мерзлого слоя (СМС), ниже нуля.</p>\n<p>В обоих случаях сигнализируется вся коса. Принцип использования грунтов, максимально допустимая температура и мощность СТС\\СМС являются нормативными параметрами объекта.</p>	68	1
69	63	Виды элементов и варианты конcтрукций	<p><em>Грунтовый геодезический репер (РП)</em></p>\n<p><strong>Конструкции</strong>: нет</p>\n<p><strong>Наличие косы</strong>: нет</p>\n<p><strong>Измеряемая величина</strong>: Высота (мм), точность измерений до 4 знаков после запятой</p>\n<p><strong>Сигнализация данных</strong>: значения элемента сигнализируется при неравенстве текущего значения предыдущему - для грунтовых реперов подвижка должна равняться 0 мм.</p>\n<p><strong>Может ли быть ретранслятором</strong>: да</p>\n<p>&nbsp;</p>\n<p><em>Деформационная марка (ДМ)</em></p>\n<p><strong>Конструкции</strong>: нанесенная краской, наварная, забетонированная, с инклинометром</p>\n<p><strong>Наличие косы</strong>: нет</p>\n<p><strong>Измеряемая величина</strong>: для нанесенных краской, забетонированных и наварных ДМ измеряется <em>высота</em> (мм) с точностью измерений до 4 знаков после запятой; для конструкций с инклинометром измеряется два показателя <em>угла (в градусах)</em>, с точностью измерений до 4 знаков после запятой</p>\n<p><strong>Сигнализация данных</strong>: для нанесенных краской, забетонированных и наварных ДМ задается реперный замер (с указанием даты ввода реперного значения), и, далее - разница между реперным замером и каждым вводимым значением сравнивается с нормативным параметром объекта &laquo;допустимая величина деформации&raquo;. Для ДМ с инклинометром сигнализация отсутствует.</p>\n<p><strong>Может ли быть ретранслятором</strong>: для нанесенных краской ДМ &ndash; нет; для наварных, забетонированных, с инклинометром - да</p>\n<p>&nbsp;</p>\n<p><em>Грунтовая деформационная марка (ГДМ)</em></p>\n<p><strong>Конструкции</strong>: обычная, с инклинометром</p>\n<p><strong>Наличие косы</strong>: да</p>\n<p><strong>Измеряемая величина</strong>: для обычной ГДМ измеряется <em>высота</em> (мм), точность измерений до 4 знаков после запятой; для конструкций с инклинометром измеряется два показателя <em>угла</em> (&deg;) с точностью измерений до 4 знаков после запятой</p>\n<p><strong>Сигнализация данных</strong>: отсутствует</p>\n<p><strong>Может ли быть ретранслятором</strong>: обычная ГДМ &ndash; нет, с инклинометром - да</p>\n<p>&nbsp;</p>\n<p><em>Пьезометрическая скважина (ПС)</em></p>\n<p><strong>Конструкции</strong>: - нет</p>\n<p><strong>Наличие косы</strong>: нет</p>\n<p><strong>Измеряемая величина</strong>: УГВ - уровень грунтовых вод (м), точность измерений до 2 знаков после запятой</p>\n<p><strong>Сигнализация данных</strong>: сигнализируются значения, превышающие параметр объекта &laquo;мощность отсыпки&raquo;</p>\n<p><strong>Может ли быть ретранслятором</strong>: нет</p>\n<p>&nbsp;</p>\n<p><em>Термометрическая скважина (ТС)</em></p>\n<p><strong>Конструкции</strong>: вертикальная\\горизонтальная; со стационарной термокосой, без стационарной термокосы</p>\n<p><strong>Наличие косы</strong>: да</p>\n<p><strong>Измеряемая величина</strong>: температура грунта</p>\n<p><strong>Сигнализация данных</strong>: сигнализируются значения, превышающие параметр &laquo;расчетная температура грунта основания&raquo;</p>\n<p><strong>Может ли быть ретранслятором</strong>: да</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Каждый элемент может иметь статус состояния: &laquo;Рабочее&raquo;, &laquo;Поврежден&raquo;, &laquo;Не смонтирован&raquo;, &laquo;Не оборудован&raquo;, &laquo;Недоступен&raquo;, &laquo;Демонтирован&raquo;. На карте каждый элемент имеет вид и цвет, соответствующий своему статусу. На рисунке 2.1 представлена таблица визуализации элементов.</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.1 Визуализация элементов сети ГТМ в зависимости от статуса состояния</p>	69	1
71	63	Общий вид системы	<p>Рисунок 2.2 Общий вид личного кабинета. 1 - Логирующая зона - отвечает за отображение оповещений о текущих действиях. Анимация логирующей зоны предполагает незавершенный процесс. 2 - Секционное меню - содержит переходы на соответствующие разделы. Также здесь отображается имя пользователя для его идентификации и ссылка выхода из системы. 3 - Боковая панель - функциональная область, на которой отображаются списки сущностей или формы редактирования, в зависимости от выбранного раздела и текущего действия. 4 - Рабочая область, которая отображает основной функционал выбранного раздела.</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Для редактирования информации или ее просмотра используются всплывающие окна (рис. 2.3). Такие окна закрываются нажатием на крестик в правом верхнем углу окна или же по нажатию клавиши Esc. Всплывающие окна используются при:</p>\n<p>- создании/редактировании объектов;</p>\n<p>- создании/редактировании элементов;</p>\n<p>- создании/редактировании групп;</p>\n<p>-добавлении/просмотре фотографий и комментариев для объектов и элементов;</p>\n<p>- импорте/экспорте результатов замеров;</p>\n<p>- просмотре истории объекта;</p>\n<p>- заполнении штампа чертежей;</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.3 Вид всплывающего окна с редактированием элемента</p>	71	1
72	63	Пользователи	<p><strong><em></em></strong></p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Раздел &laquo;Пользователи&raquo; (рис. 2.4, 2.5) служит для создания и редактирования пользователей системы. Боковая панель раздела содержит список добавленных в систему пользователей. В рабочей области расположены форма создания (добавления) пользователя (если пользователь не выбран) и форма редактирования пользователя (если существующий пользователь выбран пользователь из списка).</p>\n<p>Рисунок 2.4 Создание нового пользователя</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.5 Редактирование пользователя</p>	72	1
73	63	Работа с чертежами	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; В разделе &laquo;Чертежи&raquo; (рис. 2.6, 2.7) создаются новые и просматриваются уже добавленные чертежи. Боковая панель раздела содержит список добавленных в систему чертежей. В рабочей области расположена форма добавления (если чертеж не выбран) или блок отображения уже загруженного чертежа с предпросмотром и кнопкой &laquo;Удалить чертеж&raquo;.</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.6 Добавление нового чертежа</p>\n<p>Рисунок 2.7 Просмотр добавленного чертежа</p>	73	1
75	63	Раздел «Аналитика»	<p>Раздел &laquo;Аналитика&raquo; (рис. 2.12, 2.13, 2.14) служит для вывода статистики по объектам, а также для вывода графиков на основе табличных значений, введенных в панели управления или в приложении.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Боковая панель (при входе в раздел, без выбора объектов) содержит иерархический список объектов системы. Также здесь находится кнопка вывода статистики, которая выводится на рабочую область. При выборе какого-либо объекта боковая панель меняется на блок настроек вывода &laquo;Аналитики&raquo; с фильтрацией элементов.</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.12 Раздел &laquo;Аналитика&raquo; (объект не выбран)</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.13 Раздел &laquo;Аналитика&raquo;. Вывод статистики</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.14 Раздел &laquo;Аналитика&raquo;. Вывод графиков</p>	75	1
79	78	Создание пользователя	<p>Для создания пользователя необходимо перейти в раздел &laquo;Пользователи&raquo; и заполнить форму. Помеченные звездочкой поля являются обязательными для заполнения. Флажки прав пользователя к установке не обязательны. Добавление пользователя происходит по нажатию кнопки &laquo;Создать&raquo;. После добавления новый пользователь попадает в список боковой панели под своим именем. Для создания нового пользователя необходимо нажать на ссылку &laquo;+добавить&raquo;.</p>	79	1
80	78	Редактирование пользователя	<p>Для редактирования пользователя необходимо нажать на соответствующую строчку в списке боковой панели раздела &laquo;Пользователи&raquo;. Откроется форма редактирования, аналогичная форме создания пользователя - с заполненными данными, относящимися к редактируемому пользователю.</p>	80	1
86	85	Создание объекта/подобъекта	<p>Объекты создаются в разделе &laquo;Панель управления&raquo; - в боковой панели, посредством нажатия на закладку &laquo;+&raquo;. В данном состоянии боковая панель содержит иерархический список всех объектов и кнопку &laquo;Добавить новый&raquo; под списком.</p>\n<p>При нажатии открывается всплывающее окно с формой создания объекта. Для объекта следует обязательно указать наименование и чертеж. Поле &laquo;Родитель&raquo; определяет родительский объект - таким образом можно создавать подобъекты. В поле &laquo;Создание&raquo; объект добавляется в закладки и становится активным. Для добавления подобъекта также можно воспользоваться кнопкой "Добавить" раздела &laquo;Подобъекты&raquo; в боковой панели при активном объекте.</p>\n<p>&nbsp;</p>	86	1
89	85	Добавление области подобъектов	<p>Для уточнения расположения подобъекта на объекте используются области - полупрозрачные полигоны, определяющие расположение подобъекта - при наведении курсора на такую область, подсвечивается соответствующий подобъект. При нажатии на область подобъект центрируется.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Для добавления области используется символьная кнопка в списке подобъектов. После нажатия на нее курсор на карте изменит свое отображение, а затем, посредством последующих нажатий, будут добавляться новые вершины полигона. По завершении операции отрисовки нужного региона полигоном необходимо нажать клавишу &laquo;Enter&raquo; для сохранения области соответствующего подобъекта. Посредством нажатия клавиши "Esc" выполняется отмена данной операции.</p>	89	1
90	85	Создание/редактирование элемента	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Создание нового элемента сети ГТМ на объекте реализуется кнопкой &laquo;Добавить&raquo; в разделе &laquo;Элементы&raquo; текущего активного объекта, а также символьными кнопками контекстного меню карты, которое вызывается нажатием правой кнопкой мыши на чертеже. В первом случае возникает диалоговое окно выбора вида элемента, после выбора которого открывается всплывающее окно с формой добавления элемента, аналогичное выбору соответствующего вида элемента в контекстном меню.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Разница между созданием через контекстное меню и кнопкой создания заключается в том, что в первом случае созданный элемент будет иметь позицию курсора в момент нажатия на чертеж, а во втором случае элемент добавится в правый верхний угол чертежа, что потребует его дальнейшего ручного позиционирования (такой же метод позиционирования используется для подобъектов).</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Форма добавления элемента имеет отображение в зависимости от выбранного вида элемента, но всегда имеет обязательные параметры &laquo;Наименование&raquo;, &laquo;Тип&raquo;, &laquo;Состояние&raquo;. Для элементов, имеющих косы, также необходимо указать глубину и шаг измерительных датчиков на косе, после чего данные параметры изменить будет уже нельзя (кроме регулирования отображения конкретных глубин, сгенерированных по заданному шагу). Элемент создается при вводе необходимых параметров - всплывающее окно пропадает, элемент добавляется на чертеж, а также попадает в список элементов объекта.</p>\n<p>Редактирование элемента происходит нажатием на него в списке элементов объекта или нажатием на наименование элемента на чертеже.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Для элементов, виды которых предполагают наличие термометрических кос, имеется возможность редактировать отображение глубин, сгенерированных на этапе создания. При создании от 0 до указанной величины включительно, генерируется серия глубин с заданным шагом. В дальнейшем, к каждой глубине привязываются показания. После создания элемента, в форму редактирования добавляется кнопка &laquo;Редактировать косу&raquo;, открывающая по нажатию форму со списком всех глубин косы с возможностью указать флажками те глубины, которые нужно использовать. Выбранные глубины будут видны на этапе заполнения значения для элемента. После указания необходимо нажать кнопку &laquo;Сохранить&raquo;.</p>	90	1
91	85	Создание/редактирование группы	<p>Группа создается единственным способом - нажатием на кнопку &laquo;Добавить&raquo; в разделе &laquo;Группы&raquo; объекта-родителя в боковой панели. Форма создания группы аналогична форме редактирования и содержит лишь одно обязательное поле &laquo;Наименование&raquo;. После добавления нажатием на кнопку &laquo;Сохранить&raquo; группа попадает в список.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; В форме редактирования элемента после нажатия на кнопку &laquo;Группы&raquo; отобразится форма со списком текущих групп с флажками, обозначающими принадлежность выбранного элемента к группам. При изменении состояния флажков необходимо нажать кнопку &laquo;Сохранить&raquo;.</p>	91	1
92	85	Добавление/просмотр комментариев/фотографий	<p>Просмотр и добавление фотографий и комментариев доступны как для элементов, так и для объектов. В случае с объектами форма просмотра/редактирования инициализируется при нажатии на символьную кнопку &laquo;Комменатрии/фото&raquo; в разделе &laquo;Объект&raquo; боковой панели. Для элементов такая кнопка доступна в форме редактирования элемента.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Всплывающее окно комментариев/фотографий позволяет пролистать список ранее добавленных комментариев, а также добавить новые через текстовое поле или кнопкой выбора загрузки фотографий. Данная информация добавляется нажатием "сохранить".</p>	92	1
93	85	Редактирование штампа	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Информация штампа чертежа редактируется нажатием символьной кнопки &laquo;Заполнение штампа чертежа&raquo; в разделе &laquo;Объект&raquo; боковой панели. Форма редактирования содержит таблицу, имеющую вид штампа. После сохранения все данные, внесенные в эту таблицу, попадают в штамп - как на отображаемый чертеж, так и на генерируемый впоследствии pdf-чертеж.</p>	93	1
94	85	Генерация чертежа	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Генерация чертежа производится путем нажатия на соответствующую символьную кнопку в разделе &laquo;Объект&raquo;. При этом в отдельной вкладке откроется созданный чертеж, содержащий элементы, отображенные на чертеже в момент нажатия.</p>	94	1
95	85	Заполнения значений элементов	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Ввод показаний элементов сети ГТМ производится через блок &laquo;Результаты замеров&raquo;. Данный блок активируется и скрывается нажатием на его заголовок и имеет вид таблицы, строки которой фильтруются на основе активных и неактивных флажков боковой панели. Ряды таблицы разделены по элементам и глубинам. В случае наличия у элемента косы, столбцы соответствуют типу вводимых значений, а также дате замера. Ячейки значений редактируемы и не требуют дополнительных действий для внесения изменений - все данные сохраняются сразу. Данные выводятся до даты, выбранной в формочке справа, от заголовка блока или до текущего момента. Количество выводимых значений также регулируется выпадающим списком рядом с формочкой ввода даты. Также, блок содержит клавишу обновления данных, которая используется опционально в случае некорректного ввода значений.</p>	95	1
100	98	Работа с графиками и табличными данными	<p>При выборе объекта в списке, в разделе &laquo;Статистика&raquo; в боковой панели отобразится форма параметров для вывода графиков и табличных данных по выбранному объекту.</p>\n<p>Также, отображаются списки групп и элементов объекта, их состояние и виды для фильтрации данных. По умолчанию данные формируются для всех элементов на текущую дату. Поле &laquo;Тип графика&raquo; определяет вывод отображения данных по пьезометрическим скважинам в виде одного графика на выбранную дату для всех ПС на объекте, либо для каждой ПС по графику, в зависимости от выбранного интервала дат.</p>	100	1
101	\N	Работа с мобильным приложением (stand-alone версией)	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Мобильное приложение предназначено для ввода данных, полученных с элементов сети в полевых условиях. Данный процесс предполагает изначальную загрузку данных в мобильное устройство, последующий ввод значений и добавление комментариев и фотографий с последующей выгрузкой в систему при наличии интернета.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Для начала работ с мобильным приложением необходимо установить программу на мобильное приложение (или на desktop-устройство через ARC-Welder). Далее следует авторизоваться в разделе &laquo;Настройки&raquo; главного окна системы (рис. 4.1), указав логин и пароль администратора или введенного администратором в систему пользователя. Также, необходимо указать имя сервера, выбранного при регистрации системы (например, demo.yamal.sgsystems.ru).</p>\n<p>&nbsp;</p>\n<p>Рисунок 4.1 Вид главного окна системы и окна настроек с примером введенных данных для авторизации</p>\n<p>&nbsp;</p>\n<p>Использование приложения предполагается в условиях отсутствия сети интернет, для чего требуется предварительная загрузка всех необходимых данных в устройство. Для этого, при наличии сети и корректно введенных данных авторизации, в разделе &laquo;Загрузка данных&raquo; (рис. 4.2) необходимо нажать кнопку &laquo;Загрузить данные&raquo;. На экране отобразится информация о загруженных данных, которая также будет отображаться в данном разделе, до следующей загрузки новых данных. Данные можно удалить кнопкой &laquo;Сброс данных&raquo; в разделе &laquo;Настройки&raquo;.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<p>Рисунок 4.2 Вид раздела &laquo;Загрузка данных&raquo;</p>\n<p>&nbsp;</p>\n<p>При наличии на устройстве загруженных данных, активен раздел &laquo;Ввод данных&raquo;. Ввод происходит по выбранному элементу, нахождение которого осуществляется по иерархии объектов или через поиск по названию или объекту. Для выбранного объекта/элемента доступны просмотр комментариев/фото, добавление комментария/фото, а также, добавление значений для элементов и просмотр карты для объектов.</p>\n<p>Для автономного просмотра фотографий в комментариях необходимо вручную загрузить их на устройство с помощью кнопки загрузки посредством нажатия на соответствующее изображение.</p>\n<p>&nbsp;</p>\n<p>Рисунок 4.3 Выбор элементов и объектов в разделе &laquo;Ввод данных&raquo;</p>\n<p>&nbsp;</p>\n<p>Рисунок 4.4 Слева направо: ввод значений для элемента, просмотр комментариев и фотографий к объекту, добавление фотографий и комментария</p>\n<p>&nbsp;</p>\n<p>При наличии сети интернет, а также при наличии добавленных значений/комментариев/фотографий станет доступным раздел &laquo;Отправка данных&raquo; (рис. 4.5), в котором осуществляется сохранение введенных данных на сервер. В случае успешной выгрузки соответствующие разделы вновь станут недоступны.</p>\n<p>&nbsp;</p>\n<p>Рисунок 4.5 Вид раздела &laquo;Отправка данных&raquo;</p>	101	1
67	63	Виды чертежей	<p>Определяющим и необходимым параметром объектов является чертеж. Без наличия чертежа создание объекта невозможно. Система поддерживает загрузку чертежей в формате pdf для последующей генерации конечного pdf-чертежа с добавленными на него <strong>штампом</strong>, <strong>экспликацией</strong>, <strong>элементами</strong> и <strong>условными обозначениями</strong>.</p>\n<p>Конечный чертеж предполагает последующую его печать, поэтому каждый чертеж имеет свой предусмотренный системой формат. Использование исходного чертежа в неподходящем формате может вызвать несоответствия при генерации конечного чертежа, нанесении на него штампов и т.п. Для корректной генерации система позволяет подготовить чертеж при помощи специальных dwg-шаблонов. Каждый такой шаблон хранит в себе слой с заданными параметрами страницы, соответствующими одному из выбранных форматов. Исходный чертеж необходимо вместить в подготовленный слой в шаблоне, и экспортировать pdf данного слоя.</p>	67	1
74	63	Панель управления	<p><strong>&nbsp;</strong></p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Панель управления (рис. 2.8, 2.9, 2.10, 2.11) служит для создания и редактирования объектов, добавления к ним элементов, ввода значений для элементов, а также для генерации pdf-чертежей объектов.</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<p>Рисунок 2.8 Панель управления (объект не выбран)</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; При входе в раздел &laquo;Панель управления&raquo; в боковой панели можно увидеть иерархический список созданных в системе объектов. Здесь же присутствует кнопка добавления нового объекта. При добавлении нового объекта или при выборе объекта из списка существующих, боковая панель меняется на блок редактирования объекта, разбитый на 5 секций:</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - объект - содержит форму редактирования объекта, кнопки переходов к просмотру истории изменений в рамках объектах, кнопки просмотра фотографии и комментариев, добавленных пользователями для текущего объекта, ссылку перехода к форме заполнения данных штампа;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - подобъекты - содержит список подобъектов принадлежащих объекту;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - фильтры - содержит фильтры отображения карты и табличных значений;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - группы - содержит список групп принадлежащих объекту;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - элементы - содержит список принадлежащих объекту элементов.</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Рабочая область содержит в себе блок закладок, карту-чертеж, расположенную под блоком закладок, и секцию результатов замеров, при нажатии на которую открывается таблица со значениями элементов текущего объекта.</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.9 Панель управления (просмотр и редактирование выбранного объекта)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Каждой закладке соответствует один объект. При нажатии на закладку осуществляется переход на объект - меняется карта-чертеж, данные в боковой панели, а также значения элементов. Ненужные закладки можно закрывать нажатием на крестик в правом верхнем углу закладки. Также всегда доступна закладка для перехода к списку всех объектов и добавлению нового.&nbsp;</p>\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Чертеж прокручивается по горизонтали и вертикали нативными элементами браузера (скроллами). Чертеж содержит позиционируемые элементы, области подобъектов, экспликацию, условные обозначения и штамп с редактируемым наполнением.&nbsp;</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Блок результатов замеров содержит табличные значения, дату, до которой необходимо выводить значения, а также выбор количества выводимых значений.</p>\n<p>&nbsp;</p>\n<p>Рисунок 2.11 Отображение блока табличных значений в панели управления</p>	74	1
83	81	Создание чертежа	<p>Для создания чертежа необходимо перейти в раздел &laquo;Чертежи&raquo; и заполнить соответствующую форму. Помеченные звездочкой поля являются обязательными для заполнения. Создание чертежа происходит по нажатию кнопки &laquo;Создать&raquo;.</p>\n<p>После добавления новый чертеж попадает в список боковой панели под собственным именем. Нажав на него, можно &nbsp;просмотреть качество формирования штампа и самого pdf-чертежа.</p>\n<p>В случае некорректного отображения рекомендуется удалить чертеж и создать новый, используя dwg-шаблон. Такой шаблон позволяет вместить необходимый чертеж в специально подготовленный (единственный) слой, хранящий подготовленные настройки страницы для печати в нужном формате - экспорт PDF данного слоя с вмещенным чертежом загрузится корректно.</p>	83	1
88	85	Работа с картой	<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; В правом верхнем углу располагаются элементы управления масштабированием &ndash; &laquo;+&raquo; и &laquo;-&raquo;, увеличивающие или уменьшающие размеры pdf-чертежа, соответственно. Такой же эффект производит нажатие на соответствующие клавиши на клавиатуре.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Слева от кнопок масштабирования находится кнопка блокировки позиционирования элементов (блокировка также может активироваться нажатием горячей клавиши &laquo;B&raquo;). В активном состоянии блокировки позиционирования запрещается перенос любых элементов на карте.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Положение карты регулируется скролл-барами, также стрелками на клавиатуре или зажатым колесом мыши.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Для изменения положения элементов на карте необходимо перетащить элемент на нужную позицию, удерживая левую кнопку мыши на иконке элемента (или на грани таблицы в случае с экспликацией). Единичное нажатие на иконку элемента приводит к центрированию карты к данному элементу.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; На отображение элементов также влияют флажки в списках текущего объекта - группы, элементы, фильтры. Изменение активности флажков приводит к соответствующему отображению/скрытию элементов на чертеже, в выгружаемом pdf, а также в табличных данных. Секция &laquo;Фильтры&raquo; относится только к элементам (то есть, не относится к подобъектам). Выбранные группы скрывают/отображают элементы, принадлежащие этим группам.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Отображение условных обозначений и экспликации на карте, а также на экспортируемом pdf-чертеже регулируется флажками &laquo;Экспликация&raquo; и &laquo;Условные обозначения&raquo; в секции &laquo;Карта&raquo; раздела &laquo;Объект&raquo; в боковой панели.</p>	88	1
81	77	Чертежи	\N	81	1
85	77	Панель управления	\N	85	1
59	58	Технические требования	<p><em>Для </em><em>web</em><em>-версии:</em></p>\n<ul>\n<li>Операционная система Windows&reg; XP/Vista/Win7</li>\n<li>Наличие браузера Google Chrome&reg;&nbsp;</li>\n</ul>\n<p><em>Для мобильного приложения:</em></p>\n<ul>\n<li>Android OS 3+, iPhone 4+&nbsp;</li>\n</ul>\n<p><em>Для </em><em>stand-alone </em><em>версии:</em></p>\n<ul>\n<li>Операционная система Windows&reg; XP/Vista/Win7</li>\n<li>Наличие браузера Google Chrome&reg;</li>\n<li>ARC Welder app</li>\n</ul>	59	1
63	\N	Обзор системы	\N	63	1
70	63	Группы	<p>Для фильтрации элементов сети ГТМ на карте, в табличных значениях, а также при генерации pdf-чертежей удобно группировать элементы. Для этого в системе в рамках объекта возможно создание групп. Группа имеет только один параметр - имя. После создания групп возможно добавление в них элементов. Один элемент может принадлежать нескольким группам.</p>	70	1
76	63	Справка	<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Раздел &laquo;Справка&raquo; служит для вывода информации по использованию системы. Текст раздела &laquo;Справка&raquo; дублирует данный документ. Боковая панель содержит содержание &laquo;Справки&raquo;. Рабочая область - текст выбранного из содержания раздела.</p>	76	1
77	\N	Работа с web-версией системы	\N	77	1
87	85	Редактирование объекта/подобъекта	<p>Для редактирования объекта или подобъекта необходимо нажать на соответствующую строчку в иерархическом списке всех объектов/подобъектов. При нажатии объект/подобъект добавляется в закладки (если он отсутствует в них) и становится активным. В боковом меню можно редактировать информацию активного объекта в разделе &laquo;Объект&raquo; - изменения вступают в силу только после нажатия кнопки &laquo;Сохранить&raquo; в правом нижнем углу раздела.</p>	87	1
98	77	Аналитика	\N	98	1
58	\N	Начало работы	\N	58	1
60	58	Активация системы	<p>Для активации системы необходимо подать заявку на сайте ymal.sgproject.ru. После заполнения и отправки формы, данные для доступа к системе высылаются на почту, указанную в заявке. Также предоставляются данные для входа в личный кабинет системы, где может осуществляться администрирование срока действия программного обеспечения и просмотр сопутствующей информации.</p>	60	1
61	58	Администрирование системы	<p>Личный кабинет пользователя доступен по адресу yamal.sgsystems.ru/lk/</p>\n<p>На рисунке 1.1 показан общий вид личного кабинета. Для входа в личный кабинет требуется авторизация.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<p>&nbsp;</p>\n<p>Рисунок 1.1 Общий вид личного кабинета</p>	61	1
62	58	Работа с комплексом	<p>Информационно-аналитическая система геотехнического мониторинга &laquo;Ямал&raquo; (далее по тексту ИАС ГТМ &laquo;Ямал&raquo;) является программным комплексом, включающим в себя web-версию, а также мобильное приложение.</p>\n<p>Мобильное приложение Yamal для устройств на базе Android доступно по адресу: http://yamal.sgsystems.ru/android.apk</p>\n<p>Мобильное приложение Yamal для устройств на базе iOS доступно в App Store.</p>\n<p>Также возможно использование системы в качестве stand-alone версии посредством установки мобильного приложения через расширение для браузера Google Chrome - ARC Welder (установка доступна по адресу: https://chrome.google.com/webstore/detail/arcwelder/emfinbmielocnlhgmfkkmkngdoccbadn). Данное расширение позволяет запускать приложения для Andorid в качестве системных программ. Работа со stand-alone версией аналогична работе с мобильным приложением.</p>	62	1
78	77	Пользователи	\N	78	1
84	81	Удаление чертежа	<p>Для удаления чертежа необходимо нажать на соответствующий чертеж в списке боковой панели раздела &laquo;Чертеж&raquo;. Далее в рабочей области необходимо нажать кнопку &laquo;Удалить чертеж&raquo;. Чертеж удалится только в том случае, если он не используется для какого-либо объекта системы. В противном случае, при удалении откроется всплывающее окно, оповещающее о наличии объекта, использующего данный чертеж.</p>	84	1
96	85	Просмотр истории изменений	<p>Просмотр истории изменений в рамках объекта доступен через кнопку &laquo;История&raquo; справа от заголовка раздела &laquo;Объект&raquo;.</p>	96	1
97	85	Импорт/экспорт значений	<p>Для экспорта значений показаний элемента сети ГТМ необходимо в форме редактирования нажать на кнопку &laquo;Экспорт&raquo;. При этом будет выгружен xmls-файл, содержащий таблицу показаний элементов до даты, указанной в блоке &laquo;Результаты замеров&raquo; в указанном количестве (вводится в том же блоке).</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Импорт значений происходит с помощью аналогичной кнопки &laquo;Импорт&raquo;. При этом будет предложено загрузить xmls-файл с данными. Формат таблицы должен иметь вид экспортируемого файла. Рекомендуется для импорта выгружать значения, корректировать их и после импортировать обратно в систему.</p>	97	1
99	98	Работа со статистикой	<p>Для вывода общей статистики по объектам необходимо в разделе &laquo;Аналитика&raquo; в боковой панели, при невыбранном объекте, нажать кнопку &laquo;Статистика&raquo; в разделе &laquo;Объекты&raquo;. В появившемся диалоговом окне необходимо выбрать дату, по которой формируются данные, а также требующиеся объекты и элементы. При заданных параметрах после нажатия на кнопку &laquo;Готово&raquo; в рабочей области системы отобразятся таблицы с данными о количестве элементов ГТМ и их состоянию для каждого объекта на выбранную дату.</p>	99	1
\.


--
-- Name: treferences_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('treferences_id_seq', 101, true);


--
-- Name: treferences_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('treferences_ordering_seq', 101, true);


--
-- Data for Name: trewrites; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY trewrites (id, regexp, fields, page_id, controller_name, controller_mode, signature) FROM stdin;
1	^/ajaj/([\\w\\-]+)/?$	mode	\N	Ajaj	\N	\N
3	^/api/mobile/([\\w\\-]+)/?$	mode	\N	ApiMobile	\N	\N
4	^/api/autodesk/([\\w\\-]+)/?$	mode	\N	ApiAutodesk	\N	\N
6	^/GTM/([\\w\\-]+)/?$	mode	\N	GTM	\N	\N
7	^/stamp_gen/(\\d+)/(\\d+)/(\\d+)/?$	facility_id,width,height	\N	GTM	stamp_gen	\N
\.


--
-- Name: trewrites_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('trewrites_id_seq', 7, true);


--
-- Data for Name: troles; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY troles (id, code) FROM stdin;
1	pages
2	articles
3	design
4	settings
5	files
6	market
7	guestbooks
8	users
9	admin_start
11	gtm_input
12	gtm_analytics
14	seomp
13	gtm_edit
10	gtm_settings
\.


--
-- Name: troles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('troles_id_seq', 14, true);


--
-- Data for Name: troles_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY troles_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Страницы
2	2	1	Статьи
3	3	1	Дизайн
4	4	1	Настройки
5	5	1	Файлы
6	6	1	Магазин
7	7	1	Гостевые книги
8	8	1	Пользователи
9	9	1	Доступ в админ-панель
11	11	1	ГТМ | Ввод данных
12	12	1	ГТМ | Аналитика
14	14	1	SEOMP
13	13	1	ГТМ | Редактирование
10	10	1	ГТМ | Создание пользователей
\.


--
-- Name: troles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('troles_l10n_id_seq', 14, true);


--
-- Data for Name: tsensor_comment_images; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_comment_images (id, image_id, comment_id) FROM stdin;
\.


--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_comment_images_id_seq', 76, true);


--
-- Data for Name: tsensor_comments; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_comments (id, sensor_id, date_cr, user_cr_id, body, images_json) FROM stdin;
\.


--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_comments_id_seq', 44, true);


--
-- Data for Name: tsensor_groups; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_groups (id, sensor_id, group_id) FROM stdin;
\.


--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_groups_id_seq', 27, true);


--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_groups_id_seq1', 162, true);


--
-- Data for Name: tsensor_model_measurers; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_model_measurers (id, sensor_model_id, value_type_id, name, ordering, accuracy) FROM stdin;
\.


--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_measurers_id_seq', 10, true);


--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_measurers_ordering_seq', 10, true);


--
-- Data for Name: tsensor_model_normatives; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_model_normatives (id, sensor_model_id, normative_id, value, for_group) FROM stdin;
\.


--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_normatives_id_seq', 19, true);


--
-- Data for Name: tsensor_model_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_model_types (id, name) FROM stdin;
2	c инклинометром
3	краской
4	наварная
5	вертикальная
6	горизонтальная
7	наклонная
1	 
8	забетонированная
\.


--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_types_id_seq', 8, true);


--
-- Data for Name: tsensor_models; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_models (id, code, name, name_short, has_braid, has_own_values, has_angle) FROM stdin;
14	ts	Термометрическая скважина 	ТС	1	\N	\N
10	gdm	Грунтовая деформационная марка	ГДМ	1	1	1
13	dm	Деформационная марка	ДМ	\N	1	1
8	rp	Репер	РП	\N	1	\N
9	ps	Гидрогеологическая скважина	ПС	\N	1	\N
\.


--
-- Name: tsensor_models_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_models_id_seq', 14, true);


--
-- Data for Name: tsensor_photos; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_photos (id, sensor_id, date_cr, user_cr_id, image_id, body) FROM stdin;
\.


--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_photos_id_seq', 1, false);


--
-- Data for Name: tsensor_states; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_states (id, name, code) FROM stdin;
1	Рабочее	work
2	Поврежден	damaged
4	Не оборудован	unequip
6	Демонтирован	dismantle
3	Не смонтирован	unmount
5	Недоступен	unavailable
\.


--
-- Name: tsensor_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_states_id_seq', 6, true);


--
-- Data for Name: tsensor_values; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensor_values (id, sensor_id, date_cr, value, date_use, braid_id, allowed_value_type_id) FROM stdin;
4066	387	2017-01-25 10:32:24.324617	1.0000	2017-01-16	552	\N
4067	387	2017-01-25 10:32:25.740789	2.0000	2017-01-16	553	\N
4068	387	2017-01-25 10:32:26.7423	2.0000	2017-01-16	554	\N
4069	387	2017-01-25 10:32:27.330226	2.0000	2017-01-16	555	\N
4070	387	2017-01-25 10:32:27.792668	2.0000	2017-01-16	556	\N
4071	387	2017-01-25 10:32:28.21823	2.0000	2017-01-16	557	\N
4072	387	2017-01-25 10:32:28.450376	2.0000	2017-01-16	558	\N
4073	387	2017-01-25 10:32:28.658327	2.0000	2017-01-16	559	\N
4074	387	2017-01-25 10:32:28.853317	2.0000	2017-01-16	560	\N
4075	387	2017-01-25 10:32:29.049842	2.0000	2017-01-16	561	\N
4076	387	2017-01-25 10:32:30.61265	22.0000	2017-01-16	551	\N
4077	385	2017-01-25 10:32:39.606053	7.0000	2017-01-16	535	\N
4078	385	2017-01-25 10:32:39.842661	7.0000	2017-01-16	536	\N
4079	385	2017-01-25 10:32:40.055329	7.0000	2017-01-16	537	\N
4080	385	2017-01-25 10:32:40.264225	7.0000	2017-01-16	538	\N
4081	385	2017-01-25 10:32:40.457687	7.0000	2017-01-16	539	\N
4082	385	2017-01-25 10:32:40.687762	7.0000	2017-01-16	540	\N
4083	385	2017-01-25 10:32:40.878725	7.0000	2017-01-16	541	\N
4084	385	2017-01-25 10:32:41.08495	7.0000	2017-01-16	542	\N
4085	385	2017-01-25 10:32:41.288677	65.0000	2017-01-16	543	\N
4086	385	2017-01-25 10:32:41.495537	5.0000	2017-01-16	544	\N
4087	385	2017-01-25 10:32:41.690791	4.0000	2017-01-16	534	\N
4088	380	2017-01-25 11:44:25.077037	365.4070	2017-01-25	\N	1
4090	388	2017-01-25 11:44:25.077037	365.5800	2017-01-25	\N	6
4091	382	2017-01-25 13:55:00.287648	3.0000	2017-01-25	\N	3
4092	382	2017-01-25 13:55:00.287648	3.0000	2017-01-25	\N	4
4093	384	2017-01-25 13:55:00.287648	-1.0000	2017-01-25	524	\N
4094	384	2017-01-25 13:55:00.287648	-1.0000	2017-01-25	525	\N
4095	384	2017-01-25 13:55:00.287648	-2.0000	2017-01-25	526	\N
4096	384	2017-01-25 13:55:00.287648	-3.0000	2017-01-25	527	\N
4097	384	2017-01-25 13:55:00.287648	-3.0000	2017-01-25	528	\N
4098	384	2017-01-25 13:55:00.287648	-5.0000	2017-01-25	529	\N
4099	384	2017-01-25 13:55:00.287648	-5.0000	2017-01-25	530	\N
4100	385	2017-01-25 13:55:00.287648	-9.0000	2017-01-25	534	\N
4101	386	2017-01-25 13:55:00.287648	5.0000	2017-01-25	\N	3
4102	386	2017-01-25 13:55:00.287648	5.0000	2017-01-25	\N	4
4089	387	2017-01-25 11:44:25.077037	-8.0000	2017-01-25	551	\N
4103	389	2017-01-25 13:55:00.287648	354.0550	2017-01-25	\N	1
4104	390	2017-01-25 13:55:00.287648	368.4710	2017-01-25	\N	6
4105	391	2017-01-25 13:55:00.287648	367.4580	2017-01-25	\N	5
4106	392	2017-01-25 13:55:00.287648	355.5640	2017-01-25	\N	5
4107	393	2017-01-25 13:55:00.287648	-1.0000	2017-01-25	563	\N
4108	393	2017-01-25 13:55:00.287648	-2.0000	2017-01-25	565	\N
4109	393	2017-01-25 13:55:00.287648	-3.0000	2017-01-25	566	\N
4110	393	2017-01-25 13:55:00.287648	-5.0000	2017-01-25	567	\N
4111	393	2017-01-25 13:55:00.287648	-6.0000	2017-01-25	568	\N
4112	393	2017-01-25 13:55:00.287648	-7.0000	2017-01-25	569	\N
4113	393	2017-01-25 13:55:00.287648	-8.0000	2017-01-25	570	\N
4114	393	2017-01-25 13:55:00.287648	-9.0000	2017-01-25	571	\N
4115	393	2017-01-25 13:55:00.287648	-10.0000	2017-01-25	572	\N
4116	393	2017-01-25 13:55:00.287648	-10.0000	2017-01-25	562	\N
4117	394	2017-01-25 13:55:00.287648	367.5280	2017-01-25	\N	6
4118	395	2017-01-25 13:55:00.287648	357.0320	2017-01-25	\N	6
4120	397	2017-01-26 16:25:04.273403	5.0000	2017-01-18	\N	6
4121	398	2017-01-26 16:25:06.46353	10.0000	2017-01-18	\N	6
4122	399	2017-01-26 16:25:08.003676	20.0000	2017-01-18	\N	6
4123	400	2017-01-26 16:25:10.148595	30.0000	2017-01-18	\N	6
4124	401	2017-01-26 16:25:11.344815	40.0000	2017-01-18	\N	6
4126	397	2017-01-26 16:25:25.139929	5.0000	2017-01-19	\N	6
4127	398	2017-01-26 16:25:25.139929	10.0000	2017-01-19	\N	6
4128	399	2017-01-26 16:25:25.139929	20.0000	2017-01-19	\N	6
4129	400	2017-01-26 16:25:25.139929	30.0000	2017-01-19	\N	6
4130	401	2017-01-26 16:25:25.139929	40.0000	2017-01-19	\N	6
4131	402	2017-01-26 16:28:03.040164	\N	2017-01-18	576	\N
4155	419	2017-03-23 13:56:53.98421	1.1000	2017-03-17	\N	1
4164	423	2017-03-23 14:01:48.385875	-2.0000	2017-03-14	719	\N
4165	423	2017-03-23 14:01:49.349765	-2.0000	2017-03-14	720	\N
4166	423	2017-03-23 14:01:50.358775	-2.0000	2017-03-14	721	\N
4158	422	2017-03-23 13:57:51.101484	2000.0000	2017-03-16	\N	6
4140	396	2017-01-26 16:35:07.916974	66.0000	2017-01-29	\N	6
4141	396	2017-01-26 16:37:38.69848	71.0000	2017-01-30	\N	6
4139	396	2017-01-26 16:33:55.417108	20.0000	2017-01-26	\N	6
4142	396	2017-02-01 11:26:34.047353	10.0000	2017-01-27	\N	6
4143	396	2017-02-01 11:26:37.887098	50.0000	2017-01-28	\N	6
4144	417	2017-02-03 19:19:36.037929	\N	2017-01-30	\N	2
4145	412	2017-02-15 18:27:28.65687	2.0000	2017-02-15	\N	1
4146	420	2017-03-23 13:55:50.715255	1.0000	2017-03-14	\N	2
4147	420	2017-03-23 13:55:51.435228	2.0000	2017-03-15	\N	2
4148	420	2017-03-23 13:55:52.18132	3.0000	2017-03-16	\N	2
4149	420	2017-03-23 13:55:52.969767	4.0000	2017-03-17	\N	2
4150	420	2017-03-23 13:55:53.959104	5.0000	2017-03-18	\N	2
4151	420	2017-03-23 13:55:54.963759	6.0000	2017-03-19	\N	2
4152	419	2017-03-23 13:56:39.804927	1.0000	2017-03-14	\N	1
4167	423	2017-03-23 14:01:52.153214	-2.0000	2017-03-14	722	\N
4153	419	2017-03-23 13:56:41.293001	1.0000	2017-03-15	\N	1
4154	419	2017-03-23 13:56:49.528239	1.0000	2017-03-16	\N	1
4159	422	2017-03-23 13:57:54.32833	100000.0000	2017-03-17	\N	6
4160	422	2017-03-23 14:01:06.24015	0.0000	2017-03-18	\N	6
4138	396	2017-01-26 16:33:55.417108	\N	2017-01-17	\N	6
4119	396	2017-01-26 16:25:02.991392	1.0000	2017-01-18	\N	6
4125	396	2017-01-26 16:25:25.139929	0.0000	2017-01-19	\N	6
4132	396	2017-01-26 16:28:39.452876	5.0000	2017-01-20	\N	6
4133	396	2017-01-26 16:28:41.789032	10.0000	2017-01-21	\N	6
4134	396	2017-01-26 16:28:43.724673	20.0000	2017-01-22	\N	6
4135	396	2017-01-26 16:29:14.579203	35.0000	2017-01-23	\N	6
4136	396	2017-01-26 16:29:17.065415	40.0000	2017-01-24	\N	6
4137	396	2017-01-26 16:31:22.903493	55.0000	2017-01-25	\N	6
4168	423	2017-03-23 14:01:52.153214	-2.0000	2017-03-14	723	\N
4162	422	2017-03-23 14:01:10.458853	100.0000	2017-03-20	\N	6
4163	423	2017-03-23 14:01:47.916066	-2.0000	2017-03-14	718	\N
4169	423	2017-03-23 14:01:52.153214	-2.0000	2017-03-14	724	\N
4170	423	2017-03-23 14:01:52.153214	-2.0000	2017-03-14	725	\N
4171	423	2017-03-23 14:01:52.153214	-2.0000	2017-03-14	726	\N
4172	423	2017-03-23 14:01:57.3287	-1.0000	2017-03-15	718	\N
4173	423	2017-03-23 14:02:05.070089	-0.9000	2017-03-16	718	\N
4174	423	2017-03-23 14:02:13.901612	-0.9000	2017-03-15	719	\N
4175	423	2017-03-23 14:02:17.445484	-2.0000	2017-03-15	720	\N
4176	419	2017-03-23 14:02:57.445399	1.0000	2017-03-18	\N	1
4178	419	2017-03-23 14:03:01.252261	2.0000	2017-03-19	\N	1
4177	419	2017-03-23 14:02:59.122947	1.0000	2017-03-20	\N	1
4156	422	2017-03-23 13:57:46.715972	1000.0000	2017-03-14	\N	6
4157	422	2017-03-23 13:57:47.630631	1100.0000	2017-03-15	\N	6
4161	422	2017-03-23 14:01:08.354959	1.0000	2017-03-19	\N	6
4179	421	2017-03-23 14:03:38.520428	35000.0000	2017-03-14	\N	12
4259	405	2017-03-24 13:55:58.273621	-3.5000	2017-03-17	624	\N
4260	405	2017-03-24 13:55:58.273621	-4.0000	2017-03-17	625	\N
4261	405	2017-03-24 13:55:58.273621	-4.5000	2017-03-17	626	\N
4262	405	2017-03-24 13:55:58.273621	-5.0000	2017-03-17	627	\N
4263	405	2017-03-24 13:55:58.273621	-5.5000	2017-03-17	628	\N
4264	405	2017-03-24 13:55:58.273621	-6.0000	2017-03-17	629	\N
4265	405	2017-03-24 13:55:58.273621	-6.5000	2017-03-17	630	\N
4266	405	2017-03-24 13:55:58.273621	-7.0000	2017-03-17	631	\N
4267	405	2017-03-24 13:55:58.273621	-7.5000	2017-03-17	632	\N
4181	421	2017-03-23 14:03:40.740234	1.0000	2017-03-16	\N	12
4182	421	2017-03-23 14:03:42.062652	1.0000	2017-03-17	\N	12
4183	421	2017-03-23 14:03:44.716843	1.0000	2017-03-18	\N	12
4268	405	2017-03-24 13:55:58.273621	-8.0000	2017-03-17	633	\N
4269	405	2017-03-24 13:55:58.273621	-8.5000	2017-03-17	634	\N
4187	421	2017-03-23 14:11:10.532207	1.0000	2017-03-15	715	\N
4270	405	2017-03-24 13:55:58.273621	-9.0000	2017-03-17	635	\N
4271	405	2017-03-24 13:55:58.273621	-9.5000	2017-03-17	636	\N
4189	421	2017-03-23 14:11:17.157275	1.0000	2017-03-16	715	\N
4188	421	2017-03-23 14:11:14.902612	1.0000	2017-03-16	716	\N
4272	405	2017-03-24 13:55:58.273621	-10.0000	2017-03-17	637	\N
4180	421	2017-03-23 14:03:39.86615	35200.0000	2017-03-15	\N	12
4184	421	2017-03-23 14:03:51.839879	35000.0000	2017-03-14	716	\N
4185	421	2017-03-23 14:11:03.092319	30000.0000	2017-03-14	715	\N
4186	421	2017-03-23 14:11:09.07081	35100.0000	2017-03-15	716	\N
4190	421	2017-03-24 13:24:02.953542	5.0000	2017-03-17	716	\N
4191	421	2017-03-24 13:24:04.976473	7.0000	2017-03-17	715	\N
4192	421	2017-03-24 13:24:07.351919	16.0000	2017-03-18	716	\N
4193	418	2017-03-24 13:36:28.883002	8.0000	2017-03-15	\N	2
4194	418	2017-03-24 13:36:49.858845	9.0000	2017-03-16	\N	2
4196	418	2017-03-24 13:36:53.51207	10.0000	2017-03-17	\N	2
4195	418	2017-03-24 13:36:51.699725	11.0000	2017-03-18	\N	2
4197	418	2017-03-24 13:36:59.090541	12.0000	2017-03-19	\N	2
4198	418	2017-03-24 13:37:01.127751	13.0000	2017-03-20	\N	2
4199	416	2017-03-24 13:37:08.703995	7.0000	2017-03-15	\N	2
4200	416	2017-03-24 13:37:09.32744	8.0000	2017-03-16	\N	2
4201	416	2017-03-24 13:37:10.271476	9.0000	2017-03-17	\N	2
4202	416	2017-03-24 13:37:12.017664	10.0000	2017-03-18	\N	2
4203	416	2017-03-24 13:37:13.326111	11.0000	2017-03-19	\N	2
4204	416	2017-03-24 13:37:14.860307	12.0000	2017-03-20	\N	2
4205	417	2017-03-24 13:37:20.498754	9.0000	2017-03-15	\N	2
4206	417	2017-03-24 13:37:22.048221	10.0000	2017-03-16	\N	2
4207	417	2017-03-24 13:37:23.533827	11.0000	2017-03-17	\N	2
4208	417	2017-03-24 13:37:25.084945	12.0000	2017-03-18	\N	2
4209	417	2017-03-24 13:37:25.755984	13.0000	2017-03-19	\N	2
4210	417	2017-03-24 13:37:26.8009	14.0000	2017-03-20	\N	2
4211	410	2017-03-24 13:44:32.567472	3000.0000	2017-03-15	\N	1
4212	410	2017-03-24 13:44:42.311427	3000.0000	2017-03-16	\N	1
4213	410	2017-03-24 13:45:00.397131	3010.0000	2017-03-17	\N	1
4214	405	2017-03-24 13:52:27.613529	-10.0000	2017-03-15	637	\N
4255	405	2017-03-24 13:55:58.273621	-1.0000	2017-03-17	620	\N
4215	405	2017-03-24 13:52:32.903701	-9.5000	2017-03-15	636	\N
4216	405	2017-03-24 13:53:02.280446	\N	2017-03-15	638	\N
4217	405	2017-03-24 13:53:02.280446	\N	2017-03-15	639	\N
4218	405	2017-03-24 13:53:13.41806	-9.0000	2017-03-15	635	\N
4219	405	2017-03-24 13:53:17.638509	-8.5000	2017-03-15	634	\N
4220	405	2017-03-24 13:53:20.463675	-8.0000	2017-03-15	633	\N
4221	405	2017-03-24 13:53:23.57297	-7.5000	2017-03-15	632	\N
4222	405	2017-03-24 13:53:25.636594	-7.0000	2017-03-15	631	\N
4223	405	2017-03-24 13:53:29.080316	-6.5000	2017-03-15	630	\N
4224	405	2017-03-24 13:53:31.7484	-6.0000	2017-03-15	629	\N
4225	405	2017-03-24 13:53:36.703552	-5.5000	2017-03-15	628	\N
4226	405	2017-03-24 13:53:38.766808	-5.0000	2017-03-15	627	\N
4227	405	2017-03-24 13:53:41.346425	-4.5000	2017-03-15	626	\N
4228	405	2017-03-24 13:53:45.998023	-4.0000	2017-03-15	625	\N
4229	405	2017-03-24 13:53:48.904949	-3.5000	2017-03-15	624	\N
4230	405	2017-03-24 13:53:51.039268	-3.0000	2017-03-15	623	\N
4231	405	2017-03-24 13:53:53.904039	-2.5000	2017-03-15	622	\N
4232	405	2017-03-24 13:54:17.993955	-2.0000	2017-03-15	621	\N
4233	405	2017-03-24 13:54:21.580626	-1.5000	2017-03-15	620	\N
4234	405	2017-03-24 13:54:24.124441	-1.0000	2017-03-15	619	\N
4235	405	2017-03-24 13:55:53.865795	-1.0000	2017-03-16	619	\N
4236	405	2017-03-24 13:55:53.865795	-1.5000	2017-03-16	620	\N
4237	405	2017-03-24 13:55:53.865795	-2.0000	2017-03-16	621	\N
4238	405	2017-03-24 13:55:53.865795	-2.5000	2017-03-16	622	\N
4239	405	2017-03-24 13:55:53.865795	-3.0000	2017-03-16	623	\N
4240	405	2017-03-24 13:55:53.865795	-3.5000	2017-03-16	624	\N
4241	405	2017-03-24 13:55:53.865795	-4.0000	2017-03-16	625	\N
4242	405	2017-03-24 13:55:53.865795	-4.5000	2017-03-16	626	\N
4243	405	2017-03-24 13:55:53.865795	-5.0000	2017-03-16	627	\N
4244	405	2017-03-24 13:55:53.865795	-5.5000	2017-03-16	628	\N
4245	405	2017-03-24 13:55:53.865795	-6.0000	2017-03-16	629	\N
4246	405	2017-03-24 13:55:53.865795	-6.5000	2017-03-16	630	\N
4247	405	2017-03-24 13:55:53.865795	-7.0000	2017-03-16	631	\N
4248	405	2017-03-24 13:55:53.865795	-7.5000	2017-03-16	632	\N
4249	405	2017-03-24 13:55:53.865795	-8.0000	2017-03-16	633	\N
4250	405	2017-03-24 13:55:53.865795	-8.5000	2017-03-16	634	\N
4251	405	2017-03-24 13:55:53.865795	-9.0000	2017-03-16	635	\N
4252	405	2017-03-24 13:55:53.865795	-9.5000	2017-03-16	636	\N
4253	405	2017-03-24 13:55:53.865795	-10.0000	2017-03-16	637	\N
4256	405	2017-03-24 13:55:58.273621	-2.0000	2017-03-17	621	\N
4257	405	2017-03-24 13:55:58.273621	-2.5000	2017-03-17	622	\N
4258	405	2017-03-24 13:55:58.273621	-3.0000	2017-03-17	623	\N
4254	405	2017-03-24 13:55:58.273621	-0.9000	2017-03-17	619	\N
4273	396	2017-03-24 13:58:36.876181	200.0000	2017-03-15	\N	6
4274	396	2017-03-24 13:59:02.60816	201.0000	2017-03-16	\N	6
4275	396	2017-03-24 13:59:06.721146	202.0000	2017-03-17	\N	6
4276	398	2017-03-24 13:59:24.572791	100.0000	2017-03-15	\N	6
4277	398	2017-03-24 13:59:28.334996	150.0000	2017-03-16	\N	6
4278	398	2017-03-24 13:59:31.364849	200.0000	2017-03-17	\N	6
4279	398	2017-03-24 13:59:37.849191	250.0000	2017-03-18	\N	6
4280	398	2017-03-24 13:59:41.187218	300.0000	2017-03-19	\N	6
4281	398	2017-03-24 13:59:46.721273	400.0000	2017-03-20	\N	6
4282	398	2017-03-24 13:59:50.245279	500.0000	2017-03-21	\N	6
4283	398	2017-03-24 14:00:04.053637	50.0000	2017-03-22	\N	6
4284	398	2017-03-24 14:00:06.264232	1.0000	2017-03-23	\N	6
4286	425	2017-03-28 10:57:51.325066	38000.0000	2017-03-19	\N	12
4285	425	2017-03-28 10:55:05.120452	38000.0000	2017-03-19	741	\N
4287	425	2017-03-28 10:58:14.564158	35000.0000	2017-03-19	740	\N
4289	426	2017-03-28 10:58:29.472421	38000.0000	2017-03-19	743	\N
4290	426	2017-03-28 10:58:32.228213	35000.0000	2017-03-19	742	\N
4292	427	2017-03-28 10:58:42.460318	38000.0000	2017-03-19	745	\N
4293	427	2017-03-28 10:58:49.482674	35000.0000	2017-03-19	744	\N
4294	425	2017-03-28 10:58:55.936842	38200.0000	2017-03-20	\N	12
4295	425	2017-03-28 10:59:00.537156	38300.0000	2017-03-21	\N	12
4296	425	2017-03-28 10:59:05.979891	38200.0000	2017-03-20	741	\N
4288	426	2017-03-28 10:58:23.711581	38000.0000	2017-03-19	\N	12
4291	427	2017-03-28 10:58:39.639602	38000.0000	2017-03-19	\N	12
4297	425	2017-03-28 10:59:05.979891	3000.0000	2017-03-21	741	\N
4302	425	2017-03-28 10:59:37.17548	35200.0000	2017-03-20	740	\N
4303	425	2017-03-28 10:59:37.17548	35300.0000	2017-03-21	740	\N
4298	426	2017-03-28 10:59:08.508797	38300.0000	2017-03-20	743	\N
4299	426	2017-03-28 10:59:08.508797	38400.0000	2017-03-21	743	\N
4308	426	2017-03-28 11:00:06.448077	38300.0000	2017-03-20	\N	12
4309	426	2017-03-28 11:00:06.448077	38400.0000	2017-03-21	\N	12
4304	426	2017-03-28 10:59:54.197203	35300.0000	2017-03-20	742	\N
4305	426	2017-03-28 10:59:54.197203	35400.0000	2017-03-21	742	\N
4300	427	2017-03-28 10:59:09.761014	38350.0000	2017-03-20	745	\N
4301	427	2017-03-28 10:59:09.761014	38450.0000	2017-03-21	745	\N
4310	427	2017-03-28 11:00:10.015718	38350.0000	2017-03-20	\N	12
4311	427	2017-03-28 11:00:10.015718	38450.0000	2017-03-21	\N	12
4306	427	2017-03-28 10:59:57.174098	35350.0000	2017-03-20	744	\N
4307	427	2017-03-28 10:59:57.174098	35400.0000	2017-03-21	744	\N
4312	429	2017-03-30 15:38:39.59437	50000.0000	2017-03-01	\N	6
4313	429	2017-03-30 15:39:52.160959	50200.0000	2017-03-02	\N	6
4314	429	2017-03-30 15:39:56.597269	50300.0000	2017-03-03	\N	6
4315	429	2017-03-30 15:40:04.231246	49700.0000	2017-03-04	\N	6
4316	430	2017-03-30 15:46:38.501188	50000.0000	2017-03-01	\N	1
4317	430	2017-03-30 15:46:41.650449	50000.0000	2017-03-02	\N	1
4318	430	2017-03-30 15:46:45.76366	50000.0000	2017-03-03	\N	1
4319	430	2017-03-30 15:47:27.310317	49999.0000	2017-03-04	\N	1
\.


--
-- Name: tsensor_values_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensor_values_id_seq', 4319, true);


--
-- Data for Name: tsensors; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsensors (id, facility_id, name, location_x, location_y, location_comments, measurement_mode_id, allowed_model_type_id, state_id, is_retranslator, deep, deep_step, image_id, angle, deleted, pr_sensor_id, measurement_period, reference_date, clipmap) FROM stdin;
407	122	ТС_фоновая_тест4	1123.00	893.00	\N	\N	9	1	1	10.0	0.5	\N	0	\N	\N	\N	2017-02-01	\N
408	122	ГДМ_тест1	1292.00	504.00	\N	\N	12	1	0	5.0	1.0	\N	0	\N	\N	\N	2017-02-01	\N
409	122	ГДМ_тест2	1460.00	820.00	\N	\N	12	1	1	3.0	1.0	\N	0	\N	\N	\N	2017-02-01	\N
413	122	РП_тест4	929.00	2780.00	\N	\N	1	1	1	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
414	122	ГДМ_тест3	888.00	1680.00	\N	\N	12	1	1	2.0	1.0	\N	0	\N	\N	\N	2017-02-01	\N
411	122	РП_тест2	795.00	1684.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
415	122	ГДМ_тест5	1249.00	2230.00	\N	\N	12	1	1	2.0	1.0	\N	0	\N	\N	\N	2017-02-01	\N
416	122	ПС_тест3	1187.00	2868.00	\N	\N	2	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
381	126	ТС№9	1003.00	200.00	\N	\N	8	1	0	11.0	1.0	\N	0	\N	\N	\N	\N	\N
417	122	ПС_тест2	1247.00	1750.00	\N	\N	2	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
382	126	ГДМ№1	994.00	221.00	\N	\N	4	1	0	5.0	1.0	\N	0	\N	\N	\N	\N	\N
383	126	ТС№8	1093.00	170.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
384	126	ТС№7	1183.00	200.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
418	122	ПС_тест1	1606.00	571.00	\N	\N	2	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
385	126	ТС№6	1252.00	198.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
386	126	ГДМ№2	1244.00	176.00	\N	\N	4	1	0	5.0	1.0	\N	0	\N	\N	\N	\N	\N
387	126	ТС№5	1433.00	197.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
388	126	ДМ(N°3а-3)	1552.00	201.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
389	127	РП№4	1374.00	254.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
390	127	Дм	1267.00	212.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
391	127	Дм2	1142.00	212.00	\N	\N	5	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
392	127	Дм3	1473.00	212.00	\N	\N	5	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
393	127	ТС№12	952.00	211.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
419	131	Рп	186.00	136.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
394	127	Дм4	1472.00	152.00	\N	\N	6	1	0	0.0	0.0	\N	180	\N	\N	\N	\N	\N
420	131	ПС	190.00	254.00	\N	\N	2	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
395	127	Дм5	1369.00	146.00	\N	\N	6	1	\N	0.0	0.0	\N	180	\N	\N	\N	\N	\N
380	123	тест	357.00	761.00	\N	\N	1	1	0	0.0	0.0	\N	0	1	\N	\N	\N	\N
397	123	ДМ2	311.00	620.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
421	131	ГДМ	189.00	377.00	\N	\N	12	1	0	5.0	5.0	\N	0	\N	\N	\N	\N	\N
398	123	ДМ3	198.00	934.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
399	123	ДМ4	269.00	847.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
400	123	ДМ5	601.00	791.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
401	123	ДМ6	491.00	768.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
402	123	ТС1	234.00	479.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
403	123	ТС2	627.00	704.00	\N	\N	8	1	0	10.0	1.0	\N	0	\N	\N	\N	\N	\N
396	123	ДМ1	271.00	514.00	\N	\N	6	1	\N	0.0	0.0	\N	0	\N	\N	\N	2017-01-18	\N
405	122	ТС_тест 2	1368.00	411.00	\N	\N	8	1	1	15.0	0.5	\N	0	\N	\N	\N	2017-02-01	\N
406	122	ТС_тест3	1613.00	505.00	\N	\N	8	1	1	15.0	0.5	\N	0	\N	\N	\N	2017-02-01	\N
404	122	ТСфоновая_тест1	1208.00	613.00	\N	\N	11	1	0	10.0	0.5	\N	0	\N	\N	\N	2017-02-01	\N
422	131	ДМ	188.00	513.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
423	131	ТС	192.00	653.00	\N	\N	8	1	0	11.0	0.5	\N	0	\N	\N	\N	\N	\N
425	122	разр-1	1311.00	870.00	\N	\N	12	1	0	3.0	3.0	\N	0	\N	\N	\N	\N	\N
426	122	разр-2	1394.00	900.00	\N	\N	12	1	0	3.0	3.0	\N	0	\N	\N	\N	\N	\N
427	122	разр-3	1469.00	906.00	\N	\N	12	1	\N	3.0	3.0	\N	0	\N	\N	\N	\N	\N
410	122	РП_тест1	1218.00	394.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
428	122	ГДМ_!!!	1269.00	964.00	\N	\N	12	1	0	3.0	3.0	\N	0	\N	\N	\N	\N	\N
429	122	ДМ!!!!!!	230.00	125.00	\N	\N	6	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-03-01	\N
412	122	РП_тест3	1245.00	2296.00	\N	\N	1	1	1	0.0	0.0	\N	0	\N	\N	\N	2017-02-01	\N
424	122	11111111111	616.00	210.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	\N	\N
430	122	РП!!!!!	13.00	107.00	\N	\N	1	1	0	0.0	0.0	\N	0	\N	\N	\N	2017-03-01	\N
\.


--
-- Name: tsensors_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsensors_id_seq', 430, true);


--
-- Data for Name: tsexes; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsexes (id, code) FROM stdin;
1	M
2	F
\.


--
-- Name: tsexes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsexes_id_seq', 2, true);


--
-- Data for Name: tsexes_l10n; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsexes_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Мужской
2	2	1	Женский
\.


--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsexes_l10n_id_seq', 2, true);


--
-- Data for Name: tsocial_network_account_friends; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsocial_network_account_friends (id, fid, email, name, date_birth, avatar_id, sex_id, account_id) FROM stdin;
\.


--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsocial_network_account_friends_id_seq', 1, false);


--
-- Data for Name: tsocial_network_accounts; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsocial_network_accounts (id, user_id, network_id, fid, access_token, fid2, export_token, export_info, export_expires, do_publish, date_cr, date_mo) FROM stdin;
\.


--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsocial_network_accounts_id_seq', 1, false);


--
-- Data for Name: tsocial_networks; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tsocial_networks (id, code, name, can_post, can_auth, can_friends) FROM stdin;
1	fb	facebook	1	1	1
2	vk	vkontakte	1	1	1
3	ok	odnoklasniki	1	1	1
4	gmail	gmail	0	0	1
5	gplus	gplus	0	1	1
\.


--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tsocial_networks_id_seq', 5, true);


--
-- Data for Name: tspreadsheets; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tspreadsheets (id, name, file_id, date_cr, generator, fid) FROM stdin;
\.


--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tspreadsheets_id_seq', 1, false);


--
-- Data for Name: ttemplate_place_types; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY ttemplate_place_types (id, code, name) FROM stdin;
1	text	Простой текст
2	html	Текст с форматированием
3	image	Изображение
4	href	Ссылка (для удобства)
\.


--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('ttemplate_place_types_id_seq', 4, true);


--
-- Data for Name: ttemplate_places; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY ttemplate_places (id, template_id, place_type_id, ordering, code, name, admin_height, templatewide, preprocess, href) FROM stdin;
1	4	1	1	section	Режим	1	0	0	\N
\.


--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_id_seq', 1, true);


--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_ordering_seq', 1, true);


--
-- Data for Name: ttemplate_places_templatewide; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY ttemplate_places_templatewide (id, place_id, l10n_id, medium_id, body) FROM stdin;
\.


--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_templatewide_id_seq', 1, false);


--
-- Data for Name: ttemplates; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY ttemplates (id, code, name) FROM stdin;
4	\N	Base
\.


--
-- Name: ttemplates_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('ttemplates_id_seq', 4, true);


--
-- Data for Name: tuser_agents; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tuser_agents (id, name, is_robot, device_type) FROM stdin;
\.


--
-- Name: tuser_agents_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tuser_agents_id_seq', 1, false);


--
-- Data for Name: tuser_sessions; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tuser_sessions (id, user_id, sid, date_exp) FROM stdin;
977	3	rc2i2uxcfhvnostftwoho9eezooemvjw3e3mlvyc1fz6841d	2017-11-30 21:43:46.302821
\.


--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tuser_sessions_id_seq', 977, true);


--
-- Name: tuser_urls_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tuser_urls_id_seq', 1, false);


--
-- Data for Name: tusers; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tusers (id, login, first_name, second_name, last_name, calc_full_name, password, enabled, email, calc_no_roles, sex_id, date_cr, date_birth, im_icq, im_jabber, im_msn, im_skype, phone, date_last_page, avatar_id, about, regsid, prefer_l10n_id, im_telegram) FROM stdin;
13	sgiz	Александр	Евгеньевич	Скапинцев	Александр Скапинцев	qwerty123	1	skapintsev@sgiz.ru	0	1	2017-01-10 11:55:19.188424	\N	\N	\N	\N	\N	\N	2017-04-11 13:27:08.705243	\N	\N	\N	\N	\N
3	gonchdog	Георгий	\N	Духовенский	Василий Духовенский	$2a$06$OaYXR2kBvRY7WkODvwoRYu4KVHAoeTRKPLdsXvucxQ1hT5Ps6MwIa	1	\N	0	\N	2015-08-20 09:00:51.760216	\N	\N	\N	\N	\N	\N	2017-11-30 14:37:44.687546	\N	\N	\N	\N	\N
1	vahvarh	Владимир	\N	Оленин	Владимир Оленин	$2a$06$Z4zI/UUejzuqwHPnUWVZVevVbMXWuVlmR/NcD2Vk./.tiDfgoHnwm	1	\N	0	\N	2015-08-20 09:00:43.228902	\N	\N	\N	\N	\N	\N	2017-07-21 16:56:10.294845	\N	\N	\N	\N	\N
14	test	Пользователь	\N	Тестовый	Пользователь Тестовый	test	1	\N	0	\N	2017-02-15 19:45:00.359695	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
15	aveursus	Александр Скапинцев	\N	\N	Александр Скапинцев	qwerty123	1	\N	0	\N	2017-03-21 13:47:47.330637	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: tusers_enrolled; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tusers_enrolled (id, user_id, role_id) FROM stdin;
1	1	1
2	1	2
3	1	3
4	1	4
5	1	5
6	1	6
7	1	7
8	1	8
9	1	9
161	14	12
162	14	10
163	14	11
164	14	13
165	14	1
166	14	2
167	14	3
168	14	4
18	3	1
19	3	2
20	3	3
21	3	4
22	3	5
23	3	6
24	3	7
25	3	9
169	14	5
170	14	6
171	14	7
172	15	10
173	15	11
174	15	12
175	15	13
67	3	8
73	1	10
75	3	10
81	1	11
148	13	1
89	1	12
149	13	2
97	1	13
150	13	3
135	1	14
137	3	14
145	3	11
146	3	12
147	3	13
151	13	4
152	13	5
153	13	6
154	13	7
155	13	9
156	13	10
157	13	11
158	13	12
159	13	13
160	13	14
\.


--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tusers_enrolled_id_seq', 175, true);


--
-- Name: tusers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tusers_id_seq', 15, true);


--
-- Data for Name: tvisits; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tvisits (id, user_id, anon_id, date_cr, baseurl, params, user_agent_id, ip) FROM stdin;
\.


--
-- Data for Name: tworksheets; Type: TABLE DATA; Schema: public; Owner: sgsystems_erp_gtm
--

COPY tworksheets (id, spreadsheet_id, name, ordering) FROM stdin;
\.


--
-- Name: tworksheets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tworksheets_id_seq', 1, false);


--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: sgsystems_erp_gtm
--

SELECT pg_catalog.setval('tworksheets_ordering_seq', 1, false);


--
-- Name: tadmin_start_widgets_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets
    ADD CONSTRAINT tadmin_start_widgets_ordering_key UNIQUE (ordering);


--
-- Name: tadmin_start_widgets_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets
    ADD CONSTRAINT tadmin_start_widgets_pkey PRIMARY KEY (id);


--
-- Name: tallowed_model_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_pkey PRIMARY KEY (id);


--
-- Name: tallowed_value_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_pkey PRIMARY KEY (id);


--
-- Name: tanon_cookies_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_pkey PRIMARY KEY (id);


--
-- Name: tanon_cookies_sid_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_sid_key UNIQUE (sid);


--
-- Name: tarticle_categories_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_code_key UNIQUE (code);


--
-- Name: tarticle_categories_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_pkey PRIMARY KEY (id);


--
-- Name: tarticle_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_pkey PRIMARY KEY (id);


--
-- Name: tarticles_calc_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_calc_code_key UNIQUE (calc_code);


--
-- Name: tarticles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_pkey PRIMARY KEY (id);


--
-- Name: tarticles_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_pkey PRIMARY KEY (id);


--
-- Name: tbase_padding_principles_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tbase_padding_principles
    ADD CONSTRAINT tbase_padding_principles_pkey PRIMARY KEY (id);


--
-- Name: tbraids_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tbraids
    ADD CONSTRAINT tbraids_pkey PRIMARY KEY (id);


--
-- Name: tcart_items_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_pkey PRIMARY KEY (id);


--
-- Name: tcart_payment_methods_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods
    ADD CONSTRAINT tcart_payment_methods_code_key UNIQUE (code);


--
-- Name: tcart_payment_methods_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcart_payment_methods_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods
    ADD CONSTRAINT tcart_payment_methods_pkey PRIMARY KEY (id);


--
-- Name: tcart_states_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states
    ADD CONSTRAINT tcart_states_code_key UNIQUE (code);


--
-- Name: tcart_states_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcart_states_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states
    ADD CONSTRAINT tcart_states_pkey PRIMARY KEY (id);


--
-- Name: tcarts_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_pkey PRIMARY KEY (id);


--
-- Name: tcarts_sid_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_sid_key UNIQUE (sid);


--
-- Name: tcells_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcells
    ADD CONSTRAINT tcells_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_groups_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_code_key UNIQUE (code);


--
-- Name: tcontent_boxes_groups_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_name_key UNIQUE (name);


--
-- Name: tcontent_boxes_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_ordering_key UNIQUE (ordering);


--
-- Name: tcontent_boxes_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_pkey PRIMARY KEY (id);


--
-- Name: tcustom_nav_items_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcustom_nav_items_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_ordering_key UNIQUE (ordering);


--
-- Name: tcustom_nav_items_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_pkey PRIMARY KEY (id);


--
-- Name: tcustom_navs_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_code_key UNIQUE (code);


--
-- Name: tcustom_navs_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_name_key UNIQUE (name);


--
-- Name: tcustom_navs_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_pkey PRIMARY KEY (id);


--
-- Name: tdebug_requests_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_pkey PRIMARY KEY (id);


--
-- Name: tedit_histories_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_pkey PRIMARY KEY (id);


--
-- Name: texplications_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY texplications
    ADD CONSTRAINT texplications_pkey PRIMARY KEY (id);


--
-- Name: tfacilities_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_ordering_key UNIQUE (ordering);


--
-- Name: tfacilities_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_pkey PRIMARY KEY (id);


--
-- Name: tfacility_comment_images_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_pkey PRIMARY KEY (id);


--
-- Name: tfacility_comments_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_pkey PRIMARY KEY (id);


--
-- Name: tfacility_photos_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_pkey PRIMARY KEY (id);


--
-- Name: tfacility_states_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_states
    ADD CONSTRAINT tfacility_states_ordering_key UNIQUE (ordering);


--
-- Name: tfacility_states_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_states
    ADD CONSTRAINT tfacility_states_pkey PRIMARY KEY (id);


--
-- Name: tfacility_stats_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_stats
    ADD CONSTRAINT tfacility_stats_pkey PRIMARY KEY (id);


--
-- Name: tfacility_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_types
    ADD CONSTRAINT tfacility_types_pkey PRIMARY KEY (id);


--
-- Name: tfile_folders_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_code_key UNIQUE (code);


--
-- Name: tfile_folders_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_pkey PRIMARY KEY (id);


--
-- Name: tfile_folders_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_ordering_key UNIQUE (ordering);


--
-- Name: tfile_folders_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_pkey PRIMARY KEY (id);


--
-- Name: tfile_types_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_types
    ADD CONSTRAINT tfile_types_code_key UNIQUE (code);


--
-- Name: tfile_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_types
    ADD CONSTRAINT tfile_types_pkey PRIMARY KEY (id);


--
-- Name: tfiles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_pkey PRIMARY KEY (id);


--
-- Name: tfiles_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_ordering_key UNIQUE (ordering);


--
-- Name: tfiles_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_pkey PRIMARY KEY (id);


--
-- Name: tfmeasurement_periods_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_pkey PRIMARY KEY (id);


--
-- Name: tforms_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_code_key UNIQUE (code);


--
-- Name: tforms_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_pkey PRIMARY KEY (id);


--
-- Name: tguestbook_messages_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_pkey PRIMARY KEY (id);


--
-- Name: tguestbooks_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_code_key UNIQUE (code);


--
-- Name: tguestbooks_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_name_key UNIQUE (name);


--
-- Name: tguestbooks_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_pkey PRIMARY KEY (id);


--
-- Name: tkvcache_key_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tkvcache
    ADD CONSTRAINT tkvcache_key_key UNIQUE (key);


--
-- Name: tkvcache_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tkvcache
    ADD CONSTRAINT tkvcache_pkey PRIMARY KEY (id);


--
-- Name: tl10n_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tl10n
    ADD CONSTRAINT tl10n_code_key UNIQUE (code);


--
-- Name: tl10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tl10n
    ADD CONSTRAINT tl10n_pkey PRIMARY KEY (id);


--
-- Name: tlogin_attempts_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tlogin_attempts
    ADD CONSTRAINT tlogin_attempts_pkey PRIMARY KEY (id);


--
-- Name: tmail_templates_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates
    ADD CONSTRAINT tmail_templates_code_key UNIQUE (code);


--
-- Name: tmail_templates_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmail_templates_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates
    ADD CONSTRAINT tmail_templates_pkey PRIMARY KEY (id);


--
-- Name: tmarket_categories_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_code_key UNIQUE (code);


--
-- Name: tmarket_categories_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_categories_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_datatypes_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_code_key UNIQUE (code);


--
-- Name: tmarket_field_datatypes_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_name_key UNIQUE (name);


--
-- Name: tmarket_field_datatypes_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_enums_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums
    ADD CONSTRAINT tmarket_field_enums_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_enumsl_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_groups_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_groups_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_field_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_pkey PRIMARY KEY (id);


--
-- Name: tmarket_fields_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_fields_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_enums_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_enumsl_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_f_item_id_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_f_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_i_item_id_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_i_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_il_item_id_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_il_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_s_item_id_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_s_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_sl_item_id_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_sl_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_groups_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_groups_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups
    ADD CONSTRAINT tmarket_item_groups_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_item_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups
    ADD CONSTRAINT tmarket_item_groups_pkey PRIMARY KEY (id);


--
-- Name: tmarket_items_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_code_key UNIQUE (code);


--
-- Name: tmarket_items_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_items_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_items_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_pkey PRIMARY KEY (id);


--
-- Name: tmarket_manufacturers_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_code_key UNIQUE (code);


--
-- Name: tmarket_manufacturers_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_manufacturers_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_manufacturers_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_pkey PRIMARY KEY (id);


--
-- Name: tmarket_search_levels_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels
    ADD CONSTRAINT tmarket_search_levels_code_key UNIQUE (code);


--
-- Name: tmarket_search_levels_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_search_levels_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels
    ADD CONSTRAINT tmarket_search_levels_pkey PRIMARY KEY (id);


--
-- Name: tmarket_view_levels_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels
    ADD CONSTRAINT tmarket_view_levels_code_key UNIQUE (code);


--
-- Name: tmarket_view_levels_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_view_levels_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels
    ADD CONSTRAINT tmarket_view_levels_pkey PRIMARY KEY (id);


--
-- Name: tmeasurement_modes_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_modes
    ADD CONSTRAINT tmeasurement_modes_pkey PRIMARY KEY (id);


--
-- Name: tmeasurer_value_types_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_code_key UNIQUE (code);


--
-- Name: tmeasurer_value_types_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_name_key UNIQUE (name);


--
-- Name: tmeasurer_value_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_pkey PRIMARY KEY (id);


--
-- Name: tmediums_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_code_key UNIQUE (code);


--
-- Name: tmediums_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_name_key UNIQUE (name);


--
-- Name: tmediums_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_ordering_key UNIQUE (ordering);


--
-- Name: tmediums_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_pkey PRIMARY KEY (id);


--
-- Name: tnormatives_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormative_types
    ADD CONSTRAINT tnormatives_pkey PRIMARY KEY (id);


--
-- Name: tnormatives_pkey1; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_pkey1 PRIMARY KEY (id);


--
-- Name: tpage_blocks_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_pkey PRIMARY KEY (id);


--
-- Name: tpages_alias_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_alias_key UNIQUE (alias);


--
-- Name: tpages_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_pkey PRIMARY KEY (id);


--
-- Name: tpages_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_ordering_key UNIQUE (ordering);


--
-- Name: tpages_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_pkey PRIMARY KEY (id);


--
-- Name: tpayment_service_errors_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors
    ADD CONSTRAINT tpayment_service_errors_pkey PRIMARY KEY (id);


--
-- Name: tpayment_service_invoices_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_pkey PRIMARY KEY (id);


--
-- Name: tplan_formats_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_pkey PRIMARY KEY (id);


--
-- Name: tplans_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_pkey PRIMARY KEY (id);


--
-- Name: treferences_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_ordering_key UNIQUE (ordering);


--
-- Name: treferences_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_pkey PRIMARY KEY (id);


--
-- Name: trewrites_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_pkey PRIMARY KEY (id);


--
-- Name: trewrites_regexp_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_regexp_key UNIQUE (regexp);


--
-- Name: troles_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles
    ADD CONSTRAINT troles_code_key UNIQUE (code);


--
-- Name: troles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_pkey PRIMARY KEY (id);


--
-- Name: troles_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles
    ADD CONSTRAINT troles_pkey PRIMARY KEY (id);


--
-- Name: tsensor_comment_images_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_pkey PRIMARY KEY (id);


--
-- Name: tsensor_comments_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_pkey PRIMARY KEY (id);


--
-- Name: tsensor_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_groups
    ADD CONSTRAINT tsensor_groups_pkey PRIMARY KEY (id);


--
-- Name: tsensor_groups_pkey1; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_pkey1 PRIMARY KEY (id);


--
-- Name: tsensor_model_measurers_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_ordering_key UNIQUE (ordering);


--
-- Name: tsensor_model_measurers_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_pkey PRIMARY KEY (id);


--
-- Name: tsensor_model_normatives_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_pkey PRIMARY KEY (id);


--
-- Name: tsensor_model_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_types
    ADD CONSTRAINT tsensor_model_types_pkey PRIMARY KEY (id);


--
-- Name: tsensor_models_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_code_key UNIQUE (code);


--
-- Name: tsensor_models_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_name_key UNIQUE (name);


--
-- Name: tsensor_models_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_pkey PRIMARY KEY (id);


--
-- Name: tsensor_photos_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_pkey PRIMARY KEY (id);


--
-- Name: tsensor_states_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_states
    ADD CONSTRAINT tsensor_states_pkey PRIMARY KEY (id);


--
-- Name: tsensor_values_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_pkey PRIMARY KEY (id);


--
-- Name: tsensors_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_pkey PRIMARY KEY (id);


--
-- Name: tsexes_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes
    ADD CONSTRAINT tsexes_code_key UNIQUE (code);


--
-- Name: tsexes_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_pkey PRIMARY KEY (id);


--
-- Name: tsexes_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes
    ADD CONSTRAINT tsexes_pkey PRIMARY KEY (id);


--
-- Name: tsocial_network_account_friends_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_pkey PRIMARY KEY (id);


--
-- Name: tsocial_network_accounts_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_pkey PRIMARY KEY (id);


--
-- Name: tsocial_networks_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_networks
    ADD CONSTRAINT tsocial_networks_code_key UNIQUE (code);


--
-- Name: tsocial_networks_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_networks
    ADD CONSTRAINT tsocial_networks_pkey PRIMARY KEY (id);


--
-- Name: tspreadsheets_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tspreadsheets
    ADD CONSTRAINT tspreadsheets_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_place_types_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_code_key UNIQUE (code);


--
-- Name: ttemplate_place_types_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_name_key UNIQUE (name);


--
-- Name: ttemplate_place_types_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_places_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_ordering_key UNIQUE (ordering);


--
-- Name: ttemplate_places_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_places_templatewide_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_pkey PRIMARY KEY (id);


--
-- Name: ttemplates_code_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_code_key UNIQUE (code);


--
-- Name: ttemplates_name_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_name_key UNIQUE (name);


--
-- Name: ttemplates_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_pkey PRIMARY KEY (id);


--
-- Name: tuser_agents_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_agents
    ADD CONSTRAINT tuser_agents_pkey PRIMARY KEY (id);


--
-- Name: tuser_sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_pkey PRIMARY KEY (id);


--
-- Name: tuser_sessions_sid_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_sid_key UNIQUE (sid);


--
-- Name: tuser_urls_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_pkey PRIMARY KEY (id);


--
-- Name: tusers_enrolled_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_pkey PRIMARY KEY (id);


--
-- Name: tusers_login_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_login_key UNIQUE (login);


--
-- Name: tusers_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_pkey PRIMARY KEY (id);


--
-- Name: tusers_regsid_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_regsid_key UNIQUE (regsid);


--
-- Name: tworksheets_ordering_key; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_ordering_key UNIQUE (ordering);


--
-- Name: tworksheets_pkey; Type: CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_pkey PRIMARY KEY (id);


--
-- Name: iarticle_categories_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX iarticle_categories_l10n ON tarticle_categories_l10n USING btree (fid_id, l10n_id);


--
-- Name: iarticles_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX iarticles_l10n ON tarticles_l10n USING btree (fid_id, l10n_id);


--
-- Name: icart_items1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX icart_items1 ON tcart_items USING btree (cart_id, market_item_id);


--
-- Name: icart_items2; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX icart_items2 ON tcart_items USING btree (cart_id, other_ftype, other_fid);


--
-- Name: icontent_boxes_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX icontent_boxes_l10n ON tcontent_boxes_l10n USING btree (fid_id, l10n_id);


--
-- Name: icustom_nav_items_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX icustom_nav_items_l10n ON tcustom_nav_items_l10n USING btree (fid_id, l10n_id);


--
-- Name: iedit_histories_indx1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE INDEX iedit_histories_indx1 ON tedit_histories USING btree (model_name, facility_id);


--
-- Name: ifile_folders_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX ifile_folders_l10n ON tfile_folders_l10n USING btree (fid_id, l10n_id);


--
-- Name: ifiles_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX ifiles_l10n ON tfiles_l10n USING btree (fid_id, l10n_id);


--
-- Name: imail_templates_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imail_templates_l10n ON tmail_templates_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_categories_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_categories_l10n ON tmarket_categories_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_field_enums; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_field_enums ON tmarket_field_enums USING btree (field_id, value);


--
-- Name: imarket_field_enumsl; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_field_enumsl ON tmarket_field_enumsl USING btree (field_id, value);


--
-- Name: imarket_field_groups_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_field_groups_l10n ON tmarket_field_groups_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_fields_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_fields_l10n ON tmarket_fields_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_item_groups_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_item_groups_l10n ON tmarket_item_groups_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_items_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_items_l10n ON tmarket_items_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_manufacturers_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_manufacturers_l10n ON tmarket_manufacturers_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_search_levels_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_search_levels_l10n ON tmarket_search_levels_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_view_levels_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX imarket_view_levels_l10n ON tmarket_view_levels_l10n USING btree (fid_id, l10n_id);


--
-- Name: ipage_blocks; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX ipage_blocks ON tpage_blocks USING btree (page_id, l10n_id, medium_id, place_id);


--
-- Name: ipages1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE INDEX ipages1 ON tpages USING btree (parent_id);


--
-- Name: ipages2; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX ipages2 ON tpages USING btree (parent_id, ordering);


--
-- Name: ipages_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX ipages_l10n ON tpages_l10n USING btree (fid_id, l10n_id);


--
-- Name: iroles_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX iroles_l10n ON troles_l10n USING btree (fid_id, l10n_id);


--
-- Name: isexes_l10n; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX isexes_l10n ON tsexes_l10n USING btree (fid_id, l10n_id);


--
-- Name: isocial_network_accounts1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX isocial_network_accounts1 ON tsocial_network_accounts USING btree (network_id, fid);


--
-- Name: itemplate_places; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX itemplate_places ON ttemplate_places USING btree (template_id, code);


--
-- Name: itemplate_places_templatewide; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX itemplate_places_templatewide ON ttemplate_places_templatewide USING btree (place_id, medium_id, l10n_id);


--
-- Name: iuser_sessions1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE INDEX iuser_sessions1 ON tuser_sessions USING btree (date_exp);


--
-- Name: iusers_enrolled; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX iusers_enrolled ON tusers_enrolled USING btree (user_id, role_id);


--
-- Name: iusers_enrolled1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE INDEX iusers_enrolled1 ON tusers_enrolled USING btree (user_id);


--
-- Name: tarticle_categories_groupcode_key; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE INDEX tarticle_categories_groupcode_key ON tarticle_categories USING btree (groupcode);


--
-- Name: tbraids_index1; Type: INDEX; Schema: public; Owner: sgsystems_erp_gtm
--

CREATE UNIQUE INDEX tbraids_index1 ON tbraids USING btree (deep, sensor_id);


--
-- Name: tallowed_model_types_braid_measurer_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_braid_measurer_id_fkey FOREIGN KEY (braid_measurer_id) REFERENCES tmeasurer_value_types(id);


--
-- Name: tallowed_model_types_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tallowed_model_types_sensor_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_sensor_model_type_id_fkey FOREIGN KEY (sensor_model_type_id) REFERENCES tsensor_model_types(id);


--
-- Name: tallowed_value_types_allowed_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_allowed_model_type_id_fkey FOREIGN KEY (allowed_model_type_id) REFERENCES tallowed_model_types(id);


--
-- Name: tallowed_value_types_measure_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_measure_id_fkey FOREIGN KEY (measure_id) REFERENCES tmeasurer_value_types(id);


--
-- Name: tanon_cookies_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tarticle_categories_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tarticle_categories_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tarticle_categories_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tarticle_categories(id);


--
-- Name: tarticle_categories_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tarticles_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_category_id_fkey FOREIGN KEY (category_id) REFERENCES tarticle_categories(id);


--
-- Name: tarticles_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_folder_id_fkey FOREIGN KEY (folder_id) REFERENCES tfile_folders(id);


--
-- Name: tarticles_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tarticles_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tarticles_image3_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image3_id_fkey FOREIGN KEY (image3_id) REFERENCES tfiles(id);


--
-- Name: tarticles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tarticles(id);


--
-- Name: tarticles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tarticles_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tbraids_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tbraids
    ADD CONSTRAINT tbraids_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tcart_items_cart_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_cart_id_fkey FOREIGN KEY (cart_id) REFERENCES tcarts(id);


--
-- Name: tcart_items_market_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_market_item_id_fkey FOREIGN KEY (market_item_id) REFERENCES tmarket_items(id);


--
-- Name: tcart_payment_methods_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcart_payment_methods(id);


--
-- Name: tcart_payment_methods_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcart_states_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcart_states(id);


--
-- Name: tcart_states_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcarts_manager_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_manager_id_fkey FOREIGN KEY (manager_id) REFERENCES tusers(id);


--
-- Name: tcarts_payment_method_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_payment_method_id_fkey FOREIGN KEY (payment_method_id) REFERENCES tcart_payment_methods(id);


--
-- Name: tcarts_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_state_id_fkey FOREIGN KEY (state_id) REFERENCES tcart_states(id);


--
-- Name: tcarts_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tcells_worksheet_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcells
    ADD CONSTRAINT tcells_worksheet_id_fkey FOREIGN KEY (worksheet_id) REFERENCES tworksheets(id);


--
-- Name: tcontent_boxes_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_group_id_fkey FOREIGN KEY (group_id) REFERENCES tcontent_boxes_groups(id);


--
-- Name: tcontent_boxes_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tcontent_boxes_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tcontent_boxes_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcontent_boxes(id);


--
-- Name: tcontent_boxes_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcontent_boxes_l10n_override_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_override_image_id_fkey FOREIGN KEY (override_image_id) REFERENCES tfiles(id);


--
-- Name: tcustom_nav_items_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tcustom_nav_items_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcustom_nav_items(id);


--
-- Name: tcustom_nav_items_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcustom_nav_items_nav_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_nav_id_fkey FOREIGN KEY (nav_id) REFERENCES tcustom_navs(id);


--
-- Name: tcustom_nav_items_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: tcustom_nav_items_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tcustom_nav_items(id);


--
-- Name: tdebug_requests_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tdebug_requests_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tedit_histories_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tedit_histories_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: texplications_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY texplications
    ADD CONSTRAINT texplications_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacilities_base_principle_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_base_principle_id_fkey FOREIGN KEY (base_principle_id) REFERENCES tbase_padding_principles(id);


--
-- Name: tfacilities_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacilities_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_plan_id_fkey FOREIGN KEY (plan_id) REFERENCES tplans(id);


--
-- Name: tfacilities_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_state_id_fkey FOREIGN KEY (state_id) REFERENCES tfacility_states(id);


--
-- Name: tfacility_comment_images_comment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_comment_id_fkey FOREIGN KEY (comment_id) REFERENCES tfacility_comments(id);


--
-- Name: tfacility_comment_images_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacility_comments_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacility_comments_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfacility_photos_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacility_photos_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacility_photos_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfacility_stats_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_stats
    ADD CONSTRAINT tfacility_stats_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfile_folders_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tfile_folders(id);


--
-- Name: tfile_folders_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tfile_folders_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tfile_folders(id);


--
-- Name: tfile_folders_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfiles_file_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_file_folder_id_fkey FOREIGN KEY (file_folder_id) REFERENCES tfile_folders(id);


--
-- Name: tfiles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tfiles(id);


--
-- Name: tfiles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tfiles_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_type_id_fkey FOREIGN KEY (type_id) REFERENCES tfile_types(id);


--
-- Name: tfiles_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfmeasurement_periods_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfmeasurement_periods_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tforms_mail_template1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_mail_template1_id_fkey FOREIGN KEY (mail_template1_id) REFERENCES tmail_templates(id);


--
-- Name: tforms_mail_template2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_mail_template2_id_fkey FOREIGN KEY (mail_template2_id) REFERENCES tmail_templates(id);


--
-- Name: tguestbook_messages_guestbook_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_guestbook_id_fkey FOREIGN KEY (guestbook_id) REFERENCES tguestbooks(id);


--
-- Name: tguestbook_messages_user_a_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_user_a_id_fkey FOREIGN KEY (user_a_id) REFERENCES tusers(id);


--
-- Name: tguestbook_messages_user_q_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_user_q_avatar_id_fkey FOREIGN KEY (user_q_avatar_id) REFERENCES tfiles(id);


--
-- Name: tguestbooks_mail_template1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_mail_template1_id_fkey FOREIGN KEY (mail_template1_id) REFERENCES tmail_templates(id);


--
-- Name: tguestbooks_mail_template2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_mail_template2_id_fkey FOREIGN KEY (mail_template2_id) REFERENCES tmail_templates(id);


--
-- Name: tlogin_attempts_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tlogin_attempts
    ADD CONSTRAINT tlogin_attempts_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tmail_templates_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmail_templates(id);


--
-- Name: tmail_templates_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_categories_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_categories_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_categories_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_categories_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_categories_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_field_enums_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums
    ADD CONSTRAINT tmarket_field_enums_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_field_enumsl_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_field_enumsl_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_field_groups_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_category_id_fkey FOREIGN KEY (category_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_field_groups_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_field_groups(id);


--
-- Name: tmarket_field_groups_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_fields_datatype_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_datatype_id_fkey FOREIGN KEY (datatype_id) REFERENCES tmarket_field_datatypes(id);


--
-- Name: tmarket_fields_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_group_id_fkey FOREIGN KEY (group_id) REFERENCES tmarket_field_groups(id);


--
-- Name: tmarket_fields_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_fields_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_fields_search_level_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_search_level_id_fkey FOREIGN KEY (search_level_id) REFERENCES tmarket_search_levels(id);


--
-- Name: tmarket_fields_view_level_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_view_level_id_fkey FOREIGN KEY (view_level_id) REFERENCES tmarket_view_levels(id);


--
-- Name: tmarket_item_fields_enums_enum_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_enum_id_fkey FOREIGN KEY (enum_id) REFERENCES tmarket_field_enums(id);


--
-- Name: tmarket_item_fields_enums_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_item_fields_enums_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_enumsl_enum_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_enum_id_fkey FOREIGN KEY (enum_id) REFERENCES tmarket_field_enumsl(id);


--
-- Name: tmarket_item_fields_enumsl_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_item_fields_enumsl_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_f_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_i_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_il_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_il_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_s_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_sl_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_sl_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_groups_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_item_groups(id);


--
-- Name: tmarket_item_groups_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_items_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_category_id_fkey FOREIGN KEY (category_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_items_file_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_file_folder_id_fkey FOREIGN KEY (file_folder_id) REFERENCES tfile_folders(id);


--
-- Name: tmarket_items_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_group_id_fkey FOREIGN KEY (group_id) REFERENCES tmarket_item_groups(id);


--
-- Name: tmarket_items_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_items_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_items_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_items_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_items_manufacturer_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_manufacturer_id_fkey FOREIGN KEY (manufacturer_id) REFERENCES tmarket_manufacturers(id);


--
-- Name: tmarket_manufacturers_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_manufacturers_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_manufacturers_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_manufacturers(id);


--
-- Name: tmarket_manufacturers_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_search_levels_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_search_levels(id);


--
-- Name: tmarket_search_levels_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_view_levels_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_view_levels(id);


--
-- Name: tmarket_view_levels_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tnormatives_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tnormatives_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_type_id_fkey FOREIGN KEY (type_id) REFERENCES tnormative_types(id);


--
-- Name: tpage_blocks_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tpage_blocks_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: tpage_blocks_place_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_place_id_fkey FOREIGN KEY (place_id) REFERENCES ttemplate_places(id);


--
-- Name: tpages_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tpages(id);


--
-- Name: tpages_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tpages_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tpages(id);


--
-- Name: tpages_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_role_id_fkey FOREIGN KEY (role_id) REFERENCES troles(id);


--
-- Name: tpages_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_template_id_fkey FOREIGN KEY (template_id) REFERENCES ttemplates(id);


--
-- Name: tpayment_service_errors_pay_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors
    ADD CONSTRAINT tpayment_service_errors_pay_user_agent_id_fkey FOREIGN KEY (pay_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_ask_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_ask_user_agent_id_fkey FOREIGN KEY (ask_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_pay_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_pay_user_agent_id_fkey FOREIGN KEY (pay_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tplan_formats_file_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_file_id_fkey FOREIGN KEY (dwg_id) REFERENCES tfiles(id);


--
-- Name: tplan_formats_stamp_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_stamp_id_fkey FOREIGN KEY (pdf_id) REFERENCES tfiles(id);


--
-- Name: tplans_calc_pdf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_calc_pdf_id_fkey FOREIGN KEY (calc_pdf_id) REFERENCES tfiles(id);


--
-- Name: tplans_dwg_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_dwg_id_fkey FOREIGN KEY (dwg_id) REFERENCES tfiles(id);


--
-- Name: tplans_format_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_format_id_fkey FOREIGN KEY (format_id) REFERENCES tplan_formats(id);


--
-- Name: tplans_jpg_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_jpg_id_fkey FOREIGN KEY (jpg_id) REFERENCES tfiles(id);


--
-- Name: tplans_pdf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_pdf_id_fkey FOREIGN KEY (pdf_id) REFERENCES tfiles(id);


--
-- Name: treferences_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES treferences(id);


--
-- Name: trewrites_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: troles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES troles(id);


--
-- Name: troles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tsensor_comment_images_comment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_comment_id_fkey FOREIGN KEY (comment_id) REFERENCES tsensor_comments(id);


--
-- Name: tsensor_comment_images_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensor_comments_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_comments_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tsensor_groups_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tfacility_groups
    ADD CONSTRAINT tsensor_groups_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tsensor_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES tfacility_groups(id);


--
-- Name: tsensor_groups_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_model_measurers_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tsensor_model_measurers_value_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_value_type_id_fkey FOREIGN KEY (value_type_id) REFERENCES tmeasurer_value_types(id);


--
-- Name: tsensor_model_normatives_normative_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_normative_id_fkey FOREIGN KEY (normative_id) REFERENCES tnormative_types(id);


--
-- Name: tsensor_model_normatives_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tsensor_photos_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensor_photos_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_photos_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tsensor_values_allowed_value_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_allowed_value_type_id_fkey FOREIGN KEY (allowed_value_type_id) REFERENCES tallowed_value_types(id);


--
-- Name: tsensor_values_braid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_braid_id_fkey FOREIGN KEY (braid_id) REFERENCES tbraids(id);


--
-- Name: tsensor_values_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensors_allowed_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_allowed_model_type_id_fkey FOREIGN KEY (allowed_model_type_id) REFERENCES tallowed_model_types(id);


--
-- Name: tsensors_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tsensors_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensors_measurement_mode_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_measurement_mode_id_fkey FOREIGN KEY (measurement_mode_id) REFERENCES tmeasurement_modes(id);


--
-- Name: tsensors_pr_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_pr_sensor_id_fkey FOREIGN KEY (pr_sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensors_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_state_id_fkey FOREIGN KEY (state_id) REFERENCES tsensor_states(id);


--
-- Name: tsexes_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tsexes(id);


--
-- Name: tsexes_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tsocial_network_account_friends_account_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_account_id_fkey FOREIGN KEY (account_id) REFERENCES tsocial_network_accounts(id);


--
-- Name: tsocial_network_account_friends_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_avatar_id_fkey FOREIGN KEY (avatar_id) REFERENCES tfiles(id);


--
-- Name: tsocial_network_account_friends_sex_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_sex_id_fkey FOREIGN KEY (sex_id) REFERENCES tsexes(id);


--
-- Name: tsocial_network_accounts_network_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_network_id_fkey FOREIGN KEY (network_id) REFERENCES tsocial_networks(id);


--
-- Name: tsocial_network_accounts_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: ttemplate_places_place_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_place_type_id_fkey FOREIGN KEY (place_type_id) REFERENCES ttemplate_place_types(id);


--
-- Name: ttemplate_places_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_template_id_fkey FOREIGN KEY (template_id) REFERENCES ttemplates(id);


--
-- Name: ttemplate_places_templatewide_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: ttemplate_places_templatewide_medium_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_medium_id_fkey FOREIGN KEY (medium_id) REFERENCES tmediums(id);


--
-- Name: ttemplate_places_templatewide_place_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_place_id_fkey FOREIGN KEY (place_id) REFERENCES ttemplate_places(id);


--
-- Name: tuser_sessions_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tuser_urls_anon_cookie_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_anon_cookie_id_fkey FOREIGN KEY (anon_id) REFERENCES tanon_cookies(id);


--
-- Name: tuser_urls_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tuser_urls_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tusers_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_avatar_id_fkey FOREIGN KEY (avatar_id) REFERENCES tfiles(id);


--
-- Name: tusers_enrolled_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_role_id_fkey FOREIGN KEY (role_id) REFERENCES troles(id);


--
-- Name: tusers_enrolled_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tusers_prefer_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_prefer_l10n_id_fkey FOREIGN KEY (prefer_l10n_id) REFERENCES tl10n(id);


--
-- Name: tusers_sex_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_sex_id_fkey FOREIGN KEY (sex_id) REFERENCES tsexes(id);


--
-- Name: tworksheets_spreadsheet_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sgsystems_erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_spreadsheet_id_fkey FOREIGN KEY (spreadsheet_id) REFERENCES tspreadsheets(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

