#!/usr/bin/perl -w

use strict;

sub read_file {
	my ($name)=@_;
	open IN,$name or die "Cannot read $name";
	my $r;
	{local $/;$r=<IN>;}
	close IN;
	return $r;
}

sub save_file {
	my ($name,$data)=@_;
	open OUT,">$name" or die "Cannot save to $name";
	print OUT $data;
	close OUT;
}

{
	die "Usage: $0 server" unless @ARGV==1;

	my $server=$ARGV[0];
	die "Wrong symbols in server name" unless $server=~/^[a-z0-9\-]+$/;
	die "Already exists" if -f "/etc/apache2/sites-enabled/easymerch-erp2-$server";

	my $db="easymerch_erp2_".$server;
	$db=~s/[^a-z0-9\_]+/_/g;

	print "Создаем конфиг в lattenoir\n";
	my @cfg=split (/\n/,read_file("/home/projects/lattenoir/config/sites-enabled/easymerch-erp2--gen.pl"));
	my $cfg="";
	foreach my $a (@cfg) {
		if ($a=~/capdel/) {
			my $b=$a;
			$b=~s/capdel/$server/g;
			$a.="\n".$b;
		}
		$cfg.="$a\n";
	}
	save_file("/home/projects/lattenoir/config/sites-enabled/easymerch-erp2--gen.pl",$cfg);
	system("/home/projects/lattenoir/config/sites-enabled/easymerch-erp2--gen.pl");

#	print "Создаем конфиг в apache2\n";
#	my $src=read_file("/etc/apache2/sites-enabled/easymerch-erp2-capdel");
#	$src=~s/capdel/$server/g;
#	save_file("/etc/apache2/sites-enabled/easymerch-erp2-$server",$src);

	print "Делаем симлинк\n";
	mkdir("/www/vahvarh/easymerch.ru-erp2-nosvn/html/f-$server");
	symlink("/www/vahvarh/easymerch.ru-erp2-nosvn/html/f-$server","/www/vahvarh/easymerch.ru-erp2/html/f-$server");
#	symlink("/www/vahvarh/easymerch.ru-erp2-nosvn/html/f-$server","/www/vahvarh/easymerch.ru-erp2-newdesign/html/f-$server");

	print "Делаем дамп demo2\n";
	unlink("/tmp/easymerch-tmp.sql");
	system("pg_dump","-h","127.0.0.1","-f","/tmp/easymerch-tmp.sql","-U","easymerch_erp2_demo","easymerch_erp2_demo");

	print "Создаем пустую базу\n";
	open OUT,"|sudo su - postgres -c psql";
	sleep(1);
	print OUT "create user $db password 'tmppasswd';\n";
	print OUT "create database $db owner $db;\n";
	close OUT;

	print "Создаем расширения\n";
	open OUT,"|sudo su - postgres -c \"psql $db\"";
	sleep(1);
	print OUT "create extension pgcrypto;\n";
	print OUT "create extension postgis;\n";
	print OUT "create extension cube;\n";
	print OUT "create extension earthdistance;\n";
	close OUT;

	print "Заполняем на основании demo2\n";
	system("psql","-q","-h","127.0.0.1","-U",$db,$db,"-f","/tmp/easymerch-tmp.sql");

	print "Очищаем\n";
	system("psql","-q","-h","127.0.0.1","-U",$db,$db,"-f","/www/vahvarh/easymerch.ru-erp2/database/cleanup.sql");
	print "Запускам apache2\n";
	system("sudo","/etc/init.d/apache2","reload");
}
