/**
 * Class: LoadData
 */

/**
 * Method: new
 */
function LoadData(config){
	this.init({ title:'Загрузка данных' });
}

LoadData.prototype = new Page();

/**
 * Method: my_name
 */
LoadData.prototype.my_name = function(){
	return 'LoadData';
}

/**
 * Method: after_page_added
 */
LoadData.prototype.after_page_added = function(){
	this.refresh();
}

/**
 * Method: refresh
 */
LoadData.prototype.refresh = function(){
	this.refresh_state();
}


/**
 * Method: refresh_state
 */
LoadData.prototype.refresh_state = function(){
	var data = localStorage.getItem("data");
	if (data) data = JSON.parse(data);
	lnrr.data = data;
	this.blocks.state.html(this.get_view('state'));
	this.to_center();
}

/**
 * Method: load_data
 */
LoadData.prototype.load_data = function(tag){
	
	var t = this;
	
	var params = { need_auth:1 }
	
	this.request('init', params, function(ret){
		t.save_data(ret);
	});
}

/**
 * Method: save_data
 */
LoadData.prototype.save_data = function(incdata){
	var data = this.prepare_data(incdata);
	
	localStorage.setItem("data",JSON.stringify(data));
	localStorage.setItem("dictionaries",JSON.stringify(incdata.dictionaries));
	
	this.show_result();
//	this.save_images(data);
	
}


/**
 * Method: prepare_data
 */
LoadData.prototype.prepare_data = function(incdata){
	
	var data = {
		hash:{sensors:{}},
		facilities_length:			incdata.facilities_length,
		sensors_length: 			incdata.sensors_length,
		sensors_comments_length:	incdata.sensors_comments_length,
		sensors_photos_length:		incdata.sensors_photos_length,
		facilities_comments_length:	incdata.facilities_comments_length,
		facilities_photos_length:	incdata.facilities_photos_length,
	};
	
	// set dictionaries hash
	for (k in incdata.dictionaries) data.hash[k] = incdata.dictionaries[k].reduce(function(h,el){h[el.id] = el; return h; },{});
	
	data.hash.value_types_by_models = {};
	
	for (k in data.hash['AllowedValueType']) {
		var avt = data.hash['AllowedValueType'][k];
		var amt_id = avt.allowed_model_type_id;
		if (!data.hash.value_types_by_models[amt_id]) data.hash.value_types_by_models[amt_id] = [];
		data.hash.value_types_by_models[amt_id].push(avt);
	}
	
	// set facilities and sensors hash
	var arr_to_hash_rec = function(arr,hash){
		if (!arr||!arr.length) return hash;
		arr.reduce(function(h,el){
			h[el.id] = el;
			if (el.sensors) el.sensors.reduce(function(hh,el){
				hh[el.id] = el;
				return hh;
			},data.hash.sensors);
			arr_to_hash_rec(el.facilities,h);
			return h;
		},hash);
		return hash;
	}
	
	data.facilities = incdata.facilities;
	data.hash.facilities = arr_to_hash_rec(data.facilities,{});
		
	return data;
}

/**
 * Method: show_result
 */
LoadData.prototype.show_result = function(){
	
	var data = localStorage.getItem("data");
	lnrr.data = data ? JSON.parse(data) : {};	
	this.blocks.result.html(this.get_view('result'));
	this.to_center();
//	this.refresh();
	
}


/**
 * Method: save_images
 */
LoadData.prototype.save_images = function(data){
	
	var t = this;
	var cached_images = this.LS.get('images') || {};
	
	data.facilities
	.map(function(el){ return { id:el.image_id, url:el.image_url } })
	.filter(function(el){ return el.url && !cached_images[el.id] })
	.forEach(function(el){ t.save_image(el); });
}
